/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;

public class BillGroupRecordHolder {
    Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";
    private String groupRecKey = this.isNewGroupModel != false ? "cal_account_grouprecord" : "cal_groupbillrecord";
    private String tableKey = this.isNewGroupModel != false ? "t_cal_accountgrouprecord" : "t_cal_groupbillrecord";
    private Map<String, DynamicObject> groupRecordCache = new HashMap<String, DynamicObject>(16);
    private Map<Long, Set<String>> groupEntryCache = new HashMap<Long, Set<String>>(16);

    private DynamicObject getRecord(DynamicObject matchSetting, String groupValueStr) {
        Long matchSettingId = matchSetting.getLong("id");
        String cacheKey = matchSettingId + "_" + groupValueStr;
        DynamicObject groupRecord = this.groupRecordCache.get(cacheKey);
        if (groupRecord == null) {
            QFilter filter = new QFilter("groupsetting", "=", (Object)matchSettingId);
            filter.and("groupvalue", "=", (Object)groupValueStr);
            groupRecord = BusinessDataServiceHelper.loadSingle((String)this.groupRecKey, (String)"id", (QFilter[])filter.toArray());
            if (groupRecord == null) {
                groupRecord = BusinessDataServiceHelper.newDynamicObject((String)this.groupRecKey);
                groupRecord.set("id", (Object)DB.genLongId((String)this.tableKey));
                groupRecord.set("groupsetting_id", (Object)matchSettingId);
                groupRecord.set("groupsettingtype", (Object)matchSetting.getDataEntityType().getName());
                groupRecord.set("groupvalue", (Object)groupValueStr);
                groupRecord.set("createtime", (Object)new Date());
                groupRecord.set("costcolumn", (Object)matchSetting.getString("costcolumn"));
                groupRecord.set("costfields", (Object)matchSetting.getString("costfields"));
                groupRecord.set("iscompleted", (Object)true);
            } else {
                groupRecord = BusinessDataServiceHelper.loadSingle((Object)groupRecord.getPkValue(), (String)this.groupRecKey);
                HashSet<String> entryIdSet = new HashSet<String>(16);
                for (DynamicObject recordEntry : groupRecord.getDynamicObjectCollection("entryentity")) {
                    String billeEntryId = recordEntry.getString(this.calEntryIdKey);
                    String groupNo = recordEntry.getString("groupno");
                    entryIdSet.add(billeEntryId + "," + groupNo);
                }
                this.groupEntryCache.put(groupRecord.getLong("id"), entryIdSet);
            }
            groupRecord.set("updatetime", (Object)new Date());
            this.groupRecordCache.put(cacheKey, groupRecord);
        }
        return groupRecord;
    }

    public boolean isComtainEntry(DynamicObject matchSettingInfo, String groupValueStr, String entryIdGroupNoStr) {
        DynamicObject groupRecord = this.getRecord(matchSettingInfo, groupValueStr);
        Set<String> entryIdSet = this.groupEntryCache.get(groupRecord.getLong("id"));
        return entryIdSet != null && entryIdSet.contains(entryIdGroupNoStr);
    }

    void addEntry(DynamicObject matchSetting, String groupValueStr, Map<String, Object> entryValues) {
        DynamicObject groupRecord = this.getRecord(matchSetting, groupValueStr);
        DynamicObject groupRecordEntry = groupRecord.getDynamicObjectCollection("entryentity").addNew();
        for (Map.Entry<String, Object> fieldValue : entryValues.entrySet()) {
            groupRecordEntry.set(fieldValue.getKey(), fieldValue.getValue());
        }
        Set entryIdSet = this.groupEntryCache.computeIfAbsent(groupRecord.getLong("id"), k -> new HashSet(16));
        String billeEntryId = groupRecordEntry.getString(this.calEntryIdKey);
        String groupNo = groupRecordEntry.getString("groupno");
        entryIdSet.add(billeEntryId + "," + groupNo);
    }

    public Map<String, DynamicObject> getGroupRecords() {
        return this.groupRecordCache;
    }

    public void setGroupRecord(String key, DynamicObject record) {
        this.groupRecordCache.put(key, record);
    }
}

