/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.billgroup.AccountGroupRecordHelper;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.plugin.IBizPlugin;

public class BillGroupRelationHelper {
    private String inCalBillFieldStr;
    private String outCalBillFieldStr;
    private DynamicObject[] settingInfos;
    private String compareKey = "bill.id";
    private String srcFilterStrKey = "billfilterstr_tag";
    private String targetFilterStrKey = "rbillfilterstr_tag";
    private String targetBillTye = "relationbill";
    private static final int TARGET_OTHER = 0;
    private static final int TARGET_STRING = 1;
    private static final int TARGET_INT = 2;
    private static final String TO_CHAR_FMT = "TOCHAR(%s) as %s";
    private BillGroupRecordHolder holder = new BillGroupRecordHolder();
    private List<String> srcOnField = new ArrayList<String>();
    private Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private String calBillIdKey = this.isNewGroupModel != false ? "calbillid" : "billid";
    private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";
    private String groupRecKey = this.isNewGroupModel != false ? "cal_account_grouprecord" : "cal_groupbillrecord";
    private boolean delete = false;
    private Set<Long> createBizBillIds = new HashSet<Long>(16);
    private boolean filterGroupAcct = false;

    public BillGroupRelationHelper() {
        this.inCalBillFieldStr = this.getBillField("cal_incalbill");
        this.outCalBillFieldStr = this.getBillField("cal_outcalbill");
        Collection groupSettingDycs = BusinessDataServiceHelper.loadFromCache((String)"cal_billgroupsetting", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray()).values();
        ArrayList groupSettingDycList = new ArrayList(groupSettingDycs);
        Collections.sort(groupSettingDycList, this.getPriorityComparator());
        this.settingInfos = groupSettingDycList.toArray(new DynamicObject[0]);
    }

    public static Set<Long> getIsReturnBillGroupBillSetting() {
        HashSet<Long> isReturnBillSettings = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_billgroupsetting", (String)"id", (QFilter[])new QFilter("isreturnbill", "=", (Object)true).toArray(), null);){
            for (Row row : dataSet) {
                isReturnBillSettings.add(row.getLong("id"));
            }
        }
        return isReturnBillSettings;
    }

    public void createRelations(QFilter filter) {
        boolean ischargeoff;
        long id;
        DynamicObject[] inCalBills = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)"id, ischargeoff,bizbillid", (QFilter[])filter.toArray(), (String)"bookdate, auditdate");
        DynamicObject[] outCalBills = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)"id, ischargeoff,bizbillid", (QFilter[])filter.toArray(), (String)"bookdate, auditdate");
        HashSet<Long> outCalBillIds = new HashSet<Long>(outCalBills.length);
        HashSet<Long> inCalBillIds = new HashSet<Long>(inCalBills.length);
        HashMap<Long, Boolean> calBillIdAndIschargeoffMap = new HashMap<Long, Boolean>(outCalBills.length);
        for (DynamicObject inCalBill : inCalBills) {
            id = inCalBill.getLong("id");
            ischargeoff = inCalBill.getBoolean("ischargeoff");
            inCalBillIds.add(id);
            calBillIdAndIschargeoffMap.put(id, ischargeoff);
            this.createBizBillIds.add(inCalBill.getLong("bizbillid"));
        }
        for (DynamicObject outCalBill : outCalBills) {
            id = outCalBill.getLong("id");
            ischargeoff = outCalBill.getBoolean("ischargeoff");
            outCalBillIds.add(id);
            calBillIdAndIschargeoffMap.put(id, ischargeoff);
            this.createBizBillIds.add(outCalBill.getLong("bizbillid"));
        }
        if (inCalBillIds.isEmpty() && outCalBillIds.isEmpty()) {
            return;
        }
        this.matchAndCreateRelation(outCalBillIds, inCalBillIds, false);
        this.matchAndCreateRelation(outCalBillIds, inCalBillIds, true);
        HashSet<Long> allValidBizBillids = new HashSet<Long>();
        List<DynamicObject> groupBillRecords = this.getGroupBillRecord(allValidBizBillids, calBillIdAndIschargeoffMap);
        if (!this.isNewGroupModel.booleanValue() || allValidBizBillids.isEmpty()) {
            return;
        }
        new AccountGroupRecordHelper(allValidBizBillids, groupBillRecords).save();
    }

    protected void matchAndCreateRelation(Set<Long> outCalBills, Set<Long> inCalBills, boolean isByRelationBill) {
        if (isByRelationBill) {
            this.compareKey = "relationbill.id";
            this.srcFilterStrKey = "rbillfilterstr_tag";
            this.targetFilterStrKey = "billfilterstr_tag";
            this.targetBillTye = "bill";
        }
        HashSet<Long> copyOutCalBills = new HashSet<Long>(outCalBills);
        HashSet<Long> copyInCalBills = new HashSet<Long>(inCalBills);
        this.getMatchSettingInfo(copyOutCalBills, copyInCalBills, isByRelationBill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<Long>> dealBillGroupBySetting(boolean isByRelationBill, DynamicObject matchSettingInfo, DynamicObject[] srcBillInfos) {
        HashMap<String, Set<Long>> sucessCalBillIdsMap = new HashMap<String, Set<Long>>(16);
        String srcBillType = srcBillInfos[0].getDataEntityType().getName();
        DynamicObject bizplugin = matchSettingInfo.getDynamicObject("bizplugin");
        if (bizplugin != null) {
            String pluginClass = bizplugin.getString("plugin");
            IBizPlugin plugin = BillGroupRelationHelper.getProcessByName(pluginClass);
            HashMap<String, Object> tMap = new HashMap<String, Object>();
            tMap.put("isByRelationBill", isByRelationBill);
            tMap.put("matchSetting", matchSettingInfo);
            tMap.put("rbillfilterstr_tag", matchSettingInfo.getString("rbillfilterstr_tag"));
            plugin.doPlugin(tMap, srcBillInfos);
            Map plugInSucessIdsMap = (Map)tMap.get("sucessCalBillIds");
            if (plugInSucessIdsMap != null) {
                sucessCalBillIdsMap.put("cal_incalbill", (Set<Long>)plugInSucessIdsMap.get("cal_incalbill"));
                sucessCalBillIdsMap.put("cal_outcalbill", (Set<Long>)plugInSucessIdsMap.get("cal_outcalbill"));
            }
        } else {
            DynamicObject targetType = matchSettingInfo.getDynamicObject(this.targetBillTye);
            DynamicObjectCollection entrys = matchSettingInfo.getDynamicObjectCollection("entryentity");
            int size = entrys.size();
            HashMap<String, String> propMap = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String billfield = entry.getString("billfield");
                String rbillfield = entry.getString("rbillfield");
                if (isByRelationBill) {
                    propMap.put(rbillfield, billfield);
                    continue;
                }
                propMap.put(billfield, rbillfield);
            }
            String targetBillType = targetType.getString("number");
            DataSet billDataSet = null;
            DataSet targetDataSet = null;
            DataSet finalDataSet = null;
            try {
                String weightField = matchSettingInfo.getString("tarweightfield");
                if (StringUtils.isEmpty((String)weightField)) {
                    weightField = "entry.baseqty";
                }
                billDataSet = this.getSrcBillDataSet(srcBillType, propMap, weightField, matchSettingInfo, srcBillInfos, targetBillType);
                targetDataSet = this.getTargetBillInfo(matchSettingInfo, srcBillType, targetBillType, srcBillInfos, propMap, weightField);
                finalDataSet = this.getFinalDataSet(billDataSet, targetDataSet, propMap, srcBillType, targetBillType, weightField);
                Set<Long> notPluginSucessCalBillIds = this.createBillGroupInfo(matchSettingInfo, finalDataSet, isByRelationBill, weightField);
                sucessCalBillIdsMap.put(srcBillType, notPluginSucessCalBillIds);
            }
            finally {
                if (billDataSet != null) {
                    billDataSet.close();
                }
                if (targetDataSet != null) {
                    targetDataSet.close();
                }
                if (finalDataSet != null) {
                    finalDataSet.close();
                }
            }
        }
        return sucessCalBillIdsMap;
    }

    protected void getMatchSettingInfo(Set<Long> outCalBills, Set<Long> inCalBills, boolean isByRelationBill) {
        for (DynamicObject settingInfo : this.settingInfos) {
            Set<Long> outCalBillIDs;
            QFilter qf;
            if (outCalBills.isEmpty() && inCalBills.isEmpty()) break;
            String billType = settingInfo.getString(this.compareKey);
            String billFilter = settingInfo.getString(this.srcFilterStrKey);
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billFilter, FilterCondition.class);
            MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
            filterBuilder.buildFilter();
            List billFilterlist = filterBuilder.getQFilters();
            DynamicObject[] billCol = null;
            if ("cal_incalbill".equals(billType)) {
                qf = new QFilter("id", "in", inCalBills);
                billFilterlist.add(qf);
                billCol = BusinessDataServiceHelper.load((String)billType, (String)this.inCalBillFieldStr, (QFilter[])billFilterlist.toArray(new QFilter[0]));
            } else {
                qf = new QFilter("id", "in", outCalBills);
                billFilterlist.add(qf);
                billCol = BusinessDataServiceHelper.load((String)billType, (String)this.outCalBillFieldStr, (QFilter[])billFilterlist.toArray(new QFilter[0]));
            }
            if (billCol == null || billCol.length == 0) continue;
            Map<String, Set<Long>> sucessCalBillIdsMap = this.dealBillGroupBySetting(isByRelationBill, settingInfo, billCol);
            Set<Long> inCalBillIDs = sucessCalBillIdsMap.get("cal_incalbill");
            if (inCalBillIDs != null) {
                inCalBills.removeAll(inCalBillIDs);
            }
            if ((outCalBillIDs = sucessCalBillIdsMap.get("cal_outcalbill")) == null) continue;
            outCalBills.removeAll(outCalBillIDs);
        }
    }

    public void rebuildRelations(QFilter filter) {
        DynamicObject[] inCalBills = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)this.inCalBillFieldStr, (QFilter[])filter.toArray());
        DynamicObject[] outCalBills = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)this.outCalBillFieldStr, (QFilter[])filter.toArray());
        HashSet<Object> idSet = new HashSet<Object>(inCalBills.length + outCalBills.length);
        for (DynamicObject inCalBill : inCalBills) {
            idSet.add(inCalBill.getPkValue());
        }
        for (DynamicObject outCalBill : outCalBills) {
            idSet.add(outCalBill.getPkValue());
        }
        QFilter deleteFilter = new QFilter("srcbillid", "in", idSet);
        deleteFilter.or(new QFilter("destbillid", "in", idSet));
        this.getAndRemoveRelations(deleteFilter, false);
        this.createRelations(deleteFilter);
    }

    public void getAndRemoveRelations(QFilter filter, boolean updateCostDomainGroup) {
        DynamicObject[] inCalBills = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)this.inCalBillFieldStr, (QFilter[])filter.toArray());
        DynamicObject[] outCalBills = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)this.outCalBillFieldStr, (QFilter[])filter.toArray());
        HashSet<Object> idSet = new HashSet<Object>(inCalBills.length + outCalBills.length);
        for (DynamicObject inCalBill : inCalBills) {
            idSet.add(inCalBill.getPkValue());
        }
        for (DynamicObject outCalBill : outCalBills) {
            idSet.add(outCalBill.getPkValue());
        }
        this.getAndRemoveRelations(idSet, updateCostDomainGroup);
    }

    public void getAndRemoveRelations(Set<Object> calBillIds, boolean updateCostDomainGroup) {
        String bizGroupRecordIdKey = "";
        if (this.isNewGroupModel.booleanValue()) {
            bizGroupRecordIdKey = "bizgrouprecordid,";
        }
        QFilter filter = new QFilter("entryentity." + this.calBillIdKey, "in", calBillIds);
        if (this.isNewGroupModel.booleanValue() && this.filterGroupAcct) {
            new CalGroupAccountHelper().addNotGroupAcctFilterByAcctField("entryentity.costaccount", filter);
        }
        HashSet<Long> deleteRecordIds = new HashSet<Long>();
        ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>();
        DynamicObject[] records = BusinessDataServiceHelper.load((String)this.groupRecKey, (String)("id,iscompleted," + bizGroupRecordIdKey + "entryentity." + this.calBillIdKey + ",entryentity.islastentry,entryentity.bizbillid,entryentity.type,entryentity.owner,entryentity.material,entryentity.baseqty,entryentity.groupno,entryentity.ischargeoffed"), (QFilter[])filter.toArray());
        if (records == null || records.length == 0) {
            return;
        }
        Set<Long> transinChargeoffedIds = this.getTransinChargeoffedIds(Arrays.asList(records));
        HashSet<Long> bizbillids = new HashSet<Long>(16);
        HashSet<Long> recordIds = new HashSet<Long>(16);
        HashSet<String> types = new HashSet<String>(16);
        HashSet<Long> validCalBillIds = new HashSet<Long>(16);
        HashSet<Long> bizGroupRecordIds = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            DynamicObject recordEntry;
            recordIds.add(record.getLong("id"));
            DynamicObjectCollection recordEntryCol = record.getDynamicObjectCollection("entryentity");
            Iterator it = recordEntryCol.iterator();
            boolean isLastEntry = false;
            bizbillids.clear();
            types.clear();
            BigDecimal srcQty = BigDecimal.ZERO;
            BigDecimal destQty = BigDecimal.ZERO;
            boolean destHasPos = false;
            boolean destHasNeg = false;
            boolean hasChargeOff = false;
            HashMap<Long, Boolean> groupDest = new HashMap<Long, Boolean>();
            while (it.hasNext()) {
                recordEntry = (DynamicObject)it.next();
                if (calBillIds.contains(recordEntry.get(this.calBillIdKey))) {
                    validCalBillIds.add(recordEntry.getLong(this.calBillIdKey));
                    it.remove();
                    continue;
                }
                BigDecimal baseqty = recordEntry.getBigDecimal("baseqty");
                if ("1".equals(recordEntry.getString("type"))) {
                    groupDest.put(recordEntry.getLong("groupNo"), Boolean.TRUE);
                    if (baseqty.signum() > 0) {
                        destHasPos = true;
                    } else if (baseqty.signum() < 0) {
                        destHasNeg = true;
                    }
                }
                isLastEntry = isLastEntry || recordEntry.getBoolean("islastentry");
                Long bizbillid = recordEntry.getLong("bizbillid");
                bizbillids.add(bizbillid);
                String type = recordEntry.getString("type");
                types.add(recordEntry.getString("type"));
                boolean ischargeoffed = recordEntry.getBoolean("ischargeoffed");
                if (type.equals("1") && ischargeoffed) {
                    if (!transinChargeoffedIds.contains(bizbillid)) continue;
                    hasChargeOff = true;
                }
                if ("1".equals(type)) {
                    destQty = destQty.add(baseqty);
                    continue;
                }
                srcQty = srcQty.add(baseqty);
            }
            it = recordEntryCol.iterator();
            while (it.hasNext()) {
                recordEntry = (DynamicObject)it.next();
                Long groupNo = recordEntry.getLong("groupNo");
                if (groupDest.get(groupNo) != null) continue;
                it.remove();
            }
            if (recordEntryCol.isEmpty() || types.size() == 1) {
                deleteRecordIds.add(record.getLong("id"));
            } else {
                boolean iscompleted;
                boolean bl = iscompleted = isLastEntry || destQty.abs().compareTo(srcQty.abs()) >= 0 || bizbillids.size() == 1;
                if (destHasNeg && destHasPos) {
                    iscompleted = false;
                }
                if (bizbillids.size() > 1 && hasChargeOff) {
                    iscompleted = false;
                }
                record.set("iscompleted", (Object)iscompleted);
                updateRecords.add(record);
            }
            if (!this.isNewGroupModel.booleanValue()) continue;
            bizGroupRecordIds.add(record.getLong("bizgrouprecordid"));
        }
        if (this.isNewGroupModel.booleanValue() && updateCostDomainGroup) {
            CostDomainGroupHelper costDomainGroupHelper = new CostDomainGroupHelper();
            costDomainGroupHelper.setFilterGroupAcct(this.filterGroupAcct);
            costDomainGroupHelper.deleteAndUpdateCostDomainGroup(validCalBillIds);
            if (!bizGroupRecordIds.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_billgrouprecord"), (Object[])bizGroupRecordIds.toArray(new Object[bizGroupRecordIds.size()]));
            }
        }
        if (updateRecords.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[updateRecords.size()]));
        }
        if (!this.isNewGroupModel.booleanValue()) {
            CostAccountGroupRecordHelper oldAccountGroupRecordHelper = new CostAccountGroupRecordHelper();
            oldAccountGroupRecordHelper.setFilterGroupAcct(this.filterGroupAcct);
            oldAccountGroupRecordHelper.refreshGroupRecordByBiz(this.isDelete(), recordIds, deleteRecordIds);
        }
        if (deleteRecordIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)records[0].getDataEntityType().getName()), (Object[])deleteRecordIds.toArray(new Object[deleteRecordIds.size()]));
        }
    }

    public static IBizPlugin getProcessByName(String className) {
        try {
            Class<?> process = Class.forName(className);
            return (IBizPlugin)process.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getBillField(String entityNumber) {
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.setLength(fields.length() - 1);
        return fields.toString();
    }

    private DataSet getSrcBillDataSet(String billType, Map<String, String> propMap, String weightField, DynamicObject matchSettingInfo, DynamicObject[] srcBillInfos, String targetBillType) {
        String entryNameStr = null;
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.add("id");
        Set<Map.Entry<String, String>> set = propMap.entrySet();
        MainEntityType srcDataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        MainEntityType tgtDataEntityType = EntityMetadataCache.getDataEntityType((String)targetBillType);
        for (Map.Entry<String, String> entry : set) {
            boolean isToChar;
            String srcBillField = entry.getKey();
            String entryName = this.getEntryEntityName(billType, srcBillField);
            boolean srcFieldIsLongType = srcDataEntityType.findProperty(srcBillField) instanceof BigIntProp;
            boolean tgtFildIsStrType = tgtDataEntityType.findProperty(entry.getValue()) instanceof TextProp;
            boolean bl = isToChar = srcFieldIsLongType && tgtFildIsStrType;
            if (entryName == null) {
                srcBillField = this.selectFieldToChar(srcBillField, isToChar);
                fieldSet.add(srcBillField);
                continue;
            }
            entryNameStr = entryName;
            if (srcBillField.startsWith(entryName + ".")) continue;
            srcBillField = entryName + "." + srcBillField;
            srcBillField = this.selectFieldToChar(srcBillField, isToChar);
            fieldSet.add(srcBillField);
        }
        if (entryNameStr != null) {
            fieldSet.add(entryNameStr + ".id");
        }
        HashSet<Long> srcIdSet = new HashSet<Long>(srcBillInfos.length);
        for (DynamicObject srcBillInfo : srcBillInfos) {
            srcIdSet.add(srcBillInfo.getLong("id"));
        }
        return QueryServiceHelper.queryDataSet((String)(this.getClass() + "getbillDataSet"), (String)billType, (String)(this.getStrBySet(fieldSet) + ",entry.owner as leftowner,entry.material as leftmaterial,entry.baseqty as leftqty," + weightField + " as left" + weightField + ",ischargeoffed as leftischargeoffed,billno as leftbillno,bizdate as leftbizdate,bookdate as leftbookdate,entry.islastentry as leftislastentry, bizbillid as leftbizbillid,entry.ispresent as leftispresent"), (QFilter[])new QFilter("id", "in", srcIdSet).toArray(), null);
    }

    private DataSet getTargetBillInfo(DynamicObject matchSettingInfo, String srcBillType, String targetBillType, DynamicObject[] srcBillInfos, Map<String, String> propMap, String weightField) {
        Iterator<Map.Entry<String, String>> iterator = propMap.entrySet().iterator();
        String entryNameStr = null;
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.add("id");
        String billFilter = matchSettingInfo.getString(this.targetFilterStrKey);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billFilter, FilterCondition.class);
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)targetBillType);
        FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
        filterBuilder.buildFilter();
        List list = filterBuilder.getQFilters();
        MainEntityType srcDataEntityType = EntityMetadataCache.getDataEntityType((String)srcBillType);
        MainEntityType tgtDataEntityType = EntityMetadataCache.getDataEntityType((String)targetBillType);
        while (iterator.hasNext()) {
            boolean isToChar;
            Map.Entry<String, String> entry = iterator.next();
            String srcProp = entry.getKey();
            String targetProp = entry.getValue();
            QFilter qf = null;
            String targetBillEntryName = this.getEntryEntityName(targetBillType, targetProp);
            String srcBillEntryName = this.getEntryEntityName(srcBillType, srcProp);
            int tgtFildType = 0;
            IDataEntityProperty targetEntity = tgtDataEntityType.findProperty(targetProp);
            if (targetEntity instanceof TextProp) {
                tgtFildType = 1;
            } else if (targetEntity instanceof BigIntProp || targetEntity instanceof LongProp) {
                tgtFildType = 2;
            }
            qf = this.getEntryFiter(srcBillInfos, srcBillEntryName, targetBillEntryName, srcProp, targetProp, tgtFildType);
            boolean srcFieldIsTxtType = srcDataEntityType.findProperty(srcProp) instanceof TextProp;
            boolean tgtFildIsLongType = tgtDataEntityType.findProperty(targetProp) instanceof BigIntProp;
            boolean bl = isToChar = srcFieldIsTxtType && tgtFildIsLongType;
            if (targetBillEntryName != null) {
                entryNameStr = targetBillEntryName;
                if (targetProp.startsWith(targetBillEntryName + ".")) {
                    targetProp = targetProp.split("\\.")[1];
                }
                targetProp = targetBillEntryName + "." + targetProp;
                targetProp = this.selectFieldToChar(targetProp, isToChar);
                fieldSet.add(targetProp);
            } else {
                targetProp = this.selectFieldToChar(targetProp, isToChar);
                fieldSet.add(targetProp);
            }
            list.add(qf);
        }
        if (entryNameStr != null) {
            fieldSet.add(entryNameStr + ".id");
        }
        DataSet targetDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass() + "getTargetBillInfo"), (String)targetBillType, (String)(this.getStrBySet(fieldSet) + ",entry.owner as rightowner,entry.material as rightmaterial,entry.baseqty as rightqty," + weightField + " as right" + weightField + ",ischargeoffed as rightischargeoffed,billno as rightbillno,bizdate as rightbizdate,bookdate as rightbookdate,entry.islastentry as rightislastentry, bizbillid as rightbizbillid,entry.ispresent as rightispresent"), (QFilter[])list.toArray(new QFilter[0]), null);
        return targetDataSet;
    }

    private String getEntryEntityName(String typeNumber, String propName) {
        if (propName.endsWith(".id")) {
            return propName.split("\\.")[0];
        }
        MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)typeNumber);
        IDataEntityProperty dataEntity = billDataEntity.findProperty(propName.split("\\.")[0]);
        if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
            return dataEntity.getParent().getName();
        }
        return null;
    }

    private QFilter getEntryFiter(DynamicObject[] srcBillInfos, String srcBillEntryName, String targetBillEntryName, String srcProp, String targetProp, int tgtFildType) {
        HashSet<Object> values = new HashSet<Object>();
        for (DynamicObject srcBillInfo : srcBillInfos) {
            if (srcBillEntryName != null) {
                DynamicObjectCollection entrys = srcBillInfo.getDynamicObjectCollection(srcBillEntryName);
                for (DynamicObject entry : entrys) {
                    Object obj;
                    if (srcProp.startsWith(srcBillEntryName + ".")) {
                        srcProp = srcProp.split("\\.")[1];
                    }
                    if ((obj = entry.get(srcProp)) == null) continue;
                    this.getFieldMatchValue(tgtFildType, values, obj);
                }
                continue;
            }
            Object obj = srcBillInfo.get(srcProp);
            if (obj == null) continue;
            this.getFieldMatchValue(tgtFildType, values, obj);
        }
        QFilter qf = null;
        if (targetBillEntryName != null) {
            if (targetProp.startsWith(targetBillEntryName + ".")) {
                targetProp = targetProp.split("\\.")[1];
            }
            qf = new QFilter(targetBillEntryName + "." + targetProp, "in", values);
        } else {
            qf = new QFilter(targetProp, "in", values);
        }
        return qf;
    }

    private void getFieldMatchValue(int tgtFildType, Set<Object> values, Object obj) {
        if (tgtFildType == 1) {
            if (obj instanceof DynamicObject) {
                DynamicObject tobj = (DynamicObject)obj;
                values.add("" + tobj.getPkValue());
            } else if (obj instanceof Long) {
                values.add("" + obj);
            } else {
                values.add(obj);
            }
        } else if (tgtFildType == 2) {
            if (obj instanceof DynamicObject) {
                DynamicObject tobj = (DynamicObject)obj;
                values.add(tobj.getPkValue());
            } else if (obj instanceof String) {
                if (StringUtils.isNotEmpty((String)obj.toString())) {
                    values.add(Long.parseLong(obj.toString()));
                }
            } else {
                values.add(obj);
            }
        } else if (obj instanceof DynamicObject) {
            DynamicObject tobj = (DynamicObject)obj;
            values.add(tobj.getPkValue());
        } else {
            values.add(obj);
        }
    }

    private DataSet getFinalDataSet(DataSet billDataSet, DataSet targetDataSet, Map<String, String> propMap, String srcBillType, String targetBillType, String weightField) {
        JoinDataSet joinSet = billDataSet.join(targetDataSet, JoinType.INNER);
        Set<Map.Entry<String, String>> set = propMap.entrySet();
        HashSet<String> leftField = new HashSet<String>(64);
        HashSet<String> rightField = new HashSet<String>();
        String srcEntry = null;
        String targetEntrye = null;
        this.srcOnField.clear();
        for (Map.Entry<String, String> entry : set) {
            String srcBillField = entry.getKey();
            String destBillField = entry.getValue();
            String srcEntryName = this.getEntryEntityName(srcBillType, srcBillField);
            String targetEntryName = this.getEntryEntityName(targetBillType, destBillField);
            String srcStr = "";
            String destStr = "";
            if (srcEntryName == null) {
                srcStr = srcBillField;
            } else {
                srcEntry = srcEntryName;
                srcStr = srcBillField.startsWith(srcEntryName + ".") ? srcBillField : srcEntryName + "." + srcBillField;
            }
            if (targetEntryName == null) {
                destStr = destBillField;
            } else {
                targetEntrye = targetEntryName;
                destStr = destBillField.startsWith(targetEntryName + ".") ? destBillField : targetEntryName + "." + destBillField;
            }
            joinSet.on(srcStr, destStr);
            this.srcOnField.add(srcStr);
        }
        leftField.add("id leftID");
        leftField.add("left" + weightField);
        leftField.add("leftbillno");
        leftField.add("leftbizdate");
        leftField.add("leftbookdate");
        leftField.add("leftmaterial");
        leftField.add("leftowner");
        leftField.add("leftislastentry");
        leftField.add("leftbizbillid");
        leftField.add("leftispresent");
        leftField.add("leftqty");
        leftField.add("leftischargeoffed");
        leftField.add(srcEntry + ".id leftEntryID");
        for (String leftOnField : this.srcOnField) {
            leftField.add(leftOnField);
        }
        rightField.add("id rightID");
        leftField.add("right" + weightField);
        rightField.add("rightbillno");
        rightField.add("rightbizdate");
        rightField.add("rightbookdate");
        rightField.add("rightmaterial");
        rightField.add("rightowner");
        rightField.add("rightislastentry");
        rightField.add("rightbizbillid");
        leftField.add("rightispresent");
        leftField.add("rightqty");
        leftField.add("rightischargeoffed");
        rightField.add(targetEntrye + ".id rightEntryID");
        joinSet.select(leftField.toArray(new String[leftField.size()]), rightField.toArray(new String[rightField.size()]));
        return joinSet.finish();
    }

    private String getStrBySet(Set<String> fieldSet) {
        StringBuilder str = new StringBuilder();
        int k = 0;
        for (String s : fieldSet) {
            if (s.trim().isEmpty()) continue;
            if (k != 0) {
                str.append(',');
            }
            str.append(s);
            ++k;
        }
        return str.toString();
    }

    private Set<Long> createBillGroupInfo(DynamicObject matchSettingInfo, DataSet bills, boolean isByRelationBill, String weightField) {
        HashSet<Long> sucessCalBillIds = new HashSet<Long>(16);
        Long matchSettingId = matchSettingInfo.getLong("id");
        StringBuilder groupvalue = new StringBuilder();
        while (bills.hasNext()) {
            Row row = bills.next();
            for (String onField : this.srcOnField) {
                groupvalue.append(row.get(onField));
                groupvalue.append('#');
            }
            String groupValueStr = groupvalue.toString();
            groupvalue.setLength(0);
            Long leftEntryId = row.getLong("leftEntryID");
            Long rightEntryId = row.getLong("rightEntryID");
            if (!this.holder.isComtainEntry(matchSettingInfo, groupValueStr, leftEntryId)) {
                HashMap<String, Object> leftEntry = new HashMap<String, Object>();
                if (isByRelationBill) {
                    leftEntry.put("type", "0");
                    leftEntry.put("weight", BigDecimal.ONE);
                } else {
                    leftEntry.put("type", "1");
                    leftEntry.put("weight", row.getBigDecimal("left" + weightField).abs());
                }
                leftEntry.put(this.calBillIdKey, row.get("leftID"));
                leftEntry.put(this.calEntryIdKey, leftEntryId);
                leftEntry.put("billno", row.get("leftbillno"));
                if (!this.isNewGroupModel.booleanValue()) {
                    leftEntry.put("bizdate", row.get("leftbizdate"));
                }
                leftEntry.put("bookdate", row.get("leftbookdate"));
                leftEntry.put("material", row.get("leftmaterial"));
                leftEntry.put("owner", row.get("leftowner"));
                leftEntry.put("islastentry", row.get("leftislastentry"));
                leftEntry.put("bizbillid", row.getLong("leftbizbillid"));
                leftEntry.put("baseqty", row.getBigDecimal("leftqty"));
                leftEntry.put("ischargeoffed", row.getBoolean("leftischargeoffed"));
                leftEntry.put("occupiedqty", row.getBigDecimal("leftqty"));
                this.holder.addEntry(matchSettingInfo, groupValueStr, leftEntry);
                sucessCalBillIds.add(row.getLong("leftID"));
            }
            if (this.holder.isComtainEntry(matchSettingInfo, groupValueStr, rightEntryId)) continue;
            HashMap<String, Object> rightEntry = new HashMap<String, Object>();
            if (isByRelationBill) {
                rightEntry.put("type", "1");
                rightEntry.put("weight", row.getBigDecimal("right" + weightField).abs());
            } else {
                rightEntry.put("type", "0");
                rightEntry.put("weight", BigDecimal.ONE);
            }
            rightEntry.put(this.calBillIdKey, row.get("rightID"));
            rightEntry.put(this.calEntryIdKey, rightEntryId);
            rightEntry.put("billno", row.get("rightbillno"));
            if (!this.isNewGroupModel.booleanValue()) {
                rightEntry.put("bizdate", row.get("rightbizdate"));
            }
            rightEntry.put("bookdate", row.get("rightbookdate"));
            rightEntry.put("material", row.get("rightmaterial"));
            rightEntry.put("owner", row.get("rightowner"));
            rightEntry.put("islastentry", row.get("rightislastentry"));
            rightEntry.put("bizbillid", row.getLong("rightbizbillid"));
            rightEntry.put("baseqty", row.getBigDecimal("rightqty"));
            rightEntry.put("ischargeoffed", row.getBoolean("rightischargeoffed"));
            rightEntry.put("occupiedqty", row.getBigDecimal("rightqty"));
            this.holder.addEntry(matchSettingInfo, groupValueStr, rightEntry);
        }
        this.removeNoTgtBillGroupCalBillIds(sucessCalBillIds, matchSettingId);
        return sucessCalBillIds;
    }

    private void removeNoTgtBillGroupCalBillIds(Set<Long> sucessCalBillIds, Long matchSettingId) {
        List records = this.holder.getGroupRecords();
        Iterator it = records.iterator();
        HashSet<Long> calBillIDs = new HashSet<Long>(16);
        while (it.hasNext()) {
            DynamicObject record = (DynamicObject)it.next();
            Object groupSetting = record.get("groupsetting");
            Long groupSettingId = 0L;
            groupSettingId = groupSetting instanceof DynamicObject ? Long.valueOf(record.getLong("groupsetting_id")) : Long.valueOf(record.getLong("groupsetting"));
            if (!matchSettingId.equals(groupSettingId)) continue;
            boolean hasTargetBill = false;
            DynamicObjectCollection entryCol = record.getDynamicObjectCollection("entryentity");
            if (entryCol.isEmpty()) {
                it.remove();
                continue;
            }
            for (DynamicObject entry : entryCol) {
                if (entry.getString("type").equals("1")) {
                    hasTargetBill = true;
                }
                calBillIDs.add(entry.getLong(this.calBillIdKey));
            }
            if (!hasTargetBill) {
                it.remove();
                sucessCalBillIds.removeAll(calBillIDs);
                continue;
            }
            calBillIDs.clear();
        }
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public Set<Long> getCreateBizBillIds() {
        return this.createBizBillIds;
    }

    public void setFilterGroupAcct(boolean filterGroupAcct) {
        this.filterGroupAcct = filterGroupAcct;
    }

    private List<DynamicObject> getGroupBillRecord(Set<Long> allValidBizBillids, Map<Long, Boolean> calBillIdAndIschargeoffMap) {
        List records = this.holder.getGroupRecords();
        Iterator it = records.iterator();
        HashSet<Long> bizbillids = new HashSet<Long>();
        HashSet<DynamicObject> saveRecords = new HashSet<DynamicObject>(16);
        Set<Long> transinChargeoffedIds = this.getTransinChargeoffedIds(records);
        boolean isLastEntry = false;
        while (it.hasNext()) {
            boolean iscompleted;
            DynamicObject record = (DynamicObject)it.next();
            boolean hasTargetBill = false;
            DynamicObjectCollection entryCol = record.getDynamicObjectCollection("entryentity");
            if (entryCol.isEmpty()) {
                it.remove();
                continue;
            }
            BigDecimal srcQty = BigDecimal.ZERO;
            BigDecimal destQty = BigDecimal.ZERO;
            boolean destHasPos = false;
            boolean destHasNeg = false;
            boolean hasChargeOff = false;
            for (DynamicObject entry : entryCol) {
                Long bizbillid = entry.getLong("bizbillid");
                bizbillids.add(bizbillid);
                boolean ischargeoffed = entry.getBoolean("ischargeoffed");
                String type = entry.getString("type");
                isLastEntry = isLastEntry || entry.getBoolean("islastentry");
                BigDecimal baseqty = entry.getBigDecimal("baseqty");
                if ("1".equals(type)) {
                    if (baseqty.signum() > 0) {
                        destHasPos = true;
                    } else if (baseqty.signum() < 0) {
                        destHasNeg = true;
                    }
                    hasTargetBill = true;
                }
                if ("1".equals(type) && ischargeoffed) {
                    if (!transinChargeoffedIds.contains(bizbillid)) continue;
                    hasChargeOff = true;
                }
                if ("0".equals(type)) {
                    srcQty = srcQty.add(baseqty);
                    continue;
                }
                if (!"1".equals(type)) continue;
                destQty = destQty.add(baseqty);
            }
            if (!hasTargetBill) {
                it.remove();
                continue;
            }
            boolean bl = iscompleted = isLastEntry || destQty.abs().compareTo(srcQty.abs()) >= 0 || bizbillids.size() <= 1;
            if (destHasNeg && destHasPos) {
                iscompleted = false;
            }
            if (bizbillids.size() > 1 && hasChargeOff) {
                iscompleted = false;
            }
            record.set("iscompleted", (Object)iscompleted);
            saveRecords.add(record);
            allValidBizBillids.addAll(bizbillids);
            bizbillids.clear();
            isLastEntry = false;
        }
        if (!this.isNewGroupModel.booleanValue() && !saveRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveRecords.toArray(new DynamicObject[0]));
        }
        return records;
    }

    private Set<Long> getTransinChargeoffedIds(List<DynamicObject> records) {
        HashSet<Long> transinChargeoffedIds = new HashSet<Long>(4);
        HashSet<Long> chargeoffedIds = new HashSet<Long>(4);
        for (DynamicObject record : records) {
            DynamicObjectCollection entryCol = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryCol) {
                String type = entryRow.getString("type");
                boolean ischargeoffed = entryRow.getBoolean("ischargeoffed");
                if (!ischargeoffed || !"1".equals(type)) continue;
                chargeoffedIds.add(entryRow.getLong("bizbillid"));
            }
        }
        if (!chargeoffedIds.isEmpty()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_transinbill", (String)"id", (QFilter[])new QFilter("id", "in", chargeoffedIds).toArray(), null);){
                for (Row row : ds) {
                    transinChargeoffedIds.add(row.getLong("id"));
                }
            }
        }
        return transinChargeoffedIds;
    }

    private String selectFieldToChar(String billField, boolean isToChar) {
        if (isToChar) {
            billField = String.format(TO_CHAR_FMT, billField, billField);
        }
        return billField;
    }

    private Comparator<DynamicObject> getPriorityComparator() {
        Comparator<DynamicObject> comparator = new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int otherPrior;
                int onePrior = o1.getInt("priority");
                if (onePrior > (otherPrior = o2.getInt("priority"))) {
                    return 1;
                }
                if (onePrior < otherPrior) {
                    return -1;
                }
                return 0;
            }
        };
        return comparator;
    }

    private static class BillGroupRecordHolder {
        private Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
        private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";
        private String groupRecKey = this.isNewGroupModel != false ? "cal_account_grouprecord" : "cal_groupbillrecord";
        private String tableKey = this.isNewGroupModel != false ? "t_cal_accountgrouprecord" : "t_cal_groupbillrecord";
        private Map<String, DynamicObject> groupRecordCache = new HashMap<String, DynamicObject>();
        private Map<Long, Set<Long>> groupEntryCache = new HashMap<Long, Set<Long>>();

        private BillGroupRecordHolder() {
        }

        private DynamicObject getRecord(DynamicObject matchSetting, String groupValueStr) {
            Long matchSettingId = matchSetting.getLong("id");
            String cacheKey = matchSettingId + "_" + groupValueStr;
            DynamicObject groupRecord = this.groupRecordCache.get(cacheKey);
            if (groupRecord == null) {
                QFilter filter = new QFilter("groupsetting", "=", (Object)matchSettingId);
                filter.and("groupvalue", "=", (Object)groupValueStr);
                groupRecord = BusinessDataServiceHelper.loadSingle((String)this.groupRecKey, (String)"id", (QFilter[])filter.toArray());
                if (groupRecord == null) {
                    groupRecord = BusinessDataServiceHelper.newDynamicObject((String)this.groupRecKey);
                    groupRecord.set("id", (Object)DB.genLongId((String)this.tableKey));
                    groupRecord.set("groupsetting_id", (Object)matchSettingId);
                    groupRecord.set("groupsettingtype", (Object)matchSetting.getDataEntityType().getName());
                    groupRecord.set("groupvalue", (Object)groupValueStr);
                    groupRecord.set("createtime", (Object)new Date());
                    groupRecord.set("costcolumn", (Object)matchSetting.getString("costcolumn"));
                    groupRecord.set("costfields", (Object)matchSetting.getString("costfields"));
                } else {
                    groupRecord = BusinessDataServiceHelper.loadSingle((Object)groupRecord.getPkValue(), (String)this.groupRecKey);
                    HashSet<Long> entryIdSet = new HashSet<Long>();
                    for (DynamicObject recordEntry : groupRecord.getDynamicObjectCollection("entryentity")) {
                        entryIdSet.add(recordEntry.getLong(this.calEntryIdKey));
                    }
                    this.groupEntryCache.put(groupRecord.getLong("id"), entryIdSet);
                }
                groupRecord.set("updatetime", (Object)new Date());
                this.groupRecordCache.put(cacheKey, groupRecord);
            }
            return groupRecord;
        }

        private boolean isComtainEntry(DynamicObject matchSettingInfo, String groupValueStr, Long entryId) {
            DynamicObject groupRecord = this.getRecord(matchSettingInfo, groupValueStr);
            Set<Long> entryIdSet = this.groupEntryCache.get(groupRecord.getLong("id"));
            return entryIdSet != null && entryIdSet.contains(entryId);
        }

        private void addEntry(DynamicObject matchSetting, String groupValueStr, Map<String, Object> entryValues) {
            DynamicObject groupRecord = this.getRecord(matchSetting, groupValueStr);
            DynamicObject groupRecordEntry = groupRecord.getDynamicObjectCollection("entryentity").addNew();
            for (Map.Entry<String, Object> fieldValue : entryValues.entrySet()) {
                groupRecordEntry.set(fieldValue.getKey(), fieldValue.getValue());
            }
            Set entryIdSet = this.groupEntryCache.computeIfAbsent(groupRecord.getLong("id"), k -> new HashSet());
            entryIdSet.add(groupRecordEntry.getLong(this.calEntryIdKey));
        }

        private List<DynamicObject> getGroupRecords() {
            return new LinkedList<DynamicObject>(this.groupRecordCache.values());
        }
    }
}

