/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.calculate.billgroup.AccountGroupRecordHelper;
import kd.fi.cal.business.calculate.billgroup.BillGroupRecordHolder;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.business.calculate.billgroup.WfGroupRelationConfig;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import org.apache.commons.lang.StringUtils;

public class BillGroupWfRelationHelper {
    private DynamicObject[] wfRecordDycs;
    private WfGroupRelationConfig config;
    private DynamicObject configDyc;
    private Boolean isPurOmWf;
    private BillGroupRecordHolder holder = new BillGroupRecordHolder();
    private Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private String calBillIdKey = this.isNewGroupModel != false ? "calbillid" : "billid";
    private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";
    private String groupRecKey = this.isNewGroupModel != false ? "cal_account_grouprecord" : "cal_groupbillrecord";
    private Set<Long> allValidBizBillids;

    public List<DynamicObject> createRelations(DynamicObject[] wfRecordDycs) {
        if (wfRecordDycs.length < 1) {
            return new ArrayList<DynamicObject>(0);
        }
        this.wfRecordDycs = wfRecordDycs;
        this.isPurOmWf = "im_oswfrecord".equals(wfRecordDycs[0].getDataEntityType().getName());
        this.loadWfRelationConfig();
        this.updateOrAddRelation();
        this.saveAndSyncCost();
        if (this.isNewGroupModel.booleanValue()) {
            new AccountGroupRecordHelper(this.allValidBizBillids, new ArrayList<DynamicObject>(this.holder.getGroupRecords().values())).save();
        }
        return new ArrayList<DynamicObject>(this.holder.getGroupRecords().values());
    }

    public DynamicObject createRelations(DynamicObject wfRecordDyc) {
        if (wfRecordDyc == null) {
            return null;
        }
        this.wfRecordDycs = new DynamicObject[]{wfRecordDyc};
        this.isPurOmWf = "im_oswfrecord".equals(this.wfRecordDycs[0].getDataEntityType().getName());
        this.loadWfRelationConfig();
        this.updateOrAddRelation();
        this.saveAndSyncCost();
        for (DynamicObject record : this.holder.getGroupRecords().values()) {
            for (DynamicObject recordEntry : record.getDynamicObjectCollection("entryentity")) {
                if (recordEntry.getLong("groupno") != wfRecordDyc.getLong("id")) continue;
                if (this.isNewGroupModel.booleanValue()) {
                    new AccountGroupRecordHelper(this.allValidBizBillids, Collections.singletonList(record)).save();
                }
                HashSet<Long> calbillids = new HashSet<Long>(4);
                HashSet<Long> calentryids = new HashSet<Long>(4);
                for (DynamicObject recordEntry1 : record.getDynamicObjectCollection("entryentity")) {
                    if (!"1".equals(recordEntry1.getString("type"))) continue;
                    calbillids.add(recordEntry1.getLong(this.calBillIdKey));
                    calentryids.add(recordEntry1.getLong(this.calEntryIdKey));
                }
                new CostDomainGroupHelper().insertAndUpdateCostDomainGroup(calbillids, calentryids);
                return record;
            }
        }
        return null;
    }

    private void loadWfRelationConfig() {
        DynamicObject wfRecordDyc = this.wfRecordDycs[0];
        Long wfTypeDyc = wfRecordDyc.getLong("writeofftypeid_id");
        String wfRecordEntity = wfRecordDyc.getDynamicObjectType().getName();
        ArrayList<QFilter> configFilters = new ArrayList<QFilter>(16);
        QFilter wfTypef = new QFilter("entryentity.wftype", "=", (Object)wfTypeDyc);
        configFilters.add(wfTypef);
        QFilter wfRecordEntityf = new QFilter("entryentity.wfrecord.number", "=", (Object)wfRecordEntity);
        configFilters.add(wfRecordEntityf);
        configFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Long configId = -1L;
        ArrayList<String> srcBillTypes = new ArrayList<String>(16);
        ArrayList<String> tgtBillTypes = new ArrayList<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_writeoffgroupsetting", (String)"id,entryentity.sbilltypeids as sbilltypeids,entryentity.dbilltypeids as dbilltypeids", (QFilter[])configFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                configId = row.getLong("id");
                String srcBillType = row.getString("sbilltypeids");
                String tgtBillType = row.getString("dbilltypeids");
                srcBillTypes.addAll(Arrays.asList(srcBillType.split(",")));
                tgtBillTypes.addAll(Arrays.asList(tgtBillType.split(",")));
            }
        }
        if (-1L == configId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6838\u9500\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\u3002", (String)"BillGroupWfRelationHelper_0", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        this.config = new WfGroupRelationConfig();
        this.config.setSrcBillTypes(srcBillTypes);
        this.config.setTgtBillTypes(tgtBillTypes);
        QFilter idf = new QFilter("id", "=", (Object)configId);
        this.configDyc = BusinessDataServiceHelper.load((String)"cal_writeoffgroupsetting", (String)"id,costcolumn,costfields", (QFilter[])idf.toArray())[0];
        ArrayList<QFilter> configMainFieldFilters = new ArrayList<QFilter>(16);
        configMainFieldFilters.add(idf);
        HashSet<String> allBillTypes = new HashSet<String>(this.config.getSrcBillTypes().size() + this.config.getTgtBillTypes().size());
        allBillTypes.addAll(this.config.getSrcBillTypes());
        allBillTypes.addAll(this.config.getTgtBillTypes());
        QFilter billTypesf = new QFilter("mfieldentry.billtype.number", "in", allBillTypes);
        configMainFieldFilters.add(billTypesf);
        HashMap<String, String> billMainFieldMap = new HashMap<String, String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_writeoffgroupsetting", (String)"id,costfields,costcolumn,mfieldentry.billtype.number as billtype,mfieldentry.mainfield as mainfield", (QFilter[])configMainFieldFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                billMainFieldMap.put(row.getString("billtype"), row.getString("mainfield"));
                this.config.setSubElements(row.getString("costfields"));
                this.config.setCostColumn(row.getString("costcolumn"));
            }
        }
        this.config.setBillMainFieldMap(billMainFieldMap);
    }

    /*
     * WARNING - void declaration
     */
    private void updateOrAddRelation() {
        void var12_18;
        DynamicObject[] srcBillNum;
        QFilter billTypesf = new QFilter("sourcebill.number", "in", this.config.getBillMainFieldMap().keySet());
        QFilter mainFieldsf = new QFilter("fieldmap.sourcefield", "in", this.config.getBillMainFieldMap().values());
        QFilter enablef = new QFilter("enable", "=", (Object)Boolean.TRUE);
        HashMap calBillBizMainFields = new HashMap(16);
        try (DataSet billRuleDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calbillrule", (String)"calbill.number as calbillnum,sourcebill.number as srcbillnum,fieldmap.calfield as calfield,fieldmap.sourcefield as sourcefield", (QFilter[])new QFilter[]{billTypesf, mainFieldsf, enablef}, null);){
            for (Row row : billRuleDs) {
                String calBillNum = row.getString("calbillnum");
                srcBillNum = row.getString("srcbillnum");
                calBillBizMainFields.putIfAbsent(calBillNum, new HashSet(16));
                Set mainFields = (Set)calBillBizMainFields.get(row.getString("calbillnum"));
                String string = row.getString("calfield");
                String fieldPath = this.getAllFieldPath("cal_costrecord_subentity", string);
                mainFields.add(fieldPath + " as " + string);
                if (!this.config.getBillMainFieldMap().get(srcBillNum).equals(row.getString("sourcefield"))) continue;
                this.config.getBillMainFieldMap().put((String)srcBillNum, string);
            }
        }
        HashMap srcBilEntrylFieldValueMap = new HashMap(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<Long> bizbillIds = new HashSet<Long>(16);
        HashMap<Long, Long> omWfBillEntryIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> omWfSrcEntryIdMap = new HashMap<Long, Long>(16);
        srcBillNum = this.wfRecordDycs;
        int n = srcBillNum.length;
        boolean bl = false;
        while (var12_18 < n) {
            DynamicObject item = srcBillNum[var12_18];
            DynamicObjectCollection wfRecordEntrys = item.getDynamicObjectCollection("entry");
            Long inBillEntryId = null;
            for (Object entryDyc : wfRecordEntrys) {
                entryIds.add(entryDyc.getLong("billentryid"));
                bizbillIds.add(entryDyc.getLong("billid"));
                if (!this.isPurOmWf.booleanValue() || !"im_ospurinbill".equals(entryDyc.getDynamicObject("billtype").getString("number"))) continue;
                inBillEntryId = entryDyc.getLong("billentryid");
            }
            if (inBillEntryId != null) {
                for (Object entryDyc : wfRecordEntrys) {
                    if ("im_ospurinbill".equals(entryDyc.getDynamicObject("billtype").getString("number"))) continue;
                    omWfBillEntryIdMap.put(entryDyc.getLong("billentryid"), inBillEntryId);
                }
            }
            ++var12_18;
        }
        QFilter entryIdsf = new QFilter("entry.bizbillentryid", "in", entryIds);
        entryIdsf.and("bizbillid", "in", bizbillIds);
        for (Map.Entry entry : calBillBizMainFields.entrySet()) {
            QFilter filter = new QFilter("calbilltype", "=", (Object)"IN");
            if (((String)entry.getKey()).equals("cal_outcalbill")) {
                filter = new QFilter("calbilltype", "=", (Object)"OUT");
            }
            filter.and(entryIdsf);
            String selectFields = "calbillid as id,bizentityobject as bizentity,bizbillid,entry.bizbillentryid as bizbillentryid,entry.calentryid as entryid,billno,bizdate,bookdate,entry.material as material,entry.owner as owner,entry.baseqty as baseqty," + StringUtils.join((Collection)((Collection)entry.getValue()), (String)",");
            DataSet calBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])filter.toArray(), null);
            Object object = null;
            try {
                for (Row row : calBillDs) {
                    String billEntity = row.getString("bizentity");
                    String bizBillEntryId = row.getString("bizbillentryid");
                    String key = billEntity + "," + bizBillEntryId;
                    srcBilEntrylFieldValueMap.putIfAbsent(key, new HashMap(16));
                    Map filedValueMap = (Map)srcBilEntrylFieldValueMap.get(key);
                    for (String mainField : calBillDs.getRowMeta().getFieldNames()) {
                        filedValueMap.put(mainField, row.get(mainField));
                        if (!this.isPurOmWf.booleanValue() || !"im_ospurinbill".equals(billEntity) || !this.config.getBillMainFieldMap().get(billEntity).equals(mainField)) continue;
                        omWfSrcEntryIdMap.put(Long.valueOf(bizBillEntryId), (Long)row.get(mainField));
                    }
                }
            }
            catch (Throwable entryDyc) {
                object = entryDyc;
                throw entryDyc;
            }
            finally {
                if (calBillDs == null) continue;
                if (object != null) {
                    try {
                        calBillDs.close();
                    }
                    catch (Throwable entryDyc) {
                        ((Throwable)object).addSuppressed(entryDyc);
                    }
                    continue;
                }
                calBillDs.close();
            }
        }
        if (this.isPurOmWf.booleanValue()) {
            for (Map.Entry entry : omWfBillEntryIdMap.entrySet()) {
                String billEntity = "im_osmaterialreqoutbill";
                Long reqBillEntryId = (Long)entry.getKey();
                Long srcEntryId = (Long)omWfSrcEntryIdMap.get(entry.getValue());
                String key = billEntity + "," + reqBillEntryId;
                Map filedValueMap = (Map)srcBilEntrylFieldValueMap.get(key);
                filedValueMap.put(this.config.getBillMainFieldMap().get(billEntity), srcEntryId);
            }
        }
        for (DynamicObject item : this.wfRecordDycs) {
            DynamicObjectCollection wfRecordEntrys = item.getDynamicObjectCollection("entry");
            for (Object entryDyc : wfRecordEntrys) {
                String key;
                Map filedValueMap;
                String wfBaseQtyField;
                BigDecimal wfBaseQty = entryDyc.getBigDecimal(wfBaseQtyField = "qty");
                if (wfBaseQty.compareTo(BigDecimal.ZERO) == 0 || (filedValueMap = (Map)srcBilEntrylFieldValueMap.get(key = entryDyc.getString("billtype_id") + "," + entryDyc.getString("billentryid"))) == null || filedValueMap.isEmpty()) continue;
                this.createBillGroupInfo(filedValueMap, "baseqty", wfBaseQty, item.getPkValue());
            }
        }
    }

    private String getAllFieldPath(String billEntityNum, String calField) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityNum);
        Map billAllFields = dataEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)billAllFields.get(calField);
        IDataEntityType parentProp = property.getParent();
        return this.getFieldPath(calField, parentProp);
    }

    private String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return this.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    private void createBillGroupInfo(Map<String, Object> filedValueMap, String weightField, BigDecimal wfBaseQty, Object wfRecordId) {
        Long entryId;
        String bizEntity = (String)filedValueMap.get("bizentity");
        String mainField = this.config.getBillMainFieldMap().get(bizEntity);
        String groupValueStr = filedValueMap.get(mainField).toString();
        if (!this.holder.isComtainEntry(this.configDyc, groupValueStr, (entryId = (Long)filedValueMap.get("entryid")).toString() + "," + wfRecordId)) {
            HashMap<String, Object> entry = new HashMap<String, Object>(16);
            if (this.config.getSrcBillTypes().contains(bizEntity)) {
                entry.put("type", "0");
                entry.put("weight", BigDecimal.ONE);
            } else {
                entry.put("type", "1");
                entry.put("weight", filedValueMap.get(weightField));
            }
            entry.put(this.calBillIdKey, filedValueMap.get("id"));
            entry.put(this.calEntryIdKey, entryId);
            entry.put("billno", filedValueMap.get("billno"));
            if (!this.isNewGroupModel.booleanValue()) {
                entry.put("bizdate", filedValueMap.get("bizdate"));
            }
            entry.put("bookdate", filedValueMap.get("bookdate"));
            entry.put("material", filedValueMap.get("material"));
            entry.put("owner", filedValueMap.get("owner"));
            entry.put("islastentry", Boolean.TRUE);
            entry.put("bizbillid", filedValueMap.get("bizbillid"));
            entry.put("baseqty", filedValueMap.get("baseqty"));
            entry.put("occupiedqty", wfBaseQty);
            if (this.isPurOmWf.booleanValue()) {
                entry.put("occupiedqty", wfBaseQty.abs());
            }
            entry.put("groupno", wfRecordId);
            this.holder.addEntry(this.configDyc, groupValueStr, entry);
        }
    }

    private void saveAndSyncCost() {
        this.allValidBizBillids = new HashSet<Long>(16);
        Map<String, DynamicObject> records = this.holder.getGroupRecords();
        Iterator<Map.Entry<String, DynamicObject>> it = records.entrySet().iterator();
        HashSet<Long> bizbillids = new HashSet<Long>();
        boolean isLastEntry = false;
        while (it.hasNext()) {
            Map.Entry<String, DynamicObject> recordEntry = it.next();
            DynamicObject record = recordEntry.getValue();
            HashSet<Long> targetIds = new HashSet<Long>(16);
            HashSet<Long> srcIds = new HashSet<Long>(16);
            DynamicObjectCollection entryCol = record.getDynamicObjectCollection("entryentity");
            if (entryCol.isEmpty()) {
                it.remove();
                continue;
            }
            for (DynamicObject entry : entryCol) {
                if ("1".equals(entry.getString("type"))) {
                    targetIds.add(entry.getLong(this.calEntryIdKey));
                } else {
                    srcIds.add(entry.getLong(this.calEntryIdKey));
                }
                bizbillids.add(entry.getLong("bizbillid"));
                if (isLastEntry) continue;
                isLastEntry = entry.getBoolean("islastentry");
            }
            if (targetIds.isEmpty() || srcIds.isEmpty()) {
                it.remove();
                continue;
            }
            this.deleteRelationGroupRecord(targetIds);
            this.allValidBizBillids.addAll(bizbillids);
            record.set("iscompleted", (Object)true);
            if (!this.isNewGroupModel.booleanValue()) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                this.holder.setGroupRecord(recordEntry.getKey(), BusinessDataServiceHelper.loadSingle((Object)record.getPkValue(), (String)this.groupRecKey));
            }
            bizbillids.clear();
            isLastEntry = false;
        }
    }

    private void deleteRelationGroupRecord(Set<Long> targetIds) {
        if (this.isNewGroupModel.booleanValue()) {
            QFilter filter = new QFilter("entryentity." + this.calBillIdKey, "in", targetIds);
            filter.and("groupsettingtype", "=", (Object)"cal_billgroupsetting");
            DynamicObject[] groupRecords = BusinessDataServiceHelper.load((String)this.groupRecKey, (String)"id", (QFilter[])filter.toArray());
            if (groupRecords == null || groupRecords.length == 0) {
                return;
            }
            HashSet<Long> groupRecordIds = new HashSet<Long>(groupRecords.length);
            for (DynamicObject groupRecord : groupRecords) {
                groupRecordIds.add(groupRecord.getLong("id"));
            }
            new CostDomainGroupHelper().deleteAndUpdateCostDomainGroup(targetIds);
            DeleteServiceHelper.delete((String)this.groupRecKey, (QFilter[])new QFilter("id", "in", groupRecordIds).toArray());
        } else {
            QFilter filter = new QFilter("entryentity.billentryid", "in", targetIds);
            filter.and("groupsettingtype", "=", (Object)"cal_billgroupsetting");
            DynamicObject[] groupRecords = BusinessDataServiceHelper.load((String)"cal_groupbillrecord", (String)"id", (QFilter[])filter.toArray());
            if (groupRecords == null || groupRecords.length == 0) {
                return;
            }
            HashSet<Long> groupRecordIds = new HashSet<Long>(groupRecords.length);
            for (DynamicObject groupRecord : groupRecords) {
                groupRecordIds.add(groupRecord.getLong("id"));
            }
            DeleteServiceHelper.delete((String)"cal_groupbillrecord", (QFilter[])new QFilter("id", "in", groupRecordIds).toArray());
            DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])new QFilter("bizgrouprecordid", "in", groupRecordIds).toArray());
        }
    }
}

