/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class CostAccountGroupRecord {
    private Set<Long> costaccountIds = new HashSet<Long>();
    protected DynamicObject obj;
    private boolean isingroup;
    private Set<String> srcBill = new HashSet<String>();
    private Set<String> targetBill = new HashSet<String>();

    protected CostAccountGroupRecord(Long bizGroupId, Long booktypeid, String groupsettingtype, Long groupsetting, Date updatetime, boolean iscompleted, boolean isingroup, String costcolumn, String costfields) {
        this.obj = BusinessDataServiceHelper.newDynamicObject((String)"cal_account_grouprecord");
        this.obj.set("bizgrouprecordid", (Object)bizGroupId);
        this.obj.set("costaccounttype", (Object)booktypeid);
        this.obj.set("groupsettingtype", (Object)groupsettingtype);
        this.obj.set("groupsetting", (Object)groupsetting);
        this.obj.set("updatetime", (Object)updatetime);
        this.obj.set("iscompleted", (Object)iscompleted);
        this.obj.set("createtime", (Object)new Date());
        this.obj.set("costcolumn", (Object)costcolumn);
        this.obj.set("costfields", (Object)costfields);
        this.isingroup = isingroup;
    }

    protected void addSrcEntry(long costaccountid, long calentryid, long entryid, long period, long materialid, boolean isbeforeperiod, BigDecimal weight, BigDecimal occupiedqty, Long groupno) {
        String key = entryid + "@" + groupno;
        if (this.srcBill.contains(key)) {
            return;
        }
        this.srcBill.add(key);
        this.costaccountIds.add(costaccountid);
        DynamicObject entry = this.createEntry(costaccountid, calentryid, entryid, period, materialid, isbeforeperiod, weight, occupiedqty, groupno);
        entry.set("type", (Object)"0");
    }

    protected void addTargetEntry(long costaccountid, long calentryid, long entryid, long period, long materialid, boolean isbeforeperiod, BigDecimal weight, BigDecimal occupiedqty, Long groupno) {
        String key = entryid + "@" + groupno;
        if (this.targetBill.contains(key)) {
            return;
        }
        this.targetBill.add(key);
        this.costaccountIds.add(costaccountid);
        DynamicObject entry = this.createEntry(costaccountid, calentryid, entryid, period, materialid, isbeforeperiod, weight, occupiedqty, groupno);
        entry.set("type", (Object)"1");
    }

    protected DynamicObject createEntry(long costaccountid, long calentryid, long entryid, long period, long materialId, boolean isbeforeperiod, BigDecimal weight, BigDecimal occupiedqty, Long groupno) {
        DynamicObject entry = this.obj.getDynamicObjectCollection("entryentity").addNew();
        entry.set("calentryid", (Object)calentryid);
        entry.set("costrecordentryid", (Object)entryid);
        entry.set("costaccount", (Object)costaccountid);
        entry.set("period", (Object)period);
        entry.set("isbeforeperiod", (Object)isbeforeperiod);
        entry.set("material", (Object)materialId);
        entry.set("weight", (Object)weight);
        entry.set("occupiedqty", (Object)occupiedqty);
        entry.set("groupno", (Object)groupno);
        return entry;
    }

    protected boolean isValid() {
        if (this.srcBill.isEmpty() || this.targetBill.isEmpty()) {
            return false;
        }
        return this.isingroup || this.costaccountIds.size() <= 1;
    }
}

