/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecord;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDLockHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.DateUtils;

public class CostAccountGroupRecordHelper {
    private static final String UPDATE_ISBEFOREPERIOD = "update t_cal_atgrouprecord_entry set fisbeforeperiod = '1' where fcostaccountid = ? and fperiodid < ?";
    private static final String UPDATE_NOTISBEFOREPERIOD = "update t_cal_atgrouprecord_entry set fisbeforeperiod = '0' where fcostaccountid = ? and fperiodid >= ?";
    public static final int BATCH_SIZE = 100000;
    private static final String QUERY_NOTCREATED_GROUPRECORD = "select fid from t_cal_groupbillrecord where fid not in (select fbizgrouprecordid from t_cal_accountgrouprecord)";
    private static final String QUERY_NOTCREATED_GROUPRECORD_BYTIME_SQL = "select a.fid from t_cal_groupbillrecord  a left join t_cal_accountgrouprecord b on a.fid = b.fbizgrouprecordid and a.fupdatetime = b.fupdatetime and b.fupdatetime >= ? and b.fupdatetime <= ? where  a.fupdatetime >= ? and a.fupdatetime <= ? and b.fid is null;";
    private static Log log = LogFactory.getLog(CostAccountGroupRecordHelper.class);
    private static final String DLOCK_KEY = "cal_refreshGroupLock#";
    private boolean filterGroupAcct = false;

    public void refreshGroupRecordByTime() {
        Throwable throwable = null;
        try (TXHandle handle = TX.required();){
            HashSet<Long> bizRecordIdSet = new HashSet<Long>(16);
            log.info("\u67e5\u8be2\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u5f00\u59cb");
            List<DbInput> inputs = this.getDbInputs();
            DataSet splitDataSet = Algo.create((String)CostAccountGroupRecordHelper.class.getName()).createDataSet((Input[])inputs.toArray(new DbInput[inputs.size()]));
            for (Row row : splitDataSet) {
                bizRecordIdSet.add(row.getLong("fid"));
            }
            log.info("\u83b7\u53d6\u5f85\u751f\u6210\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u7684id\u5b8c\u6210");
            if (bizRecordIdSet.isEmpty()) {
                return;
            }
            try {
                this.refreshGroupRecordByBiz(bizRecordIdSet);
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    private List<DbInput> getDbInputs() {
        Date nowDate;
        ArrayList<DbInput> inputs = new ArrayList<DbInput>(16);
        Integer splitDay = CalDbParamServiceHelper.getInteger((String)"gen_group_split_day");
        Integer beforeDay = CalDbParamServiceHelper.getInteger((String)"gen_group_start_before_day");
        Date startDate = DateUtils.addDateTime((Date)TimeServiceHelper.now(), (int)5, (int)(0 - beforeDay));
        int diffDay = this.getDateDiffDay(startDate, nowDate = TimeServiceHelper.now());
        int batch = diffDay / splitDay;
        batch = batch == 0 ? 1 : batch;
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("fid", (DataType)DataType.LongType)});
        for (int i = 0; i < batch; ++i) {
            Date curEndDate = DateUtils.addDateTime((Date)startDate, (int)5, (int)splitDay);
            if (i == batch - 1) {
                curEndDate = nowDate;
            }
            Object[] params = new Object[]{startDate, curEndDate, startDate, curEndDate};
            DbInput input = new DbInput(CostAccountGroupRecordHelper.class.getName(), "cal", QUERY_NOTCREATED_GROUPRECORD_BYTIME_SQL, params, rowMeta);
            inputs.add(input);
            startDate = curEndDate;
        }
        return inputs;
    }

    public void repairAndRefreshGroupRecordByTime(Set<String> costAccountIds, Set<String> periodIdStr, Date mindate, Date maxdate) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from (select fid,fcostrecordentryid from t_cal_atgrouprecord_entry where fcostaccountid in (", new Object[0]);
        sql.append(String.join((CharSequence)",", costAccountIds), new Object[0]);
        sql.append(") and fperiodid in (", new Object[0]);
        sql.append(String.join((CharSequence)",", periodIdStr), new Object[0]);
        sql.append(")) t1 left join (select e.fentryid fentryid from t_cal_calcostrecord b join t_cal_calcostrecordentry e on b.fid=e.fid where b.fcostaccountid in (", new Object[0]);
        sql.append(String.join((CharSequence)",", costAccountIds), new Object[0]);
        sql.append(") ", new Object[0]);
        sql.append(" and b.fbookdate <= ? ", new Object[]{new Timestamp(maxdate.getTime())});
        sql.append(" and e.fentrystatus = 'C') t2 on t1.fcostrecordentryid = t2.fentryid where t2.fentryid is null", new Object[0]);
        HashSet<Long> errIds = new HashSet<Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                errIds.add(row.getLong("fid"));
            }
        }
        if (!errIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])new QFilter("id", "in", errIds).toArray());
        }
        this.refreshGroupRecordByTime();
    }

    @Deprecated
    public void refreshGroupRecordByBizRecord() {
        DataSet dataSet = DB.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (DBRoute)new DBRoute("cal"), (String)QUERY_NOTCREATED_GROUPRECORD);
        if (dataSet.isEmpty()) {
            return;
        }
        ArrayList setList = new ArrayList(1024);
        int i = 0;
        int max = 10000;
        HashSet<Long> bizRecordIdSet = new HashSet<Long>(1024);
        setList.add(bizRecordIdSet);
        for (Row row : dataSet) {
            if (i >= max) {
                bizRecordIdSet = new HashSet(1024);
                i = 0;
                setList.add(bizRecordIdSet);
            }
            bizRecordIdSet.add(row.getLong("fid"));
            ++i;
        }
        for (Set set : setList) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                this.refreshGroupRecordByBiz(set);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    public void refreshGroupRecordByCostAccount(Set<Long> costAccountIdSet) {
        if (costAccountIdSet == null || costAccountIdSet.isEmpty()) {
            return;
        }
        try (TXHandle handle = TX.required();){
            try {
                Map map = PeriodHelper.getCurrentPeriods(costAccountIdSet);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    paramList.add(new Object[]{entry.getKey(), ((DynamicObject)entry.getValue()).getLong("id")});
                }
                if (!paramList.isEmpty()) {
                    DBRoute route = new DBRoute("cal");
                    DB.executeBatch((DBRoute)route, (String)UPDATE_ISBEFOREPERIOD, paramList);
                    DB.executeBatch((DBRoute)route, (String)UPDATE_NOTISBEFOREPERIOD, paramList);
                    if (!AcctGroupModelHelper.isNewGroupModel()) {
                        String desc = ResManager.loadKDString((String)"\u7ed3\u8d26\u53cd\u7ed3\u8d26", (String)"CostAccountGroupRecordHelper_6", (String)"fi-cal-business", (Object[])new Object[0]);
                        new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(costAccountIdSet, desc);
                    }
                }
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    public void rebuildAllGroupRecord() {
        try (TXHandle handle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"cal_account_grouprecord", null);
                DataSet bizDataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_groupbillrecord", (String)"id", null, null);
                HashSet<Long> bizRecordIdSet = new HashSet<Long>(16);
                while (bizDataSet.hasNext()) {
                    bizRecordIdSet.add(bizDataSet.next().getLong("id"));
                }
                this.createAccountRecordByBizRecord(false, bizRecordIdSet, Boolean.FALSE, null);
                if (!AcctGroupModelHelper.isNewGroupModel()) {
                    new AutoSortHelperNew().rebuildAllSortResult();
                }
            }
            catch (KDBizException kde) {
                handle.markRollback();
                log.error("CostAccountGroupRecordHelper rebuildAllGroupRecord", (Throwable)kde);
                throw kde;
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    private List<DynamicObject> saveCostGroupRecord(List<DynamicObject> recordObjList) {
        Throwable throwable;
        TXHandle h;
        if (recordObjList == null || recordObjList.isEmpty()) {
            return recordObjList;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(100000);
        Iterator<DynamicObject> it = recordObjList.iterator();
        while (it.hasNext()) {
            if (saveList.size() >= 100000) {
                h = TX.requiresNew();
                throwable = null;
                try {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
                saveList.clear();
            }
            saveList.add(it.next());
        }
        if (!saveList.isEmpty()) {
            h = TX.requiresNew();
            throwable = null;
            try {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        return recordObjList;
    }

    public void refreshGroupRecordByBiz(boolean isDelete, Set<Long> bizRecordIdSet) {
        this.refreshGroupRecordByBiz(isDelete, bizRecordIdSet, null);
    }

    public void refreshGroupRecordByBiz(boolean isDelete, Set<Long> bizRecordIdSet, Set<Long> deleteRecordIds) {
        this.createAccountRecordByBizRecord(isDelete, bizRecordIdSet, Boolean.TRUE, deleteRecordIds);
    }

    public void refreshGroupRecordByBiz(Set<Long> recordIds) {
        this.refreshGroupRecordByBiz(false, recordIds);
    }

    public void refreshGroupRecordByBizWithOutSort(boolean isDelete, Set<Long> bizRecordIdSet) {
        QFilter deleteFilter = new QFilter("bizgrouprecordid", "in", bizRecordIdSet);
        DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])deleteFilter.toArray());
        this.createAccountRecordByBizRecord(isDelete, bizRecordIdSet, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAccountRecordByBizRecord(boolean isDelete, Set<Long> bizRecordIds, Boolean isSort, Set<Long> deleteRecordIds) {
        if (bizRecordIds.isEmpty()) {
            return;
        }
        log.info("createAccountRecordByBizRecord.bizRecordIds.size:" + bizRecordIds.size());
        int batchSize = AcctGroupModelHelper.isNewGroupModel() ? CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.GENACTGROUP_BATCHSIZE) : 999999999;
        try (DLock lock = null;
             TXHandle handle = TX.required();){
            if (!isDelete) {
                lock = DLock.createReentrant((String)(DLOCK_KEY + CacheKeyUtil.getAcctId()));
                CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(lock));
                if (!lock.tryLock()) {
                    ErrorCode errorCode = new ErrorCode("refresActGroupRunning", ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u5237\u65b0\u6210\u7ec4\u5173\u7cfb\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CostAccountGroupRecordHelper_2", (String)"fi-cal-business", (Object[])new Object[0]));
                    throw new KDBizException(errorCode, new Object[0]);
                }
            }
            Set<Long> isReturnBillSetting = this.getIsReturnBillGroupBillSetting();
            RowMeta rowMeta = ORM.create().createRowMeta("cal_groupbillrecord", "id,groupsettingtype,groupsetting,costcolumn,costfields,iscompleted,updatetime,entryentity.type as type,entryentity.billentryid as calentryid,entryentity.bizbillid as bizbillid,entryentity.occupiedqty as occupiedqty,entryentity.weight as weight,entryentity.groupno as groupno");
            Lists.partition(new ArrayList<Long>(bizRecordIds), (int)batchSize).forEach(list -> {
                DataSet bizDataSet = null;
                if (list.size() >= 500000) {
                    HashSet<Long> partIds = new HashSet<Long>(16);
                    ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
                    for (Long bizRecordId : list) {
                        partIds.add(bizRecordId);
                        if (partIds.size() < 500000) continue;
                        OrmInput input = new OrmInput(CostAccountGroupRecordHelper.class.getName(), "cal_groupbillrecord", "id,groupsettingtype,groupsetting,costcolumn,costfields,iscompleted,updatetime,entryentity.type as type,entryentity.billentryid as calentryid,entryentity.bizbillid as bizbillid,entryentity.occupiedqty as occupiedqty,entryentity.weight as weight,entryentity.groupno as groupno", new QFilter("id", "in", partIds).toArray(), rowMeta);
                        inputs.add(input);
                        partIds = new HashSet(500000);
                    }
                    if (!partIds.isEmpty()) {
                        OrmInput input = new OrmInput(CostAccountGroupRecordHelper.class.getName(), "cal_groupbillrecord", "id,groupsettingtype,groupsetting,costcolumn,costfields,iscompleted,updatetime,entryentity.type as type,entryentity.billentryid as calentryid,entryentity.bizbillid as bizbillid,entryentity.occupiedqty as occupiedqty,entryentity.weight as weight,entryentity.groupno as groupno", new QFilter("id", "in", partIds).toArray(), rowMeta);
                        inputs.add(input);
                    }
                    bizDataSet = Algo.create((String)CostAccountGroupRecordHelper.class.getName()).createDataSet(inputs.toArray(new Input[inputs.size()]));
                } else {
                    bizDataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_groupbillrecord", (String)"id,groupsettingtype,groupsetting,costcolumn,costfields,iscompleted,updatetime,entryentity.type as type,entryentity.billentryid as calentryid,entryentity.bizbillid as bizbillid,entryentity.occupiedqty as occupiedqty,entryentity.weight as weight,entryentity.groupno as groupno", (QFilter[])new QFilter("id", "in", list).toArray(), null);
                }
                DataSet bizDataSetCopy = bizDataSet.copy();
                HashSet<Long> calEntryIdSet = new HashSet<Long>(16);
                HashSet<Long> bizBillIdSet = new HashSet<Long>(16);
                HashSet<Long> bizBillAllIdSet = new HashSet<Long>(16);
                ArrayList<Input> inputs = new ArrayList<Input>(4);
                QFilter recordFilter = new QFilter("issplitcreate", "=", (Object)false);
                while (bizDataSetCopy.hasNext()) {
                    Row row = bizDataSetCopy.next();
                    if (calEntryIdSet.size() >= 100000) {
                        Input input = this.getCostRecordDataSet(calEntryIdSet, recordFilter, bizBillIdSet);
                        inputs.add(input);
                        calEntryIdSet = new HashSet(100000);
                        bizBillIdSet = new HashSet(100000);
                    }
                    calEntryIdSet.add(row.getLong("calentryid"));
                    bizBillIdSet.add(row.getLong("bizbillid"));
                    bizBillAllIdSet.add(row.getLong("bizbillid"));
                }
                if (!calEntryIdSet.isEmpty()) {
                    Input input = this.getCostRecordDataSet(calEntryIdSet, recordFilter, bizBillIdSet);
                    inputs.add(input);
                }
                if (!inputs.isEmpty()) {
                    DataSet costRecordSet = Algo.create((String)CostAccountGroupRecordHelper.class.getName()).createDataSet(inputs.toArray(new Input[0]));
                    DataSet accountGroupRecordSet = bizDataSet.join(costRecordSet, JoinType.INNER).on("calentryid", "calentryid").select(new String[]{"id", "groupsettingtype", "groupsetting", "costfields", "costcolumn", "iscompleted", "updatetime", "type", "calentryid", "weight", "occupiedqty", "groupno"}, new String[]{"costaccount", "booktype", "isingroup", "period", "entryid", "materialid", "accounttype"}).finish().orderBy(new String[]{"id", "booktype"});
                    HashMap<String, CostAccountGroupRecord> recordMap = new HashMap<String, CostAccountGroupRecord>();
                    HashMap<Long, Long> currentPeriodCache = new HashMap<Long, Long>();
                    while (accountGroupRecordSet.hasNext()) {
                        Row row = accountGroupRecordSet.next();
                        Long bizGroupId = row.getLong("id");
                        Long booktype = row.getLong("booktype");
                        Long materialid = row.getLong("materialid");
                        String key = bizGroupId + "&" + booktype;
                        CostAccountGroupRecord record = (CostAccountGroupRecord)recordMap.get(key);
                        if (record == null) {
                            record = new CostAccountGroupRecord(bizGroupId, booktype, row.getString("groupsettingtype"), row.getLong("groupsetting"), row.getDate("updatetime"), row.getBoolean("iscompleted"), row.getBoolean("isingroup"), row.getString("costcolumn"), row.getString("costfields"));
                            recordMap.put(key, record);
                        }
                        Long costAccountId = row.getLong("costaccount");
                        Long period = row.getLong("period");
                        Long currentPeriod = (Long)currentPeriodCache.get(costAccountId);
                        if (currentPeriod == null) {
                            DynamicObject currentPeriodObj = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                            if (currentPeriodObj == null) {
                                currentPeriod = 0L;
                                currentPeriodCache.put(costAccountId, 0L);
                            } else {
                                currentPeriod = currentPeriodObj.getLong("id");
                                currentPeriodCache.put(costAccountId, currentPeriod);
                            }
                        }
                        Long calentryid = row.getLong("calentryid");
                        Long entryid = row.getLong("entryid");
                        String type = row.getString("type");
                        BigDecimal weight = row.getBigDecimal("weight");
                        BigDecimal occupiedqty = row.getBigDecimal("occupiedqty");
                        Long groupno = row.getLong("groupno");
                        String accounttype = row.getString("accounttype");
                        Long groupSettingId = row.getLong("groupsetting");
                        if ("0".equals(type)) {
                            record.addSrcEntry(costAccountId, calentryid, entryid, period, materialid, period.compareTo(currentPeriod) < 0, weight, occupiedqty, groupno);
                            continue;
                        }
                        if ("D".equals(accounttype) && isReturnBillSetting.contains(groupSettingId)) continue;
                        record.addTargetEntry(costAccountId, calentryid, entryid, period, materialid, period.compareTo(currentPeriod) < 0, weight, occupiedqty, groupno);
                    }
                    ArrayList<DynamicObject> recordObjList = new ArrayList<DynamicObject>(recordMap.size());
                    for (Object record : recordMap.values()) {
                        boolean isNotDel;
                        boolean bl = isNotDel = deleteRecordIds == null || !deleteRecordIds.contains(((CostAccountGroupRecord)record).obj.getLong("bizgrouprecordid"));
                        if (!((CostAccountGroupRecord)record).isValid() || !isNotDel) continue;
                        recordObjList.add(((CostAccountGroupRecord)record).obj);
                    }
                    HashSet<Long> ids = new HashSet<Long>(16);
                    for (Long id : list) {
                        ids.add(id);
                    }
                    if (isSort.booleanValue()) {
                        if (!AcctGroupModelHelper.isNewGroupModel()) {
                            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizBillAllIdSet)});){
                                ctx.set();
                                AutoSortHelperNew autoSortHelperNew = new AutoSortHelperNew();
                                autoSortHelperNew.setFilterGroupAcct(this.filterGroupAcct);
                                autoSortHelperNew.refreshSortResult(ids, recordObjList);
                            }
                        } else {
                            this.saveCostGroupRecord(recordObjList);
                        }
                    } else {
                        this.saveCostGroupRecord(recordObjList);
                    }
                }
            });
        }
    }

    public Set<Long> getIsReturnBillGroupBillSetting() {
        HashSet<Long> isReturnBillSettings = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_billgroupsetting", (String)"id", (QFilter[])new QFilter("isreturnbill", "=", (Object)true).toArray(), null);){
            for (Row row : dataSet) {
                isReturnBillSettings.add(row.getLong("id"));
            }
        }
        return isReturnBillSettings;
    }

    private Input getCostRecordDataSet(Set<Long> calEntryIdSet, QFilter recordFilter, Set<Long> bizBillIdSet) {
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        recordFilter.and(billStatusf);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(recordFilter);
        OrmInput input = new OrmInput(CostAccountGroupRecordHelper.class.getName(), "cal_costrecord", "costaccount,costaccount.booktype as booktype,costaccount.booktype.isingroup as isingroup,period,entry.id as entryid,entry.calentryid as calentryid,entry.material as materialid,entry.accounttype as accounttype", recordFilter.copy().and("entry.calentryid", "in", calEntryIdSet).and("bizbillid", "in", bizBillIdSet).toArray());
        return input;
    }

    public void setFilterGroupAcct(boolean filterGroupAcct) {
        this.filterGroupAcct = filterGroupAcct;
    }

    private int getDateDiffDay(Date minPeriodStartDate, Date nowDate) {
        return (int)((nowDate.getTime() - minPeriodStartDate.getTime()) / 86400000L);
    }
}

