/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostDomainKeyHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.BatchExcuteHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CostDomainGroupHelper {
    public static final int BATCH_IN_SIZE = 500000;
    private static Log log = LogFactory.getLog(CostDomainGroupHelper.class);
    private static String[] DBAlias = new String[]{"fcalrangeid", "fdividebasis", "fcaldimension", "faccounttype", "fdividebasisval", "fcaldimensionval"};
    private List<String> allDimFields = new ArrayList<String>(16);
    private Map<String, Object> defValueMap = new HashMap<String, Object>(16);
    private List<String> dimensionFields = new ArrayList<String>(16);
    private String insertCostDomainSql = null;
    private static String insertCostDomainGroupSql = "INSERT INTO t_cal_costdomaingroup (fid,fdimensionkey,fsdimensionkey,ftdimensionkey,fsdimensionid,ftdimensionid,fcount,fsortid,fsmaterialid,ftmaterialid,fsperiodid,ftperiodid,fissamematerial,fisdiffdomain)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String updateCostDomainGroupSql = "UPDATE T_CAL_COSTDOMAINGROUP SET FCOUNT = FCOUNT+? WHERE fdimensionkey = ?";
    private static String resetCostDomainGroupSql = "UPDATE T_CAL_COSTDOMAINGROUP SET FCOUNT = 0 WHERE fid = ?";
    private Set<Long> emptyEntryCalrange = null;
    private CostDomainKeyHelper costDomainKeyHelper = new CostDomainKeyHelper();
    private List<String> costDomainList = this.costDomainKeyHelper.getCostDomainList();
    private BizGroupRecordBuilder bizGroupRecordBuilder = new BizGroupRecordBuilder(Collections.singletonMap("needAfterGroup", false));
    private Boolean isSort = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_SORT);
    private Set<Long> acctIds = null;
    private boolean filterGroupAcct = false;

    public CostDomainGroupHelper() {
        this.initSqlAndFields();
    }

    public void deleteAndUpdateCostDomainGroupByBizBill(Map<String, Set<Long>> formId2BizbillidMap) {
        if (!this.isSort.booleanValue()) {
            return;
        }
        if (formId2BizbillidMap == null || formId2BizbillidMap.isEmpty()) {
            return;
        }
        DataSet groupInfoDS = this.getRelationDataSetByBiz(formId2BizbillidMap);
        if (groupInfoDS == null) {
            return;
        }
        Set<String> deleteGroupKeys = this.deleteCostDomaimGroup(groupInfoDS);
        this.delete4Sort(deleteGroupKeys);
    }

    public void insertAndUpdateCostDomainGroupByBizBill(Map<String, Set<Long>> formId2BizbillidMap) {
        if (!this.isSort.booleanValue()) {
            return;
        }
        if (formId2BizbillidMap == null || formId2BizbillidMap.isEmpty()) {
            return;
        }
        DataSet groupInfoDS = this.getRelationDataSetByBiz(formId2BizbillidMap);
        if (groupInfoDS == null) {
            return;
        }
        Set<Long> newGroupIds = this.createCostDomaimGroup(groupInfoDS, false);
        if (!newGroupIds.isEmpty()) {
            new AutoSortServic().sortByAsync(newGroupIds);
        }
    }

    private DataSet getRelationDataSetByBiz(Map<String, Set<Long>> formId2BizbillidMap) {
        DataSet groupRecord = this.getBizGroupJoinRecDs(formId2BizbillidMap);
        HashSet<Long> orginBizBillids = new HashSet<Long>(16);
        if (formId2BizbillidMap != null) {
            for (Map.Entry<String, Set<Long>> mapEntry : formId2BizbillidMap.entrySet()) {
                Set<Long> bizBillids = mapEntry.getValue();
                orginBizBillids.addAll(bizBillids);
            }
        }
        return this.getS2TDataSet(orginBizBillids, groupRecord, "bizbillid");
    }

    private DataSet getBizGroupJoinRecDs(Map<String, Set<Long>> formId2BizbillidMap) {
        DataSet bgRecordDS = this.getBizGroupDs(formId2BizbillidMap);
        DataSet groupRecord = null;
        groupRecord = formId2BizbillidMap != null && formId2BizbillidMap.size() == 1 ? this.getAccGroupJoinCostRecordDSNotUseCurrency(bgRecordDS) : this.getAccGroupJoinCostRecordDSUseCurrency(bgRecordDS);
        return groupRecord;
    }

    private DataSet getBizGroupDs(Map<String, Set<Long>> formId2BizbillidMap) {
        DataSet bgRecordDS = null;
        bgRecordDS = formId2BizbillidMap == null || formId2BizbillidMap.isEmpty() ? this.bizGroupRecordBuilder.getAllGroupRecordDataSetByCostAccount(null) : this.bizGroupRecordBuilder.getAllGroupRecordDataSetByBizBillIds(formId2BizbillidMap);
        return bgRecordDS;
    }

    private DataSet getS2TDataSet(Set<Long> orginBizBillids, DataSet groupRecord, String bizbillid) {
        if (groupRecord == null) {
            return null;
        }
        DataSet[] records = groupRecord.splitByFilter(new String[]{"type = '0'", "type = '1'"}, false);
        DataSet srcRecord = records[0];
        DataSet targetRecord = records[1];
        ArrayList<String> joinSortFields = new ArrayList<String>(this.allDimFields);
        joinSortFields.add("calrange");
        joinSortFields.add("accounttype");
        joinSortFields.add("dividebasis");
        joinSortFields.add("caldimension");
        joinSortFields.add("bookdate");
        joinSortFields.add("auditdate");
        joinSortFields.add(bizbillid);
        List<String> groupFieldList = this.getGroupFields(joinSortFields);
        List<String> srcFieldList = this.changeFieldTail(joinSortFields, "_s");
        List<String> targetFieldList = this.changeFieldTail(joinSortFields, "_t");
        DataSet finalSet = srcRecord.join(targetRecord, JoinType.INNER).on("id", "id").select(srcFieldList.toArray(new String[srcFieldList.size()]), targetFieldList.toArray(new String[targetFieldList.size()])).finish();
        if (orginBizBillids != null && !orginBizBillids.isEmpty()) {
            finalSet = finalSet.where(new QFilter(bizbillid + "_s", "in", orginBizBillids).or(bizbillid + "_t", "in", orginBizBillids).toString());
        }
        groupFieldList.remove("calbillid_s");
        groupFieldList.remove("calbillid_t");
        groupFieldList.remove("bizbillid_s");
        groupFieldList.remove("bizbillid_t");
        groupFieldList.remove("bookdate_s");
        groupFieldList.remove("bookdate_t");
        groupFieldList.remove("auditdate_s");
        groupFieldList.remove("auditdate_t");
        finalSet = finalSet.groupBy(groupFieldList.toArray(new String[groupFieldList.size()])).count("count").min("bookdate_s").min("bookdate_t").min("auditdate_s").min("auditdate_t").finish();
        finalSet = finalSet.orderBy(new String[]{"bookdate_s", "bookdate_t", "auditdate_s", "auditdate_t"});
        return finalSet;
    }

    public void insertAndUpdateCostDomainGroup(Set<Long> calBillIds, Set<Long> calentryIds) {
        if (!this.isSort.booleanValue()) {
            return;
        }
        DataSet groupInfoDS = this.getRelationDataSet(calBillIds, calentryIds);
        if (groupInfoDS == null) {
            return;
        }
        Set<Long> newGroupIds = this.createCostDomaimGroup(groupInfoDS, false);
        if (!newGroupIds.isEmpty()) {
            new AutoSortServic().sortByAsync(newGroupIds);
        }
    }

    public void deleteAndUpdateCostDomainGroup(Set<Long> calBillIds) {
        if (!this.isSort.booleanValue()) {
            return;
        }
        DataSet groupInfoDS = this.getRelationDataSet(calBillIds, null);
        if (groupInfoDS == null) {
            return;
        }
        Set<String> deleteGroupKeys = this.deleteCostDomaimGroup(groupInfoDS);
        this.delete4Sort(deleteGroupKeys);
    }

    public void rebuildCostDomainGroup() {
        if (!this.isSort.booleanValue()) {
            return;
        }
        log.info("\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u5f00\u59cb");
        try (TXHandle handle = TX.required();){
            try (AlgoContext context = Algo.newContext();){
                DataSet groupInfoDS = AcctGroupModelHelper.isBizGroupModel() ? this.getBizGroupDs(null) : this.getAcctGroupDs(null, null);
                if (groupInfoDS == null) {
                    return;
                }
                this.deleteAllCostDomainGroup();
                Integer batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.REBUILD_DOMAIN_SIZE);
                if (batchSize > 0) {
                    groupInfoDS = groupInfoDS.orderBy(new String[]{"groupid"});
                    DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(groupInfoDS.getRowMeta());
                    int count = 0;
                    String beforeGroupId = null;
                    for (Row row : groupInfoDS) {
                        String curGroupId = row.getString("groupid");
                        builder.append(row);
                        boolean groupIdDiff = beforeGroupId != null && !beforeGroupId.equals(curGroupId);
                        beforeGroupId = curGroupId;
                        if (!groupIdDiff || ++count <= batchSize) continue;
                        this.createDomainByBatch(builder);
                        builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(groupInfoDS.getRowMeta());
                        count = 0;
                        beforeGroupId = null;
                    }
                    if (count > 0) {
                        this.createDomainByBatch(builder);
                    }
                } else {
                    groupInfoDS = this.getAccGroupJoinCostRecordDSUseCurrency(groupInfoDS);
                    groupInfoDS = this.getS2TDataSet(null, groupInfoDS, "bizbillid");
                    this.createCostDomaimGroup(groupInfoDS, true);
                }
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u5f02\u5e38", e);
                throw e;
            }
            finally {
                log.info("\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u7ed3\u675f");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebuildCostDomainGroupByAcctIds(Set<Long> acctIds) {
        Iterator iterator;
        String beforeGroupId;
        int count;
        DataSetBuilder builder;
        Integer batchSize;
        DataSet groupInfoDS;
        if (!this.isSort.booleanValue()) {
            return;
        }
        this.setAcctIds(acctIds);
        log.info("\u6309\u8d26\u7c3f\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u5f00\u59cb==>{}", acctIds);
        if (!this.isRebuildByAcctId()) {
            return;
        }
        try (TXHandle handle = TX.required();){
            try (AlgoContext context = Algo.newContext();){
                if (AcctGroupModelHelper.isBizGroupModel()) {
                    HashMap<Long, Set<Object>> costAcctIdMatIdsMap = new HashMap<Long, Set<Object>>(16);
                    for (Long acctId : acctIds) {
                        costAcctIdMatIdsMap.put(acctId, null);
                    }
                    groupInfoDS = this.bizGroupRecordBuilder.getAllGroupRecordDataSetByCostAccount(costAcctIdMatIdsMap);
                } else {
                    groupInfoDS = this.getAcctGroupDs(null, null);
                }
                if (groupInfoDS == null) {
                    return;
                }
                this.deleteAllCostDomainGroupByAccIds(acctIds);
                batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.REBUILD_DOMAIN_SIZE);
                if (batchSize <= 0) {
                    groupInfoDS = this.getAccGroupJoinCostRecordDSUseCurrency(groupInfoDS);
                    if ((groupInfoDS = this.getS2TDataSet(null, groupInfoDS, "bizbillid")) == null) {
                        return;
                    }
                    this.createCostDomaimGroup(groupInfoDS, true);
                    return;
                }
                groupInfoDS = groupInfoDS.orderBy(new String[]{"groupid"});
                builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(groupInfoDS.getRowMeta());
                count = 0;
                beforeGroupId = null;
                iterator = groupInfoDS.iterator();
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u5f02\u5e38", e);
                throw e;
            }
            finally {
                log.info("\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u7ed3\u675f");
            }
        }
        while (true) {
            if (!iterator.hasNext()) {
                if (count <= 0) return;
                this.createDomainByBatch(builder);
                return;
            }
            Row row = (Row)iterator.next();
            String curGroupId = row.getString("groupid");
            builder.append(row);
            boolean groupIdDiff = beforeGroupId != null && !beforeGroupId.equals(curGroupId);
            beforeGroupId = curGroupId;
            if (!groupIdDiff || ++count <= batchSize) continue;
            this.createDomainByBatch(builder);
            builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(groupInfoDS.getRowMeta());
            count = 0;
            beforeGroupId = null;
        }
    }

    private boolean isRebuildByAcctId() {
        return this.acctIds != null;
    }

    private void createDomainByBatch(DataSetBuilder builder) {
        try (TraceSpan span = Tracer.create((String)"CostDomainGroupHelper.createDomainByBatch", (String)"createDomainByBatch");){
            DataSet curGroupDs = builder.build();
            curGroupDs = this.getAccGroupJoinCostRecordDSUseCurrency(curGroupDs);
            curGroupDs = this.getS2TDataSet(null, curGroupDs, "bizbillid");
            this.createCostDomaimGroup(curGroupDs, true);
        }
    }

    private void deleteAllCostDomainGroup() {
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"TRUNCATE TABLE T_CAL_COSTDOMAIN");
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"TRUNCATE TABLE T_CAL_COSTDOMAINGROUP");
        }
    }

    private void deleteAllCostDomainGroupByAccIds(Set<Long> acctIds) {
        if (!this.isRebuildByAcctId()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            QFilter groupDomainAcctFilter = new QFilter("sdimension.costaccount", "in", acctIds);
            int batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.DOMAIN_DELETE_SIZE);
            BatchExcuteHelper.batchDelete((String)"cal_costdomaingroup", (QFilter)groupDomainAcctFilter, (int)batchSize, (boolean)true);
            QFilter domainAcctFilter = new QFilter("costaccount", "in", acctIds);
            BatchExcuteHelper.batchDelete((String)"cal_costdomain", (QFilter)domainAcctFilter, (int)batchSize, (boolean)true);
        }
    }

    private void delete4Sort(Set<String> deleteGroupKeys) {
        if (deleteGroupKeys.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("count", "<=", (Object)0);
        filter.and("dimensionkey", "in", deleteGroupKeys);
        HashSet<Long> deleteGroupIds = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costdomaingroup", (String)"id", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                deleteGroupIds.add(row.getLong("id"));
            }
        }
        if (!deleteGroupIds.isEmpty()) {
            new AutoSortServic().sortByAsync(deleteGroupIds);
        }
    }

    private Set<String> deleteCostDomaimGroup(DataSet groupInfoDS) {
        StringBuilder dimensionStr = new StringBuilder();
        ArrayList<Object[]> updateCostDomainGroupParams = new ArrayList<Object[]>(16);
        int size = 8 + this.dimensionFields.size();
        HashSet<String> deleteGroupKeys = new HashSet<String>(16);
        for (Row row : groupInfoDS) {
            Object[] srcParams = this.getInsertParams(dimensionStr, size, row, "_s");
            Object[] destParams = this.getInsertParams(dimensionStr, size, row, "_t");
            String sKey = (String)srcParams[1];
            String tKey = (String)destParams[1];
            Long count = 0L - row.getLong("count");
            String gKey = CostDomainGroupHelper.getSHA256Base64Str(sKey + tKey);
            deleteGroupKeys.add(gKey);
            updateCostDomainGroupParams.add(new Object[]{count, gKey});
        }
        if (!updateCostDomainGroupParams.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostDomainGroupSql, updateCostDomainGroupParams);
        }
        return deleteGroupKeys;
    }

    private Set<Long> createCostDomaimGroup(DataSet groupInfoDS, boolean isRebuildAll) {
        StringBuilder dimensionStr = new StringBuilder();
        HashMap<String, Object[]> insertCostDomainParamMap = new HashMap<String, Object[]>(16);
        HashMap<String, Object[]> insertCostDomainGroupParamMap = new HashMap<String, Object[]>(16);
        ArrayList<Object[]> updateCostDomainGroupParams = new ArrayList<Object[]>(16);
        int size = 8 + this.dimensionFields.size();
        HashSet<Long> newGroupIds = new HashSet<Long>(16);
        HashSet<Long> allNewGroupIds = new HashSet<Long>(16);
        IDGenerator idGenerator = new IDGenerator("t_cal_costdomaingroup");
        for (Row row : groupInfoDS) {
            Object[] destParams;
            String tKey;
            Object[] srcParams = this.getInsertParams(dimensionStr, size, row, "_s");
            String sKey = (String)srcParams[1];
            if (sKey.equals(tKey = (String)(destParams = this.getInsertParams(dimensionStr, size, row, "_t"))[1])) continue;
            insertCostDomainParamMap.put(sKey, srcParams);
            insertCostDomainParamMap.put(tKey, destParams);
            Long count = row.getLong("count");
            Long speriodid = 0L;
            Long tperiodid = 0L;
            Long smaterialid = row.getLong("material_s");
            Long tmaterialid = row.getLong("material_t");
            boolean isSamaMaterial = smaterialid.compareTo(tmaterialid) == 0;
            boolean isDiffDomain = this.isDiffDomain(srcParams, destParams, row);
            String gKey = CostDomainGroupHelper.getSHA256Base64Str(sKey + tKey);
            if (!insertCostDomainGroupParamMap.containsKey(gKey)) {
                Long id = idGenerator.getId();
                newGroupIds.add(id);
                insertCostDomainGroupParamMap.put(gKey, new Object[]{id, gKey, sKey, tKey, 0, 0, 0, 0, smaterialid, tmaterialid, speriodid, tperiodid, isSamaMaterial, isDiffDomain});
            }
            updateCostDomainGroupParams.add(new Object[]{count, gKey});
            if (insertCostDomainParamMap.size() < 100000) continue;
            this.saveCostDomainAndGroups(isRebuildAll, insertCostDomainParamMap, insertCostDomainGroupParamMap, updateCostDomainGroupParams, newGroupIds);
            allNewGroupIds.addAll(newGroupIds);
            insertCostDomainParamMap.clear();
            insertCostDomainGroupParamMap.clear();
            updateCostDomainGroupParams.clear();
            newGroupIds.clear();
        }
        if (!insertCostDomainParamMap.isEmpty()) {
            this.saveCostDomainAndGroups(isRebuildAll, insertCostDomainParamMap, insertCostDomainGroupParamMap, updateCostDomainGroupParams, newGroupIds);
            allNewGroupIds.addAll(newGroupIds);
        }
        return allNewGroupIds;
    }

    private boolean isDiffDomain(Object[] srcParams, Object[] destParams, Row row) {
        Long speriodid = row.getLong("period_s");
        Long tperiodid = row.getLong("period_t");
        Long smaterialid = row.getLong("material_s");
        Long tmaterialid = row.getLong("material_t");
        Long sCalRange = (Long)srcParams[2];
        Long tCalRange = (Long)destParams[2];
        String sdividebasisval = (String)srcParams[6];
        String tdividebasisval = (String)destParams[6];
        String scaldimensionval = (String)srcParams[7];
        String tcaldimensionval = (String)destParams[7];
        boolean isDiffDomain = smaterialid.compareTo(tmaterialid) != 0 || speriodid.compareTo(tperiodid) != 0 || sCalRange.compareTo(tCalRange) != 0 || !scaldimensionval.equals(tcaldimensionval) || sCalRange.compareTo(tCalRange) == 0 && this.emptyEntryCalrange.contains(sCalRange) && !sdividebasisval.equals(tdividebasisval);
        return isDiffDomain;
    }

    private void saveCostDomainAndGroups(boolean isRebuildAll, Map<String, Object[]> insertCostDomainParamMap, Map<String, Object[]> insertCostDomainGroupParamMap, List<Object[]> updateCostDomainGroupParams, Set<Long> newGroupIds) {
        HashMap<String, Long> key2IdMap = new HashMap<String, Long>(16);
        boolean success = this.insertToDB("cal_costdomain", insertCostDomainParamMap, this.insertCostDomainSql, key2IdMap, true, newGroupIds);
        if (!success) {
            this.insertToDB("cal_costdomain", insertCostDomainParamMap, this.insertCostDomainSql, key2IdMap, false, newGroupIds);
        }
        this.resolveInsertParams(key2IdMap, insertCostDomainGroupParamMap);
        key2IdMap.clear();
        success = this.insertToDB("cal_costdomaingroup", insertCostDomainGroupParamMap, insertCostDomainGroupSql, key2IdMap, true, newGroupIds);
        if (!success) {
            success = this.insertToDB("cal_costdomaingroup", insertCostDomainGroupParamMap, insertCostDomainGroupSql, key2IdMap, false, newGroupIds);
        }
        updateCostDomainGroupParams.sort(new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ((String)o1[1]).compareTo((String)o2[1]);
            }
        });
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostDomainGroupSql, updateCostDomainGroupParams);
        if (isRebuildAll) {
            newGroupIds.clear();
        } else {
            newGroupIds.retainAll(key2IdMap.values());
        }
    }

    private void resolveInsertParams(Map<String, Long> key2IdMap, Map<String, Object[]> insertCostDomainGroupParamMap) {
        for (Object[] value : insertCostDomainGroupParamMap.values()) {
            value[4] = key2IdMap.get(value[2]);
            value[5] = key2IdMap.get(value[3]);
        }
    }

    private boolean insertToDB(String calEntity, Map<String, Object[]> insertParamMap, String insertSql, Map<String, Long> key2IdMap, boolean isFirst, Set<Long> newGroupIds) {
        String selects = "";
        if ("cal_costdomaingroup".equals(calEntity)) {
            selects = ",count";
        }
        QFilter filter = new QFilter("dimensionkey", "in", insertParamMap.keySet());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)calEntity, (String)("id,dimensionkey" + selects), (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long count;
                Long id = row.getLong("id");
                String key = row.getString("dimensionkey");
                insertParamMap.remove(key);
                key2IdMap.put(key, id);
                if (!"cal_costdomaingroup".equals(calEntity) || (count = row.getLong("count")).compareTo(0L) != 0) continue;
                newGroupIds.add(id);
            }
        }
        if (insertParamMap.isEmpty()) {
            return true;
        }
        try {
            var10_11 = null;
            try (TXHandle h = TX.requiresNew();){
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                for (Object[] value : insertParamMap.values()) {
                    params.add(value);
                }
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)insertSql, params);
            }
            catch (Throwable params) {
                var10_11 = params;
                throw params;
            }
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            log.error("\u4fdd\u5b58\u6210\u672c\u57df\u7ef4\u5ea6\u62a5\u9519:", (Object)exceptionStackTraceMessage);
            if (exceptionStackTraceMessage.contains("SQLIntegrityConstraintViolationException") || exceptionStackTraceMessage.contains("duplicate key")) {
                if (isFirst) {
                    return false;
                }
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u672c\u57df\u7ef4\u5ea6\u62a5\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"CostDomainGroupHelper_0", (String)"fi-cal-business", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            throw e;
        }
        for (Object[] value : insertParamMap.values()) {
            key2IdMap.put((String)value[1], (Long)value[0]);
        }
        return true;
    }

    private Object[] getInsertParams(StringBuilder dimensionStr, int size, Row row, String tailMark) {
        Object[] params = new Object[size];
        String dividebasis = row.getString("dividebasis" + tailMark);
        String caldimension = row.getString("caldimension" + tailMark);
        dividebasis = this.trimComma(dividebasis);
        caldimension = this.trimComma(caldimension);
        Long calrange = row.getLong("calrange" + tailMark);
        boolean isEmptyCalrange = this.emptyEntryCalrange.contains(calrange);
        params[2] = calrange;
        params[3] = dividebasis;
        params[4] = caldimension;
        params[5] = row.get("accounttype" + tailMark);
        if (isEmptyCalrange) {
            this.getDimensionValueStr(dimensionStr, row, dividebasis, tailMark);
            params[6] = dimensionStr.toString();
        } else {
            params[6] = "";
        }
        this.getDimensionValueStr(dimensionStr, row, caldimension, tailMark);
        params[7] = dimensionStr.toString();
        this.costDomainKeyHelper.setCalDimensionValue((String)params[7]);
        this.costDomainKeyHelper.setCalrange(calrange);
        this.costDomainKeyHelper.setCostaccount(row.getLong("costaccount" + tailMark));
        this.costDomainKeyHelper.setDivideBasisValue((String)params[6]);
        this.costDomainKeyHelper.setMaterial(row.getLong("material" + tailMark));
        params[0] = DB.genLongId((String)"t_cal_costdomain");
        params[1] = this.costDomainKeyHelper.getCostDomainDimsionKey();
        int index = 8;
        for (String dimField : this.allDimFields) {
            if (this.costDomainList.contains(dimField) || isEmptyCalrange && dividebasis.contains(dimField) || caldimension.contains(dimField) || "calorg".equals(dimField)) {
                params[index++] = row.get(dimField + tailMark);
                continue;
            }
            params[index++] = this.defValueMap.get(dimField);
        }
        return params;
    }

    private void getDimensionValueStr(StringBuilder dimensionStr, Row row, String dividebasis, String tailMark) {
        dimensionStr.delete(0, dimensionStr.length());
        for (String dim : dividebasis.split(",")) {
            if (StringUtils.isEmpty((String)dim)) continue;
            Object value = row.get(dim + tailMark);
            if (value == null || "".equals(value)) {
                value = "#";
            }
            dimensionStr.append(value);
            dimensionStr.append("_");
        }
    }

    private String trimComma(String dividebasis) {
        if (dividebasis == null) {
            return "";
        }
        if (dividebasis.startsWith(",")) {
            dividebasis = dividebasis.substring(1);
        }
        if (dividebasis.endsWith(",")) {
            dividebasis = dividebasis.substring(0, dividebasis.length() - 1);
        }
        return dividebasis;
    }

    private void initSqlAndFields() {
        String divideFieldsStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionFieldsStr = CommonSettingHelper.getCalDimensionStr();
        this.allDimFields.addAll(Arrays.asList((divideFieldsStr + "," + caldimensionFieldsStr).split(",")));
        this.allDimFields.add("costaccount");
        this.allDimFields.add("period");
        this.allDimFields.add("material");
        this.allDimFields.sort(Comparator.naturalOrder());
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costdomain");
        Map allFieldPropertys = entityType.getAllFields();
        StringBuilder insertSqlBuilder = new StringBuilder();
        insertSqlBuilder.append("INSERT INTO t_cal_costdomain (fid,fdimensionkey");
        for (String dimField : this.allDimFields) {
            IDataEntityProperty dbField = (IDataEntityProperty)allFieldPropertys.get(dimField);
            if (dbField == null) {
                String msg = ResManager.loadKDString((String)"\u5982\u679c\u4f7f\u7528\u4e8c\u5f00\u5b57\u6bb5\u4f5c\u4e3a\u5212\u5206\u4f9d\u636e\u6216\u8005\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u8fdb\u5165\u201c\u5f00\u53d1\u5e73\u53f0>\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u51fa\u5e93\u6838\u7b97>\u6210\u672c\u57df\u7ef4\u5ea6\u201d\uff0c\u6309\u8981\u6c42\u6dfb\u52a0\u76f8\u5e94\u5b57\u6bb5\u3002", (String)"CostDomainGroupHelper_1", (String)"fi-cal-business", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            this.dimensionFields.add(dbField.getAlias());
            if (dbField instanceof BasedataProp) {
                this.defValueMap.put(dbField.getName(), 0L);
                continue;
            }
            if (dbField instanceof TextProp) {
                this.defValueMap.put(dbField.getName(), "");
                continue;
            }
            if (dbField instanceof TimeProp) {
                this.defValueMap.put(dbField.getName(), null);
                continue;
            }
            if (dbField instanceof FieldProp) {
                this.defValueMap.put(dbField.getName(), ((FieldProp)dbField).getDefValue());
                continue;
            }
            if (!(dbField instanceof ComboProp)) continue;
            this.defValueMap.put(dbField.getName(), "");
        }
        insertSqlBuilder.append(",");
        insertSqlBuilder.append(String.join((CharSequence)",", DBAlias));
        insertSqlBuilder.append(",");
        insertSqlBuilder.append(String.join((CharSequence)",", this.dimensionFields));
        insertSqlBuilder.append(")VALUES(");
        Object[] questionMarks = new String[8 + this.dimensionFields.size()];
        Arrays.fill(questionMarks, "?");
        insertSqlBuilder.append(String.join((CharSequence)",", (CharSequence[])questionMarks));
        insertSqlBuilder.append(")");
        this.insertCostDomainSql = insertSqlBuilder.toString();
        this.emptyEntryCalrange = new HashSet<Long>(16);
        QFilter calrangeFilter = new QFilter("enable", "=", (Object)true);
        calrangeFilter.and("status", "=", (Object)"C");
        Map calranges = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])calrangeFilter.toArray());
        if (calranges == null || calranges.isEmpty()) {
            return;
        }
        for (DynamicObject calrange : calranges.values()) {
            DynamicObjectCollection entry = calrange.getDynamicObjectCollection("entry");
            if (entry != null && !entry.isEmpty()) continue;
            this.emptyEntryCalrange.add(calrange.getLong("id"));
        }
        this.costDomainList.sort(Comparator.naturalOrder());
    }

    private DataSet getRelationDataSet(Set<Long> calBillIds, Set<Long> calentryIds) {
        DataSet groupRecord = this.getAcctGroupJoinRecDs(calBillIds, calentryIds);
        return this.getS2TDataSet(calBillIds, groupRecord, "calbillid");
    }

    private DataSet getAcctGroupJoinRecDs(Set<Long> calBillIds, Set<Long> calentryIds) {
        DataSet groupRecord = calBillIds == null || calBillIds.size() >= 500000 ? this.createDataSetUseCurrency(calBillIds, calentryIds) : this.createDataSetNotUseCurrency(calBillIds, calentryIds);
        return groupRecord;
    }

    private DataSet createDataSetNotUseCurrency(Set<Long> calBillIds, Set<Long> calentryIds) {
        QFilter defFilter = new QFilter("entryentity.isbeforeperiod", "=", (Object)false);
        if (calBillIds != null && !calBillIds.isEmpty()) {
            defFilter.and("entryentity.calbillid", "in", calBillIds);
        }
        if (calentryIds != null && !calentryIds.isEmpty()) {
            defFilter.and("entryentity.calentryid", "in", calentryIds);
        }
        new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("entryentity.costaccount", defFilter, this.filterGroupAcct);
        DataSet groupRecord = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id,costaccounttype,costaccounttype.isingroup,entryentity.costaccount", (QFilter[])defFilter.toArray(), null);
        HashSet<Long> groupRecordIds = new HashSet<Long>(16);
        HashSet<Long> costAccountids = new HashSet<Long>(4);
        HashSet<Long> inGroupCostAccountTypes = new HashSet<Long>(4);
        for (Row row : groupRecord) {
            groupRecordIds.add(row.getLong("id"));
            if (row.getBoolean("costaccounttype.isingroup").booleanValue()) {
                inGroupCostAccountTypes.add(row.getLong("costaccounttype"));
                continue;
            }
            costAccountids.add(row.getLong("entryentity.costaccount"));
        }
        if (groupRecordIds.isEmpty()) {
            return null;
        }
        QFilter newfilter = new QFilter("id", "in", groupRecordIds);
        groupRecord = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id as groupid,entryentity.bookdate as bookdate,entryentity.type as type,entryentity.calentryid as calentryid,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period,entryentity.isbeforeperiod as isbeforeperiod", (QFilter[])newfilter.toArray(), null);
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.NEED_AFTER_GROUP).booleanValue()) {
            DataSet costAccountPeriodDS = this.getCostAccountPeriodDS(inGroupCostAccountTypes, costAccountids);
            groupRecord = groupRecord.join(costAccountPeriodDS, JoinType.INNER).on("costaccount", "costaccount").on("period", "period").select(groupRecord.getRowMeta().getFieldNames(), null).finish();
        }
        groupRecord = this.getAccGroupJoinCostRecordDSNotUseCurrency(groupRecord);
        return groupRecord;
    }

    private DataSet getCostAccountPeriodDS(Set<Long> inGroupCostAccountTypes, Set<Long> costAccountids) {
        DataSet ds;
        if (!inGroupCostAccountTypes.isEmpty()) {
            QFilter filter = new QFilter("booktype", "in", inGroupCostAccountTypes);
            filter.and("enable", "=", (Object)"1");
            ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray(), null);
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    costAccountids.add(row.getLong("id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        Map currentPeriod2EnableCostAccountMap = PeriodHelper.getCurrentPeriod2EnableCostAccountMap(costAccountids);
        ds = this.getResolveCostAccountCurPeriodDS(currentPeriod2EnableCostAccountMap);
        return ds;
    }

    private DataSet getResolveCostAccountCurPeriodDS(Map<Long, Set<Long>> currentPeriod2EnableCostAccountMap) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("costaccount", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType)});
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Set<Long>> entry : currentPeriod2EnableCostAccountMap.entrySet()) {
            Long period = entry.getKey();
            Set<Long> costAccountids = entry.getValue();
            for (Long costAccountid : costAccountids) {
                builder.append(new Object[]{costAccountid, period});
            }
        }
        return builder.build();
    }

    private DataSet getAccGroupJoinCostRecordDSNotUseCurrency(DataSet groupRecord) {
        HashSet<Long> crEntryIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        Date maxDate = null;
        Date minDate = null;
        DataSet groupRecordCopy = groupRecord.copy();
        for (Row row : groupRecordCopy) {
            boolean isbeforeperiod = row.getBoolean("isbeforeperiod");
            if (isbeforeperiod) continue;
            Date bookdate = row.getDate("bookdate");
            costAccountIds.add(row.getLong("costaccount"));
            crEntryIds.add(row.getLong("costrecordentryid"));
            if (bookdate == null) continue;
            if (maxDate == null || maxDate.before(bookdate)) {
                maxDate = bookdate;
            }
            if (minDate != null && !minDate.after(bookdate)) continue;
            minDate = bookdate;
        }
        QFilter costRecordFilter = new QFilter("entry.id", "in", crEntryIds);
        costRecordFilter.and("costaccount", "in", costAccountIds);
        costRecordFilter.and("bookdate", ">=", minDate);
        costRecordFilter.and("bookdate", "<=", maxDate);
        costRecordFilter.and("billstatus", "=", (Object)"C");
        new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", costRecordFilter, this.filterGroupAcct);
        DataSet costRecordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)("calbillid,bizbillid,entry.id as entryid,entry.calrange as calrange,entry.accounttype as accounttype,entry.caldimension.caldimension as caldimension,costaccount.dividebasis.dividebasis as dividebasis,bookdate,auditdate," + this.getCostRecordQueryStr()), (QFilter[])costRecordFilter.toArray(), null);
        groupRecord = groupRecord.join(costRecordSet, JoinType.INNER).on("costrecordentryid", "entryid").select(new String[]{"groupid id", "type"}, costRecordSet.getRowMeta().getFieldNames()).finish();
        return groupRecord;
    }

    private DataSet createDataSetUseCurrency(Set<Long> calBillIds, Set<Long> calentryIds) {
        DataSet groupRecord = this.getAcctGroupDs(calBillIds, calentryIds);
        if (groupRecord == null) {
            return null;
        }
        groupRecord = this.getAccGroupJoinCostRecordDSUseCurrency(groupRecord);
        return groupRecord;
    }

    private DataSet getAcctGroupDs(Set<Long> calBillIds, Set<Long> calentryIds) {
        QFilter defFilter = new QFilter("entryentity.isbeforeperiod", "=", (Object)false);
        if (calBillIds != null && !calBillIds.isEmpty()) {
            defFilter.and("entryentity.calbillid", "in", calBillIds);
        }
        if (calentryIds != null && !calentryIds.isEmpty()) {
            defFilter.and("entryentity.calentryid", "in", calentryIds);
        }
        if (this.isRebuildByAcctId()) {
            defFilter.and("entryentity.costaccount", "in", this.acctIds);
        }
        new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("entryentity.costaccount", defFilter, this.filterGroupAcct);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        Map period2CostAccountMap = Collections.emptyMap();
        Boolean needAfterGroup = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.NEED_AFTER_GROUP);
        if (!needAfterGroup.booleanValue()) {
            period2CostAccountMap = PeriodHelper.getCurrentPeriod2EnableCostAccountMap(null);
            for (Map.Entry entry : period2CostAccountMap.entrySet()) {
                Long period = (Long)entry.getKey();
                Set costAccountids = (Set)entry.getValue();
                QFilter filter = new QFilter("entryentity.costaccount", "in", (Object)costAccountids);
                filter.and("entryentity.period", "=", (Object)period);
                filter.and(defFilter);
                OrmInput input = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", "id", filter.toArray());
                inputs.add(input);
            }
        }
        DataSet groupRecord = null;
        groupRecord = inputs.isEmpty() ? QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])defFilter.toArray(), null) : Algo.create((String)this.getClass().getName()).createDataSet(inputs.toArray(new Input[0]));
        HashSet<Long> groupRecordIds = new HashSet<Long>(16);
        ArrayList<OrmInput> partList = new ArrayList<OrmInput>(16);
        for (Row row : groupRecord) {
            groupRecordIds.add(row.getLong("id"));
            if (groupRecordIds.size() < 500000) continue;
            QFilter newfilter = new QFilter("id", "in", groupRecordIds);
            OrmInput input = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", "id as groupid,entryentity.bookdate as bookdate,entryentity.type as type,entryentity.calentryid as calentryid,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period,entryentity.isbeforeperiod as isbeforeperiod", newfilter.toArray());
            partList.add(input);
            groupRecordIds = new HashSet(500000);
        }
        if (!groupRecordIds.isEmpty()) {
            QFilter newfilter = new QFilter("id", "in", groupRecordIds);
            OrmInput input = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", "id as groupid,entryentity.bookdate as bookdate,entryentity.type as type,entryentity.calentryid as calentryid,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period,entryentity.isbeforeperiod as isbeforeperiod", newfilter.toArray());
            partList.add(input);
        }
        if (partList.isEmpty()) {
            return null;
        }
        groupRecord = Algo.create((String)this.getClass().getName()).createDataSet(partList.toArray(new Input[partList.size()])).orderBy(new String[]{"costaccount", "period"});
        if (!needAfterGroup.booleanValue()) {
            DataSet costAccountPeriodDS = this.getResolveCostAccountCurPeriodDS(period2CostAccountMap);
            groupRecord = groupRecord.join(costAccountPeriodDS, JoinType.INNER).on("costaccount", "costaccount").on("period", "period").select(groupRecord.getRowMeta().getFieldNames(), null).finish();
        }
        return groupRecord;
    }

    private DataSet getAccGroupJoinCostRecordDSUseCurrency(DataSet groupRecord) {
        HashSet<Long> crEntryIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        Date maxDate = null;
        Date minDate = null;
        Long prePeriodId = null;
        DataSet groupRecordCopy = groupRecord.copy();
        ArrayList<Input> crPartList = new ArrayList<Input>(16);
        for (Row row : groupRecordCopy) {
            boolean isbeforeperiod = row.getBoolean("isbeforeperiod");
            if (isbeforeperiod) continue;
            Date bookdate = row.getDate("bookdate");
            Long curPeriodId = row.getLong("period");
            if (bookdate == null) continue;
            if (prePeriodId != null && prePeriodId.compareTo(curPeriodId) != 0) {
                this.addInputs(crEntryIds, costAccountIds, maxDate, minDate, crPartList);
                crEntryIds = new HashSet(500000);
                costAccountIds = new HashSet(16);
                maxDate = null;
                minDate = null;
                prePeriodId = curPeriodId;
            }
            costAccountIds.add(row.getLong("costaccount"));
            crEntryIds.add(row.getLong("costrecordentryid"));
            if (maxDate == null || maxDate.before(bookdate)) {
                maxDate = bookdate;
            }
            if (minDate == null || minDate.after(bookdate)) {
                minDate = bookdate;
            }
            if (crEntryIds.size() < 500000) continue;
            this.addInputs(crEntryIds, costAccountIds, maxDate, minDate, crPartList);
            crEntryIds = new HashSet(500000);
            costAccountIds = new HashSet(16);
            maxDate = null;
            minDate = null;
        }
        if (!crEntryIds.isEmpty()) {
            this.addInputs(crEntryIds, costAccountIds, maxDate, minDate, crPartList);
        }
        if (crPartList.isEmpty()) {
            return null;
        }
        DataSet costRecordSet = Algo.create((String)this.getClass().getName()).createDataSet(crPartList.toArray(new Input[crPartList.size()]));
        groupRecord = groupRecord.join(costRecordSet, JoinType.INNER).on("costrecordentryid", "entryid").select(new String[]{"groupid id", "type"}, costRecordSet.getRowMeta().getFieldNames()).finish();
        return groupRecord;
    }

    private void addInputs(Set<Long> crEntryIds, Set<Long> costAccountIds, Date maxDate, Date minDate, List<Input> crPartList) {
        QFilter costRecordFilter = new QFilter("entry.id", "in", crEntryIds);
        costRecordFilter.and("costaccount", "in", costAccountIds);
        costRecordFilter.and("bookdate", ">=", (Object)minDate);
        costRecordFilter.and("bookdate", "<=", (Object)maxDate);
        new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", costRecordFilter, this.filterGroupAcct);
        costRecordFilter.and("billstatus", "=", (Object)"C");
        OrmInput input = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", "calbillid,bizbillid,entry.id as entryid,entry.calrange as calrange,entry.accounttype as accounttype,entry.caldimension.caldimension as caldimension,costaccount.dividebasis.dividebasis as dividebasis,bookdate,auditdate," + this.getCostRecordQueryStr(), costRecordFilter.toArray());
        crPartList.add((Input)input);
    }

    private List<String> getGroupFields(List<String> joinSortFields) {
        ArrayList<String> fieldList = new ArrayList<String>(16);
        for (String field : joinSortFields) {
            fieldList.add(field + "_s");
            fieldList.add(field + "_t");
        }
        return fieldList;
    }

    private String getCostRecordQueryStr() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        StringBuilder sb = new StringBuilder();
        for (String field : this.allDimFields) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5c5e\u6027%2$s", (String)"AutoSortHelper_2", (String)"fi-cal-business", (Object[])new Object[0]), entityType.getName(), field);
                throw new KDBizException(msg);
            }
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            if (isEntryProp) {
                sb.append(" as ");
                sb.append(field);
            }
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private List<String> changeFieldTail(List<String> joinSortFields, String tail) {
        ArrayList<String> fieldList = new ArrayList<String>(joinSortFields.size());
        for (String field : joinSortFields) {
            fieldList.add(field + " as " + field + tail);
        }
        return fieldList;
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }

    public void setAcctIds(Set<Long> acctIds) {
        Map associationCostAccountNameMap = AccountingSysHelper.getAssociationCostAccountNameMap(acctIds);
        acctIds = associationCostAccountNameMap.keySet();
        this.acctIds = acctIds;
    }

    public Set<Long> getAcctIds() {
        return this.acctIds;
    }

    public void setFilterGroupAcct(boolean filterGroupAcct) {
        this.filterGroupAcct = filterGroupAcct;
        this.bizGroupRecordBuilder.setFilterGroupAcct(filterGroupAcct);
    }
}

