/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class GroupCompletedHelper {
    private static final Log logger = LogFactory.getLog(GroupCompletedHelper.class);
    private static final String REFRESH_ACCOUNTGROUPRECORD = "update t_cal_accountgrouprecord set fiscompleted = ? where fbizgrouprecordid = ?";
    private static final String REFRESH_ACCOUNTGROUPRECORD_BYFID = "update t_cal_accountgrouprecord set fiscompleted = ? where fid = ?";
    private static final String REFRESH_GROUPRECORD = "update t_cal_groupbillrecord set fiscompleted = ? where fid = ?";

    public static void updateGroupRecord(Set<Long> trueCalEntryIds, Set<Long> falseCalEntryIds) {
        if ((trueCalEntryIds == null || trueCalEntryIds.isEmpty()) && (falseCalEntryIds == null || falseCalEntryIds.isEmpty())) {
            return;
        }
        HashSet<Long> calEntryIdSet = new HashSet<Long>((trueCalEntryIds == null ? 0 : trueCalEntryIds.size()) + (falseCalEntryIds == null ? 0 : falseCalEntryIds.size()));
        if (trueCalEntryIds != null) {
            calEntryIdSet.addAll(trueCalEntryIds);
        }
        if (falseCalEntryIds != null) {
            calEntryIdSet.addAll(falseCalEntryIds);
        }
        DynamicObject[] groupRecordCol = BusinessDataServiceHelper.load((String)AcctGroupModelHelper.getGroupRecKey(), (String)("iscompleted,entryentity." + AcctGroupModelHelper.getCalEntryIdKey() + ",entryentity.bizbillid,entryentity.islastentry,entryentity.type,entryentity.baseqty,entryentity.ischargeoffed"), (QFilter[])new QFilter("entryentity." + AcctGroupModelHelper.getCalEntryIdKey(), "in", calEntryIdSet).toArray(), (String)"id");
        GroupCompletedHelper.resolveAndSaveRecord(trueCalEntryIds, falseCalEntryIds, groupRecordCol, null, null);
    }

    private static void resolveAndSaveRecord(Set<Long> trueCalEntryIds, Set<Long> falseCalEntryIds, DynamicObject[] groupRecordCol, Set<Long> chargeoffTrueIds, Set<Long> chargeoffFalseIds) {
        if (groupRecordCol == null || groupRecordCol.length == 0) {
            return;
        }
        Set<Long> transinChargeoffedIds = GroupCompletedHelper.getTransinChargeoffedIds(Arrays.asList(groupRecordCol));
        ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(groupRecordCol.length);
        for (DynamicObject groupRecord : groupRecordCol) {
            boolean iscompleted;
            boolean hasLastEntry = false;
            DynamicObjectCollection recordEntryCol = groupRecord.getDynamicObjectCollection("entryentity");
            HashSet<Long> bizBillIdSet = new HashSet<Long>(recordEntryCol.size());
            BigDecimal srcQty = BigDecimal.ZERO;
            BigDecimal destQty = BigDecimal.ZERO;
            boolean destHasPos = false;
            boolean destHasNeg = false;
            boolean hasChargeOff = false;
            for (DynamicObject recordEntry : recordEntryCol) {
                Long bizbillid = recordEntry.getLong("bizbillid");
                bizBillIdSet.add(bizbillid);
                Long billEntryId = recordEntry.getLong(AcctGroupModelHelper.getCalEntryIdKey());
                if (trueCalEntryIds != null && trueCalEntryIds.contains(billEntryId)) {
                    recordEntry.set("islastentry", (Object)true);
                }
                if (falseCalEntryIds != null && falseCalEntryIds.contains(billEntryId)) {
                    recordEntry.set("islastentry", (Object)false);
                }
                boolean bl = hasLastEntry = hasLastEntry || recordEntry.getBoolean("islastentry");
                if (chargeoffTrueIds != null && chargeoffTrueIds.contains(bizbillid)) {
                    recordEntry.set("ischargeoffed", (Object)true);
                }
                if (chargeoffFalseIds != null && chargeoffFalseIds.contains(bizbillid)) {
                    recordEntry.set("ischargeoffed", (Object)false);
                }
                boolean ischargeoffed = recordEntry.getBoolean("ischargeoffed");
                BigDecimal baseqty = recordEntry.getBigDecimal("baseqty");
                if ("1".equals(recordEntry.getString("type"))) {
                    if (baseqty.signum() > 0) {
                        destHasPos = true;
                    } else if (baseqty.signum() < 0) {
                        destHasNeg = true;
                    }
                }
                if (recordEntry.getString("type").equals("1") && ischargeoffed) {
                    if (!transinChargeoffedIds.contains(bizbillid)) continue;
                    hasChargeOff = true;
                }
                if (recordEntry.getString("type").equals("1")) {
                    destQty = destQty.add(baseqty);
                    continue;
                }
                srcQty = srcQty.add(baseqty);
            }
            boolean bl = iscompleted = hasLastEntry || destQty.abs().compareTo(srcQty.abs()) >= 0 || bizBillIdSet.size() <= 1;
            if (destHasNeg && destHasPos) {
                iscompleted = false;
            }
            if (bizBillIdSet.size() > 1 && hasChargeOff) {
                iscompleted = false;
            }
            WriteLogHelper.writeInfoLog((Log)logger, (String)("iscompleted\uff1a" + iscompleted + "hasLastEntry\uff1a" + hasLastEntry + "destQty\uff1a" + destQty + "srcQty\uff1a" + srcQty + "bizBillIdSet.size()\uff1a" + bizBillIdSet.size()), (Object[])new Object[0]);
            updateObjs.add(new Object[]{iscompleted ? "1" : "0", groupRecord.getLong("id")});
        }
        SaveServiceHelper.save((DynamicObject[])groupRecordCol);
        if (!AcctGroupModelHelper.isNewGroupModel()) {
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)REFRESH_GROUPRECORD, updateObjs);
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)REFRESH_ACCOUNTGROUPRECORD, updateObjs);
        } else {
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)REFRESH_ACCOUNTGROUPRECORD_BYFID, updateObjs);
        }
    }

    private static Set<Long> getTransinChargeoffedIds(List<DynamicObject> records) {
        HashSet<Long> transinChargeoffedIds = new HashSet<Long>(4);
        HashSet<Long> chargeoffedIds = new HashSet<Long>(4);
        for (DynamicObject record : records) {
            DynamicObjectCollection entryCol = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryCol) {
                String type = entryRow.getString("type");
                boolean ischargeoffed = entryRow.getBoolean("ischargeoffed");
                if (!ischargeoffed || !"1".equals(type)) continue;
                chargeoffedIds.add(entryRow.getLong("bizbillid"));
            }
        }
        if (!chargeoffedIds.isEmpty()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)GroupCompletedHelper.class.getName(), (String)"im_transinbill", (String)"id", (QFilter[])new QFilter("id", "in", chargeoffedIds).toArray(), null);){
                for (Row row : ds) {
                    transinChargeoffedIds.add(row.getLong("id"));
                }
            }
        }
        return transinChargeoffedIds;
    }

    public static Set<Long> updateCalBill(Long bizEntryId, boolean isCompleted, DynamicObject[] calBillArr) {
        HashSet<Long> calBillEntryIdSet = new HashSet<Long>();
        if (calBillArr == null || calBillArr.length == 0) {
            return calBillEntryIdSet;
        }
        for (DynamicObject calBill : calBillArr) {
            for (DynamicObject calEntry : calBill.getDynamicObjectCollection("entry")) {
                if (!calEntry.get("bizbillentryid").equals(bizEntryId)) continue;
                calBillEntryIdSet.add(calEntry.getLong("id"));
                calEntry.set("islastentry", (Object)isCompleted);
            }
        }
        SaveServiceHelper.save((DynamicObject[])calBillArr);
        return calBillEntryIdSet;
    }

    public static Set<Long> updateCalBill(Set<Long> bizEntryIds, boolean isComplete, DynamicObject[] calBillArr) {
        return GroupCompletedHelper.updateCalBill(bizEntryIds, isComplete, calBillArr, true);
    }

    public static Set<Long> updateCalBill(Set<Long> bizEntryIds, boolean isComplete, DynamicObject[] calBillArr, boolean isCheckBillStatus) {
        if (isCheckBillStatus) {
            calBillArr = GroupCompletedHelper.removeUnAuditBill(calBillArr);
        }
        HashSet<Long> calBillEntryIdSet = new HashSet<Long>();
        if (calBillArr == null || calBillArr.length == 0) {
            return calBillEntryIdSet;
        }
        for (DynamicObject calBill : calBillArr) {
            for (DynamicObject calEntry : calBill.getDynamicObjectCollection("entry")) {
                if (!bizEntryIds.contains(calEntry.get("bizbillentryid"))) continue;
                calBillEntryIdSet.add(calEntry.getLong("id"));
                calEntry.set("islastentry", (Object)isComplete);
            }
        }
        SaveServiceHelper.save((DynamicObject[])calBillArr);
        return calBillEntryIdSet;
    }

    public static DynamicObject[] removeUnAuditBill(DynamicObject[] calBillArr) {
        HashMap<Long, DynamicObject> calBillIdDycMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject calBillDyc : calBillArr) {
            bizBillIds.add(calBillDyc.getLong("bizbillid"));
            calBillIdDycMap.put(calBillDyc.getLong("id"), calBillDyc);
        }
        QFilter bizBillIdFilter = new QFilter("bizbillid", "in", bizBillIds);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"C");
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)GroupCompletedHelper.class.getName(), (String)"cal_costrecord", (String)"calbillid,bizbillid,billstatus", (QFilter[])new QFilter[]{bizBillIdFilter, billStatusFilter}, null);){
            for (Row row : costRecordDs) {
                calBillIdDycMap.remove(row.getLong("calbillid"));
            }
        }
        calBillArr = calBillIdDycMap.values().toArray(new DynamicObject[0]);
        return calBillArr;
    }

    public static void updateGroupRecord4Chargeoff(Set<Long> chargeoffTrueIds, Set<Long> chargeoffFalseIds) {
        if ((chargeoffTrueIds == null || chargeoffTrueIds.isEmpty()) && (chargeoffFalseIds == null || chargeoffFalseIds.isEmpty())) {
            return;
        }
        HashSet<Long> bizbillids = new HashSet<Long>(16);
        if (chargeoffTrueIds != null) {
            bizbillids.addAll(chargeoffTrueIds);
        }
        if (chargeoffFalseIds != null) {
            bizbillids.addAll(chargeoffFalseIds);
        }
        QFilter filter = new QFilter("entryentity.bizbillid", "in", bizbillids);
        DynamicObject[] groupRecordCol = BusinessDataServiceHelper.load((String)AcctGroupModelHelper.getGroupRecKey(), (String)("iscompleted,entryentity." + AcctGroupModelHelper.getCalEntryIdKey() + ",entryentity.bizbillid,entryentity.islastentry,entryentity.type,entryentity.baseqty,entryentity.ischargeoffed"), (QFilter[])filter.toArray(), (String)"id");
        GroupCompletedHelper.resolveAndSaveRecord(null, null, groupRecordCol, chargeoffTrueIds, chargeoffFalseIds);
    }
}

