/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;

public class GroupRelationCostCalculator {
    private static String srcSuffix = "src";
    private static final String destSuffix = "dest";

    public static Map<String, BigDecimal> calculateCost(Object costAccountId, long periodId, Set<Long> calentryids) {
        DynamicObject[] groupRecords;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        HashMap<Long, DynamicObject> policyIdDycMap = new HashMap<Long, DynamicObject>(16);
        if (AcctGroupModelHelper.isBizGroupModel()) {
            if (costAccountId instanceof String) {
                costAccountId = Long.valueOf(costAccountId.toString());
            }
            String entityName = "bd_period";
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicObject periodDyc = BusinessDataServiceHelper.loadSingle((Object)periodId, (DynamicObjectType)type);
            Date beginDate = periodDyc.getDate("begindate");
            Date endDate = periodDyc.getDate("enddate");
            QFilter costRecordFilter = new QFilter("costaccount", "=", costAccountId);
            costRecordFilter.and("bookdate", ">=", (Object)beginDate);
            costRecordFilter.and("bookdate", "<=", (Object)endDate);
            costRecordFilter.and("period", "=", (Object)periodId);
            costRecordFilter.and("entry.calentryid", "in", calentryids);
            HashMap<String, Set<Long>> formId2BizbillidMap = new HashMap<String, Set<Long>>(4);
            boolean isIngroup = false;
            Long booktype = 0L;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)GroupRelationCostCalculator.class.getName(), (String)"cal_costrecord", (String)"costaccount.booktype,costaccount.booktype.isingroup,bizentityobject,bizbillid", (QFilter[])costRecordFilter.toArray(), null);){
                for (Object row : dataSet) {
                    String formid = row.getString("bizentityobject");
                    Long l = row.getLong("bizbillid");
                    Set bizbillids = formId2BizbillidMap.computeIfAbsent(formid, k -> new HashSet(16));
                    bizbillids.add(l);
                    isIngroup = row.getBoolean("costaccount.booktype.isingroup");
                    booktype = row.getLong("costaccount.booktype");
                }
            }
            groupRecords = new BizGroupRecordBuilder().getAllGroupRecordByBizBillIds(formId2BizbillidMap);
            HashSet<Long> wfGroupSettingIds = new HashSet<Long>(4);
            DynamicObject[] dynamicObjectArray = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)GroupRelationCostCalculator.class.getName(), (String)"cal_writeoffgroupsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, null);){
                for (Row row : ds) {
                    wfGroupSettingIds.add(row.getLong("id"));
                }
            }
            catch (Throwable row) {
                dynamicObjectArray = row;
                throw row;
            }
            if (groupRecords != null && groupRecords.length > 0) {
                HashSet<DynamicObject> filterGroupRecords = new HashSet<DynamicObject>(16);
                for (DynamicObject dynamicObject : groupRecords) {
                    Long settingid = dynamicObject.getLong("groupsetting_id");
                    if (wfGroupSettingIds.contains(settingid)) continue;
                    if (isIngroup) {
                        if (booktype.compareTo(dynamicObject.getLong("costaccounttype_id")) != 0) continue;
                        filterGroupRecords.add(dynamicObject);
                        continue;
                    }
                    DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
                    if (entry == null || entry.size() <= 1 || ((Long)costAccountId).compareTo(((DynamicObject)entry.get(0)).getLong("costaccount_id")) != 0) continue;
                    filterGroupRecords.add(dynamicObject);
                }
                groupRecords = filterGroupRecords.toArray(new DynamicObject[0]);
            }
        } else {
            QFilter groupRecordFilter = new QFilter("entryentity." + AcctGroupModelHelper.getCalEntryIdKey(), "in", calentryids);
            groupRecordFilter.and("groupsettingtype", "=", (Object)"cal_billgroupsetting");
            groupRecords = BusinessDataServiceHelper.load((String)AcctGroupModelHelper.getGroupRecKey(), (String)("id,iscompleted,groupsettingtype,groupsetting,costfields,costcolumn,entryentity." + AcctGroupModelHelper.getCalEntryIdKey() + ",entryentity.type,entryentity.baseqty,entryentity.weight,entryentity.bizbillid"), (QFilter[])groupRecordFilter.toArray());
        }
        if (groupRecords == null || groupRecords.length == 0) {
            return resultMap;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"calpolicy.currency,calpolicy.exratetable,calpolicy.convertmode,booktype");
        Set<Object> sameTypeCostAccount = GroupRelationCostCalculator.getSameTypeCostAccount(costAccount);
        Map<String, GroupRow> acctIdCalEntryIdRowMap = GroupRelationCostCalculator.cacheGroupRows(groupRecords, costAccount);
        for (DynamicObject groupRecord : groupRecords) {
            String[] groupElementIds = groupRecord.getString("costfields").split(",");
            String groupColumnStr = groupRecord.getString("costcolumn");
            if (groupColumnStr.startsWith(",")) {
                groupColumnStr = groupColumnStr.substring(1);
            }
            String[] groupColumns = groupColumnStr.split(",");
            List<String> elementList = Arrays.asList(groupElementIds);
            List<String> columnList = Arrays.asList(groupColumns);
            HashMap<Long, BigDecimal> srcCalBillEntryIdMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> destCalBillEntryIdMap = new HashMap<Long, BigDecimal>();
            for (DynamicObject recordEntry : groupRecord.getDynamicObjectCollection("entryentity")) {
                if ("0".equals(recordEntry.getString("type"))) {
                    srcCalBillEntryIdMap.put(recordEntry.getLong(AcctGroupModelHelper.getCalEntryIdKey()), recordEntry.getBigDecimal("baseqty"));
                    continue;
                }
                destCalBillEntryIdMap.put(recordEntry.getLong(AcctGroupModelHelper.getCalEntryIdKey()), recordEntry.getBigDecimal("weight"));
            }
            HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
            BigDecimal srcTotalQty = BigDecimal.ZERO;
            BigDecimal destTotalWeight = BigDecimal.ZERO;
            HashMap<Long, BigDecimal> destBillQtyMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> destBillWeightMap = new HashMap<Long, BigDecimal>();
            Long srcCurrencyId = null;
            Long srcCalPolicyId = null;
            Date srcDate = null;
            List<GroupRow> rowList = GroupRelationCostCalculator.getCurGroupRows(acctIdCalEntryIdRowMap, srcCalBillEntryIdMap, destCalBillEntryIdMap, sameTypeCostAccount);
            if (rowList.isEmpty()) continue;
            boolean calbycostelement = GroupRelationCostCalculator.isCalByCostElement(rowList);
            boolean isCompleted = groupRecord.getBoolean("iscompleted");
            boolean isDestSameSignum = true;
            boolean isSrcDestSameSignum = true;
            int srcOrDestQtySignum = 0;
            int destQtySignumOld = 0;
            boolean hasOtherDesNotCal = false;
            boolean hasOtherDesEntryNotCal = false;
            boolean hasOtherNotHandCost = false;
            Set<Long> currentBizBillIds = GroupRelationCostCalculator.getCurrentBizBillIds(calentryids, rowList);
            HashSet<Long> destBillDocumentEntryIds = new HashSet<Long>(16);
            HashSet<Long> destBillAllEntryIds = new HashSet<Long>(16);
            BigDecimal destTotalCost = BigDecimal.ZERO;
            BigDecimal srcTotalCost = BigDecimal.ZERO;
            for (GroupRow groupRow : rowList) {
                BigDecimal cost;
                if (groupRow.isDestBill()) {
                    Iterator<Object> bizentityobject = groupRow.getBizentityobject();
                    String costpricesource = groupRow.getCostpricesource();
                    String accounttype = groupRow.getAccounttype();
                    destBillAllEntryIds.add(groupRow.getCalentryid());
                    if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice(bizentityobject, (String)costpricesource) && !GroupRelationCostCalculator.checkUnCalTimeAccounttype(accounttype)) {
                        destBillDocumentEntryIds.add(groupRow.getCalentryid());
                        if (calbycostelement) {
                            for (String elementId : elementList) {
                                BigDecimal cost2 = groupRow.getElementCost(Long.valueOf(elementId));
                                if (cost2 == null) continue;
                                destTotalCost = destTotalCost.add(cost2);
                            }
                        } else {
                            for (String column : columnList) {
                                BigDecimal cost2 = groupRow.getColumnCost(column);
                                if (cost2 == null) continue;
                                destTotalCost = destTotalCost.add(cost2);
                            }
                        }
                    }
                    if (!groupRow.isCalculated().booleanValue() && !currentBizBillIds.contains(groupRow.getBizBillId())) {
                        hasOtherDesNotCal = true;
                    }
                    if (!groupRow.isCalculated().booleanValue() && !calentryids.contains(groupRow.getCalentryid())) {
                        hasOtherDesEntryNotCal = true;
                    }
                    if (!calentryids.contains(groupRow.getCalentryid()) && !CostPriceSourceTypeHelper.checkCostpricesource((String)costpricesource)) {
                        hasOtherNotHandCost = true;
                    }
                    if (!GroupRelationCostCalculator.checkDisassAdjustBill(bizentityobject)) {
                        hasOtherNotHandCost = true;
                    }
                    int destQtySignumNew = groupRow.getBaseqty().signum();
                    if (destQtySignumOld == 0) {
                        destQtySignumOld = destQtySignumNew;
                    } else if (destQtySignumNew != destQtySignumOld) {
                        isDestSameSignum = false;
                    }
                    if (srcOrDestQtySignum == 0) {
                        srcOrDestQtySignum = groupRow.getBaseqty().signum();
                        continue;
                    }
                    if (srcOrDestQtySignum == groupRow.getBaseqty().signum()) continue;
                    isSrcDestSameSignum = false;
                    continue;
                }
                if (calbycostelement) {
                    for (String elementId : elementList) {
                        cost = groupRow.getElementCost(Long.valueOf(elementId));
                        if (cost == null) continue;
                        srcTotalCost = srcTotalCost.add(cost);
                    }
                } else {
                    for (String column : columnList) {
                        cost = groupRow.getColumnCost(column);
                        if (cost == null) continue;
                        srcTotalCost = srcTotalCost.add(cost);
                    }
                }
                if (srcOrDestQtySignum == 0) {
                    srcOrDestQtySignum = groupRow.getBaseqty().signum();
                    continue;
                }
                if (srcOrDestQtySignum == groupRow.getBaseqty().signum()) continue;
                isSrcDestSameSignum = false;
            }
            if (destBillAllEntryIds.size() == destBillDocumentEntryIds.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u7684\u76ee\u6807\u5355\u4e0d\u5141\u8bb8\u90fd\u6307\u5b9a\u6210\u672c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u76ee\u6807\u5355\u7684\u6210\u672c\u3002", (String)"GroupRelationCostCalculator_10", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            HashMap<Long, Integer> destQtySignumMap = new HashMap<Long, Integer>(16);
            int srcQtySignum = 0;
            for (GroupRow row : rowList) {
                BigDecimal elementTotalCost;
                BigDecimal cost;
                long calentryid = row.getCalentryid();
                long thisPeroidId = row.getPeriod();
                if (row.isDestBill()) {
                    boolean peroidCompleted;
                    destQtySignumMap.put(calentryid, row.getBaseqty().signum());
                    boolean bl = peroidCompleted = isCompleted && (thisPeroidId != periodId || !calentryids.contains(row.getCalentryid())) && !hasOtherDesEntryNotCal;
                    if (peroidCompleted || destBillDocumentEntryIds.contains(row.getCalentryid())) {
                        if (calbycostelement) {
                            for (String elementId : elementList) {
                                BigDecimal cost3 = isDestSameSignum && !isSrcDestSameSignum ? row.getElementCost(Long.valueOf(elementId)).abs() : row.getElementCost(Long.valueOf(elementId));
                                BigDecimal elementTotalCost2 = (BigDecimal)hashMap.get(elementId);
                                if (elementTotalCost2 == null) {
                                    elementTotalCost2 = cost3.negate();
                                } else if (!row.getChargeOffed().booleanValue()) {
                                    elementTotalCost2 = elementTotalCost2.subtract(cost3);
                                }
                                hashMap.put(elementId, elementTotalCost2);
                            }
                        } else {
                            for (String column : columnList) {
                                BigDecimal cost3 = isDestSameSignum && !isSrcDestSameSignum ? row.getColumnCost(column).abs() : row.getColumnCost(column);
                                BigDecimal elementTotalCost2 = (BigDecimal)hashMap.get(column);
                                if (elementTotalCost2 == null) {
                                    elementTotalCost2 = cost3.negate();
                                } else if (!row.getChargeOffed().booleanValue()) {
                                    elementTotalCost2 = elementTotalCost2.subtract(cost3);
                                }
                                hashMap.put(column, elementTotalCost2);
                            }
                        }
                        srcTotalQty = isDestSameSignum ? srcTotalQty.subtract(row.getBaseqty().abs()) : srcTotalQty.subtract(row.getBaseqty());
                        continue;
                    }
                    destTotalWeight = destTotalWeight.add(row.getWeight());
                    destBillQtyMap.put(calentryid, row.getBaseqty().abs());
                    destBillWeightMap.put(calentryid, row.getWeight());
                    continue;
                }
                if (srcQtySignum == 0) {
                    srcQtySignum = row.getBaseqty().signum();
                }
                srcCurrencyId = row.getCurrency();
                srcCalPolicyId = row.getCalpolicy();
                srcDate = row.getAuditdate();
                srcTotalQty = srcTotalQty.add(row.getBaseqty().abs());
                if (calbycostelement) {
                    for (String elementId : elementList) {
                        cost = row.getElementCost(Long.valueOf(elementId));
                        elementTotalCost = (BigDecimal)hashMap.get(elementId);
                        elementTotalCost = elementTotalCost == null ? cost : elementTotalCost.add(cost);
                        hashMap.put(elementId, elementTotalCost);
                    }
                    continue;
                }
                for (String column : columnList) {
                    cost = row.getColumnCost(column);
                    elementTotalCost = (BigDecimal)hashMap.get(column);
                    elementTotalCost = elementTotalCost == null ? cost : elementTotalCost.add(cost);
                    hashMap.put(column, elementTotalCost);
                }
            }
            if (srcCurrencyId == null) {
                return resultMap;
            }
            DynamicObject destCurrency = costAccount.getDynamicObject("calpolicy").getDynamicObject("currency");
            DynamicObject srcCalPolicy = (DynamicObject)policyIdDycMap.get(srcCalPolicyId);
            if (srcCalPolicy == null) {
                srcCalPolicy = BusinessDataServiceHelper.loadSingle(srcCalPolicyId, (String)"cal_bd_calpolicy");
                policyIdDycMap.put(srcCalPolicyId, srcCalPolicy);
            }
            DynamicObject extable = srcCalPolicy.getDynamicObject("exratetable");
            String convertmode = srcCalPolicy.getString("convertmode");
            if ("A".equals(convertmode)) {
                convertmode = "1";
            } else if ("B".equals(convertmode)) {
                convertmode = "2";
            }
            if (!srcCurrencyId.equals(destCurrency.getPkValue())) {
                GroupRelationCostCalculator.exchangeAmt(hashMap, srcCurrencyId, destCurrency, extable, convertmode, srcDate);
            }
            if (!destBillDocumentEntryIds.isEmpty() && srcTotalCost != null && srcTotalCost.compareTo(BigDecimal.ZERO) != 0 && destTotalCost.abs().compareTo(srcTotalCost.abs()) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u6307\u5b9a\u603b\u6210\u672c\u5927\u4e8e\u6e90\u5355\u7684\u603b\u6210\u672c\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u76ee\u6807\u5355\u7684\u6210\u672c\u3002", (String)"GroupRelationCostCalculator_11", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            if ((isCompleted || srcTotalQty.compareTo(BigDecimal.ZERO) == 0) && !hasOtherDesNotCal) {
                GroupRelationCostCalculator.divideByWeight(resultMap, hashMap, destBillWeightMap, destTotalWeight, destCurrency.getInt("amtprecision"), costAccountId, destQtySignumMap, srcQtySignum, hasOtherDesEntryNotCal, hasOtherNotHandCost);
                continue;
            }
            GroupRelationCostCalculator.mutiplyByUnitCost(resultMap, hashMap, destBillQtyMap, srcTotalQty, destCurrency.getInt("amtprecision"), costAccountId, destQtySignumMap, srcQtySignum);
        }
        return resultMap;
    }

    private static List<GroupRow> getCurGroupRows(Map<String, GroupRow> acctIdCalEntryIdRowMap, Map<Long, BigDecimal> srcCalBillEntryIdMap, Map<Long, BigDecimal> destCalBillEntryIdMap, Set<Object> sameTypeCostAccountId) {
        GroupRow groupRow;
        String key;
        Long costAccountId;
        ArrayList<GroupRow> curGroupRows = new ArrayList<GroupRow>(16);
        boolean existDestRows = false;
        boolean srcRowIsAudit = true;
        long srcBizBillId = 0L;
        long destBizBillId = 0L;
        for (Long calEntryId : srcCalBillEntryIdMap.keySet()) {
            for (Object costAccountIdObj : sameTypeCostAccountId) {
                costAccountId = (Long)costAccountIdObj;
                key = GroupRelationCostCalculator.getAcctIdCalEntryIdSuffixKey(costAccountId, calEntryId, srcSuffix);
                groupRow = acctIdCalEntryIdRowMap.get(key);
                if (groupRow == null) continue;
                curGroupRows.add(groupRow);
                if ("C".equals(groupRow.getBillStatus())) continue;
                srcRowIsAudit = false;
                srcBizBillId = groupRow.getBizBillId();
            }
        }
        for (Long calEntryId : destCalBillEntryIdMap.keySet()) {
            for (Object costAccountIdObj : sameTypeCostAccountId) {
                costAccountId = (Long)costAccountIdObj;
                key = GroupRelationCostCalculator.getAcctIdCalEntryIdSuffixKey(costAccountId, calEntryId, destSuffix);
                groupRow = acctIdCalEntryIdRowMap.get(key);
                if (groupRow == null) continue;
                curGroupRows.add(groupRow);
                existDestRows = true;
                destBizBillId = groupRow.getBizBillId();
            }
        }
        if (!existDestRows || !srcRowIsAudit && srcBizBillId != destBizBillId) {
            curGroupRows.clear();
        }
        return curGroupRows;
    }

    private static String getAcctIdCalEntryIdSuffixKey(Long costAccountId, Long calEntryId, String suffix) {
        return String.valueOf(costAccountId) + calEntryId + suffix;
    }

    private static Map<String, GroupRow> cacheGroupRows(DynamicObject[] groupRecords, DynamicObject costAccountDyc) {
        HashMap<String, GroupRow> acctIdCalEntryIdRowMap = new HashMap<String, GroupRow>(16);
        Set<Object> sameTypeCostAccount = GroupRelationCostCalculator.getSameTypeCostAccount(costAccountDyc);
        Set<Long> isReturnBillGroupBillSetting = new CostAccountGroupRecordHelper().getIsReturnBillGroupBillSetting();
        HashMap<String, Long> calEntryIdSuffixGroupSettingIdMap = new HashMap<String, Long>(16);
        HashSet<Long> calEntryIds = new HashSet<Long>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashMap<Long, BigDecimal> destCalBillEntryIdMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> srcCalBillEntryIdMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject groupRecord : groupRecords) {
            for (DynamicObject recordEntry : groupRecord.getDynamicObjectCollection("entryentity")) {
                long calEntryId = recordEntry.getLong(AcctGroupModelHelper.getCalEntryIdKey());
                calEntryIds.add(calEntryId);
                bizBillIds.add(recordEntry.getLong("bizbillid"));
                Long groupSettingId = groupRecord.getLong("groupsetting_id");
                if ("0".equals(recordEntry.getString("type"))) {
                    calEntryIdSuffixGroupSettingIdMap.put(calEntryId + srcSuffix, groupSettingId);
                    srcCalBillEntryIdMap.put(recordEntry.getLong(AcctGroupModelHelper.getCalEntryIdKey()), recordEntry.getBigDecimal("baseqty"));
                    continue;
                }
                destCalBillEntryIdMap.put(recordEntry.getLong(AcctGroupModelHelper.getCalEntryIdKey()), recordEntry.getBigDecimal("weight"));
                calEntryIdSuffixGroupSettingIdMap.put(calEntryId + destSuffix, groupSettingId);
            }
        }
        QFilter filter = new QFilter("entry.calentryid", "in", calEntryIds);
        filter.and("costaccount", "in", sameTypeCostAccount);
        filter.and("issplitcreate", "=", (Object)false);
        filter.and("bizbillid", "in", bizBillIds);
        DataSet recordentrys = QueryServiceHelper.queryDataSet((String)GroupRelationCostCalculator.class.getName(), (String)"cal_costrecord_subentity", (String)"ischargeoffed,calorg,costaccount,costaccount.calpolicy as calpolicy,costaccount.calpolicy.calbycostelement as calbycostelement,period,auditdate,billstatus,bizbillid,localcurrency,entry.baseqty as baseqty,entry.calentryid as calentryid,entry.id as entryid,entry.accounttype as accounttype,entry.materialcost as materialcost,entry.fee as fee,entry.manufacturecost as manufacturecost,entry.resource as resource,entry.processcost as processcost,entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_actualcost as sub_actualcost,entry.iscalculated as iscalculated,entry.costpricesource as costpricesource,bizentityobject", (QFilter[])filter.toArray(), null);
        recordentrys = recordentrys.orderBy(new String[]{"entryid"});
        List<GroupRow> rowList = GroupRelationCostCalculator.buildRows(recordentrys, destCalBillEntryIdMap, srcCalBillEntryIdMap, calEntryIdSuffixGroupSettingIdMap, isReturnBillGroupBillSetting);
        for (GroupRow groupRow : rowList) {
            boolean isDestBill = groupRow.isDestBill;
            String suffix = isDestBill ? destSuffix : srcSuffix;
            Long costAccountId = groupRow.getCostAccountId();
            long calEntryId = groupRow.getCalentryid();
            String key = GroupRelationCostCalculator.getAcctIdCalEntryIdSuffixKey(costAccountId, calEntryId, suffix);
            acctIdCalEntryIdRowMap.put(key, groupRow);
        }
        return acctIdCalEntryIdRowMap;
    }

    private static boolean isCalByCostElement(List<GroupRow> rowList) {
        for (GroupRow row : rowList) {
            if (!row.isDestBill()) continue;
            return row.isCalByCostElement();
        }
        return false;
    }

    private static void exchangeAmt(Map<String, BigDecimal> srcBillTotalCost, Long srcCurrencyId, DynamicObject destCurrency, DynamicObject extable, String convertMode, Date date) {
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrency.getLong("id"), (Date)date);
        convertMode = "1";
        if (isIndirect) {
            convertMode = "2";
        }
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)srcCurrencyId, (Long)destCurrency.getLong("id"), (Long)extable.getLong("id"), (Date)date, (boolean)isIndirect);
        int destAmtPrecision = destCurrency.getInt("amtprecision");
        if (exchangeRate == null) {
            boolean isIndirect4TargetUSD = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)6L, (Date)date);
            String convertMode4TargetUSD = "1";
            if (isIndirect4TargetUSD) {
                convertMode4TargetUSD = "2";
            }
            BigDecimal exchangeRate4TargetUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)srcCurrencyId, (Long)6L, (Long)extable.getLong("id"), (Date)date, (boolean)isIndirect4TargetUSD);
            boolean isIndirect4sourceUSD = BaseDataServiceHelper.getRateConversionConfig((Long)6L, (Long)destCurrency.getLong("id"), (Date)date);
            String convertMode4sourceUSD = "1";
            if (isIndirect4sourceUSD) {
                convertMode4sourceUSD = "2";
            }
            BigDecimal exchangeRate4sourceUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)6L, (Long)destCurrency.getLong("id"), (Long)extable.getLong("id"), (Date)date, (boolean)isIndirect4sourceUSD);
            if (exchangeRate4TargetUSD == null) {
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)srcCurrencyId, (String)"bd_currency");
                String msg = String.format(ResManager.loadKDString((String)"\u6e90\u5355\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0e\u76ee\u6807\u5355\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u6e90\u5355\u672c\u4f4d\u5e01\u201c%3$s\u201d\u4e0e\u201c\u7f8e\u5143\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"GroupRelationCostCalculator_7", (String)"fi-cal-business", (Object[])new Object[0]), currency.getString("name"), destCurrency.getString("name"), currency.getString("name"));
                throw new KDBizException(msg);
            }
            if (exchangeRate4sourceUSD == null) {
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)srcCurrencyId, (String)"bd_currency");
                String msg = String.format(ResManager.loadKDString((String)"\u6e90\u5355\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0e\u76ee\u6807\u5355\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u201c\u7f8e\u5143\u201d\u4e0e\u76ee\u6807\u5355\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"GroupRelationCostCalculator_8", (String)"fi-cal-business", (Object[])new Object[0]), currency.getString("name"), destCurrency.getString("name"), destCurrency.getString("name"));
                throw new KDBizException(msg);
            }
            for (Map.Entry<String, BigDecimal> entry : srcBillTotalCost.entrySet()) {
                String key = entry.getKey();
                BigDecimal cost = entry.getValue();
                cost = "1".equals(convertMode4TargetUSD) ? cost.multiply(exchangeRate4TargetUSD).setScale(destAmtPrecision, 4) : cost.divide(exchangeRate4TargetUSD, destAmtPrecision, 4);
                cost = "1".equals(convertMode4sourceUSD) ? cost.multiply(exchangeRate4sourceUSD).setScale(destAmtPrecision, 4) : cost.divide(exchangeRate4sourceUSD).setScale(destAmtPrecision, 4);
                srcBillTotalCost.put(key, cost);
            }
        } else {
            for (Map.Entry<String, BigDecimal> entry : srcBillTotalCost.entrySet()) {
                String key = entry.getKey();
                BigDecimal cost = entry.getValue();
                cost = "1".equals(convertMode) ? cost.multiply(exchangeRate).setScale(destAmtPrecision, 4) : cost.divide(exchangeRate, destAmtPrecision, 4);
                srcBillTotalCost.put(key, cost);
            }
        }
    }

    private static Set<Object> getSameTypeCostAccount(DynamicObject costAccount) {
        HashSet<Object> costAccountIds = new HashSet<Object>();
        Long costAccountTypeId = costAccount.getDynamicObject("booktype").getLong("id");
        DynamicObject costAccountType = BusinessDataServiceHelper.loadSingle((Object)costAccountTypeId, (String)"cal_bd_costaccounttype");
        boolean isCrossAccountGroup = costAccountType.getBoolean("isingroup");
        if (isCrossAccountGroup) {
            QFilter filter = new QFilter("booktype", "=", (Object)costAccountTypeId);
            filter.and("enable", "=", (Object)true);
            DynamicObjectCollection costAccountCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject otherCostAccount : costAccountCol) {
                costAccountIds.add(otherCostAccount.get("id"));
            }
        } else {
            costAccountIds.add(costAccount.getPkValue());
        }
        return costAccountIds;
    }

    private static void mutiplyByUnitCost(Map<String, BigDecimal> resultMap, Map<String, BigDecimal> srcBillTotalCost, Map<Long, BigDecimal> destQtyMap, BigDecimal totalSrcQty, int destAmtprecision, Object costAccountId, Map<Long, Integer> destQtySignumMap, int srcQtySignum) {
        for (Map.Entry<Long, BigDecimal> destentry : destQtyMap.entrySet()) {
            int destQtySignum = destQtySignumMap.get(destentry.getKey());
            boolean isNegate = destQtySignum * srcQtySignum == -1;
            for (Map.Entry<String, BigDecimal> entry : srcBillTotalCost.entrySet()) {
                String costField = entry.getKey();
                BigDecimal cost = entry.getValue().multiply(destentry.getValue()).divide(totalSrcQty, destAmtprecision, RoundingMode.HALF_UP);
                if (isNegate) {
                    cost = cost.negate();
                }
                resultMap.put(costAccountId + "|" + destentry.getKey() + "|" + costField, cost);
            }
        }
    }

    private static void divideByWeight(Map<String, BigDecimal> resultMap, Map<String, BigDecimal> srcBillTotalCost, Map<Long, BigDecimal> destWeightMap, BigDecimal totalDestQty, int destAmtprecision, Object costAccountId, Map<Long, Integer> destQtySignumMap, int srcQtySignum, boolean hasOtherDesEntryNotCal, boolean hasOtherNotHandCost) {
        HashMap<String, BigDecimal> currentTotalCostMap = new HashMap<String, BigDecimal>();
        int destSize = destWeightMap.size();
        int i = 0;
        for (Map.Entry<Long, BigDecimal> destentry : destWeightMap.entrySet()) {
            BigDecimal cost;
            String costField;
            Long calbillentryid = destentry.getKey();
            int destQtySignum = destQtySignumMap.get(calbillentryid);
            boolean isNegate = destQtySignum * srcQtySignum == -1;
            BigDecimal qty = destentry.getValue();
            if (!(i != destSize - 1 || hasOtherDesEntryNotCal && hasOtherNotHandCost)) {
                for (Map.Entry<String, BigDecimal> entry : srcBillTotalCost.entrySet()) {
                    costField = entry.getKey();
                    cost = (BigDecimal)currentTotalCostMap.get(costField);
                    cost = cost == null ? BigDecimal.ZERO : cost;
                    cost = entry.getValue().subtract(cost);
                    if (isNegate) {
                        cost = cost.negate();
                    }
                    resultMap.put(costAccountId + "|" + calbillentryid + "|" + costField, cost);
                }
            } else {
                for (Map.Entry<String, BigDecimal> entry : srcBillTotalCost.entrySet()) {
                    costField = entry.getKey();
                    if (BigDecimal.ZERO.compareTo(totalDestQty) == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6210\u7ec4\u5173\u7cfb\u6743\u91cd\u4e3a\u96f6\uff0c\u8bf7\u68c0\u67e5\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55\u4ee5\u53ca\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e\u3002", (String)"GroupRelationCostCalculator_6", (String)"fi-cal-business", (Object[])new Object[0]));
                    }
                    cost = entry.getValue().multiply(qty).divide(totalDestQty, destAmtprecision, RoundingMode.HALF_UP);
                    BigDecimal currentTotalCost = (BigDecimal)currentTotalCostMap.get(costField);
                    currentTotalCost = currentTotalCost == null ? cost : currentTotalCost.add(cost);
                    if (isNegate) {
                        cost = cost.negate();
                    }
                    resultMap.put(costAccountId + "|" + calbillentryid + "|" + costField, cost);
                    currentTotalCostMap.put(costField, currentTotalCost);
                }
            }
            ++i;
        }
    }

    private static List<GroupRow> buildRows(DataSet dataSet, Map<Long, BigDecimal> destCalBillEntryIdMap, Map<Long, BigDecimal> srcCalBillEntryIdMap, Map<String, Long> calEntryIdGroupSettingIdMap, Set<Long> isReturnBillGroupBillSetting) {
        ArrayList<GroupRow> rowList = new ArrayList<GroupRow>();
        GroupRow groupRow = null;
        GroupRow destRow = null;
        while (dataSet.hasNext()) {
            BigDecimal destWeight;
            boolean isSrc;
            Row row = dataSet.next();
            long entryid = row.getLong("entryid");
            long calentrid = row.getLong("calentryid");
            BigDecimal srcQty = srcCalBillEntryIdMap.get(calentrid);
            boolean bl = isSrc = srcQty != null;
            if (isSrc && (groupRow == null || groupRow.getEntryid() != entryid)) {
                groupRow = new GroupRow();
                rowList.add(groupRow);
                groupRow.setDestBill(false);
                GroupRelationCostCalculator.setGroupInfo(groupRow, row, entryid, calentrid);
            }
            if (isSrc && groupRow != null) {
                groupRow.setElementCost(row.getLong("costsubelement"), row.getBigDecimal("sub_actualcost"));
            }
            boolean isDest = (destWeight = destCalBillEntryIdMap.get(calentrid)) != null;
            String accounttype = row.getString("accounttype");
            if (isDest && (destRow == null || destRow.getEntryid() != entryid)) {
                Long groupSettingId = calEntryIdGroupSettingIdMap.get(calentrid + destSuffix);
                if ("D".equals(accounttype) && isReturnBillGroupBillSetting.contains(groupSettingId)) continue;
                destRow = new GroupRow();
                rowList.add(destRow);
                destRow.setWeight(destWeight);
                destRow.setDestBill(isDest);
                GroupRelationCostCalculator.setGroupInfo(destRow, row, entryid, calentrid);
            }
            if (!isDest || destRow == null) continue;
            destRow.setElementCost(row.getLong("costsubelement"), row.getBigDecimal("sub_actualcost"));
            destRow.setCalculated(row.getBoolean("iscalculated") != false || "D".equals(accounttype) && "C".equals(row.getString("billstatus")));
        }
        return rowList;
    }

    private static void setGroupInfo(GroupRow groupRow, Row row, long entryid, long calentrid) {
        groupRow.setCalorg(row.getLong("calorg"));
        groupRow.setCalByCostElement(row.getBoolean("calbycostelement"));
        groupRow.setEntryid(entryid);
        groupRow.setCalentryid(calentrid);
        groupRow.setAuditdate(row.getDate("auditdate"));
        groupRow.setBaseqty(row.getBigDecimal("baseqty"));
        groupRow.setCalpolicy(row.getLong("calpolicy"));
        groupRow.setCurrency(row.getLong("localcurrency"));
        groupRow.setPeriod(row.getLong("period"));
        groupRow.setColumnCost("materialcost", row.getBigDecimal("materialcost"));
        groupRow.setColumnCost("fee", row.getBigDecimal("fee"));
        groupRow.setColumnCost("manufacturecost", row.getBigDecimal("manufacturecost"));
        groupRow.setColumnCost("resource", row.getBigDecimal("resource"));
        groupRow.setColumnCost("processcost", row.getBigDecimal("processcost"));
        groupRow.setCostAccountId(row.getLong("costaccount"));
        groupRow.setBillStatus(row.getString("billstatus"));
        groupRow.setBizBillId(row.getLong("bizbillid"));
        groupRow.setChargeOffed(row.getBoolean("ischargeoffed"));
        String costpricesource = row.getString("costpricesource");
        costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource);
        groupRow.setCostpricesource(costpricesource);
        String bizentityobject = row.getString("bizentityobject");
        groupRow.setBizentityobject(bizentityobject);
        String accounttype = row.getString("accounttype");
        groupRow.setAccounttype(accounttype);
    }

    private static Set<Long> getCurrentBizBillIds(Set<Long> calEntryIds, List<GroupRow> rowList) {
        HashSet<Long> currentBizBillIds = new HashSet<Long>(16);
        for (GroupRow groupRow : rowList) {
            boolean isCurrentCalEntryId = calEntryIds.contains(groupRow.getCalentryid());
            if (!isCurrentCalEntryId) continue;
            Long bizBillId = groupRow.getBizBillId();
            currentBizBillIds.add(bizBillId);
        }
        return currentBizBillIds;
    }

    private static boolean checkDisassAdjustBill(String bizentityobject) {
        return "im_disassemblebill".equals(bizentityobject) || "im_adjustbill".equals(bizentityobject);
    }

    private static boolean checkUnCalTimeAccounttype(String accounttype) {
        return AccountTypeEnum.ADD_AVERAGE.getValue().equals(accounttype) || AccountTypeEnum.SPECIAL_ACCT.getValue().equals(accounttype) || AccountTypeEnum.FIN_FOUT_PERIOD.getValue().equals(accounttype);
    }

    private static class GroupRow {
        private long calorg;
        private boolean isCalByCostElement;
        private long calpolicy;
        private long period;
        private Date auditdate;
        private long currency;
        private BigDecimal baseqty;
        private long calentryid;
        private long entryid;
        private boolean isDestBill;
        private BigDecimal weight;
        private Map<String, BigDecimal> columnCost = new HashMap<String, BigDecimal>();
        private Map<Long, BigDecimal> elementCost = new HashMap<Long, BigDecimal>();
        private Long costAccountId;
        private String billStatus;
        private Long bizBillId;
        private Boolean calculated;
        private Boolean chargeOffed;
        private String costpricesource;
        private String bizentityobject;
        private String accounttype;

        private GroupRow() {
        }

        public Boolean getChargeOffed() {
            return this.chargeOffed;
        }

        public void setChargeOffed(Boolean chargeOffed) {
            this.chargeOffed = chargeOffed;
        }

        public long getCalpolicy() {
            return this.calpolicy;
        }

        public void setCalpolicy(long calpolicy) {
            this.calpolicy = calpolicy;
        }

        public long getPeriod() {
            return this.period;
        }

        public void setPeriod(long period) {
            this.period = period;
        }

        public Date getAuditdate() {
            return this.auditdate;
        }

        public void setAuditdate(Date auditdate) {
            this.auditdate = auditdate;
        }

        public long getCurrency() {
            return this.currency;
        }

        public void setCurrency(long currency) {
            this.currency = currency;
        }

        public BigDecimal getBaseqty() {
            return this.baseqty;
        }

        public void setBaseqty(BigDecimal baseqty) {
            this.baseqty = baseqty;
        }

        public long getCalentryid() {
            return this.calentryid;
        }

        public void setCalentryid(long calentryid) {
            this.calentryid = calentryid;
        }

        public long getEntryid() {
            return this.entryid;
        }

        public void setEntryid(long entryid) {
            this.entryid = entryid;
        }

        public boolean isDestBill() {
            return this.isDestBill;
        }

        public void setDestBill(boolean isDestBill) {
            this.isDestBill = isDestBill;
        }

        public void setElementCost(long elementId, BigDecimal cost) {
            this.elementCost.put(elementId, cost);
        }

        public BigDecimal getElementCost(Long elementId) {
            BigDecimal cost = this.elementCost.get(elementId);
            return cost == null ? BigDecimal.ZERO : cost;
        }

        public void setColumnCost(String column, BigDecimal cost) {
            this.columnCost.put(column, cost);
        }

        public BigDecimal getColumnCost(String column) {
            return this.columnCost.get(column);
        }

        public long getCalorg() {
            return this.calorg;
        }

        public void setCalorg(long calorg) {
            this.calorg = calorg;
        }

        public boolean isCalByCostElement() {
            return this.isCalByCostElement;
        }

        public void setCalByCostElement(boolean calByCostElement) {
            this.isCalByCostElement = calByCostElement;
        }

        public BigDecimal getWeight() {
            return this.weight;
        }

        public void setWeight(BigDecimal weight) {
            this.weight = weight;
        }

        public void setCostAccountId(Long costAccountId) {
            this.costAccountId = costAccountId;
        }

        public Long getCostAccountId() {
            return this.costAccountId;
        }

        public void setBillStatus(String billStatus) {
            this.billStatus = billStatus;
        }

        public String getBillStatus() {
            return this.billStatus;
        }

        public void setBizBillId(Long bizBillId) {
            this.bizBillId = bizBillId;
        }

        public Long getBizBillId() {
            return this.bizBillId;
        }

        public void setCalculated(Boolean calculated) {
            this.calculated = calculated;
        }

        public Boolean isCalculated() {
            return this.calculated;
        }

        public String getCostpricesource() {
            return this.costpricesource;
        }

        public void setCostpricesource(String costpricesource) {
            this.costpricesource = costpricesource;
        }

        public String getBizentityobject() {
            return this.bizentityobject;
        }

        public void setBizentityobject(String bizentityobject) {
            this.bizentityobject = bizentityobject;
        }

        public String getAccounttype() {
            return this.accounttype;
        }

        public void setAccounttype(String accounttype) {
            this.accounttype = accounttype;
        }
    }
}

