/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CostElementHelper;

public class WFGroupCostCalculator {
    private Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";

    public Map<String, BigDecimal> calculateCost(DynamicObject groupRecord, Long groupNo, Long costAccountId) {
        List<String> elementList = Arrays.asList(groupRecord.getString("costfields").split(","));
        String groupColumnStr = groupRecord.getString("costcolumn");
        if (groupColumnStr.startsWith(",")) {
            groupColumnStr = groupColumnStr.substring(1);
        }
        List<String> columnList = Arrays.asList(groupColumnStr.split(","));
        DynamicObjectCollection groupRecordEntrys = groupRecord.getDynamicObjectCollection("entryentity");
        HashSet<Long> calentryidSet = new HashSet<Long>(groupRecordEntrys.size());
        HashMap<Long, List<BigDecimal>> billAccumulatedQty = new HashMap<Long, List<BigDecimal>>(groupRecordEntrys.size());
        HashMap<Long, BigDecimal> weightMap = new HashMap<Long, BigDecimal>(groupRecordEntrys.size());
        BigDecimal totalWeight = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> srcOccupiedqtyMap = new HashMap<Long, BigDecimal>(groupRecordEntrys.size());
        HashMap<Long, BigDecimal> destOccupiedqtyMap = new HashMap<Long, BigDecimal>(groupRecordEntrys.size());
        for (DynamicObject recordEntry : groupRecordEntrys) {
            Long calentryid = recordEntry.getLong(this.calEntryIdKey);
            if (groupNo.equals(recordEntry.getLong("groupno"))) {
                String type = recordEntry.getString("type");
                if ("1".equals(type)) {
                    destOccupiedqtyMap.put(calentryid, recordEntry.getBigDecimal("occupiedqty"));
                    BigDecimal weight = recordEntry.getBigDecimal("weight");
                    weightMap.put(calentryid, weight);
                    totalWeight = totalWeight.add(weight);
                } else {
                    srcOccupiedqtyMap.put(calentryid, recordEntry.getBigDecimal("occupiedqty"));
                }
                calentryidSet.add(calentryid);
                continue;
            }
            List list = billAccumulatedQty.computeIfAbsent(calentryid, k -> new ArrayList());
            list.add(recordEntry.getBigDecimal("occupiedqty"));
        }
        QFilter filter = new QFilter("entry.calentryid", "in", calentryidSet);
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"calpolicy.currency,calpolicy.exratetable,calpolicy.convertmode,booktype");
        filter.and("costaccount", "in", WFGroupCostCalculator.getSameTypeCostAccount(costAccount));
        filter.and("issplitcreate", "=", (Object)false);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)WFGroupCostCalculator.class.getName(), (String)"cal_costrecord_subentity", (String)"costaccount,bizentityobject,costaccount.calpolicy as calpolicy,costaccount.calpolicy.calbycostelement as calbycostelement,localcurrency,localcurrency.amtprecision as amtprecision,entry.calentryid as calentryid,entry.baseqty as baseqty,entry.id as entryid,entry.materialcost as materialcost,entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource,entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_actualcost as sub_actualcost", (QFilter[])filter.toArray(), null);
        costRecordDataSet = costRecordDataSet.orderBy(new String[]{"entryid"});
        Map<Long, GroupRow> rowMap = WFGroupCostCalculator.buildRows(costRecordDataSet, weightMap);
        boolean isCalByCostElement = WFGroupCostCalculator.isCalByCostElement(rowMap);
        Map<String, BigDecimal> srcBillTotalCost = this.getSrcTotalCost(elementList, columnList, billAccumulatedQty, srcOccupiedqtyMap, rowMap, isCalByCostElement);
        Map<String, BigDecimal> targetCost = this.calculateTargetCost(destOccupiedqtyMap, weightMap, totalWeight, rowMap, srcBillTotalCost);
        return targetCost;
    }

    private Map<String, BigDecimal> calculateTargetCost(Map<Long, BigDecimal> occupiedqtyMap, Map<Long, BigDecimal> weightMap, BigDecimal totalWeight, Map<Long, GroupRow> rowMap, Map<String, BigDecimal> srcBillTotalCost) {
        HashMap<String, BigDecimal> targetCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> alreadyDividedCost = new HashMap<String, BigDecimal>(srcBillTotalCost.size());
        int i = 0;
        for (Map.Entry<Long, BigDecimal> weightEntry : weightMap.entrySet()) {
            Long calentryid = weightEntry.getKey();
            BigDecimal weight = weightEntry.getValue();
            GroupRow row = rowMap.get(calentryid);
            Long costAccountId = row.getCostaccount();
            BigDecimal occupiedQty = occupiedqtyMap.get(calentryid);
            for (Map.Entry<String, BigDecimal> costEntry : srcBillTotalCost.entrySet()) {
                BigDecimal alreadyCost;
                BigDecimal srcTotalCost = costEntry.getValue();
                String key = costEntry.getKey();
                BigDecimal thisCost = null;
                if (i == weightMap.size() - 1) {
                    alreadyCost = (BigDecimal)alreadyDividedCost.get(key);
                    thisCost = srcTotalCost.subtract(alreadyCost == null ? BigDecimal.ZERO : alreadyCost);
                } else {
                    thisCost = srcTotalCost.multiply(weight).divide(totalWeight, row.getAmtprecision(), RoundingMode.HALF_UP);
                    alreadyCost = alreadyDividedCost.computeIfAbsent(key, k -> BigDecimal.ZERO);
                    alreadyDividedCost.put(key, alreadyCost.add(thisCost));
                }
                thisCost = thisCost.multiply(row.getBaseqty()).divide(occupiedQty, row.getAmtprecision(), RoundingMode.HALF_UP);
                String targetKey = key;
                if ("im_mdc_ominbill".equals(row.getBizentityobject()) && row.getBaseqty().compareTo(BigDecimal.ZERO) > 0 || "im_ospurinbill".equals(row.getBizentityobject()) && row.getBaseqty().compareTo(BigDecimal.ZERO) > 0) {
                    targetKey = row.isCalByCostElement() ? CostElementHelper.getDefalutMaterialId().toString() : "materialcost";
                }
                BigDecimal targetCost = targetCostMap.computeIfAbsent(costAccountId + "|" + calentryid + "|" + targetKey, k -> BigDecimal.ZERO);
                targetCostMap.put(costAccountId + "|" + calentryid + "|" + targetKey, targetCost.add(thisCost));
            }
            ++i;
        }
        return targetCostMap;
    }

    private Map<String, BigDecimal> getSrcTotalCost(List<String> elementList, List<String> columnList, Map<Long, List<BigDecimal>> billAccumulatedQty, Map<Long, BigDecimal> occupiedqtyMap, Map<Long, GroupRow> rowMap, boolean isCalByCostElement) {
        HashMap<String, BigDecimal> srcBillTotalCost = new HashMap<String, BigDecimal>();
        for (Map.Entry<Long, BigDecimal> occupiedQtyEntry : occupiedqtyMap.entrySet()) {
            Long calentryid = occupiedQtyEntry.getKey();
            BigDecimal occupiedQty = occupiedQtyEntry.getValue();
            GroupRow row = rowMap.get(calentryid);
            List<BigDecimal> accumulatedQtyList = billAccumulatedQty.get(calentryid);
            boolean isCompleted = this.isCompleted(occupiedQty, row.getBaseqty(), billAccumulatedQty.get(calentryid));
            if (isCalByCostElement) {
                for (String subElementId : elementList) {
                    Long subElementid = Long.valueOf(subElementId);
                    BigDecimal totalCost = srcBillTotalCost.computeIfAbsent(subElementId, k -> BigDecimal.ZERO);
                    BigDecimal elementCost = row.getElementCost(subElementid);
                    if (isCompleted) {
                        BigDecimal accumulatedCost = BigDecimal.ZERO;
                        if (accumulatedQtyList != null) {
                            for (BigDecimal accumulatedQty : accumulatedQtyList) {
                                accumulatedCost = accumulatedCost.add(elementCost.multiply(accumulatedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP));
                            }
                        }
                        totalCost = totalCost.add(elementCost.subtract(accumulatedCost));
                    } else {
                        totalCost = totalCost.add(elementCost.multiply(occupiedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP));
                    }
                    srcBillTotalCost.put(subElementId, totalCost);
                }
                continue;
            }
            for (String column : columnList) {
                BigDecimal totalCost = srcBillTotalCost.computeIfAbsent(column, k -> BigDecimal.ZERO);
                BigDecimal columnCost = row.getColumnCost(column);
                if (isCompleted) {
                    BigDecimal accumulatedCost = BigDecimal.ZERO;
                    if (accumulatedQtyList != null) {
                        for (BigDecimal accumulatedQty : accumulatedQtyList) {
                            accumulatedCost = accumulatedCost.add(columnCost.multiply(accumulatedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP));
                        }
                    }
                    totalCost = totalCost.add(columnCost.subtract(accumulatedCost));
                } else {
                    totalCost = totalCost.add(columnCost.multiply(occupiedQty).divide(row.getBaseqty(), row.getAmtprecision(), RoundingMode.HALF_UP));
                }
                srcBillTotalCost.put(column, totalCost);
            }
        }
        return srcBillTotalCost;
    }

    private boolean isCompleted(BigDecimal occupiedQty, BigDecimal baseqty, List<BigDecimal> list) {
        BigDecimal accumulatedQty = BigDecimal.ZERO;
        if (list != null && !list.isEmpty()) {
            for (BigDecimal qty : list) {
                accumulatedQty = accumulatedQty.add(qty);
            }
        }
        return occupiedQty.add(accumulatedQty).compareTo(baseqty) == 0;
    }

    private static boolean isCalByCostElement(Map<Long, GroupRow> rowMap) {
        for (GroupRow row : rowMap.values()) {
            if (!row.isDestBill()) continue;
            return row.isCalByCostElement();
        }
        return false;
    }

    private static Set<Object> getSameTypeCostAccount(DynamicObject costAccount) {
        HashSet<Object> costAccountIds = new HashSet<Object>();
        Long costAccountTypeId = costAccount.getDynamicObject("booktype").getLong("id");
        DynamicObject costAccountType = BusinessDataServiceHelper.loadSingle((Object)costAccountTypeId, (String)"cal_bd_costaccounttype");
        boolean isCrossAccountGroup = costAccountType.getBoolean("isingroup");
        if (isCrossAccountGroup) {
            QFilter filter = new QFilter("booktype", "=", (Object)costAccountTypeId);
            filter.and("enable", "=", (Object)true);
            DynamicObjectCollection costAccountCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject otherCostAccount : costAccountCol) {
                costAccountIds.add(otherCostAccount.get("id"));
            }
        } else {
            costAccountIds.add(costAccount.getPkValue());
        }
        return costAccountIds;
    }

    private static Map<Long, GroupRow> buildRows(DataSet dataSet, Map<Long, BigDecimal> weightMap) {
        HashMap<Long, GroupRow> rowMap = new HashMap<Long, GroupRow>();
        GroupRow groupRow = null;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long entryid = row.getLong("entryid");
            Long calentrid = row.getLong("calentryid");
            if (groupRow == null || groupRow.getEntryid() != entryid) {
                groupRow = new GroupRow();
                rowMap.put(calentrid, groupRow);
                groupRow.setBizentityobject(row.getString("bizentityobject"));
                groupRow.setDestBill(weightMap.containsKey(calentrid));
                groupRow.setCalByCostElement(row.getBoolean("calbycostelement"));
                groupRow.setEntryid(entryid);
                groupRow.setCostaccount(row.getLong("costaccount"));
                groupRow.setBaseqty(row.getBigDecimal("baseqty"));
                groupRow.setColumnCost("materialcost", row.getBigDecimal("materialcost"));
                groupRow.setColumnCost("fee", row.getBigDecimal("fee"));
                groupRow.setColumnCost("manufacturecost", row.getBigDecimal("manufacturecost"));
                groupRow.setColumnCost("resource", row.getBigDecimal("resource"));
                groupRow.setColumnCost("processcost", row.getBigDecimal("processcost"));
                groupRow.setAmtprecision(row.getInteger("amtprecision"));
            }
            groupRow.setElementCost(row.getLong("costsubelement"), row.getBigDecimal("sub_actualcost"));
        }
        return rowMap;
    }

    private static class GroupRow {
        private Long costaccount;
        private boolean isCalByCostElement;
        private BigDecimal baseqty;
        private long entryid;
        private boolean isDestBill;
        private Map<String, BigDecimal> columnCost = new HashMap<String, BigDecimal>();
        private Map<Long, BigDecimal> elementCost = new HashMap<Long, BigDecimal>();
        private int amtprecision;
        private String bizentityobject;

        private GroupRow() {
        }

        public BigDecimal getBaseqty() {
            return this.baseqty;
        }

        public void setBaseqty(BigDecimal baseqty) {
            this.baseqty = baseqty;
        }

        public long getEntryid() {
            return this.entryid;
        }

        public void setEntryid(long entryid) {
            this.entryid = entryid;
        }

        public boolean isDestBill() {
            return this.isDestBill;
        }

        public void setDestBill(boolean isDestBill) {
            this.isDestBill = isDestBill;
        }

        public void setElementCost(long elementId, BigDecimal cost) {
            this.elementCost.put(elementId, cost);
        }

        public BigDecimal getElementCost(Long elementId) {
            BigDecimal cost = this.elementCost.get(elementId);
            return cost == null ? BigDecimal.ZERO : cost;
        }

        public void setColumnCost(String column, BigDecimal cost) {
            this.columnCost.put(column, cost);
        }

        public BigDecimal getColumnCost(String column) {
            return this.columnCost.get(column);
        }

        public boolean isCalByCostElement() {
            return this.isCalByCostElement;
        }

        public void setCalByCostElement(boolean calByCostElement) {
            this.isCalByCostElement = calByCostElement;
        }

        public int getAmtprecision() {
            return this.amtprecision;
        }

        public void setAmtprecision(int amtprecision) {
            this.amtprecision = amtprecision;
        }

        public Long getCostaccount() {
            return this.costaccount;
        }

        public void setCostaccount(Long costaccount) {
            this.costaccount = costaccount;
        }

        public String getBizentityobject() {
            return this.bizentityobject;
        }

        public void setBizentityobject(String bizentityobject) {
            this.bizentityobject = bizentityobject;
        }
    }
}

