/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilderFunction;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordSpecialBuilder;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class BizGroupRecordBuilder {
    private static final int BATCH_IN_SIZE = 50000;
    private static final String costcolumn = ",materialcost,processcost,fee,manufacturecost,resource,";
    public static final String ACCOUNT_GROUP_SELECT = "id,groupsetting,iscompleted,costcolumn,costfields,groupvalue,entryentity.type as type,entryentity.bizbillid as bizbillid,entryentity.billno as billno,costaccounttype as booktype,costaccounttype.isingroup as isingroup,entryentity.calbillid as calbillid,entryentity.calentryid as calentryid,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount, entryentity.material as material,entryentity.bookdate as bookdate,entryentity.period as period,entryentity.period.enddate as periodenddate,entryentity.baseqty as baseqty,entryentity.occupiedqty as occupiedqty, entryentity.weight as weight,entryentity.groupno as groupno,entryentity.isbeforeperiod as isbeforeperiod,TO_CHAR(id) as groupid,'C' as billstatus";
    public static final String ACCOUNT_GROUP_LOAD = "id,costaccounttype,groupsetting,iscompleted,costcolumn,costfields,bizgrouprecordid,groupvalue,entryentity.type,entryentity.calentryid,entryentity.bizbillid,entryentity.billno,entryentity.calbillid,entryentity.costrecordentryid,entryentity.costaccount, entryentity.material,entryentity.bookdate,entryentity.period,entryentity.baseqty,entryentity.occupiedqty, entryentity.weight,entryentity.groupno,entryentity.isbeforeperiod";
    public static final String IM_BGGROUP_SELECT = "id,bgsetting,bgsetting.grouptype,iscompleted,groupvalue,entryentity.type as type,entryentity.bizbillid as bizbillid,entryentity.bookdate as bookdate,entryentity.bizentryid as bizentryid,entryentity.billno as billno,entryentity.owner as owner,entryentity.formid as bizentityobject";
    private String costfields = null;
    private boolean needAfterGroup = true;
    private BizGroupRecordSpecialBuilder specialGroupRecordBuilder = new BizGroupRecordSpecialBuilder();
    private boolean filterGroupAcct = false;

    public BizGroupRecordBuilder() {
    }

    public BizGroupRecordBuilder(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        Boolean after = (Boolean)map.get("needAfterGroup");
        if (after != null) {
            this.needAfterGroup = after != false || CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.NEED_AFTER_GROUP) != false;
        }
    }

    public DynamicObject[] getAllGroupRecordByBizBillIds(Map<String, Set<Long>> formId2BizbillidMap) {
        HashSet<QFilter> bgFilters = new HashSet<QFilter>(16);
        HashSet<QFilter> spBgFilters = new HashSet<QFilter>(16);
        HashSet<Long> allBizbillids = new HashSet<Long>(16);
        for (Map.Entry<String, Set<Long>> mapEntry : formId2BizbillidMap.entrySet()) {
            String formid = mapEntry.getKey();
            Set<Long> bizBillids = mapEntry.getValue();
            allBizbillids.addAll(bizBillids);
            Lists.partition(new ArrayList<Long>(bizBillids), (int)50000).forEach(list -> {
                QFilter bgFilter = new QFilter("entryentity.formid", "=", (Object)formid);
                bgFilter.and("entryentity.bizbillid", "in", list);
                bgFilters.add(bgFilter);
                QFilter spFilter = new QFilter("bizentityobject", "=", (Object)formid);
                spFilter.and("bizbillid", "in", list);
                spBgFilters.add(spFilter);
            });
        }
        DataSet dataSet = this.getBizGroupRecordAndSpecialRecordDataSet(bgFilters, spBgFilters, false, null);
        Set<DynamicObject> buildRecords = this.buildGroupRecordDyn(dataSet);
        QFilter filter = new QFilter("entryentity.bizbillid", "in", allBizbillids);
        DynamicObject[] loadRecords = BusinessDataServiceHelper.load((String)"cal_account_grouprecord", (String)ACCOUNT_GROUP_LOAD, (QFilter[])filter.toArray());
        if (loadRecords != null && loadRecords.length > 0) {
            buildRecords.addAll(Arrays.asList(loadRecords));
        }
        return buildRecords.toArray(new DynamicObject[0]);
    }

    public DataSet getAllGroupRecordDataSetByBizBillIds(Map<String, Set<Long>> formId2BizbillidMap) {
        HashSet<QFilter> bgFilters = new HashSet<QFilter>(16);
        HashSet<QFilter> spBgFilters = new HashSet<QFilter>(16);
        HashSet<QFilter> accFilters = new HashSet<QFilter>(16);
        for (Map.Entry<String, Set<Long>> mapEntry : formId2BizbillidMap.entrySet()) {
            String formid = mapEntry.getKey();
            Set<Long> bizBillids = mapEntry.getValue();
            Lists.partition(new ArrayList<Long>(bizBillids), (int)50000).forEach(list -> {
                QFilter bgFilter = new QFilter("entryentity.formid", "=", (Object)formid);
                bgFilter.and("entryentity.bizbillid", "in", list);
                bgFilters.add(bgFilter);
                QFilter spFilter = new QFilter("bizentityobject", "=", (Object)formid);
                spFilter.and("bizbillid", "in", list);
                spBgFilters.add(spFilter);
                QFilter accFilter = new QFilter("entryentity.bizbillid", "in", list);
                accFilters.add(accFilter);
            });
        }
        DataSet dataSet = this.getBizGroupRecordAndSpecialRecordDataSet(bgFilters, spBgFilters, false, null);
        DataSet accGroupDataSet = this.getAccGroupDataSet(accFilters, null);
        dataSet = dataSet.union(accGroupDataSet);
        return dataSet;
    }

    public String getAllGroupRecordDataSetByCostAccountByCache(Map<Long, Set<Object>> costAccount2MaterialidMap, String selectFields) {
        DataSet dataSet = this.getAllGroupRecordDataSetByCostAccount(costAccount2MaterialidMap);
        dataSet = dataSet.where("billstatus = 'C'");
        dataSet = dataSet.select(selectFields);
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.BIZGROUP_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = dataSet.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }

    public DataSet getAllGroupRecordDataSetByCostAccount(Map<Long, Set<Object>> costAccount2MaterialidMap) {
        Set<Object> materialids;
        DynamicObject currentPeriod;
        if (costAccount2MaterialidMap == null) {
            costAccount2MaterialidMap = new HashMap<Long, Set<Object>>(16);
        }
        QFilter costAccountFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (!costAccount2MaterialidMap.isEmpty()) {
            costAccountFilter = new QFilter("id", "in", costAccount2MaterialidMap.keySet());
        }
        new CalGroupAccountHelper().addNotGroupAcctFilterSelfIf(costAccountFilter, this.filterGroupAcct);
        HashMap<Long, Set> calOrg2CostAccountMap = new HashMap<Long, Set>(16);
        HashSet<Long> allCostaccountIds = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])costAccountFilter.toArray(), null);){
            for (Row row : ds) {
                Long costAccountId = row.getLong("id");
                Long calorgId = row.getLong("calorg");
                Set costaccountIds = calOrg2CostAccountMap.computeIfAbsent(calorgId, k -> new HashSet(4));
                costaccountIds.add(costAccountId);
                allCostaccountIds.add(costAccountId);
            }
        }
        Map currentPeriodMap = PeriodHelper.getCurrentPeriods(allCostaccountIds);
        HashMap<Long, Long> currentPeriodIdMap = new HashMap<Long, Long>(16);
        for (Long allCostaccountId : allCostaccountIds) {
            DynamicObject periodDyn = (DynamicObject)currentPeriodMap.get(allCostaccountId);
            Long periodid = 0L;
            if (periodDyn != null) {
                periodid = periodDyn.getLong("id");
            }
            currentPeriodIdMap.put(allCostaccountId, periodid);
        }
        Map ownersByCalorgIds = AccountingSysHelper.getOwnersByCalorgIds(calOrg2CostAccountMap.keySet());
        HashMap<Long, Object> owner2StartBookdate = new HashMap<Long, Object>(16);
        HashMap<Long, Date> owner2EndBookdate = new HashMap<Long, Date>(16);
        HashMap owner2MaterialIdsMap = new HashMap(16);
        for (Map.Entry entry : calOrg2CostAccountMap.entrySet()) {
            Set owners;
            Object costAccountId22;
            Long calorgId = (Long)entry.getKey();
            Set costAccountIds = (Set)entry.getValue();
            Object minBookdate = null;
            Date maxBookdate = null;
            for (Object costAccountId22 : costAccountIds) {
                currentPeriod = (DynamicObject)currentPeriodMap.get(costAccountId22);
                if (currentPeriod == null) {
                    minBookdate = null;
                    break;
                }
                Date startDate = currentPeriod.getDate("begindate");
                if (minBookdate == null || ((Date)minBookdate).after(startDate)) {
                    minBookdate = startDate;
                }
                if (currentPeriod == null) {
                    maxBookdate = null;
                    break;
                }
                Date endDate = currentPeriod.getDate("enddate");
                if (maxBookdate != null && !maxBookdate.before(endDate)) continue;
                maxBookdate = endDate;
            }
            HashSet<Object> materialIds = new HashSet<Object>(16);
            costAccountId22 = costAccountIds.iterator();
            while (costAccountId22.hasNext()) {
                Long costAccountId3 = (Long)costAccountId22.next();
                Set<Object> curMaterialIds = costAccount2MaterialidMap.get(costAccountId3);
                if (curMaterialIds == null) {
                    materialIds = null;
                    break;
                }
                materialIds.addAll(curMaterialIds);
            }
            if ((owners = (Set)ownersByCalorgIds.get(calorgId)) == null || owners.isEmpty()) continue;
            for (Long owner : owners) {
                if (owner2StartBookdate.containsKey(owner)) {
                    Date curStartBookdate = (Date)owner2StartBookdate.get(owner);
                    Date curEndBookdate = (Date)owner2EndBookdate.get(owner);
                    Set curMaterialIds = (Set)owner2MaterialIdsMap.get(owner);
                    if (curStartBookdate == null || minBookdate == null) {
                        owner2StartBookdate.put(owner, null);
                    } else if (((Date)minBookdate).before(curStartBookdate)) {
                        owner2StartBookdate.put(owner, minBookdate);
                    }
                    if (curEndBookdate == null || maxBookdate == null) {
                        owner2StartBookdate.put(owner, null);
                    } else if (maxBookdate.after(curEndBookdate)) {
                        owner2EndBookdate.put(owner, maxBookdate);
                    }
                    if (curMaterialIds == null || materialIds == null) {
                        owner2MaterialIdsMap.put(owner, null);
                        continue;
                    }
                    curMaterialIds.addAll(materialIds);
                    continue;
                }
                owner2StartBookdate.put(owner, minBookdate);
                owner2EndBookdate.put(owner, maxBookdate);
                owner2MaterialIdsMap.put(owner, materialIds);
            }
        }
        HashSet<QFilter> bgFilters = new HashSet<QFilter>(16);
        HashSet<QFilter> hashSet = new HashSet<QFilter>(16);
        HashSet<QFilter> accFilters = new HashSet<QFilter>(16);
        boolean needQuerTwice = false;
        for (Map.Entry mapEntry : owner2StartBookdate.entrySet()) {
            Long owner = (Long)mapEntry.getKey();
            Date startbookdate = (Date)mapEntry.getValue();
            Date endbookdate = (Date)owner2EndBookdate.get(owner);
            materialids = (Set<Object>)owner2MaterialIdsMap.get(owner);
            QFilter bgFilter = new QFilter("entryentity.owner", "=", (Object)owner);
            if (startbookdate != null) {
                bgFilter.and("entryentity.bookdate", ">=", (Object)startbookdate);
            }
            if (!this.needAfterGroup && endbookdate != null) {
                bgFilter.and("entryentity.bookdate", "<=", (Object)endbookdate);
            }
            if (materialids != null && !materialids.isEmpty()) {
                bgFilter.and("entryentity.material", "in", (Object)materialids);
            }
            bgFilters.add(bgFilter);
        }
        for (Long costaccountId : allCostaccountIds) {
            QFilter spFilter = new QFilter("costaccount", "=", (Object)costaccountId);
            QFilter accFilter = new QFilter("entryentity.costaccount", "=", (Object)costaccountId);
            if (this.needAfterGroup) {
                accFilter.and("entryentity.isbeforeperiod", "=", (Object)Boolean.FALSE);
            } else {
                accFilter.and("entryentity.period", "=", currentPeriodIdMap.get(costaccountId));
            }
            currentPeriod = (DynamicObject)currentPeriodMap.get(costaccountId);
            if (currentPeriod != null) {
                spFilter.and("bookdate", ">=", (Object)currentPeriod.getDate("begindate"));
                if (!this.needAfterGroup) {
                    spFilter.and("bookdate", "<=", (Object)currentPeriod.getDate("enddate"));
                }
            }
            if ((materialids = costAccount2MaterialidMap.get(costaccountId)) != null && !materialids.isEmpty()) {
                needQuerTwice = true;
                accFilter.and("entryentity.material", "in", materialids);
                spFilter.and("entry.material", "in", materialids);
            }
            hashSet.add(spFilter);
            accFilters.add(accFilter);
        }
        DataSet dataSet = this.getBizGroupRecordAndSpecialRecordDataSet(bgFilters, hashSet, needQuerTwice, currentPeriodIdMap);
        DataSet accGroupDataSet = this.getAccGroupDataSet(accFilters, currentPeriodIdMap);
        dataSet = dataSet.union(accGroupDataSet);
        return dataSet;
    }

    private Set<DynamicObject> buildGroupRecordDyn(DataSet dataSet) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            Long groupsetting = row.getLong("groupsetting");
            Long bookType = row.getLong("booktype");
            Long costAccountId = row.getLong("costaccount");
            boolean isIngroup = row.getBoolean("isingroup");
            String curKey = "";
            curKey = isIngroup ? id + "#" + groupsetting + "#0#" + bookType : id + "#" + groupsetting + "#" + costAccountId + "#" + bookType;
            DynamicObject record = (DynamicObject)resultMap.get(curKey);
            if (record == null) {
                record = BusinessDataServiceHelper.newDynamicObject((String)"cal_account_grouprecord");
                record.set("id", (Object)row.getLong("id"));
                record.set("costaccounttype", (Object)bookType);
                record.set("groupsetting", (Object)groupsetting);
                record.set("groupsetting_id", (Object)groupsetting);
                record.set("costaccounttype_id", (Object)bookType);
                record.set("iscompleted", (Object)row.getBoolean("iscompleted"));
                record.set("costfields", (Object)row.getString("costfields"));
                record.set("costcolumn", (Object)costcolumn);
                record.set("bizgrouprecordid", (Object)row.getLong("id"));
                record.set("groupvalue", (Object)row.getString("groupvalue"));
                resultMap.put(curKey, record);
            }
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entryentity");
            DynamicObject entryRow = entry.addNew();
            entryRow.set("type", (Object)row.getString("type"));
            entryRow.set("calentryid", (Object)row.getLong("calentryid"));
            entryRow.set("calbillid", (Object)row.getLong("calbillid"));
            entryRow.set("costrecordentryid", (Object)row.getLong("costrecordentryid"));
            entryRow.set("costaccount", (Object)row.getLong("costaccount"));
            entryRow.set("costaccount_id", (Object)row.getLong("costaccount"));
            entryRow.set("period", (Object)row.getLong("period"));
            entryRow.set("bookdate", (Object)row.getDate("bookdate"));
            entryRow.set("material", (Object)row.getLong("material"));
            entryRow.set("baseqty", (Object)row.getBigDecimal("baseqty"));
            entryRow.set("occupiedqty", (Object)row.getBigDecimal("occupiedqty"));
            entryRow.set("weight", (Object)row.getBigDecimal("weight"));
            entryRow.set("bizbillid", (Object)row.getBigDecimal("bizbillid"));
            entryRow.set("billno", (Object)row.getString("billno"));
            entryRow.set("groupno", (Object)0L);
            entryRow.set("isbeforeperiod", (Object)row.getBoolean("isbeforeperiod"));
        }
        HashSet<DynamicObject> records = new HashSet<DynamicObject>(resultMap.values());
        return records;
    }

    private DataSet getBizGroupJoinCostRecordDS(DataSet dataSet) {
        String costRecordSelect = "billstatus,invscheme.isinupdate,invscheme.isoutupdate,calbilltype,entry.bizbillentryid as bizbillentryid,bookdate,period,period.enddate as periodenddate,costaccount.booktype as booktype,costaccount.booktype.isingroup as isingroup,calbillid,entry.calentryid as calentryid, entry.id as costrecordentryid,costaccount,entry.material as material,entry.baseqty as baseqty,entry.weight as weight,entry.accounttype as accounttype,entry.isrework as isrework";
        HashSet<Long> allBizBillIds = new HashSet<Long>(16);
        HashSet<Long> allOwnerids = new HashSet<Long>(16);
        Date minBookdate = null;
        Date maxBookdate = null;
        for (Row row : dataSet.copy().groupBy(new String[]{"bizbillid", "owner"}).min("bookdate", "minbookdate").max("bookdate", "maxbookdate").finish()) {
            allBizBillIds.add(row.getLong("bizbillid"));
            allOwnerids.add(row.getLong("owner"));
            Date curMinBookdate = row.getDate("minbookdate");
            Date curMaxBookdate = row.getDate("maxbookdate");
            if (curMinBookdate != null && (minBookdate == null || minBookdate.after(curMinBookdate))) {
                minBookdate = curMinBookdate;
            }
            if (curMaxBookdate == null || maxBookdate != null && !maxBookdate.before(curMaxBookdate)) continue;
            maxBookdate = curMaxBookdate;
        }
        DataSet costAccountDs = AccountingSysHelper.getAccountingSysCostaccountDataSetByOwners(allOwnerids);
        HashSet<Long> allCostAccountIds = new HashSet<Long>(4);
        for (Row row : costAccountDs.copy()) {
            allCostAccountIds.add(row.getLong("costaccount"));
        }
        DataSet costRecordSet = null;
        QFilter filter = new QFilter("issplitcreate", "=", (Object)false);
        filter.and("costaccount", "in", allCostAccountIds);
        filter.and("bookdate", ">=", (Object)minBookdate);
        filter.and("bookdate", "<=", (Object)maxBookdate);
        if (allBizBillIds.size() >= 50000) {
            ArrayList crInputs = new ArrayList(16);
            Lists.partition(new ArrayList(allBizBillIds), (int)50000).forEach(list -> {
                QFilter crFilter = new QFilter("bizbillid", "in", list);
                new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", crFilter, this.filterGroupAcct);
                OrmInput crInput = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", costRecordSelect, new QFilter[]{crFilter, filter});
                crInputs.add(crInput);
            });
            costRecordSet = Algo.create((String)this.getClass().getName()).createDataSet(crInputs.toArray(new Input[crInputs.size()]));
        } else {
            QFilter crFilter = new QFilter("bizbillid", "in", allBizBillIds);
            new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", crFilter, this.filterGroupAcct);
            costRecordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)costRecordSelect, (QFilter[])new QFilter[]{crFilter, filter}, null);
        }
        DataSet groupRecord = dataSet.join(costRecordSet, JoinType.LEFT).on("bizentryid", "bizbillentryid").select(new String[]{"id", "bgsetting as groupsetting", "iscompleted", "type", "bizbillid", "bgsetting.grouptype", "groupvalue", "billno", "owner", "bizentityobject"}, costRecordSet.getRowMeta().getFieldNames()).finish();
        DataSet[] groupRecords = groupRecord.splitByFilter(new String[]{"booktype == null"}, true);
        HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(groupRecord.getRowMeta().getFieldNames()));
        HashSet<String> noTypeFields = new HashSet<String>(fieldNames);
        noTypeFields.remove("costaccount");
        noTypeFields.remove("booktype");
        noTypeFields.remove("isingroup");
        groupRecords[0] = groupRecords[0].join(costAccountDs, JoinType.LEFT).on("owner", "owner").select(noTypeFields.toArray(new String[0]), new String[]{"costaccount", "booktype", "isingroup"}).finish();
        groupRecords[0] = groupRecords[0].select("id,groupsetting,iscompleted,type,bizbillid,bgsetting.grouptype,groupvalue,billno,owner,bizentityobject,'A' as billstatus,true as invscheme.isinupdate,true as invscheme.isoutupdate,'OUT' calbilltype,0L as bizbillentryid,null as bookdate,0L as period,null as periodenddate,case when booktype = null then 0L else booktype end as booktype,case when isingroup = null then false else isingroup end as isingroup,0L as calbillid,0L as calentryid,0L as costrecordentryid,case when costaccount = null then 0L else costaccount end as costaccount,0L as material,0 as baseqty,0 as weight,' ' as accounttype,False as isrework");
        groupRecord = groupRecords[1].union(groupRecords[0]);
        return groupRecord;
    }

    private String getCostFields() {
        if (StringUtils.isEmpty((String)this.costfields)) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id", (QFilter[])new QFilter("syncflag", "=", (Object)"1").toArray(), null);){
                HashSet<String> set = new HashSet<String>(16);
                for (Row row : ds) {
                    set.add(row.getString("id"));
                }
                this.costfields = String.join((CharSequence)",", set);
            }
        }
        return this.costfields;
    }

    private DataSet getAccGroupDataSet(Set<QFilter> accFilters, Map<Long, Long> currentPeriodIdMap) {
        DataSet accIdDS;
        HashSet<Long> accIds = new HashSet<Long>(16);
        if (accFilters != null && accFilters.size() == 1) {
            QFilter accFilter = accFilters.iterator().next();
            new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("entryentity.costaccount", accFilter, this.filterGroupAcct);
            accIdDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])accFilter.toArray(), null);
            for (Row row : accIdDS) {
                accIds.add(row.getLong("id"));
            }
        } else if (accFilters != null && accFilters.size() > 1) {
            ArrayList<OrmInput> accidInputs = new ArrayList<OrmInput>(16);
            for (QFilter qFilter : accFilters) {
                new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("entryentity.costaccount", qFilter, this.filterGroupAcct);
                OrmInput accinput = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", "id", qFilter.toArray());
                accidInputs.add(accinput);
            }
            accIdDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])accidInputs.toArray(new OrmInput[0]));
            for (Row row : accIdDS) {
                accIds.add(row.getLong("id"));
            }
        }
        DataSet accReocrdDS = null;
        RowMeta rowMeta = ORM.create().createRowMeta("cal_account_grouprecord", ACCOUNT_GROUP_SELECT);
        rowMeta.getField("groupid").setDataType((DataType)DataType.StringType);
        rowMeta.getField("billstatus").setDataType((DataType)DataType.StringType);
        if (accIds.isEmpty()) {
            DataSet dataSet = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
            return dataSet;
        }
        if (accIds.size() <= 50000) {
            QFilter qFilter = new QFilter("id", "in", accIds);
            accReocrdDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)ACCOUNT_GROUP_SELECT, (QFilter[])qFilter.toArray(), null);
        } else {
            ArrayList arrayList = new ArrayList(16);
            Lists.partition(new ArrayList(accIds), (int)50000).forEach(list -> {
                QFilter accFilter = new QFilter("id", "in", list);
                OrmInput accinput = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", ACCOUNT_GROUP_SELECT, accFilter.toArray(), rowMeta);
                accReocrdInputs.add(accinput);
            });
            accReocrdDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])arrayList.toArray(new OrmInput[0]));
        }
        if (!this.needAfterGroup && currentPeriodIdMap != null) {
            DataSet dataSet = this.getResolveCostAccountCurPeriodDS(currentPeriodIdMap);
            accReocrdDS = accReocrdDS.join(dataSet, JoinType.INNER).on("costaccount", "costaccount").on("period", "period").select(accReocrdDS.getRowMeta().getFieldNames(), null).finish();
        }
        return accReocrdDS;
    }

    private DataSet getResolveCostAccountCurPeriodDS(Map<Long, Long> currentPeriodIdMap) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("costaccount", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType)});
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Long> entry : currentPeriodIdMap.entrySet()) {
            Long costAccountid = entry.getKey();
            Long period = entry.getValue();
            builder.append(new Object[]{costAccountid, period});
        }
        return builder.build();
    }

    private DataSet getBizGroupRecordAndSpecialRecordDataSet(Set<QFilter> bgFilters, Set<QFilter> spBgFilters, boolean needQuerTwice, Map<Long, Long> currentPeriodMap) {
        DataSet bgRecordDS = this.getBizGrouopRecordDataSet(bgFilters);
        bgRecordDS = bgRecordDS.distinct();
        DataSet groupRecordDS = this.getBizGroupJoinCostRecordDS(bgRecordDS);
        DataSet specialGroupRecordDS = this.specialGroupRecordBuilder.getSpecialGroupRecord(spBgFilters, needQuerTwice);
        groupRecordDS = groupRecordDS.union(specialGroupRecordDS);
        if (currentPeriodMap == null || currentPeriodMap.isEmpty()) {
            currentPeriodMap = this.getCurrentPeriodMap();
        }
        groupRecordDS = groupRecordDS.groupBy(new String[]{"id", "groupsetting", "booktype"}).reduceGroup((ReduceGroupFunctionWithCollector)new BizGroupRecordBuilderFunction(currentPeriodMap, costcolumn, this.getCostFields(), this.needAfterGroup));
        return groupRecordDS;
    }

    private Map<Long, Long> getCurrentPeriodMap() {
        HashSet<Long> allCostaccountIds = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id", null, null);){
            for (Row row : ds) {
                Long costAccountId = row.getLong("id");
                allCostaccountIds.add(costAccountId);
            }
        }
        Map currentPeriodDynMap = PeriodHelper.getCurrentPeriods(allCostaccountIds);
        HashMap<Long, Long> currentPeriodMap = new HashMap<Long, Long>(16);
        for (Long allCostaccountId : allCostaccountIds) {
            DynamicObject periodDyn = (DynamicObject)currentPeriodDynMap.get(allCostaccountId);
            Long periodid = 0L;
            if (periodDyn != null) {
                periodid = periodDyn.getLong("id");
            }
            currentPeriodMap.put(allCostaccountId, periodid);
        }
        return currentPeriodMap;
    }

    private DataSet getBizGrouopRecordDataSet(Set<QFilter> bgFilters) {
        HashSet<Long> bgIds = new HashSet<Long>(16);
        if (bgFilters != null && bgFilters.size() == 1) {
            DataSet bgIdDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_bgrecord", (String)"id", (QFilter[])bgFilters.iterator().next().toArray(), null);
            for (Row row : bgIdDS) {
                bgIds.add(row.getLong("id"));
            }
        } else if (bgFilters != null && bgFilters.size() > 1) {
            ArrayList<OrmInput> idInputs = new ArrayList<OrmInput>(16);
            for (QFilter filter : bgFilters) {
                OrmInput input = new OrmInput(this.getClass().getName(), "im_bgrecord", "id", filter.toArray());
                idInputs.add(input);
            }
            DataSet bgIdDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])idInputs.toArray(new OrmInput[0]));
            for (Row row : bgIdDS) {
                bgIds.add(row.getLong("id"));
            }
        }
        DataSet bgRecordDS = null;
        if (bgIds.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta("im_bgrecord", IM_BGGROUP_SELECT);
            bgRecordDS = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        } else if (bgIds.size() <= 50000) {
            QFilter filter = new QFilter("id", "in", bgIds);
            bgRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_bgrecord", (String)IM_BGGROUP_SELECT, (QFilter[])filter.toArray(), null);
        } else {
            ArrayList bgReocrdInputs = new ArrayList(16);
            Lists.partition(new ArrayList(bgIds), (int)50000).forEach(list -> {
                QFilter filter = new QFilter("id", "in", list);
                OrmInput input = new OrmInput(this.getClass().getName(), "im_bgrecord", IM_BGGROUP_SELECT, filter.toArray());
                bgReocrdInputs.add(input);
            });
            bgRecordDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])bgReocrdInputs.toArray(new OrmInput[0]));
        }
        return bgRecordDS;
    }

    public void setFilterGroupAcct(boolean filterGroupAcct) {
        this.filterGroupAcct = filterGroupAcct;
    }
}

