/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.cal.common.enums.AccountTypeEnum;

public class BizGroupRecordBuilderFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = -6405236007665408923L;
    private static final List<String> mdcbill = Arrays.asList("im_mdc_mftproorder", "im_mdc_mftfeedorder", "im_mdc_mftreturnorder");
    private Map<Long, Long> currentPeriodMap;
    private String costcolumn;
    private String costfields;
    private boolean needAfterGroup;

    public BizGroupRecordBuilderFunction(Map<Long, Long> currentPeriodMap, String costcolumn, String costfields, boolean needAfterGroup) {
        this.currentPeriodMap = currentPeriodMap;
        this.costcolumn = costcolumn;
        this.costfields = costfields;
        this.needAfterGroup = needAfterGroup;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        boolean isMdcReturn;
        boolean isDestMdcStandard = false;
        BigDecimal srcqty = BigDecimal.ZERO;
        BigDecimal destqty = BigDecimal.ZERO;
        boolean hasSrc = false;
        boolean hasDest = false;
        boolean destHasPos = false;
        boolean destHasNeg = false;
        boolean hasCurrentPeriod = false;
        boolean isingroup = false;
        boolean srcNotRework = false;
        boolean destRework = false;
        HashSet<Long> costAccountIds = new HashSet<Long>(4);
        ArrayList<Object[]> result = new ArrayList<Object[]>(4);
        HashSet<Long> costrecordentryids = new HashSet<Long>(4);
        boolean noAbsense = true;
        while (iterator.hasNext()) {
            boolean isBeforePeriod;
            boolean needCollect;
            Row row = iterator.next();
            Long costRecordEntryId = row.getLong("costrecordentryid");
            if (costRecordEntryId == null || costRecordEntryId.compareTo(0L) == 0) {
                noAbsense = false;
            }
            if (costRecordEntryId != null && !costrecordentryids.add(costRecordEntryId)) continue;
            String setGroupType = row.getString("bgsetting.grouptype");
            Boolean invSchemeOutUpdate = row.getBoolean("invscheme.isoutupdate");
            Boolean invSchemeInUpdate = row.getBoolean("invscheme.isinupdate");
            String bizObject = row.getString("bizentityobject");
            if ("im_adjustbill".equals(bizObject) || "im_assembbill".equals(bizObject) || "im_disassemblebill".equals(bizObject) || "im_locationtransfer".equals(bizObject)) {
                invSchemeOutUpdate = true;
                invSchemeInUpdate = true;
            }
            String calBilltype = row.getString("calbilltype");
            String type = row.getString("type");
            boolean mulBillOut = !(!setGroupType.equals("A") && !setGroupType.equals("B") || invSchemeOutUpdate != null && invSchemeOutUpdate == false || !"OUT".equals(calBilltype));
            boolean mulBillIn = (setGroupType.equals("A") || setGroupType.equals("B")) && invSchemeOutUpdate != null && invSchemeOutUpdate == false && invSchemeInUpdate != false && "IN".equals(calBilltype);
            boolean singleBill = setGroupType.equals("C") && ("0".equals(type) && "OUT".equals(calBilltype) || "1".equals(type) && "IN".equals(calBilltype));
            boolean bl = needCollect = mulBillOut || mulBillIn || singleBill;
            if (!needCollect) continue;
            String bizentityobject = row.getString("bizentityobject");
            String accounttype = row.getString("accounttype");
            isDestMdcStandard = isDestMdcStandard || "1".equals(type) && AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype) && mdcbill.contains(bizentityobject);
            BigDecimal qty = row.getBigDecimal("baseqty");
            boolean rework = row.getBoolean("isrework");
            if ("0".equals(type)) {
                srcqty = srcqty.add(qty);
                srcNotRework = srcNotRework || !rework;
            } else {
                destqty = destqty.add(qty);
                boolean bl2 = destRework = destRework || rework;
                if (qty.signum() > 0) {
                    destHasPos = true;
                } else if (qty.signum() < 0) {
                    destHasNeg = true;
                }
            }
            isingroup = row.getBoolean("isingroup");
            StringBuilder groupid = new StringBuilder();
            Long id = row.getLong("id");
            Long groupsetting = row.getLong("groupsetting");
            Long booktype = row.getLong("booktype");
            Long costaccount = row.getLong("costaccount");
            groupid.append(id);
            groupid.append("#");
            groupid.append(groupsetting);
            groupid.append("#");
            groupid.append(booktype);
            if (!isingroup) {
                groupid.append("#");
                groupid.append(costaccount);
            }
            Long period = row.getLong("period");
            Long curperiod = this.currentPeriodMap.get(costaccount);
            if (curperiod == null) continue;
            boolean bl3 = isBeforePeriod = period.compareTo(curperiod) < 0;
            if (!this.needAfterGroup && period.compareTo(curperiod) > 0) {
                noAbsense = false;
                continue;
            }
            if (!isBeforePeriod) {
                hasCurrentPeriod = true;
            }
            costAccountIds.add(costaccount);
            BigDecimal weight = BigDecimal.ONE;
            if ("0".equals(type)) {
                hasSrc = true;
            } else {
                hasDest = true;
                weight = row.getBigDecimal("weight").abs();
                if (weight.compareTo(BigDecimal.ZERO) == 0) {
                    weight = qty.abs();
                }
            }
            Object[] values = this.getCurrentRow(row, groupid.toString(), isBeforePeriod, weight);
            result.add(values);
        }
        boolean bl = isMdcReturn = isDestMdcStandard && srcqty.signum() * destqty.signum() < 0;
        if (isMdcReturn) {
            return;
        }
        if (!isingroup && costAccountIds.size() > 1) {
            return;
        }
        if (srcNotRework && destRework) {
            return;
        }
        if (hasCurrentPeriod && hasSrc && hasDest) {
            for (Object[] objects : result) {
                objects[2] = destHasNeg && destHasPos ? Boolean.valueOf(false) : Boolean.valueOf(noAbsense && (Boolean)objects[2] != false);
                collector.collect(objects);
            }
        }
    }

    private Object[] getCurrentRow(Row row, String groupid, boolean isBeforePeriod, BigDecimal weight) {
        Object[] values = new Object[]{row.getLong("id"), row.getLong("groupsetting"), row.getBoolean("iscompleted"), this.costcolumn, this.costfields, row.getString("groupvalue"), row.getString("type"), row.getLong("bizbillid"), row.getString("billno"), row.getLong("booktype"), row.getBoolean("isingroup"), row.getLong("calbillid"), row.getLong("calentryid"), row.getLong("costrecordentryid"), row.getLong("costaccount"), row.getLong("material"), row.getDate("bookdate"), row.getLong("period"), row.getDate("periodenddate"), row.getBigDecimal("baseqty"), row.getBigDecimal("baseqty"), weight, 0L, isBeforePeriod, groupid, row.getString("billstatus")};
        return values;
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("groupsetting", (DataType)DataType.LongType), new Field("iscompleted", (DataType)DataType.BooleanType), new Field("costcolumn", (DataType)DataType.StringType), new Field("costfields", (DataType)DataType.StringType), new Field("groupvalue", (DataType)DataType.StringType), new Field("type", (DataType)DataType.StringType), new Field("bizbillid", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("booktype", (DataType)DataType.LongType), new Field("isingroup", (DataType)DataType.BooleanType), new Field("calbillid", (DataType)DataType.LongType), new Field("calentryid", (DataType)DataType.LongType), new Field("costrecordentryid", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("bookdate", (DataType)DataType.DateType), new Field("period", (DataType)DataType.LongType), new Field("periodenddate", (DataType)DataType.DateType), new Field("baseqty", (DataType)DataType.BigDecimalType), new Field("occupiedqty", (DataType)DataType.BigDecimalType), new Field("weight", (DataType)DataType.BigDecimalType), new Field("groupno", (DataType)DataType.LongType), new Field("isbeforeperiod", (DataType)DataType.BooleanType), new Field("groupid", (DataType)DataType.StringType), new Field("billstatus", (DataType)DataType.StringType)});
    }
}

