/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BizGroupRecordDelete4Cal {
    private static Log log = LogFactory.getLog(BizGroupRecordDelete4Cal.class);
    private static final String SELECT_FIELDS = "id,groupvalue,iscompleted,updatetime,entryentity.id,entryentity.type,entryentity.formid,entryentity.bizbillid,entryentity.bizentryid,entryentity.baseqty,entryentity.islastentry,entryentity.isdel,entryentity.ischargeoffed";

    public static Set<Long> deleteRecord(Map<String, Set<Long>> formId2BizbillidMap, boolean recreate) {
        Set<Long> bizBillIds = BizGroupRecordDelete4Cal.getAllBizBillIds(formId2BizbillidMap);
        HashSet<Long> allBizBillIds = new HashSet<Long>(16);
        Lists.partition(new ArrayList<Long>(bizBillIds), (int)1000).forEach(list -> {
            DynamicObject[] records;
            HashSet curPartBizBillids = new HashSet(1000);
            curPartBizBillids.addAll(list);
            HashSet<Long> deleteRecordIds = new HashSet<Long>(16);
            ArrayList<Object[]> deleteRecordEntryIds = new ArrayList<Object[]>(16);
            Date maxUpdateTime = null;
            HashSet<DynamicObject> updateRecords = new HashSet<DynamicObject>(16);
            QFilter filter = new QFilter("entryentity.bizbillid", "in", list);
            for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"im_bgrecord", (String)SELECT_FIELDS, (QFilter[])filter.toArray())) {
                DynamicObjectCollection entry = record.getDynamicObjectCollection("entryentity");
                Iterator iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entryRow = (DynamicObject)iterator.next();
                    Long bizbillid = entryRow.getLong("bizbillid");
                    boolean isDel = entryRow.getBoolean("isdel");
                    allBizBillIds.add(bizbillid);
                    if (!recreate && (!isDel || !curPartBizBillids.contains(bizbillid))) continue;
                    deleteRecordEntryIds.add(new Object[]{entryRow.getLong("id")});
                    iterator.remove();
                }
                boolean hasSrc = false;
                boolean hasDest = false;
                boolean destHasPos = false;
                boolean destHasNeg = false;
                BigDecimal srcQty = BigDecimal.ZERO;
                BigDecimal destQty = BigDecimal.ZERO;
                boolean islastentry = false;
                boolean hasChargeOff = false;
                for (DynamicObject entryRow : entry) {
                    boolean isDel = entryRow.getBoolean("isdel");
                    String formid = entryRow.getString("formid.id");
                    if (isDel) continue;
                    boolean ischargeoffed = entryRow.getBoolean("ischargeoffed");
                    String type = entryRow.getString("type");
                    islastentry = islastentry || entryRow.getBoolean("islastentry");
                    BigDecimal baseqty = entryRow.getBigDecimal("baseqty");
                    if ("1".equals(type)) {
                        if (baseqty.signum() > 0) {
                            destHasPos = true;
                        } else if (baseqty.signum() < 0) {
                            destHasNeg = true;
                        }
                        hasDest = true;
                    } else {
                        hasSrc = true;
                    }
                    if ("1".equals(type) && ischargeoffed) {
                        if (!"im_transinbill".equals(formid)) continue;
                        hasChargeOff = true;
                    }
                    if ("0".equals(type)) {
                        srcQty = srcQty.add(baseqty);
                        continue;
                    }
                    if (!"1".equals(type)) continue;
                    destQty = destQty.add(baseqty);
                }
                if (hasSrc && hasDest) {
                    boolean iscompleted;
                    boolean bl = iscompleted = islastentry || destQty.abs().compareTo(srcQty.abs()) >= 0;
                    if (destHasNeg && destHasPos) {
                        iscompleted = false;
                    }
                    if (hasChargeOff) {
                        iscompleted = false;
                    }
                    record.set("iscompleted", (Object)iscompleted);
                    record.set("updatetime", (Object)TimeServiceHelper.now());
                    updateRecords.add(record);
                    continue;
                }
                deleteRecordIds.add(record.getLong("id"));
                Date updateTime = record.getDate("updatetime");
                if (updateTime == null || maxUpdateTime != null && !maxUpdateTime.before(updateTime)) continue;
                maxUpdateTime = updateTime;
            }
            try (TXHandle tx = TX.requiresNew();){
                BizGroupRecordDelete4Cal.deleteSave2DB(deleteRecordIds, maxUpdateTime);
                BizGroupRecordDelete4Cal.deleteEntrySave2DB(deleteRecordEntryIds);
                BizGroupRecordDelete4Cal.updateSave2DB(updateRecords);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u5931\u8d25", (Throwable)e);
                throw e;
            }
        });
        return allBizBillIds;
    }

    private static void deleteEntrySave2DB(List<Object[]> deleteRecordEntryIds) {
        Lists.partition(deleteRecordEntryIds, (int)1000).forEach(list -> DB.executeBatch((DBRoute)new DBRoute("scm"), (String)"delete from t_im_bgrecorde where fentryid = ? ", (List)list));
    }

    private static void updateSave2DB(Set<DynamicObject> updateRecords) {
        if (updateRecords == null || updateRecords.isEmpty()) {
            return;
        }
        Lists.partition(new ArrayList<DynamicObject>(updateRecords), (int)1000).forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
    }

    private static void deleteSave2DB(Set<Long> deleteRecordIds, Date maxUpdateTime) {
        if (deleteRecordIds == null || deleteRecordIds.isEmpty() || maxUpdateTime == null) {
            return;
        }
        Lists.partition(new ArrayList<Long>(deleteRecordIds), (int)1000).forEach(list -> {
            QFilter idFilter = new QFilter("id", "in", list);
            idFilter.and("updatetime", "<=", (Object)maxUpdateTime);
            DeleteServiceHelper.delete((String)"im_bgrecord", (QFilter[])idFilter.toArray());
        });
    }

    private static Set<Long> getAllBizBillIds(Map<String, Set<Long>> formId2BizbillidMap) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Set<Long> value : formId2BizbillidMap.values()) {
            bizBillIds.addAll(value);
        }
        return bizBillIds;
    }
}

