/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordDelete4Cal;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class BizGroupRecordHelper {
    private static Log log = LogFactory.getLog(BizGroupRecordHelper.class);
    private CostDomainGroupHelper costDomainGroupHelper = new CostDomainGroupHelper();
    private boolean filterGroupAcct = false;

    public Set<Long> reCreateBizGroupRecord(Set<String> formids, Set<String> billnos, Date startBookDate, Date endBookDate) {
        Map<String, Set<Long>> formId2BizbillidMap = this.getFormId2BizbillidMapByBillnoBookdate(formids, billnos, startBookDate, endBookDate);
        Set<Long> allDelBizBillIds = this.deleteBizGroupRecordUpdateCostDomin(formId2BizbillidMap, true);
        Set<Long> allCreateBizBillids = BizGroupRecordHelper.createBizGroupRecord(formId2BizbillidMap);
        this.updateCostDomin(formId2BizbillidMap);
        HashSet<Long> allGroupBizBillIds = new HashSet<Long>(16);
        allGroupBizBillIds.addAll(allDelBizBillIds);
        allGroupBizBillIds.addAll(allCreateBizBillids);
        return allGroupBizBillIds;
    }

    private void updateCostDomin(Map<String, Set<Long>> formId2BizbillidMap) {
        this.costDomainGroupHelper.insertAndUpdateCostDomainGroupByBizBill(formId2BizbillidMap);
    }

    public static Set<Long> createBizGroupRecord(Map<String, Set<Long>> formId2BizbillidMap) {
        Boolean isBySrc = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.BIZGROUPBILL_ISBYSRC);
        HashSet<Long> allCreateBizBillIds = new HashSet<Long>(16);
        for (Map.Entry<String, Set<Long>> setEntry : formId2BizbillidMap.entrySet()) {
            String entity = setEntry.getKey();
            Set<Long> bizBillIds = setEntry.getValue();
            try {
                TXHandle tx = TX.requiresNew();
                Throwable throwable = null;
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u751f\u6210\u6210\u7ec4\u5173\u7cfb");
                    Set ids1 = (Set)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"BizGroupRecordService", (String)"createRecord", (Object[])new Object[]{Collections.singletonMap(entity, bizBillIds), true});
                    allCreateBizBillIds.addAll(ids1);
                    if (!isBySrc.booleanValue()) continue;
                    Set ids2 = (Set)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"BizGroupRecordService", (String)"createRecord", (Object[])new Object[]{Collections.singletonMap(entity, bizBillIds), false});
                    allCreateBizBillIds.addAll(ids2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u751f\u6210\u6210\u7ec4\u5173\u7cfb\u5931\u8d25", (Throwable)e);
                throw e;
            }
        }
        return allCreateBizBillIds;
    }

    public Set<Long> deleteBizGroupRecordUpdateCostDomin(Map<String, Set<Long>> formId2BizbillidMap, boolean recreate) {
        this.costDomainGroupHelper.deleteAndUpdateCostDomainGroupByBizBill(formId2BizbillidMap);
        Set<Long> allDelBizBillIds = BizGroupRecordDelete4Cal.deleteRecord(formId2BizbillidMap, recreate);
        return allDelBizBillIds;
    }

    private Map<String, Set<Long>> getFormId2BizbillidMapByBillnoBookdate(Set<String> formids, Set<String> billnos, Date startBookDate, Date endBookDate) {
        QFilter settingFilter = new QFilter("enable", "=", (Object)"1");
        if (formids != null && !formids.isEmpty()) {
            settingFilter.and("sourcebill", "in", formids);
        }
        settingFilter.and("fieldmap.calfield", "in", (Object)new String[]{"billno", "bookdate"});
        HashMap<String, Map> calBillRuleMap = new HashMap<String, Map>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calbillrule", (String)"sourcebill,fieldmap.calfield,fieldmap.sourcefield", (QFilter[])settingFilter.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                String sourcebill = row.getString("sourcebill");
                String calfield = row.getString("fieldmap.calfield");
                String sourcefield = row.getString("fieldmap.sourcefield");
                if (StringUtils.isEmpty((String)calfield) || StringUtils.isEmpty((String)sourcefield)) continue;
                Map map = calBillRuleMap.computeIfAbsent(sourcebill, k -> new HashMap(4));
                map.put(calfield, sourcefield);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        for (Map.Entry entry : calBillRuleMap.entrySet()) {
            String formid = (String)entry.getKey();
            Map fieldMap = (Map)entry.getValue();
            QFilter filter = null;
            if (billnos != null && !billnos.isEmpty()) {
                filter = new QFilter((String)fieldMap.get("billno"), "in", billnos);
            } else if (startBookDate != null) {
                filter = new QFilter((String)fieldMap.get("bookdate"), ">=", (Object)startBookDate);
                if (endBookDate != null) {
                    filter.and((String)fieldMap.get("bookdate"), "<", (Object)endBookDate);
                }
            }
            if (filter == null) continue;
            if (formid.contains("im_mdc_")) {
                filter.and("billtype.billformid", "=", (Object)formid);
            }
            OrmInput input = new OrmInput(this.getClass().getName(), formid, "'" + formid + "' as formid,id", filter.toArray());
            inputs.add(input);
        }
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(16);
        if (!inputs.isEmpty()) {
            try (DataSet dataSet2 = Algo.create((String)this.getClass().getName()).createDataSet(inputs.toArray(new Input[0]));){
                for (Row row : dataSet2) {
                    String formid = row.getString("formid");
                    Long id = row.getLong("id");
                    Set ids = map.computeIfAbsent(formid, k -> new HashSet());
                    ids.add(id);
                }
            }
        }
        return map;
    }

    public void setFilterGroupAcct(boolean filterGroupAcct) {
        this.filterGroupAcct = filterGroupAcct;
        this.costDomainGroupHelper.setFilterGroupAcct(this.filterGroupAcct);
    }
}

