/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BizGroupRecordSpecialBuilder {
    private static final String[] SPECIAL_GROUPTYPE = new String[]{"C", "B"};
    private static final RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("groupsetting", (DataType)DataType.LongType), new Field("iscompleted", (DataType)DataType.BooleanType), new Field("type", (DataType)DataType.StringType), new Field("bizbillid", (DataType)DataType.LongType), new Field("bgsetting.grouptype", (DataType)DataType.StringType), new Field("groupvalue", (DataType)DataType.StringType), new Field("billno", (DataType)DataType.StringType), new Field("owner", (DataType)DataType.LongType), new Field("bizentityobject", (DataType)DataType.StringType), new Field("billstatus", (DataType)DataType.StringType), new Field("invscheme.isinupdate", (DataType)DataType.BooleanType), new Field("invscheme.isoutupdate", (DataType)DataType.BooleanType), new Field("calbilltype", (DataType)DataType.StringType), new Field("bizbillentryid", (DataType)DataType.LongType), new Field("bookdate", (DataType)DataType.DateType), new Field("period", (DataType)DataType.LongType), new Field("periodenddate", (DataType)DataType.DateType), new Field("booktype", (DataType)DataType.LongType), new Field("isingroup", (DataType)DataType.BooleanType), new Field("calbillid", (DataType)DataType.LongType), new Field("calentryid", (DataType)DataType.LongType), new Field("costrecordentryid", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("baseqty", (DataType)DataType.BigDecimalType), new Field("weight", (DataType)DataType.BigDecimalType), new Field("accounttype", (DataType)DataType.StringType), new Field("isrework", (DataType)DataType.BooleanType)});
    private static final List<String> matChangeEntitys = Arrays.asList("im_assembbill", "im_disassemblebill", "im_adjustbill");
    public static final String COSTRECORD_SELECTFIELDS = "id,billno,bizentityobject,ischargeoff,calbilltype,bizbillid,entry.srcbillid,entry.srcbillentryid,entry.mainbillid,entry.mainbillentryid,entry.owner as owner,billstatus,invscheme.isinupdate,invscheme.isoutupdate,entry.bizbillentryid as bizbillentryid,bookdate,period,period.enddate as periodenddate,costaccount.booktype as booktype,costaccount.booktype.isingroup as isingroup,calbillid,entry.calentryid as calentryid, entry.id as costrecordentryid,costaccount,entry.material as material,entry.baseqty as baseqty,entry.weight as weight,entry.accounttype as accounttype,entry.isrework as isrework";
    private Map<String, String> singleEnttity2RelTypeMap = new HashMap<String, String>(16);
    private Map<String, String> charegeoffEntity2RelTypeMap = new HashMap<String, String>(16);
    private Set<String> allformids = new HashSet<String>(4);
    private Long singleBillSettingId = 0L;
    private Long chargeOffBillSettingId = 0L;

    public BizGroupRecordSpecialBuilder() {
        this.initBGSettings();
    }

    private void initBGSettings() {
        QFilter filter = new QFilter("grouptype", "in", (Object)SPECIAL_GROUPTYPE);
        filter.and("enable", "=", (Object)"1");
        Map settingMap = BusinessDataServiceHelper.loadFromCache((String)"im_bizgroupsetting", (String)"id,grouptype,formid,reltype", (QFilter[])filter.toArray());
        if (settingMap == null || settingMap.isEmpty()) {
            return;
        }
        for (DynamicObject setting : settingMap.values()) {
            String grouptype = setting.getString("grouptype");
            if ("C".equals(grouptype)) {
                this.singleBillSettingId = setting.getLong("id");
            } else if ("B".equals(grouptype)) {
                this.chargeOffBillSettingId = setting.getLong("id");
            }
            DynamicObjectCollection entry = setting.getDynamicObjectCollection("groupbillentry");
            for (DynamicObject entryRow : entry) {
                String formid = entryRow.getString("formid.id");
                this.allformids.add(formid);
                String reltype = entryRow.getString("reltype");
                if ("C".equals(grouptype)) {
                    this.singleEnttity2RelTypeMap.put(formid, reltype);
                    continue;
                }
                if (!"B".equals(grouptype)) continue;
                this.charegeoffEntity2RelTypeMap.put(formid, reltype);
            }
        }
    }

    public DataSet getSpecialGroupRecord(Set<QFilter> spBgFilters, boolean needQuerTwice) {
        HashMap<String, Set<Long>> chargeOffEntityIdMap = new HashMap<String, Set<Long>>(16);
        DataSet ds = this.getCostRecord(spBgFilters);
        DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        HashSet<Long> matChangeBizBillIds = new HashSet<Long>(16);
        HashSet<Long> groupids = new HashSet<Long>(16);
        this.buildGroupRecordDS(chargeOffEntityIdMap, ds, builder, matChangeBizBillIds, groupids, false);
        if (needQuerTwice && !matChangeBizBillIds.isEmpty()) {
            HashSet<QFilter> twiceFilters = new HashSet<QFilter>(16);
            Lists.partition(new ArrayList<Long>(matChangeBizBillIds), (int)10000).forEach(list -> twiceFilters.add(new QFilter("bizbillid", "in", list)));
            ds = this.getCostRecord(twiceFilters);
            this.buildGroupRecordDS(chargeOffEntityIdMap, ds, builder, matChangeBizBillIds, groupids, true);
        }
        DataSet chargeoffSrcBillDS = this.getCostRecord(chargeOffEntityIdMap);
        for (Row row : chargeoffSrcBillDS) {
            Long bizbillid = row.getLong("bizbillid");
            Long bizbillentryid = row.getLong("bizbillentryid");
            String billno = row.getString("billno");
            Long owner = row.getLong("owner");
            String bizentityobject = row.getString("bizentityobject");
            builder.append(this.getRowObjectArr(bizbillentryid, this.chargeOffBillSettingId, "0", "B", row));
        }
        DataSet dataSet = builder.build().distinct();
        return dataSet;
    }

    private void buildGroupRecordDS(Map<String, Set<Long>> chargeOffEntityIdMap, DataSet ds, DataSetBuilder builder, Set<Long> matChangeBizBillIds, Set<Long> groupids, boolean isTwice) {
        for (Row row : ds) {
            Set ids;
            Long groupId;
            String singelRelType;
            String entity = row.getString("bizentityobject");
            boolean ischargeoff = row.getBoolean("ischargeoff");
            Long bizbillid = row.getLong("bizbillid");
            Long bizbillentryid = row.getLong("bizbillentryid");
            Long srcbillid = row.getLong("entry.srcbillid");
            Long srcbillentryid = row.getLong("entry.srcbillentryid");
            Long mainbillid = row.getLong("entry.mainbillid");
            Long mainbillentryid = row.getLong("entry.mainbillentryid");
            String calbilltype = row.getString("calbilltype");
            String billno = row.getString("billno");
            Long owner = row.getLong("owner");
            String bizentityobject = row.getString("bizentityobject");
            if (matChangeEntitys.contains(entity)) {
                matChangeBizBillIds.add(bizbillid);
            }
            if (StringUtils.isNotEmpty((String)(singelRelType = this.singleEnttity2RelTypeMap.get(entity)))) {
                String type = " ";
                groupId = 0L;
                if ("IN".equals(calbilltype)) {
                    type = "1";
                } else if ("OUT".equals(calbilltype)) {
                    type = "0";
                }
                if ("A".equals(singelRelType)) {
                    groupId = bizbillentryid;
                } else if ("B".equals(singelRelType)) {
                    if ("IN".equals(calbilltype)) {
                        groupId = srcbillentryid;
                    } else if ("OUT".equals(calbilltype)) {
                        groupId = bizbillentryid;
                    }
                } else if ("C".equals(singelRelType)) {
                    if ("IN".equals(calbilltype)) {
                        groupId = bizbillentryid;
                    } else if ("OUT".equals(calbilltype)) {
                        groupId = srcbillentryid;
                    }
                }
                if (groupId != 0L) {
                    if (isTwice) {
                        if (groupids.contains(groupId)) {
                            builder.append(this.getRowObjectArr(groupId, this.singleBillSettingId, type, "C", row));
                        }
                    } else {
                        groupids.add(groupId);
                        builder.append(this.getRowObjectArr(groupId, this.singleBillSettingId, type, "C", row));
                    }
                }
            }
            String charegeoffRelType = this.charegeoffEntity2RelTypeMap.get(entity);
            if (!ischargeoff || !StringUtils.isNotEmpty((String)charegeoffRelType)) continue;
            groupId = 0L;
            if ("D".equals(charegeoffRelType)) {
                ids = chargeOffEntityIdMap.computeIfAbsent(entity, k -> new HashSet(16));
                ids.add(srcbillid);
                groupId = srcbillentryid;
            } else if ("E".equals(charegeoffRelType)) {
                ids = chargeOffEntityIdMap.computeIfAbsent(entity, k -> new HashSet(16));
                ids.add(mainbillid);
                groupId = mainbillentryid;
            }
            if (groupId == 0L) continue;
            builder.append(this.getRowObjectArr(groupId, this.chargeOffBillSettingId, "1", "B", row));
        }
    }

    private Object[] getRowObjectArr(Long groupId, Long groupSettingId, String type, String groupSettingType, Row row) {
        return new Object[]{groupId, groupSettingId, true, type, row.getLong("bizbillid"), groupSettingType, groupId, row.getString("billno"), row.getLong("owner"), row.getString("bizentityobject"), row.getString("billstatus"), row.getBoolean("invscheme.isinupdate"), row.getBoolean("invscheme.isoutupdate"), row.getString("calbilltype"), row.getLong("bizbillentryid"), row.getDate("bookdate"), row.getLong("period"), row.getDate("periodenddate"), row.getLong("booktype"), row.getBoolean("isingroup"), row.getLong("calbillid"), row.getLong("calentryid"), row.getLong("costrecordentryid"), row.getLong("costaccount"), row.getLong("material"), row.getBigDecimal("baseqty"), row.getBigDecimal("weight"), row.getString("accounttype"), row.getString("isrework")};
    }

    private DataSet getCostRecord(Map<String, Set<Long>> formId2BizbillidMap) {
        HashSet<QFilter> costRecordFilters = new HashSet<QFilter>(16);
        for (Map.Entry<String, Set<Long>> mapEntry : formId2BizbillidMap.entrySet()) {
            String entity = mapEntry.getKey();
            Set<Long> bizBillids = mapEntry.getValue();
            Lists.partition(new ArrayList<Long>(bizBillids), (int)10000).forEach(list -> {
                QFilter filter = new QFilter("bizbillid", "in", list);
                filter.and("bizentityobject", "=", (Object)entity);
                costRecordFilters.add(filter);
            });
        }
        DataSet costRecordDS = this.getCostRecord(costRecordFilters);
        return costRecordDS;
    }

    private DataSet getCostRecord(Set<QFilter> spBgFilters) {
        if (spBgFilters.size() == 1) {
            DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)COSTRECORD_SELECTFIELDS, (QFilter[])spBgFilters.iterator().next().and("issplitcreate", "=", (Object)false).and("bizentityobject", "in", this.allformids).toArray(), null);
            return costRecordDS;
        }
        if (spBgFilters.size() > 1) {
            ArrayList<OrmInput> costRecordInputs = new ArrayList<OrmInput>(16);
            for (QFilter filter : spBgFilters) {
                OrmInput input = new OrmInput(this.getClass().getName(), "cal_costrecord", COSTRECORD_SELECTFIELDS, filter.and("issplitcreate", "=", (Object)false).and("bizentityobject", "in", this.allformids).toArray());
                costRecordInputs.add(input);
            }
            DataSet costRecordDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])costRecordInputs.toArray(new OrmInput[0]));
            return costRecordDS;
        }
        RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", COSTRECORD_SELECTFIELDS);
        DataSet emptyDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        return emptyDs;
    }
}

