/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class BizGroupRecordUpdateFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 2525074402074456656L;

    public BizGroupRecordUpdateFunction(RowMeta rowMeta) {
        this.sourceRowMeta = rowMeta;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        boolean hasSrc = false;
        boolean hasDest = false;
        HashSet<Long> allBizBillids = new HashSet<Long>(4);
        HashMap<String, Set<Long>> destEntity2BizBillids = new HashMap<String, Set<Long>>(4);
        boolean isBeforPeriod = false;
        boolean ischargeoff = false;
        boolean iscompleted = false;
        Long id = 0L;
        Long bizGroupId = 0L;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            id = row.getLong("id");
            bizGroupId = row.getLong("bizgrouprecordid");
            Long bizbillid = row.getLong("bizbillid");
            String bizentityobject = row.getString("bizentityobject");
            ischargeoff = ischargeoff || row.getBoolean("ischargeoff") != false;
            isBeforPeriod = row.getBoolean("entryentity.isbeforeperiod");
            iscompleted = row.getBoolean("iscompleted");
            String type = row.getString("type");
            if ("0".equals(type)) {
                hasSrc = true;
            } else {
                hasDest = true;
                Set destBizIds = destEntity2BizBillids.computeIfAbsent(bizentityobject, k -> new HashSet(4));
                destBizIds.add(bizbillid);
            }
            allBizBillids.add(bizbillid);
        }
        if (isBeforPeriod) {
            this.collectDestBill(collector, destEntity2BizBillids, id, bizGroupId);
        } else if (ischargeoff && !destEntity2BizBillids.containsKey("im_transinbill")) {
            this.collectDestBillBak(collector, allBizBillids, id, bizGroupId);
        } else if (hasDest && !hasSrc) {
            this.collectDestBill(collector, destEntity2BizBillids, id, bizGroupId);
        } else if (hasDest && hasSrc && allBizBillids.size() == 1) {
            this.collectDestBillBak(collector, allBizBillids, id, bizGroupId);
        } else if (!iscompleted) {
            this.collectDestBill(collector, destEntity2BizBillids, id, bizGroupId);
        }
    }

    private void collectDestBillBak(Collector collector, Set<Long> allBizBillids, Long id, Long bizGroupId) {
        for (Long bizBillid : allBizBillids) {
            collector.collect(new Object[]{id, bizGroupId, null, null, bizBillid});
        }
    }

    private void collectDestBill(Collector collector, Map<String, Set<Long>> destEntity2BizBillids, Long id, Long bizGroupId) {
        for (Map.Entry<String, Set<Long>> entry : destEntity2BizBillids.entrySet()) {
            String entity = entry.getKey();
            Set<Long> bizbills = entry.getValue();
            for (Long bizbill : bizbills) {
                collector.collect(new Object[]{id, bizGroupId, entity, bizbill, null});
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("groupid", (DataType)DataType.LongType), new Field("bizgroupid", (DataType)DataType.LongType), new Field("entity", (DataType)DataType.StringType), new Field("bizbillid", (DataType)DataType.LongType), new Field("bizbillidbak", (DataType)DataType.LongType)});
    }
}

