/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.bizbillgroup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.billgroup.AccGroupUpdateHelper;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordUpdateFunction;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class BizGroupRecordUpdateTask
extends AbstractTask {
    public static final String ACC_GROUP_RECORD_SELECT = "id,iscompleted,bizgrouprecordid,entryentity.type as type,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period,entryentity.isbeforeperiod";
    private static Log log = LogFactory.getLog(BizGroupRecordUpdateTask.class);
    private static final int BATCH_SIZE = 100000;
    private Set<String> bizbillidBaks;
    private Set<Long> groupIds;
    private Set<Long> bizGroupIds;
    private Map<String, Set<Long>> formid2BizBillidMap;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.bizbillidBaks = new HashSet<String>(16);
        this.groupIds = new HashSet<Long>(16);
        this.bizGroupIds = new HashSet<Long>(16);
        this.formid2BizBillidMap = new HashMap<String, Set<Long>>(16);
        Set<Long> calOrgIds = this.getAllCalOrgIds();
        try {
            Long starTime;
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-\u5f00\u59cb");
            Long allStarTime = starTime = Long.valueOf(System.currentTimeMillis());
            this.modifyStopSyncBizBill(calOrgIds, true);
            boolean isNewAccGroupModel = AcctGroupModelHelper.isNewGroupModel();
            if (!isNewAccGroupModel) {
                new CostAccountGroupRecordHelper().refreshGroupRecordByTime();
            }
            long endTime = System.currentTimeMillis();
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-0.\u5dee\u91cf\u751f\u6210\u6210\u7ec4\u5173\u7cfb,\u7528\u65f6:" + (endTime - starTime) / 1000L + "s");
            CalDbParamServiceHelper.updateParam((String)CalDbParamConstant.ACCOUNTGROUP_NEWMODEL, (String)"true", null);
            try (TXHandle handle = TX.requiresNew();){
                try (AlgoContext context = Algo.newContext();){
                    this.deleteCalGroupRecord();
                }
                catch (Throwable e) {
                    handle.markRollback();
                    throw e;
                }
            }
            endTime = System.currentTimeMillis();
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-1.\u5220\u9664\u4e00\u5355\u53cc\u65b9\u5411\u8c03\u62e8\u672a\u5b8c\u6210\u5b8c\u6210,\u7528\u65f6:" + (endTime - starTime) / 1000L + "s");
            if (!isNewAccGroupModel) {
                handle = TX.requiresNew();
                var10_11 = null;
                try {
                    AccGroupUpdateHelper.updateCostAccountGroupRecord();
                }
                catch (Throwable throwable) {
                    var10_11 = throwable;
                    throw throwable;
                }
                finally {
                    if (handle != null) {
                        if (var10_11 != null) {
                            try {
                                handle.close();
                            }
                            catch (Throwable throwable) {
                                var10_11.addSuppressed(throwable);
                            }
                        } else {
                            handle.close();
                        }
                    }
                }
            }
            endTime = System.currentTimeMillis();
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-2.\u5347\u7ea7\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u5b8c\u6210,\u7528\u65f6:" + (endTime - starTime) / 1000L + "s");
            starTime = endTime;
            CalDbParamServiceHelper.updateParam((String)CalDbParamConstant.BIZGROUP_MODEL, (String)"true", null);
            this.queryImBill();
            handle = TX.requiresNew();
            var10_11 = null;
            try {
                this.invokerImBizGroupService();
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var10_11 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var10_11.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            endTime = System.currentTimeMillis();
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-3.\u91cd\u5efa\u6210\u672c\u57df\u6210\u7ec4\u5173\u7cfb\u5b8c\u6210,\u7528\u65f6:" + (endTime - starTime) / 1000L + "s");
            starTime = endTime;
            new CostDomainGroupHelper().rebuildCostDomainGroup();
            endTime = System.currentTimeMillis();
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-4.\u91cd\u5efa\u6210\u672c\u57df\u6210\u7ec4\u5173\u7cfb\u5b8c\u6210,\u7528\u65f6:" + (endTime - starTime) / 1000L + "s");
            starTime = endTime;
            new AutoSortServic().sort();
            endTime = System.currentTimeMillis();
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-5.\u91cd\u5efa\u667a\u80fd\u6392\u5e8f\u7ed3\u679c\u5b8c\u6210,\u7528\u65f6:" + (endTime - starTime) / 1000L + "s");
            log.info("\u5347\u7ea7\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb-\u5b8c\u6210,\u603b\u7528\u65f6:" + (endTime - allStarTime) / 1000L + "s");
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        finally {
            try {
                this.modifyStopSyncBizBill(calOrgIds, false);
            }
            catch (Throwable e) {
                log.error("\u91cd\u5efa\u6210\u672c\u57df\u7ef4\u5ea6\u6210\u7ec4\u5173\u7cfb\u542f\u52a8\u670d\u52a1\u5f02\u5e38", e);
            }
        }
    }

    private void queryImBill() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(5, -30);
        Date startDate = calendar.getTime();
        ArrayList<Input> imBillInputs = new ArrayList<Input>(16);
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadAllRules();
        Map inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        Map outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
        for (Map.Entry<String, List<CalBillRule>> entry : inCalBillRuleMap.entrySet()) {
            this.addImBillInputs(now, startDate, imBillInputs, entry);
        }
        for (Map.Entry<String, List<CalBillRule>> entry : outCalBillRuleMap.entrySet()) {
            this.addImBillInputs(now, startDate, imBillInputs, entry);
        }
        List dateSplitFilters = DateUtils.getDateSplitFilters((Date)startDate, (Date)now, (String)"bookdate");
        ArrayList<OrmInput> arrayList = new ArrayList<OrmInput>(16);
        for (QFilter dateSplitFilter : dateSplitFilters) {
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", "id,bizbillid", dateSplitFilter.toArray());
            arrayList.add(input);
        }
        DataSet imBillDS = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet((Input[])imBillInputs.toArray(new OrmInput[0])).distinct();
        DataSet costRecordDS = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet((Input[])arrayList.toArray(new OrmInput[0]));
        DataSet dataSet = imBillDS.join(costRecordDS, JoinType.LEFT).on("id", "bizbillid").select(new String[]{"id", "entity"}, new String[]{"bizbillid"}).finish();
        dataSet = dataSet.filter("bizbillid is null");
        for (Row row : dataSet) {
            String entity = row.getString("entity");
            Long bizbillid = row.getLong("id");
            Set ids = this.formid2BizBillidMap.computeIfAbsent(entity, k -> new HashSet(16));
            ids.add(bizbillid);
        }
    }

    private void addImBillInputs(Date now, Date startDate, List<Input> inputs, Map.Entry<String, List<CalBillRule>> mapEntry) {
        String entity = mapEntry.getKey();
        List<CalBillRule> calBillRules = mapEntry.getValue();
        for (CalBillRule calBillRule : calBillRules) {
            Map calBizFieldMap = calBillRule.getCalBizFieldMap();
            List billFilters = calBillRule.getBillFilters();
            this.resolveBillFilters(billFilters);
            String bookdateField = (String)calBizFieldMap.get("bookdate");
            List dateSplitFilters = DateUtils.getDateSplitFilters((Date)startDate, (Date)now, (String)bookdateField);
            if (entity.contains("im_mdc_")) {
                billFilters.add(new QFilter("billtype.billformid.number", "=", (Object)entity));
            }
            for (QFilter dateSplitFilter : dateSplitFilters) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
                filters.addAll(billFilters);
                filters.add(dateSplitFilter);
                OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, "id,'" + entity + "' as entity", filters.toArray(new QFilter[0]));
                input.getRowMeta().getField("entity").setDataType((DataType)DataType.StringType);
                inputs.add((Input)input);
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
            filters.addAll(billFilters);
            filters.add(new QFilter(bookdateField, ">", (Object)now));
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, "id,'" + entity + "' as entity", filters.toArray(new QFilter[0]));
            inputs.add((Input)input);
        }
    }

    private void resolveBillFilters(List<QFilter> billFilters) {
        for (QFilter billFilter : billFilters) {
            String property = billFilter.getProperty();
            if (!"billstatus".equals(property)) continue;
            billFilter.__setCP("in");
            billFilter.__setValue((Object)new String[]{"B", "C"});
        }
    }

    private void invokerImBizGroupService() {
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"BizGroupRecordService", (String)"createRecord", (Object[])new Object[]{this.formid2BizBillidMap, true});
    }

    private void deleteCalGroupRecord() {
        QFilter gFilter1 = new QFilter("entryentity.isbeforeperiod", "=", (Object)"0");
        DataSet dataSet = this.getGroupRecordJoinCostRecordDS(gFilter1);
        this.handleGroupRecordDS(dataSet);
        QFilter gFilter2 = new QFilter("entryentity.isbeforeperiod", "=", (Object)"1");
        gFilter2.and("iscompleted", "=", (Object)false);
        gFilter2.and("entryentity.type", "=", (Object)"1");
        dataSet = this.getGroupRecordJoinCostRecordDS(gFilter2);
        this.handleGroupRecordDS(dataSet);
        Lists.partition(new ArrayList<Long>(this.groupIds), (int)10000).forEach(list -> DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])new QFilter("id", "in", list).toArray()));
        Lists.partition(new ArrayList<Long>(this.bizGroupIds), (int)10000).forEach(list -> DeleteServiceHelper.delete((String)"cal_groupbillrecord", (QFilter[])new QFilter("id", "in", list).toArray()));
        QFilter logFilter = new QFilter("traceid", "=", (Object)"bizgroupupdate");
        logFilter.and("type", "=", (Object)"C");
        Long logid = 0L;
        try (DataSet logDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_dblog", (String)"id,starttime,log_tag", (QFilter[])logFilter.toArray(), (String)"starttime desc", (int)1);){
            HashSet<Long> preBizBillIds = new HashSet<Long>(16);
            HashSet<String> preBizBillIdStrs = new HashSet<String>(16);
            for (Row row : logDS) {
                logid = row.getLong("id");
                String[] bizbillidStrs = row.getString("log_tag").split(",");
                for (String bizbillidStr : bizbillidStrs) {
                    preBizBillIds.add(Long.valueOf(bizbillidStr));
                    preBizBillIdStrs.add(bizbillidStr);
                }
            }
            this.bizbillidBaks.addAll(preBizBillIdStrs);
            QFilter crFilter = new QFilter("bizbillid", "in", preBizBillIds);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,bizentityobject", (QFilter[])crFilter.toArray(), null);){
                for (Row row : ds) {
                    String bizentityobject = row.getString("bizentityobject");
                    Long bizbillid = row.getLong("bizbillid");
                    Set ids = this.formid2BizBillidMap.computeIfAbsent(bizentityobject, k -> new HashSet(16));
                    ids.add(bizbillid);
                }
            }
        }
        if (logid != 0L) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_dblog"), (Object[])new Object[]{logid});
        }
        if (!this.bizbillidBaks.isEmpty()) {
            Object[] params = new Object[]{ID.genLongId(), TimeServiceHelper.now(), "bizgroupupdate", "C", String.join((CharSequence)",", String.join((CharSequence)",", this.bizbillidBaks))};
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"insert into t_cal_dblog (fid,fstarttime,ftraceid,ftype,flog_tag)values(?,?,?,?,?)", (Object[])params);
        }
    }

    private DataSet getGroupRecordJoinCostRecordDS(QFilter gFilter) {
        DataSet accGroupRecordDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_account_grouprecord", (String)ACC_GROUP_RECORD_SELECT, (QFilter[])gFilter.toArray(), null);
        HashMap<String, Set> costAccountPeriodRCEidMap = new HashMap<String, Set>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        for (Row row : accGroupRecordDS.copy()) {
            Long costAccountId = row.getLong("costaccount");
            Long period = row.getLong("period");
            periods.add(period);
            Long crEid = row.getLong("costrecordentryid");
            String key = costAccountId + "#" + period;
            Set set = costAccountPeriodRCEidMap.computeIfAbsent(key, k -> new HashSet(16));
            set.add(crEid);
        }
        DataSet costRecordDS = null;
        if (costAccountPeriodRCEidMap.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", "billnumber,bizbillid,bizentityobject,ischargeoff,entry.id");
            costRecordDS = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new ArrayList(4), rowMeta);
        } else {
            HashMap<Long, Date> periodStartDateMap = new HashMap<Long, Date>(16);
            HashMap<Long, Date> periodEndDateMap = new HashMap<Long, Date>(16);
            QFilter periodFilter = new QFilter("id", "in", periods);
            DataSet periodDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id,begindate,enddate", (QFilter[])periodFilter.toArray(), null);
            Object object = null;
            try {
                for (Row row : periodDS) {
                    Long id = row.getLong("id");
                    Date begindate = row.getDate("begindate");
                    Date enddate = row.getDate("enddate");
                    periodStartDateMap.put(id, begindate);
                    periodEndDateMap.put(id, enddate);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (periodDS != null) {
                    if (object != null) {
                        try {
                            periodDS.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        periodDS.close();
                    }
                }
            }
            ArrayList costRecordInputs = new ArrayList(16);
            for (Map.Entry entry : costAccountPeriodRCEidMap.entrySet()) {
                String[] keys = ((String)entry.getKey()).split("#");
                Set entryids = (Set)entry.getValue();
                Long costAccountId = Long.valueOf(keys[0]);
                Long period = Long.valueOf(keys[1]);
                Date sDate = (Date)periodStartDateMap.get(period);
                Date eDate = (Date)periodEndDateMap.get(period);
                Lists.partition(new ArrayList(entryids), (int)100000).forEach(partList -> {
                    QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
                    filter.and("bookdate", ">=", (Object)sDate);
                    filter.and("bookdate", "<=", (Object)eDate);
                    filter.and("entry.id", "in", partList);
                    OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", "bizbillid,bizentityobject,ischargeoff,entry.id", filter.toArray());
                    costRecordInputs.add(input);
                });
            }
            costRecordDS = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(costRecordInputs.toArray(new Input[0]));
        }
        return accGroupRecordDS.join(costRecordDS, JoinType.INNER).on("costrecordentryid", "entry.id").select(accGroupRecordDS.getRowMeta().getFieldNames(), costRecordDS.getRowMeta().getFieldNames()).finish();
    }

    private void handleGroupRecordDS(DataSet dataSet) {
        DataSet resultDS = dataSet.groupBy(new String[]{"id"}).reduceGroup((ReduceGroupFunctionWithCollector)new BizGroupRecordUpdateFunction(dataSet.getRowMeta()));
        for (Row row : resultDS) {
            Long groupid = row.getLong("groupid");
            Long bizgroupid = row.getLong("bizgroupid");
            String entity = row.getString("entity");
            Long bizbillid = row.getLong("bizbillid");
            Long bizbillidbak = row.getLong("bizbillidbak");
            this.groupIds.add(groupid);
            this.bizGroupIds.add(bizgroupid);
            if (StringUtils.isNotEmpty((String)entity)) {
                Set ids = this.formid2BizBillidMap.computeIfAbsent(entity, k -> new HashSet(16));
                ids.add(bizbillid);
                this.bizbillidBaks.add(bizbillid.toString());
                continue;
            }
            this.bizbillidBaks.add(bizbillidbak.toString());
        }
    }

    private void modifyStopSyncBizBill(Set<Long> calOrgIds, boolean isStop) {
        new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, null, null, isStop, TimeServiceHelper.now());
    }

    private Set<Long> getAllCalOrgIds() {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costaccount", (String)"calorg", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                orgIds.add(row.getLong("calorg"));
            }
        }
        return orgIds;
    }
}

