/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostDomainKeyHelper;
import kd.fi.cal.common.util.CommonUtils;

public class DomainReCalHandle {
    private String entity = "";
    private List<Long> costActIds;
    private List<Long> matIds;
    private Set<String> lotNums;
    private QFilter billFs;
    private Date startDate;
    private Date endDate;
    private CostDomainKeyHelper costDomainKeyHelper = new CostDomainKeyHelper();
    private int updateBatch;
    private Set<Long> emptyCalRangeIds;
    private int entryCount = 0;
    private Map<String, Long> keyRangeIdMap;
    private Map<Long, Long> rangeIdCalDimIdMap;
    private Map<Long, String> rangeIdAccTypeMap;
    private Map<String, Long> rangeIdMatGroupNumCalDimIdMap;
    private Map<String, String> rangeIdMatIdAccTypeMap;
    private Map<String, String> rangeIdMatGroupNumAccTypeMap;
    private boolean isMatchRangeDimAcct;
    private boolean updateBaseUnit = false;

    public void handle(String entity) {
        if ("cal_costrecord".equals(entity)) {
            entity = "cal_costrecord_subentity";
        } else if ("cal_costadjustbill".equals(entity)) {
            entity = "cal_costadjust_subentity";
        }
        this.entity = entity;
        if (EntityMetadataCache.getDataEntityType((String)entity).findProperty("costdomainkey") == null) {
            return;
        }
        if ("cal_stdcostdiffbill".equals(entity)) {
            return;
        }
        this.matchRangeDimAcctOtherField();
        this.emptyCalRangeIds = this.getEmptyCalRangeIds();
        DataSet billDs = this.getBillDs();
        this.doUpdate(billDs);
    }

    private void matchRangeDimAcctOtherField() {
        if (!this.isMatchRangeDimAcct) {
            return;
        }
        this.cacheRangeInfo();
        this.cacheCalDimInfo();
        this.cacheAccType();
        DataSet billDs = this.getBillDs();
        QFilter matGroupF = new QFilter("standard", "=", (Object)730148448254487552L);
        if (this.matIds != null && !this.matIds.isEmpty()) {
            matGroupF.and("material", "in", this.matIds);
        }
        DataSet matGroupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"group.longnumber grouplongnum,material", (QFilter[])matGroupF.toArray(), null);
        billDs = billDs.leftJoin(matGroupDs).on("material", "material").select(billDs.getRowMeta().getFieldNames(), new String[]{"grouplongnum"}).finish();
        ArrayList<Object> updateParams = new ArrayList<Object[]>(16);
        HashSet<Long> tmpBillIds = new HashSet<Long>(16);
        for (Row row : billDs) {
            int dbBatch;
            String matAccType;
            boolean isNoMatchRange;
            String billDivBas = row.getString("dividebasis");
            Long billCostAcctId = row.getLong("costaccount");
            Long billMatId = row.getLong("material");
            String billMatGLongNum = row.getString("grouplongnum");
            StringBuilder notEmpKeySB = new StringBuilder();
            notEmpKeySB.append(billCostAcctId).append("_");
            for (String div : billDivBas.split(",")) {
                if (div.isEmpty()) continue;
                Object divValue = row.get(div);
                String divValueStr = divValue == null ? "0" : divValue.toString();
                notEmpKeySB.append(divValueStr).append("_");
            }
            String costAccDivValue = notEmpKeySB.toString();
            Long billRangeId = this.keyRangeIdMap.get(costAccDivValue);
            if (billRangeId == null || billRangeId.equals(0L)) {
                billRangeId = this.keyRangeIdMap.get(billCostAcctId.toString());
            }
            boolean bl = isNoMatchRange = billRangeId == null || billRangeId.equals(0L);
            if (isNoMatchRange) continue;
            Long rangeCalDimId = this.rangeIdCalDimIdMap.get(billRangeId);
            if (billMatGLongNum != null && !rangeCalDimId.equals(0L)) {
                String[] groupNums = billMatGLongNum.split("!");
                for (int i = groupNums.length - 1; i >= 0; --i) {
                    String groupNum = groupNums[i];
                    if (!this.rangeIdMatGroupNumCalDimIdMap.containsKey(billRangeId + "_" + groupNum)) continue;
                    rangeCalDimId = this.rangeIdMatGroupNumCalDimIdMap.get(billRangeId + "_" + groupNum);
                    break;
                }
            }
            String rangeAccType = this.rangeIdAccTypeMap.get(billRangeId);
            if (billMatGLongNum != null) {
                String[] groupNums = billMatGLongNum.split("!");
                for (int i = groupNums.length - 1; i >= 0; --i) {
                    String groupNum = groupNums[i];
                    if (!this.rangeIdMatGroupNumAccTypeMap.containsKey(billRangeId + "_" + groupNum)) continue;
                    rangeAccType = this.rangeIdMatGroupNumAccTypeMap.get(billRangeId + "_" + groupNum);
                    break;
                }
            }
            if ((matAccType = this.rangeIdMatIdAccTypeMap.get(billRangeId + "_" + billMatId)) != null && StringUtils.isNotEmpty((String)matAccType)) {
                rangeAccType = matAccType;
            }
            Long billId = row.getLong("id");
            Long entryId = row.getLong("entryid");
            if (!StringUtils.isEmpty((String)this.entity) && "cal_inventorybalance".equals(this.entity)) {
                entryId = billId;
            }
            Long matBaseUnit = row.getLong("matbaseunit");
            Long billBaseUnit = row.getLong("billbaseunit");
            matBaseUnit = this.isUpdateBaseUnit() ? matBaseUnit : billBaseUnit;
            Object[] updateParam = new Object[]{billRangeId, rangeCalDimId, rangeAccType, matBaseUnit, entryId};
            tmpBillIds.add(billId);
            updateParams.add(updateParam);
            int n = dbBatch = this.updateBatch < 1000 ? 1000 : this.updateBatch;
            if (updateParams.size() < dbBatch) continue;
            this.saveRangeDimAcct2Db(tmpBillIds, updateParams);
            tmpBillIds = new HashSet(16);
            updateParams = new ArrayList(16);
        }
        this.saveRangeDimAcct2Db(tmpBillIds, updateParams);
    }

    private List<Object[]> doUpdate(DataSet billDs) {
        ArrayList<Object> updateParams = new ArrayList<Object[]>(16);
        HashSet<Long> tmpBillIds = new HashSet<Long>(16);
        for (Row row : billDs) {
            int dbBatch;
            String divideBasis = row.getString("dividebasis");
            String calDimension = row.getString("caldimension");
            if (divideBasis == null) {
                divideBasis = "";
            }
            if (calDimension == null) {
                calDimension = "";
            }
            String divValues = this.getDimensionValueStr(row, divideBasis);
            String dimValues = this.getDimensionValueStr(row, calDimension);
            Long billId = row.getLong("id");
            Long entryId = row.getLong("entryid");
            this.costDomainKeyHelper.setCalDimensionValue(dimValues);
            Long calRangeId = row.getLong("calrange");
            if (!this.emptyCalRangeIds.contains(calRangeId)) {
                divValues = "";
            }
            this.costDomainKeyHelper.setCalrange(calRangeId);
            this.costDomainKeyHelper.setCostaccount(row.getLong("costaccount"));
            this.costDomainKeyHelper.setDivideBasisValue(divValues);
            this.costDomainKeyHelper.setMaterial(row.getLong("material"));
            String dominKey = this.costDomainKeyHelper.getCostDomainDimsionKey();
            Object[] updateParam = new Object[]{dominKey, entryId};
            tmpBillIds.add(billId);
            updateParams.add(updateParam);
            int n = dbBatch = this.updateBatch < 1000 ? 1000 : this.updateBatch;
            if (updateParams.size() >= dbBatch) {
                this.save2Db(tmpBillIds, updateParams);
                tmpBillIds = new HashSet(16);
                updateParams = new ArrayList(16);
            }
            ++this.entryCount;
        }
        this.save2Db(tmpBillIds, updateParams);
        return updateParams;
    }

    private void save2Db(Set<Long> tmpBillIds, List<Object[]> updateParams) {
        if (updateParams.isEmpty()) {
            return;
        }
        String mainTalbe = this.getTableName(this.entity);
        String entryTable = this.getTableName(this.getEntryName(this.entity));
        String sql = "update %s set fcostdomainkey = ? where fentryid = ? ";
        if (!StringUtils.isEmpty((String)this.entity) && "cal_inventorybalance".equals(this.entity)) {
            sql = "update %s set fcostdomainkey = ? where fid = ? ";
        }
        sql = String.format(sql, entryTable);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)mainTalbe, (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, tmpBillIds)});){
            ctx.set();
            try (TXHandle txHandle = TX.requiresNew();){
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, updateParams);
            }
        }
    }

    private DataSet getBillDs() {
        List<QFilter> billFs = this.buildFilter();
        HashSet<String> selFields = new HashSet<String>(16);
        String[] divideBasis = CommonSettingHelper.getDivideBasis();
        String[] calDimensions = CommonSettingHelper.getCalDimension();
        StringBuilder selSB = new StringBuilder();
        selFields.addAll(Arrays.asList(divideBasis));
        selFields.addAll(Arrays.asList(calDimensions));
        selFields.add("costaccount");
        selFields.add("calrange");
        selFields.add("material");
        for (String field : selFields) {
            String fieldPath = CommonUtils.getFieldPath((String)this.entity, (String)field);
            selSB.append(fieldPath).append(" as ").append(field).append(",");
            if (!"material".equals(field)) continue;
            selSB.append(fieldPath).append(".baseunit as matbaseunit,");
            String billBaseUnitFieldPath = CommonUtils.getFieldPath((String)this.entity, (String)"baseunit");
            selSB.append(billBaseUnitFieldPath).append(" as billbaseunit,");
        }
        String calDimField = CommonUtils.getFieldPath((String)this.entity, (String)"caldimension");
        selSB.append(calDimField);
        selSB.append(".caldimension as caldimension,");
        selSB.append("costaccount.dividebasis.dividebasis as dividebasis,");
        selSB.append("id,");
        selSB.append(this.getEntryName(this.entity)).append(".id as entryid");
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entity, (String)selSB.toString(), (QFilter[])billFs.toArray(new QFilter[0]), null);
        return billDs;
    }

    private List<QFilter> buildFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter acctFilter = new QFilter("costaccount", "in", this.costActIds);
        QFilter startFilter = new QFilter("bookdate", ">=", (Object)this.startDate);
        QFilter endFilter = new QFilter("bookdate", "<", (Object)this.endDate);
        qFilters.add(acctFilter);
        qFilters.add(startFilter);
        qFilters.add(endFilter);
        String entryName = this.getEntryName(this.entity);
        if (this.matIds != null && this.matIds.size() > 0) {
            QFilter matFilter = new QFilter(entryName + ".material", "in", this.matIds);
            qFilters.add(matFilter);
        }
        if (this.lotNums != null && this.lotNums.size() > 0) {
            QFilter lotFilter = new QFilter(entryName + ".lot", "in", this.lotNums);
            qFilters.add(lotFilter);
        }
        if (this.billFs != null) {
            qFilters.add(this.billFs);
        }
        return qFilters;
    }

    public void setCostActIds(List<Long> costActIds) {
        this.costActIds = costActIds;
    }

    public List<Long> getCostActIds() {
        return this.costActIds;
    }

    public void setMatIds(List<Long> matIds) {
        this.matIds = matIds;
    }

    public List<Long> getMatIds() {
        return this.matIds;
    }

    public void setLotNums(Set<String> lotNums) {
        this.lotNums = lotNums;
    }

    private String getTableName(String entityOrEntry) {
        String entryTable = ((EntityType)EntityMetadataCache.getDataEntityType((String)this.entity).getAllEntities().get(entityOrEntry)).getAlias();
        return entryTable;
    }

    private String getEntryName(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).findProperty("costdomainkey").getParent().getName();
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    private String getDimensionValueStr(Row row, String dividebasis) {
        StringBuilder dimensionStr = new StringBuilder();
        for (String dim : dividebasis.split(",")) {
            if (StringUtils.isEmpty((String)dim)) continue;
            Object value = row.get(dim);
            if (value == null || "".equals(value)) {
                value = "#";
            }
            dimensionStr.append(value);
            dimensionStr.append("_");
        }
        return dimensionStr.toString();
    }

    public void setUpdateBatch(int updateBatch) {
        this.updateBatch = updateBatch;
    }

    private Set<Long> getEmptyCalRangeIds() {
        HashSet<Long> emptyEntryCalrange = new HashSet<Long>(16);
        QFilter calrangeFilter = new QFilter("enable", "=", (Object)true);
        calrangeFilter.and("status", "=", (Object)"C");
        calrangeFilter.and("costaccount", "in", this.costActIds);
        Map calranges = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])calrangeFilter.toArray());
        if (calranges == null || calranges.isEmpty()) {
            return new HashSet<Long>(0);
        }
        for (DynamicObject calrange : calranges.values()) {
            DynamicObjectCollection entry = calrange.getDynamicObjectCollection("entry");
            if (entry != null && !entry.isEmpty()) continue;
            emptyEntryCalrange.add(calrange.getLong("id"));
        }
        return emptyEntryCalrange;
    }

    public void setBillFs(QFilter billFs) {
        this.billFs = billFs;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    private void cacheCalDimInfo() {
        QFilter calDimF = new QFilter("calrange.id", "in", this.keyRangeIdMap.values());
        calDimF.and("status", "=", (Object)"C");
        calDimF.and("enable", "=", (Object)"1");
        String calDimSels = "calrange,entry.material material,entry.materialgroup.number as matgroupnum,entry.caldimension caldimension";
        DataSet calDimDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_materialdimension", (String)calDimSels, (QFilter[])calDimF.toArray(), null);
        this.rangeIdMatGroupNumCalDimIdMap = new HashMap<String, Long>(16);
        for (Row row : calDimDs) {
            Long calrangeId = row.getLong("calrange");
            Long materialId = row.getLong("material");
            Long calDimId = row.getLong("caldimension");
            String groupNo = row.getString("matgroupnum");
            if (groupNo == null || !StringUtils.isNotEmpty((String)groupNo)) continue;
            this.rangeIdMatGroupNumCalDimIdMap.put(calrangeId + "_" + groupNo, calDimId);
        }
    }

    private void cacheRangeInfo() {
        String[] divideBasis;
        this.keyRangeIdMap = new HashMap<String, Long>(16);
        this.rangeIdCalDimIdMap = new HashMap<Long, Long>(16);
        this.rangeIdAccTypeMap = new HashMap<Long, String>(16);
        QFilter costActF = new QFilter("costaccount", "in", this.costActIds);
        costActF.and("status", "=", (Object)"C");
        costActF.and("enable", "=", (Object)Boolean.TRUE);
        StringBuilder divSB = new StringBuilder();
        for (String div : divideBasis = CommonSettingHelper.getDivideBasis()) {
            String fieldPath = CommonUtils.getFieldPath((String)"cal_bd_calrange", (String)div);
            divSB.append(fieldPath).append(" as ").append(div).append(",");
        }
        divSB = divSB.deleteCharAt(divSB.length() - 1);
        String divStr = divSB.toString();
        String divSels = "id,costaccount,accounttype,dividebasis.dividebasis dividebasis,caldimension,entry.id entryid," + divStr;
        DataSet rangeIdDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_calrange", (String)divSels, (QFilter[])costActF.toArray(), null);
        for (Row row : rangeIdDs) {
            Long rangeId = row.getLong("id");
            Long entryId = row.getLong("entryid");
            Long costAccId = row.getLong("costaccount");
            String curDivideBasis = row.getString("dividebasis");
            Long calDimId = row.getLong("caldimension");
            String accType = row.getString("accounttype");
            String key = "";
            if (entryId == null || entryId.equals(0L)) {
                key = costAccId.toString();
            } else {
                StringBuilder notEmpKeySB = new StringBuilder();
                notEmpKeySB.append(costAccId).append("_");
                for (String div : curDivideBasis.split(",")) {
                    if (div.isEmpty()) continue;
                    Object divValue = row.get(div);
                    String divValueStr = divValue == null ? "0" : divValue.toString();
                    notEmpKeySB.append(divValueStr).append("_");
                }
                key = notEmpKeySB.toString();
            }
            this.keyRangeIdMap.put(key, rangeId);
            this.rangeIdCalDimIdMap.put(rangeId, calDimId);
            this.rangeIdAccTypeMap.put(rangeId, accType);
        }
    }

    private void cacheAccType() {
        this.rangeIdMatIdAccTypeMap = new HashMap<String, String>(16);
        this.rangeIdMatGroupNumAccTypeMap = new HashMap<String, String>(16);
        QFilter accTypeF = new QFilter("calrange.id", "in", this.keyRangeIdMap.values());
        accTypeF.and("status", "=", (Object)"C");
        accTypeF.and("enable", "=", (Object)"1");
        String accTypeSels = "calrange,entry.material material,entry.materialgroup.number as matgroupnum,entry.accounttype accounttype";
        DataSet calDimDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_accounttype", (String)accTypeSels, (QFilter[])accTypeF.toArray(), null);
        for (Row row : calDimDs) {
            Long calrangeId = row.getLong("calrange");
            Long materialId = row.getLong("material");
            String acctType = row.getString("accounttype");
            String groupNo = row.getString("matgroupnum");
            if (materialId != null && !materialId.equals(0L)) {
                this.rangeIdMatIdAccTypeMap.put(calrangeId + "_" + materialId, acctType);
            }
            if (groupNo == null || !StringUtils.isNotEmpty((String)groupNo)) continue;
            this.rangeIdMatGroupNumAccTypeMap.put(calrangeId + "_" + groupNo, acctType);
        }
    }

    private void saveRangeDimAcct2Db(Set<Long> tmpBillIds, List<Object[]> updateParams) {
        if (updateParams.isEmpty()) {
            return;
        }
        String mainTalbe = this.getTableName(this.entity);
        String entryTable = this.getTableName(this.getEntryName(this.entity));
        IDataEntityProperty property = EntityMetadataCache.getDataEntityType((String)this.entity).findProperty("baseunit");
        String baseUnitAlias = property.getAlias();
        String sql = "update %s set fcalrangeid = ?,fcaldimensionid = ?,faccounttype=?,%s=? where fentryid = ? ";
        if (!StringUtils.isEmpty((String)this.entity) && "cal_inventorybalance".equals(this.entity)) {
            sql = "update %s set fcalrangeid = ?,fcaldimensionid = ?,faccounttype=?,%s=? where fid = ? ";
        }
        sql = String.format(sql, entryTable, baseUnitAlias);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)mainTalbe, (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, tmpBillIds)});){
            ctx.set();
            try (TXHandle txHandle = TX.requiresNew();){
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, updateParams);
            }
            this.updateBillBaseUnit(updateParams);
        }
        var9_9 = null;
        try (AlgoContext context = Algo.newContext();){
            this.updateBalData(tmpBillIds, updateParams);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    private void updateBillBaseUnit(List<Object[]> updateParams) {
        boolean isNeedUpdateEntity;
        boolean bl = isNeedUpdateEntity = "cal_costrecord_subentity".equals(this.entity) || "cal_initbill".equals(this.entity);
        if (isNeedUpdateEntity && this.isUpdateBaseUnit()) {
            String subEntryTable = this.getTableName(this.getSubEntryName(this.entity));
            String detailSql = "update %s set fbaseunitid=? where fentryid = ? ";
            detailSql = String.format(detailSql, subEntryTable);
            ArrayList<Object[]> detailParams = new ArrayList<Object[]>(16);
            for (Object[] updateParam : updateParams) {
                detailParams.add(new Object[]{updateParam[3], updateParam[4]});
            }
            try (TXHandle txHandle = TX.requiresNew();){
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailSql, detailParams);
            }
        }
    }

    public void setIsMatchRangeDimAcct(boolean isMatchRangeDimAcct) {
        this.isMatchRangeDimAcct = isMatchRangeDimAcct;
    }

    private void updateBalData(Set<Long> tmpBillIds, List<Object[]> updateParams) {
        IDataEntityProperty prop = EntityMetadataCache.getDataEntityType((String)this.entity).findProperty("costsubelement");
        if (prop == null) {
            return;
        }
        IDataEntityType parentProp = prop.getParent();
        if (parentProp instanceof JsonSubEntryType) {
            return;
        }
        HashMap<Long, Object[]> entryIdUpdateParamMap = new HashMap<Long, Object[]>(16);
        for (Object[] updateParam : updateParams) {
            Long entryId = (Long)updateParam[4];
            entryIdUpdateParamMap.put(entryId, updateParam);
        }
        DataSet billDs = this.getBill4BalDs(tmpBillIds, entryIdUpdateParamMap.keySet());
        DataSet balSpDs = this.getBalSpDs(tmpBillIds, billDs);
        List<Object[]> balUpdateParams = this.collectBalUpdateParams(entryIdUpdateParamMap, balSpDs);
        this.saveBalInfo2Db(balUpdateParams);
    }

    private List<Object[]> collectBalUpdateParams(Map<Long, Object[]> entryIdUpdateParamMap, DataSet balSpDs) {
        ArrayList<Object[]> balUpdateParams = new ArrayList<Object[]>(16);
        HashSet<Long> balIds = new HashSet<Long>(16);
        balSpDs = balSpDs.orderBy(new String[]{"balid"});
        for (Row row : balSpDs) {
            boolean notContains;
            Long balId = row.getLong("balid");
            Long entryId = row.getLong("entryid");
            String balAcctType = row.getString("faccounttype");
            Long balCalRangeId = row.getLong("fcalrangeid");
            Long balDimId = row.getLong("fcaldimensionid");
            Long balBaseUnitId = row.getLong("balbaseunitid");
            Object[] updateParam = entryIdUpdateParamMap.get(entryId);
            Object newCalRangeId = updateParam[0];
            Object newCalDimId = updateParam[1];
            Object newCalAccType = updateParam[2];
            Object newBaseUnit = updateParam[3];
            boolean isAcctDiff = !balAcctType.equals(newCalAccType);
            boolean isCalRangeDiff = !balCalRangeId.equals(newCalRangeId);
            boolean isCalDimDiff = !balDimId.equals(newCalDimId);
            boolean isBaseUnitDiff = this.isUpdateBaseUnit() && !balBaseUnitId.equals(newBaseUnit);
            boolean isNeedUpdate = isAcctDiff || isCalRangeDiff || isCalDimDiff || isBaseUnitDiff;
            boolean bl = notContains = !balIds.contains(balId);
            if (!isNeedUpdate || !notContains) continue;
            balIds.add(balId);
            balUpdateParams.add(new Object[]{newCalRangeId, newCalDimId, newCalAccType, newBaseUnit, balId});
        }
        return balUpdateParams;
    }

    private DataSet getBill4BalDs(Set<Long> tmpBillIds, Set<Long> entryIds) {
        String entryName = this.getEntryName(this.entity) + ".id";
        String subEntryName = this.getSubEntryNamePath(this.entity) + ".id";
        StringBuilder selSb = new StringBuilder();
        selSb.append(entryName).append(" as entryid,");
        selSb.append(subEntryName).append(" as subentryid");
        QFilter billIdF = new QFilter("id", "in", tmpBillIds);
        billIdF.and(entryName, "in", entryIds);
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entity, (String)selSb.toString(), (QFilter[])billIdF.toArray(), null);
        return billDs;
    }

    private String getSubEntryName(String entity) {
        IDataEntityProperty prop = EntityMetadataCache.getDataEntityType((String)entity).findProperty("costsubelement");
        IDataEntityType parentProp = prop.getParent();
        String name = parentProp.getName();
        return name;
    }

    private String getSubEntryNamePath(String entity) {
        IDataEntityProperty prop = EntityMetadataCache.getDataEntityType((String)entity).findProperty("costsubelement");
        IDataEntityType parentProp = prop.getParent();
        String entryFieldPatch = CommonUtils.getFieldPath((String)parentProp.getName(), (IDataEntityType)parentProp.getParent());
        return entryFieldPatch;
    }

    private DataSet getBalSpDs(Set<Long> tmpBillIds, DataSet billDs) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t2.fid as balid,t1.fbillid as fbillid,t1.fentryid as fdetailid,", new Object[0]);
        sqlBuilder.append("t2.faccounttype as faccounttype,t2.fcalrangeid as fcalrangeid,t2.fcaldimensionid as fcaldimensionid,t2.fbaseunitid balbaseunitid ", new Object[0]);
        sqlBuilder.append("from t_cal_bal_sp t1 join t_cal_bal t2 ", new Object[0]);
        sqlBuilder.append("on t1.fkeycol = t2.fkeycol and t1.fperiod = t2.fperiod where ", new Object[0]);
        sqlBuilder.appendIn("fbillid", tmpBillIds.toArray());
        DataSet balDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)sqlBuilder);
        DataSet balSpDs = billDs.join(balDs).on("subentryid", "fdetailid").select(new String[]{"entryid"}, balDs.getRowMeta().getFieldNames()).finish();
        return balSpDs;
    }

    private void saveBalInfo2Db(List<Object[]> balUpdateParams) {
        if (balUpdateParams.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            String sql = "update t_cal_bal set fcalrangeid = ?,fcaldimensionid = ?,faccounttype=?,fbaseunitid=? where fid = ? ";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, balUpdateParams);
        }
    }

    public void setIsUpdateBaseUnit(boolean isUpdateBaseUnit) {
        this.updateBaseUnit = isUpdateBaseUnit;
    }

    private boolean isUpdateBaseUnit() {
        return this.updateBaseUnit;
    }
}

