/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.in;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cal.business.calculate.in.FeeShareConfigHelper;
import kd.fi.cal.business.calculate.in.FeeShareDataHolder;
import kd.fi.cal.business.calculate.in.FeeShareResultHolder;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;

public class CalFeeShareStrategy {
    private FeeShareDataHolder feeShareDataHolder;
    private FeeShareConfigHelper feeShareConfigHelper;
    private FeeShareResultHolder feeShareResultHolder;
    private static Log log = LogFactory.getLog(CalFeeShareStrategy.class);
    private boolean isActualFeeShare;

    public CalFeeShareStrategy(List<DynamicObject> feeShareRecords) {
        try {
            this.feeShareDataHolder = new FeeShareDataHolder(feeShareRecords);
            log.info("FeeShareDataHolder--init--end");
        }
        catch (Exception e) {
            log.error("FeeShareDataHolder--init", (Throwable)e);
            throw e;
        }
        try {
            this.feeShareConfigHelper = this.feeShareDataHolder.getFeeShareConfigHelper();
            log.info("feeShareConfigHelper--init--end");
        }
        catch (Exception e) {
            log.error("feeShareConfigHelper--init", (Throwable)e);
            throw e;
        }
        try {
            this.feeShareResultHolder = new FeeShareResultHolder(this.feeShareConfigHelper);
            log.info("feeShareResultHolder--init--end");
        }
        catch (Exception e) {
            log.error("feeShareResultHolder--init", (Throwable)e);
            throw e;
        }
        this.isActualFeeShare = this.feeShareConfigHelper.isActualFeeShare();
    }

    public void execute() {
        List<DynamicObject> feeShareRecords = this.feeShareDataHolder.getFeeShareRecords();
        Map<Long, DynamicObject> recordId2FeeShareRecMainEntryMap = this.feeShareDataHolder.getRecordId2FeeShareRecMainEntryMap();
        Map<Long, DynamicObject> mainCostRecordEntryMap = this.feeShareDataHolder.getMainCostRecordEntryMap();
        Map<Long, List<DynamicObject>> notMainCostRecordEntryMap = this.feeShareDataHolder.getNotMainCostRecordEntryMap();
        Set<Long> feeSharedIds = this.feeShareDataHolder.getFeeSharedIds();
        for (int i = 0; i < feeShareRecords.size(); ++i) {
            DynamicObject feeShareRecord = feeShareRecords.get(i);
            Long feeShareRecordId = feeShareRecord.getLong("id");
            if (feeSharedIds.contains(feeShareRecordId)) continue;
            DynamicObject mainEntryRow = recordId2FeeShareRecMainEntryMap.get(feeShareRecordId);
            DynamicObjectCollection feeShareRecordEntry = feeShareRecord.getDynamicObjectCollection("entry");
            for (DynamicObject feeShareRecordEntryRow : feeShareRecordEntry) {
                boolean isMainBill = feeShareRecordEntryRow.getBoolean("ismianbill");
                if (isMainBill) continue;
                Long calBillEntryId = feeShareRecordEntryRow.getLong("calentryid");
                DynamicObject mainCostRecordEntryRow = mainCostRecordEntryMap.get(calBillEntryId);
                try {
                    this.shareCostRecord(mainEntryRow, mainCostRecordEntryRow, feeShareRecordEntryRow);
                }
                catch (Exception e) {
                    log.error("shareCostRecord--main--error", (Throwable)e);
                    throw e;
                }
                List<DynamicObject> notMainCostRecordEntryRows = notMainCostRecordEntryMap.get(calBillEntryId);
                if (notMainCostRecordEntryRows == null || notMainCostRecordEntryRows.isEmpty()) continue;
                for (DynamicObject notMainCostRecordEntryRow : notMainCostRecordEntryRows) {
                    try {
                        this.shareCostRecord(mainEntryRow, notMainCostRecordEntryRow, feeShareRecordEntryRow);
                    }
                    catch (Exception e) {
                        log.error("shareCostRecord--notmain--error", (Throwable)e);
                        throw e;
                    }
                }
            }
        }
        log.info("feeShareResultHolder.saveToDB--start");
        try {
            this.feeShareResultHolder.saveToDB();
        }
        catch (Exception e) {
            log.error("shareCostRecord--saveToDB--error", (Throwable)e);
            throw e;
        }
        log.info("feeShareResultHolder.saveToDB--end");
    }

    private void shareCostRecord(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, DynamicObject feeShareRecordEntryRow) {
        boolean isAdjustBusApBill;
        if (costRecordEntryRow == null) {
            String msg = ResManager.loadKDString((String)"\u5206\u644a\u52fe\u7a3d\u8bb0\u5f55\u4e2d\u6d89\u53ca\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u9700\u8981\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u91cc\u9762\u89e3\u9501\u6570\u636e\uff0c\u7136\u540e\u53cd\u5206\u644a\u91cd\u65b0\u5206\u644a\u3002", (String)"CalFeeShareStrategy_0", (String)"fi-cal-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        Map<Long, Integer> apBillEntryId2SeqMap = this.feeShareDataHolder.getApBillEntryId2SeqMap();
        Map<Long, Date> apBillEntryId2ExratedateMap = this.feeShareDataHolder.getApBillEntryId2ExratedateMap();
        Set<Long> adjustBusApBillIds = this.feeShareDataHolder.getAdjustBusApBillIds();
        DynamicObject asstBillParent = (DynamicObject)costRecordEntryRow.getParent();
        Long calorg = asstBillParent.getDynamicObject("calorg").getLong("id");
        DynamicObject billCurrency = asstBillParent.getDynamicObject("localcurrency");
        boolean isExpenseItemFeeShare = this.feeShareConfigHelper.isExpenseItemFeeShare(mainEntryRow);
        long asstBillHeadId = asstBillParent.getLong("id");
        long asstBillEntryId = costRecordEntryRow.getLong("id");
        long apBillHeadId = mainEntryRow.getLong("billid");
        long apBillEntryId = mainEntryRow.getLong("billentryid");
        long shareId = ((DynamicObject)feeShareRecordEntryRow.getParent()).getLong("id");
        String accountType = costRecordEntryRow.getString("accounttype");
        boolean enablestandardcost = asstBillParent.getDynamicObject("costaccount").getBoolean("enablestandardcost");
        BigDecimal shareBaseAmount = feeShareRecordEntryRow.getBigDecimal("shareamount");
        BigDecimal shareBillAmount = this.feeShareConfigHelper.getToSourceAmt(calorg, shareBaseAmount, billCurrency, apBillEntryId2ExratedateMap.get(apBillEntryId));
        boolean bl = isAdjustBusApBill = !this.isActualFeeShare && adjustBusApBillIds.contains(apBillHeadId);
        if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
            this.feeShareResultHolder.addStdDiffBill(mainEntryRow, costRecordEntryRow, shareBillAmount, shareId, CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue(), apBillEntryId2SeqMap, isAdjustBusApBill);
            if (this.isActualFeeShare && isExpenseItemFeeShare) {
                this.feeShareResultHolder.addTotalShareFeeRecord(shareId, asstBillEntryId, shareBillAmount);
            }
        } else {
            if (enablestandardcost) {
                this.feeShareResultHolder.addStdDiffBill(mainEntryRow, costRecordEntryRow, shareBillAmount, shareId, CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue(), apBillEntryId2SeqMap, isAdjustBusApBill);
            }
            if (this.feeShareConfigHelper.isNoWriteBack(costRecordEntryRow, mainEntryRow, isExpenseItemFeeShare)) {
                this.feeShareResultHolder.addCostAdjustBill(mainEntryRow, costRecordEntryRow, shareBillAmount, shareId, CostAdjustBillDiffTypeEnum.ACT_COST.getValue(), apBillEntryId2SeqMap, isAdjustBusApBill);
                if (this.isActualFeeShare && isExpenseItemFeeShare) {
                    this.feeShareResultHolder.addTotalShareFeeRecord(shareId, asstBillEntryId, shareBillAmount);
                }
            } else {
                this.feeShareResultHolder.addCostRecordAmtUpdateParams(costRecordEntryRow, shareBillAmount, mainEntryRow);
                if (this.isActualFeeShare) {
                    this.feeShareResultHolder.addFeeShareDetaiRecord(mainEntryRow, costRecordEntryRow, shareBillAmount, shareBillAmount, shareId);
                } else {
                    this.feeShareResultHolder.addEstFeeShareDetaiRecord(mainEntryRow, costRecordEntryRow, shareBillAmount, shareBaseAmount, shareId, apBillEntryId2SeqMap);
                }
            }
        }
        if (this.isActualFeeShare && isExpenseItemFeeShare) {
            this.feeShareResultHolder.addCostRecordTotalFeeIsAllocateUpdateParams(shareBillAmount, asstBillEntryId, asstBillHeadId);
        }
    }
}

