/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.in;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class FeeShareConfigHelper {
    private Map<Long, Date> costAccountBeginDateMap = new HashMap<Long, Date>(16);
    private Set<Long> calByEleCostAccountIds = new HashSet<Long>(16);
    private Map<String, Long> costAccountStorageorg2CostTypeMap = new HashMap<String, Long>(16);
    private Map<String, Long> costTypeExpenseItem2SubElementMap = new HashMap<String, Long>(16);
    private Map<String, Long> costTypeMaterial2SubElementMap = new HashMap<String, Long>(16);
    private Long defaultFeeElement = 773175492709890048L;
    private Long defaultProcessCostElement = 773176488857077760L;
    private Map<Long, StandardAmtExchange> calorg2StandardAmtExchangeMap = new HashMap<Long, StandardAmtExchange>(4);
    private Map<Long, String> calorg2SysParamsWriteBackMap = new HashMap<Long, String>(4);
    private Long[] defaMaterialElements = CostElementHelper.getDefaultMaterialElements();
    private List<Long[]> allCostElements = CostElementHelper.getAllCostEle4InitBill();
    private Map<Long, Date> periodBeginDateMap = new HashMap<Long, Date>(16);
    private Map<Long, Date> periodEndDateMap = new HashMap<Long, Date>(16);
    private boolean isActualFeeShare;

    public FeeShareConfigHelper(Set<Long> costaccountIds, Set<Long> expenseitemIds, Set<Long> periodIds, boolean isActualFeeShare, Set<Long> materialIds) {
        Long costtype;
        Object row3;
        Object subElementid2;
        Object row22;
        Serializable costAccountId;
        Map currentPeriods = PeriodHelper.getCurrentPeriods(costaccountIds);
        for (Map.Entry costaccountId2period : currentPeriods.entrySet()) {
            if (costaccountId2period.getValue() == null) {
                DynamicObject costaccount = BusinessDataServiceHelper.loadSingle(costaccountId2period.getKey(), (String)"cal_bd_costaccount");
                String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FeeShareConfigHelper_0", (String)"fi-cal-business", (Object[])new Object[0]);
                msg = String.format(msg, costaccount.getString("name"));
                throw new KDBizException(msg);
            }
            this.costAccountBeginDateMap.put((Long)costaccountId2period.getKey(), ((DynamicObject)costaccountId2period.getValue()).getDate("begindate"));
        }
        QFilter q = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        q.and("id", "in", costaccountIds);
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calorg.name,calpolicy.calbycostelement,calpolicy.supporttaxamt,calpolicy.currency.amtprecision", (QFilter[])q.toArray());
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        HashMap<Long, String> notCurrencyCalorgid2NameMap = new HashMap<Long, String>(4);
        for (DynamicObject costAccount : costAccounts) {
            costAccountId = Long.valueOf(costAccount.getLong("id"));
            Boolean calbycostelement = costAccount.getBoolean("calpolicy.calbycostelement");
            Long calorgid = costAccount.getLong("calorg");
            String calorgName = costAccount.getString("calorg");
            notCurrencyCalorgid2NameMap.put(calorgid, calorgName);
            calOrgIds.add(calorgid);
            if (!calbycostelement.booleanValue()) continue;
            this.calByEleCostAccountIds.add((Long)costAccountId);
        }
        QFilter defaultFilter = new QFilter("defaultvalue", "=", (Object)Boolean.TRUE);
        defaultFilter.and("type", "in", (Object)new String[]{"002", "005"});
        defaultFilter.and("syncflag", "=", (Object)"1");
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,type", (QFilter[])defaultFilter.toArray(), null);
        costAccountId = null;
        try {
            for (Object row22 : subElementDs) {
                subElementid2 = row22.getLong("id");
                String type = row22.getString("type");
                if ("002".equals(type)) {
                    this.defaultFeeElement = subElementid2;
                    continue;
                }
                if (!"005".equals(type)) continue;
                this.defaultProcessCostElement = subElementid2;
            }
        }
        catch (Throwable calbycostelement) {
            costAccountId = calbycostelement;
            throw calbycostelement;
        }
        finally {
            if (subElementDs != null) {
                if (costAccountId != null) {
                    try {
                        subElementDs.close();
                    }
                    catch (Throwable calbycostelement) {
                        ((Throwable)costAccountId).addSuppressed(calbycostelement);
                    }
                } else {
                    subElementDs.close();
                }
            }
        }
        Date now = TimeServiceHelper.now();
        QFilter filter = new QFilter("effectdate", "<=", (Object)now);
        filter.and("invaliddate", ">", (Object)now);
        filter.and("costaccount", "in", costaccountIds);
        filter.and("bizstatus", "=", (Object)"1");
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costtypeorg", (String)"costaccount,storageorgunit,costtype", (QFilter[])filter.toArray(), null);
        row22 = null;
        try {
            for (Object row3 : ds) {
                Long costaccount = row3.getLong("costaccount");
                Long storageorgunit = row3.getLong("storageorgunit");
                costtype = row3.getLong("costtype");
                this.costAccountStorageorg2CostTypeMap.put(costaccount.toString() + storageorgunit, costtype);
            }
        }
        catch (Throwable subElementid2) {
            row22 = subElementid2;
            throw subElementid2;
        }
        finally {
            if (ds != null) {
                if (row22 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable subElementid2) {
                        ((Throwable)row22).addSuppressed(subElementid2);
                    }
                } else {
                    ds.close();
                }
            }
        }
        QFilter subFilter = new QFilter("costtype", "in", this.costAccountStorageorg2CostTypeMap.values());
        subFilter.and("expenseitem", "in", expenseitemIds);
        DataSet ds2 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelemententry", (String)"costtype,expenseitem,subelement", (QFilter[])subFilter.toArray(), null);
        subElementid2 = null;
        try {
            for (Object row4 : ds2) {
                Long costtype2 = row4.getLong("costtype");
                Long expenseitem = row4.getLong("expenseitem");
                Long subelement = row4.getLong("subelement");
                this.costTypeExpenseItem2SubElementMap.put(costtype2.toString() + expenseitem, subelement);
            }
        }
        catch (Throwable row3) {
            subElementid2 = row3;
            throw row3;
        }
        finally {
            if (ds2 != null) {
                if (subElementid2 != null) {
                    try {
                        ds2.close();
                    }
                    catch (Throwable row3) {
                        ((Throwable)subElementid2).addSuppressed(row3);
                    }
                } else {
                    ds2.close();
                }
            }
        }
        QFilter elementMaterialFilter = new QFilter("costtype", "in", this.costAccountStorageorg2CostTypeMap.values());
        elementMaterialFilter.and("material", "in", materialIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement_material", (String)"id,subelement,costtype,material", (QFilter[])elementMaterialFilter.toArray(), null);
        row3 = null;
        try {
            for (Row row5 : dataSet) {
                costtype = row5.getLong("costtype");
                Long material = row5.getLong("material");
                Long subelement = row5.getLong("subelement");
                this.costTypeMaterial2SubElementMap.put(costtype.toString() + material, subelement);
            }
        }
        catch (Throwable row4) {
            row3 = row4;
            throw row4;
        }
        finally {
            if (dataSet != null) {
                if (row3 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row4) {
                        ((Throwable)row3).addSuppressed(row4);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        DynamicObject[] baseCurrency = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"baseacctorg,basecurrrency,basecurrrency.amtprecision,exratetable", (QFilter[])new QFilter("baseacctorg", "in", calOrgIds).toArray());
        for (DynamicObject dynamicObject : baseCurrency) {
            Long calorgId = dynamicObject.getDynamicObject("baseacctorg").getLong("id");
            DynamicObject basecurrrency = dynamicObject.getDynamicObject("basecurrrency");
            Long exratetable = dynamicObject.getDynamicObject("exratetable").getLong("id");
            this.calorg2StandardAmtExchangeMap.put(calorgId, new StandardAmtExchange(basecurrrency, exratetable));
            notCurrencyCalorgid2NameMap.remove(calorgId);
        }
        if (!notCurrencyCalorgid2NameMap.isEmpty()) {
            Object msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u672a\u8bbe\u7f6e\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\uff0c\u8bf7\u5728\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011\u2192\u3010\u57fa\u7840\u8d44\u6599\u3011\u2192\u3010\u8d22\u52a1\u6570\u636e\u3011\u2192\u3010\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e\u3011\u4e2d\u7ef4\u62a4\u3002", (String)"FeeShareConfigHelper_1", (String)"fi-cal-business", (Object[])new Object[0]);
            msg = String.format((String)msg, String.join((CharSequence)"\u3011\u3010", notCurrencyCalorgid2NameMap.values()));
            throw new KDBizException((String)msg);
        }
        for (Long calOrgId : calOrgIds) {
            String writeBackMessage = (String)ParamsHelper.getAppParam((long)calOrgId, (String)"issameperiodwriteback");
            if (writeBackMessage == null) {
                writeBackMessage = "A";
            }
            this.calorg2SysParamsWriteBackMap.put(calOrgId, writeBackMessage);
        }
        try (DataSet ds3 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter("id", "in", periodIds).toArray(), null);){
            for (Row row6 : ds3) {
                Long id = row6.getLong("id");
                Date begindate = row6.getDate("begindate");
                Date enddate = row6.getDate("enddate");
                this.periodBeginDateMap.put(id, begindate);
                this.periodEndDateMap.put(id, enddate);
            }
        }
        this.isActualFeeShare = isActualFeeShare;
    }

    public boolean isNoWriteBack(DynamicObject costRecordEntryRow, DynamicObject mainEntryRow, boolean isExpenseItemFeeShare) {
        if (!isExpenseItemFeeShare) {
            return true;
        }
        DynamicObject asstBillParent = (DynamicObject)costRecordEntryRow.getParent();
        Date mainBillDate = mainEntryRow.getDate("bookdate");
        Long calOrgId = asstBillParent.getDynamicObject("calorg").getLong("id");
        String writeBackMessage = this.calorg2SysParamsWriteBackMap.get(calOrgId);
        if (writeBackMessage == null) {
            writeBackMessage = "A";
        }
        boolean nowriteBack = true;
        if ("A".equals(writeBackMessage) && this.isSamePeriod(asstBillParent, mainBillDate)) {
            Date bizDate = asstBillParent.getDate("bizdate");
            Date beginDate = this.getCostAccountBeginDate(asstBillParent);
            boolean isCher = asstBillParent.getBoolean("isvoucher");
            boolean realTime = AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(costRecordEntryRow.getString("accounttype")) || AccountTypeEnum.FIN_FOUT.getValue().equals(costRecordEntryRow.getString("accounttype"));
            boolean bizDateFlag = bizDate.compareTo(beginDate) < 0;
            boolean isinitbill = asstBillParent.getBoolean("isinitbill");
            nowriteBack = bizDateFlag || realTime || isCher || isinitbill;
        }
        return nowriteBack;
    }

    private boolean isSamePeriod(DynamicObject asstBillParent, Date mainBillDate) {
        Long period = asstBillParent.getDynamicObject("period").getLong("id");
        Date beginDate = this.periodBeginDateMap.get(period);
        Date endDate = this.periodEndDateMap.get(period);
        return mainBillDate.compareTo(beginDate) >= 0 && mainBillDate.compareTo(endDate) <= 0;
    }

    private Date getCostAccountBeginDate(DynamicObject asstBillParent) {
        long costAccountId = asstBillParent.getDynamicObject("costaccount").getLong("id");
        Date beginDate = this.costAccountBeginDateMap.get(costAccountId);
        if (beginDate != null) {
            return beginDate;
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        beginDate = period.getDate("begindate");
        this.costAccountBeginDateMap.put(costAccountId, beginDate);
        return beginDate;
    }

    public Date getMaxDateFromMainAsstBill(DynamicObject mainEntryRow, DynamicObject asstParentBill, String asstDateField) {
        Date mainDate = mainEntryRow.getDate(asstDateField);
        Date asstDate = asstParentBill.getDate(asstDateField);
        long costAccountID = asstParentBill.getDynamicObject("costaccount").getLong("id");
        Date costAccountBeginDate = this.costAccountBeginDateMap.get(costAccountID);
        if (costAccountBeginDate == null) {
            DynamicObject value = PeriodHelper.getCurrentPeriod((Long)costAccountID);
            costAccountBeginDate = value.getDate("beginDate");
            this.costAccountBeginDateMap.put(costAccountID, costAccountBeginDate);
        }
        Date MaxDate = costAccountBeginDate;
        if (null != mainDate) {
            Date date = MaxDate = MaxDate.compareTo(mainDate) > 0 ? MaxDate : mainDate;
        }
        if (null != asstDate) {
            MaxDate = MaxDate.compareTo(asstDate) > 0 ? MaxDate : asstDate;
        }
        return MaxDate;
    }

    public Long getFeeSubElementId(DynamicObject costRecordEntryRow, DynamicObject mainEntryRow) {
        Long subElementid;
        DynamicObject asstBillParent = (DynamicObject)costRecordEntryRow.getParent();
        Long costAccountId = asstBillParent.getDynamicObject("costaccount").getLong("id");
        if (!this.calByEleCostAccountIds.contains(costAccountId)) {
            return 773175233367685120L;
        }
        Long expenseItemId = mainEntryRow.getLong("expenseitem.id");
        Long material = mainEntryRow.getLong("material.id");
        Long storageorgunit = asstBillParent.getDynamicObject("storageorgunit").getLong("id");
        String bizentityobject = asstBillParent.getString("bizentityobject.id");
        Long costTypeId = this.costAccountStorageorg2CostTypeMap.get(costAccountId.toString() + storageorgunit);
        if (costTypeId == null) {
            costTypeId = this.costAccountStorageorg2CostTypeMap.get(costAccountId.toString() + 0L);
            Long l = costTypeId = costTypeId == null ? Long.valueOf(0L) : costTypeId;
        }
        if (expenseItemId == null || expenseItemId == 0L) {
            if ("im_mdc_ominbill".equals(bizentityobject) || "im_ospurinbill".equals(bizentityobject)) {
                subElementid = this.defaultProcessCostElement;
            } else {
                subElementid = this.costTypeMaterial2SubElementMap.get(costTypeId.toString() + material);
                if (subElementid == null) {
                    subElementid = 773175233367685120L;
                }
            }
        } else {
            subElementid = this.costTypeExpenseItem2SubElementMap.get(costTypeId.toString() + expenseItemId);
            if (subElementid == null) {
                subElementid = this.defaultFeeElement;
            }
        }
        return subElementid;
    }

    public static String getBillAllFields(String billEntity) {
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        if ("cal_costrecord_subentity".equals(billEntity) || "ap_busbill".equals(billEntity)) {
            fields.append("entry.seq");
        } else if ("cal_costadjust_subentity".equals(billEntity) || "cal_stdcostdiffbill".equals(billEntity)) {
            fields.append("entryentity.seq");
        } else if ("ap_finapbill".equals(billEntity)) {
            fields.append("detailentry.seq");
        }
        return fields.toString();
    }

    public BigDecimal getToSourceAmt(Long calorg, BigDecimal shareAmount, DynamicObject billCurrency, Date shareDate) {
        StandardAmtExchange exchange = this.calorg2StandardAmtExchangeMap.get(calorg);
        BigDecimal sourceAmt = exchange.exchangeToSourceAmt(shareAmount, billCurrency, shareDate);
        return sourceAmt;
    }

    public BigDecimal getShareBaseAmount(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, DynamicObject feeShareRecordEntryRow, Set<Long> istaxdeductionBillIds) {
        BigDecimal shareamount;
        BigDecimal shareBaseAmt = shareamount = feeShareRecordEntryRow.getBigDecimal("shareamount");
        return shareBaseAmt;
    }

    public boolean isCalByElement(DynamicObject costRecordEntryRow) {
        DynamicObject asstBillParent = (DynamicObject)costRecordEntryRow.getParent();
        Long costAccountId = asstBillParent.getDynamicObject("costaccount").getLong("id");
        return this.calByEleCostAccountIds.contains(costAccountId);
    }

    public Long[] getDefaMaterialElements() {
        return this.defaMaterialElements;
    }

    public List<Long[]> getAllCostElements() {
        return this.allCostElements;
    }

    public boolean isActualFeeShare() {
        return this.isActualFeeShare;
    }

    public boolean isExpenseItemFeeShare(DynamicObject mainEntryRow) {
        Long expenseItemId = mainEntryRow.getLong("expenseitem.id");
        return expenseItemId != null && Long.compare(expenseItemId, 0L) != 0;
    }
}

