/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.in;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.constant.CommonConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.PeriodHelper;

public class FeeShareCostAdjustBillHelper {
    private static final Log logger = LogFactory.getLog(FeeShareCostAdjustBillHelper.class);
    private Map<Long, DynamicObject> apBillMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Date> wfid2exratedate = new HashMap<Long, Date>(16);
    private Map<Long, DynamicObject> costRecordMap = new HashMap<Long, DynamicObject>(16);
    private Set<Long> calorgIds = new HashSet<Long>(16);
    private Map<Long, DynamicObject> calorg2CurrencyMap = new HashMap<Long, DynamicObject>(4);
    private Map<Long, StandardAmtExchange> calorg2StandardAmtExchangeMap = new HashMap<Long, StandardAmtExchange>(4);
    private Set<Map<String, Object>> params;
    private Map<Long, DynamicObject> apEid2FeeShareRecordMap = new HashMap<Long, DynamicObject>(4);
    private Long writeoffTypeId = 0L;
    private String entity = "";
    private Map<Date, Set<Long>> startDate2costaccountMap = new HashMap<Date, Set<Long>>(4);
    private Set<Long> feesharerecordIds = new HashSet<Long>(4);
    private IDGenerator idGenerator = new IDGenerator("t_cal_feerecord");
    private boolean isActualFeeShare = true;

    public FeeShareCostAdjustBillHelper(Set<Map<String, Object>> params) {
        this.initParams(params, true);
    }

    public FeeShareCostAdjustBillHelper(Set<Map<String, Object>> params, boolean isActualFeeShare) {
        this.initParams(params, isActualFeeShare);
    }

    private void initParams(Set<Map<String, Object>> params, boolean isActualFeeShare) {
        this.isActualFeeShare = isActualFeeShare;
        this.params = params;
        HashSet<Long> apbillids = new HashSet<Long>(16);
        HashSet<Long> apbillentryids = new HashSet<Long>(16);
        HashSet<Long> bizbillids = new HashSet<Long>(16);
        HashSet<Long> bizbillentryids = new HashSet<Long>(16);
        for (Map<String, Object> param : params) {
            Long apbillid = (Long)param.get("apbillid");
            Long apbillentryid = (Long)param.get("apbillentryid");
            Long bizbillid = (Long)param.get("bizbillid");
            Long bizbillentryid = (Long)param.get("bizbillentryid");
            apbillids.add(apbillid);
            apbillentryids.add(apbillentryid);
            bizbillids.add(bizbillid);
            bizbillentryids.add(bizbillentryid);
        }
        if (isActualFeeShare) {
            this.initApBill(apbillids, apbillentryids);
            this.writeoffTypeId = CommonConstant.HXLB_ACTUALFEE_SHARE;
            this.entity = "ap_finapbill";
        } else {
            this.initBusApBill(apbillids, apbillentryids);
            this.writeoffTypeId = CommonConstant.HXLB_ESTFEE_SHARE;
            this.entity = "ap_busbill";
        }
        this.initCostRecord(bizbillids, bizbillentryids);
        this.initStandAmtExchageMap();
    }

    private void initBusApBill(Set<Long> apbillids, Set<Long> apbillentryids) {
        QFilter filter = new QFilter("id", "in", apbillids);
        filter.and("entry.id", "in", apbillentryids);
        DynamicObjectCollection aps = QueryServiceHelper.query((String)"ap_busbill", (String)"id,billno,exratedate,currency,asstacttype,asstact,entry.id as detailentry.id,entry.seq as detailentry.seq,entry.e_expenseitem as detailentry.expenseitem,billtype as billtypeid,bizdate,bookdate", (QFilter[])filter.toArray(), null);
        for (DynamicObject ap : aps) {
            this.apBillMap.put(ap.getLong("detailentry.id"), ap);
        }
    }

    private void initStandAmtExchageMap() {
        DynamicObject[] baseCurrency;
        for (DynamicObject dynamicObject : baseCurrency = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"baseacctorg,basecurrrency,basecurrrency.amtprecision,exratetable", (QFilter[])new QFilter("baseacctorg", "in", this.calorgIds).toArray())) {
            Long calorgId = dynamicObject.getDynamicObject("baseacctorg").getLong("id");
            DynamicObject basecurrrency = dynamicObject.getDynamicObject("basecurrrency");
            Long exratetable = dynamicObject.getDynamicObject("exratetable").getLong("id");
            this.calorg2CurrencyMap.put(calorgId, basecurrrency);
            this.calorg2StandardAmtExchangeMap.put(calorgId, new StandardAmtExchange(basecurrrency, exratetable));
        }
    }

    private void initCostRecord(Set<Long> bizbillids, Set<Long> bizbillentryids) {
        QFilter filter = new QFilter("bizbillid", "in", bizbillids);
        filter.and("entry.bizbillentryid", "in", bizbillentryids);
        filter.and("costaccount.enable", "=", (Object)"1");
        filter.and("costaccount.ismainaccount", "=", (Object)true);
        filter.and("calbilltype", "=", (Object)"IN");
        filter.and("issplitcreate", "=", (Object)false);
        DynamicObjectCollection crs = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)"id,calorg,billtype,billno,costaccount,entry.calentryid,entry.bizbillentryid,calbillid,supplier,entry.material,entry.id,entry.seq,bizdate,bookdate", (QFilter[])filter.toArray(), null);
        HashSet<Long> costAccountIds = new HashSet<Long>(4);
        for (DynamicObject cr : crs) {
            this.costRecordMap.put(cr.getLong("entry.bizbillentryid"), cr);
            this.calorgIds.add(cr.getLong("calorg"));
            costAccountIds.add(cr.getLong("costaccount"));
        }
        Map currentPeriods = PeriodHelper.getCurrentPeriods(costAccountIds);
        for (Map.Entry infoEntry : currentPeriods.entrySet()) {
            Long costAccountId = (Long)infoEntry.getKey();
            Date begindate = ((DynamicObject)infoEntry.getValue()).getDate("begindate");
            Set curCostAccountids = this.startDate2costaccountMap.computeIfAbsent(begindate, k -> new HashSet(4));
            curCostAccountids.add(costAccountId);
        }
    }

    private void initApBill(Set<Long> apbillids, Set<Long> apbillentryids) {
        QFilter filter = new QFilter("id", "in", apbillids);
        filter.and("detailentry.id", "in", apbillentryids);
        DynamicObjectCollection aps = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno,exratedate,currency,asstacttype,asstact,detailentry.id,detailentry.seq,detailentry.expenseitem,billtypeid,bizdate,bookdate", (QFilter[])filter.toArray(), null);
        for (DynamicObject ap : aps) {
            this.apBillMap.put(ap.getLong("detailentry.id"), ap);
        }
    }

    public void createBill() {
        for (Map<String, Object> param : this.params) {
            Long apbillentryid = (Long)param.get("apbillentryid");
            Long bizbillentryid = (Long)param.get("bizbillentryid");
            Long currency = (Long)param.get("currency");
            BigDecimal e_amount = (BigDecimal)param.get("e_amount");
            BigDecimal e_taxamount = (BigDecimal)param.get("e_taxamount");
            DynamicObject feeShardRecord = this.getFeeShardRecord(apbillentryid);
            this.addAssBill2Rcord(bizbillentryid, feeShardRecord, e_amount, e_taxamount, currency);
        }
        this.resolveRecord();
        SaveServiceHelper.save((DynamicObject[])this.apEid2FeeShareRecordMap.values().toArray(new DynamicObject[0]));
        HashSet<Long> recordIds = new HashSet<Long>(16);
        for (DynamicObject record : this.apEid2FeeShareRecordMap.values()) {
            recordIds.add(record.getLong("id"));
        }
        logger.info("ids\u8c03\u7528\u5206\u644a\u6b63\u5411\u64cd\u4f5c\u5f00\u59cb");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalNewFeeShareService", (String)"execute4Ids", (Object[])new Object[]{recordIds});
        logger.info("ids\u8c03\u7528\u5206\u644a\u6b63\u5411\u64cd\u4f5c\u7ed3\u675f");
    }

    private void resolveRecord() {
        DynamicObjectCollection entry;
        HashMap<Long, Long> wfid2ExpenseitemMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> wfid2ShareCurrencyMap = new HashMap<Long, Long>(16);
        HashMap<Long, BigDecimal> wfid2shareamountMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> wfid2sharetaxamountMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject record : this.apEid2FeeShareRecordMap.values()) {
            Long wfId = record.getLong("id");
            entry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                boolean ismianbill = entryRow.getBoolean("ismianbill");
                if (ismianbill) {
                    wfid2ExpenseitemMap.put(wfId, entryRow.getLong("expenseitem"));
                    continue;
                }
                wfid2ShareCurrencyMap.put(wfId, entryRow.getLong("sharecurrency"));
                BigDecimal shareamount = entryRow.getBigDecimal("shareamount");
                BigDecimal sharetaxamount = entryRow.getBigDecimal("sharetaxamount");
                BigDecimal amt3 = (BigDecimal)wfid2shareamountMap.get(wfId);
                BigDecimal amt4 = (BigDecimal)wfid2sharetaxamountMap.get(wfId);
                amt3 = amt3 == null ? shareamount : amt3.add(shareamount);
                amt4 = amt4 == null ? sharetaxamount : amt4.add(sharetaxamount);
                wfid2shareamountMap.put(wfId, amt3);
                wfid2sharetaxamountMap.put(wfId, amt4);
            }
        }
        for (DynamicObject record : this.apEid2FeeShareRecordMap.values()) {
            Long wfid = record.getLong("id");
            entry = record.getDynamicObjectCollection("entry");
            Long calorg = record.getLong("org");
            Date exratedate = this.wfid2exratedate.get(wfid);
            for (DynamicObject entryRow : entry) {
                boolean ismianbill = entryRow.getBoolean("ismianbill");
                if (ismianbill) {
                    Long currencyId = entryRow.getLong("currency");
                    DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
                    entryRow.set("sharecurrency", wfid2ShareCurrencyMap.get(wfid));
                    entryRow.set("e_amount", (Object)this.calorg2StandardAmtExchangeMap.get(calorg).exchangeToSourceAmt((BigDecimal)wfid2shareamountMap.get(wfid), currency, exratedate));
                    entryRow.set("e_taxamount", (Object)this.calorg2StandardAmtExchangeMap.get(calorg).exchangeToSourceAmt((BigDecimal)wfid2sharetaxamountMap.get(wfid), currency, exratedate));
                    entryRow.set("shareamount", wfid2shareamountMap.get(wfid));
                    entryRow.set("sharetaxamount", wfid2sharetaxamountMap.get(wfid));
                    continue;
                }
                entryRow.set("expenseitem", wfid2ExpenseitemMap.get(wfid));
            }
        }
    }

    private void addAssBill2Rcord(Long bizbillentryid, DynamicObject feeShardRecord, BigDecimal e_amount, BigDecimal e_taxamount, Long currencyid) {
        DynamicObject entry = feeShardRecord.getDynamicObjectCollection("entry").addNew();
        DynamicObject costrecord = this.costRecordMap.get(bizbillentryid);
        if (costrecord == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u4e1a\u52a1\u5904\u7406\u65e5\u5fd7\u3002", (String)"FeeShareCostAdjustBillHelper_0", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        entry.set("billid", (Object)costrecord.getLong("id"));
        entry.set("billentryid", (Object)costrecord.getLong("entry.id"));
        entry.set("billtype", (Object)"cal_costrecord_subentity");
        entry.set("billtypeid", (Object)costrecord.getLong("billtype"));
        entry.set("billno", (Object)costrecord.getString("billno"));
        entry.set("bizdate", (Object)costrecord.getDate("bizdate"));
        entry.set("bookdate", (Object)costrecord.getDate("bookdate"));
        entry.set("billseq", (Object)costrecord.getInt("entry.seq"));
        entry.set("asstacttype", (Object)"bd_supplier");
        entry.set("asstact", (Object)costrecord.getLong("supplier"));
        entry.set("calentryid", (Object)costrecord.getLong("entry.calentryid"));
        entry.set("bizbillentryid", (Object)costrecord.getLong("entry.bizbillentryid"));
        entry.set("material", (Object)costrecord.getLong("entry.material"));
        entry.set("shareuser", (Object)RequestContext.get().getUserId());
        Long calorg = costrecord.getLong("calorg");
        feeShardRecord.set("org", (Object)calorg);
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyid, (String)"bd_currency");
        Date exratedate = this.wfid2exratedate.get(feeShardRecord.getLong("id"));
        BigDecimal shareamount = this.calorg2StandardAmtExchangeMap.get(calorg).exchangeToStandardAmt(e_amount, currency, exratedate);
        BigDecimal sharetaxamount = this.calorg2StandardAmtExchangeMap.get(calorg).exchangeToStandardAmt(e_taxamount, currency, exratedate);
        entry.set("e_amount", (Object)e_amount);
        entry.set("e_taxamount", (Object)e_taxamount);
        entry.set("currency", (Object)currencyid);
        entry.set("shareamount", (Object)shareamount);
        entry.set("sharetaxamount", (Object)sharetaxamount);
        entry.set("sharecurrency", (Object)this.calorg2CurrencyMap.get(calorg).getLong("id"));
        entry.set("ismianbill", (Object)false);
    }

    private DynamicObject getFeeShardRecord(Long apbillentryid) {
        DynamicObject record = this.apEid2FeeShareRecordMap.get(apbillentryid);
        if (record == null) {
            DynamicObject apbill = this.apBillMap.get(apbillentryid);
            if (apbill == null) {
                String apEnttiyName = MetadataServiceHelper.getDataEntityType((String)this.entity).getDisplayName().getLocaleValue();
                String msg = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1$s\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FeeShareCostAdjustBillHelper_1", (String)"fi-cal-business", (Object[])new Object[0]), apEnttiyName);
                throw new KDBizException(msg);
            }
            record = BusinessDataServiceHelper.newDynamicObject((String)"cal_feeshare_newrecord");
            Long id = this.idGenerator.getId();
            this.feesharerecordIds.add(id);
            record.set("id", (Object)id);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String dateStr = simpleDateFormat.format(new Date());
            long shareNum = Long.parseLong(dateStr);
            record.set("wfnumber", (Object)shareNum);
            record.set("createtime", (Object)new Date());
            record.set("sharedate", (Object)new Date());
            record.set("creator", (Object)RequestContext.get().getUserId());
            record.set("writeofftypeid", (Object)this.writeoffTypeId);
            DynamicObject entry = record.getDynamicObjectCollection("entry").addNew();
            entry.set("billentryid", (Object)apbill.getLong("detailentry.id"));
            entry.set("currency", (Object)apbill.getLong("currency"));
            entry.set("billtype", (Object)this.entity);
            entry.set("billtypeid", (Object)apbill.getLong("billtypeid"));
            entry.set("billid", (Object)apbill.getLong("id"));
            entry.set("billno", (Object)apbill.getString("billno"));
            entry.set("bizdate", (Object)apbill.getDate("bizdate"));
            entry.set("bookdate", (Object)apbill.getDate("bookdate"));
            entry.set("billseq", (Object)apbill.getInt("detailentry.seq"));
            entry.set("asstacttype", (Object)apbill.getString("asstacttype"));
            entry.set("asstact", (Object)apbill.getLong("asstact"));
            entry.set("expenseitem", (Object)apbill.getLong("detailentry.expenseitem"));
            entry.set("shareuser", (Object)RequestContext.get().getUserId());
            entry.set("ismianbill", (Object)true);
            this.apEid2FeeShareRecordMap.put(apbillentryid, record);
            this.wfid2exratedate.put(id, apbill.getDate("exratedate"));
        }
        return record;
    }

    public Set<Long> getAdjustBillIds() {
        HashSet costAccountids = new HashSet(4);
        Date minBookdate = null;
        for (Map.Entry<Date, Set<Long>> dateSetEntry : this.startDate2costaccountMap.entrySet()) {
            Date bookdate = dateSetEntry.getKey();
            if (bookdate != null && (minBookdate == null || minBookdate.after(bookdate))) {
                minBookdate = bookdate;
            }
            costAccountids.addAll(dateSetEntry.getValue());
        }
        QFilter filter = new QFilter("costaccount", "in", costAccountids);
        filter.and("bookdate", ">=", minBookdate);
        filter.and("feeshareflag", "in", this.feesharerecordIds);
        if (this.isActualFeeShare) {
            filter.and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue());
        } else {
            filter.and("createtype", "in", (Object)new String[]{CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue(), CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue()});
        }
        HashSet<Long> costAdjustBillIds = new HashSet<Long>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"id", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                costAdjustBillIds.add(row.getLong("id"));
            }
        }
        return costAdjustBillIds;
    }
}

