/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.in;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.in.FeeShareConfigHelper;
import kd.fi.cal.common.constant.CommonConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.util.DateUtils;

public class FeeShareDataHolder {
    private FeeShareConfigHelper feeShareConfigHelper;
    private boolean isActualFeeShare;
    private List<DynamicObject> feeShareRecords = new ArrayList<DynamicObject>(16);
    private Map<Long, DynamicObject> mainCostRecordEntryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, List<DynamicObject>> notMainCostRecordEntryMap = new HashMap<Long, List<DynamicObject>>(16);
    private Set<Long> bizbillids = new HashSet<Long>(16);
    private Map<Long, DynamicObject> recordId2FeeShareRecMainEntryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Integer> apBillEntryId2SeqMap = new HashMap<Long, Integer>(16);
    private Map<Long, Date> apBillEntryId2ExratedateMap = new HashMap<Long, Date>(16);
    private Set<Long> adjustBusApBillIds = new HashSet<Long>(16);
    private Set<Long> currentFeeShareIds = new HashSet<Long>(16);
    private Set<Long> feeSharedIds = new HashSet<Long>(16);

    public FeeShareDataHolder(List<DynamicObject> feeShareRecords) {
        DynamicObject[] mainCostRecords;
        String entryidFields;
        String selectFields;
        String apBillEntityKey;
        DynamicObject writeofftypeid = feeShareRecords.get(0).getDynamicObject("writeofftypeid");
        if (writeofftypeid == null) {
            String msg = ResManager.loadKDString((String)"\u5206\u644a\u7c7b\u522b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FeeShareDataHolder_0", (String)"fi-cal-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.isActualFeeShare = CommonConstant.HXLB_ACTUALFEE_SHARE.compareTo(writeofftypeid.getLong("id")) == 0;
        this.feeShareRecords.addAll(feeShareRecords);
        HashSet<Long> costaccountIds = new HashSet<Long>(16);
        HashSet<Long> expenseitemIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        Date minBookdate = null;
        Date maxBookdate = null;
        HashSet<Long> mainCostRecordIds = new HashSet<Long>(16);
        HashSet<Long> calEntryIds = new HashSet<Long>(16);
        HashSet<Long> apBillEntryIds = new HashSet<Long>(16);
        HashSet<Long> apBillIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        Date maxShareDate = null;
        for (DynamicObject feeShareRecord : feeShareRecords) {
            Long feeShareRecordId = feeShareRecord.getLong("id");
            this.currentFeeShareIds.add(feeShareRecordId);
            Date shareDate = feeShareRecord.getDate("createtime");
            if (shareDate != null && (maxShareDate == null || maxShareDate.before(shareDate))) {
                maxShareDate = shareDate;
            }
            DynamicObjectCollection entry = feeShareRecord.getDynamicObjectCollection("entry");
            for (Object entryRow : entry) {
                int isMainBill;
                Date bookdate = entryRow.getDate("bookdate");
                if (minBookdate == null || bookdate.before(minBookdate)) {
                    minBookdate = bookdate;
                }
                if (maxBookdate == null || bookdate.after(maxBookdate)) {
                    maxBookdate = bookdate;
                }
                if ((isMainBill = entryRow.getBoolean("ismianbill")) != 0) {
                    apBillIds.add(entryRow.getLong("billid"));
                    apBillEntryIds.add(entryRow.getLong("billentryid"));
                    Long expenseitem = entryRow.getLong("expenseitem.id");
                    Long material = entryRow.getLong("material.id");
                    if (expenseitem != null && expenseitem != 0L) {
                        expenseitemIds.add(expenseitem);
                    }
                    if (material != null && material != 0L) {
                        materialIds.add(material);
                    }
                    this.recordId2FeeShareRecMainEntryMap.put(feeShareRecordId, (DynamicObject)entryRow);
                    continue;
                }
                mainCostRecordIds.add(entryRow.getLong("billid"));
                calEntryIds.add(entryRow.getLong("calentryid"));
            }
        }
        if (minBookdate != null) {
            minBookdate = DateUtils.getDayStartTime(minBookdate);
        }
        if (this.isActualFeeShare) {
            apBillEntityKey = "ap_finapbill";
            selectFields = "id,istaxdeduction,detailentry.seq as seq,detailentry.id as entryid,exratedate";
            entryidFields = "detailentry.id";
        } else {
            apBillEntityKey = "ap_busbill";
            selectFields = "id,isadjust,entry.seq as seq,entry.id as entryid,exratedate";
            entryidFields = "entry.id";
        }
        QFilter apBillFilter = new QFilter("id", "in", apBillIds);
        apBillFilter.and(entryidFields, "in", apBillEntryIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)apBillEntityKey, (String)selectFields, (QFilter[])apBillFilter.toArray(), null);
        Object object = null;
        try {
            for (DynamicObject[] row : ds) {
                if (!this.isActualFeeShare && row.getBoolean("isadjust").booleanValue()) {
                    this.adjustBusApBillIds.add(row.getLong("id"));
                }
                this.apBillEntryId2SeqMap.put(row.getLong("entryid"), row.getInteger("seq"));
                this.apBillEntryId2ExratedateMap.put(row.getLong("entryid"), row.getDate("exratedate"));
            }
        }
        catch (Throwable entryRow) {
            object = entryRow;
            throw entryRow;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable entryRow) {
                        ((Throwable)object).addSuppressed(entryRow);
                    }
                } else {
                    ds.close();
                }
            }
        }
        QFilter mainCostRecordFilter = new QFilter("id", "in", mainCostRecordIds);
        mainCostRecordFilter.and("costaccount.accountcosttype", "!=", (Object)"B");
        String costRecordAllFields = FeeShareConfigHelper.getBillAllFields("cal_costrecord_subentity");
        for (DynamicObject mainCostRecord : mainCostRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)costRecordAllFields, (QFilter[])mainCostRecordFilter.toArray())) {
            this.bizbillids.add(mainCostRecord.getLong("bizbillid"));
            costaccountIds.add(mainCostRecord.getDynamicObject("costaccount").getLong("id"));
            periodIds.add(mainCostRecord.getDynamicObject("period").getLong("id"));
            DynamicObjectCollection entry = mainCostRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                Long calentryid = entryRow.getLong("calentryid");
                if (!calEntryIds.contains(calentryid)) continue;
                this.mainCostRecordEntryMap.put(calentryid, entryRow);
                if (this.isActualFeeShare) {
                    this.addActFeeShardIds(entryRow);
                    continue;
                }
                this.addEstFeeShardIds(entryRow);
            }
        }
        QFilter notMainCostRecordFilter = new QFilter("bizbillid", "in", this.bizbillids);
        notMainCostRecordFilter.and("costaccount.enable", "=", (Object)"1");
        notMainCostRecordFilter.and("costaccount.ismainaccount", "=", (Object)Boolean.FALSE);
        notMainCostRecordFilter.and("costaccount.accountcosttype", "!=", (Object)"B");
        notMainCostRecordFilter.and("calbilltype", "=", (Object)"IN");
        notMainCostRecordFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        DynamicObject[] notMainCostRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)costRecordAllFields, (QFilter[])notMainCostRecordFilter.toArray());
        if (notMainCostRecords == null) {
            notMainCostRecords = new DynamicObject[]{};
        }
        for (DynamicObject costRecord : notMainCostRecords) {
            DynamicObjectCollection entry = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                Long calentryid = entryRow.getLong("calentryid");
                if (!calEntryIds.contains(calentryid)) continue;
                List costRecords = this.notMainCostRecordEntryMap.computeIfAbsent(calentryid, k -> new ArrayList(4));
                costRecords.add(entryRow);
                costaccountIds.add(costRecord.getDynamicObject("costaccount").getLong("id"));
                periodIds.add(costRecord.getDynamicObject("period").getLong("id"));
            }
        }
        this.feeShareConfigHelper = new FeeShareConfigHelper(costaccountIds, expenseitemIds, periodIds, this.isActualFeeShare, materialIds);
        this.addFeeShareIdsByCostAdjustBill(costaccountIds, minBookdate, this.currentFeeShareIds);
        this.feeSharedIds.retainAll(this.currentFeeShareIds);
    }

    private void addFeeShareIdsByCostAdjustBill(Set<Long> costaccountIds, Date minBookdate, Set<Long> currentFeeShareIds) {
        QFilter costAdjustFilter = new QFilter("costaccount", "in", costaccountIds);
        costAdjustFilter.and("bookdate", ">=", (Object)minBookdate);
        costAdjustFilter.and("createtype", "in", (Object)new String[]{CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue(), CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue(), CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue()});
        costAdjustFilter.and("feeshareflag", "in", currentFeeShareIds);
        try (DataSet costAdjustDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"feeshareflag", (QFilter[])costAdjustFilter.toArray(), null);){
            for (Row row : costAdjustDS) {
                this.feeSharedIds.add(row.getLong("feeshareflag"));
            }
        }
        costAdjustDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)"feeshareflag", (QFilter[])costAdjustFilter.toArray(), null);
        var6_6 = null;
        try {
            for (Row row : costAdjustDS) {
                this.feeSharedIds.add(row.getLong("feeshareflag"));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (costAdjustDS != null) {
                if (var6_6 != null) {
                    try {
                        costAdjustDS.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    costAdjustDS.close();
                }
            }
        }
    }

    private void addEstFeeShardIds(DynamicObject entryRow) {
        DynamicObjectCollection feeEstSubEntity = entryRow.getDynamicObjectCollection("subentryentityest");
        if (feeEstSubEntity == null || feeEstSubEntity.isEmpty()) {
            return;
        }
        for (DynamicObject feeEstShareRow : feeEstSubEntity) {
            this.feeSharedIds.add(feeEstShareRow.getLong("estimatebillid"));
        }
    }

    private void addActFeeShardIds(DynamicObject entryRow) {
        DynamicObjectCollection feeShareSubEntity = entryRow.getDynamicObjectCollection("subentryentity");
        if (feeShareSubEntity == null || feeShareSubEntity.isEmpty()) {
            return;
        }
        for (DynamicObject feeShareRow : feeShareSubEntity) {
            this.feeSharedIds.add(feeShareRow.getLong("sharercdid"));
        }
    }

    public Map<Long, DynamicObject> getRecordId2FeeShareRecMainEntryMap() {
        return this.recordId2FeeShareRecMainEntryMap;
    }

    public Map<Long, Integer> getApBillEntryId2SeqMap() {
        return this.apBillEntryId2SeqMap;
    }

    public FeeShareConfigHelper getFeeShareConfigHelper() {
        return this.feeShareConfigHelper;
    }

    public List<DynamicObject> getFeeShareRecords() {
        return this.feeShareRecords;
    }

    public Map<Long, DynamicObject> getMainCostRecordEntryMap() {
        return this.mainCostRecordEntryMap;
    }

    public Map<Long, List<DynamicObject>> getNotMainCostRecordEntryMap() {
        return this.notMainCostRecordEntryMap;
    }

    public Map<Long, Date> getApBillEntryId2ExratedateMap() {
        return this.apBillEntryId2ExratedateMap;
    }

    public Set<Long> getFeeSharedIds() {
        return this.feeSharedIds;
    }

    public Set<Long> getAdjustBusApBillIds() {
        return this.adjustBusApBillIds;
    }
}

