/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.in;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.in.FeeShareConfigHelper;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.DBUtil;

public class FeeShareResultHolder {
    private static Log log = LogFactory.getLog(FeeShareResultHolder.class);
    private FeeShareConfigHelper feeShareConfigHelper;
    private boolean isActualFeeShare;
    private Map<String, DynamicObject> costAdjustBillMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> stdDiffBillMap = new HashMap<String, DynamicObject>(16);
    private List<CostAdjustDetailParams> stdDiffBillDetailParams = new ArrayList<CostAdjustDetailParams>(16);
    private List<DynamicObject> totalShareFeeRecords = new ArrayList<DynamicObject>(16);
    private Set<Long> costRecordAmtUpdateIds = new HashSet<Long>(16);
    private Set<Long> costRecordAmtUpdateEntryIds = new HashSet<Long>(16);
    private Set<Long> needCalCostRecordAmtEntryIds = new HashSet<Long>(16);
    private List<Object[]> costRecordDetailUpdateParams = new ArrayList<Object[]>(16);
    private List<Object[]> costRecordDetailUnitCostUpdateParams = new ArrayList<Object[]>(16);
    private List<Object[]> costRecordEntryCostUpdateParams = new ArrayList<Object[]>(16);
    private List<Object[]> costRecordEntryUnitCostUpdateParams = new ArrayList<Object[]>(16);
    private List<DynamicObject> feeShareDetails = new ArrayList<DynamicObject>(16);
    private List<Object[]> insertEstFeeShareDetailParams = new ArrayList<Object[]>(16);
    private List<Object[]> costRecordTotalFeeParams = new ArrayList<Object[]>(16);
    private Set<Long> costRecordTotalFeeIds = new HashSet<Long>(16);
    private List<Object[]> costRecordCostPriceSourceUpdateParams = new ArrayList<Object[]>(16);
    private DBRoute calRoute = new DBRoute("cal");
    private static final String COSTRECORD_TOTALFEE_UPDATESQL = "update t_cal_calcostrecordentry set ftotalsharefee = ftotalsharefee + ?,fisallocate = '1'  where fentryid = ?";
    private static final String COSTRECORD_DETAIL_UPDATESQL = "update t_cal_costrecord_detail set factualcost = factualcost + ?   where fentryid = ? and fcostsubelementid = ?";
    private static final String COSTRECORD_DETAILUNITCOST_UPDATESQL = "update t_cal_costrecord_detail set funitactualcost = factualcost/fbaseqty where fentryid = ? and fcostsubelementid = ?";
    private static final String COSTRECORD_ENTRY_UPDATESQL = "update t_cal_calcostrecordentry set factualcost = factualcost+?, fmaterialcost=fmaterialcost+?, ffee=ffee+?, fprocesscost=fprocesscost+?, fcostpricesource = ?,fdesignatedcost = ?  where fentryid = ?";
    private static final String COSTRECORD_ENTRYUNITCOST_UPDATESQL = "update t_cal_calcostrecordentry set funitactualcost = factualcost/fbaseqty,funitmaterialcost = fmaterialcost/fbaseqty,funitfee=ffee/fbaseqty,funitprocesscost=fprocesscost/fbaseqty where fentryid = ?";
    private static final String COSTRECORD_ESTFEEDETAIL_INSERT = "insert into t_cal_esbilldetailentry(fdetailid,fentryid,festimatebillid,fsharedetailexitemid,fexitemseq,fsharedetailatype,fsharedetailasstactid,fsharedetailamt,fsharedetailamount)values(?,?,?,?,?,?,?,?,?)";
    private IDGenerator esBillDetailIdGenerator = new IDGenerator("t_cal_esbilldetailentry");
    private IDGenerator stdBillEntryIdGenerator = new IDGenerator("t_cal_stdcostdiffentry");

    public FeeShareResultHolder(FeeShareConfigHelper feeShareConfigHelper) {
        this.feeShareConfigHelper = feeShareConfigHelper;
        this.isActualFeeShare = feeShareConfigHelper.isActualFeeShare();
    }

    public void saveToDB() {
        try (TXHandle h = TX.required();){
            try {
                this.saveToDB4CostAdjustBill(this.costAdjustBillMap.values(), "cal_costadjust_subentity");
                log.info("saveToDB4CostAdjustBill--end");
                this.saveToDB4CostAdjustBill(this.stdDiffBillMap.values(), "cal_stdcostdiffbill");
                log.info("saveToDB4StdDiffBill--end");
                if (!this.totalShareFeeRecords.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])this.totalShareFeeRecords.toArray(new DynamicObject[0]));
                    log.info("saveTotalShareFeeRecords--end");
                }
                this.saveToDB4CostRecord();
                log.info("saveToDB4CostRecord--end");
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Throwable)e);
                throw e;
            }
        }
    }

    private void saveToDB4CostRecord() {
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cal_calcostrecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, this.costRecordTotalFeeIds)});){
            if (!this.costRecordTotalFeeParams.isEmpty()) {
                DBUtil.sortUpdateParams(this.costRecordTotalFeeParams, (int[])new int[]{1});
                DB.executeBatch((DBRoute)this.calRoute, (String)COSTRECORD_TOTALFEE_UPDATESQL, this.costRecordTotalFeeParams);
            }
        }
        ctx = ShardingHintContext.createAndSet((String)"t_cal_calcostrecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, this.costRecordAmtUpdateIds)});
        var2_2 = null;
        try {
            if (!this.costRecordDetailUpdateParams.isEmpty()) {
                DBUtil.sortUpdateParams(this.costRecordDetailUpdateParams, (int[])new int[]{1, 2});
                DBUtil.sortUpdateParams(this.costRecordDetailUnitCostUpdateParams, (int[])new int[]{0, 1});
                DB.executeBatch((DBRoute)this.calRoute, (String)COSTRECORD_DETAIL_UPDATESQL, this.costRecordDetailUpdateParams);
                DB.executeBatch((DBRoute)this.calRoute, (String)COSTRECORD_DETAILUNITCOST_UPDATESQL, this.costRecordDetailUnitCostUpdateParams);
            }
            if (!this.needCalCostRecordAmtEntryIds.isEmpty()) {
                CostElementHelper.calCostRecordAllCost((Long[])this.needCalCostRecordAmtEntryIds.toArray(new Long[0]));
            }
            if (!this.costRecordCostPriceSourceUpdateParams.isEmpty()) {
                DB.executeBatch((DBRoute)this.calRoute, (String)CostPriceSourceTypeEnum.getCostpriceSourceSql(), this.costRecordCostPriceSourceUpdateParams);
            }
            if (!this.costRecordEntryCostUpdateParams.isEmpty()) {
                DBUtil.sortUpdateParams(this.costRecordEntryCostUpdateParams, (int[])new int[]{6});
                DB.executeBatch((DBRoute)this.calRoute, (String)COSTRECORD_ENTRY_UPDATESQL, this.costRecordEntryCostUpdateParams);
                DB.executeBatch((DBRoute)this.calRoute, (String)COSTRECORD_ENTRYUNITCOST_UPDATESQL, this.costRecordEntryUnitCostUpdateParams);
            }
            if (!this.insertEstFeeShareDetailParams.isEmpty()) {
                DB.executeBatch((DBRoute)this.calRoute, (String)COSTRECORD_ESTFEEDETAIL_INSERT, this.insertEstFeeShareDetailParams);
            }
            if (!this.feeShareDetails.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])this.feeShareDetails.toArray(new DynamicObject[0]));
            }
            if (!this.costRecordAmtUpdateIds.isEmpty()) {
                if (CalBalanceModelHelper.isNewBalance()) {
                    new BalanceOpInvoker().invokeCostRecordUpdateBalOp(this.costRecordAmtUpdateIds, BalanceSourceEnum.FEE_DIVIDE);
                } else {
                    BalanceCalculator calculator = new BalanceCalculator();
                    calculator.updateBalance4Others(this.costRecordAmtUpdateEntryIds.toArray(new Object[this.costRecordAmtUpdateEntryIds.size()]), BalanceSourceEnum.FEE_DIVIDE);
                }
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var2_2 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    private void saveToDB4CostAdjustBill(Collection<DynamicObject> values, String billEntity) {
        ArrayList<DynamicObject> costAdjustBills = new ArrayList<DynamicObject>(16);
        costAdjustBills.addAll(values);
        if (costAdjustBills.isEmpty()) {
            return;
        }
        List numbers = CodeRuleServiceHelper.getNumbers((String)billEntity, costAdjustBills);
        for (int i = 0; i < costAdjustBills.size(); ++i) {
            String billno = null;
            billno = numbers == null || StringUtils.isEmpty((String)((String)numbers.get(i))) ? String.valueOf(System.currentTimeMillis()) : (String)numbers.get(i);
            DynamicObject bill = (DynamicObject)costAdjustBills.get(i);
            bill.set("billno", (Object)billno);
        }
        int batchsize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.NEW_FEESHARE_ADJ_BATCHSIZE);
        Lists.partition(costAdjustBills, (int)batchsize).forEach(list -> {
            OperationResult result;
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            HashSet<Long> costAdjustIds = new HashSet<Long>(16);
            for (DynamicObject info : list) {
                costAdjustIds.add(info.getLong("id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            if ("cal_stdcostdiffbill".equals(billEntity)) {
                option.setVariableValue("CostAdjustDetailParms", SerializationUtils.toJsonString(this.stdDiffBillDetailParams));
            }
            if (!(result = OperationServiceHelper.executeOperate((String)"audit", (String)billEntity, (Object[])costAdjustIds.toArray(), (OperateOption)option)).isSuccess()) {
                StringBuilder errorInfo = new StringBuilder();
                errorInfo.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"FeeShareVerifyTask_11", (String)"fi-cal-business", (Object[])new Object[0]));
                List errors = result.getAllErrorOrValidateInfo();
                if (errors != null && !errors.isEmpty()) {
                    for (IOperateInfo error : errors) {
                        OperateInfo operror = (OperateInfo)error;
                        errorInfo.append(operror.getMessage());
                    }
                    errorInfo.append(result.getMessage());
                    throw new KDBizException(errorInfo.toString());
                }
            }
            if ("cal_costadjust_subentity".equals(billEntity)) {
                PrevCostAdjustProcessHelper prevCostAdjustProcessHelper = new PrevCostAdjustProcessHelper();
                prevCostAdjustProcessHelper.dealOutAdjustSet(costAdjustIds);
            }
        });
    }

    public void addFeeShareDetaiRecord(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, BigDecimal substractAmt, BigDecimal asstshareCost, long shareId) {
        DynamicObject recordDetailObj = BusinessDataServiceHelper.newDynamicObject((String)"cal_fee_sharedetail");
        DynamicObject asstParent = (DynamicObject)costRecordEntryRow.getParent();
        recordDetailObj.set("costaccount", (Object)asstParent.getLong("costaccount.id"));
        recordDetailObj.set("sharercdid", (Object)shareId);
        recordDetailObj.set("costrecordid", (Object)asstParent.getLong("id"));
        recordDetailObj.set("entryid", (Object)costRecordEntryRow.getLong("id"));
        recordDetailObj.set("expenseitem", (Object)mainEntryRow.getLong("expenseitem.id"));
        recordDetailObj.set("sharedetailcurrency", (Object)asstParent.getLong("localcurrency.id"));
        recordDetailObj.set("shareamount", (Object)substractAmt);
        recordDetailObj.set("realshareamount", (Object)asstshareCost);
        recordDetailObj.set("asstacttype", (Object)mainEntryRow.getString("asstacttype"));
        recordDetailObj.set("asstact", (Object)mainEntryRow.getLong("asstact.id"));
        this.feeShareDetails.add(recordDetailObj);
    }

    public void addCostRecordTotalFeeIsAllocateUpdateParams(BigDecimal asstshareCost, long asstBillEntryId, long headid) {
        Object[] recordParam = new Object[]{asstshareCost, asstBillEntryId};
        this.costRecordTotalFeeParams.add(recordParam);
        this.costRecordTotalFeeIds.add(headid);
    }

    public void addCostAdjustBill(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, BigDecimal asstshareCost, long shareId, String diffType, Map<Long, Integer> apBillEntryId2SeqMap, boolean isAdjustBusApBill) {
        BigDecimal adjustCost = asstshareCost;
        String asstBillId = costRecordEntryRow.get("id").toString();
        if (adjustCost.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject asstParentBill = (DynamicObject)costRecordEntryRow.getParent();
        Long custsupplierid = mainEntryRow.getLong("asstact.id");
        Long billtypeid = asstParentBill.getLong("billtype.id");
        Object costaccountid = asstParentBill.getDynamicObject("costaccount").getPkValue();
        String createtype = this.isActualFeeShare ? CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue() : (isAdjustBusApBill ? CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue() : CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
        StringBuilder key = new StringBuilder();
        key.append(custsupplierid);
        key.append(billtypeid);
        key.append(costaccountid);
        key.append((Object)createtype);
        key.append(diffType);
        key.append(shareId);
        if (this.isActualFeeShare) {
            Date date = this.feeShareConfigHelper.getMaxDateFromMainAsstBill(mainEntryRow, asstParentBill, "bookdate");
            key.append(date.getTime());
        } else {
            key.append(asstBillId);
        }
        DynamicObject costadjustBill = this.costAdjustBillMap.get(key.toString());
        if (costadjustBill == null) {
            costadjustBill = this.getCostAdjustBillHead(shareId, diffType, mainEntryRow, asstParentBill, createtype);
            this.costAdjustBillMap.put(key.toString(), costadjustBill);
        }
        this.createCostAdjustBillEntry(mainEntryRow, costRecordEntryRow, adjustCost, asstBillId, costadjustBill, apBillEntryId2SeqMap);
    }

    private void createCostAdjustBillEntry(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, BigDecimal adjustCost, String asstBillId, DynamicObject costadjustBill, Map<Long, Integer> apBillEntryId2SeqMap) {
        DynamicObject asstParentBill = (DynamicObject)costRecordEntryRow.getParent();
        DynamicObject entry = costadjustBill.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", (Object)asstParentBill.getDynamicObject("storageorgunit"));
        entry.set("material", (Object)costRecordEntryRow.getDynamicObject("material"));
        entry.set("lot", costRecordEntryRow.get("lot"));
        entry.set("adjustamt", (Object)adjustCost);
        entry.set("warehouse", (Object)costRecordEntryRow.getDynamicObject("warehouse"));
        entry.set("location", (Object)costRecordEntryRow.getDynamicObject("location"));
        entry.set("ownertype", (Object)costRecordEntryRow.getString("ownertype"));
        entry.set("owner", (Object)costRecordEntryRow.getDynamicObject("owner"));
        entry.set("ecostcenter", (Object)costRecordEntryRow.getDynamicObject("ecostcenter"));
        entry.set("assist", (Object)costRecordEntryRow.getDynamicObject("assist"));
        entry.set("invbilltype", (Object)asstParentBill.getDynamicObject("billtype"));
        entry.set("invbillid", (Object)asstParentBill.getLong("id"));
        entry.set("invtype", (Object)costRecordEntryRow.getDynamicObject("invtype"));
        entry.set("invstatus", (Object)costRecordEntryRow.getDynamicObject("invstatus"));
        entry.set("baseunit", (Object)costRecordEntryRow.getDynamicObject("baseunit"));
        entry.set("invbillentryid", (Object)asstBillId);
        entry.set("invbillnum", (Object)asstParentBill.getString("billno"));
        entry.set("inventryseq", (Object)costRecordEntryRow.getInt("seq"));
        entry.set("invbizentityobject", (Object)"cal_costrecord_subentity");
        entry.set("srcbilltype", (Object)mainEntryRow.getLong("billtypeid.id"));
        entry.set("srcbillnum", (Object)mainEntryRow.getString("billno"));
        entry.set("srcentryseq", (Object)apBillEntryId2SeqMap.get(mainEntryRow.getLong("billentryid")));
        entry.set("feeprojectid", (Object)mainEntryRow.getLong("expenseitem.id"));
        entry.set("srcbizentityobject", (Object)mainEntryRow.getString("billtype.id"));
        entry.set("srcbillId", (Object)mainEntryRow.getLong("billid"));
        entry.set("srcbillentryId", (Object)mainEntryRow.getLong("billentryid"));
        entry.set("mversion", (Object)costRecordEntryRow.getDynamicObject("mversion"));
        entry.set("project", (Object)costRecordEntryRow.getDynamicObject("project"));
        entry.set("tracknumber", costRecordEntryRow.get("tracknumber"));
        entry.set("configuredcode", costRecordEntryRow.get("configuredcode"));
        entry.set("productline", costRecordEntryRow.get("productline"));
        entry.set("noupdatecalfields", costRecordEntryRow.get("noupdatecalfields"));
        entry.set("stocktype", costRecordEntryRow.get("stocktype"));
        Long feeSubElementId = this.feeShareConfigHelper.getFeeSubElementId(costRecordEntryRow, mainEntryRow);
        if (this.feeShareConfigHelper.isCalByElement(costRecordEntryRow)) {
            List<Long[]> allCostElements = this.feeShareConfigHelper.getAllCostElements();
            for (Long[] allCostElement : allCostElements) {
                DynamicObject subEntryRow = entry.getDynamicObjectCollection("subentryentity").addNew();
                subEntryRow.set("costelement", (Object)allCostElement[1]);
                subEntryRow.set("costsubelement", (Object)allCostElement[0]);
                subEntryRow.set("sub_material", (Object)costRecordEntryRow.getDynamicObject("material"));
                subEntryRow.set("sub_currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
                if (feeSubElementId.compareTo(allCostElement[0]) == 0) {
                    subEntryRow.set("sub_adjustamt", (Object)adjustCost);
                    continue;
                }
                subEntryRow.set("sub_adjustamt", (Object)BigDecimal.ZERO);
            }
        } else {
            Long[] defaMaterialElements = this.feeShareConfigHelper.getDefaMaterialElements();
            DynamicObject subEntryRow = entry.getDynamicObjectCollection("subentryentity").addNew();
            subEntryRow.set("costelement", (Object)defaMaterialElements[1]);
            subEntryRow.set("costsubelement", (Object)defaMaterialElements[0]);
            subEntryRow.set("sub_material", (Object)costRecordEntryRow.getDynamicObject("material"));
            subEntryRow.set("sub_currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
            subEntryRow.set("sub_adjustamt", (Object)adjustCost);
        }
    }

    private DynamicObject getCostAdjustBillHead(long shareId, String diffType, DynamicObject mainEntryRow, DynamicObject asstParentBill, Object createtype) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustBill.set("cstype", mainEntryRow.get("asstacttype"));
        costAdjustBill.set("custsupplier", (Object)mainEntryRow.getDynamicObject("asstact"));
        costAdjustBill.set("currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
        costAdjustBill.set("bizdate", (Object)this.feeShareConfigHelper.getMaxDateFromMainAsstBill(mainEntryRow, asstParentBill, "bizdate"));
        costAdjustBill.set("bookdate", (Object)this.feeShareConfigHelper.getMaxDateFromMainAsstBill(mainEntryRow, asstParentBill, "bookdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("billtype", (Object)asstParentBill.getDynamicObject("billtype"));
        costAdjustBill.set("difftype", (Object)diffType);
        costAdjustBill.set("createtype", createtype);
        costAdjustBill.set("costaccount", (Object)asstParentBill.getDynamicObject("costaccount"));
        costAdjustBill.set("calorg", (Object)asstParentBill.getDynamicObject("calorg"));
        costAdjustBill.set("adminorg", (Object)asstParentBill.getDynamicObject("adminorg"));
        costAdjustBill.set("feeshareflag", (Object)shareId);
        costAdjustBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        costAdjustBill.set("createtime", (Object)new Date());
        costAdjustBill.set("modifytime", (Object)new Date());
        costAdjustBill.set("modifier", (Object)RequestContext.get().getUserId());
        return costAdjustBill;
    }

    public void addStdDiffBill(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, BigDecimal asstshareCost, long shareId, String diffType, Map<Long, Integer> apBillEntryId2SeqMap, boolean isAdjustBusApBill) {
        BigDecimal adjustCost = asstshareCost;
        String asstBillId = costRecordEntryRow.get("id").toString();
        if (adjustCost.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject asstParentBill = (DynamicObject)costRecordEntryRow.getParent();
        Long custsupplierid = mainEntryRow.getLong("asstact.id");
        Long billtypeid = asstParentBill.getLong("billtype.id");
        Object costaccountid = asstParentBill.getDynamicObject("costaccount").getPkValue();
        String createtype = this.isActualFeeShare ? CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue() : (isAdjustBusApBill ? CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue() : CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
        StringBuilder key = new StringBuilder();
        key.append(custsupplierid);
        key.append(billtypeid);
        key.append(costaccountid);
        key.append((Object)createtype);
        key.append(diffType);
        key.append(shareId);
        if (this.isActualFeeShare) {
            Date date = this.feeShareConfigHelper.getMaxDateFromMainAsstBill(mainEntryRow, asstParentBill, "bookdate");
            key.append(date.getTime());
        } else {
            key.append(asstBillId);
        }
        DynamicObject costadjustBill = this.stdDiffBillMap.get(key.toString());
        if (costadjustBill == null) {
            costadjustBill = this.getStdDiffBillHead(shareId, diffType, mainEntryRow, asstParentBill, createtype);
            this.stdDiffBillMap.put(key.toString(), costadjustBill);
        }
        this.createStdDiffBillEntry(mainEntryRow, costRecordEntryRow, adjustCost, asstBillId, costadjustBill, apBillEntryId2SeqMap);
    }

    private void createStdDiffBillEntry(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, BigDecimal adjustCost, String asstBillId, DynamicObject costadjustBill, Map<Long, Integer> apBillEntryId2SeqMap) {
        DynamicObject asstParentBill = (DynamicObject)costRecordEntryRow.getParent();
        DynamicObject entry = costadjustBill.getDynamicObjectCollection("entryentity").addNew();
        Long entryid = this.stdBillEntryIdGenerator.getId();
        entry.set("id", (Object)entryid);
        entry.set("storageorgunit", (Object)asstParentBill.getDynamicObject("storageorgunit"));
        entry.set("material", (Object)costRecordEntryRow.getDynamicObject("material"));
        entry.set("lot", costRecordEntryRow.get("lot"));
        entry.set("adjustamt", (Object)adjustCost);
        entry.set("diff_k", (Object)adjustCost);
        entry.set("warehouse", (Object)costRecordEntryRow.getDynamicObject("warehouse"));
        entry.set("location", (Object)costRecordEntryRow.getDynamicObject("location"));
        entry.set("ownertype", (Object)costRecordEntryRow.getString("ownertype"));
        entry.set("owner", (Object)costRecordEntryRow.getDynamicObject("owner"));
        entry.set("ecostcenter", (Object)costRecordEntryRow.getDynamicObject("ecostcenter"));
        entry.set("assist", (Object)costRecordEntryRow.getDynamicObject("assist"));
        entry.set("invbilltype", (Object)asstParentBill.getDynamicObject("billtype"));
        entry.set("invbillid", (Object)asstParentBill.getLong("id"));
        entry.set("invtype", (Object)costRecordEntryRow.getDynamicObject("invtype"));
        entry.set("invstatus", (Object)costRecordEntryRow.getDynamicObject("invstatus"));
        entry.set("baseunit", (Object)costRecordEntryRow.getDynamicObject("baseunit"));
        entry.set("invbillentryid", (Object)asstBillId);
        entry.set("invbillnum", (Object)asstParentBill.getString("billno"));
        entry.set("inventryseq", (Object)costRecordEntryRow.getInt("seq"));
        entry.set("invbizentityobject", (Object)"cal_costrecord_subentity");
        entry.set("srcbilltype", (Object)mainEntryRow.getLong("billtypeid.id"));
        entry.set("srcbillnum", (Object)mainEntryRow.getString("billno"));
        entry.set("srcentryseq", (Object)apBillEntryId2SeqMap.get(mainEntryRow.getLong("billentryid")));
        entry.set("feeprojectid", (Object)mainEntryRow.getLong("expenseitem.id"));
        entry.set("srcbizentityobject", (Object)mainEntryRow.getString("billtype.id"));
        entry.set("srcbillId", (Object)mainEntryRow.getLong("billid"));
        entry.set("srcbillentryId", (Object)mainEntryRow.getLong("billentryid"));
        entry.set("mversion", (Object)costRecordEntryRow.getDynamicObject("mversion"));
        entry.set("project", (Object)costRecordEntryRow.getDynamicObject("project"));
        entry.set("tracknumber", costRecordEntryRow.get("tracknumber"));
        entry.set("configuredcode", costRecordEntryRow.get("configuredcode"));
        entry.set("productline", costRecordEntryRow.get("productline"));
        entry.set("noupdatecalfields", costRecordEntryRow.get("noupdatecalfields"));
        entry.set("stocktype", costRecordEntryRow.get("stocktype"));
        Long feeSubElementId = this.feeShareConfigHelper.getFeeSubElementId(costRecordEntryRow, mainEntryRow);
        if (this.feeShareConfigHelper.isCalByElement(costRecordEntryRow)) {
            List<Long[]> allCostElements = this.feeShareConfigHelper.getAllCostElements();
            for (Long[] allCostElement : allCostElements) {
                if (feeSubElementId.compareTo(allCostElement[0]) == 0) {
                    this.stdDiffBillDetailParams.add(new CostAdjustDetailParams((Object)entryid, (Object)allCostElement[1], (Object)allCostElement[0], adjustCost, BigDecimal.ZERO, BigDecimal.ZERO, adjustCost, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                    continue;
                }
                this.stdDiffBillDetailParams.add(new CostAdjustDetailParams((Object)entryid, (Object)allCostElement[1], (Object)allCostElement[0], BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
            }
        } else {
            Long[] defaMaterialElements = this.feeShareConfigHelper.getDefaMaterialElements();
            this.stdDiffBillDetailParams.add(new CostAdjustDetailParams((Object)entryid, (Object)defaMaterialElements[1], (Object)defaMaterialElements[0], adjustCost, BigDecimal.ZERO, BigDecimal.ZERO, adjustCost, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
        }
    }

    private DynamicObject getStdDiffBillHead(long shareId, String diffType, DynamicObject mainEntryRow, DynamicObject asstParentBill, Object createtype) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        costAdjustBill.set("cstype", mainEntryRow.get("asstacttype"));
        costAdjustBill.set("custsupplier", (Object)mainEntryRow.getDynamicObject("asstact"));
        costAdjustBill.set("currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
        costAdjustBill.set("bizdate", (Object)this.feeShareConfigHelper.getMaxDateFromMainAsstBill(mainEntryRow, asstParentBill, "bizdate"));
        costAdjustBill.set("bookdate", (Object)this.feeShareConfigHelper.getMaxDateFromMainAsstBill(mainEntryRow, asstParentBill, "bookdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("billtype", (Object)asstParentBill.getDynamicObject("billtype"));
        costAdjustBill.set("createtype", createtype);
        costAdjustBill.set("costaccount", (Object)asstParentBill.getDynamicObject("costaccount"));
        costAdjustBill.set("calorg", (Object)asstParentBill.getDynamicObject("calorg"));
        costAdjustBill.set("adminorg", (Object)asstParentBill.getDynamicObject("adminorg"));
        costAdjustBill.set("feeshareflag", (Object)shareId);
        costAdjustBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        costAdjustBill.set("createtime", (Object)new Date());
        costAdjustBill.set("modifytime", (Object)new Date());
        costAdjustBill.set("modifier", (Object)RequestContext.get().getUserId());
        return costAdjustBill;
    }

    public void addTotalShareFeeRecord(long shareId, long asstBillId, BigDecimal shareBillAmount) {
        DynamicObject totalShareFee = BusinessDataServiceHelper.newDynamicObject((String)"cal_fee_totalsharefee");
        totalShareFee.set("feeshareid", (Object)shareId);
        totalShareFee.set("costrecordentryid", (Object)asstBillId);
        totalShareFee.set("totalfee", (Object)shareBillAmount);
        this.totalShareFeeRecords.add(totalShareFee);
    }

    public void addCostRecordAmtUpdateParams(DynamicObject costRecordEntryRow, BigDecimal substractAmt, DynamicObject mainEntryRow) {
        DynamicObject asstBillParent = (DynamicObject)costRecordEntryRow.getParent();
        Long costRecordId = asstBillParent.getLong("id");
        Long costRecordEntryId = costRecordEntryRow.getLong("id");
        Long expenseItemId = mainEntryRow.getLong("expenseitem.id");
        String costpricesource = costRecordEntryRow.getString("costpricesource");
        String designated = "0";
        if (this.isActualFeeShare) {
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costpricesource, (String)CostPriceSourceTypeEnum.FEE_SHARE_SPECIFICATION.getValue());
            designated = CostPriceSourceTypeEnum.FEE_SHARE_SPECIFICATION.getDesignated();
        } else {
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costpricesource, (String)CostPriceSourceTypeEnum.FEE_TEMP_SPECIFICATION.getValue());
            designated = CostPriceSourceTypeEnum.FEE_TEMP_SPECIFICATION.getDesignated();
        }
        Long subElementId = this.feeShareConfigHelper.getFeeSubElementId(costRecordEntryRow, mainEntryRow);
        this.costRecordDetailUpdateParams.add(new Object[]{substractAmt, costRecordEntryId, subElementId});
        this.costRecordDetailUnitCostUpdateParams.add(new Object[]{costRecordEntryId, subElementId});
        this.costRecordAmtUpdateIds.add(costRecordId);
        this.costRecordAmtUpdateEntryIds.add(costRecordEntryId);
        if (this.feeShareConfigHelper.isCalByElement(costRecordEntryRow)) {
            this.needCalCostRecordAmtEntryIds.add(costRecordEntryId);
            this.costRecordCostPriceSourceUpdateParams.add(new Object[]{costpricesource, designated, costRecordEntryId});
        } else {
            if (expenseItemId == null || expenseItemId == 0L) {
                String bizentityobject = asstBillParent.getString("bizentityobject.id");
                if ("im_mdc_ominbill".equals(bizentityobject) || "im_ospurinbill".equals(bizentityobject)) {
                    this.costRecordEntryCostUpdateParams.add(new Object[]{substractAmt, BigDecimal.ZERO, BigDecimal.ZERO, substractAmt, costpricesource, designated, costRecordEntryId});
                } else {
                    this.costRecordEntryCostUpdateParams.add(new Object[]{substractAmt, substractAmt, BigDecimal.ZERO, BigDecimal.ZERO, costpricesource, designated, costRecordEntryId});
                }
            } else {
                this.costRecordEntryCostUpdateParams.add(new Object[]{substractAmt, BigDecimal.ZERO, substractAmt, BigDecimal.ZERO, costpricesource, designated, costRecordEntryId});
            }
            this.costRecordEntryUnitCostUpdateParams.add(new Object[]{costRecordEntryId});
        }
    }

    public void addEstFeeShareDetaiRecord(DynamicObject mainEntryRow, DynamicObject costRecordEntryRow, BigDecimal shareBillAmount, BigDecimal shareBaseAmount, long shareId, Map<Long, Integer> apBillEntryId2SeqMap) {
        Long expenseItemId = mainEntryRow.getLong("expenseitem.id");
        Integer exitemseq = apBillEntryId2SeqMap.get(mainEntryRow.getLong("billentryid"));
        String asstacttype = mainEntryRow.getString("asstacttype");
        Long asstact = mainEntryRow.getLong("asstact.id");
        Long entryid = costRecordEntryRow.getLong("id");
        this.insertEstFeeShareDetailParams.add(new Object[]{this.esBillDetailIdGenerator.getId(), entryid, shareId, expenseItemId, exitemseq, asstacttype, asstact, shareBillAmount, shareBaseAmount});
    }
}

