/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.in;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.common.helper.CostRecordQFilterHelper;

public class FeeshareVerifyHelper {
    public Map<String, Object> doFeeShare(Map<String, Object> params) {
        Map<String, Object> jobParams = this.resolveParams(params);
        this.dispatchJob(jobParams);
        return null;
    }

    private void dispatchJob(Map<String, Object> jobParams) {
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a,\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s", (String)"FeeshareVerifyHelper_2", (String)"fi-cal-business", (Object[])new Object[0]), jobParams.get("calorgnum"));
        job.setName(OpName);
        job.setTaskDefineId("2TEE+G+UFBFB");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.FeeShareVerifyTask");
        JobClient.dispatch((JobInfo)job);
    }

    private Map<String, Object> resolveParams(Map<String, Object> params) {
        List mainBillIds = (List)params.get("mainbillids");
        List mainBillEntryIds = (List)params.get("mainbillentryids");
        Object[] mainSetArray = new Object[]{mainBillIds, mainBillEntryIds};
        QFilter AsstQFilter = this.getAsstQfilter(params);
        Object[] asst = this.getAsstCalBillEntryIds(AsstQFilter);
        Object[] asstCalBillEntryids = new Object[]{asst[0]};
        Long[] assbizbillids = (Long[])asst[1];
        Object matchCondition = params.get("matchcondition");
        Long calorgid = (Long)params.get("calorg");
        String calorgnum = (String)params.get("calorgnum");
        Date shareDate = TimeServiceHelper.now();
        Object shareStandard = params.get("sharestandard");
        DynamicObject calpolicy = this.getMainCostAccounCalPolicy(calorgid);
        if (calpolicy == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FeeshareVerifyHelper_3", (String)"fi-cal-business", (Object[])new Object[0]), new Object[0]);
            throw new KDBizException(errorMsg);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmsss");
        long shareNum = Long.parseLong(simpleDateFormat.format(new Date()));
        HashMap<String, Object> jobParams = new HashMap<String, Object>(16);
        jobParams.put("mainSetArray", SerializationUtils.toJsonString((Object)mainSetArray));
        jobParams.put("asstSetArray", SerializationUtils.toJsonString((Object)asstCalBillEntryids));
        jobParams.put("asstbizbillids", SerializationUtils.toJsonString((Object)assbizbillids));
        jobParams.put("matchingcondition", matchCondition);
        jobParams.put("shareNum", SerializationUtils.toJsonString((Object)shareNum));
        jobParams.put("asstQfilter", AsstQFilter.toSerializedString());
        jobParams.put("CALORG", SerializationUtils.toJsonString((Object)calorgid));
        jobParams.put("exratetable", SerializationUtils.toJsonString((Object)calpolicy.getDynamicObject("exratetable").getLong("id")));
        jobParams.put("sharestandard", shareStandard);
        String shareDateStr = new SimpleDateFormat("yyyy-MM-dd").format(shareDate);
        jobParams.put("sharedate", shareDateStr);
        jobParams.put("sharecurrency", SerializationUtils.toJsonString((Object)calpolicy.getDynamicObject("currency").getLong("id")));
        jobParams.put("calorgnum", calorgnum);
        return jobParams;
    }

    private DynamicObject getMainCostAccounCalPolicy(Long orgId) {
        DynamicObject init = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{new QFilter("calorg", "=", (Object)orgId).and("ismainaccount", "=", (Object)"1")});
        if (init == null || init.get("calpolicy") == null) {
            return null;
        }
        return init.getDynamicObject("calpolicy");
    }

    private Object[] getAsstCalBillEntryIds(QFilter asstQFilter) {
        QFilter filter = new QFilter("costaccount.ismainaccount", "=", (Object)"1");
        filter.and("costaccount.enable", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("ischargeoffed", "!=", (Object)"1");
        filter.and("ischargeoff", "!=", (Object)"1");
        filter.and(asstQFilter);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass() + "costRecordDataSet"), (String)"cal_costrecord", (String)"bizbillid,entry.calentryid", (QFilter[])filter.toArray(), null);){
            ArrayList<Long> calentryids = new ArrayList<Long>(16);
            HashSet<Long> bizbillids = new HashSet<Long>(16);
            for (Row row : dataSet) {
                calentryids.add(row.getLong("entry.calentryid"));
                bizbillids.add(row.getLong("bizbillid"));
            }
            Object[] objectArray = new Object[]{calentryids, bizbillids.toArray(new Long[0])};
            return objectArray;
        }
    }

    private QFilter getAsstQfilter(Map<String, Object> params) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add((QFilter)params.get("asstqfilter"));
        filters.add(new QFilter("issplitcreate", "=", (Object)"0"));
        filters.add(new QFilter("calbilltype", "=", (Object)"IN"));
        filters.add(new QFilter("entry.ispresent", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("calorg", "=", params.get("calorg")));
        List expenseBillTypes = CostRecordQFilterHelper.getMatchBilltype((String)"expensebilltype");
        filters.add(new QFilter("billtype", "in", (Object)expenseBillTypes));
        List<String> entityObjectList = this.getEntityOBj(expenseBillTypes);
        filters.add(new QFilter("bizentityobject.number", "in", entityObjectList));
        QFilter cacheFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        for (QFilter filter : filters) {
            cacheFilter.and(filter);
        }
        return cacheFilter;
    }

    private List<String> getEntityOBj(List<Long> expenseBillTypes) {
        ArrayList<String> expenseBills = new ArrayList<String>();
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)"bos_billtype", (String)"id,number,billformid", (QFilter[])new QFilter("id", "in", expenseBillTypes).toArray());
        for (DynamicObject dynamicObject : billTypes) {
            expenseBills.add(dynamicObject.getString("billformid"));
        }
        return expenseBills;
    }
}

