/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.out.FiFoBalInfo;
import kd.fi.cal.business.calculate.out.FiFoBillInfo;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.IDGenerator;

public class CalInTimeFifoRptHolder {
    private final Boolean fifoZeroAppendRpt = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.FIFO_ZERO_APPEND_RPT);
    private Map<Object, DynamicObject> rptCacheMap = new HashMap<Object, DynamicObject>(16);
    private Map<Long, Integer> rptIdNextSeqDbMap = new HashMap<Long, Integer>(16);
    private Map<Long, Long> rptIdPeriodDbMap = new HashMap<Long, Long>(16);
    private IDGenerator idGenerator = new IDGenerator("t_cal_caloutrpt");
    private final IDGenerator entryIdGenerator = new IDGenerator("t_cal_caloutrptentry");
    private Map<String, DynamicObject> rptMap = new HashMap<String, DynamicObject>();
    private static final String insertSql = "insert into t_cal_caloutrpt(FID,FCOSTACCOUNTID,FDIVIDEBASISID,FCALDIMENSIONID,FDIVIDEBASISVALUE,FCALDIMENSIONVALUE,FMATERIALID,FACCOUNTTYPE,FPERIODID,FCALTIME,FCALSTATUS,FNEXTSEQ,FCALORGID,FCALRANGEID,foperationuserid,fassistid,fconfiguredcodeid,fprojectid,ftracknumberid) values (?,?,?,?,?,?,?,?,?,?,?,        ?,?,?,?,?,?,?,?)";
    private static final String insertEntrySql = "insert into t_cal_caloutrptentry(FID,FENTRYID,FSEQ,FBIZBILLID,FBIZBILLENTRYID,FBILLTYPENUM,FBILLTYPE,FBILLNUMBER,FINSTR,FOUTSTR,FBALANCESTR,FPARENTENTRYID,FBIZDATE,FAUDITDATE,FDESCRIBE) values (?,?,?,?,?,?,?,?,?,?,?,        ?,?,?,?)";
    private static final String updateSql = "update t_cal_caloutrpt set FNEXTSEQ = ?,fcaltime = ?,foperationuserid = ?, fdividebasisid = ?, fdividebasisvalue = ?, fcaldimensionid = ?, fcaldimensionvalue= ?, fassistid=?, fconfiguredcodeid=?, fprojectid=?,ftracknumberid=? where fid = ?";
    private Long calOrgId;
    private long curPeriodId;
    private Map<String, Boolean> fieldIsBaseDateMap;
    private String entityName;
    private String opType;
    private static final char innerSplit = '_';
    private final Map<Long, String> subEleIdNameMap = new HashMap<Long, String>(16);

    public CalInTimeFifoRptHolder() {
        this.cacheSubEleIdNameMap();
    }

    public void createEmptyRptDycs(Set<Long> rptIdSet) {
        for (Long rptId : rptIdSet) {
            if (rptId == null || rptId.equals(0L)) continue;
            DynamicObject rptDyc = BusinessDataServiceHelper.newDynamicObject((String)"cal_calculateoutrpt");
            rptDyc.set("id", (Object)rptId);
            this.rptCacheMap.put(rptId, rptDyc);
            rptDyc.getDataEntityState().setFromDatabase(true);
        }
        Set<Object> rptIds = this.rptCacheMap.keySet();
        QFilter calRptIdsFilter = new QFilter("id", "in", rptIds);
        try (DataSet rptDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calculateoutrpt", (String)"id,nextseq,period", (QFilter[])new QFilter[]{calRptIdsFilter}, null);){
            for (Row rptD : rptDs) {
                this.rptIdNextSeqDbMap.put(rptD.getLong("id"), rptD.getInteger("nextseq"));
                this.rptIdPeriodDbMap.put(rptD.getLong("id"), rptD.getLong("period"));
            }
        }
    }

    public void writeRptBySql() {
        ArrayList<Object[]> headParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(this.rptMap.size());
        ArrayList<Object[]> headUpdateParams = new ArrayList<Object[]>(16);
        HashSet<Long> costaccountIds = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        periods.addAll(this.rptIdPeriodDbMap.values());
        for (Map.Entry<String, DynamicObject> entry : this.rptMap.entrySet()) {
            DynamicObject caloutRptInfo = entry.getValue();
            DynamicObjectCollection rptEntryInfos = caloutRptInfo.getDynamicObjectCollection("entryentity");
            Long id = caloutRptInfo.getLong("id");
            int nextSeq = 0;
            for (DynamicObject rptEntryInfo : rptEntryInfos) {
                costaccountIds.add(caloutRptInfo.getLong("costaccount"));
                periods.add(caloutRptInfo.getLong("period"));
                Object[] entryParam = new Object[15];
                entryParam[0] = id;
                entryParam[1] = this.entryIdGenerator.getId();
                nextSeq = rptEntryInfo.getInt("seq");
                entryParam[2] = nextSeq;
                entryParam[3] = rptEntryInfo.getLong("bizbillid");
                entryParam[4] = rptEntryInfo.getLong("bizbillentryid");
                entryParam[5] = rptEntryInfo.getString("billtypenum");
                entryParam[6] = rptEntryInfo.getString("billtype");
                entryParam[7] = rptEntryInfo.getString("billnumber");
                entryParam[8] = rptEntryInfo.getString("instr");
                entryParam[9] = rptEntryInfo.getString("outstr");
                entryParam[10] = rptEntryInfo.getString("balancestr");
                entryParam[11] = rptEntryInfo.getLong("parententryid");
                Date bizDate = rptEntryInfo.getDate("bizdate");
                entryParam[12] = new Timestamp(bizDate.getTime());
                Date auditDate = rptEntryInfo.getDate("auditdate");
                entryParam[13] = new Timestamp(auditDate.getTime());
                entryParam[14] = rptEntryInfo.getString("describe");
                entryParams.add(entryParam);
            }
            if (!entry.getValue().getDataEntityState().getFromDatabase()) {
                Object[] headParam = new Object[]{id, caloutRptInfo.getLong("costaccount"), caloutRptInfo.getLong("dividebasis"), caloutRptInfo.getLong("caldimension"), caloutRptInfo.getString("dividebasisvalue"), caloutRptInfo.getString("caldimensionValue"), caloutRptInfo.getLong("material"), caloutRptInfo.getString("accounttype"), caloutRptInfo.getLong("period"), caloutRptInfo.getDate("caltime"), caloutRptInfo.getString("calstatus"), nextSeq + 1, caloutRptInfo.getLong("calorg"), caloutRptInfo.getLong("calrange"), caloutRptInfo.getLong("operationuser"), caloutRptInfo.getLong("assist"), caloutRptInfo.getLong("configuredcode"), caloutRptInfo.getLong("project"), caloutRptInfo.getLong("tracknumber")};
                headParams.add(headParam);
                continue;
            }
            Object[] headUpdateParam = new Object[]{nextSeq + 1, new Timestamp(TimeServiceHelper.now().getTime()), caloutRptInfo.get("operationuser"), caloutRptInfo.get("dividebasis"), caloutRptInfo.get("dividebasisvalue"), caloutRptInfo.get("caldimension"), caloutRptInfo.get("caldimensionvalue"), caloutRptInfo.getLong("assist"), caloutRptInfo.getLong("configuredcode"), caloutRptInfo.getLong("project"), caloutRptInfo.getLong("tracknumber"), id};
            headUpdateParams.add(headUpdateParam);
        }
        DBRoute dbRoute = new DBRoute("cal");
        if (!headParams.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, headParams);
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_caloutrpt", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("FCOSTACCOUNTID", FilterType.in_range, costaccountIds), new ShardingHintContext.ShardingHintCondition("FPERIODID", FilterType.in_range, periods)});){
            ctx.set();
            if (!entryParams.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertEntrySql, entryParams);
            }
        }
        if (!headUpdateParams.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, headUpdateParams);
        }
    }

    public Map<String, DynamicObject> getRptMap() {
        return this.rptMap;
    }

    public int getCurrSeq(DynamicObject rptInfoDyc) {
        boolean isFromDataBase;
        long calRptId = rptInfoDyc.getLong("id");
        int nextSeq = rptInfoDyc.getInt("nextSeq");
        boolean bl = isFromDataBase = calRptId != 0L && rptInfoDyc.getDataEntityState().getFromDatabase();
        if (isFromDataBase && nextSeq <= 1) {
            Integer nextSeqDb = this.rptIdNextSeqDbMap.get(calRptId);
            if (nextSeqDb != null) {
                nextSeq = nextSeqDb;
            } else {
                rptInfoDyc.set("id", (Object)DB.genLongId((String)"t_cal_caloutrpt"));
                rptInfoDyc.getDataEntityState().setFromDatabase(false);
            }
        }
        if (nextSeq <= 1) {
            nextSeq = 1;
        }
        rptInfoDyc.set("nextSeq", (Object)nextSeq);
        return nextSeq;
    }

    public void updateRptHeadInfo(DynamicObject rptInfo, boolean isEmptyRange, Row row) {
        long costaccount = row.getLong("costaccount");
        long material = row.getLong("material");
        long dividebasisid = row.getLong("dividebasis");
        long caldimensionid = row.getLong("caldimension");
        long calRangeId = row.getLong("calrange");
        String dividebasisStr = row.getString("dividebasisstr");
        String caldimensionStr = row.getString("caldimensionstr");
        String divideBasisValue = "";
        StringBuilder divideBasisValueSB = new StringBuilder();
        String caldimensionValue = "";
        StringBuilder caldimensionValueSB = new StringBuilder();
        if (StringUtils.isNotEmpty((String)dividebasisStr)) {
            for (String s : dividebasisStr.split(",")) {
                String value = row.get(s).toString();
                if (value.trim().isEmpty()) {
                    value = "#";
                }
                divideBasisValueSB.append(value).append('_');
            }
            divideBasisValue = divideBasisValueSB.substring(0, divideBasisValueSB.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)caldimensionStr)) {
            for (String s : caldimensionStr.split(",")) {
                Object valueObj = row.get(s);
                if (valueObj == null) continue;
                String value = String.valueOf(valueObj);
                if ("assist".equals(s)) {
                    rptInfo.set(s, (Object)value);
                } else if ("configuredcode".equals(s)) {
                    rptInfo.set(s, (Object)value);
                } else if ("project".equals(s)) {
                    rptInfo.set(s, (Object)value);
                } else if ("tracknumber".equals(s)) {
                    rptInfo.set(s, (Object)value);
                }
                if (value.trim().isEmpty()) {
                    value = "#";
                }
                caldimensionValueSB.append(value).append('_');
            }
            if (caldimensionValueSB.length() > 0) {
                caldimensionValue = caldimensionValueSB.substring(0, caldimensionValueSB.length() - 1);
            }
        }
        if (isEmptyRange) {
            rptInfo.set("dividebasisvalue", (Object)divideBasisValue);
        }
        rptInfo.set("caldimensionvalue", (Object)caldimensionValue);
        rptInfo.set("caltime", (Object)TimeServiceHelper.now());
        rptInfo.set("operationuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        if (rptInfo.get("material") == null || rptInfo.get("material").equals(0L)) {
            rptInfo.set("costaccount", (Object)costaccount);
            rptInfo.set("calorg", (Object)this.calOrgId);
            rptInfo.set("material", (Object)material);
            rptInfo.set("dividebasis", (Object)dividebasisid);
            rptInfo.set("caldimension", (Object)caldimensionid);
            rptInfo.set("accounttype", (Object)AccountTypeEnum.FIN_FOUT.getValue());
            rptInfo.set("calstatus", (Object)"A");
            rptInfo.set("period", (Object)this.curPeriodId);
            rptInfo.set("calrange", (Object)calRangeId);
        }
    }

    public DynamicObject createNewRpt() {
        DynamicObject rptInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_calculateoutrpt");
        rptInfo.set("id", (Object)this.idGenerator.getId());
        return rptInfo;
    }

    public void setCalOrgId(Long calOrgId) {
        this.calOrgId = calOrgId;
    }

    public void setCurPeriodId(long curPeriodId) {
        this.curPeriodId = curPeriodId;
    }

    public void createOrUpdateRpt(long calrptid, String key, String[] onFields, Row row, boolean isEmptyRange) {
        long costAccountId = row.getLong("costaccount");
        if (!this.rptCacheMap.containsKey(calrptid) && !this.rptMap.containsKey(key)) {
            DynamicObject rptInfo = null;
            if (this.fifoZeroAppendRpt.booleanValue()) {
                rptInfo = this.getZeroBalRptInfo(key, onFields, costAccountId);
                this.updateRptHeadInfo(rptInfo, isEmptyRange, row);
            }
            if (rptInfo == null) {
                rptInfo = this.createNewRpt();
                this.updateRptHeadInfo(rptInfo, isEmptyRange, row);
                this.rptMap.put(key, rptInfo);
            }
        } else {
            DynamicObject rptInfo = this.rptCacheMap.get(calrptid);
            if (rptInfo == null) {
                rptInfo = this.rptMap.get(key);
            }
            if (rptInfo != null) {
                this.updateRptHeadInfo(rptInfo, isEmptyRange, row);
                this.rptMap.put(key, rptInfo);
            }
        }
    }

    private DynamicObject getZeroBalRptInfo(String key, String[] onFields, long costAccountId) {
        DynamicObjectCollection rptColl;
        DynamicObject rptInfo = null;
        String[] keys = key.split(",");
        QFilter q = new QFilter("material", "=", (Object)Long.valueOf(keys[0]));
        q.and("costaccount", "=", (Object)costAccountId);
        for (int i = 0; i < onFields.length; ++i) {
            boolean isBaseDate;
            if ("costelement".equals(onFields[i]) || "costsubelement".equals(onFields[i])) continue;
            Boolean fieldIsBaseDate = this.fieldIsBaseDateMap.get(onFields[i]);
            boolean bl = isBaseDate = fieldIsBaseDate == null ? false : fieldIsBaseDate;
            if (isBaseDate) {
                q.and(onFields[i], "=", (Object)Long.valueOf(keys[i + 1]));
                continue;
            }
            q.and(onFields[i], "=", (Object)keys[i + 1]);
        }
        DynamicObjectCollection balColl = QueryServiceHelper.query((String)"cal_balance_fifo", (String)"calrptid", (QFilter[])q.toArray());
        HashSet<Long> balIdSet = new HashSet<Long>(balColl.size());
        for (DynamicObject balInfo : balColl) {
            balIdSet.add(balInfo.getLong("calrptid"));
        }
        if (!balIdSet.isEmpty() && !(rptColl = QueryServiceHelper.query((String)"cal_calculateoutrpt", (String)"id", (QFilter[])new QFilter("id", "in", balIdSet).toArray(), (String)"caltime desc", (int)1)).isEmpty()) {
            HashSet<Long> rptIdSet = new HashSet<Long>(16);
            long rptId = ((DynamicObject)rptColl.get(0)).getLong("id");
            rptIdSet.add(rptId);
            this.createEmptyRptDycs(rptIdSet);
            rptInfo = this.rptCacheMap.get(rptId);
            this.rptMap.put(key, rptInfo);
        }
        return rptInfo;
    }

    public void setFieldIsBaseDateMap(Map<String, Boolean> fieldIsBaseDateMap) {
        this.fieldIsBaseDateMap = fieldIsBaseDateMap;
    }

    public void addRptEntry(String key, FiFoBillInfo billInfo, List<FiFoBalInfo> balList, Map<Long, Long> updateRptMap) {
        String costPriceSourceStr;
        int seq;
        boolean isSubEntry;
        String[] keys = key.split(",");
        String rptKey = this.getRptKey(key);
        DynamicObject rptInfo = this.rptMap.get(rptKey);
        int currSeq = this.getCurrSeq(rptInfo);
        rptInfo.set("nextSeq", (Object)currSeq++);
        for (FiFoBalInfo balInfo : balList) {
            Long dbRptId = balInfo.getDbRptId();
            boolean dbRptIsEmpty = dbRptId == null || dbRptId.equals(0L);
            long newRptId = rptInfo.getLong("id");
            if (!dbRptIsEmpty && dbRptId.equals(newRptId)) continue;
            updateRptMap.put(balInfo.getBalId(), newRptId);
        }
        long costSubElement = Long.parseLong(keys[keys.length - 1]);
        boolean bl = isSubEntry = costSubElement != -1L;
        if (isSubEntry && billInfo.getCost().compareTo(BigDecimal.ZERO) == 0 && this.isBalListZero(balList)) {
            return;
        }
        DynamicObject rptEntry = rptInfo.getDynamicObjectCollection("entryentity").addNew();
        int displaypricepc = billInfo.getDisplayPricePrecision();
        String billno = billInfo.getBillNo();
        String billtypenumber = billInfo.getBillTypeNum();
        String billtypename = billInfo.getBillTypeName();
        long billId = billInfo.getBillId();
        long billEntryId = billInfo.getBillEntryId();
        long eid = billInfo.getBillEntryId();
        long parentId = 0L;
        if (isSubEntry) {
            billno = this.subEleIdNameMap.get(costSubElement);
            parentId = eid;
            billtypename = ResManager.loadKDString((String)"\u5b50\u8981\u7d20", (String)"MoveAddAverageCalculate_0", (String)"fi-cal-business", (Object[])new Object[0]);
        }
        Set<String> priceTypes = billInfo.getPriceTypeNames();
        StringBuilder billTypeSb = new StringBuilder();
        if (!priceTypes.isEmpty()) {
            billTypeSb.append('\uff08');
            for (String priceType : priceTypes) {
                billTypeSb.append(priceType);
                billTypeSb.append(',');
            }
            billTypeSb = new StringBuilder(billTypeSb.substring(0, billTypeSb.length() - 1));
            billTypeSb.append('\uff09');
            billtypename = billtypename + billTypeSb;
        }
        if ("0".equals(this.opType)) {
            String msg;
            billtypename = msg = String.format(ResManager.loadKDString((String)"%1$s\uff08\u53cd\u5ba1\u6838\uff09", (String)"FIFOCalculate_13", (String)"fi-cal-business", (Object[])new Object[0]), billtypename);
        }
        if ((seq = rptInfo.getInt("nextSeq")) == 0) {
            seq = 1;
        }
        rptEntry.set("seq", (Object)seq);
        rptInfo.set("nextSeq", (Object)(seq + 1));
        rptEntry.set("bizbillid", (Object)billId);
        rptEntry.set("bizbillentryid", (Object)billEntryId);
        rptEntry.set("billnumber", (Object)billno);
        rptEntry.set("billtypenum", (Object)billtypenumber);
        rptEntry.set("billtype", (Object)billtypename);
        rptEntry.set("bizdate", (Object)billInfo.getBizDate());
        rptEntry.set("auditdate", (Object)billInfo.getAuditDate());
        this.handlePrecision(billInfo, balList);
        rptEntry.set("instr", this.getInStr(billInfo, isSubEntry));
        rptEntry.set("outstr", this.getOutStr(billInfo, isSubEntry));
        rptEntry.set("balancestr", this.getBalanceStr(balList, displaypricepc, billInfo));
        rptEntry.set("parententryid", (Object)parentId);
        String costpricesource = billInfo.getCostpricesource();
        if ("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) {
            if (!isSubEntry) {
                rptEntry.set("describe", (Object)costpricesource);
            }
        } else if (!isSubEntry && ("cal_costrecord_subentity".equals(this.entityName) || "cal_costrecord".equals(this.entityName)) && StringUtils.isNotEmpty((String)(costPriceSourceStr = CostPriceSourceTypeEnum.getAllNameByCostPriceSources((String)costpricesource)))) {
            rptEntry.set("describe", (Object)costPriceSourceStr);
        }
    }

    public void addRptEntry4CostAdjust(String key, FiFoBillInfo billInfo, FiFoBalInfo parentBalInfo, Map<Long, FiFoBalInfo> detailBalMap, DynamicObject costAdjustbill, DynamicObject costAdjustEntry) {
        String rptKey = this.getRptKey(key);
        DynamicObject rptInfo = this.rptMap.get(rptKey);
        DynamicObject rptEntry = rptInfo.getDynamicObjectCollection("entryentity").addNew();
        int displaypricepc = billInfo.getDisplayPricePrecision();
        int amtPrecision = billInfo.getAmtPrecision();
        int qtyPrecision = billInfo.getQtyPrecision();
        int seq = rptInfo.getInt("nextSeq");
        if (seq == 0) {
            seq = 1;
        }
        rptEntry.set("seq", (Object)seq);
        rptInfo.set("nextSeq", (Object)(seq + 1));
        rptEntry.set("bizbillid", costAdjustbill.get("id"));
        rptEntry.set("bizbillentryid", costAdjustEntry.get("id"));
        rptEntry.set("billnumber", (Object)costAdjustbill.getString("billno"));
        rptEntry.set("billtypenum", (Object)"cal_costadjustbill");
        rptEntry.set("bizdate", (Object)costAdjustbill.getDate("bookdate"));
        rptEntry.set("auditdate", (Object)costAdjustbill.getDate("auditdate"));
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"MoveAddAverageCalculate_1", (String)"fi-cal-business", (Object[])new Object[0]);
        String invbillnum = costAdjustEntry.getString("invbillnum");
        if (StringUtils.isNotEmpty((String)invbillnum)) {
            msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"MoveAddAverageCalculate_14", (String)"fi-cal-business", (Object[])new Object[0]), invbillnum);
        }
        rptEntry.set("describe", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getDesc());
        rptEntry.set("billtype", (Object)msg);
        StringBuilder str = new StringBuilder();
        str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(displaypricepc, 4).toPlainString()).append(" = ").append(costAdjustEntry.getBigDecimal("adjustamt").setScale(amtPrecision, 4).toPlainString());
        rptEntry.set("outstr", (Object)str.toString());
        str.setLength(0);
        str.append(this.toBigDecimalString(parentBalInfo.getQty().setScale(qtyPrecision, 4))).append(" * ").append(this.toBigDecimalString(this.getPriceStr(parentBalInfo, displaypricepc).setScale(displaypricepc, 4))).append(" = ").append(this.toBigDecimalString(parentBalInfo.getCost().setScale(amtPrecision, 4)));
        rptEntry.set("balancestr", (Object)str.toString());
        rptEntry.set("parententryid", (Object)0L);
        for (DynamicObject detail : costAdjustEntry.getDynamicObjectCollection("subentryentity")) {
            if (detail.getBigDecimal("sub_adjustamt").compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject rpt1 = rptInfo.getDynamicObjectCollection("entryentity").addNew();
            long costSubElement = detail.getLong("costsubelement");
            FiFoBalInfo detailBalInfo = detailBalMap.get(detail.getLong("id"));
            seq = this.getCurrSeq(rptInfo);
            rptInfo.set("nextSeq", (Object)seq++);
            rpt1.set("seq", (Object)seq);
            rpt1.set("bizbillid", costAdjustbill.get("id"));
            rpt1.set("bizbillentryid", detail.get("id"));
            String subName = this.subEleIdNameMap.get(costSubElement);
            rpt1.set("billnumber", (Object)subName);
            rpt1.set("billtypenum", (Object)"cal_costadjustbill");
            String msg1 = ResManager.loadKDString((String)"\u5b50\u8981\u7d20", (String)"MoveAddAverageCalculate_10", (String)"fi-cal-business", (Object[])new Object[0]);
            rpt1.set("billtype", (Object)msg1);
            rpt1.set("bizdate", (Object)costAdjustbill.getDate("bookdate"));
            rpt1.set("auditdate", (Object)costAdjustbill.getDate("auditdate"));
            str.setLength(0);
            str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(displaypricepc, 4).toPlainString()).append(" = ").append(this.toBigDecimalString(detail.getBigDecimal("sub_adjustamt").setScale(amtPrecision, 4)));
            rpt1.set("outstr", (Object)str.toString());
            str.setLength(0);
            str.append(this.toBigDecimalString(detailBalInfo.getQty().setScale(qtyPrecision, 4))).append(" * ").append(this.toBigDecimalString(this.getPriceStr(detailBalInfo, displaypricepc).setScale(displaypricepc, 4))).append(" = ").append(this.toBigDecimalString(detailBalInfo.getCost().setScale(amtPrecision, 4)));
            rpt1.set("balancestr", (Object)str.toString());
            rpt1.set("parententryid", (Object)costAdjustEntry.getLong("id"));
        }
    }

    private String getRptKey(String key) {
        String rptkey = key.substring(0, key.lastIndexOf(44));
        rptkey = rptkey.substring(0, rptkey.lastIndexOf(44));
        return rptkey;
    }

    private boolean isBalListZero(List<FiFoBalInfo> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (FiFoBalInfo info : list) {
            if (info.getCost().compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void handlePrecision(FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        int amtPrecision = billInfo.getAmtPrecision();
        int qtyPrecision = billInfo.getQtyPrecision();
        billInfo.setQty(billInfo.getQty().setScale(qtyPrecision, 4));
        billInfo.setCost(billInfo.getCost().setScale(amtPrecision, 4));
        for (FiFoBalInfo balInfo : balList) {
            balInfo.setQty(balInfo.getQty().setScale(qtyPrecision, 4));
            balInfo.setCost(balInfo.getCost().setScale(amtPrecision, 4));
        }
    }

    private Object getInStr(FiFoBillInfo billInfo, boolean isSubEntry) {
        String queueType;
        BigDecimal sign = BigDecimal.ONE;
        if ("0".equals(this.opType)) {
            sign = new BigDecimal("-1");
        }
        if ("0".equals(queueType = billInfo.getQueueType())) {
            StringBuilder str = new StringBuilder();
            if (!isSubEntry) {
                str.append(this.toBigDecimalString(billInfo.getQty().multiply(sign))).append(" * ").append(this.toBigDecimalString(this.getPriceStr(billInfo))).append(" = ");
            }
            str.append(this.toBigDecimalString(billInfo.getCost().multiply(sign)));
            return str.toString();
        }
        return null;
    }

    private Object getOutStr(FiFoBillInfo billInfo, boolean isSubEntry) {
        String queueType;
        BigDecimal sign = BigDecimal.ONE;
        if ("0".equals(this.opType)) {
            sign = new BigDecimal("-1");
        }
        if ("1".equals(queueType = billInfo.getQueueType())) {
            StringBuilder str = new StringBuilder();
            if (!isSubEntry) {
                str.append(this.toBigDecimalString(billInfo.getQty().multiply(sign))).append(" * ").append(this.toBigDecimalString(this.getPriceStr(billInfo))).append(" = ");
            }
            str.append(this.toBigDecimalString(billInfo.getCost().multiply(sign)));
            return str.toString();
        }
        return null;
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    private BigDecimal getPriceStr(FiFoBalInfo balInfo, int pricePrecision) {
        if (balInfo.getCost() == null || balInfo.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.setScale(pricePrecision, 4);
        }
        if (balInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.setScale(pricePrecision, 4);
        }
        BigDecimal price = balInfo.getCost().divide(balInfo.getQty(), pricePrecision, 4);
        return price;
    }

    private BigDecimal getPriceStr(FiFoBillInfo billInfo) {
        if (billInfo.getCost() == null || billInfo.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.setScale(billInfo.getDisplayPricePrecision(), 4);
        }
        if (billInfo.getPrice() != null && billInfo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
            return billInfo.getPrice().setScale(billInfo.getDisplayPricePrecision(), 4);
        }
        if (billInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.setScale(billInfo.getDisplayPricePrecision(), 4);
        }
        BigDecimal price = billInfo.getCost().divide(billInfo.getQty(), billInfo.getDisplayPricePrecision(), 4);
        return price;
    }

    private Object getBalanceStr(List<FiFoBalInfo> balList, int pricePrecision, FiFoBillInfo billInfo) {
        int amtPrecision = billInfo.getAmtPrecision();
        int qtyPrecision = billInfo.getQtyPrecision();
        StringBuilder str = new StringBuilder();
        int max = 5;
        int i = 0;
        for (FiFoBalInfo balInfo : balList) {
            if (balInfo.getQty().signum() == 0 && balInfo.getCost().signum() == 0) continue;
            if (i >= max) {
                str.append("...");
                break;
            }
            str.append(this.toBigDecimalString(balInfo.getQty())).append(" * ").append(this.toBigDecimalString(balInfo.getPrice().setScale(pricePrecision, 4))).append(" = ").append(this.toBigDecimalString(balInfo.getCost())).append("\n");
            ++i;
        }
        if (str.length() <= 0) {
            if (balList.isEmpty()) {
                str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(pricePrecision, 4).toPlainString()).append(" = ").append(BigDecimal.ZERO.setScale(amtPrecision, 4).toPlainString()).append("\n");
            } else {
                FiFoBalInfo balInfo = balList.get(balList.size() - 1);
                str.append(this.toBigDecimalString(balInfo.getQty())).append(" * ").append(this.toBigDecimalString(balInfo.getPrice().setScale(pricePrecision, 4))).append(" = ").append(this.toBigDecimalString(balInfo.getCost())).append("\n");
            }
        }
        return str.toString();
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    private void cacheSubEleIdNameMap() {
        QFilter subEleF = new QFilter("syncflag", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,name", (QFilter[])subEleF.toArray(), null);
        for (Row row : dataSet) {
            this.subEleIdNameMap.put(row.getLong("id"), row.getString("name"));
        }
    }
}

