/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.fi.cal.business.calculate.out.FIFOCalculate;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate4Sync;
import kd.fi.cal.business.calculate.out.StandardCostCalculate;
import kd.fi.cal.business.process.inner.CalMoveDlock;

public class CalMoveInvoker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCalAdjBill(Long[] billIds, String entityName, String opType) {
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            HashSet<Long> billIdSets = new HashSet<Long>(Arrays.asList(billIds));
            Map<String, DLock> keyLockMap = calMoveDlock.addLockBatchByCostAdjust(billIdSets);
            locks.addAll(keyLockMap.values());
            this.doCalThrowExp(billIds, entityName, opType, null);
        }
        finally {
            this.releaseLock(locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCalAdjBillFifo(Long[] billIds, String entityName, String opType, long costAccountId) {
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            HashSet<Long> billIdSets = new HashSet<Long>(Arrays.asList(billIds));
            Map<String, DLock> keyLockMap = calMoveDlock.addLockBatchByCostAdjust(billIdSets);
            locks.addAll(keyLockMap.values());
            FIFOCalculate fifoCal = new FIFOCalculate(billIds, entityName, opType, costAccountId);
            fifoCal.calculate();
        }
        finally {
            this.releaseLock(locks);
        }
    }

    private void releaseLock(final List<DLock> locks) {
        CommitListener commitListener = new CommitListener(){

            public void onEnded(boolean rollbacked) {
                for (DLock lock : locks) {
                    lock.close();
                }
            }
        };
        TX.addCommitListener((CommitListener)commitListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCalInitBill(Long[] billIds, String entityName, String opType, long costAccId) {
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            HashSet<Long> billIdSets = new HashSet<Long>(Arrays.asList(billIds));
            Map<String, DLock> keyLockMap = calMoveDlock.addLockBatchByInitCalBill(billIdSets);
            locks.addAll(keyLockMap.values());
            this.doCalThrowExp(billIds, entityName, opType, costAccId);
        }
        finally {
            this.releaseLock(locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCalInitBillFifo(Long[] billIds, String entityName, String opType, long costAccountId) {
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            HashSet<Long> billIdSets = new HashSet<Long>(Arrays.asList(billIds));
            Map<String, DLock> keyLockMap = calMoveDlock.addLockBatchByInitCalBill(billIdSets);
            locks.addAll(keyLockMap.values());
            FIFOCalculate cal = new FIFOCalculate(billIds, entityName, opType, costAccountId);
            cal.calculate();
        }
        finally {
            this.releaseLock(locks);
        }
    }

    public void doCalThrowExp(Long[] billIds, String entityName, String opType, Long costAccId) {
        Collection<Object[]> errorBillInfo = this.doCal(billIds, entityName, opType, costAccId);
        if (errorBillInfo != null) {
            StringBuilder errorMsgSb = new StringBuilder();
            for (Object[] objs : errorBillInfo) {
                String errorMsg = (String)objs[1];
                errorMsgSb.append(errorMsg).append("\r\n");
            }
            if (errorMsgSb.length() > 0) {
                throw new KDBizException(errorMsgSb.toString());
            }
        }
    }

    private Collection<Object[]> doCal(Long[] billIds, String entityName, String opType, Long costAccId) {
        MoveAddAverageCalculate calMov = costAccId == null ? new MoveAddAverageCalculate(billIds, entityName, opType) : new MoveAddAverageCalculate(billIds, entityName, opType, costAccId);
        calMov.calculate();
        Collection<Object[]> errorBillInfo = null;
        return errorBillInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCalMoveAndFifoByMatWf(Map<Long, DynamicObject> notCalculatedCostRecordEntry, Set<Long> costRecordIdSet, Map<String, BigDecimal> totalGroupCost, Set<Long> costAcctIds) {
        Map<Object, Object> keyLockMap = new HashMap(16);
        if (notCalculatedCostRecordEntry.isEmpty()) {
            return;
        }
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            keyLockMap = calMoveDlock.addLockBatchByCostRecordId(costRecordIdSet);
            locks.addAll(keyLockMap.values());
            MoveAddAverageCalculate4Sync movedCalculator = new MoveAddAverageCalculate4Sync(costRecordIdSet.toArray(new Long[costRecordIdSet.size()]), notCalculatedCostRecordEntry.keySet().toArray(new Long[notCalculatedCostRecordEntry.size()]), "cal_costrecord", "1");
            StandardCostCalculate standardCalculator = new StandardCostCalculate(costRecordIdSet, notCalculatedCostRecordEntry.keySet());
            standardCalculator.putGroupCost(totalGroupCost);
            movedCalculator.putGroupCost(totalGroupCost);
            DataSet dataSet = movedCalculator.beforeCalculate();
            Collection<Object[]> errorMsgs = movedCalculator.doCalculate(dataSet);
            this.showCalMoveErrorMsgs(errorMsgs);
            standardCalculator.calculate();
            for (Long costAcctId : costAcctIds) {
                FIFOCalculate fifoCal = new FIFOCalculate(costRecordIdSet.toArray(new Long[0]), "cal_costrecord", "1", costAcctId);
                fifoCal.setBillEntryIds(notCalculatedCostRecordEntry.keySet().toArray(new Long[notCalculatedCostRecordEntry.size()]));
                fifoCal.putGroupCost(totalGroupCost);
                fifoCal.calculate();
            }
        }
        finally {
            this.releaseLock(locks);
        }
    }

    private void showCalMoveErrorMsgs(Collection<Object[]> errorMsgs) {
        if (errorMsgs == null || errorMsgs.isEmpty()) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        for (Object[] errorMsgObjs : errorMsgs) {
            String errorMsg = (String)errorMsgObjs[1];
            errMsg.append(errorMsg).append("\n");
        }
        throw new KDBizException(errMsg.toString());
    }
}

