/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.calculate.out.CalInTimeFifoRptHolder;
import kd.fi.cal.business.calculate.out.FiFoBalInfo;
import kd.fi.cal.business.calculate.out.FiFoBillInfo;
import kd.fi.cal.business.calculate.out.FiFoSelfBalInfo;
import kd.fi.cal.business.costprice.CostPrice4Others;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;

public class FIFOCalculate {
    private static final Log logger = LogFactory.getLog(FIFOCalculate.class);
    private String entityName;
    private Long[] billIds;
    private Long[] billEntryIds = null;
    private String divideStr;
    private String caldimensionStr;
    private String totalKey;
    private String opType;
    private Map<String, BigDecimal> billGroupMap = new HashMap<String, BigDecimal>(16);
    private Map<Long, CostPriceResultInfo> billCostPriceMap = new HashMap<Long, CostPriceResultInfo>(16);
    private Set<Long> costRecordEntrySet = new HashSet<Long>(16);
    private Set<Long> omInCostRecordEntrys = new HashSet<Long>(16);
    private Set<Long> notOmInCostRecordEntrys = new HashSet<Long>(16);
    private Set<String> omInBills = new HashSet<String>(16);
    private long curPeriodId = 0L;
    private Date periodBeginDate;
    private long costAccountId = 0L;
    private Long calOrgId = 0L;
    private Map<String, BigDecimal[]> recordCostMap = new HashMap<String, BigDecimal[]>();
    private Set<DynamicObject> insertBalSet = new HashSet<DynamicObject>();
    private Map<Long, Object[]> updateBalMap = new HashMap<Long, Object[]>();
    private Set<Long> deleteBalSet = new HashSet<Long>(16);
    private Map<Long, Long> updateRptMap = new HashMap<Long, Long>(32);
    private Map<Long, Long> costRecordChildMap = new HashMap<Long, Long>(32);
    private Map<Long, DynamicObject> costAdjustMap = new HashMap<Long, DynamicObject>(32);
    private Map<Long, DynamicObject> costAdjustEntryMap = new HashMap<Long, DynamicObject>(32);
    private Map<Long, DynamicObject> loadBillMap = new HashMap<Long, DynamicObject>(32);
    private Map<Long, DynamicObject> loadEntryMap = new HashMap<Long, DynamicObject>(32);
    private String entryName = "entry";
    private DynamicObject costAdjustOutBillType;
    private boolean isCalByCostElement = false;
    private Map<String, Boolean> fieldIsBaseDateMap = new HashMap<String, Boolean>(16);
    private Map<Long, BigDecimal[]> materialCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> feeMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> processCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> manufactureCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> resourceMap = new HashMap<Long, BigDecimal[]>();
    private Set<Long> entryIdSet = new HashSet<Long>(16);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private List<Object[]> updateCostPricesParams = new ArrayList<Object[]>(16);
    private String realTimePriceName = ResManager.loadKDString((String)"\u5373\u65f6\u6210\u672c", (String)"FIFOCalculate_9", (String)"fi-cal-business", (Object[])new Object[0]);
    private String zeroCostPriceName = ResManager.loadKDString((String)"\u96f6\u6210\u672c", (String)"FIFOCalculate_10", (String)"fi-cal-business", (Object[])new Object[0]);
    private String presentPriceName = ResManager.loadKDString((String)"\u8d60\u54c1", (String)"MoveAddAverageCalculate4Sync_0", (String)"fi-cal-business", (Object[])new Object[0]);
    private static String GROUP_PRICE = "group_price";
    private static String INVENTORY_TRANSACTION_ZEROCOST = "inventory_transaction_zerocost";
    private static String STRATEGY_SYNC_PRICE = "strategy_sync_price";
    private static String BILL_PRICE = "bill_price";
    private static String FIFO_PRICE = "fifo_price";
    private boolean enableStd;
    private boolean isSync = false;
    private Map<String, Object[]> errorMsgMap;
    private Map<String, Object[]> domainKeyBillIdBillInfoMap = new HashMap<String, Object[]>(16);
    private boolean calInTimeRemoveAllErr = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_INTIME_REMOVE_ALL_ERR);
    private Set<Long> zeroInOutBizTypeIds = new HashSet<Long>(16);
    private Map<Long, String> costAcctIdNameMap = new HashMap<Long, String>(16);
    private String auditType;
    private CalInTimeFifoRptHolder rptHolder = new CalInTimeFifoRptHolder();
    private Map<Long, Boolean> calOrgPurZeroCostMap = new HashMap<Long, Boolean>();

    public FIFOCalculate(Long[] billIds, String entityName, String opType, long costAccountId) {
        Boolean isPurZeroCost;
        this.entityName = entityName;
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName) || "cal_initbill".equals(entityName)) {
            this.entryName = "entryentity";
        }
        this.billIds = billIds;
        this.divideStr = CommonSettingHelper.getDivideBasisStr();
        this.caldimensionStr = CommonSettingHelper.getCalDimensionStr();
        this.totalKey = CommonUtils.trimComma((String)this.divideStr) + "," + CommonUtils.trimComma((String)this.caldimensionStr);
        this.opType = opType;
        this.costAccountId = costAccountId;
        this.omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        DynamicObject costAcc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost,calorg,calpolicy.calbycostelement,id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
        this.enableStd = costAcc.getBoolean("enablestandardcost");
        DynamicObject period = null;
        period = "cal_initbill".equals(entityName) ? PeriodHelper.getStartPeriod((Long)this.costAccountId) : PeriodHelper.getCurrentPeriod((Long)this.costAccountId);
        if (period != null) {
            this.curPeriodId = period.getLong("id");
            this.periodBeginDate = period.getDate("begindate");
        }
        this.calOrgId = costAcc.getLong("calorg");
        this.costAdjustOutBillType = CommonSettingHelper.getCostAdjustOutBillType();
        this.isCalByCostElement = costAcc.getBoolean("calpolicy.calbycostelement");
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_balance_fifo");
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (pro instanceof BasedataProp) {
                this.fieldIsBaseDateMap.put(pro.getName(), true);
                continue;
            }
            this.fieldIsBaseDateMap.put(pro.getName(), false);
        }
        this.rptHolder.setCalOrgId(this.calOrgId);
        this.rptHolder.setCurPeriodId(this.curPeriodId);
        this.rptHolder.setFieldIsBaseDateMap(this.fieldIsBaseDateMap);
        this.rptHolder.setEntityName(entityName);
        this.rptHolder.setOpType(opType);
        if ("cal_costrecord".equals(entityName)) {
            DynamicObject settingObj = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizTypes = settingObj.getDynamicObjectCollection("zeroinoutbiztype");
            for (DynamicObject bizType : bizTypes) {
                this.zeroInOutBizTypeIds.add(bizType.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        if ((isPurZeroCost = this.calOrgPurZeroCostMap.get(this.calOrgId)) == null) {
            isPurZeroCost = (Boolean)ParamsHelper.getAppParam((long)this.calOrgId, (String)"ispurfetchzerocost");
            this.calOrgPurZeroCostMap.put(this.calOrgId, isPurZeroCost);
        }
        this.costAcctIdNameMap.put(costAcc.getLong("id"), costAcc.getString("name"));
    }

    public FIFOCalculate(Long[] billIds, String entityName, String opType, long costAccountId, boolean isSync, String auditType) {
        this(billIds, entityName, opType, costAccountId);
        this.isSync = isSync;
        this.errorMsgMap = new HashMap<String, Object[]>();
        if ("cal_costrecord".equals(entityName)) {
            DynamicObject settingObj = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizTypes = settingObj.getDynamicObjectCollection("zeroinoutbiztype");
            for (DynamicObject bizType : bizTypes) {
                this.zeroInOutBizTypeIds.add(bizType.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        this.auditType = auditType;
    }

    public void calculate() {
        this.calculate4NotToDB();
        this.writeToDB();
    }

    public void calculate4NotToDB() {
        Object recordDataSet;
        DataSet dataSet = this.getBillDataSet(this.billIds, this.entityName);
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        if (this.enableStd && "cal_initbill".equals(this.entityName)) {
            dataSet = dataSet.select(this.getInitCalAliasSelects() + ",(unitactualcost+costdiff/billqty) as unitactualcost,billcost+costdiff as billcost");
        }
        if ("1".equals(this.opType) && "cal_costrecord".equals(this.entityName)) {
            this.cacheBillGroup(dataSet.copy());
            this.cacheCostPrice(dataSet.copy());
        }
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        HashSet<Long> materialSet = new HashSet<Long>(16);
        HashSet<Long> recordEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> costRecIds = new HashSet<Long>(16);
        for (Row row : dataSet.copy()) {
            long calRangeId = row.getLong("calRange");
            if (calRangeId != 0L) {
                calRangeSet.add(calRangeId);
            }
            materialSet.add(row.getLong("material"));
            if (row.getLong("costrecordentryid") != 0L) {
                recordEntryIdSet.add(row.getLong("costrecordentryid"));
                costRecIds.add(row.getLong("costrecordid"));
            }
            this.entryIdSet.add(row.getLong("eid"));
        }
        if (!recordEntryIdSet.isEmpty()) {
            QFilter filter = new QFilter("entry.id", "in", recordEntryIdSet);
            filter.and("id", "in", costRecIds);
            recordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorentryid,entry.id", (QFilter[])filter.toArray(), null);
            Throwable calRangeId = null;
            try {
                Iterator iterator = recordDataSet.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.costRecordChildMap.put(row.getLong("entry.id"), row.getLong("entry.ancestorentryid"));
                }
            }
            catch (Throwable throwable) {
                calRangeId = throwable;
                throw throwable;
            }
            finally {
                if (recordDataSet != null) {
                    if (calRangeId != null) {
                        try {
                            recordDataSet.close();
                        }
                        catch (Throwable throwable) {
                            calRangeId.addSuppressed(throwable);
                        }
                    } else {
                        recordDataSet.close();
                    }
                }
            }
        }
        DataSet calRangeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray(), null);
        recordDataSet = null;
        try {
            calRangeSet.clear();
            for (Row row : calRangeDataSet) {
                if (row.getLong("entry.id") == 0L) continue;
                calRangeSet.add(row.getLong("id"));
            }
        }
        catch (Throwable calRangeId) {
            recordDataSet = calRangeId;
            throw calRangeId;
        }
        finally {
            if (calRangeDataSet != null) {
                if (recordDataSet != null) {
                    try {
                        calRangeDataSet.close();
                    }
                    catch (Throwable calRangeId) {
                        ((Throwable)recordDataSet).addSuppressed(calRangeId);
                    }
                } else {
                    calRangeDataSet.close();
                }
            }
        }
        QFilter q = new QFilter("material", "in", materialSet);
        q.and("costaccount", "=", (Object)this.costAccountId);
        QFilter q1 = new QFilter("endqty", "<>", (Object)0);
        q1.or("endcost", "<>", (Object)0);
        q.and(q1);
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_fifo", (String)("id,material,costaccount,endqty,endcost,endunitcost,calrptid,calrange,bizdate,auditdate,billno,entryseq,billentryid as entryid,to_char(costelement) as costelement,to_char(costsubelement) as costsubelement," + this.totalKey), (QFilter[])q.toArray(), null);
        HashSet<Long> rptIdSet = new HashSet<Long>();
        for (Row row : balDataSet.copy()) {
            rptIdSet.add(row.getLong("calrptid"));
        }
        this.rptHolder.createEmptyRptDycs(rptIdSet);
        DataSet groupBalDataSet = balDataSet.copy().groupBy((String[])ArrayUtils.concatAll((Object[])new String[]{"material", "costaccount", "endqty", "calrange", "bizdate", "auditdate", "billno", "entryseq", "entryid"}, (Object[][])new String[][]{this.totalKey.split(",")})).sum("endcost").sum("endunitcost").max("calrptid").finish().select("-1L as id,material,costaccount,endqty,endcost,endunitcost,calrptid,calrange,bizdate,auditdate,billno,entryseq,entryid,'-1' as costelement,'-1' as costsubelement," + this.totalKey);
        DataSet unionBalDataSet = balDataSet.union(groupBalDataSet);
        unionBalDataSet = unionBalDataSet.orderBy(new String[]{"bizdate asc", "auditdate asc", "billno asc", "entryseq asc", "costsubelement asc"});
        if (!calRangeSet.isEmpty()) {
            DataSet divideDataSet;
            DataSet calRangeDataSet2 = dataSet.copy().filter(new QFilter("calrange", "in", calRangeSet).toString());
            if (!calRangeDataSet2.isEmpty()) {
                this.handleCalRangeDataSet(dataSet.copy(), calRangeDataSet2, unionBalDataSet.copy());
            }
            if (!(divideDataSet = dataSet.copy().filter(new QFilter("calrange", "not in", calRangeSet).toString())).isEmpty()) {
                this.handleDivideDataSet(dataSet.copy(), divideDataSet, unionBalDataSet);
            }
        } else {
            this.handleDivideDataSet(dataSet.copy(), dataSet, unionBalDataSet);
        }
    }

    public void writeToDB() {
        this.writeFifoBal();
        this.rptHolder.writeRptBySql();
        if ("cal_costrecord".equals(this.entityName)) {
            this.writeCostRecord();
            this.writeIsCal(this.entryIdSet);
        }
        this.writeCostAdjust();
    }

    public Collection<Object[]> calculate4Sync() {
        Object row2;
        DataSet dataSet = this.getBillDataSet(this.billIds, this.entityName);
        if (dataSet == null || dataSet.isEmpty()) {
            return null;
        }
        if (this.enableStd && "cal_initbill".equals(this.entityName)) {
            dataSet = dataSet.select(this.getInitCalAliasSelects() + ",(unitactualcost+costdiff/billqty) as unitactualcost,billcost+costdiff as billcost");
        }
        if ("cal_costrecord".equals(this.entityName)) {
            this.cacheBillGroup(dataSet.copy());
            this.cacheCostPrice(dataSet.copy());
        }
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        HashSet<Long> materialSet = new HashSet<Long>(16);
        HashSet<Long> recordEntryIdSet = new HashSet<Long>(16);
        for (Object row2 : dataSet.copy()) {
            long calRangeId = row2.getLong("calRange");
            if (calRangeId != 0L) {
                calRangeSet.add(calRangeId);
            }
            materialSet.add(row2.getLong("material"));
            if (row2.getLong("costrecordentryid") != 0L) {
                recordEntryIdSet.add(row2.getLong("costrecordentryid"));
            }
            this.entryIdSet.add(row2.getLong("eid"));
        }
        if (!recordEntryIdSet.isEmpty()) {
            DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorentryid,entry.id", (QFilter[])new QFilter("entry.id", "in", recordEntryIdSet).toArray(), null);
            row2 = null;
            try {
                for (Row row3 : recordDataSet) {
                    this.costRecordChildMap.put(row3.getLong("entry.id"), row3.getLong("entry.ancestorentryid"));
                }
            }
            catch (Throwable calRangeId) {
                row2 = calRangeId;
                throw calRangeId;
            }
            finally {
                if (recordDataSet != null) {
                    if (row2 != null) {
                        try {
                            recordDataSet.close();
                        }
                        catch (Throwable calRangeId) {
                            ((Throwable)row2).addSuppressed(calRangeId);
                        }
                    } else {
                        recordDataSet.close();
                    }
                }
            }
        }
        DataSet calRangeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray(), null);
        row2 = null;
        try {
            calRangeSet.clear();
            for (Row row3 : calRangeDataSet) {
                if (row3.getLong("entry.id") == 0L) continue;
                calRangeSet.add(row3.getLong("id"));
            }
        }
        catch (Throwable calRangeId) {
            row2 = calRangeId;
            throw calRangeId;
        }
        finally {
            if (calRangeDataSet != null) {
                if (row2 != null) {
                    try {
                        calRangeDataSet.close();
                    }
                    catch (Throwable calRangeId) {
                        ((Throwable)row2).addSuppressed(calRangeId);
                    }
                } else {
                    calRangeDataSet.close();
                }
            }
        }
        QFilter q = new QFilter("material", "in", materialSet);
        q.and("costaccount", "=", (Object)this.costAccountId);
        QFilter q1 = new QFilter("endqty", "<>", (Object)0);
        q1.or("endcost", "<>", (Object)0);
        q.and(q1);
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_fifo", (String)("id,material,costaccount,endqty,endcost,endunitcost,calrptid,calrange,bizdate,auditdate,billno,entryseq,billentryid as entryid,to_char(costelement) as costelement,to_char(costsubelement) as costsubelement," + this.totalKey), (QFilter[])q.toArray(), null);
        HashSet<Long> rptIdSet = new HashSet<Long>();
        for (Row row4 : balDataSet.copy()) {
            rptIdSet.add(row4.getLong("calrptid"));
        }
        this.rptHolder.createEmptyRptDycs(rptIdSet);
        DataSet groupBalDataSet = balDataSet.copy().groupBy((String[])ArrayUtils.concatAll((Object[])new String[]{"material", "costaccount", "endqty", "calrange", "bizdate", "auditdate", "billno", "entryseq", "entryid"}, (Object[][])new String[][]{this.totalKey.split(",")})).sum("endcost").sum("endunitcost").max("calrptid").finish().select("-1L as id,material,costaccount,endqty,endcost,endunitcost,calrptid,calrange,bizdate,auditdate,billno,entryseq,entryid,'-1' as costelement,'-1' as costsubelement," + this.totalKey);
        DataSet unionBalDataSet = balDataSet.union(groupBalDataSet);
        unionBalDataSet = unionBalDataSet.orderBy(new String[]{"bizdate asc", "auditdate asc", "billno asc", "entryseq asc", "costsubelement asc"});
        if (!calRangeSet.isEmpty()) {
            DataSet divideDataSet;
            DataSet calRangeDataSet2 = dataSet.copy().filter(new QFilter("calrange", "in", calRangeSet).toString());
            if (!calRangeDataSet2.isEmpty()) {
                this.handleCalRangeDataSet(dataSet.copy(), calRangeDataSet2, unionBalDataSet.copy());
            }
            if (!(divideDataSet = dataSet.copy().filter(new QFilter("calrange", "not in", calRangeSet).toString())).isEmpty()) {
                this.handleDivideDataSet(dataSet.copy(), divideDataSet, unionBalDataSet);
            }
        } else {
            this.handleDivideDataSet(dataSet.copy(), dataSet, unionBalDataSet);
        }
        if (this.calInTimeRemoveAllErr && this.domainKeyBillIdBillInfoMap != null && !this.domainKeyBillIdBillInfoMap.isEmpty()) {
            return this.domainKeyBillIdBillInfoMap.values();
        }
        if (this.errorMsgMap != null && !this.errorMsgMap.isEmpty()) {
            return this.errorMsgMap.values();
        }
        return null;
    }

    private void writeIsCal(Set<Long> entryIdSet) {
        if (entryIdSet.isEmpty() || "0".equals(this.opType)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (long entryId : entryIdSet) {
            sb.append(entryId).append(",");
        }
        String ids = sb.substring(0, sb.length() - 1);
        String sql = "update t_cal_calcostrecordentry set fiscalculated = '1' where fentryid in (" + ids + ")";
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql);
    }

    private void writeCostAdjust() {
        if (!this.costAdjustMap.isEmpty()) {
            HashSet<Long> costAdjustEntryIdSet = new HashSet<Long>(16);
            HashSet<Long> costAdjustBillIdSet = new HashSet<Long>(16);
            SaveServiceHelper.save((DynamicObject[])this.costAdjustMap.values().toArray(new DynamicObject[0]));
            for (Map.Entry<Long, DynamicObject> entry : this.costAdjustMap.entrySet()) {
                DynamicObject info = entry.getValue();
                costAdjustBillIdSet.add(info.getLong("id"));
                for (DynamicObject entryInfo : info.getDynamicObjectCollection("entryentity")) {
                    costAdjustEntryIdSet.add(entryInfo.getLong("id"));
                }
            }
            DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])costAdjustBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreop", "true");
            option.setVariableValue("ishasright", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)option);
            List errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
            if (!this.isNewBalance) {
                new BalanceCalculator().updateBalance4CostAdjust(costAdjustEntryIdSet.toArray());
            }
        }
    }

    private void writeCostRecord() {
        List updateDbParams;
        BigDecimal[] costs;
        String[] keys;
        String key;
        if (!this.recordCostMap.isEmpty()) {
            String recordUpateSql = "update t_cal_costrecord_detail set factualcost = ?,funitactualcost = ? where fentryid = ? and fcostsubelementid = ?";
            ArrayList<Object[]> recordList = new ArrayList<Object[]>(this.recordCostMap.size());
            for (Map.Entry<String, BigDecimal[]> entry : this.recordCostMap.entrySet()) {
                key = entry.getKey();
                keys = key.split("\\|");
                costs = entry.getValue();
                Long entryId = Long.valueOf(keys[0]);
                Long subElementId = Long.valueOf(keys[1]);
                BigDecimal actualCost = costs[0];
                BigDecimal unitCost = costs[1];
                Object[] param = new Object[]{actualCost, unitCost, entryId, subElementId};
                recordList.add(param);
            }
            if (!recordList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)recordUpateSql, recordList);
            }
        }
        if (!this.costRecordEntrySet.isEmpty()) {
            if (this.isCalByCostElement) {
                CostElementHelper.calCostRecordAllCost((Long[])this.costRecordEntrySet.toArray(new Long[0]));
            } else {
                Object[] param;
                ArrayList<Object[]> paramList;
                String sql;
                if (!this.recordCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set factualcost = ? ,funitactualcost = ? where fentryid = ?";
                    paramList = new ArrayList<Object[]>(this.recordCostMap.size());
                    for (Map.Entry<String, BigDecimal[]> entry : this.recordCostMap.entrySet()) {
                        key = entry.getKey();
                        keys = key.split("\\|");
                        Long entryId = Long.valueOf(keys[0]);
                        BigDecimal[] costs2 = entry.getValue();
                        Object[] param2 = new Object[]{costs2[0], costs2[1], entryId};
                        paramList.add(param2);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.materialCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fmaterialcost = ? ,funitmaterialcost = ? where fentryid = ?";
                    paramList = new ArrayList(this.materialCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.materialCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.feeMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set ffee = ? ,funitfee = ? where fentryid = ?";
                    paramList = new ArrayList(this.feeMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.feeMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.processCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fprocesscost = ? ,funitprocesscost = ? where fentryid = ?";
                    paramList = new ArrayList(this.processCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.processCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.manufactureCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fmanufacturecost = ? ,funitmanufacturecost = ? where fentryid = ?";
                    paramList = new ArrayList(this.manufactureCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.manufactureCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.resourceMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fresource = ? ,funitresource = ? where fentryid = ?";
                    paramList = new ArrayList(this.resourceMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.resourceMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                CostElementHelper.calCostRecordProcessCost((Long[])this.omInCostRecordEntrys.toArray(new Long[0]));
                CostElementHelper.calCostRecordMaterialCost((Long[])this.notOmInCostRecordEntrys.toArray(new Long[0]));
            }
        }
        if (this.updateCostPricesParams.size() > 0 && (updateDbParams = CostPriceSourceTypeHelper.getUpdateCostPriceSourceParams(this.updateCostPricesParams)) != null && updateDbParams.size() > 0) {
            String updatecostrecordentrysql = " update t_cal_calcostrecordentry set fcostpricesource = ?,fdesignatedcost = ? where fentryid = ?";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updatecostrecordentrysql, (List)updateDbParams);
        }
    }

    private void writeFifoBal() {
        ArrayList<Object[]> paramList;
        String sql;
        if (!this.insertBalSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.insertBalSet.toArray(new DynamicObject[0]));
        }
        if (!this.updateBalMap.isEmpty()) {
            sql = "update t_cal_balance_fifo set fendqty = ?,fendcost = ?,fendunitcost = ? where fid = ?";
            paramList = new ArrayList<Object[]>(this.updateBalMap.size());
            for (Map.Entry<Long, Object[]> entry : this.updateBalMap.entrySet()) {
                long id = entry.getKey();
                Object[] o = entry.getValue();
                paramList.add(new Object[]{o[0], o[1], o[2], id});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
        if (!this.updateRptMap.isEmpty()) {
            sql = "update t_cal_balance_fifo set fcalrptid = ? where fid = ?";
            paramList = new ArrayList(this.updateRptMap.size());
            for (Map.Entry<Long, Object> entry : this.updateRptMap.entrySet()) {
                paramList.add(new Object[]{entry.getValue(), entry.getKey()});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
        if (!this.deleteBalSet.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_balance_fifo"), (Object[])this.deleteBalSet.toArray());
        }
    }

    private DataSet getBillDataSet(Long[] billIds, String entityName) {
        if ("cal_costrecord".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entry.accounttype", "=", (Object)AccountTypeEnum.FIN_FOUT.getValue());
            q.and("isinitbill", "=", (Object)false);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            if (this.billEntryIds != null) {
                q.and("entry.id", "in", (Object)this.billEntryIds);
            }
            if ("0".equals(this.opType) && CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
                q.and("entry.iscalculated", "=", (Object)Boolean.TRUE);
            }
            q.and("costaccount", "=", (Object)this.costAccountId);
            q.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
            q.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getCostRecordSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIN_FOUT.getValue());
            q.and("isupdatecost", "=", (Object)Boolean.TRUE);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getCostAdjustSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        if ("cal_initbill".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIN_FOUT.getValue());
            QFilter q1 = new QFilter("entryentity.baseqty", "!=", (Object)0);
            q1.or("entryentity.amount", "!=", (Object)0);
            q.and(q1);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBillSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBillSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        return null;
    }

    private void handleCalRangeDataSet(DataSet finalDataSet, DataSet calRangeDataSet, DataSet balDataSet) {
        finalDataSet = finalDataSet.groupBy(new String[]{"caldimension", "caldimensionstr"}).finish().select(new String[]{"caldimension", "caldimensionstr"});
        for (Row row : finalDataSet) {
            DataSet copyCalRangeDataSet = calRangeDataSet.copy();
            long caldimensionid = row.getLong("caldimension");
            copyCalRangeDataSet = copyCalRangeDataSet.filter("caldimension = " + caldimensionid);
            copyCalRangeDataSet = copyCalRangeDataSet.orderBy(new String[]{"bizdate", "auditdate", "billno", "entryseq", "costsubelement desc"});
            String fifoKey = "";
            String caldimension = row.getString("caldimensionstr");
            fifoKey = caldimensionid != 0L ? "calrange," + CommonUtils.trimComma((String)caldimension) : "calrange";
            fifoKey = fifoKey + ",costelement,costsubelement";
            String[] onFields = fifoKey.split(",");
            DataSet copyRCDataSet = balDataSet.copy();
            copyRCDataSet = copyRCDataSet.orderBy(new String[]{"bizdate", "auditdate", "billno", "entryseq"});
            copyCalRangeDataSet = copyCalRangeDataSet.orderBy(new String[]{"bizdate", "auditdate", "billno", "entryseq", "costsubelement desc"});
            copyCalRangeDataSet = copyCalRangeDataSet.select(this.getAliasSelects().split(","));
            List<String> allKeysSet = this.getAllKeys(onFields);
            HashMap<String, List<FiFoSelfBalInfo>> balDataMap = new HashMap<String, List<FiFoSelfBalInfo>>(16);
            for (Row calBalRow : copyRCDataSet) {
                String joinKey = this.getJoinKey(allKeysSet, calBalRow);
                FiFoSelfBalInfo selfBalInfo = new FiFoSelfBalInfo();
                selfBalInfo.setBalid((Long)calBalRow.get("id"));
                selfBalInfo.setEndqty((BigDecimal)calBalRow.get("endqty"));
                selfBalInfo.setEndcost((BigDecimal)calBalRow.get("endcost"));
                selfBalInfo.setEndunitcost((BigDecimal)calBalRow.get("endunitcost"));
                selfBalInfo.setCalrptid((Long)calBalRow.get("calrptid"));
                selfBalInfo.setBalbizdate((Date)calBalRow.get("bizdate"));
                selfBalInfo.setBalauditdate((Date)calBalRow.get("auditdate"));
                selfBalInfo.setBalbillno((String)calBalRow.get("billno"));
                selfBalInfo.setBalentryseq((Integer)calBalRow.get("entryseq"));
                selfBalInfo.setBalentryid((Long)calBalRow.get("entryid"));
                ArrayList<FiFoSelfBalInfo> balData = (ArrayList<FiFoSelfBalInfo>)balDataMap.get(joinKey);
                if (balData == null) {
                    balData = new ArrayList<FiFoSelfBalInfo>(16);
                    balData.add(selfBalInfo);
                    balDataMap.put(joinKey, balData);
                    continue;
                }
                balData.add(selfBalInfo);
            }
            this.cacheRpt(copyCalRangeDataSet.copy(), balDataMap, onFields, false);
            this.handleDetailDataSet(copyCalRangeDataSet, balDataMap, onFields);
        }
    }

    private void handleDivideDataSet(DataSet finalDataSet, DataSet divideDataSet, DataSet balDataSet) {
        finalDataSet = finalDataSet.groupBy(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"}).finish().select(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"});
        for (Row row : finalDataSet) {
            DataSet copyDivideDataSet = divideDataSet.copy();
            long dividebasisid = row.getLong("dividebasis");
            long caldimensionid = row.getLong("caldimension");
            String dividebasis = row.getString("dividebasisstr");
            copyDivideDataSet = copyDivideDataSet.filter("dividebasis = " + dividebasisid + " and caldimension = " + caldimensionid);
            copyDivideDataSet = copyDivideDataSet.orderBy(new String[]{"bizdate", "auditdate", "billno", "entryseq", "costsubelement desc"});
            String calKey = "";
            String caldimension = row.getString("caldimensionstr");
            calKey = caldimensionid != 0L ? CommonUtils.trimComma((String)dividebasis) + "," + CommonUtils.trimComma((String)caldimension) : CommonUtils.trimComma((String)dividebasis);
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            DataSet copyBalDataSet = balDataSet.copy();
            copyBalDataSet = copyBalDataSet.orderBy(new String[]{"bizdate", "auditdate", "billno", "entryseq"});
            copyDivideDataSet = copyDivideDataSet.orderBy(new String[]{"bizdate", "auditdate", "billno", "entryseq", "costsubelement desc"});
            copyDivideDataSet = copyDivideDataSet.select(this.getAliasSelects().split(","));
            List<String> allKeysSet = this.getAllKeys(onFields);
            HashMap<String, List<FiFoSelfBalInfo>> balDataMap = new HashMap<String, List<FiFoSelfBalInfo>>(16);
            for (Row calBalRow : copyBalDataSet) {
                String joinKey = this.getJoinKey(allKeysSet, calBalRow);
                FiFoSelfBalInfo selfBalInfo = new FiFoSelfBalInfo();
                selfBalInfo.setBalid((Long)calBalRow.get("id"));
                selfBalInfo.setEndqty((BigDecimal)calBalRow.get("endqty"));
                selfBalInfo.setEndcost((BigDecimal)calBalRow.get("endcost"));
                selfBalInfo.setEndunitcost((BigDecimal)calBalRow.get("endunitcost"));
                selfBalInfo.setCalrptid((Long)calBalRow.get("calrptid"));
                selfBalInfo.setBalbizdate((Date)calBalRow.get("bizdate"));
                selfBalInfo.setBalauditdate((Date)calBalRow.get("auditdate"));
                selfBalInfo.setBalbillno((String)calBalRow.get("billno"));
                selfBalInfo.setBalentryseq((Integer)calBalRow.get("entryseq"));
                selfBalInfo.setBalentryid((Long)calBalRow.get("entryid"));
                ArrayList<FiFoSelfBalInfo> balData = (ArrayList<FiFoSelfBalInfo>)balDataMap.get(joinKey);
                if (balData == null) {
                    balData = new ArrayList<FiFoSelfBalInfo>(16);
                    balData.add(selfBalInfo);
                    balDataMap.put(joinKey, balData);
                    continue;
                }
                balData.add(selfBalInfo);
            }
            this.cacheRpt(copyDivideDataSet.copy(), balDataMap, onFields, true);
            this.handleDetailDataSet(copyDivideDataSet, balDataMap, onFields);
        }
    }

    private void handleDetailDataSet(DataSet detailDataSet, Map<String, List<FiFoSelfBalInfo>> balData, String[] onFields) {
        block40: {
            FiFoBillInfo parentBillInfo;
            ArrayList<Long> entryIdList;
            HashMap<Long, ArrayList<FiFoBillInfo>> map;
            HashMap<Long, String> detailKeyMap;
            HashMap<Long, List<FiFoBalInfo>> balMap;
            block42: {
                block41: {
                    HashMap cacheBalMap = new HashMap();
                    balMap = new HashMap<Long, List<FiFoBalInfo>>();
                    ArrayList<FiFoBillInfo> billList = new ArrayList<FiFoBillInfo>();
                    detailKeyMap = new HashMap<Long, String>();
                    long lastDetailId = 0L;
                    String lastKey = "";
                    HashMap<Long, FiFoBillInfo> cacheBillMap = new HashMap<Long, FiFoBillInfo>();
                    for (Row row : detailDataSet) {
                        List<FiFoBalInfo> list;
                        String key = this.getGroupKey(row, onFields, true);
                        String parentKey = this.getGroupKey(row, onFields, false);
                        FiFoBillInfo billInfo = (FiFoBillInfo)cacheBillMap.get(row.getLong("entryid"));
                        if (billInfo == null) {
                            billInfo = this.buildBillInfo(row, parentKey);
                            cacheBillMap.put(row.getLong("entryid"), billInfo);
                        }
                        if (!detailKeyMap.containsKey(billInfo.getDetailId())) {
                            billList.add(billInfo);
                            detailKeyMap.put(billInfo.getDetailId(), key);
                        }
                        if ((list = (ArrayList<FiFoBalInfo>)cacheBalMap.get(key)) != null) {
                            balMap.put(billInfo.getDetailId(), list);
                        } else {
                            List<FiFoBalInfo> transfer;
                            List<String> allKeys = this.getAllKeys(onFields);
                            String joinKey = this.getJoinKey(allKeys, row);
                            List<FiFoSelfBalInfo> selfBalInfos = balData.get(joinKey);
                            list = (List)balMap.get(billInfo.getDetailId());
                            if (list != null) {
                                if (selfBalInfos != null && !selfBalInfos.isEmpty() && (transfer = this.transferBalInfo(selfBalInfos)) != null && !transfer.isEmpty()) {
                                    list.addAll(transfer);
                                }
                            } else {
                                list = new ArrayList<FiFoBalInfo>();
                                if (selfBalInfos != null && !selfBalInfos.isEmpty() && (transfer = this.transferBalInfo(selfBalInfos)) != null && !transfer.isEmpty()) {
                                    list.addAll(transfer);
                                }
                                balMap.put(billInfo.getDetailId(), list);
                            }
                        }
                        if (lastDetailId != 0L && lastDetailId != billInfo.getDetailId()) {
                            cacheBalMap.put(lastKey, balMap.get(lastDetailId));
                            if (lastKey.equals(key)) {
                                balMap.put(billInfo.getDetailId(), (List<FiFoBalInfo>)balMap.get(lastDetailId));
                            }
                        }
                        lastKey = key;
                        lastDetailId = billInfo.getDetailId();
                    }
                    if (billList.isEmpty()) break block40;
                    map = new HashMap<Long, ArrayList<FiFoBillInfo>>();
                    entryIdList = new ArrayList<Long>();
                    for (FiFoBillInfo billInfo : billList) {
                        ArrayList<FiFoBillInfo> list;
                        long entryId = billInfo.getBillEntryId();
                        if (!entryIdList.contains(entryId)) {
                            entryIdList.add(entryId);
                        }
                        if ((list = (ArrayList<FiFoBillInfo>)map.get(entryId)) != null) {
                            list.add(billInfo);
                            continue;
                        }
                        list = new ArrayList<FiFoBillInfo>();
                        list.add(billInfo);
                        map.put(entryId, list);
                    }
                    if (!"cal_costrecord".equals(this.entityName)) break block41;
                    for (Long entryId : entryIdList) {
                        Object billInfo2;
                        List list = (List)map.get(entryId);
                        parentBillInfo = (FiFoBillInfo)list.get(list.size() - 1);
                        if (this.isSync && this.errorMsgMap.containsKey(parentBillInfo.getKey())) {
                            this.putCalInTimeAllErr(parentBillInfo, null);
                            continue;
                        }
                        String queueType = parentBillInfo.getQueueType();
                        if ("0".equals(queueType)) {
                            parentBillInfo.setIgnoreZeroCost(parentBillInfo.isPresent());
                        } else {
                            BigDecimal baseQty = parentBillInfo.getQty();
                            List balList = (List)balMap.get(parentBillInfo.getDetailId());
                            parentBillInfo.setIgnoreZeroCost(false);
                            Object sumQty = BigDecimal.ZERO;
                            BigDecimal sumCost = BigDecimal.ZERO;
                            for (FiFoBalInfo balInfo : balList) {
                                sumQty = ((BigDecimal)sumQty).add(balInfo.getQty());
                                sumCost = sumCost.add(balInfo.getCost());
                                if (baseQty.compareTo((BigDecimal)sumQty) > 0) continue;
                                break;
                            }
                            if (((BigDecimal)sumQty).compareTo(BigDecimal.ZERO) != 0 && sumCost.compareTo(BigDecimal.ZERO) == 0) {
                                parentBillInfo.setIgnoreZeroCost(true);
                            }
                        }
                        if ("1".equals(this.opType)) {
                            if ("0".equals(queueType)) {
                                this.inBillFetchPrice(list, detailKeyMap, balMap);
                            } else {
                                this.outBillFetchPrice(list, detailKeyMap, balMap);
                            }
                        }
                        BigDecimal sumCost = BigDecimal.ZERO;
                        BigDecimal sumPrice = BigDecimal.ZERO;
                        for (Object billInfo2 : list) {
                            String key = (String)detailKeyMap.get(((FiFoBillInfo)billInfo2).getDetailId());
                            if (!this.isDetail(key)) continue;
                            BigDecimal billQty = ((FiFoBillInfo)billInfo2).getQty();
                            long subElementId = ((FiFoBillInfo)billInfo2).getCostSubElementId();
                            BigDecimal queueSign = ((FiFoBillInfo)billInfo2).getSignnum();
                            BigDecimal sign = new BigDecimal(billQty.signum()).multiply(queueSign);
                            BigDecimal actualCost = ((FiFoBillInfo)billInfo2).getCost();
                            BigDecimal unitCost = ((FiFoBillInfo)billInfo2).getPrice();
                            if (actualCost == null) {
                                actualCost = BigDecimal.ZERO;
                            }
                            if (unitCost == null) {
                                unitCost = BigDecimal.ZERO;
                            }
                            actualCost = actualCost.abs().multiply(sign).multiply(queueSign);
                            if (unitCost.signum() < 0) {
                                actualCost = actualCost.multiply(new BigDecimal(unitCost.signum()));
                            }
                            ((FiFoBillInfo)billInfo2).setCost(actualCost);
                            ((FiFoBillInfo)billInfo2).setPrice(unitCost);
                            parentBillInfo.addAllPriceTypeNames(((FiFoBillInfo)billInfo2).getPriceTypeNames());
                            parentBillInfo.addAllPriceTypes(((FiFoBillInfo)billInfo2).getPriceTypes());
                            sumCost = sumCost.add(actualCost);
                            sumPrice = sumPrice.add(unitCost);
                            if (((FiFoBillInfo)billInfo2).getPriceTypes().contains(BILL_PRICE)) continue;
                            BigDecimal wbActualCost = actualCost.abs().multiply(sign);
                            if (unitCost.signum() < 0) {
                                wbActualCost = actualCost.abs().multiply(sign).multiply(new BigDecimal(unitCost.signum()));
                            }
                            this.recordCostMap.put(entryId + "|" + subElementId, new BigDecimal[]{wbActualCost, unitCost});
                            this.costRecordEntrySet.add(entryId);
                            if (this.omInBills.contains(((FiFoBillInfo)billInfo2).getBizEntityObject())) {
                                this.omInCostRecordEntrys.add(entryId);
                                continue;
                            }
                            this.notOmInCostRecordEntrys.add(entryId);
                        }
                        parentBillInfo.setCost(sumCost);
                        parentBillInfo.setPrice(sumPrice);
                        HashMap<Long, FiFoBalInfo> detailBalMap = new HashMap<Long, FiFoBalInfo>();
                        billInfo2 = list.iterator();
                        while (billInfo2.hasNext()) {
                            FiFoBillInfo billInfo3 = (FiFoBillInfo)billInfo2.next();
                            String key = (String)detailKeyMap.get(billInfo3.getDetailId());
                            List balList = (List)balMap.get(billInfo3.getDetailId());
                            if (!this.isDetail(key)) continue;
                            this.calculate4CostRecordDetail(key, onFields, billInfo3, balList);
                            this.checkBalList(billInfo3, balList, detailBalMap);
                        }
                        String errorMsg = this.checkBillInfo(parentBillInfo);
                        if (this.isSync && !StringUtils.isEmpty((String)errorMsg)) {
                            this.errorMsgMap.put(parentBillInfo.getKey(), new Object[]{parentBillInfo.getBizBillId(), errorMsg, parentBillInfo.getBillNo(), parentBillInfo.getMaterialNum(), parentBillInfo.getCostAccountId(), parentBillInfo.getBillId(), parentBillInfo.getBillEntryId(), parentBillInfo.getMaterialId()});
                            this.putCalInTimeAllErr(parentBillInfo, errorMsg);
                            continue;
                        }
                        this.calculate4CostRecord((String)detailKeyMap.get(parentBillInfo.getDetailId()), parentBillInfo, (List)balMap.get(parentBillInfo.getDetailId()));
                        List parentBalList = (List)balMap.get(parentBillInfo.getDetailId());
                        String parentKey = (String)detailKeyMap.get(parentBillInfo.getDetailId());
                        FiFoBalInfo parentBalInfo = (FiFoBalInfo)parentBalList.get(parentBalList.size() - 1);
                        this.rptHolder.addRptEntry(parentKey, parentBillInfo, parentBalList, this.updateRptMap);
                        for (int j = 0; j < list.size() - 1; ++j) {
                            FiFoBillInfo billInfo4 = (FiFoBillInfo)list.get(j);
                            String key = (String)detailKeyMap.get(billInfo4.getDetailId());
                            List balList = (List)balMap.get(billInfo4.getDetailId());
                            this.rptHolder.addRptEntry(key, billInfo4, balList, this.updateRptMap);
                        }
                        this.calAdjBillEntry(parentBillInfo, detailBalMap, parentKey, parentBalInfo);
                    }
                    break block40;
                }
                if (!"cal_costadjustbill".equals(this.entityName) && !"cal_costadjust_subentity".equals(this.entityName)) break block42;
                for (Long entryId : entryIdList) {
                    List list = (List)map.get(entryId);
                    HashMap detailBalMap = new HashMap();
                    for (FiFoBillInfo billInfo : list) {
                        String key = (String)detailKeyMap.get(billInfo.getDetailId());
                        List balList = (List)balMap.get(billInfo.getDetailId());
                        if (billInfo.getCostRecordEntryId() != 0L && !balList.isEmpty()) {
                            List<FiFoBalInfo> copyBalList = this.createSortList4CostAdjust(billInfo.getCostRecordEntryId(), balList);
                            this.calculate4CostAdjust(key, onFields, billInfo, copyBalList);
                        } else {
                            this.calculate4CostAdjust(key, onFields, billInfo, balList);
                        }
                        if (!this.isDetail(key)) continue;
                        this.checkBalList(billInfo, balList, detailBalMap);
                    }
                    FiFoBillInfo parentBillInfo2 = (FiFoBillInfo)list.get(list.size() - 1);
                    List parentBalList = (List)balMap.get(parentBillInfo2.getDetailId());
                    String parentKey = (String)detailKeyMap.get(parentBillInfo2.getDetailId());
                    FiFoBalInfo parentBalInfo = (FiFoBalInfo)parentBalList.get(parentBalList.size() - 1);
                    this.rptHolder.addRptEntry(parentKey, parentBillInfo2, parentBalList, this.updateRptMap);
                    for (int j = 0; j < list.size() - 1; ++j) {
                        FiFoBillInfo billInfo = (FiFoBillInfo)list.get(j);
                        String key = (String)detailKeyMap.get(billInfo.getDetailId());
                        List balList = (List)balMap.get(billInfo.getDetailId());
                        this.rptHolder.addRptEntry(key, billInfo, balList, this.updateRptMap);
                    }
                    this.calAdjBillEntry(parentBillInfo2, detailBalMap, parentKey, parentBalInfo);
                }
                break block40;
            }
            if (!"cal_initbill".equals(this.entityName)) break block40;
            for (Long entryId : entryIdList) {
                List list = (List)map.get(entryId);
                for (FiFoBillInfo billInfo : list) {
                    String key = (String)detailKeyMap.get(billInfo.getDetailId());
                    List balList = (List)balMap.get(billInfo.getDetailId());
                    this.calculate4InitBill(key, onFields, billInfo, balList);
                }
                parentBillInfo = (FiFoBillInfo)list.get(list.size() - 1);
                List parentBalList = (List)balMap.get(parentBillInfo.getDetailId());
                String parentKey = (String)detailKeyMap.get(parentBillInfo.getDetailId());
                this.rptHolder.addRptEntry(parentKey, parentBillInfo, parentBalList, this.updateRptMap);
                for (int j = 0; j < list.size() - 1; ++j) {
                    FiFoBillInfo billInfo = (FiFoBillInfo)list.get(j);
                    String key = (String)detailKeyMap.get(billInfo.getDetailId());
                    List balList = (List)balMap.get(billInfo.getDetailId());
                    this.rptHolder.addRptEntry(key, billInfo, balList, this.updateRptMap);
                }
            }
        }
    }

    private void putCalInTimeAllErr(FiFoBillInfo parentBillInfo, String errorMsg) {
        if (!this.calInTimeRemoveAllErr) {
            return;
        }
        if (StringUtils.isEmpty((String)errorMsg)) {
            Object[] errorBillInfo = this.errorMsgMap.get(parentBillInfo.getKey());
            errorMsg = errorBillInfo == null ? "" : (String)errorBillInfo[1];
        }
        Object[] errBillInfo = new Object[]{parentBillInfo.getBizBillId(), errorMsg, parentBillInfo.getBillNo(), parentBillInfo.getMaterialNum(), parentBillInfo.getCostAccountId(), parentBillInfo.getBillId(), parentBillInfo.getBillEntryId(), parentBillInfo.getMaterialId()};
        String domainKeyBillId = parentBillInfo.getKey() + "," + parentBillInfo.getBizBillId();
        this.domainKeyBillIdBillInfoMap.put(domainKeyBillId, errBillInfo);
    }

    private void calAdjBillEntry(FiFoBillInfo parentBillInfo, Map<Long, FiFoBalInfo> detailBalMap, String parentKey, FiFoBalInfo parentBalInfo) {
        DynamicObject costAdjustbill = this.costAdjustMap.get(parentBillInfo.getBillId());
        DynamicObject costAdjustEntry = this.costAdjustEntryMap.get(parentBillInfo.getBillEntryId());
        if (costAdjustbill != null && costAdjustEntry != null) {
            parentBalInfo.setCost(parentBalInfo.getCost().add(costAdjustEntry.getBigDecimal("adjustamt").negate()));
            for (DynamicObject detail : costAdjustEntry.getDynamicObjectCollection("subentryentity")) {
                if (detail.getBigDecimal("sub_adjustamt").compareTo(BigDecimal.ZERO) == 0) continue;
                FiFoBalInfo detailBalInfo = detailBalMap.get(detail.getLong("id"));
                detailBalInfo.setCost(detailBalInfo.getCost().add(detail.getBigDecimal("sub_adjustamt").negate()));
                detailBalInfo.setPrice(this.getPriceStr(detailBalInfo, parentBillInfo.getPricePrecision()));
                this.updateBalMap.put(detailBalInfo.getBalId(), new Object[]{detailBalInfo.getQty(), detailBalInfo.getCost(), detailBalInfo.getPrice()});
            }
            this.rptHolder.addRptEntry4CostAdjust(parentKey, parentBillInfo, parentBalInfo, detailBalMap, costAdjustbill, costAdjustEntry);
        }
    }

    private void calculate4InitBill(String key, String[] onFields, FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        boolean isDetail = this.isDetail(key);
        if ("1".equals(this.opType)) {
            this.addBalList(key, billInfo, onFields, balList, isDetail);
        } else {
            this.delBalList4InitBill(key, billInfo, onFields, balList, isDetail);
        }
    }

    private void delBalList4InitBill(String key, FiFoBillInfo billInfo, String[] onFields, List<FiFoBalInfo> balList, boolean isDetail) {
        long entryId = billInfo.getBillEntryId();
        BigDecimal cost = billInfo.getCost();
        BigDecimal qty = billInfo.getQty();
        int removeIndex = -1;
        for (int i = 0; i < balList.size(); ++i) {
            FiFoBalInfo balInfo = balList.get(i);
            if (balInfo.getBillEntryId() != entryId || cost.compareTo(balInfo.getCost()) != 0 || qty.compareTo(balInfo.getQty()) != 0) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex != -1) {
            if (isDetail) {
                long balId = balList.get(removeIndex).getBalId();
                this.deleteBalSet.add(balId);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6570\u636e\u5df2\u51fa\u5e93\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FIFOCalculate_5", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        balList.remove(removeIndex);
    }

    private void sortBalList(List<FiFoBalInfo> balList) {
        Collections.sort(balList, new Comparator<FiFoBalInfo>(){

            @Override
            public int compare(FiFoBalInfo o1, FiFoBalInfo o2) {
                Date bizDate1 = o1.getBizDate();
                Date auditDate1 = o1.getAuditDate();
                String billNo1 = o1.getBillNo();
                int entrySeq1 = o1.getEntrySeq();
                Date bizDate2 = o2.getBizDate();
                Date auditDate2 = o2.getAuditDate();
                String billNo2 = o2.getBillNo();
                int entrySeq2 = o2.getEntrySeq();
                if (bizDate1.compareTo(bizDate2) > 0) {
                    return 1;
                }
                if (bizDate1.compareTo(bizDate2) < 0) {
                    return -1;
                }
                if (auditDate1.compareTo(auditDate2) > 0) {
                    return 1;
                }
                if (auditDate1.compareTo(auditDate2) < 0) {
                    return -1;
                }
                if (billNo1.compareTo(billNo2) > 0) {
                    return 1;
                }
                if (billNo1.compareTo(billNo2) < 0) {
                    return -1;
                }
                if (entrySeq1 > entrySeq2) {
                    return 1;
                }
                if (entrySeq1 < entrySeq2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private void checkBalList(FiFoBillInfo billInfo, List<FiFoBalInfo> balList, Map<Long, FiFoBalInfo> detailBalMap) {
        FiFoBalInfo lastBalInfo = balList.get(balList.size() - 1);
        BigDecimal balQty = lastBalInfo.getQty();
        BigDecimal balCost = lastBalInfo.getCost();
        BigDecimal newCost = null;
        if (balQty.signum() == 0 && balCost.signum() != 0) {
            newCost = BigDecimal.ZERO;
        }
        if (("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) && CostAdjustBilCreateTypeEnum.HAND.getValue().equals(billInfo.getCreateType()) || "cal_initbill".equals(this.entityName)) {
            return;
        }
        if (newCost != null) {
            this.loadBill4CreateAdj(this.billIds, this.entityName);
            BigDecimal adjustAmt = newCost.subtract(balCost).negate();
            DynamicObject costAdjustInfo = this.costAdjustMap.get(billInfo.getBillId());
            DynamicObject costAdjustEntry = this.costAdjustEntryMap.get(billInfo.getBillEntryId());
            DynamicObject loadBill = this.loadBillMap.get(billInfo.getBillId());
            DynamicObject loadEntry = this.loadEntryMap.get(billInfo.getBillEntryId());
            if (costAdjustInfo != null) {
                if (costAdjustEntry == null) {
                    costAdjustEntry = this.createCostAdjustEntry(loadBill, loadEntry, costAdjustInfo);
                    this.costAdjustEntryMap.put(billInfo.getBillEntryId(), costAdjustEntry);
                }
            } else {
                costAdjustInfo = this.createCostAdjustHead(loadBill);
                costAdjustEntry = this.createCostAdjustEntry(loadBill, loadEntry, costAdjustInfo);
                this.costAdjustMap.put(billInfo.getBillId(), costAdjustInfo);
                this.costAdjustEntryMap.put(billInfo.getBillEntryId(), costAdjustEntry);
            }
            DynamicObject detail = this.createCostAdjustDetail(costAdjustEntry, billInfo, adjustAmt);
            detailBalMap.put(detail.getLong("id"), lastBalInfo);
        }
    }

    private DynamicObject createCostAdjustHead(DynamicObject loadBill) {
        DynamicObject costAdjustInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustInfo.set("cstype", (Object)"bd_customer");
        if ("cal_costrecord".equals(this.entityName)) {
            costAdjustInfo.set("currency", loadBill.get("localcurrency_id"));
        } else {
            costAdjustInfo.set("currency", loadBill.get("currency_id"));
        }
        costAdjustInfo.set("id", (Object)DB.genLongId((String)"t_cal_costadjustbill"));
        costAdjustInfo.set("biztype", (Object)"B");
        costAdjustInfo.set("billstatus", (Object)"B");
        costAdjustInfo.set("difftype", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        costAdjustInfo.set("createtype", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getValue());
        costAdjustInfo.set("costaccount", (Object)loadBill.getLong("costaccount_id"));
        costAdjustInfo.set("calorg", (Object)this.calOrgId);
        costAdjustInfo.set("billtype", (Object)this.costAdjustOutBillType);
        Date date = TimeServiceHelper.now();
        costAdjustInfo.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustInfo.set("creator_id", (Object)userId);
        costAdjustInfo.set("auditdate", (Object)date);
        costAdjustInfo.set("auditor_id", (Object)userId);
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustInfo, (String)this.calOrgId.toString());
        costAdjustInfo.set("billno", (Object)number);
        if ("cal_initbill".equals(this.entityName)) {
            costAdjustInfo.set("period", (Object)this.curPeriodId);
            costAdjustInfo.set("bizdate", (Object)this.periodBeginDate);
            costAdjustInfo.set("bookdate", (Object)this.periodBeginDate);
        } else {
            costAdjustInfo.set("adminorg_id", (Object)loadBill.getLong("adminorg_id"));
            costAdjustInfo.set("bizdate", (Object)loadBill.getDate("bizdate"));
            costAdjustInfo.set("bookdate", (Object)loadBill.getDate("bookdate"));
        }
        return costAdjustInfo;
    }

    private DynamicObject createCostAdjustEntry(DynamicObject loadInfo, DynamicObject loadEntry, DynamicObject costAdjustInfo) {
        DynamicObject costAdjustEntry = costAdjustInfo.getDynamicObjectCollection("entryentity").addNew();
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityName);
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        long id = DB.genLongId((String)"t_cal_costadjustbillentry");
        costAdjustEntry.set("id", (Object)id);
        if ("cal_costrecord".equals(this.entityName)) {
            costAdjustEntry.set("storageorgunit", loadInfo.get("storageorgunit_id"));
        } else {
            costAdjustEntry.set("storageorgunit", loadEntry.get("storageorgunit_id"));
        }
        costAdjustEntry.set("material", loadEntry.get("material_id"));
        costAdjustEntry.set("lot", loadEntry.get("lot"));
        costAdjustEntry.set("warehouse", loadEntry.get("warehouse_id"));
        costAdjustEntry.set("location", loadEntry.get("location_id"));
        costAdjustEntry.set("ownertype", (Object)"bos_org");
        costAdjustEntry.set("owner", loadEntry.get("owner_id"));
        costAdjustEntry.set("ecostcenter", loadEntry.get("ecostcenter_id"));
        costAdjustEntry.set("assist", loadEntry.get("assist_id"));
        costAdjustEntry.set("invbilltype", loadInfo.get("billtype_id"));
        costAdjustEntry.set("invbillnum", (Object)loadInfo.getString("billno"));
        costAdjustEntry.set("inventryseq", loadEntry.get("seq"));
        costAdjustEntry.set("invbillid", loadInfo.get("id"));
        String entityObject = "";
        entityObject = this.entityName.equals("cal_costrecord") ? "cal_costrecord_subentity" : "cal_costadjust_subentity";
        costAdjustEntry.set("invbizentityobject", (Object)entityObject);
        costAdjustEntry.set("invbillentryid", loadEntry.get("id"));
        costAdjustEntry.set("baseunit", loadEntry.get("baseunit_id"));
        costAdjustEntry.set("project", loadEntry.get("project_id"));
        costAdjustEntry.set("invtype", loadEntry.get("invtype_id"));
        costAdjustEntry.set("invstatus", loadEntry.get("invstatus_id"));
        costAdjustEntry.set("mversion", loadEntry.get("mversion_id"));
        costAdjustEntry.set("tracknumber", loadEntry.get("tracknumber"));
        costAdjustEntry.set("configuredcode", loadEntry.get("configuredcode"));
        costAdjustEntry.set("noupdatecalfields", loadEntry.get("noupdatecalfields"));
        costAdjustEntry.set("stocktype", loadEntry.get("stocktype"));
        CommonSettingHelper.setExFieldValue((MainEntityType)costAdjustEntityType, (MainEntityType)billEntityType, (DynamicObject)costAdjustEntry, (DynamicObject)loadEntry);
        return costAdjustEntry;
    }

    private DynamicObject createCostAdjustDetail(DynamicObject costAdjustEntry, FiFoBillInfo billInfo, BigDecimal balCost) {
        DynamicObject detailInfo = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
        long id = DB.genLongId((String)"t_cal_costadjust_detail");
        detailInfo.set("id", (Object)id);
        detailInfo.set("sub_material", (Object)billInfo.getMaterialId());
        detailInfo.set("costelement", (Object)billInfo.getCostElementId());
        detailInfo.set("costsubelement", (Object)billInfo.getCostSubElementId());
        detailInfo.set("sub_currency", (Object)billInfo.getCurrencyId());
        detailInfo.set("sub_adjustamt", (Object)balCost);
        costAdjustEntry.set("adjustamt", (Object)costAdjustEntry.getBigDecimal("adjustamt").add(balCost));
        return detailInfo;
    }

    private List<FiFoBalInfo> createSortList4CostAdjust(long costRecordEntryId, List<FiFoBalInfo> balList) {
        ArrayList<FiFoBalInfo> copyBalList = new ArrayList<FiFoBalInfo>(balList.size());
        for (FiFoBalInfo info : balList) {
            copyBalList.add(info);
        }
        int j = -1;
        for (int i = 0; i < copyBalList.size(); ++i) {
            Long ancestorEntryId = this.costRecordChildMap.get(costRecordEntryId);
            if (costRecordEntryId != ((FiFoBalInfo)copyBalList.get(i)).getBillEntryId() && (ancestorEntryId == null || ancestorEntryId.longValue() != ((FiFoBalInfo)copyBalList.get(i)).getBillEntryId())) continue;
            j = i;
            break;
        }
        if (j != -1 && j != 0) {
            FiFoBalInfo info = (FiFoBalInfo)copyBalList.get(j);
            FiFoBalInfo lastInfo = (FiFoBalInfo)copyBalList.get(0);
            for (int i = 1; i <= j; ++i) {
                FiFoBalInfo preInfo = (FiFoBalInfo)copyBalList.get(i);
                copyBalList.set(i, lastInfo);
                lastInfo = preInfo;
            }
            copyBalList.set(0, info);
        }
        return copyBalList;
    }

    private BigDecimal getPriceStr(FiFoBalInfo balInfo, int pricePrecision) {
        if (balInfo.getCost() == null || balInfo.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.setScale(pricePrecision, 4);
        }
        if (balInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO.setScale(pricePrecision, 4);
        }
        BigDecimal price = balInfo.getCost().divide(balInfo.getQty(), pricePrecision, 4);
        return price;
    }

    private void calculate4CostAdjust(String key, String[] onFields, FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        boolean isDetail = this.isDetail(key);
        if (balList.isEmpty()) {
            this.addBalList(key, billInfo, onFields, balList, isDetail);
        } else {
            this.mergeBalList(billInfo, balList, isDetail);
        }
    }

    private void calculate4CostRecordDetail(String key, String[] onFields, FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        String queueType = billInfo.getQueueType();
        BigDecimal opType = billInfo.getOpType();
        BigDecimal qty = billInfo.getQty();
        if ("0".equals(queueType) && qty.multiply(opType).signum() > 0 || "1".equals(queueType) && qty.multiply(opType).signum() < 0) {
            this.addBalList(key, billInfo, onFields, balList, true);
        } else if ("0".equals(queueType) && qty.multiply(opType).signum() < 0 || "1".equals(queueType) && qty.multiply(opType).signum() > 0) {
            if (balList.isEmpty()) {
                this.addBalList(key, billInfo, onFields, balList, true);
            } else if ("0".equals(queueType) && qty.multiply(opType).signum() < 0) {
                List<FiFoBalInfo> copyBalList = this.createSortList4InBill(billInfo, balList);
                this.mergeBalList(billInfo, copyBalList, true);
            } else {
                this.mergeBalList(billInfo, balList, true);
            }
        }
    }

    private void calculate4CostRecord(String key, FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        String queueType = billInfo.getQueueType();
        BigDecimal opType = billInfo.getOpType();
        BigDecimal qty = billInfo.getQty();
        if ("0".equals(queueType) && qty.multiply(opType).signum() > 0 || "1".equals(queueType) && qty.multiply(opType).signum() < 0) {
            this.addBalList(key, billInfo, null, balList, false);
        } else if ("0".equals(queueType) && qty.multiply(opType).signum() < 0 || "1".equals(queueType) && qty.multiply(opType).signum() > 0) {
            if (balList.isEmpty()) {
                this.addBalList(key, billInfo, null, balList, false);
            } else if ("0".equals(queueType) && qty.multiply(opType).signum() < 0) {
                List<FiFoBalInfo> copyBalList = this.createSortList4InBill(billInfo, balList);
                this.mergeBalList(billInfo, copyBalList, false);
            } else {
                this.mergeBalList(billInfo, balList, false);
            }
        }
    }

    private List<FiFoBalInfo> createSortList4InBill(FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        ArrayList<FiFoBalInfo> copyBalList = new ArrayList<FiFoBalInfo>(balList.size());
        for (FiFoBalInfo info : balList) {
            copyBalList.add(info);
        }
        int j = -1;
        for (int i = 0; i < copyBalList.size(); ++i) {
            long entryId = billInfo.getBillEntryId();
            if (entryId != ((FiFoBalInfo)copyBalList.get(i)).getBillEntryId()) continue;
            j = i;
            break;
        }
        if (j != -1 && j != 0) {
            FiFoBalInfo info = (FiFoBalInfo)copyBalList.get(j);
            FiFoBalInfo lastInfo = (FiFoBalInfo)copyBalList.get(0);
            for (int i = 1; i <= j; ++i) {
                FiFoBalInfo preInfo = (FiFoBalInfo)copyBalList.get(i);
                copyBalList.set(i, lastInfo);
                lastInfo = preInfo;
            }
            copyBalList.set(0, info);
        }
        return copyBalList;
    }

    private String checkBillInfo(FiFoBillInfo billInfo) {
        if ("0".equals(this.opType)) {
            return "";
        }
        if (this.zeroInOutBizTypeIds.contains(billInfo.getBiztypeId()) && billInfo.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        String queueType = billInfo.getQueueType();
        BigDecimal unitActualCost = billInfo.getPrice();
        if (!(unitActualCost.compareTo(BigDecimal.ZERO) != 0 && unitActualCost.signum() >= 0 || billInfo.getPriceTypes().contains(GROUP_PRICE))) {
            StringBuilder msg = new StringBuilder();
            if ("0".equals(queueType) && !billInfo.isPresent() && !billInfo.isIgnoreZeroCost()) {
                msg.append(ResManager.loadKDString((String)"\u975e\u8d60\u54c1\u884c\u5165\u5e93\u5355\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u786e\u8ba4\u3002\u5efa\u8bae\u901a\u8fc7\u5355\u636e\u5f55\u5165\u5355\u4ef7\u91d1\u989d\u6216\u8005\u901a\u8fc7\u6838\u7b97\u914d\u7f6e-\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u5355\u636e\u540c\u6b65\u53d6\u4ef7\uff0c\u6216\u8005\u91c7\u7528\u975e\u5373\u65f6\u6838\u7b97\u7b97\u6cd5\uff1a%3$s\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"FIFOCalculate_14", (String)"fi-cal-business", (Object[])new Object[0]));
            } else if ("1".equals(queueType) && !billInfo.isIgnoreZeroCost()) {
                msg.append(ResManager.loadKDString((String)"\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u5355\u4ef7\u5f02\u5e38\uff0c\u6838\u7b97\u4e2d\u6b62\uff0c\u8bf7\u6838\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u53ca\u5355\u636e\uff0c\u786e\u4fdd\u6838\u7b97\u5355\u636e\u6570\u91cf\u91d1\u989d\u6b63\u786e\uff1a%3$s\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"FIFOCalculate_15", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            if ("1".equals(billInfo.getQueueType()) && billInfo.isIgnoreZeroCost()) {
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
                Long billEntryId = billInfo.getBillEntryId();
                if (billInfo.isInvTxZeroCost()) {
                    sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated(), billEntryId});
                    billInfo.setCostpricesource(CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                } else {
                    sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getDesignated(), billEntryId});
                    billInfo.setCostpricesource(CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue()));
                }
                if (sqlParams.size() > 0) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostPriceSourceTypeEnum.getCostpriceSourceSql(), sqlParams);
                }
            }
            if (msg.length() > 0) {
                String costAcctName = this.getCostAcctIdNameMap().get(billInfo.getCostAccountId());
                String costAcctNameMsg = "";
                if (StringUtils.isNotEmpty((String)costAcctName)) {
                    costAcctNameMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011", (String)"CalMoveAddAverageNewProcess_3", (String)"fi-cal-business", (Object[])new Object[0]);
                    costAcctNameMsg = String.format(costAcctNameMsg, costAcctName);
                }
                String format = String.format(msg.toString(), billInfo.getMaterialNum(), billInfo.getMaterialName(), costAcctNameMsg);
                if (this.isSync) {
                    return format;
                }
                throw new KDBizException(format);
            }
        }
        return "";
    }

    private void insertBalSet(String key, FiFoBillInfo billInfo, String[] onFields, long balId) {
        DynamicObject balInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_fifo");
        String[] keys = key.split(",");
        BigDecimal opType = billInfo.getOpType();
        BigDecimal sign = BigDecimal.ONE;
        String queueType = billInfo.getQueueType();
        if ("1".equals(queueType)) {
            sign = new BigDecimal("-1");
        }
        balInfo.set("id", (Object)balId);
        balInfo.set("costaccount", (Object)this.costAccountId);
        balInfo.set("calorg", (Object)this.calOrgId);
        balInfo.set("currency", (Object)billInfo.getCurrencyId());
        balInfo.set("baseunit", (Object)billInfo.getBaseUnitId());
        balInfo.set("material", (Object)billInfo.getMaterialId());
        balInfo.set("auditdate", (Object)billInfo.getAuditDate());
        balInfo.set("billno", (Object)billInfo.getBillNo());
        balInfo.set("billentryid", (Object)billInfo.getBillEntryId());
        balInfo.set("bizdate", (Object)billInfo.getBizDate());
        balInfo.set("endqty", (Object)billInfo.getQty().multiply(opType).multiply(sign));
        balInfo.set("endcost", (Object)billInfo.getCost().multiply(opType).multiply(sign));
        balInfo.set("endunitcost", (Object)billInfo.getPrice());
        balInfo.set("entryseq", (Object)billInfo.getEntrySeq());
        String rptKey = this.getRptKey(key);
        balInfo.set("calrptid", this.rptHolder.getRptMap().get(rptKey).get("id"));
        int i = 0;
        for (String field : onFields) {
            balInfo.set(field, (Object)keys[i + 1]);
            ++i;
        }
        this.insertBalSet.add(balInfo);
    }

    private void inBillFetchPrice(List<FiFoBillInfo> list, Map<Long, String> detailKeyMap, Map<Long, List<FiFoBalInfo>> balMap) {
        boolean isPur;
        FiFoBillInfo parentBillInfo = list.get(list.size() - 1);
        this.fetchPrice(list, detailKeyMap, balMap, GROUP_PRICE);
        if (!this.hasPrice(list, GROUP_PRICE)) {
            this.fetchPrice(list, detailKeyMap, balMap, INVENTORY_TRANSACTION_ZEROCOST);
        }
        if (!this.hasPrice(list, GROUP_PRICE, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, balMap, STRATEGY_SYNC_PRICE);
        }
        if (!this.hasPrice(list, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, balMap, BILL_PRICE);
        }
        boolean purZeroPrice = this.calOrgPurZeroCostMap.get(this.calOrgId);
        boolean bl = isPur = "im_purinbill".equals(parentBillInfo.getBizEntityObject()) || "im_mdc_ominbill".equals(parentBillInfo.getBizEntityObject()) || "im_ospurinbill".equals(parentBillInfo.getBizEntityObject());
        if (!this.hasPrice(list, GROUP_PRICE, STRATEGY_SYNC_PRICE, BILL_PRICE) && !parentBillInfo.isIgnoreZeroCost() && (!isPur || isPur && purZeroPrice)) {
            this.fetchPrice(list, detailKeyMap, balMap, FIFO_PRICE);
        }
    }

    private void outBillFetchPrice(List<FiFoBillInfo> list, Map<Long, String> detailKeyMap, Map<Long, List<FiFoBalInfo>> balMap) {
        this.fetchPrice(list, detailKeyMap, balMap, GROUP_PRICE);
        if (!this.hasPrice(list, GROUP_PRICE)) {
            this.fetchPrice(list, detailKeyMap, balMap, INVENTORY_TRANSACTION_ZEROCOST);
        }
        if (!this.hasPrice(list, GROUP_PRICE, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, balMap, STRATEGY_SYNC_PRICE);
        }
        if (!this.hasPrice(list, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, balMap, BILL_PRICE);
        }
        if (!this.hasPrice(list, GROUP_PRICE, STRATEGY_SYNC_PRICE, BILL_PRICE, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, balMap, FIFO_PRICE);
        }
    }

    private void fetchPrice(List<FiFoBillInfo> list, Map<Long, String> detailKeyMap, Map<Long, List<FiFoBalInfo>> balMap, String priceType) {
        StringBuilder costPriceSourceSb = new StringBuilder();
        HashSet<String> costPriceSourceSet = new HashSet<String>(16);
        String costPriceSourceStr = null;
        long entryId = 0L;
        FiFoBillInfo parentBillInfo = list.get(list.size() - 1);
        for (FiFoBillInfo billInfo : list) {
            String key = detailKeyMap.get(billInfo.getDetailId());
            entryId = billInfo.getBillEntryId();
            List<FiFoBalInfo> balList = balMap.get(billInfo.getDetailId());
            if (!this.isDetail(key)) continue;
            BigDecimal[] costs = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
            if (GROUP_PRICE.equals(priceType)) {
                costs = this.fetchGroupPrice(billInfo);
            } else if (INVENTORY_TRANSACTION_ZEROCOST.equals(priceType)) {
                FiFoBillInfo parentBill = list.get(list.size() - 1);
                if (billInfo.isInvTxZeroCost() || parentBill.isPresent() && "0".equals(parentBill.getQueueType())) {
                    parentBill.setIgnoreZeroCost(Boolean.TRUE);
                    costs[0] = BigDecimal.ZERO;
                    costs[1] = BigDecimal.ZERO;
                    billInfo.addPriceType(INVENTORY_TRANSACTION_ZEROCOST);
                    if (parentBill.isPresent() && "0".equals(parentBill.getQueueType())) {
                        billInfo.addPriceTypeName(this.presentPriceName);
                    } else if (billInfo.isInvTxZeroCost()) {
                        billInfo.addPriceTypeName(this.zeroCostPriceName);
                    }
                }
            } else if (STRATEGY_SYNC_PRICE.equals(priceType)) {
                costs = this.fetchSyncPrice(billInfo);
            } else if (BILL_PRICE.equals(priceType)) {
                if (billInfo.getPriceTypes().contains(GROUP_PRICE) || billInfo.getPriceTypes().contains(STRATEGY_SYNC_PRICE) || billInfo.getPriceTypes().contains(INVENTORY_TRANSACTION_ZEROCOST)) continue;
                costs = this.fetchBillPrice(billInfo);
            } else if (FIFO_PRICE.equals(priceType)) {
                costs = this.fetchFIFOPrice(billInfo, balList);
            }
            if (!billInfo.getPriceTypes().contains(priceType)) continue;
            billInfo.setCost(costs[0]);
            billInfo.setPrice(costs[1]);
            if (GROUP_PRICE.equals(priceType)) {
                String costpricesource = billInfo.getCostpricesource();
                costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource);
                String bizEntityObject = billInfo.getBizEntityObject();
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource)) continue;
                costPriceSourceSet.add(CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue());
                continue;
            }
            if (STRATEGY_SYNC_PRICE.equals(priceType)) {
                String bizEntityObject = billInfo.getBizEntityObject();
                String costpricesource = billInfo.getCostpricesource();
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)(costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource)))) continue;
                costPriceSourceSet.add(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                continue;
            }
            if (BILL_PRICE.equals(priceType) || INVENTORY_TRANSACTION_ZEROCOST.equals(priceType)) {
                costPriceSourceSet.add(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                continue;
            }
            if (!FIFO_PRICE.equals(priceType)) continue;
            costPriceSourceSet.add(CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue());
        }
        if (!costPriceSourceSet.isEmpty()) {
            for (String costPriceSource : costPriceSourceSet) {
                costPriceSourceSb.append(costPriceSource);
                costPriceSourceSb.append(",");
            }
        }
        if (costPriceSourceSb.length() > 0) {
            String costpricesource;
            boolean isUpdateFromExpCalcute;
            String costPriceSourceStrs;
            String costPriceSource;
            costPriceSourceStr = costPriceSourceSb.substring(0, costPriceSourceSb.length() - 1);
            String designated = "0";
            costPriceSource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costPriceSourceStr);
            CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue((String)costPriceSource);
            if (costPriceSourceTypeEnum != null) {
                designated = costPriceSourceTypeEnum.getDesignated();
            }
            if (StringUtils.isNotEmpty((String)(costPriceSourceStrs = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costPriceSourceStr))) && !(isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)this.auditType, (String)(costpricesource = parentBillInfo.getCostpricesource())))) {
                this.updateCostPricesParams.add(new Object[]{costPriceSourceStrs, designated, entryId});
                parentBillInfo.setCostpricesource(costPriceSourceStr);
            }
        }
    }

    private BigDecimal[] fetchGroupPrice(FiFoBillInfo billInfo) {
        BigDecimal billQty = billInfo.getQty();
        long calEntryId = billInfo.getCalEntryId();
        long eid = billInfo.getBillEntryId();
        long costaccount = billInfo.getCostAccountId();
        long costSubElement = billInfo.getCostSubElementId();
        int pricePrecision = billInfo.getPricePrecision();
        BigDecimal queueSign = billInfo.getSignnum();
        BigDecimal sign = new BigDecimal(billQty.signum()).multiply(queueSign);
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        if (this.isCalByCostElement) {
            actualCost = this.billGroupMap.get(costaccount + "|" + calEntryId + "|" + costSubElement);
        } else {
            BigDecimal gresource;
            BigDecimal gmanufactureCost;
            BigDecimal gprocessCost;
            BigDecimal gfee;
            String costAccountKey = costaccount + "|" + calEntryId;
            BigDecimal materialCost = billInfo.getMaterialCost();
            BigDecimal fee = billInfo.getFee();
            BigDecimal processCost = billInfo.getProcessCost();
            BigDecimal manufactureCost = billInfo.getManufactureCost();
            BigDecimal resource = billInfo.getResource();
            boolean isGroup = false;
            BigDecimal gmaterialCost = this.billGroupMap.get(costAccountKey + "|" + "materialcost");
            if (gmaterialCost != null) {
                materialCost = gmaterialCost;
                isGroup = true;
                BigDecimal unitMaterialCost = gmaterialCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitMaterialCost.signum());
                this.materialCostMap.put(eid, new BigDecimal[]{gmaterialCost.abs().multiply(sign).multiply(priceSignum), unitMaterialCost});
            }
            if ((gfee = this.billGroupMap.get(costAccountKey + "|" + "fee")) != null) {
                fee = gfee;
                isGroup = true;
                BigDecimal unitFee = gfee.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitFee.signum());
                this.feeMap.put(eid, new BigDecimal[]{gfee.abs().multiply(sign).multiply(priceSignum), unitFee});
            }
            if ((gprocessCost = this.billGroupMap.get(costAccountKey + "|" + "processcost")) != null) {
                processCost = gprocessCost;
                isGroup = true;
                BigDecimal unitProcessCost = gprocessCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitProcessCost.signum());
                this.processCostMap.put(eid, new BigDecimal[]{gprocessCost.abs().multiply(sign).multiply(priceSignum), unitProcessCost});
            }
            if ((gmanufactureCost = this.billGroupMap.get(costAccountKey + "|" + "manufacturecost")) != null) {
                manufactureCost = gmanufactureCost;
                isGroup = true;
                BigDecimal unitManufactureCost = gmanufactureCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitManufactureCost.signum());
                this.manufactureCostMap.put(eid, new BigDecimal[]{gmanufactureCost.abs().multiply(sign).multiply(priceSignum), unitManufactureCost});
            }
            if ((gresource = this.billGroupMap.get(costAccountKey + "|" + "resource")) != null) {
                resource = gresource;
                isGroup = true;
                BigDecimal unitResource = gresource.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitResource.signum());
                this.resourceMap.put(eid, new BigDecimal[]{gresource.abs().multiply(sign).multiply(priceSignum), unitResource});
            }
            if (isGroup) {
                actualCost = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource);
            }
        }
        if (actualCost != null) {
            unitCost = actualCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
            billInfo.addPriceType(GROUP_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchSyncPrice(FiFoBillInfo billInfo) {
        int amtPrecision = billInfo.getAmtPrecision();
        BigDecimal billQty = billInfo.getQty();
        long subElementId = billInfo.getCostSubElementId();
        long entryId = billInfo.getBillEntryId();
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        String costpricesource = billInfo.getCostpricesource();
        costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource);
        String bizEntityObject = billInfo.getBizEntityObject();
        if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource)) {
            return null;
        }
        CostPriceResultInfo result = this.billCostPriceMap.get(entryId);
        if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(subElementId)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = unitCost.multiply(billQty).setScale(amtPrecision, 4);
            String srcBillno = result.getSrcBillno();
            if (StringUtils.isNotEmpty((String)srcBillno)) {
                billInfo.addPriceTypeName(result.getSrcPriceName() + srcBillno);
            } else {
                billInfo.addPriceTypeName(result.getSrcPriceName());
            }
            billInfo.addPriceType(STRATEGY_SYNC_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchBillPrice(FiFoBillInfo billInfo) {
        BigDecimal billCost = billInfo.getCost();
        BigDecimal billPrice = billInfo.getPrice();
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        if (billCost.compareTo(BigDecimal.ZERO) != 0 || billPrice.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = billCost;
            unitCost = billPrice;
            billInfo.addPriceType(BILL_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchFIFOPrice(FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        List<BigDecimal> list = this.getFIFOPrice(billInfo, balList);
        actualCost = list.get(0);
        unitCost = list.get(1);
        if (actualCost != null && actualCost.compareTo(BigDecimal.ZERO) != 0 || unitCost != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
            billInfo.addPriceTypeName(this.realTimePriceName);
            billInfo.addPriceType(FIFO_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private boolean hasPrice(List<FiFoBillInfo> list, String ... priceType) {
        for (FiFoBillInfo info : list) {
            for (String type : priceType) {
                if (!info.getPriceTypes().contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    private List<BigDecimal> getFIFOPrice(FiFoBillInfo billInfo, List<FiFoBalInfo> balList) {
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        String queueType = billInfo.getQueueType();
        int pricePrecision = 10;
        int amtPrecision = billInfo.getAmtPrecision();
        BigDecimal opType = billInfo.getOpType();
        BigDecimal billQty = billInfo.getQty();
        BigDecimal sign = BigDecimal.ONE;
        if ("1".equals(queueType)) {
            sign = new BigDecimal("-1");
        }
        BigDecimal newCalQty = billQty.multiply(opType).multiply(sign);
        if ("0".equals(queueType)) {
            BigDecimal sumQty = BigDecimal.ZERO;
            BigDecimal sumCost = BigDecimal.ZERO;
            for (FiFoBalInfo balInfo : balList) {
                BigDecimal qty = balInfo.getQty();
                BigDecimal cost = balInfo.getCost();
                sumCost = sumCost.add(cost);
                sumQty = sumQty.add(qty);
            }
            BigDecimal bigDecimal = unitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 || sumCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumCost.divide(sumQty, pricePrecision, 4);
            if (unitCost.signum() <= 0) {
                for (int i = balList.size() - 1; i >= 0; --i) {
                    FiFoBalInfo balInfo;
                    balInfo = balList.get(i);
                    if (balInfo.getPrice().signum() <= 0) continue;
                    unitCost = balInfo.getPrice();
                    break;
                }
            }
            actualCost = billQty.multiply(unitCost).setScale(amtPrecision, 4);
        } else {
            BigDecimal sumCost;
            BigDecimal sumQty;
            boolean isAddPrice = false;
            for (FiFoBalInfo balInfo : balList) {
                boolean qtyIsZero;
                BigDecimal qty = balInfo.getQty();
                BigDecimal newQty = newCalQty.add(qty);
                boolean isNegPrice = balInfo.getPrice().signum() < 0;
                boolean bl = qtyIsZero = qty.compareTo(BigDecimal.ZERO) == 0 && balInfo.getCost().compareTo(BigDecimal.ZERO) != 0;
                if (isNegPrice || qtyIsZero) {
                    isAddPrice = true;
                }
                if (newQty.signum() >= 0) break;
                newCalQty = newQty;
            }
            BigDecimal calQty = billQty.multiply(opType).multiply(sign);
            if (!isAddPrice) {
                int i = 0;
                sumQty = BigDecimal.ZERO;
                sumCost = BigDecimal.ZERO;
                for (FiFoBalInfo balInfo : balList) {
                    BigDecimal qty = balInfo.getQty();
                    BigDecimal cost = balInfo.getCost();
                    BigDecimal newQty = calQty.add(qty);
                    if (newQty.signum() >= 0) {
                        actualCost = sumCost.add(billQty.subtract(sumQty).multiply(balInfo.getPrice()).setScale(amtPrecision, 4));
                        if (newQty.signum() == 0) {
                            actualCost = sumCost.add(cost);
                        }
                        if (actualCost.signum() * billQty.signum() >= 0) {
                            if (i == 0) {
                                unitCost = balInfo.getPrice();
                                break;
                            }
                            unitCost = actualCost.divide(billQty, pricePrecision, 4);
                            break;
                        }
                    } else {
                        calQty = newQty;
                        sumQty = sumQty.add(qty);
                        sumCost = sumCost.add(cost);
                    }
                    ++i;
                }
                if (unitCost == null || unitCost.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal bigDecimal = unitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 || sumCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumCost.divide(sumQty, pricePrecision, 4);
                    actualCost = billQty.compareTo(sumQty) == 0 ? sumCost : billQty.multiply(unitCost).setScale(amtPrecision, 4);
                }
            } else {
                int i = 0;
                sumQty = BigDecimal.ZERO;
                sumCost = BigDecimal.ZERO;
                for (FiFoBalInfo balInfo : balList) {
                    BigDecimal qty = balInfo.getQty();
                    BigDecimal cost = balInfo.getCost();
                    BigDecimal newQty = calQty.add(qty);
                    sumCost = sumCost.add(cost);
                    sumQty = sumQty.add(qty);
                    if (newQty.signum() >= 0 && sumCost.signum() * sumQty.signum() >= 0) {
                        unitCost = i == 0 ? balInfo.getPrice() : sumCost.divide(sumQty, pricePrecision, 4);
                        if (newQty.signum() == 0) {
                            actualCost = sumCost;
                            break;
                        }
                        actualCost = unitCost.multiply(billQty).setScale(amtPrecision, 4);
                        break;
                    }
                    calQty = newQty;
                    ++i;
                }
                if (unitCost == null || unitCost.compareTo(BigDecimal.ZERO) == 0) {
                    unitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 || sumCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumCost.divide(sumQty, pricePrecision, 4);
                    actualCost = billQty.compareTo(sumQty) == 0 ? sumCost : billQty.multiply(unitCost).setScale(amtPrecision, 4);
                }
            }
        }
        if (unitCost == null && actualCost == null) {
            billInfo.setHasRecentCost(false);
        } else {
            billInfo.setHasRecentCost(true);
        }
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        list.add(actualCost);
        list.add(unitCost);
        return list;
    }

    private String getRptKey(String key) {
        String rptkey = key.substring(0, key.lastIndexOf(44));
        rptkey = rptkey.substring(0, rptkey.lastIndexOf(44));
        return rptkey;
    }

    private FiFoBalInfo createBalInfo(FiFoBillInfo billInfo) {
        FiFoBalInfo balInfo = new FiFoBalInfo();
        BigDecimal opType = billInfo.getOpType();
        BigDecimal qty = billInfo.getQty();
        BigDecimal cost = billInfo.getCost();
        BigDecimal sign = BigDecimal.ONE;
        String queueType = billInfo.getQueueType();
        if ("1".equals(queueType)) {
            sign = new BigDecimal("-1");
        }
        balInfo.setQty(qty.multiply(opType).multiply(sign));
        balInfo.setCost(cost.multiply(opType).multiply(sign));
        balInfo.setBillEntryId(billInfo.getBillEntryId());
        balInfo.setAuditDate(billInfo.getAuditDate());
        balInfo.setBillNo(billInfo.getBillNo());
        balInfo.setBizDate(billInfo.getBizDate());
        balInfo.setEntrySeq(billInfo.getEntrySeq());
        balInfo.setPrice(billInfo.getPrice());
        long balId = DB.genLongId((String)"t_cal_balance_fifo");
        balInfo.setBalId(balId);
        return balInfo;
    }

    private FiFoBalInfo buildBalInfo(Row row) {
        if (row.getLong("balid") == null) {
            return null;
        }
        FiFoBalInfo info = new FiFoBalInfo();
        info.setBalId(row.getLong("balid"));
        info.setBillEntryId(row.getLong("balentryid"));
        info.setAuditDate(row.getDate("balauditdate"));
        info.setBillNo(row.getString("balbillno"));
        info.setBizDate(row.getDate("balbizdate"));
        info.setEntrySeq(row.getInteger("balentryseq"));
        info.setCost(row.getBigDecimal("endcost"));
        info.setQty(row.getBigDecimal("endqty"));
        info.setPrice(row.getBigDecimal("endunitcost"));
        return info;
    }

    private FiFoBillInfo buildBillInfo(Row row, String key) {
        FiFoBillInfo info = new FiFoBillInfo();
        BigDecimal signNum = row.getBigDecimal("signnum");
        info.setBillId(row.getLong("billid"));
        info.setBillEntryId(row.getLong("eid"));
        info.setAmtPrecision(row.getInteger("amtprecision"));
        info.setAuditDate(row.getDate("auditdate"));
        info.setKey(key);
        if ("cal_costrecord_subentity".equals(this.entityName) || "cal_costrecord".equals(this.entityName)) {
            info.setBizBillId(row.getLong("bizbillid"));
        }
        if ("cal_costrecord".equals(this.entityName)) {
            info.setBiztypeId(row.getLong("biztype"));
        }
        info.setBaseUnitId(row.getLong("baseunit"));
        info.setBillNo(row.getString("billno"));
        info.setBizDate(row.getDate("bizdate"));
        info.setCost(row.getBigDecimal("billcost").multiply(signNum));
        info.setCurrencyId(row.getLong("currency"));
        info.setEntrySeq(row.getInteger("entryseq"));
        info.setOpType("1".equals(this.opType) ? BigDecimal.ONE : new BigDecimal("-1"));
        info.setQty(row.getBigDecimal("billqty").multiply(signNum));
        info.setQtyPrecision(row.getInteger("qtyprecision"));
        info.setPrice(row.getBigDecimal("unitactualcost"));
        info.setQueueType(row.getString("queuetype"));
        info.setSignnum(row.getBigDecimal("signnum"));
        info.setMaterialId(row.getLong("material"));
        info.setDisplayPricePrecision(row.getInteger("displaypricepc"));
        info.setPricePrecision(10);
        String billTypeName = row.getString("billtypename");
        String invbillnum = row.getString("invbillnum");
        if (StringUtils.isNotEmpty((String)invbillnum)) {
            billTypeName = String.format(ResManager.loadKDString((String)"%1$s(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%2$s)", (String)"MoveAddAverageCalculate_13", (String)"fi-cal-business", (Object[])new Object[0]), billTypeName, invbillnum);
        }
        if ("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) {
            String createType = CostAdjustBilCreateTypeEnum.getEnumDesc((String)row.getString("createtype"));
            if (!StringUtils.isEmpty((String)createType)) {
                info.setCostpricesource(createType);
            }
            info.setCreateType(row.getString("createtype"));
        } else if ("cal_costrecord_subentity".equals(this.entityName) || "cal_costrecord".equals(this.entityName)) {
            info.setCostpricesource(row.getString("costpricesource"));
        }
        info.setBillTypeName(billTypeName);
        info.setBillTypeNum(row.getString("billtypenumber"));
        info.setBizEntityObject(row.getString("bizentityobject"));
        info.setCostRecordEntryId(row.getLong("costrecordentryid"));
        info.setCalEntryId(row.getLong("calentryid"));
        info.setDetailId(row.getLong("entryid"));
        info.setCostElementId(row.getLong("costelement"));
        info.setCostSubElementId(row.getLong("costsubelement"));
        info.setPresent(row.getBoolean("ispresent"));
        info.setMaterialName(row.getString("materialname"));
        info.setMaterialNum(row.getString("materialnum"));
        info.setFee(row.getBigDecimal("fee").multiply(signNum));
        info.setProcessCost(row.getBigDecimal("processcost").multiply(signNum));
        info.setManufactureCost(row.getBigDecimal("manufacturecost").multiply(signNum));
        info.setResource(row.getBigDecimal("resource").multiply(signNum));
        info.setMaterialCost(row.getBigDecimal("materialcost").multiply(signNum));
        info.setCostAccountId(row.getLong("costaccount"));
        info.setInvTxZeroCost(row.getBoolean("zerocost"));
        return info;
    }

    private boolean isDetail(String key) {
        String[] keys = key.split(",");
        String subElementId = keys[keys.length - 1];
        return !"-1".equals(subElementId);
    }

    private void addBalList(String key, FiFoBillInfo billInfo, String[] onFields, List<FiFoBalInfo> balList, boolean isDetail) {
        FiFoBalInfo balInfo = this.createBalInfo(billInfo);
        balList.add(balInfo);
        this.sortBalList(balList);
        if (isDetail) {
            this.insertBalSet(key, billInfo, onFields, balInfo.getBalId());
        }
    }

    private void mergeBalList(FiFoBillInfo billInfo, List<FiFoBalInfo> balList, boolean isDetail) {
        String queueType = billInfo.getQueueType();
        BigDecimal opType = billInfo.getOpType();
        BigDecimal qty = billInfo.getQty();
        BigDecimal cost = billInfo.getCost();
        BigDecimal sign = BigDecimal.ONE;
        if ("1".equals(queueType)) {
            sign = sign.multiply(new BigDecimal("-1"));
        }
        BigDecimal billQty = qty.multiply(opType).multiply(sign);
        BigDecimal billCost = cost.multiply(opType).multiply(sign);
        boolean isLast = false;
        for (int i = 0; i < balList.size(); ++i) {
            if (i == balList.size() - 1) {
                isLast = true;
            }
            FiFoBalInfo balInfo = balList.get(i);
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getCost();
            BigDecimal newQty = billQty.add(balQty);
            BigDecimal newCost = billCost.add(balCost);
            if (newQty.signum() >= 0) {
                balInfo.setQty(newQty);
                balInfo.setCost(newCost);
                balInfo.setPrice(this.getPriceStr(balInfo, billInfo.getPricePrecision()));
                if (!isDetail) break;
                this.updateBalMap.put(balInfo.getBalId(), new Object[]{balInfo.getQty(), balInfo.getCost(), balInfo.getPrice()});
                break;
            }
            billQty = newQty;
            billCost = newCost;
            if (!isLast) {
                balInfo.setQty(BigDecimal.ZERO);
                balInfo.setCost(BigDecimal.ZERO);
            } else {
                balInfo.setQty(newQty);
                balInfo.setCost(newCost);
            }
            balInfo.setPrice(this.getPriceStr(balInfo, billInfo.getPricePrecision()));
            if (!isDetail) continue;
            this.updateBalMap.put(balInfo.getBalId(), new Object[]{balInfo.getQty(), balInfo.getCost(), balInfo.getPrice()});
        }
    }

    private String getCostRecordSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        String entryName = "entry";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id as billid,bizbillid,billno as billno,bookdate as bizdate,billtype.number as billtypenumber,billtype.name as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entry.caldimension as caldimension,entry.caldimension.caldimension as caldimensionstr,auditdate,'0' as createtype,");
        selects.append("entry.baseqty as billqty,entry.material as material,entry.material.name as materialname,entry.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,entry.signnum as signnum,");
        selects.append("entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,entry.calrange as calrange,entry.calentryid as calentryid,entry.queuetype as queuetype,bizentityobject.number as bizentityobject,period as period,entry.ispresent as ispresent,entry.seq as entryseq,0 as costrecordentryid,0 as costrecordid");
        selects.append(",entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource,entry.materialcost as materialcost,biztype,costaccount.calorg as calorgid,entry.costpricesource as costpricesource,'' as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entry.subentrycostelement.costelement) as costelement,to_char(entry.subentrycostelement.costsubelement) as costsubelement,entry.subentrycostelement.sub_actualcost billcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost,entry.subentrycostelement.id as entryid,entry.id as eid,invscheme.zerocost as zerocost");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entry.actualcost as billcost,entry.unitactualcost as unitactualcost,entry.id as entryid,entry.id as eid,invscheme.zerocost as zerocost");
        }
        return selects.toString();
    }

    private String getCostAdjustSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"MoveAddAverageCalculate_1", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,0L as bizbillid,billno as billno,entryentity.invbizdate as bizdate,'cal_costadjustbill' as billtypenumber,'").append(s).append("' as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,createtype,");
        selects.append("0 as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,currency as currency,10 as priceprecision,currency.amtprecision as amtprecision,currency.priceprecision as displaypricepc,entryentity.signnum as signnum,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,entryentity.queuetype as queuetype,'cal_costadjustbill' as bizentityobject,0 as unitactualcost,0 as period,'0' as ispresent,entryentity.seq as entryseq,entryentity.invbillentryid as costrecordentryid,entryentity.invbillid as costrecordid");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,' ' as costpricesource,entryentity.invbillnum as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_adjustamt billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.adjustamt as billcost,entryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
        }
        return selects.toString();
    }

    private String getInitBillSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355", (String)"FIFOCalculate_6", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,0L as bizbillid,billno as billno,bookdate as bizdate,'cal_initbill' as billtypenumber,'").append(s).append("' as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,'0' as createtype,");
        selects.append("entryentity.baseqty as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,1 as signnum,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,'0' as queuetype,'cal_initbill' as bizentityobject,0 as period,'0' as ispresent,entryentity.seq as entryseq,'0' as costrecordentryid,0 as costrecordid");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,'' as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.sub_price as unitactualcost,entryentity.subentryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
            if (this.enableStd) {
                selects.append(",entryentity.subentryentity.sub_costdiff as costdiff");
            }
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.amount as billcost,entryentity.price as unitactualcost,entryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
            if (this.enableStd) {
                selects.append(",entryentity.costdiff as costdiff");
            }
        }
        return selects.toString();
    }

    private String getAliasSelects() {
        StringBuilder selects = new StringBuilder();
        selects.append(this.totalKey);
        selects.append(",billid,bizbillid,billno,bizdate,billtypenumber,billtypename,costaccount,entryid,dividebasis,dividebasisstr,");
        selects.append("caldimension,caldimensionstr,auditdate,period,ispresent,entryseq,queuetype,signnum,createtype,");
        selects.append("billqty,billcost,material,materialname,materialnum,currency,priceprecision,amtprecision,displaypricepc,baseunit,qtyprecision,costrecordentryid,costrecordid,");
        selects.append("fee,processcost,manufacturecost,resource,materialcost,invbillnum,");
        selects.append("calrange,calentryid,bizentityobject,unitactualcost,costelement,costsubelement,eid,zerocost");
        if ("cal_costrecord".equals(this.entityName)) {
            selects.append(",costpricesource");
            selects.append(",biztype");
            selects.append(",calorgid");
        }
        return selects.toString();
    }

    private String getInitCalAliasSelects() {
        StringBuilder selects = new StringBuilder();
        selects.append(this.totalKey);
        selects.append(",billid,bizbillid,billno,bizdate,billtypenumber,billtypename,costaccount,entryid,dividebasis,dividebasisstr");
        selects.append(",caldimension,caldimensionstr,auditdate,period,ispresent,entryseq,queuetype,signnum,createtype");
        selects.append(",billqty,material,materialname,materialnum,currency,priceprecision,amtprecision");
        selects.append(",displaypricepc,baseunit,qtyprecision,costrecordentryid,costrecordid,costdiff");
        selects.append(",fee,processcost,manufacturecost,resource,materialcost");
        selects.append(",calrange,calentryid,bizentityobject,costelement,costsubelement,eid,zerocost,' ' as costpricesource,'' as invbillnum");
        return selects.toString();
    }

    private void cacheRpt(DataSet detailDataSet, Map<String, List<FiFoSelfBalInfo>> balData, String[] onFields, boolean isEmptyRange) {
        for (Row row : detailDataSet) {
            List<String> allKeys = this.getAllKeys(onFields);
            String joinKey = this.getJoinKey(allKeys, row);
            List<FiFoSelfBalInfo> selfBalInfos = balData.get(joinKey);
            String key = this.getGroupKey(row, onFields, false);
            int limit = balData.get(joinKey) == null || balData.get(joinKey).isEmpty() ? 0 : balData.get(joinKey).size();
            int index = 0;
            do {
                FiFoSelfBalInfo selfBalInfo = balData.get(joinKey) == null || balData.get(joinKey).isEmpty() ? null : selfBalInfos.get(index);
                long calrptid = selfBalInfo == null ? 0L : selfBalInfo.getCalrptid();
                this.rptHolder.createOrUpdateRpt(calrptid, key, onFields, row, isEmptyRange);
            } while (++index < limit);
        }
    }

    private String getGroupKey(Row row, String[] onFields, boolean hasCostElement) {
        StringBuilder key = new StringBuilder();
        long material = row.getLong("material");
        key.append(material).append(',');
        for (String field : onFields) {
            Object value = row.get(field);
            if ("".equals(value)) {
                value = " ";
            }
            if ("costelement".equals(field) || "costsubelement".equals(field)) {
                if (!hasCostElement) continue;
                key.append(value).append(',');
                continue;
            }
            key.append(value).append(',');
        }
        return key.substring(0, key.length() - 1);
    }

    private void cacheBillGroup(DataSet dataSet) {
        if ("cal_costrecord".equals(this.entityName)) {
            HashMap costAccount_calEntryIdMap = new HashMap();
            for (Row row : dataSet) {
                long costAccount = row.getLong("costaccount");
                long calentryId = row.getLong("calentryid");
                long period = row.getLong("period");
                if (costAccount_calEntryIdMap.containsKey(costAccount + "|" + period)) {
                    ((Set)costAccount_calEntryIdMap.get(costAccount + "|" + period)).add(calentryId);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(calentryId);
                costAccount_calEntryIdMap.put(costAccount + "|" + period, set);
            }
            for (Map.Entry entry : costAccount_calEntryIdMap.entrySet()) {
                String key = (String)entry.getKey();
                Map<String, BigDecimal> map = GroupRelationCostCalculator.calculateCost(key.split("\\|")[0], Long.parseLong(key.split("\\|")[1]), (Set)entry.getValue());
                this.billGroupMap.putAll(map);
            }
            logger.info("\u6210\u7ec4\u5173\u7cfb\u83b7\u53d6\uff1a" + this.billGroupMap);
        }
    }

    private void cacheCostPrice(DataSet dataSet) {
        if ("cal_costrecord".equals(this.entityName)) {
            HashMap entityObject_entryIdMap = new HashMap();
            for (Row row : dataSet) {
                long entryId = row.getLong("eid");
                String bizEntityObject = row.getString("bizentityobject");
                ArrayList<Long> list = (ArrayList<Long>)entityObject_entryIdMap.get(bizEntityObject);
                if (list != null) {
                    if (list.contains(entryId)) continue;
                    list.add(entryId);
                    continue;
                }
                list = new ArrayList<Long>();
                list.add(entryId);
                entityObject_entryIdMap.put(bizEntityObject, list);
            }
            for (Map.Entry entry : entityObject_entryIdMap.entrySet()) {
                CostPrice4Others priceHelper = new CostPrice4Others();
                String bizEntityObject = (String)entry.getKey();
                QFilter qFilter = new QFilter("priceobject", "=", (Object)"C");
                qFilter.and("entityobject", "=", (Object)bizEntityObject);
                CostPriceResultInfo[] resultList = priceHelper.getPrice4MoveAddAverage((List)entry.getValue(), qFilter, this.billIds);
                if (resultList == null) continue;
                for (CostPriceResultInfo result : resultList) {
                    if (!result.isDetail() || !result.isSuccess()) continue;
                    this.billCostPriceMap.put(result.getEntryId(), result);
                }
            }
            logger.info("\u53d6\u4ef7\u83b7\u53d6\uff1a" + this.billCostPriceMap);
        }
    }

    public void putGroupCost(Map<String, BigDecimal> groupCost) {
        this.billGroupMap.putAll(groupCost);
    }

    public void setBillEntryIds(Long[] billEntryIds) {
        this.billEntryIds = billEntryIds;
    }

    public void setCostAcctIdNameMap(Map<Long, String> costAcctIdNameMap) {
        this.costAcctIdNameMap = costAcctIdNameMap;
    }

    public Map<Long, String> getCostAcctIdNameMap() {
        return this.costAcctIdNameMap;
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    private boolean isBalListZero(List<FiFoBalInfo> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (FiFoBalInfo info : list) {
            if (info.getCost().compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private List<FiFoBalInfo> transferBalInfo(List<FiFoSelfBalInfo> selfBalInfos) {
        if (selfBalInfos == null || selfBalInfos.isEmpty()) {
            return new ArrayList<FiFoBalInfo>();
        }
        ArrayList<FiFoBalInfo> result = new ArrayList<FiFoBalInfo>(selfBalInfos.size());
        for (FiFoSelfBalInfo selfBalInfo : selfBalInfos) {
            result.add(this.buildBalInfoNew(selfBalInfo));
        }
        return result;
    }

    private FiFoBalInfo buildBalInfoNew(FiFoSelfBalInfo row) {
        if (row.getBalid() == null) {
            return null;
        }
        FiFoBalInfo info = new FiFoBalInfo();
        info.setBalId(row.getBalid());
        info.setDbRptId(row.getCalrptid());
        info.setBillEntryId(row.getBalentryid());
        info.setAuditDate(row.getBalauditdate());
        info.setBillNo(row.getBalbillno());
        info.setBizDate(row.getBalbizdate());
        info.setEntrySeq(row.getBalentryseq());
        info.setCost(row.getEndcost());
        info.setQty(row.getEndqty());
        info.setPrice(row.getEndunitcost());
        return info;
    }

    private String getJoinKey(List<String> allKeysSet, Row calBalRow) {
        StringBuilder sb = new StringBuilder();
        for (String onField : allKeysSet) {
            Object o = calBalRow.get(onField);
            sb.append(o).append("#");
        }
        return sb.toString();
    }

    private List<String> getAllKeys(String[] onFields) {
        ArrayList<String> allKeys = new ArrayList<String>(Arrays.asList(onFields));
        allKeys.add("costaccount");
        allKeys.add("material");
        return allKeys;
    }

    private void loadBill4CreateAdj(Long[] billIds, String entityName) {
        DynamicObject[] infos;
        if (this.loadBillMap.size() > 0) {
            return;
        }
        for (DynamicObject info : infos = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName))) {
            this.loadBillMap.put(info.getLong("id"), info);
            for (DynamicObject entry : info.getDynamicObjectCollection(this.entryName)) {
                this.loadEntryMap.put(entry.getLong("id"), entry);
            }
        }
    }
}

