/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AddDomainKeyFunction;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;

public class FIFOPeriodDataCalculate {
    private long costAccountId;
    private long curPeriodId;
    private long prePeriodId;
    private int periodNum;
    private String dimFields;
    private Set<Long> materialSet;
    private Set<DynamicObject> insertBalSet = new HashSet<DynamicObject>();
    private String totalKey;
    private boolean isStartPeriod;
    private long calOrgId;
    private Set<Long> emptyRangeIds;

    public FIFOPeriodDataCalculate(long costAccountId, Set<Long> materialSet) {
        this.costAccountId = costAccountId;
        this.materialSet = materialSet;
        this.initBalanceDimFields();
        DynamicObject calSetInfo = QueryServiceHelper.queryOne((String)"cal_setting", (String)"dividebasiscols,caldimensioncols", (QFilter[])new QFilter("id", "=", (Object)683799445774680063L).toArray());
        String divideStr = calSetInfo.getString("dividebasiscols");
        String caldimensionStr = calSetInfo.getString("caldimensioncols");
        this.totalKey = CommonUtils.trimComma((String)divideStr) + "," + CommonUtils.trimComma((String)caldimensionStr);
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (curPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\uff0c\u53ef\u80fd\u8fd8\u672a\u542f\u7528\u3002", (String)"CostRecordBuilder_5", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DynamicObject startPeriod = PeriodHelper.getStartPeriod((Long)costAccountId);
        this.curPeriodId = curPeriod.getLong("id");
        this.isStartPeriod = this.curPeriodId == startPeriod.getLong("id");
        this.periodNum = curPeriod.getInt("periodyear") * 100 + curPeriod.getInt("periodnumber");
        if (!this.isStartPeriod) {
            DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)this.curPeriodId);
            this.prePeriodId = prePeriod.getLong("id");
        }
        this.calOrgId = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter("id", "=", (Object)costAccountId).toArray()).getLong("calorg");
        this.emptyRangeIds = this.getEmptyEntryRangeIds();
    }

    private Set<Long> getEmptyEntryRangeIds() {
        QFilter filter = new QFilter("costaccount", "=", (Object)this.costAccountId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        if (emptyEntryRangeIds.isEmpty()) {
            emptyEntryRangeIds.add(-1L);
        }
        return emptyEntryRangeIds;
    }

    public void reCalBeginData() {
        try (DataSet balDataSet = this.getBalDataSet();
             DataSet billDataSet = this.getBillDataSet();){
            DataSet newBalDataSet = balDataSet.map((MapFunction)new AddDomainKeyFunction(this.emptyRangeIds, balDataSet.getRowMeta(), null, null, null, null, "domainkeyfield"));
            newBalDataSet = newBalDataSet.groupBy(new String[]{"domainkeyfield", "costelement", "costsubelement"}).sum("balqty").sum("balcost").finish();
            DataSet newbillDataSet = billDataSet.map((MapFunction)new AddDomainKeyFunction(this.emptyRangeIds, billDataSet.getRowMeta(), null, null, null, null, "domainkeyfield"));
            JoinDataSet joinDataSet = newBalDataSet.join(newbillDataSet);
            joinDataSet = joinDataSet.on("domainkeyfield", "domainkeyfield");
            joinDataSet = joinDataSet.on("costelement", "costelement");
            joinDataSet = joinDataSet.on("costsubelement", "costsubelement");
            DataSet finalDataSet = joinDataSet.select(new String[]{"domainkeyfield", "balqty", "balcost"}, new String[]{"id as billid", "detailid", "entityobject", "calbilltype", "bizdate", "billno", "auditdate", "entryseq", "costelement", "costsubelement", "entryid", "billqty", "billcost", "billunitcost", "priceprecision", "amtprecision", "qtyprecision"}).finish().orderBy(new String[]{"domainkeyfield", "costelement", "costsubelement", "bizdate desc", "auditdate desc", "billno desc", "entryseq desc"});
            HashMap map = new HashMap(512);
            for (Row row : finalDataSet) {
                BalInfo balInfo = new BalInfo();
                String key = row.getString("domainkeyfield") + row.getLong("costelement") + row.getLong("costsubelement");
                balInfo.setBalId(key);
                balInfo.setQty(row.getBigDecimal("balqty"));
                balInfo.setCost(row.getBigDecimal("balcost"));
                BigDecimal bigDecimal = row.getBigDecimal("balqty");
                ArrayList<BillInfo> list = (ArrayList<BillInfo>)map.get(balInfo);
                if (list == null) {
                    list = new ArrayList<BillInfo>(64);
                    map.put(balInfo, list);
                }
                String entityObject = row.getString("entityobject");
                String calbillType = row.getString("calbilltype");
                BigDecimal billQty = row.getBigDecimal("billqty");
                String billType = "";
                if ("calinitbill".equals(entityObject) || "IN".equals(calbillType) && billQty.signum() > 0 || "OUT".equals(calbillType) && billQty.signum() < 0) {
                    billType = "IN";
                }
                if ("OUT".equals(calbillType) && billQty.signum() > 0 || "IN".equals(calbillType) && billQty.signum() < 0) {
                    billType = "OUT";
                }
                if ((bigDecimal.signum() < 0 || !"IN".equals(billType)) && (bigDecimal.signum() >= 0 || !"OUT".equals(billType))) continue;
                BillInfo billInfo = new BillInfo();
                list.add(billInfo);
                billInfo.setDetailId(row.getLong("detailid"));
                billInfo.setBillId(row.getLong("billid"));
                billInfo.setQty(billQty);
                billInfo.setCost(row.getBigDecimal("billcost"));
                billInfo.setPrice(row.getBigDecimal("billunitcost"));
                billInfo.setAmtPrecision(row.getInteger("amtprecision"));
                billInfo.setPricePrecision(row.getInteger("priceprecision"));
                billInfo.setQtyPrecision(row.getInteger("qtyprecision"));
            }
            HashSet<Long> detailIdSet = new HashSet<Long>(map.size());
            HashSet<Long> billIdSet = new HashSet<Long>(map.size());
            HashMap<Long, BigDecimal[]> costMap = new HashMap<Long, BigDecimal[]>(map.size());
            block19: for (Map.Entry entry : map.entrySet()) {
                BalInfo balInfo = (BalInfo)entry.getKey();
                List list = (List)entry.getValue();
                if (list == null || list.isEmpty()) continue;
                BigDecimal balQty = balInfo.getQty().abs();
                BigDecimal balCost = balInfo.getCost();
                BigDecimal sumQty = BigDecimal.ZERO;
                BigDecimal sumCost = BigDecimal.ZERO;
                for (BillInfo billInfo : list) {
                    detailIdSet.add(billInfo.getDetailId());
                    billIdSet.add(billInfo.getBillId());
                    costMap.put(billInfo.getDetailId(), new BigDecimal[]{billInfo.getQty().abs().multiply(new BigDecimal(balInfo.getQty().signum())), billInfo.getCost().abs().multiply(new BigDecimal(balInfo.getQty().signum())), billInfo.getPrice()});
                    BigDecimal billQty = billInfo.getQty().abs();
                    BigDecimal billCost = billInfo.getCost().abs().multiply(new BigDecimal(balInfo.getQty().signum()));
                    int pricePrecision = billInfo.getPricePrecision();
                    sumQty = sumQty.add(billQty);
                    if (sumQty.compareTo(balQty) >= 0) {
                        BigDecimal newBillQty = balQty.subtract(sumQty.subtract(billQty)).multiply(new BigDecimal(balInfo.getQty().signum()));
                        BigDecimal newBillCost = balCost.subtract(sumCost);
                        BigDecimal newBillPrice = newBillQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : newBillCost.divide(newBillQty, pricePrecision, 4);
                        costMap.put(billInfo.getDetailId(), new BigDecimal[]{newBillQty, newBillCost, newBillPrice});
                        continue block19;
                    }
                    sumCost = sumCost.add(billCost);
                }
            }
            if (!detailIdSet.isEmpty()) {
                DataSet costRecordDataSet = this.getUnionDataSet(detailIdSet.toArray(new Long[0]), billIdSet, null);
                this.insertFIFOBalance(costRecordDataSet, costMap);
            }
        }
    }

    public void updateFIFOBalDivideFields(Set<Long> detailIdSet, Set<Long> entryIdSet, Set<Long> billIdSet) {
        DataSet costRecordDataSet = this.getUnionDataSet(detailIdSet.toArray(new Long[0]), billIdSet, null);
        QFilter q = new QFilter("billentryid", "in", entryIdSet);
        DataSet fifoBalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_fifo_period", (String)"id as fifoid,billentryid,costsubelement as fifosubelement", (QFilter[])q.toArray(), null);
        DataSet joinSet = fifoBalDataSet.join(costRecordDataSet).on("billentryid", "eid").on("fifosubelement", "costsubelement").select(new String[]{"billentryid", "fifosubelement"}, costRecordDataSet.getRowMeta().getFieldNames()).finish();
        HashMap<String, StringBuilder> calKeyMap = new HashMap<String, StringBuilder>(8);
        HashMap paramListMap = new HashMap(8);
        MainEntityType fifoEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_balance_fifo_period");
        for (Row row : joinSet) {
            ArrayList<Object[]> paramList;
            Long billEntryId = row.getLong("billentryid");
            Long costsubelement = row.getLong("fifosubelement");
            Long calrange = row.getLong("calrange");
            long caldimensionid = row.getLong("caldimension");
            String dividebasis = row.getString("dividebasisstr");
            String caldimension = row.getString("caldimensionstr");
            String calKey = "";
            calKey = caldimensionid != 0L ? CommonUtils.trimComma((String)dividebasis) + "," + CommonUtils.trimComma((String)caldimension) : CommonUtils.trimComma((String)dividebasis);
            String[] calKeys = calKey.split(",");
            StringBuilder updateSql = (StringBuilder)calKeyMap.get(calKey);
            if (updateSql == null) {
                updateSql = new StringBuilder();
                StringBuilder updateFields = new StringBuilder();
                for (String field : calKeys) {
                    IDataEntityProperty fieldProperty = fifoEntityType.findProperty(field);
                    if (fieldProperty == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u5148\u8fdb\u5148\u51fa\u4f59\u989d\u8868\uff08\u6708\u672b\uff09\u627e\u4e0d\u5230\u8be5\u5b57\u6bb5%1$s", (String)"FIFOPeriodDataCalculate_0", (String)"fi-cal-business", (Object[])new Object[0]), field));
                    }
                    updateFields.append(fieldProperty.getAlias()).append(" = ?,");
                }
                updateSql.append("update t_cal_bal_fifo_period set ").append((CharSequence)updateFields).append("fcalrangeid = ? where fbillentryid = ? and fcostsubelementid = ?");
                calKeyMap.put(calKey, updateSql);
            }
            if ((paramList = (ArrayList<Object[]>)paramListMap.get(calKey)) == null) {
                paramList = new ArrayList<Object[]>(16);
                paramListMap.put(calKey, paramList);
            }
            Object[] params = new Object[calKeys.length + 3];
            int i = 0;
            for (String field : calKeys) {
                params[i] = row.get(field);
                ++i;
            }
            params[i] = calrange;
            params[i + 1] = billEntryId;
            params[i + 2] = costsubelement;
            paramList.add(params);
        }
        if (calKeyMap.isEmpty()) {
            return;
        }
        for (Map.Entry e : calKeyMap.entrySet()) {
            String calKey = (String)e.getKey();
            StringBuilder updateSql = (StringBuilder)e.getValue();
            List paramList = (List)paramListMap.get(calKey);
            if (paramList.isEmpty()) continue;
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql.toString(), (List)paramList);
        }
    }

    public void calBeginData4EndInit() {
        QFilter q = new QFilter("entryentity.accounttype", "=", (Object)AccountTypeEnum.FIN_FOUT_PERIOD.getValue());
        q.and("billstatus", "=", (Object)"C");
        q.and("costaccount", "=", (Object)this.costAccountId);
        DataSet initBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitSelects(), (QFilter[])q.toArray(), null);
        this.insertFIFOBalance(initBillDataSet, null);
    }

    public void calBalData4SettleAccount() {
        QFilter preBalFilter = new QFilter("costaccount", "=", (Object)this.costAccountId);
        preBalFilter.and("period", "=", (Object)this.prePeriodId);
        QFilter q1 = new QFilter("endqty", "<>", (Object)BigDecimal.ZERO);
        q1.or("endcost", "<>", (Object)BigDecimal.ZERO);
        preBalFilter.and(q1);
        StringBuilder balFields = new StringBuilder();
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_balance_fifo_period");
        Set selectorsSet = balEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            balFields.append(o).append(',');
        }
        balFields.append("id");
        QFilter curBalFilter = new QFilter("costaccount", "=", (Object)this.costAccountId);
        curBalFilter.and("period", "=", (Object)this.curPeriodId);
        QFilter q2 = new QFilter("beginqty", "<>", (Object)BigDecimal.ZERO);
        q2.or("begincost", "<>", (Object)BigDecimal.ZERO);
        curBalFilter.and(q2);
        String curSelects = "id as curbalid,billentryid as curbalbillentryid,costsubelement as curbalsubelement,beginqty as curbalbeginqty,begincost as curbalbegincost";
        try (DataSet preBalDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_fifo_period", (String)balFields.toString(), (QFilter[])preBalFilter.toArray(), null);
             DataSet curBalDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_fifo_period", (String)curSelects, (QFilter[])curBalFilter.toArray(), null);){
            DataSet allBalDS = preBalDS.join(curBalDS, JoinType.FULL).on("billentryid", "curbalbillentryid").on("costsubelement", "curbalsubelement").select(preBalDS.getRowMeta().getFieldNames(), curBalDS.getRowMeta().getFieldNames()).finish();
            HashSet<Long> delids = new HashSet<Long>(4);
            HashSet<DynamicObject> insertInfos = new HashSet<DynamicObject>(4);
            for (Row row : allBalDS) {
                Long id = row.getLong("id");
                BigDecimal endqty = row.getBigDecimal("endqty");
                BigDecimal endcost = row.getBigDecimal("endcost");
                Long curbalid = row.getLong("curbalid");
                BigDecimal curbalbeginqty = row.getBigDecimal("curbalbeginqty");
                BigDecimal curbalbegincost = row.getBigDecimal("curbalbegincost");
                if (curbalid != null && id == null) {
                    delids.add(curbalid);
                } else {
                    if (curbalbeginqty != null && curbalbegincost != null) {
                        if (curbalbeginqty.compareTo(endqty) == 0 && curbalbegincost.compareTo(endcost) == 0) continue;
                        delids.add(curbalid);
                    }
                    DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_fifo_period");
                    for (String key : selectorsSet) {
                        info.set(key, row.get(key));
                    }
                    info.set("period_id", (Object)this.curPeriodId);
                    info.set("beginqty", (Object)info.getBigDecimal("endqty"));
                    info.set("begincost", (Object)info.getBigDecimal("endcost"));
                    info.set("beginunitcost", (Object)info.getBigDecimal("endunitcost"));
                    info.set("calrptid", (Object)0L);
                    insertInfos.add(info);
                }
                if (delids.size() >= 500) {
                    DeleteServiceHelper.delete((IDataEntityType)balEntityType, (Object[])delids.toArray());
                    delids.clear();
                }
                if (insertInfos.size() < 500) continue;
                SaveServiceHelper.save((DynamicObject[])insertInfos.toArray(new DynamicObject[0]));
                insertInfos.clear();
            }
            if (delids.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)balEntityType, (Object[])delids.toArray());
            }
            if (insertInfos.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])insertInfos.toArray(new DynamicObject[0]));
            }
        }
    }

    private void insertFIFOBalance(DataSet billDataSet, Map<Long, BigDecimal[]> costMap) {
        this.handleDivideDataSet(billDataSet, costMap);
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        if (!this.materialSet.isEmpty()) {
            q.and("material", "in", this.materialSet);
        }
        q.and("period", "=", (Object)this.curPeriodId);
        DeleteServiceHelper.delete((String)"cal_balance_fifo_period", (QFilter[])q.toArray());
        if (!this.insertBalSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.insertBalSet.toArray(new DynamicObject[0]));
        }
    }

    private void handleDivideDataSet(DataSet finalDataSet, Map<Long, BigDecimal[]> costMap) {
        for (Row row : finalDataSet) {
            long caldimensionid = row.getLong("caldimension");
            String dividebasis = row.getString("dividebasisstr");
            String caldimension = row.getString("caldimensionstr");
            String calKey = "";
            calKey = caldimensionid != 0L ? CommonUtils.trimComma((String)dividebasis) + "," + CommonUtils.trimComma((String)caldimension) : CommonUtils.trimComma((String)dividebasis);
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            this.insertBalSet(onFields, row, costMap);
        }
    }

    private DataSet getBalDataSet() {
        QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
        q.and("period", "<", (Object)this.periodNum);
        q.and("endperiod", ">=", (Object)this.periodNum);
        if (!this.materialSet.isEmpty()) {
            q.and("material", "in", this.materialSet);
        }
        if (CalBalanceModelHelper.isNewBalance()) {
            String selectFileds = this.getBalSelects(false) + ",id as detailbalid,costelement,costsubelement,baseqty_bal as balqty,actualcost_bal as balcost";
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bal", (String)selectFileds, (QFilter[])q.toArray(), null);
        }
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)this.getBalSelects(false), (QFilter[])q.toArray(), null);
        HashSet<Long> balIdSet = new HashSet<Long>();
        for (Row row : balDataSet.copy()) {
            balIdSet.add(row.getLong("id"));
        }
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"id,balid,costelement,costsubelement,periodendqty as balqty,periodendactualcost as balcost", (QFilter[])new QFilter("balid", "in", balIdSet).toArray(), null);
        return balDataSet.join(detailDataSet, JoinType.LEFT).on("id", "balid").select(this.getBalSelects(true).split(","), new String[]{"id as detailbalid", "costelement", "costsubelement", "balqty", "balcost"}).finish();
    }

    private void insertBalSet(String[] onFields, Row row, Map<Long, BigDecimal[]> costMap) {
        BigDecimal[] costs;
        DynamicObject balInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_fifo_period");
        long detailId = row.getLong("detailid");
        balInfo.set("costaccount", (Object)this.costAccountId);
        balInfo.set("calorg", (Object)this.calOrgId);
        balInfo.set("currency", row.get("currency"));
        balInfo.set("baseunit", row.get("baseunit"));
        balInfo.set("material", row.get("material"));
        balInfo.set("auditdate", row.get("auditdate"));
        balInfo.set("billno", row.get("billno"));
        balInfo.set("billentryid", row.get("eid"));
        balInfo.set("bizdate", row.get("bizdate"));
        balInfo.set("period", (Object)this.curPeriodId);
        balInfo.set("calrange", row.get("calrange"));
        BigDecimal[] bigDecimalArray = costs = costMap == null ? null : costMap.get(detailId);
        if (costs != null) {
            balInfo.set("endqty", (Object)costs[0]);
            balInfo.set("endcost", (Object)costs[1]);
            balInfo.set("endunitcost", (Object)costs[2]);
        } else {
            balInfo.set("endqty", row.get("billqty"));
            balInfo.set("endcost", row.get("billcost"));
            balInfo.set("endunitcost", row.get("unitactualcost"));
        }
        balInfo.set("beginqty", balInfo.get("endqty"));
        balInfo.set("begincost", balInfo.get("endcost"));
        balInfo.set("beginunitcost", balInfo.get("endunitcost"));
        balInfo.set("entryseq", row.get("entryseq"));
        for (String field : onFields) {
            balInfo.set(field, row.get(field));
        }
        this.insertBalSet.add(balInfo);
    }

    private String getBalSelects(boolean isAlias) {
        if (isAlias) {
            return this.dimFields + ",id,calorg,calrange,caldimensionstr,dividebasisstr";
        }
        return this.dimFields + ",id,calorg,calrange,caldimension.caldimension as caldimensionstr,costaccount.dividebasis.dividebasis as dividebasisstr";
    }

    private DataSet getBillDataSet() {
        DataSet dataSet = null;
        if (this.isStartPeriod) {
            QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "=", (Object)this.curPeriodId);
            if (!this.materialSet.isEmpty()) {
                q.and("entryentity.material", "in", this.materialSet);
            }
            q.and("billstatus", "=", (Object)"C");
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitBillSelects(), (QFilter[])q.toArray(), null);
        } else {
            QFilter q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            if (!this.materialSet.isEmpty()) {
                q.and("entryentity.material", "in", this.materialSet);
            }
            q.and("billstatus", "=", (Object)"C");
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitBillSelects(), (QFilter[])q.toArray(), null);
            q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            Date[] periodDates = PeriodHelper.getPeriodStartAndEndTime((Long)this.prePeriodId);
            if (periodDates != null && periodDates.length > 1) {
                q.and("bookdate", "<=", (Object)periodDates[1]);
            }
            if (!this.materialSet.isEmpty()) {
                q.and("entry.material", "in", this.materialSet);
            }
            q.and("isinitbill", "=", (Object)Boolean.FALSE);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            q.and("billstatus", "=", (Object)"C");
            DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getBillSelects(), (QFilter[])q.toArray(), null);
            HashSet<Long> bizBillIds = new HashSet<Long>(16);
            HashSet<Long> ancestorEntryids = new HashSet<Long>(16);
            for (Row row : costRecordDS.copy()) {
                ancestorEntryids.add(row.getLong("entryid"));
                bizBillIds.add(row.getLong("bizbillid"));
            }
            q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            if (periodDates != null && periodDates.length > 1) {
                q.and("bookdate", "<=", (Object)periodDates[1]);
            }
            q.and("issplitcreate", "=", (Object)Boolean.TRUE);
            q.and("entry.ancestorentryid", "in", ancestorEntryids);
            q.and("bizbillid", "in", bizBillIds);
            DataSet childCostRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.ancestorentryid,entry.id", (QFilter[])q.toArray(), null);
            HashMap<Long, Long> childMotherRecordMap = new HashMap<Long, Long>(16);
            for (Row row : childCostRecordDS) {
                childMotherRecordMap.put(row.getLong("entry.id"), row.getLong("entry.ancestorentryid"));
            }
            q = new QFilter("costaccount", "=", (Object)this.costAccountId);
            q.and("period", "<=", (Object)this.prePeriodId);
            if (periodDates != null && periodDates.length > 1) {
                q.and("bookdate", "<=", (Object)periodDates[1]);
            }
            HashSet<Object> allIdSet = new HashSet<Object>(16);
            allIdSet.addAll(childMotherRecordMap.keySet());
            allIdSet.addAll(ancestorEntryids);
            q.and("entryentity.invbillentryid", "in", allIdSet);
            HashMap<Long, HashMap<Long, BigDecimal>> adjustAmtMap = new HashMap<Long, HashMap<Long, BigDecimal>>(16);
            DataSet costAdjustDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)"entryentity.invbillentryid,entryentity.subentryentity.costsubelement,entryentity.subentryentity.sub_adjustamt", (QFilter[])q.toArray(), null);
            for (Row row : costAdjustDS) {
                HashMap<Long, BigDecimal> subelementAmtMap = (HashMap<Long, BigDecimal>)adjustAmtMap.get(row.getLong("entryentity.invbillentryid"));
                if (subelementAmtMap == null) {
                    subelementAmtMap = new HashMap<Long, BigDecimal>(16);
                    adjustAmtMap.put(row.getLong("entryentity.invbillentryid"), subelementAmtMap);
                }
                subelementAmtMap.put(row.getLong("entryentity.subentryentity.costsubelement"), row.getBigDecimal("entryentity.subentryentity.sub_adjustamt"));
            }
            HashMap<String, BigDecimal> motherRecord_adjustAmtMap = new HashMap<String, BigDecimal>(16);
            for (Map.Entry e : childMotherRecordMap.entrySet()) {
                long childEntryId = (Long)e.getKey();
                long ancestorEntryId = (Long)e.getValue();
                Map subelementAmtMap = (Map)adjustAmtMap.get(childEntryId);
                if (subelementAmtMap == null) continue;
                for (Map.Entry e1 : subelementAmtMap.entrySet()) {
                    long subElementId = (Long)e1.getKey();
                    BigDecimal adjustAmt = (BigDecimal)e1.getValue();
                    BigDecimal totalAmt = (BigDecimal)motherRecord_adjustAmtMap.get(ancestorEntryId + "|" + subElementId);
                    if (totalAmt == null) {
                        totalAmt = BigDecimal.ZERO;
                    }
                    totalAmt = totalAmt.add(adjustAmt);
                    motherRecord_adjustAmtMap.put(ancestorEntryId + "|" + subElementId, totalAmt);
                }
            }
            for (Long entryid : ancestorEntryids) {
                Map subelementAmtMap = (Map)adjustAmtMap.get(entryid);
                if (subelementAmtMap == null) continue;
                for (Map.Entry e1 : subelementAmtMap.entrySet()) {
                    long subElementId = (Long)e1.getKey();
                    BigDecimal adjustAmt = (BigDecimal)e1.getValue();
                    BigDecimal totalAmt = (BigDecimal)motherRecord_adjustAmtMap.get(entryid + "|" + subElementId);
                    if (totalAmt == null) {
                        totalAmt = BigDecimal.ZERO;
                    }
                    totalAmt = totalAmt.add(adjustAmt);
                    motherRecord_adjustAmtMap.put(entryid + "|" + subElementId, totalAmt);
                }
            }
            costRecordDS = costRecordDS.map((MapFunction)new AddAdjustAmtFunction(costRecordDS.getRowMeta(), motherRecord_adjustAmtMap));
            dataSet = dataSet.union(costRecordDS);
        }
        return dataSet;
    }

    private String getBillSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        String entryName = "entry";
        for (String field : fields = this.dimFields.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id,bizbillid,entry.subentrycostelement.costelement as costelement,entry.subentrycostelement.costsubelement as costsubelement,calbilltype,");
        selects.append("entry.baseqty as billqty,entry.subentrycostelement.sub_actualcost as billcost,entry.subentrycostelement.sub_unitactualcost as billunitcost,entry.subentrycostelement.id as detailid,entry.id as entryid,");
        selects.append("10 as priceprecision,localcurrency.amtprecision as amtprecision,entry.baseunit.precision as qtyprecision,");
        selects.append("bizdate,billno,auditdate,entry.seq as entryseq,'costrecord' as entityobject");
        selects.append(",calorg,entry.calrange as calrange,entry.caldimension.caldimension as caldimensionstr,costaccount.dividebasis.dividebasis as dividebasisstr");
        return selects.toString();
    }

    private String getInitBillSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.dimFields.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id,0L as bizbillid,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,'IN' as calbilltype,");
        selects.append("entryentity.baseqty as billqty,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.sub_price as billunitcost,entryentity.subentryentity.id as detailid,entryentity.id as entryid,");
        selects.append("10 as priceprecision,localcurrency.amtprecision as amtprecision,entryentity.baseunit.precision as qtyprecision,");
        selects.append("entryentity.stockindate as bizdate,billno,auditdate,entryentity.seq as entryseq,'calinitbill' as entityobject");
        selects.append(",calorg,entryentity.calrange as calrange,entryentity.caldimension.caldimension as caldimensionstr,costaccount.dividebasis.dividebasis as dividebasisstr");
        return selects.toString();
    }

    private void initBalanceDimFields() {
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>(16);
        bizDataTypeSet.add(BizDataType.MAIN);
        bizDataTypeSet.add(BizDataType.DIM);
        ArrayList<String> dimFieldList = new ArrayList<String>(32);
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balancemodel";
        Map fieldMap = BalanceServiceHelper.loadBizData((String)balanceEntity, bizDataTypeSet);
        if (fieldMap.get(BizDataType.MAIN) != null) {
            dimFieldList.addAll((Collection)fieldMap.get(BizDataType.MAIN));
        }
        if (fieldMap.get(BizDataType.DIM) != null) {
            dimFieldList.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        if (dimFieldList.isEmpty()) {
            dimFieldList.add("costaccount");
            dimFieldList.add("storageorgunit");
            dimFieldList.add("ownertype");
            dimFieldList.add("owner");
            dimFieldList.add("material");
            dimFieldList.add("assist");
            dimFieldList.add("lot");
            dimFieldList.add("warehouse");
            dimFieldList.add("location");
            dimFieldList.add("invtype");
            dimFieldList.add("invstatus");
            dimFieldList.add("project");
            dimFieldList.add("mversion");
        }
        StringBuilder sb = new StringBuilder();
        for (String field : dimFieldList) {
            if ("costelement".equals(field) || "costsubelement".equals(field)) continue;
            sb.append(field).append(",");
        }
        this.dimFields = sb.substring(0, sb.length() - 1);
    }

    private DataSet getUnionDataSet(Long[] billDetailIds, Set<Long> billIds, String entityName) {
        QFilter q = new QFilter("entry.subentrycostelement.id", "in", (Object)billDetailIds);
        q.and("id", "in", billIds);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordSelects(), (QFilter[])q.toArray(), null);
        q = new QFilter("entryentity.subentryentity.id", "in", (Object)billDetailIds);
        q.and("id", "in", billIds);
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)this.getInitSelects(), (QFilter[])q.toArray(), null);
        return initDataSet.union(costRecordDataSet);
    }

    private String getCostRecordSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        String entryName = "entry";
        for (String field : fields = this.totalKey.split(",")) {
            if ("costaccount".equals(field)) continue;
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id as billid,billno as billno,bizdate,billtype.number as billtypenumber,billtype.name as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entry.caldimension as caldimension,entry.caldimension.caldimension as caldimensionstr,auditdate,'0' as createtype,");
        selects.append("entry.baseqty as billqty,entry.material as material,entry.material.name as materialname,entry.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,entry.signnum as signnum,");
        selects.append("entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,entry.calrange as calrange,entry.calentryid as calentryid,entry.queuetype as queuetype,bizentityobject.number as bizentityobject,period as period,entry.seq as entryseq");
        selects.append(",entry.subentrycostelement.costelement as costelement,entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_actualcost billcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost,entry.subentrycostelement.id as detailid,entry.id as eid");
        return selects.toString();
    }

    private String getInitSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            if ("costaccount".equals(field)) continue;
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355", (String)"FIFOCalculate_6", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,billno as billno,entryentity.stockindate as bizdate,'cal_initbill' as billtypenumber,'").append(s).append("' as billtypename,costaccount,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,'0' as createtype,");
        selects.append("entryentity.baseqty as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,1 as signnum,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,'0' as queuetype,'cal_initbill' as bizentityobject,0 as period,entryentity.seq as entryseq");
        selects.append(",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.sub_price as unitactualcost,entryentity.subentryentity.id as detailid,entryentity.id as eid");
        return selects.toString();
    }

    private static class AddAdjustAmtFunction
    extends MapFunction {
        private static final long serialVersionUID = -5124479994753421306L;
        private RowMeta rowMeta;
        private Map<String, BigDecimal> motherRecord_adjustAmtMap;

        public AddAdjustAmtFunction(RowMeta rowMeta, Map<String, BigDecimal> motherRecord_adjustAmtMap) {
            this.rowMeta = rowMeta;
            this.motherRecord_adjustAmtMap = motherRecord_adjustAmtMap;
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }

        public Object[] map(Row row) {
            RowMeta resultRowMeta = this.getResultRowMeta();
            Object[] newRow = new Object[resultRowMeta.getFieldCount()];
            for (String fieldName : resultRowMeta.getFieldNames()) {
                int fieldIndex = resultRowMeta.getFieldIndex(fieldName);
                newRow[fieldIndex] = row.get(fieldName);
            }
            long entryId = row.getLong("entryid");
            long subElementId = row.getLong("costsubelement");
            BigDecimal adjustAmt = this.motherRecord_adjustAmtMap.get(entryId + "|" + subElementId);
            if (adjustAmt != null) {
                int billCostIndex = resultRowMeta.getFieldIndex("billcost");
                int billUnitCostIndex = resultRowMeta.getFieldIndex("billunitcost");
                BigDecimal newBillCost = row.getBigDecimal("billcost").add(adjustAmt);
                newRow[billCostIndex] = newBillCost;
                newRow[billUnitCostIndex] = newBillCost.divide(row.getBigDecimal("billqty"), 10, 4);
            }
            return newRow;
        }
    }

    private static class BalInfo {
        private String balId;
        private BigDecimal qty;
        private BigDecimal cost;

        private BalInfo() {
        }

        public String getBalId() {
            return this.balId;
        }

        public void setBalId(String balId) {
            this.balId = balId;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BalInfo)) {
                return false;
            }
            return this.balId.equals(((BalInfo)obj).getBalId());
        }

        public int hashCode() {
            return this.balId.hashCode();
        }
    }

    private static class BillInfo {
        private long billId;
        private long billEntryId;
        private long detailId;
        private Date bizDate;
        private Date auditDate;
        private String billNo;
        private int entrySeq;
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal cost = BigDecimal.ZERO;
        private BigDecimal price = BigDecimal.ZERO;
        private String type;
        private int qtyPrecision;
        private int amtPrecision;
        private int pricePrecision;
        private long currencyId;
        private long baseUnitId;
        private long materialId;

        private BillInfo() {
        }

        public long getBillId() {
            return this.billId;
        }

        public void setBillId(long billId) {
            this.billId = billId;
        }

        public long getBillEntryId() {
            return this.billEntryId;
        }

        public void setBillEntryId(long billEntryId) {
            this.billEntryId = billEntryId;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public Date getAuditDate() {
            return this.auditDate;
        }

        public void setAuditDate(Date auditDate) {
            this.auditDate = auditDate;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public int getEntrySeq() {
            return this.entrySeq;
        }

        public void setEntrySeq(int entrySeq) {
            this.entrySeq = entrySeq;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getQtyPrecision() {
            return this.qtyPrecision;
        }

        public void setQtyPrecision(int qtyPrecision) {
            this.qtyPrecision = qtyPrecision;
        }

        public int getAmtPrecision() {
            return this.amtPrecision;
        }

        public void setAmtPrecision(int amtPrecision) {
            this.amtPrecision = amtPrecision;
        }

        public int getPricePrecision() {
            return this.pricePrecision;
        }

        public void setPricePrecision(int pricePrecision) {
            this.pricePrecision = pricePrecision;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(long currencyId) {
            this.currencyId = currencyId;
        }

        public long getBaseUnitId() {
            return this.baseUnitId;
        }

        public void setBaseUnitId(long baseUnitId) {
            this.baseUnitId = baseUnitId;
        }

        public long getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(long materialId) {
            this.materialId = materialId;
        }

        public long getDetailId() {
            return this.detailId;
        }

        public void setDetailId(long detailId) {
            this.detailId = detailId;
        }
    }
}

