/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.util.CommonUtils;

public class IntimeBufferPoolHandle {
    private Set<Long> bizBillIds = new HashSet<Long>(16);
    private Date minAuditDate = null;
    private DynamicObjectCollection intimeCostRecordCol;
    private String entity;
    private String actionName;
    private Set<Long> billids = new HashSet<Long>(16);
    private List<Object> entryIdList = new ArrayList<Object>(16);
    private boolean isDeleteBill = false;
    private static final int BATCH_SIZE = 10000;
    private final Map<Long, Set<Long>> allBillIdEntryIdMap = new HashMap<Long, Set<Long>>(16);

    public Set<Long> getBufferPoolBizBillids() {
        return this.bizBillIds;
    }

    public IntimeBufferPoolHandle(DynamicObject[] bills, String entity, String actionName, boolean isDeleteBill) {
        this.entity = entity;
        this.actionName = actionName;
        this.intimeCostRecordCol = this.resolveBills(bills);
        this.isDeleteBill = isDeleteBill;
    }

    private DynamicObjectCollection resolveBills(DynamicObject[] bills) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DateType.LongType), new Field("bizbillid", (DataType)DateType.LongType), new Field("entryid", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("bizbillentryid", (DataType)DateType.LongType), new Field("bookdate", (DataType)DateType.DateType), new Field("auditdate", (DataType)DateType.DateType), new Field("queuetype", (DataType)DateType.StringType)});
        DataSetBuilder collBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryentity) {
                Set entryIds = this.allBillIdEntryIdMap.computeIfAbsent(bill.getLong("id"), k -> new HashSet(16));
                entryIds.add(entryRow.getLong("id"));
                String accountType = entryRow.getString("accounttype");
                if (!AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(accountType) && !AccountTypeEnum.FIN_FOUT.getValue().equals(accountType) && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
                Long id = bill.getLong("id");
                Long bizbillid = 0L;
                Long entryid = entryRow.getLong("id");
                Long material = entryRow.getDynamicObject("material").getLong("id");
                Long bizbillentryid = 0L;
                Date bookdate = bill.getDate("bookdate");
                Date auditdate = bill.getDate("auditdate");
                String queuetype = "";
                if ("cal_costadjust_subentity".equals(this.entity)) {
                    bookdate = entryRow.getDate("invbizdate");
                    auditdate = entryRow.getDate("invauditdate");
                    queuetype = entryRow.getString("queuetype");
                }
                collBuilder.append(new Object[]{id, bizbillid, entryid, material, bizbillentryid, bookdate, auditdate, queuetype});
            }
        }
        DynamicObjectCollection coll = ORM.create().toPlainDynamicObjectCollection(collBuilder.build());
        return coll;
    }

    public IntimeBufferPoolHandle(DynamicObjectCollection coll, String entity, String actionName, boolean isDeleteBill) {
        this.intimeCostRecordCol = coll;
        this.entity = entity;
        this.actionName = actionName;
        this.isDeleteBill = isDeleteBill;
    }

    public void insertIntoPool() {
        if (this.intimeCostRecordCol == null || this.intimeCostRecordCol.isEmpty()) {
            return;
        }
        this.initMinAuditDateAndBizBillIds();
        Set<Long> materialTransBizbillIds = this.getMaterialTransBizbillids();
        this.insert2DB(materialTransBizbillIds);
        this.updateEntryStatus();
        this.updateBillStatusByBill();
    }

    private void updateBillStatusByBill() {
        boolean isCostRecord;
        boolean bl = isCostRecord = "cal_costrecord".equals(this.entity) || "cal_costrecord_subentity".equals(this.entity);
        if (isCostRecord && !ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
            this.updateBillStatus(false);
        } else {
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onCommitted() {
                    try (TXHandle tx = TX.requiresNew();){
                        IntimeBufferPoolHandle.this.updateBillStatus(true);
                    }
                }
            });
        }
    }

    private void updateBillStatus(boolean isUpdateBillStatus) {
        if (this.billids.isEmpty()) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)this.getHeadTable(), (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, this.billids)});){
            ctx.set();
            Lists.partition(Arrays.asList(this.billids.toArray()), (int)10000).forEach(list1 -> {
                SqlBuilder builder = new SqlBuilder();
                builder.append("update ", new Object[0]);
                String headTable = this.getHeadTable();
                builder.append(headTable, new Object[0]);
                builder.append(" set ", new Object[0]);
                if (isUpdateBillStatus) {
                    builder.append(" fbillstatus = ", new Object[0]);
                    builder.append(this.getStatus(), new Object[0]);
                    builder.append(",", new Object[0]);
                }
                builder.append("fcalstatus = 'C'", new Object[0]);
                builder.append(" where ", new Object[0]);
                builder.appendIn("fid", list1.toArray());
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)builder);
            });
        }
    }

    private void initMinAuditDateAndBizBillIds() {
        for (DynamicObject info : this.intimeCostRecordCol) {
            Date auditTime = info.getDate("auditdate");
            Long bizbillid = info.getLong("bizbillid");
            if (this.minAuditDate == null || this.minAuditDate.after(auditTime)) {
                this.minAuditDate = auditTime;
            }
            if (bizbillid == null || Long.compare(bizbillid, 0L) == 0) continue;
            this.bizBillIds.add(bizbillid);
        }
    }

    private void updateEntryStatus() {
        if (this.entryIdList.isEmpty()) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)this.getHeadTable(), (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, this.billids)});){
            ctx.set();
            Lists.partition(this.entryIdList, (int)10000).forEach(list1 -> {
                SqlBuilder builder = new SqlBuilder();
                builder.append("update ", new Object[0]);
                builder.append(this.getEntryTable(), new Object[0]);
                builder.append(" set fentrystatus = ", new Object[0]);
                builder.append(this.getStatus(), new Object[0]);
                builder.append(",fecalstatus = 'C'", new Object[0]);
                builder.append(" where ", new Object[0]);
                builder.appendIn("fentryid", list1);
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)builder);
            });
        }
    }

    private String getStatus() {
        if (ActionEnum.AUDIT.getValue().equals(this.actionName) || ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
            return "'B'";
        }
        return "'C'";
    }

    private String getEntryTable() {
        switch (this.entity) {
            case "cal_costrecord_subentity": {
                return "t_cal_calcostrecordentry";
            }
            case "cal_costadjust_subentity": {
                return "t_cal_costadjustbillentry";
            }
            case "cal_initbill": {
                return "t_cal_initbillentry";
            }
            case "cal_stdcostdiffbill": {
                return "t_cal_stdcostdiff";
            }
        }
        return "";
    }

    private String getHeadTable() {
        switch (this.entity) {
            case "cal_costrecord_subentity": {
                return "t_cal_calcostrecord";
            }
            case "cal_costadjust_subentity": {
                return "t_cal_costadjustbill";
            }
            case "cal_initbill": {
                return "t_cal_initbill";
            }
        }
        return "";
    }

    private void insert2DB(Set<Long> materialTransBizbillIds) {
        Set<String> entityEntryIdActions = this.getEntityEntryIdActions();
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
        IDGenerator idGenerator = new IDGenerator("t_cal_bufferpool", this.intimeCostRecordCol.size());
        for (DynamicObject info : this.intimeCostRecordCol) {
            Long costrecordId = info.getLong("id");
            Long costrecordEntryId = info.getLong("entryid");
            String key = this.doSameEntity(this.entity) + costrecordEntryId + this.actionName;
            if (entityEntryIdActions.contains(key)) continue;
            Long materialId = info.getLong("material");
            Boolean isMaterialTrans = materialTransBizbillIds.contains(info.getLong("bizbillid"));
            Date auditTime = info.getDate("auditdate");
            if (ActionEnum.UN_AUDIT.getValue().equals(this.actionName) || ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
                auditTime = TimeServiceHelper.now();
            }
            Long bizbillid = info.getLong("bizbillid");
            Long bizbillentryid = info.getLong("bizbillentryid");
            Date bookdate = info.getDate("bookdate");
            String queuetype = info.getString("queuetype");
            this.billids.add(costrecordId);
            this.entryIdList.add(costrecordEntryId);
            insertParams.add(new Object[]{idGenerator.getId(), this.entity, costrecordId, costrecordEntryId, materialId, isMaterialTrans, this.actionName, auditTime, bizbillid, bizbillentryid, bookdate, this.isDeleteBill, queuetype, 0});
        }
        if (!insertParams.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"insert into t_cal_bufferpool(fid,fentity,fbillid,fentryid,fmaterialid,fismaterialtrans,factionname,factiontime,fbizbillid,fbizbillentryid,fbookdate,fisdeletebill,fqueuetype,fcaltimes) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", insertParams);
        }
    }

    private Set<String> getEntityEntryIdActions() {
        HashSet<String> entityEntryIdActions = new HashSet<String>(16);
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (DynamicObject billDyc : this.intimeCostRecordCol) {
            billIds.add(billDyc.getLong("id"));
            entryIds.add(billDyc.getLong("entryid"));
        }
        QFilter billIdF = new QFilter("billid", "in", billIds);
        QFilter entryIdF = new QFilter("entryid", "in", entryIds);
        QFilter actionNameF = new QFilter("actionname", "=", (Object)this.actionName);
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bufferpool", (String)"billid,entryid,actionname,entity", (QFilter[])new QFilter[]{billIdF, entryIdF, actionNameF}, null);
        for (Row row : billDs) {
            String entity = row.getString("entity");
            entity = this.doSameEntity(entity);
            String entryId = row.getString("entryid");
            String actionName = row.getString("actionname");
            entityEntryIdActions.add(entity + entryId + actionName);
        }
        return entityEntryIdActions;
    }

    private String doSameEntity(String entity) {
        if ("cal_costrecord_subentity".equals(entity)) {
            entity = "cal_costrecord";
        } else if ("cal_costadjust_subentity".equals(entity)) {
            entity = "cal_costadjustbill";
        }
        return entity;
    }

    private Set<Long> getMaterialTransBizbillids() {
        DynamicObject[] groupBillRecords;
        HashSet<Long> materialTransBizbillIds = new HashSet<Long>(16);
        if (this.bizBillIds == null || this.bizBillIds.isEmpty()) {
            return materialTransBizbillIds;
        }
        if (AcctGroupModelHelper.isBizGroupModel()) {
            QFilter costRecordFilter = new QFilter("entryentity.bizbillid", "=", this.bizBillIds);
            HashMap<String, Set<Long>> formId2BizbillidMap = new HashMap<String, Set<Long>>(4);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)GroupRelationCostCalculator.class.getName(), (String)"cal_costrecord", (String)"bizentityobject,bizbillid", (QFilter[])costRecordFilter.toArray(), null);){
                for (Row row : dataSet) {
                    String formid = row.getString("bizentityobject");
                    Long bizbillid = row.getLong("bizbillid");
                    Set bizbillids = formId2BizbillidMap.computeIfAbsent(formid, k -> new HashSet(16));
                    bizbillids.add(bizbillid);
                }
            }
            groupBillRecords = new BizGroupRecordBuilder().getAllGroupRecordByBizBillIds(formId2BizbillidMap);
        } else {
            String groupRecKey = AcctGroupModelHelper.isNewGroupModel() ? "cal_account_grouprecord" : "cal_groupbillrecord";
            QFilter groupBillRecordFilter = new QFilter("entryentity.bizbillid", "in", this.bizBillIds);
            if (this.minAuditDate != null) {
                groupBillRecordFilter.and("updatetime", ">=", (Object)this.minAuditDate);
            }
            groupBillRecords = BusinessDataServiceHelper.load((String)groupRecKey, (String)"id,entryentity.material,entryentity.bizbillid", (QFilter[])groupBillRecordFilter.toArray());
        }
        if (groupBillRecords != null && groupBillRecords.length > 0) {
            for (DynamicObject groupBillRecord : groupBillRecords) {
                Long beforeMaterilId = null;
                boolean isMaterialTrans = false;
                DynamicObjectCollection entry = groupBillRecord.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryRow : entry) {
                    Long materialid = CommonUtils.getBaseId((DynamicObject)entryRow, (String)"material");
                    if (beforeMaterilId == null) {
                        beforeMaterilId = materialid;
                        continue;
                    }
                    if (beforeMaterilId.compareTo(materialid) == 0) continue;
                    isMaterialTrans = true;
                }
                if (!isMaterialTrans) continue;
                for (DynamicObject entryRow : entry) {
                    Long bizbillid = entryRow.getLong("bizbillid");
                    materialTransBizbillIds.add(bizbillid);
                }
            }
        }
        return materialTransBizbillIds;
    }

    public Map<Long, Set<Long>> getNoInPoolBillEntryIdMap() {
        for (Long billid : this.billids) {
            this.allBillIdEntryIdMap.remove(billid);
        }
        return this.allBillIdEntryIdMap;
    }

    public Set<Long> getBillids() {
        return this.billids;
    }

    public List<Object> getEntryIdList() {
        return this.entryIdList;
    }

    public void setEntryIdList(List<Object> entryIdList) {
        this.entryIdList = entryIdList;
    }
}

