/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.process.inner.CalMoveDlock;
import kd.fi.cal.business.process.inner.QueryInvOrgHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.LowTimer;

public class MoveAddAverageCalculate {
    private static final Log logger = LogFactory.getLog(MoveAddAverageCalculate.class);
    private String entityName;
    private Long[] billIds;
    private Long[] billEntryIds;
    private String divideStr;
    private String caldimensionStr;
    private String totalKey;
    private String opType;
    private Map<String, BigDecimal> billGroupMap = new HashMap<String, BigDecimal>();
    private Map<Long, CostPriceResultInfo> billCostPriceMap = new HashMap<Long, CostPriceResultInfo>();
    private Set<Long> costRecordEntrySet = new HashSet<Long>();
    private Set<Long> omInCostRecordEntrys = new HashSet<Long>(16);
    private Set<Long> notOmInCostRecordEntrys = new HashSet<Long>(16);
    private Set<Long> byElementCostRecordEntrySet = new HashSet<Long>();
    private Set<Long> noneElementCostRecordEntrySet = new HashSet<Long>();
    private static final String lockKey = "moveaddaverage_";
    private Map<Long, DynamicObject> costAdjustMap = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> costAdjustEntryMap = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> loadBillMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObject> loadEntryMap = new HashMap<Long, DynamicObject>();
    private String entryName = "entry";
    private DynamicObject costAdjustOutBillType;
    private Map<Long, Long> periodMap = new HashMap<Long, Long>(8);
    private Map<Long, Date> begindateMap = new HashMap<Long, Date>(8);
    private Map<Long, Boolean> calByElementMap = new HashMap<Long, Boolean>();
    private Map<String, DynamicObject> rptMap = new HashMap<String, DynamicObject>();
    private Map<String, BigDecimal[]> recordMap = new HashMap<String, BigDecimal[]>();
    private Map<Long, BigDecimal[]> materialCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> feeMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> processCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> manufactureCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> resourceMap = new HashMap<Long, BigDecimal[]>();
    private String groupPriceName = ResManager.loadKDString((String)"\u6210\u7ec4\u6210\u672c", (String)"FIFOCalculate_7", (String)"fi-cal-business", (Object[])new Object[0]);
    private String realTimePriceName = ResManager.loadKDString((String)"\u5373\u65f6\u6210\u672c", (String)"FIFOCalculate_9", (String)"fi-cal-business", (Object[])new Object[0]);
    private boolean enableStd = false;
    private Set<String> omInBills = new HashSet<String>(16);
    private Set<Long> zeroInOutBizTypeIds = new HashSet<Long>(16);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Map<Long, String> prevCostParamMap = new HashMap<Long, String>(16);
    private Map<Long, String> elementNameMap = new HashMap<Long, String>(16);
    private Map<Long, String> createDiffbillTypeMap = new HashMap<Long, String>();

    public MoveAddAverageCalculate(Long[] billIds, String entityName, String opType) {
        this.init(billIds, null, entityName, opType);
    }

    public MoveAddAverageCalculate(Long[] billIds, Long[] billEntryIds, String entityName, String opType) {
        this.init(billIds, billEntryIds, entityName, opType);
    }

    public MoveAddAverageCalculate(Long[] billIds, String entityName, String opType, long costAccId) {
        this.init(billIds, null, entityName, opType);
        DynamicObject costAcc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccId)});
        this.enableStd = costAcc.getBoolean("enablestandardcost");
    }

    private void init(Long[] billIds, Long[] billEntryIds, String entityName, String opType) {
        this.entityName = entityName;
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName) || "cal_initbill".equals(entityName)) {
            this.entryName = "entryentity";
        }
        this.billIds = billIds;
        this.billEntryIds = billEntryIds;
        DynamicObject calSetInfo = QueryServiceHelper.queryOne((String)"cal_setting", (String)"dividebasiscols,caldimensioncols", (QFilter[])new QFilter("id", "=", (Object)683799445774680063L).toArray());
        this.divideStr = calSetInfo.getString("dividebasiscols");
        this.caldimensionStr = calSetInfo.getString("caldimensioncols");
        this.totalKey = CommonUtils.trimComma((String)this.divideStr) + "," + CommonUtils.trimComma((String)this.caldimensionStr);
        this.opType = opType;
        DynamicObject[] infos = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        if (infos == null || infos.length == 0) {
            return;
        }
        if (!"cal_balance".equals(entityName)) {
            for (DynamicObject info : infos) {
                this.loadBillMap.put(info.getLong("id"), info);
                for (DynamicObject entry : info.getDynamicObjectCollection(this.entryName)) {
                    this.loadEntryMap.put(entry.getLong("id"), entry);
                }
            }
        }
        this.costAdjustOutBillType = CommonSettingHelper.getCostAdjustOutBillType();
        for (DynamicObject info : infos) {
            Long calOrgId;
            String diffbillType;
            Long costAccountId = info.getLong("costaccount.id");
            Boolean calByElement = this.calByElementMap.get(costAccountId);
            if (calByElement == null) {
                calByElement = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement").getDynamicObject("calpolicy").getBoolean("calbycostelement");
                this.calByElementMap.put(costAccountId, calByElement);
            }
            if ((diffbillType = this.createDiffbillTypeMap.get(calOrgId = Long.valueOf(info.getLong("calorg.id")))) != null) continue;
            diffbillType = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"creatediffbilltype");
            this.createDiffbillTypeMap.put(calOrgId, diffbillType);
        }
        this.omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        if ("cal_costrecord".equals(entityName)) {
            DynamicObject settingObj = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizTypes = settingObj.getDynamicObjectCollection("zeroinoutbiztype");
            for (DynamicObject bizType : bizTypes) {
                this.zeroInOutBizTypeIds.add(bizType.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate4AdjustBill() {
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            CalMoveDlock calMoveDlock = new CalMoveDlock();
            HashSet<Long> billIdSets = new HashSet<Long>(Arrays.asList(this.billIds));
            Map<String, DLock> keyLockMap = calMoveDlock.addLockBatchByCostAdjust(billIdSets);
            locks.addAll(keyLockMap.values());
            this.calculate();
        }
        finally {
            for (DLock lock : locks) {
                lock.close();
            }
        }
    }

    @Deprecated
    public void calculate4InitBill() {
        this.calculate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate() {
        DataSet dataSet = this.getBillDataSet(this.billIds, this.billEntryIds, this.entityName);
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        logger.info("------ynzy----calculate-----");
        logger.info("------ynzy----billIds.size()-----" + this.billIds.length);
        DataSet finalDataSet = null;
        if (!"cal_balance".equals(this.entityName) && !"cal_initbill".equals(this.entityName)) {
            DataSet copyDataSet = dataSet.copy();
            finalDataSet = copyDataSet.select(this.getAliasSelects() + ",case when queuetype = '0' then '1' else '0' end as type");
        } else {
            finalDataSet = dataSet.copy().addField("1", "type");
        }
        DataSet copyFinalDataSet = finalDataSet.copy();
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        int count = 0;
        for (DynamicObject[] row : dataSet.copy()) {
            long calRangeId = row.getLong("calRange");
            if (calRangeId != 0L) {
                calRangeSet.add(calRangeId);
            }
            entryIdSet.add(row.getLong("eid"));
            materialIdSet.add(row.getLong("material"));
            ++count;
        }
        logger.info("------ynzy----dataSet.size()-----" + count);
        logger.info("------ynzy----calRangeSet1.size()-----" + calRangeSet.size());
        DynamicObject[] calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray());
        calRangeSet.clear();
        for (DynamicObject calRange : calRanges) {
            if (calRange.getDynamicObjectCollection("entry").isEmpty()) continue;
            calRangeSet.add(calRange.getLong("id"));
        }
        logger.info("------ynzy----calRangeSet2.size()-----" + calRangeSet.size());
        HashSet lockSet = new HashSet();
        LowTimer time = new LowTimer();
        try {
            QueryInvOrgHelper queryInvOrgHelper;
            List<Long> invOrgIds;
            this.cacheBillGroup(dataSet.copy());
            logger.info("------ynzy----cacheBillGroup.time-----" + time.msValue());
            time.reset();
            logger.info("------ynzy----cacheCostPrice.time-----" + time.msValue());
            time.reset();
            QFilter costAccountFilter = new QFilter("costaccount", "in", this.calByElementMap.keySet());
            QFilter recentCostFilter = new QFilter("material", "in", materialIdSet);
            if (calRangeSet.isEmpty() && !(invOrgIds = (queryInvOrgHelper = new QueryInvOrgHelper()).queryInvOrgByEntity(this.entityName, Arrays.asList(this.billIds))).isEmpty()) {
                invOrgIds.add(0L);
                recentCostFilter.and(new QFilter("storageorgunit", "in", invOrgIds));
            }
            DataSet recentCostDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_recentcost", (String)("id,material,costaccount,recentqty,recentcost,price,priceupdatetime,calrptid,calrange,to_char(costelement) as costelement,to_char(costsubelement) as costsubelement," + this.totalKey), (QFilter[])new QFilter[]{costAccountFilter, recentCostFilter}, null);
            DataSet groupRCDataSet = recentCostDataSet.copy().groupBy((String[])ArrayUtils.concatAll((Object[])new String[]{"material", "costaccount", "recentqty", "calrptid", "calrange"}, (Object[][])new String[][]{this.totalKey.split(",")})).sum("recentcost").sum("price").max("priceupdatetime").finish().select("-1L as id,material,costaccount,recentqty,recentcost,price,priceupdatetime,calrptid,calrange,'-1' as costelement,'-1' as costsubelement," + this.totalKey);
            DataSet rcDataSet = recentCostDataSet.union(groupRCDataSet);
            if (!calRangeSet.isEmpty()) {
                DataSet divideDataSet;
                DataSet calRangeDataSet = copyFinalDataSet.copy().filter(new QFilter("calrange", "in", calRangeSet).toString());
                if (!calRangeDataSet.isEmpty()) {
                    time.reset();
                    this.handleCalRangeDataSet(finalDataSet.copy(), calRangeDataSet, rcDataSet.copy());
                    logger.info("------ynzy----handleCalRangeDataSet.time-----" + time.msValue());
                    time.reset();
                }
                if (!(divideDataSet = copyFinalDataSet.copy().filter(new QFilter("calrange", "not in", calRangeSet).toString())).isEmpty()) {
                    this.handleDivideDataSet(finalDataSet, divideDataSet, rcDataSet);
                }
            } else {
                this.handleDivideDataSet(finalDataSet, copyFinalDataSet, rcDataSet);
            }
            if ("cal_costrecord".equals(this.entityName)) {
                this.writeCostRecordEntry();
                this.writeIsCal(entryIdSet);
            }
            time.reset();
            this.writeCostAdjust();
            logger.info("------ynzy----writeCostAdjust.time-----" + time.msValue());
            time.reset();
            this.writeRpt();
            logger.info("------ynzy----writeCostAdjust.time-----" + time.msValue());
            time.reset();
        }
        finally {
            for (DLock lock : lockSet) {
                lock.unlock();
            }
        }
    }

    private void writeCostAdjust() {
        if (!this.costAdjustMap.isEmpty()) {
            this.insertOtherElements();
            HashSet<Long> costAdjustEntryIdSet = new HashSet<Long>(128);
            HashSet<Long> costAdjustBillIdSet = new HashSet<Long>(this.costAdjustMap.size());
            SaveServiceHelper.save((DynamicObject[])this.costAdjustMap.values().toArray(new DynamicObject[0]));
            for (Map.Entry<Long, DynamicObject> entry : this.costAdjustMap.entrySet()) {
                DynamicObject info = entry.getValue();
                costAdjustBillIdSet.add(info.getLong("id"));
                for (DynamicObject entryInfo : info.getDynamicObjectCollection("entryentity")) {
                    costAdjustEntryIdSet.add(entryInfo.getLong("id"));
                }
            }
            DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])costAdjustBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreop", "true");
            option.setVariableValue("ishasright", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)option);
            List errors = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess() || !errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                String msg1 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a%1$s", (String)"MoveAddAverageCalculate_8", (String)"fi-cal-business", (Object[])new Object[0]), msg + result.getMessage());
                throw new KDBizException(msg1);
            }
            if (!this.isNewBalance) {
                new BalanceCalculator().updateBalance4CostAdjust(costAdjustEntryIdSet.toArray());
            }
        }
    }

    private void insertOtherElements() {
        ArrayList<Long[]> costAllSubElements = new ArrayList<Long[]>(16);
        HashMap<Long, Boolean> costElementCache = new HashMap<Long, Boolean>(this.costAdjustMap.size());
        for (Map.Entry<Long, DynamicObject> entry : this.costAdjustMap.entrySet()) {
            DynamicObject info = entry.getValue();
            Long costAccountId = (Long)info.get("costaccount");
            Boolean isCostElement = (Boolean)costElementCache.get(costAccountId);
            if (isCostElement == null) {
                isCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
                costElementCache.put(costAccountId, isCostElement);
            }
            if (!isCostElement.booleanValue()) continue;
            if (costAllSubElements.isEmpty()) {
                HashSet<String> dupSet = new HashSet<String>(16);
                QFilter q = new QFilter("syncflag", "=", (Object)"1");
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
                     DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);){
                    DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement"}, new String[]{"element"}).finish();
                    Object object = null;
                    try {
                        for (Row row : joinDataSet) {
                            if (!dupSet.add(row.getLong("subelement") + "|" + row.getLong("element"))) continue;
                            costAllSubElements.add(new Long[]{row.getLong("subelement"), row.getLong("element")});
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (joinDataSet != null) {
                            if (object != null) {
                                try {
                                    joinDataSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                joinDataSet.close();
                            }
                        }
                    }
                }
            }
            for (DynamicObject entryInfo : info.getDynamicObjectCollection("entryentity")) {
                DynamicObjectCollection details = entryInfo.getDynamicObjectCollection("subentryentity");
                DynamicObject firstDetail = (DynamicObject)details.get(0);
                if (firstDetail == null) continue;
                for (Long[] elements : costAllSubElements) {
                    boolean isExist = false;
                    for (DynamicObject detail : details) {
                        if (detail.getLong("costsubelement") != elements[0].longValue()) continue;
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    DynamicObject detailInfo = details.addNew();
                    long id = DB.genLongId((String)"t_cal_costadjust_detail");
                    detailInfo.set("id", (Object)id);
                    detailInfo.set("sub_material", firstDetail.get("sub_material"));
                    detailInfo.set("costelement", (Object)elements[1]);
                    detailInfo.set("costsubelement", (Object)elements[0]);
                    detailInfo.set("sub_currency", firstDetail.get("sub_currency"));
                    detailInfo.set("sub_adjustamt", (Object)BigDecimal.ZERO);
                }
            }
        }
    }

    private void handleCalRangeDataSet(DataSet finalDataSet, DataSet calRangeDataSet, DataSet recentCostDataSet) {
        finalDataSet = finalDataSet.groupBy(new String[]{"caldimension", "caldimensionstr"}).finish().select(new String[]{"caldimension", "caldimensionstr"});
        int count = 0;
        for (Row row : finalDataSet) {
            DataSet copyCalRangeDataSet = calRangeDataSet.copy();
            long caldimensionid = row.getLong("caldimension");
            copyCalRangeDataSet = copyCalRangeDataSet.filter("caldimension = " + caldimensionid);
            String calKey = "";
            String caldimension = row.getString("caldimensionstr");
            calKey = caldimensionid != 0L ? "calrange," + CommonUtils.trimComma((String)caldimension) : "calrange";
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            DataSet copyRCDataSet = recentCostDataSet.copy();
            JoinDataSet joinDataSet = copyCalRangeDataSet.join(copyRCDataSet, JoinType.LEFT);
            for (String onField : onFields) {
                joinDataSet = joinDataSet.on(onField, onField);
            }
            joinDataSet = joinDataSet.on("costaccount", "costaccount").on("material", "material");
            DataSet detailDataSet = joinDataSet.select((this.getAliasSelects() + ",type").split(","), new String[]{"id as recentcostid", "recentqty", "recentcost", "price", "priceupdatetime", "calrptid"}).finish().orderBy(new String[]{"auditdate", "type", "billno", "entryseq", "costsubelement desc"});
            this.cacheRpt(detailDataSet.copy(), onFields, false);
            try (TraceSpan span = Tracer.create((String)"MoveAddAverageCalculate-cacheRpt", (String)"MoveAddAverageCalculate-cacheRpt");){
                this.handleDetailDataSet(detailDataSet, onFields);
            }
            ++count;
        }
        logger.info("------ynzy----finalDataSet.size-----" + count);
    }

    private void handleDivideDataSet(DataSet finalDataSet, DataSet divideDataSet, DataSet recentCostDataSet) {
        finalDataSet = finalDataSet.groupBy(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"}).finish().select(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"});
        for (Row row : finalDataSet) {
            DataSet copyDivideDataSet = divideDataSet.copy();
            long dividebasisid = row.getLong("dividebasis");
            long caldimensionid = row.getLong("caldimension");
            String dividebasis = row.getString("dividebasisstr");
            copyDivideDataSet = copyDivideDataSet.filter("dividebasis = " + dividebasisid + " and caldimension = " + caldimensionid);
            String calKey = "";
            String caldimension = row.getString("caldimensionstr");
            calKey = caldimensionid != 0L ? CommonUtils.trimComma((String)dividebasis) + "," + CommonUtils.trimComma((String)caldimension) : CommonUtils.trimComma((String)dividebasis);
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            DataSet copyRCDataSet = recentCostDataSet.copy();
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            JoinDataSet joinDataSet = copyDivideDataSet.join(copyRCDataSet, JoinType.LEFT, hint);
            for (String onField : onFields) {
                joinDataSet = joinDataSet.on(onField, onField);
            }
            joinDataSet = joinDataSet.on("costaccount", "costaccount").on("material", "material");
            DataSet detailDataSet = joinDataSet.select((this.getAliasSelects() + ",type").split(","), new String[]{"id as recentcostid", "recentqty", "recentcost", "price", "priceupdatetime", "calrptid"}).finish().orderBy(new String[]{"auditdate", "type", "billno", "entryseq", "costsubelement desc"});
            this.cacheRpt(detailDataSet.copy(), onFields, true);
            this.handleDetailDataSet(detailDataSet, onFields);
        }
    }

    private void cacheBillGroup(DataSet dataSet) {
        if ("cal_costrecord".equals(this.entityName)) {
            HashMap costAccount_calEntryIdMap = new HashMap();
            for (Row row : dataSet) {
                long costAccount = row.getLong("costaccount");
                long calentryId = row.getLong("calentryid");
                long period = row.getLong("period");
                if (costAccount_calEntryIdMap.containsKey(costAccount + "|" + period)) {
                    ((Set)costAccount_calEntryIdMap.get(costAccount + "|" + period)).add(calentryId);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(calentryId);
                costAccount_calEntryIdMap.put(costAccount + "|" + period, set);
            }
            for (Map.Entry entry : costAccount_calEntryIdMap.entrySet()) {
                String key = (String)entry.getKey();
                Map<String, BigDecimal> map = GroupRelationCostCalculator.calculateCost(key.split("\\|")[0], Long.parseLong(key.split("\\|")[1]), (Set)entry.getValue());
                this.billGroupMap.putAll(map);
            }
            logger.info("\u6210\u7ec4\u5173\u7cfb\u83b7\u53d6\uff1a" + this.billGroupMap);
        }
    }

    private void cacheRpt(DataSet detailDataSet, String[] onFields, boolean isEmptyRange) {
        char innerSplit = '_';
        String outSplit = "&";
        HashSet<Long> rptSet = new HashSet<Long>();
        for (Row row : detailDataSet.copy()) {
            long calrptid = row.get("calrptid") == null ? 0L : row.getLong("calrptid");
            if (calrptid == 0L) continue;
            rptSet.add(calrptid);
        }
        DynamicObject[] rptInfos = BusinessDataServiceHelper.load((Object[])rptSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_calculateoutrpt"));
        HashMap<Object, DynamicObject> rptCacheMap = new HashMap<Object, DynamicObject>(rptInfos.length);
        for (DynamicObject info : rptInfos) {
            rptCacheMap.put(info.getPkValue(), info);
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_caloutrpt");
        for (Row row : detailDataSet) {
            DynamicObject rptInfo;
            String value;
            String key = this.getGroupKey(row, onFields, false);
            long calrptid = row.get("calrptid") == null ? 0L : row.getLong("calrptid");
            long costaccount = row.getLong("costaccount");
            long material = row.getLong("material");
            long dividebasisid = row.getLong("dividebasis");
            long caldimensionid = row.getLong("caldimension");
            long calOrgId = row.getLong("calorgid");
            long calRangeId = row.getLong("calrange");
            String dividebasisStr = row.getString("dividebasisstr");
            String caldimensionStr = row.getString("caldimensionstr");
            String divideBasisValue = "";
            StringBuilder divideBasisValueSB = new StringBuilder();
            String caldimensionValue = "";
            StringBuilder caldimensionValueSB = new StringBuilder();
            if (StringUtils.isNotEmpty((String)dividebasisStr)) {
                for (String s : dividebasisStr.split(",")) {
                    value = row.get(s).toString();
                    if (value.trim().isEmpty()) {
                        value = "#";
                    }
                    divideBasisValueSB.append(value).append(innerSplit);
                }
                divideBasisValue = divideBasisValueSB.substring(0, divideBasisValueSB.length() - 1);
            }
            if (StringUtils.isNotEmpty((String)caldimensionStr)) {
                for (String s : caldimensionStr.split(",")) {
                    value = row.get(s).toString();
                    if (value.trim().isEmpty()) {
                        value = "#";
                    }
                    caldimensionValueSB.append(value).append(innerSplit);
                }
                caldimensionValue = caldimensionValueSB.substring(0, caldimensionValueSB.length() - 1);
            }
            if (!rptCacheMap.containsKey(calrptid) && !this.rptMap.containsKey(key)) {
                DynamicObject curPeriod;
                rptInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_calculateoutrpt");
                rptInfo.set("costaccount", (Object)costaccount);
                Long curPeriodId = this.periodMap.get(costaccount);
                if (curPeriodId == null && (curPeriod = "cal_balance".equals(this.entityName) || "cal_initbill".equals(this.entityName) ? PeriodHelper.getStartPeriod((Long)costaccount) : PeriodHelper.getCurrentPeriod((Long)costaccount)) != null) {
                    curPeriodId = curPeriod.getLong("id");
                }
                if (curPeriodId == null) {
                    curPeriodId = 0L;
                }
                this.periodMap.put(costaccount, curPeriodId);
                rptInfo.set("calorg", (Object)calOrgId);
                rptInfo.set("period", (Object)curPeriodId);
                rptInfo.set("material", (Object)material);
                rptInfo.set("dividebasis", (Object)dividebasisid);
                rptInfo.set("caldimension", (Object)caldimensionid);
                rptInfo.set("calrange", (Object)calRangeId);
                if (isEmptyRange) {
                    rptInfo.set("dividebasisvalue", (Object)divideBasisValue);
                }
                rptInfo.set("caldimensionvalue", (Object)caldimensionValue);
                rptInfo.set("accounttype", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
                rptInfo.set("caltime", (Object)TimeServiceHelper.now());
                rptInfo.set("operationuser", (Object)RequestContext.get().getUserId());
                rptInfo.set("calstatus", (Object)"A");
                rptInfo.set("id", (Object)idGenerator.getId());
                this.rptMap.put(key, rptInfo);
                continue;
            }
            rptInfo = (DynamicObject)rptCacheMap.get(calrptid);
            if (rptInfo == null) {
                rptInfo = this.rptMap.get(key);
            }
            if (rptInfo == null) continue;
            if (isEmptyRange && rptInfo.getString("dividebasisvalue").indexOf(divideBasisValue) < 0) {
                rptInfo.set("dividebasisvalue", (Object)(rptInfo.get("dividebasisvalue") + outSplit + divideBasisValue));
            }
            if (rptInfo.getString("caldimensionvalue").indexOf(caldimensionValue) < 0) {
                rptInfo.set("caldimensionvalue", (Object)(rptInfo.get("caldimensionvalue") + outSplit + caldimensionValue));
            }
            rptInfo.set("caltime", (Object)TimeServiceHelper.now());
            rptInfo.set("operationuser", (Object)RequestContext.get().getUserId());
            this.rptMap.put(key, rptInfo);
        }
    }

    private void handleDetailDataSet(DataSet detailDataSet, String[] onFields) {
        HashMap<String, RecentCostInfo> costMap = new HashMap<String, RecentCostInfo>();
        HashSet<String> insertSet = new HashSet<String>();
        HashMap<String, Long> costIdMap = new HashMap<String, Long>();
        HashMap<Long, RecentCostInfo> detailRecentCostMap = new HashMap<Long, RecentCostInfo>();
        HashMap<Long, String> detailKeyMap = new HashMap<Long, String>();
        HashMap<Long, List<BillInfo>> dataMap = new HashMap<Long, List<BillInfo>>();
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        this.cacheMap(detailDataSet, onFields, costMap, insertSet, costIdMap, detailRecentCostMap, detailKeyMap, dataMap, entryIdList);
        for (Long entryId : entryIdList) {
            List list = (List)dataMap.get(entryId);
            HashMap<Long, RecentCostInfo> costAdjustDetailMap = new HashMap<Long, RecentCostInfo>(16);
            HashMap<Long, RecentCostInfo> beginMap = new HashMap<Long, RecentCostInfo>(16);
            BillInfo parentBillInfo = (BillInfo)list.get(list.size() - 1);
            for (BillInfo billInfo : list) {
                String key = (String)detailKeyMap.get(billInfo.getDetailId());
                boolean isDetail = this.isDetail(key);
                RecentCostInfo recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(billInfo.getDetailId());
                RecentCostInfo beginInfo = recentCostInfo.copy();
                this.handlePrecision(beginInfo, billInfo.getQtyPrecision(), billInfo.getAmtPrecision(), billInfo.getPricePrecision());
                beginMap.put(billInfo.getDetailId(), beginInfo);
                this.handleRecentCost(billInfo, parentBillInfo, recentCostInfo, costAdjustDetailMap, isDetail);
                if (!isDetail || "cal_balance".equals(this.entityName)) continue;
                this.checkRecentCost(recentCostInfo, billInfo, costAdjustDetailMap);
            }
            if ("cal_costrecord".equals(this.entityName)) {
                this.checkBillInfo(parentBillInfo);
            }
            RecentCostInfo parentRcInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
            RecentCostInfo parentBeginInfo = (RecentCostInfo)beginMap.get(parentBillInfo.getDetailId());
            String parentKey = (String)detailKeyMap.get(parentBillInfo.getDetailId());
            DynamicObject parentRptInfo = this.rptMap.get(this.getRptKey(parentKey));
            this.handlePrecision(parentBillInfo, parentBillInfo.getQtyPrecision(), parentBillInfo.getAmtPrecision(), parentBillInfo.getPricePrecision());
            this.addRptEntry(parentRptInfo, parentBillInfo, parentBeginInfo, parentRcInfo);
            for (int i = 0; i < list.size() - 1; ++i) {
                BillInfo billInfo = (BillInfo)list.get(i);
                String key = (String)detailKeyMap.get(billInfo.getDetailId());
                DynamicObject rptInfo = this.rptMap.get(this.getRptKey(key));
                RecentCostInfo recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(billInfo.getDetailId());
                RecentCostInfo beginInfo = (RecentCostInfo)beginMap.get(billInfo.getDetailId());
                this.addRptEntry(rptInfo, billInfo, beginInfo, recentCostInfo);
            }
            DynamicObject costAdjustbill = this.costAdjustMap.get(parentBillInfo.getBillEntryId());
            DynamicObject costAdjustEntry = this.costAdjustEntryMap.get(parentBillInfo.getBillEntryId());
            if (costAdjustbill == null || costAdjustEntry == null) continue;
            this.addRptEntry4CostAdjust(parentRptInfo, parentBillInfo, parentRcInfo, costAdjustDetailMap, costAdjustbill, costAdjustEntry);
        }
        this.writeRecentCost(costMap, insertSet, costIdMap, onFields);
    }

    private void checkBillInfo(BillInfo billInfo) {
        if ("0".equals(this.opType)) {
            return;
        }
        if (this.zeroInOutBizTypeIds.contains(billInfo.getBiztypeId()) && billInfo.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (billInfo.getPrice().compareTo(BigDecimal.ZERO) <= 0 && !this.groupPriceName.equals(billInfo.getPriceTypeName())) {
            StringBuilder msg = new StringBuilder();
            if ("1".equals(billInfo.getQueueType()) && !billInfo.isPresent()) {
                String errorMsg = ResManager.loadKDString((String)"\u975e\u8d60\u54c1\u884c\u5165\u5e93\u5355\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u786e\u8ba4\u3002\u5efa\u8bae\u901a\u8fc7\u5355\u636e\u5f55\u5165\u5355\u4ef7\u91d1\u989d\u6216\u8005\u901a\u8fc7\u6838\u7b97\u914d\u7f6e-\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u5355\u636e\u540c\u6b65\u53d6\u4ef7\uff0c\u6216\u8005\u91c7\u7528\u975e\u5373\u65f6\u6838\u7b97\u7b97\u6cd5\uff1a%3$s\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"FIFOCalculate_14", (String)"fi-cal-business", (Object[])new Object[0]);
                msg.append(errorMsg);
            } else if ("0".equals(billInfo.getQueueType())) {
                String errorMsg = ResManager.loadKDString((String)"\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u5355\u4ef7\u5f02\u5e38\uff0c\u6838\u7b97\u4e2d\u6b62\uff0c\u8bf7\u6838\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u53ca\u5355\u636e\uff0c\u786e\u4fdd\u6838\u7b97\u5355\u636e\u6570\u91cf\u91d1\u989d\u6b63\u786e\uff1a%3$s\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"FIFOCalculate_15", (String)"fi-cal-business", (Object[])new Object[0]);
                msg.append(errorMsg);
            }
            if (msg.length() > 0) {
                throw new KDBizException(String.format(msg.toString(), billInfo.getMaterialNum(), billInfo.getMaterialName(), ""));
            }
        }
    }

    private String getRptKey(String key) {
        String rptkey = key.substring(0, key.lastIndexOf(44));
        rptkey = rptkey.substring(0, rptkey.lastIndexOf(44));
        return rptkey;
    }

    private boolean isDetail(String key) {
        String[] keys = key.split(",");
        String subElementId = keys[keys.length - 1];
        return !"-1".equals(subElementId);
    }

    private BillInfo buildBillInfo(Row row) {
        String createType;
        BillInfo info = new BillInfo();
        info.setAmtPrecision(row.getInteger("amtprecision"));
        info.setBaseUnitId(row.getLong("baseunit"));
        info.setBillId(row.getLong("billid"));
        info.setBillEntryId(row.getLong("eid"));
        info.setDetailId(row.getLong("entryid"));
        String billTypeName = row.getString("billtypename");
        String invbillnum = row.getString("invbillnum");
        if (StringUtils.isNotEmpty((String)invbillnum)) {
            billTypeName = String.format(ResManager.loadKDString((String)"%1$s(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%2$s)", (String)"MoveAddAverageCalculate_13", (String)"fi-cal-business", (Object[])new Object[0]), billTypeName, invbillnum);
        }
        if (("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) && !StringUtils.isEmpty((String)(createType = CostAdjustBilCreateTypeEnum.getEnumDesc((String)row.getString("createtype"))))) {
            info.setCostpricesource(createType);
        }
        info.setCreateType(row.getString("createtype"));
        if ("cal_costrecord".equals(this.entityName)) {
            info.setBiztypeId(row.getLong("biztype"));
        }
        info.setBillTypeName(billTypeName);
        info.setBillTypeNum(row.getString("billtypenumber"));
        info.setCalEntryId(row.getLong("calentryid"));
        BigDecimal signnum = BigDecimal.valueOf(row.getInteger("signnum").intValue());
        info.setSignnum(signnum);
        info.setCost(row.getBigDecimal("billcost").multiply(signnum));
        info.setCostElementId(Long.parseLong(row.getString("costelement")));
        info.setCostSubElementId(Long.parseLong(row.getString("costsubelement")));
        info.setCurrencyId(row.getLong("currency"));
        info.setDisplayPricePrecision(row.getInteger("displaypricepc"));
        info.setMaterialId(row.getLong("material"));
        info.setPrice(row.getBigDecimal("unitactualcost"));
        info.setPricePrecision(row.getInteger("priceprecision"));
        info.setQty(row.getBigDecimal("billqty").multiply(signnum));
        info.setQtyPrecision(row.getInteger("qtyprecision"));
        info.setPresent(row.getBoolean("ispresent"));
        info.setQueueType(row.getString("type"));
        info.setCostAccountId(row.getLong("costaccount"));
        info.setBillNo(row.getString("billno"));
        info.setCalOrgId(row.getLong("calorgid"));
        info.setMaterialName(row.getString("materialname"));
        info.setMaterialNum(row.getString("materialnum"));
        info.setBizDate(row.getDate("bizdate"));
        info.setAuditDate(row.getDate("auditdate"));
        info.setFee(row.getBigDecimal("fee").multiply(signnum));
        info.setProcessCost(row.getBigDecimal("processcost").multiply(signnum));
        info.setManufactureCost(row.getBigDecimal("manufacturecost").multiply(signnum));
        info.setResource(row.getBigDecimal("resource").multiply(signnum));
        info.setMaterialCost(row.getBigDecimal("materialcost").multiply(signnum));
        info.setBizEntityObject(row.getString("bizentityobject"));
        return info;
    }

    private void writeCostRecordEntry() {
        BigDecimal[] costs;
        String[] keys;
        String key;
        if (!this.recordMap.isEmpty()) {
            String recordUpateSql = "update t_cal_costrecord_detail set factualcost = ?,funitactualcost = ? where fentryid = ? and fcostsubelementid = ?";
            ArrayList<Object[]> recordList = new ArrayList<Object[]>(this.recordMap.size());
            for (Map.Entry<String, BigDecimal[]> entry : this.recordMap.entrySet()) {
                key = entry.getKey();
                keys = key.split("\\|");
                costs = entry.getValue();
                Long entryId = Long.valueOf(keys[0]);
                Long subElementId = Long.valueOf(keys[1]);
                BigDecimal actualCost = costs[0];
                BigDecimal unitCost = costs[1];
                Object[] param = new Object[]{actualCost, unitCost, entryId, subElementId};
                recordList.add(param);
            }
            if (!recordList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)recordUpateSql, recordList);
            }
        }
        if (!this.costRecordEntrySet.isEmpty()) {
            if (!this.byElementCostRecordEntrySet.isEmpty()) {
                CostElementHelper.calCostRecordAllCost((Long[])this.byElementCostRecordEntrySet.toArray(new Long[0]));
            }
            if (!this.noneElementCostRecordEntrySet.isEmpty()) {
                Object[] param;
                ArrayList<Object[]> paramList;
                String sql;
                if (!this.recordMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set factualcost = ? ,funitactualcost = ? where fentryid = ?";
                    paramList = new ArrayList<Object[]>(this.recordMap.size());
                    for (Map.Entry<String, BigDecimal[]> entry : this.recordMap.entrySet()) {
                        key = entry.getKey();
                        keys = key.split("\\|");
                        Long entryId = Long.valueOf(keys[0]);
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        BigDecimal[] costs2 = entry.getValue();
                        Object[] param2 = new Object[]{costs2[0], costs2[1], entryId};
                        paramList.add(param2);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.materialCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fmaterialcost = ? ,funitmaterialcost = ? where fentryid = ?";
                    paramList = new ArrayList(this.materialCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.materialCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.feeMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set ffee = ? ,funitfee = ? where fentryid = ?";
                    paramList = new ArrayList(this.feeMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.feeMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.processCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fprocesscost = ? ,funitprocesscost = ? where fentryid = ?";
                    paramList = new ArrayList(this.processCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.processCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.manufactureCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fmanufacturecost = ? ,funitmanufacturecost = ? where fentryid = ?";
                    paramList = new ArrayList(this.manufactureCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.manufactureCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.resourceMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fresource = ? ,funitresource = ? where fentryid = ?";
                    paramList = new ArrayList(this.resourceMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.resourceMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, (Object)this.billIds)});){
                    ctx.set();
                    CostElementHelper.calCostRecordProcessCost((Long[])this.omInCostRecordEntrys.toArray(new Long[0]));
                    CostElementHelper.calCostRecordMaterialCost((Long[])this.notOmInCostRecordEntrys.toArray(new Long[0]));
                }
            }
        }
    }

    private void writeIsCal(Set<Long> entryIdSet) {
        if (entryIdSet.isEmpty() || "0".equals(this.opType)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (long entryId : entryIdSet) {
            sb.append(entryId).append(",");
        }
        String ids = sb.substring(0, sb.length() - 1);
        String sql = "update t_cal_calcostrecordentry set fiscalculated = '1' where fentryid in (" + ids + ")";
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql);
    }

    private void handleRecentCost(BillInfo billInfo, BillInfo parentBillInfo, RecentCostInfo recentCostInfo, Map<Long, RecentCostInfo> costAdjustDetailMap, boolean isDetail) {
        BigDecimal cost;
        BigDecimal qty;
        String type = billInfo.getQueueType();
        int pricePrecision = billInfo.getPricePrecision();
        int amountPrecision = billInfo.getAmtPrecision();
        int qtyPrecision = billInfo.getQtyPrecision();
        RecentCostInfo inInfo = null;
        RecentCostInfo outInfo = null;
        if ("1".equals(this.opType)) {
            if ("cal_costrecord".equals(this.entityName)) {
                if ("1".equals(type)) {
                    if (isDetail) {
                        inInfo = this.inHandleGroup(billInfo, recentCostInfo);
                        parentBillInfo.setCost(parentBillInfo.getCost().add(inInfo.getRecentCost().subtract(billInfo.getCost())));
                        parentBillInfo.setPrice(parentBillInfo.getPrice().add(inInfo.getRecentPrice().subtract(billInfo.getPrice())));
                        if (inInfo.getRecentCost().compareTo(BigDecimal.ZERO) != 0) {
                            parentBillInfo.setPriceTypeName(billInfo.getPriceTypeName());
                        }
                    } else {
                        inInfo = new RecentCostInfo();
                        inInfo.setRecentCost(billInfo.getCost());
                        inInfo.setRecentQty(billInfo.getQty());
                        inInfo.setRecentPrice(billInfo.getPrice());
                    }
                } else if (isDetail) {
                    outInfo = this.outHandleGroup(billInfo, recentCostInfo);
                    parentBillInfo.setCost(parentBillInfo.getCost().add(outInfo.getRecentCost().subtract(billInfo.getCost())));
                    parentBillInfo.setPrice(parentBillInfo.getPrice().add(outInfo.getRecentPrice().subtract(billInfo.getPrice())));
                    if (outInfo.getRecentCost().compareTo(BigDecimal.ZERO) != 0) {
                        parentBillInfo.setPriceTypeName(billInfo.getPriceTypeName());
                    }
                } else {
                    outInfo = new RecentCostInfo();
                    outInfo.setRecentCost(billInfo.getCost());
                    outInfo.setRecentQty(billInfo.getQty());
                    outInfo.setRecentPrice(billInfo.getPrice());
                }
            } else if ("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) {
                BigDecimal cost2 = billInfo.getCost();
                if ("1".equals(type)) {
                    inInfo = new RecentCostInfo();
                    inInfo.setRecentCost(cost2);
                } else {
                    outInfo = new RecentCostInfo();
                    outInfo.setRecentCost(cost2);
                }
            } else if ("cal_balance".equals(this.entityName) || "cal_initbill".equals(this.entityName)) {
                qty = billInfo.getQty();
                cost = billInfo.getCost();
                inInfo = new RecentCostInfo();
                inInfo.setRecentCost(cost);
                inInfo.setRecentQty(qty);
            }
        } else {
            qty = billInfo.getQty();
            cost = billInfo.getCost();
            BigDecimal unitactualcost = billInfo.getPrice();
            if ("cal_balance".equals(this.entityName) || "cal_initbill".equals(this.entityName)) {
                inInfo = new RecentCostInfo();
                inInfo.setRecentCost(cost.negate());
                inInfo.setRecentQty(qty.negate());
            } else if ("1".equals(type)) {
                inInfo = new RecentCostInfo();
                inInfo.setRecentCost(cost.negate());
                inInfo.setRecentQty(qty.negate());
                inInfo.setRecentPrice(unitactualcost);
            } else {
                outInfo = new RecentCostInfo();
                outInfo.setRecentCost(cost.negate());
                outInfo.setRecentQty(qty.negate());
                outInfo.setRecentPrice(unitactualcost);
            }
        }
        BigDecimal endCost = recentCostInfo.getRecentCost().add(inInfo == null ? BigDecimal.ZERO : inInfo.getRecentCost()).subtract(outInfo == null ? BigDecimal.ZERO : outInfo.getRecentCost());
        BigDecimal endQty = recentCostInfo.getRecentQty().add(inInfo == null ? BigDecimal.ZERO : inInfo.getRecentQty()).subtract(outInfo == null ? BigDecimal.ZERO : outInfo.getRecentQty());
        recentCostInfo.setRecentCost(endCost);
        recentCostInfo.setRecentQty(endQty);
        this.handlePrecision(recentCostInfo, qtyPrecision, amountPrecision, pricePrecision);
        if (inInfo != null) {
            billInfo.setCost(inInfo.getRecentCost());
            billInfo.setPrice(inInfo.getRecentPrice());
            billInfo.setQty(inInfo.getRecentQty());
        } else if (outInfo != null) {
            billInfo.setCost(outInfo.getRecentCost());
            billInfo.setPrice(outInfo.getRecentPrice());
            billInfo.setQty(outInfo.getRecentQty());
        }
        if (billInfo != parentBillInfo) {
            this.handlePrecision(billInfo, qtyPrecision, amountPrecision, pricePrecision);
        }
    }

    private void handlePrecision(BillInfo billInfo, int qtyPrecision, int amountPrecision, int pricePrecision) {
        billInfo.setCost(billInfo.getCost().setScale(amountPrecision, 4));
        billInfo.setQty(billInfo.getQty().setScale(qtyPrecision, 4));
        billInfo.setPrice(this.getRecentPrice(billInfo, pricePrecision));
    }

    private BigDecimal getRecentPrice(BillInfo info, int pricePrecision) {
        if (info.getPrice() != null && info.getPrice().compareTo(BigDecimal.ZERO) != 0) {
            return info.getPrice().setScale(pricePrecision, 4);
        }
        if (info.getCost() == null || info.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (info.getQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = info.getCost().divide(info.getQty(), pricePrecision, 4);
        return price;
    }

    private void checkRecentCost(RecentCostInfo recentCostInfo, BillInfo billInfo, Map<Long, RecentCostInfo> costAdjustDetailMap) {
        BigDecimal balCost = recentCostInfo.getRecentCost();
        BigDecimal balQty = recentCostInfo.getRecentQty();
        int amountPrecision = billInfo.getAmtPrecision();
        BigDecimal newCost = null;
        if (balQty.signum() == 0 && balCost.signum() != 0) {
            newCost = BigDecimal.ZERO;
        }
        String prevCostParam = this.getPrevCostParam(billInfo);
        boolean isNoAdj = this.getIsNoAdj(billInfo.getCreateType(), prevCostParam);
        if (isNoAdj) {
            return;
        }
        String diffBillType = this.createDiffbillTypeMap.get(billInfo.getCalOrgId());
        if ("no".equals(diffBillType)) {
            return;
        }
        if (newCost != null) {
            BigDecimal adjustAmt = newCost.subtract(balCost).negate();
            DynamicObject costAdjustInfo = this.costAdjustMap.get(billInfo.getBillEntryId());
            DynamicObject costAdjustEntry = this.costAdjustEntryMap.get(billInfo.getBillEntryId());
            DynamicObject loadBill = this.loadBillMap.get(billInfo.getBillId());
            DynamicObject loadEntry = this.loadEntryMap.get(billInfo.getBillEntryId());
            if (costAdjustInfo != null) {
                if (costAdjustEntry == null) {
                    costAdjustEntry = this.createCostAdjustEntry(loadBill, loadEntry, costAdjustInfo);
                    this.costAdjustEntryMap.put(billInfo.getBillEntryId(), costAdjustEntry);
                }
            } else {
                costAdjustInfo = this.createCostAdjustHead(loadBill);
                costAdjustEntry = this.createCostAdjustEntry(loadBill, loadEntry, costAdjustInfo);
                this.costAdjustMap.put(billInfo.getBillEntryId(), costAdjustInfo);
                this.costAdjustEntryMap.put(billInfo.getBillEntryId(), costAdjustEntry);
            }
            DynamicObject detail = this.createCostAdjustDetail(costAdjustEntry, billInfo, adjustAmt);
            costAdjustDetailMap.put(detail.getLong("id"), recentCostInfo);
        }
    }

    private DynamicObject createCostAdjustHead(DynamicObject loadBill) {
        DynamicObject costAdjustInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustInfo.set("cstype", (Object)"bd_customer");
        if ("cal_costrecord".equals(this.entityName) || "cal_initbill".equals(this.entityName)) {
            costAdjustInfo.set("currency", loadBill.get("localcurrency_id"));
        } else {
            costAdjustInfo.set("currency", loadBill.get("currency_id"));
        }
        costAdjustInfo.set("id", (Object)DB.genLongId((String)"t_cal_costadjustbill"));
        costAdjustInfo.set("biztype", (Object)"B");
        costAdjustInfo.set("billstatus", (Object)"B");
        costAdjustInfo.set("difftype", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        costAdjustInfo.set("createtype", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getValue());
        long costaccountId = loadBill.getLong("costaccount_id");
        costAdjustInfo.set("costaccount", (Object)costaccountId);
        costAdjustInfo.set("calorg", (Object)loadBill.getLong("calorg_id"));
        costAdjustInfo.set("billtype", (Object)this.costAdjustOutBillType);
        Date date = TimeServiceHelper.now();
        costAdjustInfo.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustInfo.set("creator_id", (Object)userId);
        costAdjustInfo.set("auditdate", (Object)date);
        costAdjustInfo.set("auditor_id", (Object)userId);
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustInfo, (String)loadBill.getString("calorg_id"));
        costAdjustInfo.set("billno", (Object)number);
        if ("cal_initbill".equals(this.entityName)) {
            costAdjustInfo.set("period", (Object)this.periodMap.get(costaccountId));
            Date beginDate = this.begindateMap.get(costaccountId);
            if (beginDate == null) {
                beginDate = PeriodHelper.getStartPeriod((Long)costaccountId).getDate("begindate");
                this.begindateMap.put(costaccountId, beginDate);
            }
            costAdjustInfo.set("bizdate", (Object)beginDate);
            costAdjustInfo.set("bookdate", (Object)beginDate);
        } else {
            costAdjustInfo.set("bizdate", (Object)loadBill.getDate("bizdate"));
            costAdjustInfo.set("bookdate", (Object)loadBill.getDate("bookdate"));
            costAdjustInfo.set("adminorg_id", (Object)loadBill.getLong("adminorg_id"));
        }
        return costAdjustInfo;
    }

    private DynamicObject createCostAdjustEntry(DynamicObject loadInfo, DynamicObject loadEntry, DynamicObject costAdjustInfo) {
        DynamicObject costAdjustEntry = costAdjustInfo.getDynamicObjectCollection("entryentity").addNew();
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityName);
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        long id = DB.genLongId((String)"t_cal_costadjustbillentry");
        costAdjustEntry.set("id", (Object)id);
        if ("cal_costrecord".equals(this.entityName)) {
            costAdjustEntry.set("storageorgunit", loadInfo.get("storageorgunit_id"));
        } else {
            costAdjustEntry.set("storageorgunit", loadEntry.get("storageorgunit_id"));
        }
        costAdjustEntry.set("material", loadEntry.get("material_id"));
        costAdjustEntry.set("lot", loadEntry.get("lot"));
        costAdjustEntry.set("warehouse", loadEntry.get("warehouse_id"));
        costAdjustEntry.set("location", loadEntry.get("location_id"));
        costAdjustEntry.set("ownertype", (Object)"bos_org");
        costAdjustEntry.set("owner", loadEntry.get("owner_id"));
        costAdjustEntry.set("ecostcenter", loadEntry.get("ecostcenter_id"));
        costAdjustEntry.set("assist", loadEntry.get("assist_id"));
        costAdjustEntry.set("invbilltype", loadInfo.get("billtype_id"));
        costAdjustEntry.set("invbillnum", (Object)loadInfo.getString("billno"));
        costAdjustEntry.set("inventryseq", loadEntry.get("seq"));
        costAdjustEntry.set("invbillid", loadInfo.get("id"));
        String entityObject = "";
        entityObject = this.entityName.equals("cal_costrecord") ? "cal_costrecord_subentity" : (this.entityName.equals("cal_initbill") ? this.entityName : "cal_costadjust_subentity");
        costAdjustEntry.set("invbizentityobject", (Object)entityObject);
        costAdjustEntry.set("invbillentryid", loadEntry.get("id"));
        costAdjustEntry.set("baseunit", loadEntry.get("baseunit_id"));
        costAdjustEntry.set("project", loadEntry.get("project_id"));
        costAdjustEntry.set("invtype", loadEntry.get("invtype_id"));
        costAdjustEntry.set("invstatus", loadEntry.get("invstatus_id"));
        costAdjustEntry.set("mversion", loadEntry.get("mversion_id"));
        costAdjustEntry.set("tracknumber", loadEntry.get("tracknumber"));
        costAdjustEntry.set("configuredcode", loadEntry.get("configuredcode"));
        costAdjustEntry.set("noupdatecalfields", loadEntry.get("noupdatecalfields"));
        costAdjustEntry.set("stocktype", loadEntry.get("stocktype"));
        CommonSettingHelper.setExFieldValue((MainEntityType)costAdjustEntityType, (MainEntityType)billEntityType, (DynamicObject)costAdjustEntry, (DynamicObject)loadEntry);
        return costAdjustEntry;
    }

    private DynamicObject createCostAdjustDetail(DynamicObject costAdjustEntry, BillInfo billInfo, BigDecimal balCost) {
        DynamicObject detailInfo = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
        long id = DB.genLongId((String)"t_cal_costadjust_detail");
        detailInfo.set("id", (Object)id);
        detailInfo.set("sub_material", (Object)billInfo.getMaterialId());
        detailInfo.set("costelement", (Object)billInfo.getCostElementId());
        detailInfo.set("costsubelement", (Object)billInfo.getCostSubElementId());
        detailInfo.set("sub_currency", (Object)billInfo.getCurrencyId());
        detailInfo.set("sub_adjustamt", (Object)balCost);
        costAdjustEntry.set("adjustamt", (Object)costAdjustEntry.getBigDecimal("adjustamt").add(balCost));
        return detailInfo;
    }

    private void addRptEntry(DynamicObject rptInfo, BillInfo billInfo, RecentCostInfo beginInfo, RecentCostInfo endInfo) {
        String priceType;
        boolean isSubEntry;
        long costSubElement = billInfo.getCostSubElementId();
        boolean bl = isSubEntry = costSubElement != -1L;
        if (isSubEntry && billInfo.getCost().compareTo(BigDecimal.ZERO) == 0 && endInfo.getRecentCost().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int displaypricepc = billInfo.getDisplayPricePrecision();
        DynamicObject rptEntry = rptInfo.getDynamicObjectCollection("entryentity").addNew();
        String inStr = this.getInRecentString(billInfo, displaypricepc, isSubEntry);
        String outStr = this.getOutRecentString(billInfo, displaypricepc, isSubEntry);
        String endStr = this.getRecentString(beginInfo, displaypricepc) + "\n" + this.getRecentString(endInfo, displaypricepc);
        String billno = billInfo.getBillNo();
        String billtypenumber = billInfo.getBillTypeNum();
        String billtypename = billInfo.getBillTypeName();
        long billId = billInfo.getBillId();
        long billEntryId = billInfo.getDetailId();
        int seq = rptInfo.getInt("nextSeq");
        long parentId = 0L;
        if (isSubEntry) {
            billno = this.elementNameMap.get(costSubElement);
            if (billno == null) {
                billno = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id,name,number", (QFilter[])new QFilter("id", "=", (Object)costSubElement).toArray()).getString("name");
                this.elementNameMap.put(costSubElement, billno);
            }
            parentId = billInfo.getBillEntryId();
            billtypename = ResManager.loadKDString((String)"\u5b50\u8981\u7d20", (String)"MoveAddAverageCalculate_0", (String)"fi-cal-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)(priceType = billInfo.getPriceTypeName()))) {
            billtypename = billtypename + "\uff08" + priceType + "\uff09";
        }
        if ("0".equals(this.opType)) {
            String msg;
            billtypename = msg = String.format(ResManager.loadKDString((String)"%1$s\uff08\u53cd\u5ba1\u6838\uff09", (String)"FIFOCalculate_13", (String)"fi-cal-business", (Object[])new Object[0]), billtypename);
        }
        if (seq == 0) {
            seq = 1;
        }
        rptEntry.set("seq", (Object)seq);
        rptInfo.set("nextSeq", (Object)(seq + 1));
        rptEntry.set("bizbillid", (Object)billId);
        rptEntry.set("bizbillentryid", (Object)billEntryId);
        rptEntry.set("billnumber", (Object)billno);
        rptEntry.set("billtypenum", (Object)billtypenumber);
        rptEntry.set("billtype", (Object)billtypename);
        rptEntry.set("bizdate", (Object)billInfo.getBizDate());
        rptEntry.set("auditdate", (Object)billInfo.getAuditDate());
        rptEntry.set("instr", (Object)inStr);
        rptEntry.set("outstr", (Object)outStr);
        rptEntry.set("balancestr", (Object)endStr);
        rptEntry.set("parententryid", (Object)parentId);
        String costpricesource = billInfo.getCostpricesource();
        if (!isSubEntry && ("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) && !isSubEntry) {
            rptEntry.set("describe", (Object)costpricesource);
        }
    }

    private void addRptEntry4CostAdjust(DynamicObject rptInfo, BillInfo billInfo, RecentCostInfo parentBalInfo, Map<Long, RecentCostInfo> detailBalMap, DynamicObject costAdjustbill, DynamicObject costAdjustEntry) {
        DynamicObject rptEntry = rptInfo.getDynamicObjectCollection("entryentity").addNew();
        int displaypricepc = billInfo.getDisplayPricePrecision();
        int amtPrecision = billInfo.getAmtPrecision();
        int qtyPrecision = billInfo.getQtyPrecision();
        int pricePrecision = billInfo.getPricePrecision();
        int seq = rptInfo.getInt("nextSeq");
        if (seq == 0) {
            seq = 1;
        }
        rptEntry.set("seq", (Object)seq);
        rptInfo.set("nextSeq", (Object)(seq + 1));
        rptEntry.set("bizbillid", costAdjustbill.get("id"));
        rptEntry.set("bizbillentryid", costAdjustEntry.get("id"));
        rptEntry.set("billnumber", (Object)costAdjustbill.getString("billno"));
        rptEntry.set("billtypenum", (Object)"cal_costadjustbill");
        String createTypeName = "\uff08" + CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getDesc() + "\uff09";
        String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355%1$s", (String)"MoveAddAverageCalculate_9", (String)"fi-cal-business", (Object[])new Object[0]), createTypeName);
        rptEntry.set("billtype", (Object)msg);
        rptEntry.set("bizdate", (Object)costAdjustbill.getDate("bookdate"));
        rptEntry.set("auditdate", (Object)costAdjustbill.getDate("auditdate"));
        StringBuilder str = new StringBuilder();
        str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(displaypricepc, 4).toPlainString()).append(" = ").append(this.toBigDecimalString(costAdjustEntry.getBigDecimal("adjustamt").setScale(amtPrecision, 4)));
        rptEntry.set("outstr", (Object)str.toString());
        String endStr = this.getRecentString(parentBalInfo, displaypricepc) + "\n";
        parentBalInfo.setRecentCost(parentBalInfo.getRecentCost().add(costAdjustEntry.getBigDecimal("adjustamt").negate()));
        this.handlePrecision(parentBalInfo, qtyPrecision, amtPrecision, pricePrecision);
        endStr = endStr + this.getRecentString(parentBalInfo, displaypricepc);
        rptEntry.set("balancestr", (Object)endStr);
        rptEntry.set("parententryid", (Object)0L);
        for (DynamicObject detail : costAdjustEntry.getDynamicObjectCollection("subentryentity")) {
            if (detail.getBigDecimal("sub_adjustamt").compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject rpt1 = rptInfo.getDynamicObjectCollection("entryentity").addNew();
            long costSubElement = detail.getLong("costsubelement");
            RecentCostInfo detailBalInfo = detailBalMap.get(detail.getLong("id"));
            seq = rptInfo.getInt("nextSeq");
            rpt1.set("seq", (Object)seq);
            rptInfo.set("nextSeq", (Object)(seq + 1));
            rpt1.set("bizbillid", costAdjustbill.get("id"));
            rpt1.set("bizbillentryid", detail.get("id"));
            rpt1.set("billnumber", (Object)QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id,name,number", (QFilter[])new QFilter("id", "=", (Object)costSubElement).toArray()).getString("name"));
            rpt1.set("billtypenum", (Object)"cal_costadjustbill");
            String msg1 = String.format(ResManager.loadKDString((String)"\u5b50\u8981\u7d20%1$s", (String)"MoveAddAverageCalculate_15", (String)"fi-cal-business", (Object[])new Object[0]), createTypeName);
            rpt1.set("billtype", (Object)msg1);
            rpt1.set("bizdate", (Object)costAdjustbill.getDate("bookdate"));
            rpt1.set("auditdate", (Object)costAdjustbill.getDate("auditdate"));
            str.setLength(0);
            str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(displaypricepc, 4).toPlainString()).append(" = ").append(detail.getBigDecimal("sub_adjustamt").setScale(amtPrecision, 4).toPlainString());
            rpt1.set("outstr", (Object)str.toString());
            endStr = this.getRecentString(detailBalInfo, displaypricepc) + "\n";
            detailBalInfo.setRecentCost(detailBalInfo.getRecentCost().add(detail.getBigDecimal("sub_adjustamt").negate()));
            this.handlePrecision(detailBalInfo, qtyPrecision, amtPrecision, pricePrecision);
            endStr = endStr + this.getRecentString(detailBalInfo, displaypricepc);
            rpt1.set("balancestr", (Object)endStr);
            rpt1.set("parententryid", (Object)costAdjustEntry.getLong("id"));
        }
    }

    private String getOutRecentString(BillInfo billInfo, int displaypricepc, boolean isSubEntry) {
        String type = billInfo.getQueueType();
        if ("0".equals(type)) {
            if (isSubEntry) {
                return this.toBigDecimalString(billInfo.getCost());
            }
            return this.toBigDecimalString(billInfo.getQty()) + " * " + this.toBigDecimalString(billInfo.getPrice().setScale(displaypricepc, 4)) + " = " + this.toBigDecimalString(billInfo.getCost());
        }
        return "";
    }

    private String getInRecentString(BillInfo billInfo, int displaypricepc, boolean isSubEntry) {
        String type = billInfo.getQueueType();
        if ("1".equals(type)) {
            if (isSubEntry) {
                return this.toBigDecimalString(billInfo.getCost());
            }
            return this.toBigDecimalString(billInfo.getQty()) + " * " + this.toBigDecimalString(billInfo.getPrice().setScale(displaypricepc, 4)) + " = " + this.toBigDecimalString(billInfo.getCost());
        }
        return "";
    }

    private void handlePrecision(RecentCostInfo info, int qtyPrecision, int amountPrecision, int pricePrecision) {
        if (info == null) {
            return;
        }
        info.setRecentCost(info.getRecentCost().setScale(amountPrecision, 4));
        info.setRecentQty(info.getRecentQty().setScale(qtyPrecision, 4));
        info.setRecentPrice(info.getRecentPrice().setScale(pricePrecision, 4));
    }

    private String getRecentString(RecentCostInfo info, int displaypricepc) {
        if (info == null) {
            return "";
        }
        String inStr = this.toBigDecimalString(info.getRecentQty()) + " * " + this.toBigDecimalString(this.getRecentPrice(info, displaypricepc)) + " = " + this.toBigDecimalString(info.getRecentCost());
        return inStr;
    }

    private BigDecimal getRecentPrice(RecentCostInfo info, int pricePrecision) {
        if (info.getRecentCost() == null || info.getRecentCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (info.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = info.getRecentCost().divide(info.getRecentQty(), pricePrecision, 4);
        return price;
    }

    private void writeRpt() {
        HashMap<Long, DynamicObject> insertMap = new HashMap<Long, DynamicObject>(this.rptMap.size());
        HashMap updateMap = new HashMap(this.rptMap.size());
        for (Map.Entry<String, DynamicObject> entry : this.rptMap.entrySet()) {
            insertMap.put(entry.getValue().getLong("id"), entry.getValue());
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calculateoutrpt", (String)"id", (QFilter[])new QFilter("id", "in", insertMap.keySet()).toArray(), null);){
            for (Row row : dataSet) {
                updateMap.put(row.getLong("id"), insertMap.get(row.getLong("id")));
                insertMap.remove(row.getLong("id"));
            }
        }
        if (!insertMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])insertMap.values().toArray(new DynamicObject[0]));
        }
        if (!updateMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateMap.values().toArray(new DynamicObject[0]));
        }
    }

    private void cacheMap(DataSet dataSet, String[] onFields, Map<String, RecentCostInfo> costMap, Set<String> insertSet, Map<String, Long> costIdMap, Map<Long, RecentCostInfo> detailRecentCostMap, Map<Long, String> detailKeyMap, Map<Long, List<BillInfo>> dataMap, List<Long> entryIdList) {
        for (Row row : dataSet) {
            List<BillInfo> list;
            String key = this.getGroupKey(row, onFields, true);
            RecentCostInfo recentCostInfo = costMap.get(key);
            if (recentCostInfo == null) {
                recentCostInfo = new RecentCostInfo();
                BigDecimal qty = row.get("recentqty") == null ? BigDecimal.ZERO : row.getBigDecimal("recentqty");
                BigDecimal cost = row.get("recentcost") == null ? BigDecimal.ZERO : row.getBigDecimal("recentcost");
                BigDecimal price = row.get("price") == null ? BigDecimal.ZERO : row.getBigDecimal("price");
                long recentcostid = row.get("recentcostid") == null ? 0L : row.getLong("recentcostid");
                recentCostInfo.setId(recentcostid);
                recentCostInfo.setRecentQty(qty);
                recentCostInfo.setRecentCost(cost);
                recentCostInfo.setRecentPrice(price);
                recentCostInfo.setPriceUpdateTime(row.getDate("priceupdatetime"));
                if (recentcostid == 0L) {
                    insertSet.add(key);
                } else {
                    costIdMap.put(key, recentcostid);
                }
                costMap.put(key, recentCostInfo);
            }
            BillInfo billInfo = this.buildBillInfo(row);
            detailKeyMap.put(billInfo.getDetailId(), key);
            detailRecentCostMap.put(billInfo.getDetailId(), recentCostInfo);
            long entryId = billInfo.getBillEntryId();
            if (!entryIdList.contains(entryId)) {
                entryIdList.add(entryId);
            }
            if ((list = dataMap.get(entryId)) != null) {
                list.add(billInfo);
                continue;
            }
            list = new ArrayList<BillInfo>();
            list.add(billInfo);
            dataMap.put(entryId, list);
        }
    }

    private void writeBackBalance() {
        if (!this.costRecordEntrySet.isEmpty()) {
            new BalanceCalculator().updateBalance4Others(this.costRecordEntrySet.toArray(), BalanceSourceEnum.INSTANTLY_COST);
        }
    }

    private void writeRecentCost(Map<String, RecentCostInfo> costMap, Set<String> insertSet, Map<String, Long> costIdMap, String[] onFields) {
        String updateSql = "update t_cal_recentcost set frecentcost = ? ,frecentqty = ? , fcalrptid = ?, fprice=?, fpriceupdatetime = ?  where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashSet<DynamicObject> insertInfoSet = new HashSet<DynamicObject>();
        for (Map.Entry<String, RecentCostInfo> entry : costMap.entrySet()) {
            String key = entry.getKey();
            RecentCostInfo info = entry.getValue();
            String rptkey = key.substring(0, key.lastIndexOf(44));
            rptkey = rptkey.substring(0, rptkey.lastIndexOf(44));
            DynamicObject rptInfo = this.rptMap.get(rptkey);
            if (insertSet.contains(key)) {
                DynamicObject recentCostInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_recentcost");
                String[] value = key.split(",");
                long costAccount = Long.parseLong(value[0]);
                long currency = Long.parseLong(value[1]);
                long baseUnit = Long.parseLong(value[2]);
                long material = Long.parseLong(value[3]);
                recentCostInfo.set("costaccount", (Object)costAccount);
                recentCostInfo.set("currency", (Object)currency);
                recentCostInfo.set("baseunit", (Object)baseUnit);
                recentCostInfo.set("material", (Object)material);
                for (int i = 0; i < onFields.length; ++i) {
                    recentCostInfo.set(onFields[i], (Object)value[i + 4]);
                }
                long costElement = Long.parseLong(recentCostInfo.get("costelement").toString());
                if (costElement == -1L) continue;
                recentCostInfo.set("recentqty", (Object)info.getRecentQty());
                recentCostInfo.set("recentcost", (Object)info.getRecentCost());
                recentCostInfo.set("calrptid", (Object)rptInfo.getLong("id"));
                if (info.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && BigDecimal.ZERO.compareTo(info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP)) < 0) {
                    recentCostInfo.set("price", (Object)info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP));
                    recentCostInfo.set("priceupdatetime", (Object)TimeServiceHelper.now());
                }
                insertInfoSet.add(recentCostInfo);
                continue;
            }
            long recentCostId = costIdMap.get(key);
            if (recentCostId == -1L) continue;
            if (info.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && BigDecimal.ZERO.compareTo(info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP)) < 0) {
                Object[] param = new Object[]{info.getRecentCost(), info.getRecentQty(), rptInfo.getLong("id"), info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP), new Timestamp(TimeServiceHelper.now().getTime()), recentCostId};
                paramList.add(param);
                continue;
            }
            Timestamp timestamp = info.getPriceUpdateTime() == null ? null : new Timestamp(info.getPriceUpdateTime().getTime());
            Object[] param = new Object[]{info.getRecentCost(), info.getRecentQty(), rptInfo.getLong("id"), info.getRecentPrice(), timestamp, recentCostId};
            paramList.add(param);
        }
        if (!insertInfoSet.isEmpty()) {
            WriteLogHelper.writeInfoLog((Log)logger, (String)("------ynzy----writeRecentCost.insertInfoSet.size()-----" + insertInfoSet.size()), (Object[])new Object[0]);
            SaveServiceHelper.save((DynamicObject[])insertInfoSet.toArray(new DynamicObject[0]));
        }
        if (!paramList.isEmpty()) {
            WriteLogHelper.writeInfoLog((Log)logger, (String)("------ynzy----writeRecentCost.paramList.size()-----" + paramList.size()), (Object[])new Object[0]);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, paramList);
        }
    }

    private RecentCostInfo outHandleGroup(BillInfo billInfo, RecentCostInfo recentCostInfo) {
        RecentCostInfo info = new RecentCostInfo();
        BigDecimal qty = billInfo.getQty();
        BigDecimal queueSign = billInfo.getSignnum();
        BigDecimal sign = new BigDecimal(qty.signum()).multiply(queueSign);
        BigDecimal cost = billInfo.getCost();
        BigDecimal unitactualcost = billInfo.getPrice();
        long entryId = billInfo.getDetailId();
        long calEntryId = billInfo.getCalEntryId();
        long costaccount = billInfo.getCostAccountId();
        long eid = billInfo.getBillEntryId();
        long costSubElement = billInfo.getCostSubElementId();
        info.setRecentQty(qty);
        info.setId(entryId);
        int pricePrecision = billInfo.getPricePrecision();
        int amountPrecision = billInfo.getAmtPrecision();
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        boolean isBillCost = false;
        boolean isCalByCostElement = this.calByElementMap.get(billInfo.getCostAccountId());
        if (isCalByCostElement) {
            actualCost = this.billGroupMap.get(costaccount + "|" + calEntryId + "|" + costSubElement);
        } else {
            BigDecimal gresource;
            BigDecimal gmanufactureCost;
            BigDecimal gprocessCost;
            BigDecimal gfee;
            String costAccountKey = costaccount + "|" + calEntryId;
            BigDecimal materialCost = billInfo.getMaterialCost();
            BigDecimal fee = billInfo.getFee();
            BigDecimal processCost = billInfo.getProcessCost();
            BigDecimal manufactureCost = billInfo.getManufactureCost();
            BigDecimal resource = billInfo.getResource();
            boolean isGroup = false;
            BigDecimal gmaterialCost = this.billGroupMap.get(costAccountKey + "|" + "materialcost");
            if (gmaterialCost != null) {
                materialCost = gmaterialCost;
                if (gmaterialCost.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitMaterialCost = gmaterialCost.divide(qty, pricePrecision, 4).abs();
                    this.materialCostMap.put(eid, new BigDecimal[]{gmaterialCost.abs().multiply(sign), unitMaterialCost});
                }
            }
            if ((gfee = this.billGroupMap.get(costAccountKey + "|" + "fee")) != null) {
                fee = gfee;
                if (gfee.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitFee = gfee.divide(qty, pricePrecision, 4).abs();
                    this.feeMap.put(eid, new BigDecimal[]{gfee.abs().multiply(sign), unitFee});
                }
            }
            if ((gprocessCost = this.billGroupMap.get(costAccountKey + "|" + "processcost")) != null) {
                processCost = gprocessCost;
                if (gprocessCost.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitProcessCost = gprocessCost.divide(qty, pricePrecision, 4).abs();
                    this.processCostMap.put(eid, new BigDecimal[]{gprocessCost.abs().multiply(sign), unitProcessCost});
                }
            }
            if ((gmanufactureCost = this.billGroupMap.get(costAccountKey + "|" + "manufacturecost")) != null) {
                manufactureCost = gmanufactureCost;
                if (gmanufactureCost.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitManufactureCost = gmanufactureCost.divide(qty, pricePrecision, 4).abs();
                    this.manufactureCostMap.put(eid, new BigDecimal[]{gmanufactureCost.abs().multiply(sign), unitManufactureCost});
                }
            }
            if ((gresource = this.billGroupMap.get(costAccountKey + "|" + "resource")) != null) {
                resource = gresource;
                if (gresource.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitResource = gresource.divide(qty, pricePrecision, 4).abs();
                    this.resourceMap.put(eid, new BigDecimal[]{gresource.abs().multiply(sign), unitResource});
                }
            }
            if (isGroup) {
                actualCost = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource);
            }
        }
        if (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0) {
            CostPriceResultInfo result = this.billCostPriceMap.get(eid);
            if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(costSubElement)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
                actualCost = qty.multiply(unitCost).setScale(amountPrecision, 4);
                billInfo.setPriceTypeName(result.getSrcPriceName());
            }
        } else {
            unitCost = actualCost.divide(qty, pricePrecision, 4).abs();
            billInfo.setPriceTypeName(this.groupPriceName);
        }
        if (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0) {
            unitCost = unitactualcost;
            actualCost = cost;
            isBillCost = true;
        }
        if (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0) {
            isBillCost = false;
            unitCost = this.fetchCostByRecentCost(pricePrecision, amountPrecision, recentCostInfo);
            actualCost = qty.compareTo(recentCostInfo.getRecentQty()) == 0 ? recentCostInfo.getRecentCost() : qty.multiply(unitCost).setScale(amountPrecision, 4);
            billInfo.setPriceTypeName(this.realTimePriceName);
        }
        actualCost = actualCost.abs().multiply(sign).multiply(queueSign);
        info.setRecentPrice(unitCost);
        info.setRecentCost(actualCost);
        if (!isBillCost) {
            this.recordMap.put(eid + "|" + costSubElement, new BigDecimal[]{actualCost.abs().multiply(sign), unitCost});
            this.costRecordEntrySet.add(eid);
            if (isCalByCostElement) {
                this.byElementCostRecordEntrySet.add(eid);
            } else {
                this.noneElementCostRecordEntrySet.add(eid);
            }
            if (this.omInBills.contains(billInfo.getBizEntityObject())) {
                this.omInCostRecordEntrys.add(eid);
            } else {
                this.notOmInCostRecordEntrys.add(eid);
            }
        }
        return info;
    }

    private BigDecimal fetchCostByRecentCost(int pricePrecision, int amountPrecision, RecentCostInfo recentCostInfo) {
        BigDecimal unitCost = recentCostInfo.getRecentQty() == null || recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : recentCostInfo.getRecentCost().divide(recentCostInfo.getRecentQty(), pricePrecision, 4);
        return unitCost;
    }

    private BigDecimal fetchCostByPriceStrage(int pricePrecision, int amountPrecision, RecentCostInfo outInfo) {
        BigDecimal unitCost = this.getPrice();
        return unitCost;
    }

    private BigDecimal getPrice() {
        return BigDecimal.ZERO;
    }

    private RecentCostInfo inHandleGroup(BillInfo billInfo, RecentCostInfo recentCostInfo) {
        RecentCostInfo info = new RecentCostInfo();
        BigDecimal billQty = billInfo.getQty();
        BigDecimal billCost = billInfo.getCost();
        BigDecimal billPrice = billInfo.getPrice();
        info.setRecentQty(billQty);
        long calEntryId = billInfo.getCalEntryId();
        long eid = billInfo.getBillEntryId();
        long costaccount = billInfo.getCostAccountId();
        long costSubElement = billInfo.getCostSubElementId();
        int pricePrecision = billInfo.getPricePrecision();
        int amountPrecision = billInfo.getAmtPrecision();
        BigDecimal queueSign = billInfo.getSignnum();
        BigDecimal sign = new BigDecimal(billQty.signum()).multiply(queueSign);
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        boolean isBillCost = false;
        boolean isCalByCostElement = this.calByElementMap.get(billInfo.getCostAccountId());
        if (isCalByCostElement) {
            actualCost = this.billGroupMap.get(costaccount + "|" + calEntryId + "|" + costSubElement);
        } else {
            BigDecimal gresource;
            BigDecimal gmanufactureCost;
            BigDecimal gprocessCost;
            BigDecimal gfee;
            String costAccountKey = costaccount + "|" + calEntryId;
            BigDecimal materialCost = billInfo.getMaterialCost();
            BigDecimal fee = billInfo.getFee();
            BigDecimal processCost = billInfo.getProcessCost();
            BigDecimal manufactureCost = billInfo.getManufactureCost();
            BigDecimal resource = billInfo.getResource();
            boolean isGroup = false;
            BigDecimal gmaterialCost = this.billGroupMap.get(costAccountKey + "|" + "materialcost");
            if (gmaterialCost != null) {
                materialCost = gmaterialCost;
                if (gmaterialCost.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitMaterialCost = gmaterialCost.divide(billQty, pricePrecision, 4).abs();
                    this.materialCostMap.put(eid, new BigDecimal[]{gmaterialCost.abs().multiply(sign), unitMaterialCost});
                }
            }
            if ((gfee = this.billGroupMap.get(costAccountKey + "|" + "fee")) != null) {
                fee = gfee;
                if (gfee.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitFee = gfee.divide(billQty, pricePrecision, 4).abs();
                    this.feeMap.put(eid, new BigDecimal[]{gfee.abs().multiply(sign), unitFee});
                }
            }
            if ((gprocessCost = this.billGroupMap.get(costAccountKey + "|" + "processcost")) != null) {
                processCost = gprocessCost;
                if (gprocessCost.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitProcessCost = gprocessCost.divide(billQty, pricePrecision, 4).abs();
                    this.processCostMap.put(eid, new BigDecimal[]{gprocessCost.abs().multiply(sign), unitProcessCost});
                }
            }
            if ((gmanufactureCost = this.billGroupMap.get(costAccountKey + "|" + "manufacturecost")) != null) {
                manufactureCost = gmanufactureCost;
                if (gmanufactureCost.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitManufactureCost = gmanufactureCost.divide(billQty, pricePrecision, 4).abs();
                    this.manufactureCostMap.put(eid, new BigDecimal[]{gmanufactureCost.abs().multiply(sign), unitManufactureCost});
                }
            }
            if ((gresource = this.billGroupMap.get(costAccountKey + "|" + "resource")) != null) {
                resource = gresource;
                if (gresource.compareTo(BigDecimal.ZERO) != 0) {
                    isGroup = true;
                    BigDecimal unitResource = gresource.divide(billQty, pricePrecision, 4).abs();
                    this.resourceMap.put(eid, new BigDecimal[]{gresource.abs().multiply(sign), unitResource});
                }
            }
            if (isGroup) {
                actualCost = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource);
            }
        }
        if (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0) {
            CostPriceResultInfo result = this.billCostPriceMap.get(eid);
            if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(costSubElement)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
                actualCost = unitCost.multiply(info.getRecentQty()).setScale(amountPrecision, 4);
                billInfo.setPriceTypeName(result.getSrcPriceName());
            }
        } else {
            unitCost = actualCost.divide(billQty, pricePrecision, 4).abs();
            billInfo.setPriceTypeName(this.groupPriceName);
        }
        if (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0) {
            actualCost = billCost;
            unitCost = billPrice;
            isBillCost = true;
        }
        if ("im_otherinbill".equals(billInfo.getBizEntityObject()) && (actualCost == null || actualCost.compareTo(BigDecimal.ZERO) == 0)) {
            isBillCost = false;
            unitCost = this.fetchCostByRecentCost(pricePrecision, amountPrecision, recentCostInfo);
            actualCost = billQty.multiply(unitCost).setScale(amountPrecision, 4);
            billInfo.setPriceTypeName(this.realTimePriceName);
        }
        actualCost = actualCost.abs().multiply(sign).multiply(queueSign);
        info.setRecentCost(actualCost);
        info.setRecentPrice(unitCost);
        if (!isBillCost) {
            this.recordMap.put(eid + "|" + costSubElement, new BigDecimal[]{actualCost.abs().multiply(sign), unitCost});
            this.costRecordEntrySet.add(eid);
            if (isCalByCostElement) {
                this.byElementCostRecordEntrySet.add(eid);
            } else {
                this.noneElementCostRecordEntrySet.add(eid);
            }
        }
        return info;
    }

    private String getGroupKey(Row row, String[] onFields, boolean hasCostElement) {
        StringBuilder key = new StringBuilder();
        long costAccount = row.getLong("costaccount");
        long currecy = row.getLong("currency");
        long baseUnit = row.getLong("baseunit");
        long material = row.getLong("material");
        key.append(costAccount).append(',');
        key.append(currecy).append(',');
        key.append(baseUnit).append(',');
        key.append(material).append(',');
        for (String field : onFields) {
            Object value = row.get(field);
            if ("".equals(value)) {
                value = " ";
            }
            if ("costelement".equals(field) || "costsubelement".equals(field)) {
                if (!hasCostElement) continue;
                key.append(value).append(',');
                continue;
            }
            key.append(value).append(',');
        }
        return key.substring(0, key.length() - 1);
    }

    private DataSet getBillDataSet(Long[] billIds, Long[] billEntryIds, String entityName) {
        if ("cal_costrecord".equals(entityName) || "cal_costrecord_subentity".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entry.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            q.and("isinitbill", "=", (Object)Boolean.FALSE);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            if (billEntryIds != null) {
                q.and("entry.id", "in", (Object)billEntryIds);
            }
            if ("0".equals(this.opType) && CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
                q.and("entry.iscalculated", "=", (Object)Boolean.TRUE);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getCostRecordSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            q.and("isupdatecost", "=", (Object)Boolean.TRUE);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getCostAdjustSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        if ("cal_balance".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBalanceSelects(), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"id,balid,to_char(costelement) as costelement,to_char(costsubelement) as costsubelement,periodendqty as billqty,periodendactualcost as billcost", (QFilter[])new QFilter("balid", "in", (Object)billIds).toArray(), null);
            DataSet groupDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"id,balid,periodendqty as billqty,periodendactualcost as billcost,costelement,costsubelement", (QFilter[])new QFilter("balid", "in", (Object)billIds).toArray(), null).groupBy(new String[]{"balid"}).max("billqty").sum("billcost").finish().select("balid,billqty,billcost,'-1' as costelement,'-1' as costsubelement");
            dataSet = dataSet.copy().join(detailDataSet, JoinType.LEFT).on("billid", "balid").select(this.getInitBalanceAlias().split(","), new String[]{"id as entryid", "balid as eid", "costelement", "costsubelement", "billqty", "billcost"}).finish().union(dataSet.copy().join(groupDataSet, JoinType.LEFT).on("billid", "balid").select(this.getInitBalanceAlias().split(","), new String[]{"balid as entryid", "balid as eid", "costelement", "costsubelement", "billqty", "billcost"}).finish());
            q.and("accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_calrange", (String)"id as balId,caldimension as caldimension,caldimension.caldimension as caldimensionstr,calrange as calrange", (QFilter[])q.toArray(), null);
            dataSet = dataSet.addField("1", "entryseq");
            dataSet = dataSet.addField("1", "signnum");
            return dataSet.join(balDataSet, JoinType.INNER).on("billid", "balId").select(this.getAliasSelects().split(",")).finish();
        }
        if ("cal_initbill".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            QFilter q1 = new QFilter("entryentity.baseqty", "!=", (Object)0);
            q1.or("entryentity.amount", "!=", (Object)0);
            q.and(q1);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBillSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBillSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        return null;
    }

    private String getCostRecordSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        String entryName = "entry";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id as billid,billno as billno,billtype.number as billtypenumber,billtype.name as billtypename,bookdate as bizdate,costaccount,costaccount.calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entry.caldimension as caldimension,entry.caldimension.caldimension as caldimensionstr,auditdate,entry.seq as entryseq,'0' as createtype,");
        selects.append("entry.baseqty as billqty,entry.material as material,entry.material.name as materialname,entry.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,");
        selects.append("entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,entry.calrange as calrange,entry.calentryid as calentryid,entry.queuetype as queuetype,bizentityobject.number as bizentityobject,period as period,entry.ispresent as ispresent");
        selects.append(",entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource,entry.materialcost as materialcost,entry.signnum as signnum,biztype,'' as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entry.subentrycostelement.costelement) as costelement,to_char(entry.subentrycostelement.costsubelement) as costsubelement,entry.subentrycostelement.sub_actualcost as billcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost,entry.subentrycostelement.id as entryid,entry.id as eid");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entry.actualcost as billcost,entry.unitactualcost as unitactualcost,entry.id as entryid,entry.id as eid");
        }
        return selects.toString();
    }

    private String getCostAdjustSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"MoveAddAverageCalculate_1", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,billno as billno,'cal_costadjustbill' as billtypenumber,'").append(s).append("' as billtypename,entryentity.invbizdate as bizdate,costaccount,costaccount.calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,entryentity.seq as entryseq,createtype,");
        selects.append("0 as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,currency as currency,10 as priceprecision,currency.amtprecision as amtprecision,currency.priceprecision as displaypricepc,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,entryentity.queuetype as queuetype,'cal_costadjustbill' as bizentityobject,0 as unitactualcost,0 as period,'0' as ispresent");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,entryentity.signnum as signnum,entryentity.invbillnum as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_adjustamt as billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.adjustamt as billcost,entryentity.id as entryid,entryentity.id as eid");
        }
        return selects.toString();
    }

    private String getInitBalanceSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        for (String field : fields = this.totalKey.split(",")) {
            selects.append(field).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u4f59\u989d\u521d\u59cb\u5316", (String)"MoveAddAverageCalculate_2", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,' ' as billno,'cal_balance' as billtypenumber,'").append(s).append("' as billtypename,null as bizdate,costaccount,costaccount.calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,'0' as createtype,");
        selects.append("null as auditdate,material as material,material.name as materialname,material.number as materialnum,calpolicy.currency as currency,10 as priceprecision,calpolicy.currency.amtprecision as amtprecision,calpolicy.currency.priceprecision as displaypricepc,");
        selects.append("baseunit as baseunit,baseunit.precision as qtyprecision,0 as calentryid,'cal_balance' as bizentityobject,0 as unitactualcost,0 as period,'0' as ispresent");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,'' as invbillnum");
        return selects.toString();
    }

    private String getInitBillSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            IDataEntityProperty p = entityType.findProperty(field);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(field).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(field).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355", (String)"MoveAddAverageCalculate_5", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,billno,'cal_initbill' as billtypenumber,'").append(s).append("' as billtypename,bookdate as bizdate,costaccount,calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,entryentity.seq as entryseq,'0' as createtype,");
        selects.append("entryentity.baseqty as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,'0' as queuetype,'cal_initbill' as bizentityobject,0 as unitactualcost,period,'0' as ispresent");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,1 as signnum,'' as invbillnum");
        if (isDetail) {
            if (this.enableStd) {
                selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_amount+entryentity.subentryentity.sub_costdiff as billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid");
            } else {
                selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid");
            }
        } else if (this.enableStd) {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.amount+entryentity.costdiff as billcost,entryentity.id as entryid,entryentity.id as eid");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.amount as billcost,entryentity.id as entryid,entryentity.id as eid");
        }
        return selects.toString();
    }

    private String getInitBalanceAlias() {
        StringBuilder selects = new StringBuilder();
        selects.append(this.totalKey);
        selects.append(",billid,billno,billtypenumber,billtypename,bizdate,costaccount,calorgid,dividebasis,dividebasisstr,createtype,");
        selects.append("auditdate,material,materialname,materialnum,currency,priceprecision,amtprecision,displaypricepc,");
        selects.append("baseunit,qtyprecision,calentryid,bizentityobject,unitactualcost,period,ispresent");
        selects.append(",fee,processcost,manufacturecost,resource,materialcost,invbillnum");
        return selects.toString();
    }

    private String getAliasSelects() {
        StringBuilder selects = new StringBuilder();
        selects.append(this.totalKey);
        selects.append(",billid,billno,billtypenumber,billtypename,bizdate,costaccount,calorgid,entryid,dividebasis,dividebasisstr,createtype,");
        selects.append("caldimension,caldimensionstr,auditdate,period,ispresent,entryseq,materialname,materialnum,");
        selects.append("fee,processcost,manufacturecost,resource,materialcost,signnum,invbillnum,");
        selects.append("billqty,billcost,material,currency,priceprecision,amtprecision,displaypricepc,baseunit,qtyprecision,calrange,calentryid,bizentityobject,unitactualcost,costelement,costsubelement,eid");
        if ("cal_costrecord".equals(this.entityName)) {
            selects.append(",biztype");
        }
        return selects.toString();
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    public void putGroupCost(Map<String, BigDecimal> groupCost) {
        this.billGroupMap.putAll(groupCost);
    }

    private String getPrevCostParam(BillInfo billInfo) {
        Long calOrgId = billInfo.getCalOrgId();
        String prevCostParam = this.prevCostParamMap.get(calOrgId);
        if (prevCostParam == null) {
            AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
            String prevCostAdjustParam = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"prevcostadjustparam");
            this.prevCostParamMap.put(calOrgId, prevCostAdjustParam);
            prevCostParam = prevCostAdjustParam;
        }
        return prevCostParam;
    }

    private boolean getIsNoAdj(String createType, String prevCostParam) {
        if ("cal_initbill".equals(this.entityName)) {
            return true;
        }
        boolean isAdjBill = "cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName);
        boolean isHandBill = CostAdjustBilCreateTypeEnum.HAND.getValue().equals(createType) || CostAdjustBilCreateTypeEnum.HAND_IMPORT.getValue().equals(createType);
        boolean enablePrevCost = !"no".equals(prevCostParam);
        boolean isAutoGenBil = CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue().equals(createType) || CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue().equals(createType) || CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue().equals(createType) || CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue().equals(createType) || CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue().equals(createType) || CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue().equals(createType);
        boolean enablePreCostAndIsAutoGenBill = enablePrevCost && isAutoGenBil;
        boolean noAdj = isAdjBill && (isHandBill || enablePreCostAndIsAutoGenBill);
        return noAdj;
    }

    private static class BillInfo {
        private long billId;
        private long billEntryId;
        private String billNo;
        private long costAccountId;
        private long calOrgId;
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal cost = BigDecimal.ZERO;
        private BigDecimal price = BigDecimal.ZERO;
        private String queueType;
        private int qtyPrecision;
        private int amtPrecision;
        private int pricePrecision;
        private long currencyId;
        private long baseUnitId;
        private long materialId;
        private String materialName;
        private String materialNum;
        private int displayPricePrecision;
        private String billTypeNum;
        private String billTypeName;
        private BigDecimal signnum = BigDecimal.ONE.stripTrailingZeros();
        private long calEntryId;
        private long detailId;
        private long costElementId;
        private long costSubElementId;
        private boolean present;
        private Date bizDate;
        private Date auditDate;
        private BigDecimal materialCost;
        private BigDecimal fee;
        private BigDecimal processCost;
        private BigDecimal manufactureCost;
        private BigDecimal resource;
        private String priceTypeName;
        private String bizEntityObject;
        private long biztypeId;
        private String createType;
        private String costpricesource;

        private BillInfo() {
        }

        public long getBiztypeId() {
            return this.biztypeId;
        }

        public void setBiztypeId(long biztypeId) {
            this.biztypeId = biztypeId;
        }

        public String getQueueType() {
            return this.queueType;
        }

        public void setQueueType(String queueType) {
            this.queueType = queueType;
        }

        public int getQtyPrecision() {
            return this.qtyPrecision;
        }

        public void setQtyPrecision(int qtyPrecision) {
            this.qtyPrecision = qtyPrecision;
        }

        public int getAmtPrecision() {
            return this.amtPrecision;
        }

        public void setAmtPrecision(int amtPrecision) {
            this.amtPrecision = amtPrecision;
        }

        public long getBillId() {
            return this.billId;
        }

        public void setBillId(long billId) {
            this.billId = billId;
        }

        public long getBillEntryId() {
            return this.billEntryId;
        }

        public void setBillEntryId(long billEntryId) {
            this.billEntryId = billEntryId;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(long currencyId) {
            this.currencyId = currencyId;
        }

        public long getBaseUnitId() {
            return this.baseUnitId;
        }

        public void setBaseUnitId(long baseUnitId) {
            this.baseUnitId = baseUnitId;
        }

        public long getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(long materialId) {
            this.materialId = materialId;
        }

        public int getDisplayPricePrecision() {
            return this.displayPricePrecision;
        }

        public void setDisplayPricePrecision(int displayPricePrecision) {
            this.displayPricePrecision = displayPricePrecision;
        }

        public int getPricePrecision() {
            return this.pricePrecision;
        }

        public void setPricePrecision(int pricePrecision) {
            this.pricePrecision = pricePrecision;
        }

        public String getBillTypeNum() {
            return this.billTypeNum;
        }

        public void setBillTypeNum(String billTypeNum) {
            this.billTypeNum = billTypeNum;
        }

        public String getBillTypeName() {
            return this.billTypeName;
        }

        public void setBillTypeName(String billTypeName) {
            this.billTypeName = billTypeName;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public long getCalEntryId() {
            return this.calEntryId;
        }

        public void setCalEntryId(long calEntryId) {
            this.calEntryId = calEntryId;
        }

        public long getDetailId() {
            return this.detailId;
        }

        public void setDetailId(long detailId) {
            this.detailId = detailId;
        }

        public long getCostElementId() {
            return this.costElementId;
        }

        public void setCostElementId(long costElementId) {
            this.costElementId = costElementId;
        }

        public long getCostSubElementId() {
            return this.costSubElementId;
        }

        public void setCostSubElementId(long costSubElementId) {
            this.costSubElementId = costSubElementId;
        }

        public boolean isPresent() {
            return this.present;
        }

        public void setPresent(boolean present) {
            this.present = present;
        }

        public long getCostAccountId() {
            return this.costAccountId;
        }

        public void setCostAccountId(long costAccountId) {
            this.costAccountId = costAccountId;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public long getCalOrgId() {
            return this.calOrgId;
        }

        public void setCalOrgId(long calOrgId) {
            this.calOrgId = calOrgId;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName;
        }

        public String getMaterialNum() {
            return this.materialNum;
        }

        public void setMaterialNum(String materialNum) {
            this.materialNum = materialNum;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public Date getAuditDate() {
            return this.auditDate;
        }

        public void setAuditDate(Date auditDate) {
            this.auditDate = auditDate;
        }

        public BigDecimal getMaterialCost() {
            return this.materialCost;
        }

        public void setMaterialCost(BigDecimal materialCost) {
            this.materialCost = materialCost;
        }

        public BigDecimal getFee() {
            return this.fee;
        }

        public void setFee(BigDecimal fee) {
            this.fee = fee;
        }

        public BigDecimal getProcessCost() {
            return this.processCost;
        }

        public void setProcessCost(BigDecimal processCost) {
            this.processCost = processCost;
        }

        public BigDecimal getManufactureCost() {
            return this.manufactureCost;
        }

        public void setManufactureCost(BigDecimal manufactureCost) {
            this.manufactureCost = manufactureCost;
        }

        public BigDecimal getResource() {
            return this.resource;
        }

        public void setResource(BigDecimal resource) {
            this.resource = resource;
        }

        public String getPriceTypeName() {
            return this.priceTypeName;
        }

        public void setPriceTypeName(String priceTypeName) {
            this.priceTypeName = priceTypeName;
        }

        public BigDecimal getSignnum() {
            return this.signnum;
        }

        public void setSignnum(BigDecimal signnum) {
            this.signnum = signnum;
        }

        public String getBizEntityObject() {
            return this.bizEntityObject;
        }

        public void setBizEntityObject(String bizEntityObject) {
            this.bizEntityObject = bizEntityObject;
        }

        public String getCreateType() {
            return this.createType;
        }

        public void setCreateType(String createType) {
            this.createType = createType;
        }

        public String getCostpricesource() {
            return this.costpricesource;
        }

        public void setCostpricesource(String costpricesource) {
            this.costpricesource = costpricesource;
        }
    }

    private static class RecentCostInfo {
        private long id;
        private BigDecimal recentQty = BigDecimal.ZERO;
        private BigDecimal recentCost = BigDecimal.ZERO;
        private BigDecimal recentPrice = BigDecimal.ZERO;
        private Date priceUpdateTime = null;

        private RecentCostInfo() {
        }

        public RecentCostInfo copy() {
            RecentCostInfo info = new RecentCostInfo();
            info.setId(0L);
            info.setRecentCost(this.getRecentCost());
            info.setRecentPrice(this.getRecentPrice());
            info.setRecentQty(this.getRecentQty());
            info.setPriceUpdateTime(this.getPriceUpdateTime());
            return info;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public BigDecimal getRecentQty() {
            return this.recentQty;
        }

        public void setRecentQty(BigDecimal recentQty) {
            this.recentQty = recentQty;
        }

        public BigDecimal getRecentCost() {
            return this.recentCost;
        }

        public void setRecentCost(BigDecimal recentCost) {
            this.recentCost = recentCost;
        }

        public BigDecimal getRecentPrice() {
            return this.recentPrice;
        }

        public void setRecentPrice(BigDecimal recentPrice) {
            this.recentPrice = recentPrice;
        }

        public Date getPriceUpdateTime() {
            return this.priceUpdateTime;
        }

        public void setPriceUpdateTime(Date priceUpdateTime) {
            this.priceUpdateTime = priceUpdateTime;
        }
    }
}

