/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.costprice.CostPrice4Others;
import kd.fi.cal.business.process.inner.PriceFluctHolder;
import kd.fi.cal.business.process.inner.QueryInvOrgHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;

public class MoveAddAverageCalculate4Sync {
    private static final Log logger = LogFactory.getLog(MoveAddAverageCalculate4Sync.class);
    private static final String insertSql = "insert into t_cal_caloutrpt(FID,FCOSTACCOUNTID,FDIVIDEBASISID,FCALDIMENSIONID,FDIVIDEBASISVALUE,FCALDIMENSIONVALUE,FMATERIALID,FACCOUNTTYPE,FPERIODID,FCALTIME,FCALSTATUS,FNEXTSEQ,FCALORGID,FCALRANGEID,foperationuserid,fassistid,fconfiguredcodeid,fprojectid,ftracknumberid) values (?,?,?,?,?,?,?,?,?,?,?,        ?,?,?,?,?,?,?,?)";
    private static final String insertEntrySql = "insert into t_cal_caloutrptentry(FID,FENTRYID,FSEQ,FBIZBILLID,FBIZBILLENTRYID,FBILLTYPENUM,FBILLTYPE,FBILLNUMBER,FINSTR,FOUTSTR,FBALANCESTR,FPARENTENTRYID,FBIZDATE,FAUDITDATE,FDESCRIBE) values (?,?,?,?,?,?,?,?,?,?,?,        ?,?,?,?)";
    private static final String updateSql = "update t_cal_caloutrpt set FNEXTSEQ = ?,fcaltime = ?,fassistid=?,fconfiguredcodeid=?,fprojectid=?,ftracknumberid=? where fid = ?";
    private String entityName;
    private Long[] billIds;
    private String divideStr;
    private String caldimensionStr;
    private String totalKey;
    private String opType;
    private Map<String, BigDecimal> billGroupMap = new HashMap<String, BigDecimal>();
    private Map<Long, CostPriceResultInfo> billCostPriceMap = new HashMap<Long, CostPriceResultInfo>();
    private Map<Long, CostPriceResultInfo> billCostPriceMap4ZeroPrice = new HashMap<Long, CostPriceResultInfo>();
    private Map<Long, CostPriceResultInfo> billCostPriceMap4NegativePrice = new HashMap<Long, CostPriceResultInfo>();
    private Map<Long, CostPriceResultInfo> billCostPriceMap4NegativeQty = new HashMap<Long, CostPriceResultInfo>(16);
    private Set<Long> hasGetZeroPriceEntryIds = new HashSet<Long>(16);
    private Set<Long> hasGetNegPriceEntryIds = new HashSet<Long>(16);
    private Set<Long> costRecordEntrySet = new HashSet<Long>();
    private Set<Long> byElementCostRecordEntrySet = new HashSet<Long>();
    private Set<Long> noneElementCostRecordEntrySet = new HashSet<Long>();
    private Map<Long, DynamicObject> costAdjustMap = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> costAdjustEntryMap = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> loadBillMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObject> loadEntryMap = new HashMap<Long, DynamicObject>();
    private String entryName = "entry";
    private DynamicObject costAdjustOutBillType;
    private Map<Long, Long> periodMap = new HashMap<Long, Long>(8);
    private Map<Long, Date> begindateMap = new HashMap<Long, Date>(8);
    private Map<Long, Boolean> calByElementMap = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> calOrgPurZeroCostMap = new HashMap<Long, Boolean>();
    private Map<Long, String> createDiffbillTypeMap = new HashMap<Long, String>();
    private Set<Long> zeroInOutBizTypeIds = new HashSet<Long>(16);
    private Map<String, DynamicObject> rptMap = new HashMap<String, DynamicObject>();
    private Map<String, BigDecimal[]> recordMap = new HashMap<String, BigDecimal[]>();
    private Set<DynamicObject> insertRecentCost = new HashSet<DynamicObject>();
    private List<Object[]> updateRecentCostList = new ArrayList<Object[]>();
    private List<Object[]> updateCostPricesParams = new ArrayList<Object[]>(16);
    private Map<Long, BigDecimal[]> materialCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> feeMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> processCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> manufactureCostMap = new HashMap<Long, BigDecimal[]>();
    private Map<Long, BigDecimal[]> resourceMap = new HashMap<Long, BigDecimal[]>();
    private String realTimePriceName = ResManager.loadKDString((String)"\u5373\u65f6\u6210\u672c", (String)"FIFOCalculate_9", (String)"fi-cal-business", (Object[])new Object[0]);
    private String zeroCostPriceName = ResManager.loadKDString((String)"\u96f6\u6210\u672c", (String)"FIFOCalculate_10", (String)"fi-cal-business", (Object[])new Object[0]);
    private String presentPriceName = ResManager.loadKDString((String)"\u8d60\u54c1", (String)"MoveAddAverageCalculate4Sync_0", (String)"fi-cal-business", (Object[])new Object[0]);
    private static String GROUP_PRICE = "group_price";
    private static String INVENTORY_TRANSACTION_ZEROCOST = "inventory_transaction_zerocost";
    private static String STRATEGY_SYNC_PRICE = "strategy_sync_price";
    private static String BILL_PRICE = "bill_price";
    private static String RECENT_PRICE = "recent_price";
    private static String STRAGE_ZERO_PRICE = "strage_zero_price";
    private boolean enableStd = false;
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Map<Long, String> costAcctIdNameMap = new HashMap<Long, String>(16);
    private Long[] billEntryIds;
    private Map<Long, Integer> rptIdNextSeqDbMap = new HashMap<Long, Integer>(16);
    private Map<Long, Long> rptIdPeriodDbMap = new HashMap<Long, Long>(16);
    private Map<Long, String> elementNameMap = new HashMap<Long, String>(16);
    private String auditType;
    private boolean preCal = false;
    private Map<Long, Long> entryInvOrgIdMap = new HashMap<Long, Long>(16);
    private final Map<String, String> keyOrgValueMap = CalDbParamServiceHelper.getKeyOrgValueMap((String)CalDbParamConstant.NOT_NEG_QTY);
    private String bizBillEntity = null;
    private PriceFluctHolder pricFluctHolder;
    private boolean isEnableNegQtyPrice = false;

    public MoveAddAverageCalculate4Sync(Long[] billIds, String entityName, String opType, String auditType) {
        this.init(billIds, null, entityName, opType, auditType);
    }

    public MoveAddAverageCalculate4Sync(Long[] billIds, Long[] billEntryIds, String entityName, String opType) {
        this.init(billIds, billEntryIds, entityName, opType, null);
    }

    public MoveAddAverageCalculate4Sync(Long[] billIds, String entityName, String opType, long costAccId) {
        this.init(billIds, null, entityName, opType, null);
        DynamicObject costAcc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccId)});
        this.enableStd = costAcc.getBoolean("enablestandardcost");
    }

    private void init(Long[] billIds, Long[] billEntryIds, String entityName, String opType, String auditType) {
        this.entityName = entityName;
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName) || "cal_initbill".equals(entityName)) {
            this.entryName = "entryentity";
        }
        this.billIds = billIds;
        this.billEntryIds = billEntryIds;
        DynamicObject calSetInfo = QueryServiceHelper.queryOne((String)"cal_setting", (String)"dividebasiscols,caldimensioncols", (QFilter[])new QFilter("id", "=", (Object)683799445774680063L).toArray());
        this.divideStr = calSetInfo.getString("dividebasiscols");
        this.caldimensionStr = calSetInfo.getString("caldimensioncols");
        this.totalKey = CommonUtils.trimComma((String)this.divideStr) + "," + CommonUtils.trimComma((String)this.caldimensionStr);
        this.opType = opType;
        this.auditType = auditType;
        DynamicObject[] infos = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        if (infos == null || infos.length == 0) {
            return;
        }
        if (!"cal_balance".equals(entityName)) {
            for (DynamicObject info : infos) {
                this.loadBillMap.put(info.getLong("id"), info);
                for (DynamicObject entry : info.getDynamicObjectCollection(this.entryName)) {
                    this.loadEntryMap.put(entry.getLong("id"), entry);
                }
            }
        }
        if ("cal_costrecord".equals(entityName)) {
            DynamicObject[] settingObj = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizTypes = settingObj.getDynamicObjectCollection("zeroinoutbiztype");
            for (DynamicObject bizType : bizTypes) {
                this.zeroInOutBizTypeIds.add(bizType.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        this.costAdjustOutBillType = CommonSettingHelper.getCostAdjustOutBillType();
        for (DynamicObject info : infos) {
            Boolean calByElement;
            String diffbillType;
            Long costAccountId = info.getLong("costaccount.id");
            Long calOrgId = info.getLong("calorg.id");
            Boolean isPurZeroCost = this.calOrgPurZeroCostMap.get(calOrgId);
            if (isPurZeroCost == null) {
                isPurZeroCost = (Boolean)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"ispurfetchzerocost");
                this.calOrgPurZeroCostMap.put(calOrgId, isPurZeroCost);
            }
            if ((diffbillType = this.createDiffbillTypeMap.get(calOrgId)) == null) {
                diffbillType = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"creatediffbilltype");
                this.createDiffbillTypeMap.put(calOrgId, diffbillType);
            }
            if ((calByElement = this.calByElementMap.get(costAccountId)) == null) {
                calByElement = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement").getDynamicObject("calpolicy").getBoolean("calbycostelement");
                this.calByElementMap.put(costAccountId, calByElement);
            }
            if (this.periodMap.get(costAccountId) != null) continue;
            if ("cal_balance".equals(entityName) || "cal_initbill".equals(entityName)) {
                DynamicObject period = PeriodHelper.getStartPeriod((Long)costAccountId);
                if (period == null) {
                    DynamicObject costaccDyn = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
                    String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"MoveAddAverageCalculate_11", (String)"fi-cal-business", (Object[])new Object[0]);
                    msg = String.format(msg, costaccDyn.getString("number"), costaccDyn.getString("name"));
                    throw new KDBizException(msg);
                }
                this.periodMap.put(costAccountId, period.getLong("id"));
                this.begindateMap.put(costAccountId, period.getDate("begindate"));
                continue;
            }
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                DynamicObject costaccDyn = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
                String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"MoveAddAverageCalculate_12", (String)"fi-cal-business", (Object[])new Object[0]);
                msg = String.format(msg, costaccDyn.getString("number"), costaccDyn.getString("name"));
                throw new KDBizException(msg);
            }
            this.periodMap.put(costAccountId, curPeriod.getLong("id"));
        }
        this.cacheCostAcctIdNameMap(this.calByElementMap.keySet());
        this.pricFluctHolder = new PriceFluctHolder(entityName, billIds);
        QFilter qFilter = new QFilter("priceobject", "=", (Object)"M");
        qFilter.and("entityobject", "=", (Object)"cal_out_calculate");
        this.isEnableNegQtyPrice = new CostPrice4Others().isHasEnablePriceScheme(qFilter);
    }

    public DataSet beforeCalculate() {
        DataSet dataSet = this.getBillDataSet(this.billIds, this.entityName);
        this.cacheBillGroup(dataSet.copy());
        this.cacheCostPrice(dataSet.copy());
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object[]> doCalculate(DataSet dataSet) {
        if (dataSet == null || dataSet.isEmpty()) {
            return null;
        }
        DataSet finalDataSet = null;
        if (!"cal_balance".equals(this.entityName) && !"cal_initbill".equals(this.entityName)) {
            DataSet copyDataSet = dataSet.copy();
            finalDataSet = copyDataSet.select(this.getAliasSelects() + ",case when queuetype = '0' then '1' else '0' end as type");
        } else {
            finalDataSet = dataSet.copy().addField("1", "type");
        }
        DataSet copyFinalDataSet = finalDataSet.copy();
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (DynamicObject[] row : dataSet.copy()) {
            long calRangeId = row.getLong("calRange");
            if (calRangeId != 0L) {
                calRangeSet.add(calRangeId);
            }
            entryIdSet.add(row.getLong("eid"));
            materialIdSet.add(row.getLong("material"));
        }
        DynamicObject[] calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray());
        calRangeSet.clear();
        for (DynamicObject calRange : calRanges) {
            if (calRange.getDynamicObjectCollection("entry").isEmpty()) continue;
            calRangeSet.add(calRange.getLong("id"));
        }
        HashSet lockSet = new HashSet();
        try {
            Object calRangeDataSet;
            QueryInvOrgHelper queryInvOrgHelper;
            List<Long> invOrgIds;
            QFilter costAccountFilter = new QFilter("costaccount", "in", this.calByElementMap.keySet());
            QFilter recentCostFilter = new QFilter("material", "in", materialIdSet);
            if (calRangeSet.isEmpty() && !(invOrgIds = (queryInvOrgHelper = new QueryInvOrgHelper()).queryInvOrgByEntity(this.entityName, Arrays.asList(this.billIds))).isEmpty()) {
                invOrgIds.add(0L);
                recentCostFilter.and(new QFilter("storageorgunit", "in", invOrgIds));
            }
            DataSet recentCostDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_recentcost", (String)("id,material,costaccount,recentqty,recentcost,price,priceupdatetime,calrptid,calrange,to_char(costelement) as costelement,to_char(costsubelement) as costsubelement," + this.totalKey), (QFilter[])new QFilter[]{costAccountFilter, recentCostFilter}, null);
            DataSet groupRCDataSet = recentCostDataSet.copy().groupBy((String[])ArrayUtils.concatAll((Object[])new String[]{"material", "costaccount", "recentqty", "calrptid", "calrange"}, (Object[][])new String[][]{this.totalKey.split(",")})).sum("recentcost").sum("price").max("priceupdatetime").finish().select("-1L as id,material,costaccount,recentqty,recentcost,price,priceupdatetime,calrptid,calrange,'-1' as costelement,'-1' as costsubelement," + this.totalKey);
            DataSet rcDataSet = recentCostDataSet.union(groupRCDataSet);
            HashMap<String, Object[]> errorMsgMap = new HashMap<String, Object[]>(16);
            int entryCounts = 0;
            if (!calRangeSet.isEmpty()) {
                DataSet divideDataSet;
                calRangeDataSet = copyFinalDataSet.copy().filter(new QFilter("calrange", "in", calRangeSet).toString());
                if (!calRangeDataSet.isEmpty()) {
                    entryCounts += this.handleCalRangeDataSet(finalDataSet.copy(), (DataSet)calRangeDataSet, rcDataSet.copy(), (Map<String, Object[]>)errorMsgMap);
                }
                if (!(divideDataSet = copyFinalDataSet.copy().filter(new QFilter("calrange", "not in", calRangeSet).toString())).isEmpty()) {
                    entryCounts += this.handleDivideDataSet(finalDataSet, divideDataSet, rcDataSet, errorMsgMap);
                }
            } else {
                entryCounts += this.handleDivideDataSet(finalDataSet, copyFinalDataSet, rcDataSet, errorMsgMap);
            }
            if (!errorMsgMap.isEmpty() || this.preCal) {
                calRangeDataSet = errorMsgMap.values();
                return calRangeDataSet;
            }
            this.pricFluctHolder.sendFluctEvent();
            if ("cal_costrecord".equals(this.entityName)) {
                ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, (Object)this.billIds)});
                Object object = null;
                try {
                    ctx.set();
                    this.writeCostRecordEntry();
                    this.writeIsCal(entryIdSet);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ctx != null) {
                        if (object != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
            }
            this.writeCostAdjust();
            if ("B".equals(CalDbParamServiceHelper.getString((String)CalDbParamConstant.MOVEADDAVCAL_CALPRT_WRITEMODEL, null))) {
                this.writeRptBySql(entryCounts);
            } else {
                this.writeRpt();
            }
            this.writeRecentCost();
        }
        finally {
            for (DLock lock : lockSet) {
                lock.unlock();
            }
        }
        return null;
    }

    private void writeRecentCost() {
        String updateSql = "update t_cal_recentcost set frecentcost = ? ,frecentqty = ? , fcalrptid = ?, fprice= ?,fpriceupdatetime = ? where fid = ?";
        if (!this.insertRecentCost.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.insertRecentCost.toArray(new DynamicObject[0]));
        }
        if (!this.updateRecentCostList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, this.updateRecentCostList);
        }
    }

    private void writeCostAdjust() {
        if (!this.costAdjustMap.isEmpty()) {
            this.insertOtherElements();
            HashSet<Long> costAdjustEntryIdSet = new HashSet<Long>(128);
            HashSet<Long> costAdjustBillIdSet = new HashSet<Long>(this.costAdjustMap.size());
            SaveServiceHelper.save((DynamicObject[])this.costAdjustMap.values().toArray(new DynamicObject[0]));
            for (Map.Entry<Long, DynamicObject> entry : this.costAdjustMap.entrySet()) {
                DynamicObject info = entry.getValue();
                costAdjustBillIdSet.add(info.getLong("id"));
                for (DynamicObject entryInfo : info.getDynamicObjectCollection("entryentity")) {
                    costAdjustEntryIdSet.add(entryInfo.getLong("id"));
                }
            }
            DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])costAdjustBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreop", "true");
            option.setVariableValue("ishasright", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)option);
            List errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
            if (!this.isNewBalance) {
                new BalanceCalculator().updateBalance4CostAdjust(costAdjustEntryIdSet.toArray());
            }
        }
    }

    private void insertOtherElements() {
        ArrayList<Long[]> costAllSubElements = new ArrayList<Long[]>(16);
        HashMap<Long, Boolean> costElementCache = new HashMap<Long, Boolean>(this.costAdjustMap.size());
        for (Map.Entry<Long, DynamicObject> entry : this.costAdjustMap.entrySet()) {
            DynamicObject info = entry.getValue();
            Long costAccountId = (Long)info.get("costaccount");
            Boolean isCostElement = (Boolean)costElementCache.get(costAccountId);
            if (isCostElement == null) {
                isCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
                costElementCache.put(costAccountId, isCostElement);
            }
            if (!isCostElement.booleanValue()) continue;
            if (costAllSubElements.isEmpty()) {
                HashSet<String> dupSet = new HashSet<String>(16);
                QFilter q = new QFilter("syncflag", "=", (Object)"1");
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
                     DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);){
                    DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement"}, new String[]{"element"}).finish();
                    Object object = null;
                    try {
                        for (Row row : joinDataSet) {
                            if (!dupSet.add(row.getLong("subelement") + "|" + row.getLong("element"))) continue;
                            costAllSubElements.add(new Long[]{row.getLong("subelement"), row.getLong("element")});
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (joinDataSet != null) {
                            if (object != null) {
                                try {
                                    joinDataSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                joinDataSet.close();
                            }
                        }
                    }
                }
            }
            for (DynamicObject entryInfo : info.getDynamicObjectCollection("entryentity")) {
                DynamicObjectCollection details = entryInfo.getDynamicObjectCollection("subentryentity");
                DynamicObject firstDetail = (DynamicObject)details.get(0);
                if (firstDetail == null) continue;
                for (Long[] elements : costAllSubElements) {
                    boolean isExist = false;
                    for (DynamicObject detail : details) {
                        if (detail.getLong("costsubelement") != elements[0].longValue()) continue;
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    DynamicObject detailInfo = details.addNew();
                    long id = DB.genLongId((String)"t_cal_costadjust_detail");
                    detailInfo.set("id", (Object)id);
                    detailInfo.set("sub_material", firstDetail.get("sub_material"));
                    detailInfo.set("costelement", (Object)elements[1]);
                    detailInfo.set("costsubelement", (Object)elements[0]);
                    detailInfo.set("sub_currency", firstDetail.get("sub_currency"));
                    detailInfo.set("sub_adjustamt", (Object)BigDecimal.ZERO);
                }
            }
        }
    }

    private int handleCalRangeDataSet(DataSet finalDataSet, DataSet calRangeDataSet, DataSet recentCostDataSet, Map<String, Object[]> errorMsgMap) {
        finalDataSet = finalDataSet.groupBy(new String[]{"caldimension", "caldimensionstr"}).finish().select(new String[]{"caldimension", "caldimensionstr"});
        int entryCount = 0;
        for (Row row : finalDataSet) {
            DataSet copyCalRangeDataSet = calRangeDataSet.copy();
            long caldimensionid = row.getLong("caldimension");
            copyCalRangeDataSet = copyCalRangeDataSet.filter("caldimension = " + caldimensionid);
            String calKey = "";
            String caldimension = row.getString("caldimensionstr");
            calKey = caldimensionid != 0L ? "calrange," + CommonUtils.trimComma((String)caldimension) : "calrange";
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            DataSet copyRCDataSet = recentCostDataSet.copy();
            JoinDataSet joinDataSet = copyCalRangeDataSet.join(copyRCDataSet, JoinType.LEFT);
            for (String onField : onFields) {
                joinDataSet = joinDataSet.on(onField, onField);
            }
            joinDataSet = joinDataSet.on("costaccount", "costaccount").on("material", "material");
            DataSet detailDataSet = joinDataSet.select((this.getAliasSelects() + ",type").split(","), new String[]{"id as recentcostid", "recentqty", "recentcost", "price", "priceupdatetime", "calrptid"}).finish().orderBy(new String[]{"auditdate", "type", "billno", "entryseq", "costsubelement desc"});
            if ("B".equals(CalDbParamServiceHelper.getString((String)CalDbParamConstant.MOVEADDAVCAL_CALPRT_WRITEMODEL, null))) {
                this.cacheRptByAsynchronous(detailDataSet.copy(), onFields, false);
            } else {
                this.cacheRpt(detailDataSet.copy(), onFields, false);
            }
            entryCount += this.handleDetailDataSet(detailDataSet, onFields, errorMsgMap);
        }
        return entryCount;
    }

    private int handleDivideDataSet(DataSet finalDataSet, DataSet divideDataSet, DataSet recentCostDataSet, Map<String, Object[]> errorMsgMap) {
        finalDataSet = finalDataSet.groupBy(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"}).finish().select(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"});
        int entryCount = 0;
        for (Row row : finalDataSet) {
            DataSet copyDivideDataSet = divideDataSet.copy();
            long dividebasisid = row.getLong("dividebasis");
            long caldimensionid = row.getLong("caldimension");
            String dividebasis = row.getString("dividebasisstr");
            copyDivideDataSet = copyDivideDataSet.filter("dividebasis = " + dividebasisid + " and caldimension = " + caldimensionid);
            String calKey = "";
            String caldimension = row.getString("caldimensionstr");
            calKey = caldimensionid != 0L ? CommonUtils.trimComma((String)dividebasis) + "," + CommonUtils.trimComma((String)caldimension) : CommonUtils.trimComma((String)dividebasis);
            calKey = calKey + ",costelement,costsubelement";
            String[] onFields = calKey.split(",");
            DataSet copyRCDataSet = recentCostDataSet.copy();
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            JoinDataSet joinDataSet = copyDivideDataSet.join(copyRCDataSet, JoinType.LEFT, hint);
            for (String onField : onFields) {
                joinDataSet = joinDataSet.on(onField, onField);
            }
            joinDataSet = joinDataSet.on("costaccount", "costaccount").on("material", "material");
            DataSet detailDataSet = joinDataSet.select((this.getAliasSelects() + ",type").split(","), new String[]{"id as recentcostid", "recentqty", "recentcost", "price", "priceupdatetime", "calrptid"}).finish().orderBy(new String[]{"auditdate", "type", "billno", "entryseq", "costsubelement desc"});
            if ("B".equals(CalDbParamServiceHelper.getString((String)CalDbParamConstant.MOVEADDAVCAL_CALPRT_WRITEMODEL, null))) {
                this.cacheRptByAsynchronous(detailDataSet.copy(), onFields, true);
            } else {
                this.cacheRpt(detailDataSet.copy(), onFields, true);
            }
            entryCount += this.handleDetailDataSet(detailDataSet, onFields, errorMsgMap);
        }
        return entryCount;
    }

    private void cacheBillGroup(DataSet dataSet) {
        if ("cal_costrecord".equals(this.entityName)) {
            HashMap costAccount_calEntryIdMap = new HashMap();
            for (Row row : dataSet) {
                long costAccount = row.getLong("costaccount");
                long calentryId = row.getLong("calentryid");
                long period = row.getLong("period");
                if (costAccount_calEntryIdMap.containsKey(costAccount + "|" + period)) {
                    ((Set)costAccount_calEntryIdMap.get(costAccount + "|" + period)).add(calentryId);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(calentryId);
                costAccount_calEntryIdMap.put(costAccount + "|" + period, set);
            }
            for (Map.Entry entry : costAccount_calEntryIdMap.entrySet()) {
                String key = (String)entry.getKey();
                Map<String, BigDecimal> map = GroupRelationCostCalculator.calculateCost(key.split("\\|")[0], Long.parseLong(key.split("\\|")[1]), (Set)entry.getValue());
                this.billGroupMap.putAll(map);
            }
            logger.info("\u6210\u7ec4\u5173\u7cfb\u83b7\u53d6\uff1a" + this.billGroupMap);
        }
    }

    private void cacheCostPrice(DataSet dataSet) {
        if ("cal_costrecord".equals(this.entityName)) {
            HashMap entityObject_entryIdMap = new HashMap();
            for (Row row : dataSet) {
                long entryId = row.getLong("eid");
                String bizEntityObject = row.getString("bizentityobject");
                ArrayList<Long> list = (ArrayList<Long>)entityObject_entryIdMap.get(bizEntityObject);
                if (list != null) {
                    if (list.contains(entryId)) continue;
                    list.add(entryId);
                    continue;
                }
                list = new ArrayList<Long>();
                list.add(entryId);
                entityObject_entryIdMap.put(bizEntityObject, list);
            }
            for (Map.Entry entry : entityObject_entryIdMap.entrySet()) {
                CostPrice4Others priceHelper = new CostPrice4Others();
                String bizEntityObject = (String)entry.getKey();
                QFilter qFilter = new QFilter("priceobject", "=", (Object)"C");
                qFilter.and("entityobject", "=", (Object)bizEntityObject);
                CostPriceResultInfo[] resultList = priceHelper.getPrice4MoveAddAverage((List)entry.getValue(), qFilter, this.billIds);
                if (resultList == null) continue;
                for (CostPriceResultInfo result : resultList) {
                    if (!result.isDetail() || !result.isSuccess()) continue;
                    this.billCostPriceMap.put(result.getEntryId(), result);
                }
            }
            logger.info("\u53d6\u4ef7\u83b7\u53d6\uff1a" + this.billCostPriceMap);
        }
    }

    private void cacheZeroPrice(List<Long> entryIds) {
        WriteLogHelper.writeInfoLog((Log)logger, (String)("needZeroPriceEntryIds\uff1a" + entryIds.size()), (Object[])new Object[0]);
        if (entryIds.isEmpty()) {
            return;
        }
        HashSet<Long> entryIdSet = new HashSet<Long>(entryIds);
        entryIdSet.removeAll(this.hasGetZeroPriceEntryIds);
        entryIds = new ArrayList<Long>(entryIdSet);
        entryIds = this.getNeedPriceEntryIds(entryIds, this.billCostPriceMap4ZeroPrice.keySet());
        logger.info("needZeroPriceEntryIds1\uff1a" + entryIds.size());
        if (entryIds.isEmpty()) {
            return;
        }
        CostPrice4Others priceHelper = new CostPrice4Others();
        QFilter qFilter = new QFilter("priceobject", "=", (Object)"E");
        qFilter.and("entityobject", "=", (Object)"cal_out_calculate");
        CostPriceResultInfo[] resultList = priceHelper.getPrice4MoveAddAverage(entryIds, qFilter, this.billIds);
        if (resultList != null) {
            for (CostPriceResultInfo result : resultList) {
                if (!result.isDetail() || !result.isSuccess()) continue;
                this.billCostPriceMap4ZeroPrice.put(result.getEntryId(), result);
            }
        }
        this.hasGetZeroPriceEntryIds.addAll(entryIds);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("zeroPriceGet\uff1a" + this.billCostPriceMap4ZeroPrice), (Object[])new Object[0]);
    }

    private List<Long> getNeedPriceEntryIds(List<Long> entryIds, Set<Long> curPriceEIds) {
        if (this.preCal) {
            return entryIds;
        }
        ArrayList<Long> newEntryIds = new ArrayList<Long>(16);
        for (Long entryId : entryIds) {
            boolean noPrice = !curPriceEIds.contains(entryId);
            if (!noPrice) continue;
            newEntryIds.add(entryId);
        }
        entryIds = newEntryIds;
        return entryIds;
    }

    private void cacheNegativePrice(List<Long> entryIds) {
        WriteLogHelper.writeInfoLog((Log)logger, (String)("needNegPriceEntryIds\uff1a" + entryIds.size()), (Object[])new Object[0]);
        if (entryIds.isEmpty()) {
            return;
        }
        HashSet<Long> entryIdSet = new HashSet<Long>(entryIds);
        entryIdSet.removeAll(this.hasGetNegPriceEntryIds);
        entryIds = new ArrayList<Long>(entryIdSet);
        entryIds = this.getNeedPriceEntryIds(entryIds, this.billCostPriceMap4NegativePrice.keySet());
        logger.info("needNegPriceEntryIds1\uff1a" + entryIds.size());
        if (entryIds.isEmpty()) {
            return;
        }
        CostPrice4Others priceHelper = new CostPrice4Others();
        QFilter qFilter = new QFilter("priceobject", "=", (Object)"H");
        qFilter.and("entityobject", "=", (Object)"cal_out_calculate");
        CostPriceResultInfo[] resultList = priceHelper.getPrice4MoveAddAverage(entryIds, qFilter, this.billIds);
        if (resultList != null) {
            for (CostPriceResultInfo result : resultList) {
                if (!result.isDetail() || !result.isSuccess()) continue;
                this.billCostPriceMap4NegativePrice.put(result.getEntryId(), result);
            }
        }
        this.hasGetNegPriceEntryIds.addAll(entryIds);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("negZeroPriceGet\uff1a" + this.billCostPriceMap4NegativePrice), (Object[])new Object[0]);
    }

    private void cacheNegativeQty(List<Long> entryIds) {
        logger.info("\u9700\u8981\u8d1f\u5e93\u5b58\u53d6\u4ef7\u5206\u5f55\uff1a" + entryIds.size());
        entryIds = this.getNeedPriceEntryIds(entryIds, this.billCostPriceMap4NegativeQty.keySet());
        logger.info("\u9700\u8981\u8d1f\u5e93\u5b58\u53d6\u4ef7\u5206\u5f55\uff1a" + entryIds.size());
        if (entryIds.isEmpty()) {
            return;
        }
        CostPrice4Others priceHelper = new CostPrice4Others();
        QFilter qFilter = new QFilter("priceobject", "=", (Object)"M");
        qFilter.and("entityobject", "=", (Object)"cal_out_calculate");
        CostPriceResultInfo[] resultList = priceHelper.getPrice4MoveAddAverage(entryIds, qFilter, this.billIds);
        if (resultList != null) {
            for (CostPriceResultInfo result : resultList) {
                if (!result.isDetail() || !result.isSuccess()) continue;
                this.billCostPriceMap4NegativeQty.put(result.getEntryId(), result);
            }
        }
        logger.info("\u8d1f\u5e93\u5b58\u53d6\u4ef7\u83b7\u53d6\uff1a" + this.billCostPriceMap4NegativeQty);
    }

    private void cacheRpt(DataSet detailDataSet, String[] onFields, boolean isEmptyRange) {
        char innerSplit = '_';
        String outSplit = "&";
        HashSet<Long> rptSet = new HashSet<Long>();
        for (Row row : detailDataSet.copy()) {
            long calrptid = row.get("calrptid") == null ? 0L : row.getLong("calrptid");
            if (calrptid == 0L) continue;
            rptSet.add(calrptid);
        }
        DynamicObject[] rptInfos = BusinessDataServiceHelper.load((Object[])rptSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_calculateoutrpt"));
        HashMap<Object, DynamicObject> rptCacheMap = new HashMap<Object, DynamicObject>(rptInfos.length);
        for (DynamicObject info : rptInfos) {
            rptCacheMap.put(info.getPkValue(), info);
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_caloutrpt");
        for (Row row : detailDataSet) {
            DynamicObject rptInfo;
            String value;
            String key = this.getGroupKey(row, onFields, false);
            long calrptid = row.get("calrptid") == null ? 0L : row.getLong("calrptid");
            long costaccount = row.getLong("costaccount");
            long material = row.getLong("material");
            long dividebasisid = row.getLong("dividebasis");
            long caldimensionid = row.getLong("caldimension");
            long calOrgId = row.getLong("calorgid");
            long calRangeId = row.getLong("calrange");
            String dividebasisStr = row.getString("dividebasisstr");
            String caldimensionStr = row.getString("caldimensionstr");
            String divideBasisValue = "";
            StringBuilder divideBasisValueSB = new StringBuilder();
            String caldimensionValue = "";
            StringBuilder caldimensionValueSB = new StringBuilder();
            if (StringUtils.isNotEmpty((String)dividebasisStr)) {
                for (String s : dividebasisStr.split(",")) {
                    value = row.get(s).toString();
                    if (value.trim().isEmpty()) {
                        value = "#";
                    }
                    divideBasisValueSB.append(value).append(innerSplit);
                }
                divideBasisValue = divideBasisValueSB.substring(0, divideBasisValueSB.length() - 1);
            }
            if (StringUtils.isNotEmpty((String)caldimensionStr)) {
                for (String s : caldimensionStr.split(",")) {
                    value = row.get(s).toString();
                    if (value.trim().isEmpty()) {
                        value = "#";
                    }
                    caldimensionValueSB.append(value).append(innerSplit);
                }
                caldimensionValue = caldimensionValueSB.substring(0, caldimensionValueSB.length() - 1);
            }
            if (!rptCacheMap.containsKey(calrptid) && !this.rptMap.containsKey(key)) {
                rptInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_calculateoutrpt");
                rptInfo.set("costaccount", (Object)costaccount);
                rptInfo.set("calorg", (Object)calOrgId);
                rptInfo.set("period", (Object)this.periodMap.get(costaccount));
                rptInfo.set("material", (Object)material);
                rptInfo.set("dividebasis", (Object)dividebasisid);
                rptInfo.set("caldimension", (Object)caldimensionid);
                rptInfo.set("calrange", (Object)calRangeId);
                if (isEmptyRange) {
                    rptInfo.set("dividebasisvalue", (Object)divideBasisValue);
                }
                rptInfo.set("caldimensionvalue", (Object)caldimensionValue);
                if (StringUtils.isNotEmpty((String)caldimensionStr)) {
                    for (String s : caldimensionStr.split(",")) {
                        Object valueObj = row.get(s);
                        if (valueObj == null) continue;
                        String value2 = String.valueOf(valueObj);
                        if ("assist".equals(s)) {
                            rptInfo.set(s, (Object)value2);
                            continue;
                        }
                        if ("configuredcode".equals(s)) {
                            rptInfo.set(s, (Object)value2);
                            continue;
                        }
                        if ("project".equals(s)) {
                            rptInfo.set(s, (Object)value2);
                            continue;
                        }
                        if (!"tracknumber".equals(s)) continue;
                        rptInfo.set(s, (Object)value2);
                    }
                }
                rptInfo.set("accounttype", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
                rptInfo.set("caltime", (Object)TimeServiceHelper.now());
                rptInfo.set("operationuser", (Object)RequestContext.get().getCurrUserId());
                rptInfo.set("calstatus", (Object)"A");
                rptInfo.set("id", (Object)idGenerator.getId());
                this.rptMap.put(key, rptInfo);
                continue;
            }
            rptInfo = (DynamicObject)rptCacheMap.get(calrptid);
            if (rptInfo == null) {
                rptInfo = this.rptMap.get(key);
            }
            if (rptInfo == null) continue;
            if (isEmptyRange && rptInfo.getString("dividebasisvalue").indexOf(divideBasisValue) < 0) {
                rptInfo.set("dividebasisvalue", (Object)(rptInfo.get("dividebasisvalue") + outSplit + divideBasisValue));
            }
            if (rptInfo.getString("caldimensionvalue").indexOf(caldimensionValue) < 0) {
                rptInfo.set("caldimensionvalue", (Object)(rptInfo.get("caldimensionvalue") + outSplit + caldimensionValue));
            }
            rptInfo.set("caltime", (Object)TimeServiceHelper.now());
            rptInfo.set("operationuser", (Object)RequestContext.get().getCurrUserId());
            this.rptMap.put(key, rptInfo);
        }
    }

    private void cacheRptByAsynchronous(DataSet detailDataSet, String[] onFields, boolean isEmptyRange) {
        char innerSplit = '_';
        for (Row row : detailDataSet) {
            String value;
            Iterator<DynamicObject> key = this.getGroupKey(row, onFields, false);
            long calrptid = row.get("calrptid") == null ? 0L : row.getLong("calrptid");
            DynamicObject rptDyc = this.rptMap.get(key);
            if (rptDyc != null) {
                if (calrptid == 0L) continue;
                rptDyc.set("id", (Object)calrptid);
                continue;
            }
            long costaccount = row.getLong("costaccount");
            long material = row.getLong("material");
            long dividebasisid = row.getLong("dividebasis");
            long caldimensionid = row.getLong("caldimension");
            long calOrgId = row.getLong("calorgid");
            long calRangeId = row.getLong("calrange");
            String dividebasisStr = row.getString("dividebasisstr");
            String caldimensionStr = row.getString("caldimensionstr");
            String divideBasisValue = "";
            StringBuilder divideBasisValueSB = new StringBuilder();
            String caldimensionValue = "";
            StringBuilder caldimensionValueSB = new StringBuilder();
            if (StringUtils.isNotEmpty((String)dividebasisStr)) {
                for (String s : dividebasisStr.split(",")) {
                    value = row.get(s).toString();
                    if (value.trim().isEmpty()) {
                        value = "#";
                    }
                    divideBasisValueSB.append(value).append(innerSplit);
                }
                divideBasisValue = divideBasisValueSB.substring(0, divideBasisValueSB.length() - 1);
            }
            if (StringUtils.isNotEmpty((String)caldimensionStr)) {
                for (String s : caldimensionStr.split(",")) {
                    value = row.get(s).toString();
                    if (value.trim().isEmpty()) {
                        value = "#";
                    }
                    caldimensionValueSB.append(value).append(innerSplit);
                }
                caldimensionValue = caldimensionValueSB.substring(0, caldimensionValueSB.length() - 1);
            }
            DynamicObject rptInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_calculateoutrpt");
            rptInfo.set("costaccount", (Object)costaccount);
            rptInfo.set("calorg", (Object)calOrgId);
            rptInfo.set("period", (Object)this.periodMap.get(costaccount));
            rptInfo.set("material", (Object)material);
            rptInfo.set("dividebasis", (Object)dividebasisid);
            rptInfo.set("caldimension", (Object)caldimensionid);
            rptInfo.set("calrange", (Object)calRangeId);
            if (isEmptyRange) {
                rptInfo.set("dividebasisvalue", (Object)divideBasisValue);
            }
            if (StringUtils.isNotEmpty((String)caldimensionStr)) {
                for (String s : caldimensionStr.split(",")) {
                    Object valueObj = row.get(s);
                    if (valueObj == null) continue;
                    String value2 = String.valueOf(valueObj);
                    if ("assist".equals(s)) {
                        rptInfo.set(s, (Object)value2);
                        continue;
                    }
                    if ("configuredcode".equals(s)) {
                        rptInfo.set(s, (Object)value2);
                        continue;
                    }
                    if ("project".equals(s)) {
                        rptInfo.set(s, (Object)value2);
                        continue;
                    }
                    if (!"tracknumber".equals(s)) continue;
                    rptInfo.set(s, (Object)value2);
                }
            }
            rptInfo.set("caldimensionvalue", (Object)caldimensionValue);
            rptInfo.set("accounttype", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            rptInfo.set("caltime", (Object)TimeServiceHelper.now());
            rptInfo.set("calstatus", (Object)"A");
            rptInfo.set("id", (Object)calrptid);
            rptInfo.set("operationuser", (Object)RequestContext.get().getCurrUserId());
            this.rptMap.put((String)((Object)key), rptInfo);
            rptInfo.getDataEntityState().setFromDatabase(true);
        }
        ArrayList<DynamicObject> newRptInfoDycs = new ArrayList<DynamicObject>(16);
        HashSet<Long> calRptIds = new HashSet<Long>(16);
        for (DynamicObject rptDyc : this.rptMap.values()) {
            calRptIds.add((Long)rptDyc.getPkValue());
        }
        this.cacheRptInfo(calRptIds);
        for (DynamicObject rptInfo : this.rptMap.values()) {
            boolean isRptPeriodLessAcctPeriod;
            long rptId = rptInfo.getLong("id");
            Long rptPeriod = this.rptIdPeriodDbMap.get(rptId);
            Long acctPeriod = this.periodMap.get(rptInfo.getLong("costaccount"));
            boolean bl = isRptPeriodLessAcctPeriod = rptPeriod != null && acctPeriod != null && rptPeriod < acctPeriod;
            if (rptId != 0L && !isRptPeriodLessAcctPeriod) continue;
            newRptInfoDycs.add(rptInfo);
        }
        if (newRptInfoDycs.size() > 0) {
            IDGenerator idGenerator = new IDGenerator("t_cal_caloutrpt", newRptInfoDycs.size());
            for (DynamicObject newRptInfoDyc : newRptInfoDycs) {
                newRptInfoDyc.set("id", (Object)idGenerator.getId());
                newRptInfoDyc.getDataEntityState().setFromDatabase(false);
            }
        }
    }

    private void cacheRptInfo(Set<Long> calRptIds) {
        QFilter calRptIdsFilter = new QFilter("id", "in", calRptIds);
        try (DataSet rptDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calculateoutrpt", (String)"id,nextseq,period", (QFilter[])new QFilter[]{calRptIdsFilter}, null);){
            for (Row rptD : rptDs) {
                this.rptIdNextSeqDbMap.put(rptD.getLong("id"), rptD.getInteger("nextseq"));
                this.rptIdPeriodDbMap.put(rptD.getLong("id"), rptD.getLong("period"));
            }
        }
    }

    private int handleDetailDataSet(DataSet detailDataSet, String[] onFields, Map<String, Object[]> errorMsgMap) {
        String type;
        BillInfo parentBillInfo;
        List list;
        HashMap<String, RecentCostInfo> costMap = new HashMap<String, RecentCostInfo>();
        HashSet<String> insertSet = new HashSet<String>();
        HashMap<String, Long> costIdMap = new HashMap<String, Long>();
        HashMap<Long, RecentCostInfo> detailRecentCostMap = new HashMap<Long, RecentCostInfo>();
        HashMap<Long, String> detailKeyMap = new HashMap<Long, String>();
        HashMap<Long, List<BillInfo>> dataMap = new HashMap<Long, List<BillInfo>>();
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        int entryCount = 0;
        this.cacheMap(detailDataSet, onFields, costMap, insertSet, costIdMap, detailRecentCostMap, detailKeyMap, dataMap, entryIdList);
        HashMap<String, RecentCostInfo> beginMap = new HashMap<String, RecentCostInfo>(16);
        HashMap<String, RecentCostInfo> billCostMap = new HashMap<String, RecentCostInfo>(16);
        HashSet<Long> zeroEntryIds = new HashSet<Long>(16);
        HashSet<Long> negativeEntryIds = new HashSet<Long>(16);
        HashSet<Long> negativeQtyEntryIds = new HashSet<Long>(16);
        for (Long entryId : entryIdList) {
            BigDecimal unitCost;
            RecentCostInfo recentCostInfo;
            Set<Long> entryIds;
            list = (List)dataMap.get(entryId);
            parentBillInfo = (BillInfo)list.get(list.size() - 1);
            if (errorMsgMap.containsKey(parentBillInfo.getKey())) continue;
            type = parentBillInfo.getQueueType();
            for (BillInfo billInfo : list) {
                RecentCostInfo recentCostInfo2 = (RecentCostInfo)detailRecentCostMap.get(billInfo.getDetailId());
                RecentCostInfo beginInfo = recentCostInfo2.copy();
                this.handlePrecision(beginInfo, billInfo.getQtyPrecision(), billInfo.getAmtPrecision(), billInfo.getPricePrecision());
                beginMap.put(this.getEntryAndDetailKey(billInfo), beginInfo);
            }
            if ("1".equals(type)) {
                parentBillInfo.setIgnoreZeroCost(parentBillInfo.isPresent());
            }
            if (!"1".equals(this.opType)) continue;
            for (BillInfo billInfo : list) {
                BigDecimal qty = billInfo.getQty();
                BigDecimal cost = billInfo.getCost();
                BigDecimal unitactualcost = billInfo.getPrice();
                RecentCostInfo rcInfo = new RecentCostInfo();
                rcInfo.setRecentQty(qty);
                rcInfo.setRecentCost(cost);
                rcInfo.setRecentPrice(unitactualcost);
                billCostMap.put(this.getEntryAndDetailKey(billInfo), rcInfo);
            }
            if ("1".equals(type)) {
                entryIds = this.inBillFetchPrice(list, detailKeyMap, detailRecentCostMap, parentBillInfo, billCostMap);
                if (entryIds == null) continue;
                recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
                unitCost = this.fetchCostByRecentCost(parentBillInfo.getPricePrecision(), parentBillInfo.getAmtPrecision(), recentCostInfo);
                if (recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) < 0) {
                    negativeQtyEntryIds.addAll(entryIds);
                    continue;
                }
                if (unitCost.signum() < 0) {
                    negativeEntryIds.addAll(entryIds);
                    continue;
                }
                zeroEntryIds.addAll(entryIds);
                continue;
            }
            entryIds = this.outBillFetchPrice(list, detailKeyMap, detailRecentCostMap, parentBillInfo, billCostMap);
            if (entryIds == null) continue;
            recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
            unitCost = this.fetchCostByRecentCost(parentBillInfo.getPricePrecision(), parentBillInfo.getAmtPrecision(), recentCostInfo);
            if (recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) < 0) {
                negativeQtyEntryIds.addAll(entryIds);
                continue;
            }
            if (unitCost.signum() < 0) {
                negativeEntryIds.addAll(entryIds);
                continue;
            }
            zeroEntryIds.addAll(entryIds);
        }
        this.cacheZeroPrice(new ArrayList<Long>(zeroEntryIds));
        this.cacheNegativePrice(new ArrayList<Long>(negativeEntryIds));
        this.cacheNegativeQty(new ArrayList<Long>(negativeQtyEntryIds));
        for (Long entryId : entryIdList) {
            list = (List)dataMap.get(entryId);
            parentBillInfo = (BillInfo)list.get(list.size() - 1);
            type = parentBillInfo.getQueueType();
            HashMap<Long, RecentCostInfo> costAdjustDetailMap = new HashMap<Long, RecentCostInfo>(16);
            if (!"1".equals(this.opType)) {
                for (BillInfo billInfo : list) {
                    BigDecimal qty = billInfo.getQty();
                    BigDecimal cost = billInfo.getCost();
                    BigDecimal unitactualcost = billInfo.getPrice();
                    RecentCostInfo inInfo = new RecentCostInfo();
                    inInfo.setRecentCost(cost.negate());
                    inInfo.setRecentQty(qty.negate());
                    inInfo.setRecentPrice(unitactualcost);
                    billCostMap.put(this.getEntryAndDetailKey(billInfo), inInfo);
                }
            } else {
                negativeEntryIds.clear();
                zeroEntryIds.clear();
                if ("1".equals(type)) {
                    Set<Long> entryIds = this.inBillFetchPrice(list, detailKeyMap, detailRecentCostMap, parentBillInfo, billCostMap);
                    if (entryIds != null) {
                        RecentCostInfo recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
                        BigDecimal unitCost = this.fetchCostByRecentCost(parentBillInfo.getPricePrecision(), parentBillInfo.getAmtPrecision(), recentCostInfo);
                        if (recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) < 0) {
                            negativeQtyEntryIds.addAll(entryIds);
                        } else if (unitCost.signum() < 0) {
                            negativeEntryIds.addAll(entryIds);
                        } else {
                            zeroEntryIds.addAll(entryIds);
                        }
                    }
                } else {
                    RecentCostInfo curRecentCostInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
                    parentBillInfo.setIgnoreZeroCost(curRecentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && curRecentCostInfo.getRecentCost().compareTo(BigDecimal.ZERO) == 0);
                    Set<Long> entryIds = this.outBillFetchPrice(list, detailKeyMap, detailRecentCostMap, parentBillInfo, billCostMap);
                    if (entryIds != null) {
                        RecentCostInfo recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
                        BigDecimal unitCost = this.fetchCostByRecentCost(parentBillInfo.getPricePrecision(), parentBillInfo.getAmtPrecision(), recentCostInfo);
                        if (recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) < 0) {
                            negativeQtyEntryIds.addAll(entryIds);
                        } else if (unitCost.signum() < 0) {
                            negativeEntryIds.addAll(entryIds);
                        } else {
                            zeroEntryIds.addAll(entryIds);
                        }
                    }
                }
                String costpricesourcestr = parentBillInfo.getCostpricesource();
                StringBuilder costpricesourceSb = new StringBuilder();
                if (StringUtils.isNotEmpty((String)costpricesourcestr)) {
                    if (!costpricesourcestr.endsWith(",")) {
                        costpricesourcestr = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costpricesourcestr);
                    }
                    costpricesourceSb.append(costpricesourcestr);
                }
                for (BillInfo billInfo : list) {
                    RecentCostInfo rcInfo;
                    BigDecimal[] costs;
                    String key = (String)detailKeyMap.get(billInfo.getDetailId());
                    boolean isDetail = this.isDetail(key);
                    if (!isDetail) continue;
                    if (zeroEntryIds.contains(billInfo.getBillEntryId())) {
                        costs = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                        costs = this.fetchZeroPrice(billInfo, costpricesourceSb, costpricesourcestr);
                        rcInfo = (RecentCostInfo)billCostMap.get(this.getEntryAndDetailKey(billInfo));
                        rcInfo.setRecentCost(costs[0]);
                        rcInfo.setRecentPrice(costs[1]);
                    }
                    if (negativeEntryIds.contains(billInfo.getBillEntryId())) {
                        costs = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                        costs = this.fetchNegativePrice(billInfo, costpricesourceSb, costpricesourcestr);
                        rcInfo = (RecentCostInfo)billCostMap.get(this.getEntryAndDetailKey(billInfo));
                        rcInfo.setRecentCost(costs[0]);
                        rcInfo.setRecentPrice(costs[1]);
                    }
                    if (negativeQtyEntryIds.contains(billInfo.getBillEntryId())) {
                        costs = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                        costs = this.fetchNegativeQty(billInfo, costpricesourceSb, costpricesourcestr);
                        rcInfo = (RecentCostInfo)billCostMap.get(this.getEntryAndDetailKey(billInfo));
                        rcInfo.setRecentCost(costs[0]);
                        rcInfo.setRecentPrice(costs[1]);
                    }
                    BigDecimal billQty = billInfo.getQty();
                    long eid = billInfo.getBillEntryId();
                    long costSubElement = billInfo.getCostSubElementId();
                    BigDecimal queueSign = billInfo.getSignnum();
                    BigDecimal sign = new BigDecimal(billQty.signum()).multiply(queueSign);
                    boolean isCalByCostElement = this.calByElementMap.get(billInfo.getCostAccountId());
                    RecentCostInfo rcInfo2 = (RecentCostInfo)billCostMap.get(this.getEntryAndDetailKey(billInfo));
                    BigDecimal unitCost = BigDecimal.ZERO;
                    BigDecimal actualCost = BigDecimal.ZERO;
                    if (rcInfo2 != null) {
                        unitCost = rcInfo2.getRecentPrice();
                        actualCost = rcInfo2.getRecentCost();
                    }
                    BigDecimal priceSignum = new BigDecimal(unitCost.signum());
                    actualCost = actualCost.abs().multiply(sign).multiply(priceSignum).multiply(queueSign);
                    if (!billInfo.getPriceTypes().contains(BILL_PRICE)) {
                        this.recordMap.put(eid + "|" + costSubElement, new BigDecimal[]{actualCost.abs().multiply(sign).multiply(priceSignum), unitCost});
                        this.costRecordEntrySet.add(eid);
                        if (isCalByCostElement) {
                            this.byElementCostRecordEntrySet.add(eid);
                        } else {
                            this.noneElementCostRecordEntrySet.add(eid);
                        }
                    }
                    if (rcInfo2 != null) {
                        rcInfo2.setRecentCost(actualCost);
                        parentBillInfo.setCost(parentBillInfo.getCost().add(rcInfo2.getRecentCost().subtract(billInfo.getCost())));
                        parentBillInfo.setPrice(parentBillInfo.getPrice().add(rcInfo2.getRecentPrice().subtract(billInfo.getPrice())));
                    }
                    parentBillInfo.addAllPriceTypeName(billInfo.getPriceTypeNames());
                    parentBillInfo.addAllPriceType(billInfo.getPriceTypes());
                }
                if (costpricesourceSb.length() > 0) {
                    boolean isUpdateFromExpCalcute;
                    String costPriceSourceStrs;
                    String costPriceSourceStr = costpricesourceSb.substring(0, costpricesourceSb.length() - 1);
                    Object designated = "0";
                    String costPriceSource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costPriceSourceStr);
                    CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue((String)costPriceSource);
                    if (costPriceSourceTypeEnum != null) {
                        designated = costPriceSourceTypeEnum.getDesignated();
                    }
                    if (StringUtils.isNotEmpty((String)(costPriceSourceStrs = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costPriceSourceStr))) && !(isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)this.auditType, (String)costPriceSourceStrs))) {
                        this.updateCostPricesParams.add(new Object[]{costPriceSourceStrs, designated, entryId});
                        parentBillInfo.setCostpricesource(costPriceSourceStrs);
                    }
                }
                RecentCostInfo parentInInfo = new RecentCostInfo();
                parentInInfo.setRecentCost(parentBillInfo.getCost());
                parentInInfo.setRecentQty(parentBillInfo.getQty());
                parentInInfo.setRecentPrice(parentBillInfo.getPrice());
                billCostMap.put(this.getEntryAndDetailKey(parentBillInfo), parentInInfo);
            }
            int pricePrecision = parentBillInfo.getPricePrecision();
            int amountPrecision = parentBillInfo.getAmtPrecision();
            int qtyPrecision = parentBillInfo.getQtyPrecision();
            for (BillInfo billInfo : list) {
                String key;
                boolean isDetail;
                RecentCostInfo recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(billInfo.getDetailId());
                RecentCostInfo beginInfo = recentCostInfo.copy();
                this.handlePrecision(beginInfo, billInfo.getQtyPrecision(), billInfo.getAmtPrecision(), billInfo.getPricePrecision());
                beginMap.put(this.getEntryAndDetailKey(billInfo), beginInfo);
                RecentCostInfo inInfo = null;
                RecentCostInfo outInfo = null;
                if ("1".equals(type)) {
                    inInfo = (RecentCostInfo)billCostMap.get(this.getEntryAndDetailKey(billInfo));
                } else {
                    outInfo = (RecentCostInfo)billCostMap.get(this.getEntryAndDetailKey(billInfo));
                }
                BigDecimal endCost = recentCostInfo.getRecentCost().add(inInfo == null ? BigDecimal.ZERO : inInfo.getRecentCost()).subtract(outInfo == null ? BigDecimal.ZERO : outInfo.getRecentCost());
                BigDecimal endQty = recentCostInfo.getRecentQty().add(inInfo == null ? BigDecimal.ZERO : inInfo.getRecentQty()).subtract(outInfo == null ? BigDecimal.ZERO : outInfo.getRecentQty());
                recentCostInfo.setRecentCost(endCost);
                recentCostInfo.setRecentQty(endQty);
                this.handlePrecision(recentCostInfo, qtyPrecision, amountPrecision, pricePrecision);
                if (inInfo != null) {
                    billInfo.setCost(inInfo.getRecentCost());
                    billInfo.setPrice(inInfo.getRecentPrice());
                    billInfo.setQty(inInfo.getRecentQty());
                } else if (outInfo != null) {
                    billInfo.setCost(outInfo.getRecentCost());
                    billInfo.setPrice(outInfo.getRecentPrice());
                    billInfo.setQty(outInfo.getRecentQty());
                }
                if (!(isDetail = this.isDetail(key = (String)detailKeyMap.get(billInfo.getDetailId())))) continue;
                this.handlePrecision(billInfo, qtyPrecision, amountPrecision, pricePrecision);
                this.checkRecentCost(recentCostInfo, billInfo, costAdjustDetailMap);
            }
            if ("cal_costrecord".equals(this.entityName)) {
                String negEndQtyErrMsg = this.checkNegEndQty(detailRecentCostMap, list);
                String errorMsg = this.checkBillInfo(parentBillInfo);
                String string = errorMsg = errorMsg == null ? negEndQtyErrMsg : errorMsg + "\r\n" + negEndQtyErrMsg;
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    errorMsgMap.put(parentBillInfo.getKey(), new Object[]{parentBillInfo.getBizbillId(), errorMsg, parentBillInfo.getBillNo(), parentBillInfo.getMaterialNum(), parentBillInfo.getCostAccountId(), parentBillInfo.getBillId(), parentBillInfo.getBillEntryId(), parentBillInfo.getMaterialId()});
                    continue;
                }
            }
            if (!errorMsgMap.isEmpty()) continue;
            RecentCostInfo parentRcInfo = (RecentCostInfo)detailRecentCostMap.get(parentBillInfo.getDetailId());
            RecentCostInfo parentBeginInfo = (RecentCostInfo)beginMap.get(this.getEntryAndDetailKey(parentBillInfo));
            String parentKey = (String)detailKeyMap.get(parentBillInfo.getDetailId());
            DynamicObject parentRptInfo = this.rptMap.get(this.getRptKey(parentKey));
            int currSeq = this.getCurrSeq(parentRptInfo);
            parentRptInfo.set("nextSeq", (Object)currSeq++);
            this.handlePrecision(parentBillInfo, parentBillInfo.getQtyPrecision(), parentBillInfo.getAmtPrecision(), parentBillInfo.getPricePrecision());
            this.addRptEntry(parentRptInfo, parentBillInfo, parentBeginInfo, parentRcInfo);
            ++entryCount;
            BigDecimal befRecQty = parentBeginInfo.getRecentQty();
            BigDecimal befRecCOst = parentBeginInfo.getRecentCost();
            BigDecimal aftRecQty = parentRcInfo.getRecentQty();
            BigDecimal aftRecCost = parentRcInfo.getRecentCost();
            long eId = parentBillInfo.getBillEntryId();
            long billId = parentBillInfo.getBillId();
            this.pricFluctHolder.addFuctuationParams(befRecQty, befRecCOst, aftRecQty, aftRecCost, eId, billId);
            for (int i = 0; i < list.size() - 1; ++i) {
                BillInfo billInfo = (BillInfo)list.get(i);
                String key = (String)detailKeyMap.get(billInfo.getDetailId());
                DynamicObject rptInfo = this.rptMap.get(this.getRptKey(key));
                parentRptInfo.set("nextSeq", (Object)currSeq++);
                RecentCostInfo recentCostInfo = (RecentCostInfo)detailRecentCostMap.get(billInfo.getDetailId());
                RecentCostInfo beginInfo = (RecentCostInfo)beginMap.get(this.getEntryAndDetailKey(billInfo));
                this.addRptEntry(rptInfo, billInfo, beginInfo, recentCostInfo);
                ++entryCount;
            }
            DynamicObject costAdjustbill = this.costAdjustMap.get(parentBillInfo.getBillEntryId());
            DynamicObject costAdjustEntry = this.costAdjustEntryMap.get(parentBillInfo.getBillEntryId());
            if (costAdjustbill == null || costAdjustEntry == null) continue;
            entryCount += this.addRptEntry4CostAdjust(parentRptInfo, parentBillInfo, parentRcInfo, costAdjustDetailMap, costAdjustbill, costAdjustEntry);
        }
        if (!errorMsgMap.isEmpty()) {
            return entryCount;
        }
        this.writeRecentCost(costMap, insertSet, costIdMap, onFields);
        return entryCount;
    }

    private String checkNegEndQty(Map<Long, RecentCostInfo> detailRecentCostMap, List<BillInfo> list) {
        String negEndQtyErrMsg = "";
        if (this.keyOrgValueMap.isEmpty() || "im_transinbill".equals(this.bizBillEntity)) {
            return negEndQtyErrMsg;
        }
        for (BillInfo billInfo : list) {
            String queueType = billInfo.getQueueType();
            BigDecimal qty = billInfo.getQty();
            BigDecimal opType = "1".equals(this.opType) ? BigDecimal.ONE : new BigDecimal("-1");
            RecentCostInfo recentCostInfo = detailRecentCostMap.get(billInfo.getDetailId());
            long billEntryId = billInfo.getBillEntryId();
            Long invOrgId = this.entryInvOrgIdMap.get(billEntryId);
            boolean isNotAllowNegEndQty = this.keyOrgValueMap.containsKey(CalDbParamConstant.NOT_NEG_QTY + invOrgId);
            boolean isInQueue = "1".equals(queueType);
            boolean isOutQueue = "0".equals(queueType);
            boolean isOut = isInQueue && qty.multiply(opType).signum() < 0 || isOutQueue && qty.multiply(opType).signum() > 0;
            if (!isOut || recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) >= 0 || !isNotAllowNegEndQty) continue;
            String msgFormat = ResManager.loadKDString((String)"\u7ed3\u5b58\u6570\u91cf\u5c0f\u4e8e0, \u8bf7\u786e\u8ba4\u3002\u201c%3$s\u201c\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"MoveAddAverageCalculate4Sync_1", (String)"fi-cal-business", (Object[])new Object[0]);
            String costAcctName = this.getCostAcctIdNameMap().get(billInfo.getCostAccountId());
            String costAcctNameMsg = "";
            if (StringUtils.isNotEmpty((String)costAcctName)) {
                costAcctNameMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%s\u3011", (String)"CalMoveAddAverageNewProcess_2", (String)"fi-cal-business", (Object[])new Object[0]);
                costAcctNameMsg = String.format(costAcctNameMsg, costAcctName);
            }
            negEndQtyErrMsg = String.format(msgFormat, billInfo.getMaterialNum(), billInfo.getMaterialName(), costAcctNameMsg);
            break;
        }
        return negEndQtyErrMsg;
    }

    private void reGetNewRecentCostInfo(Map<Long, RecentCostInfo> detailRecentCostMap, Map<Long, String> detailKeyMap, Map<String, RecentCostInfo> billCostMap, List<BillInfo> list, BillInfo parentBillInfo) {
        boolean isRecOrZeroPrice;
        boolean ignoreZeroCost;
        String type = parentBillInfo.getQueueType();
        RecentCostInfo curRecentCostInfo = detailRecentCostMap.get(parentBillInfo.getDetailId());
        if ("0".equals(type) && !(ignoreZeroCost = parentBillInfo.isIgnoreZeroCost())) {
            parentBillInfo.setIgnoreZeroCost(curRecentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && curRecentCostInfo.getRecentCost().compareTo(BigDecimal.ZERO) == 0);
        }
        if (isRecOrZeroPrice = this.hasPrice(list, RECENT_PRICE, STRAGE_ZERO_PRICE)) {
            this.fetchRecentPrice(parentBillInfo, curRecentCostInfo);
        }
    }

    private Set<Long> inBillFetchPrice(List<BillInfo> list, Map<Long, String> detailKeyMap, Map<Long, RecentCostInfo> detailRecentCostMap, BillInfo parentBillInfo, Map<String, RecentCostInfo> billCostMap) {
        boolean isPur;
        this.fetchPrice(list, detailKeyMap, billCostMap, GROUP_PRICE, detailRecentCostMap);
        if (!this.hasPrice(list, GROUP_PRICE)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, INVENTORY_TRANSACTION_ZEROCOST, detailRecentCostMap);
        }
        if (!this.hasPrice(list, GROUP_PRICE, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, STRATEGY_SYNC_PRICE, detailRecentCostMap);
        }
        if (!this.hasPrice(list, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, BILL_PRICE, detailRecentCostMap);
        }
        boolean purZeroPrice = this.calOrgPurZeroCostMap.get(parentBillInfo.getCalOrgId());
        boolean bl = isPur = "im_purinbill".equals(parentBillInfo.getBizEntityObject()) || "im_mdc_ominbill".equals(parentBillInfo.getBizEntityObject()) || "im_ospurinbill".equals(parentBillInfo.getBizEntityObject());
        if (!this.hasPrice(list, GROUP_PRICE, STRATEGY_SYNC_PRICE, BILL_PRICE, INVENTORY_TRANSACTION_ZEROCOST) && !parentBillInfo.isIgnoreZeroCost() && (!isPur || isPur && purZeroPrice)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, RECENT_PRICE, detailRecentCostMap);
        }
        if (!(this.hasPrice(list, GROUP_PRICE, STRATEGY_SYNC_PRICE, BILL_PRICE, RECENT_PRICE, INVENTORY_TRANSACTION_ZEROCOST) || parentBillInfo.isIgnoreZeroCost() || isPur)) {
            return this.fetchPrice(list, detailKeyMap, billCostMap, STRAGE_ZERO_PRICE, detailRecentCostMap);
        }
        return null;
    }

    private Set<Long> outBillFetchPrice(List<BillInfo> list, Map<Long, String> detailKeyMap, Map<Long, RecentCostInfo> detailRecentCostMap, BillInfo parentBillInfo, Map<String, RecentCostInfo> billCostMap) {
        boolean isPur;
        this.fetchPrice(list, detailKeyMap, billCostMap, GROUP_PRICE, detailRecentCostMap);
        if (!this.hasPrice(list, GROUP_PRICE)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, INVENTORY_TRANSACTION_ZEROCOST, detailRecentCostMap);
        }
        if (!this.hasPrice(list, GROUP_PRICE, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, STRATEGY_SYNC_PRICE, detailRecentCostMap);
        }
        if (!this.hasPrice(list, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, BILL_PRICE, detailRecentCostMap);
        }
        if (!this.hasPrice(list, GROUP_PRICE, STRATEGY_SYNC_PRICE, BILL_PRICE, INVENTORY_TRANSACTION_ZEROCOST)) {
            this.fetchPrice(list, detailKeyMap, billCostMap, RECENT_PRICE, detailRecentCostMap);
        }
        boolean bl = isPur = "im_purinbill".equals(parentBillInfo.getBizEntityObject()) || "im_mdc_ominbill".equals(parentBillInfo.getBizEntityObject()) || "im_ospurinbill".equals(parentBillInfo.getBizEntityObject());
        if (!(this.hasPrice(list, GROUP_PRICE, STRATEGY_SYNC_PRICE, BILL_PRICE, RECENT_PRICE, INVENTORY_TRANSACTION_ZEROCOST) || parentBillInfo.isIgnoreZeroCost() || isPur)) {
            return this.fetchPrice(list, detailKeyMap, billCostMap, STRAGE_ZERO_PRICE, detailRecentCostMap);
        }
        return null;
    }

    private Set<Long> fetchPrice(List<BillInfo> list, Map<Long, String> detailKeyMap, Map<String, RecentCostInfo> billCostMap, String priceType, Map<Long, RecentCostInfo> detailRecentCostMap) {
        String costpricesource;
        boolean isUpdateFromExpCalcute;
        BillInfo parentBillInfo = list.get(list.size() - 1);
        HashSet<Long> zeroEntryIds = new HashSet<Long>(16);
        StringBuilder costPriceSourceSb = new StringBuilder();
        HashSet<String> costPriceSourceSet = new HashSet<String>(16);
        String costPriceSourceStr = null;
        for (BillInfo billInfo : list) {
            BigDecimal[] costs;
            block15: {
                RecentCostInfo recentCostInfo;
                block16: {
                    block17: {
                        block14: {
                            long detailId = billInfo.getDetailId();
                            String key = detailKeyMap.get(detailId);
                            boolean isDetail = this.isDetail(key);
                            recentCostInfo = detailRecentCostMap.get(billInfo.getDetailId());
                            if (!isDetail) continue;
                            costs = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                            if (!GROUP_PRICE.equals(priceType)) break block14;
                            costs = this.fetchGroupPrice(billInfo);
                            break block15;
                        }
                        if (!INVENTORY_TRANSACTION_ZEROCOST.equals(priceType)) break block16;
                        BillInfo parentBill = list.get(list.size() - 1);
                        if (!billInfo.isInvTxZeroCost() && (!parentBill.isPresent() || !"1".equals(parentBill.getQueueType()))) break block15;
                        parentBill.setIgnoreZeroCost(Boolean.TRUE);
                        costs[0] = BigDecimal.ZERO;
                        costs[1] = BigDecimal.ZERO;
                        billInfo.addPriceType(INVENTORY_TRANSACTION_ZEROCOST);
                        if (!parentBill.isPresent() || !"1".equals(parentBill.getQueueType())) break block17;
                        billInfo.addPriceTypeName(this.presentPriceName);
                        break block15;
                    }
                    if (!billInfo.isInvTxZeroCost()) break block15;
                    billInfo.addPriceTypeName(this.zeroCostPriceName);
                    break block15;
                }
                if (STRATEGY_SYNC_PRICE.equals(priceType)) {
                    costs = this.fetchSyncPrice(billInfo);
                } else if (BILL_PRICE.equals(priceType)) {
                    if (billInfo.getPriceTypes().contains(GROUP_PRICE) || billInfo.getPriceTypes().contains(STRATEGY_SYNC_PRICE) || billInfo.getPriceTypes().contains(INVENTORY_TRANSACTION_ZEROCOST)) continue;
                    costs = this.fetchBillPrice(billInfo);
                } else if (RECENT_PRICE.equals(priceType)) {
                    costs = this.fetchRecentPrice(billInfo, recentCostInfo);
                } else if (STRAGE_ZERO_PRICE.equals(priceType)) {
                    zeroEntryIds.add(billInfo.getBillEntryId());
                    continue;
                }
            }
            if (!billInfo.getPriceTypes().contains(priceType)) continue;
            RecentCostInfo rcInfo = billCostMap.get(this.getEntryAndDetailKey(billInfo));
            rcInfo.setRecentCost(costs[0]);
            rcInfo.setRecentPrice(costs[1]);
            if (GROUP_PRICE.equals(priceType)) {
                String costpricesource2 = billInfo.getCostpricesource();
                costpricesource2 = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource2);
                String bizEntityObject = billInfo.getBizEntityObject();
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource2)) continue;
                costPriceSourceSet.add(CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue());
                continue;
            }
            if (STRATEGY_SYNC_PRICE.equals(priceType)) {
                String bizEntityObject = billInfo.getBizEntityObject();
                String costpricesource3 = billInfo.getCostpricesource();
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)(costpricesource3 = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource3)))) continue;
                costPriceSourceSet.add(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                continue;
            }
            if (BILL_PRICE.equals(priceType) || INVENTORY_TRANSACTION_ZEROCOST.equals(priceType)) {
                costPriceSourceSet.add(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                continue;
            }
            if (!RECENT_PRICE.equals(priceType)) continue;
            costPriceSourceSet.add(CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue());
        }
        if (!costPriceSourceSet.isEmpty()) {
            for (String costPriceSource : costPriceSourceSet) {
                costPriceSourceSb.append(costPriceSource);
                costPriceSourceSb.append(",");
            }
        }
        if (costPriceSourceSb.length() > 0 && !(isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)this.auditType, (String)(costpricesource = parentBillInfo.getCostpricesource())))) {
            costPriceSourceStr = costPriceSourceSb.toString();
            parentBillInfo.setCostpricesource(costPriceSourceStr);
        }
        return zeroEntryIds;
    }

    private boolean hasPrice(List<BillInfo> list, String ... priceType) {
        for (BillInfo info : list) {
            for (String type : priceType) {
                if (!info.getPriceTypes().contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    private BigDecimal[] fetchZeroPrice(BillInfo billInfo, StringBuilder costpricesourceSb, String costpricesourceStr) {
        BigDecimal billQty = billInfo.getQty();
        int amountPrecision = billInfo.getAmtPrecision();
        long eid = billInfo.getBillEntryId();
        long costSubElement = billInfo.getCostSubElementId();
        BigDecimal unitCost = BigDecimal.ZERO;
        BigDecimal actualCost = BigDecimal.ZERO;
        CostPriceResultInfo result = this.billCostPriceMap4ZeroPrice.get(eid);
        if (result == null) {
            ArrayList<Long> list = new ArrayList<Long>(8);
            list.add(eid);
            this.cacheZeroPrice(list);
            result = this.billCostPriceMap4ZeroPrice.get(eid);
        }
        if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(costSubElement)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = unitCost.multiply(billQty).setScale(amountPrecision, 4);
            this.dealGetPricePriceSrc(billInfo, costpricesourceSb, costpricesourceStr, result);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private void dealGetPricePriceSrc(BillInfo billInfo, StringBuilder costpricesourceSb, String costpricesourceStr, CostPriceResultInfo result) {
        String srcBillno = result.getSrcBillno();
        if (StringUtils.isNotEmpty((String)srcBillno)) {
            billInfo.addPriceTypeName(result.getSrcPriceName() + srcBillno);
        } else {
            billInfo.addPriceTypeName(result.getSrcPriceName());
        }
        billInfo.addPriceType(STRAGE_ZERO_PRICE);
        boolean isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)this.auditType, (String)costpricesourceStr);
        if (!isUpdateFromExpCalcute) {
            costpricesourceSb.append(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
            costpricesourceSb.append(",");
        }
    }

    private BigDecimal[] fetchNegativePrice(BillInfo billInfo, StringBuilder costpricesourceSb, String costpricesourceStr) {
        BigDecimal billQty = billInfo.getQty();
        int amountPrecision = billInfo.getAmtPrecision();
        long eid = billInfo.getBillEntryId();
        long costSubElement = billInfo.getCostSubElementId();
        BigDecimal unitCost = BigDecimal.ZERO;
        BigDecimal actualCost = BigDecimal.ZERO;
        CostPriceResultInfo result = this.billCostPriceMap4NegativePrice.get(eid);
        if (result == null) {
            ArrayList<Long> list = new ArrayList<Long>(8);
            list.add(eid);
            this.cacheNegativePrice(list);
            result = this.billCostPriceMap4NegativePrice.get(eid);
        }
        if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(costSubElement)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = unitCost.multiply(billQty).setScale(amountPrecision, 4);
            this.dealGetPricePriceSrc(billInfo, costpricesourceSb, costpricesourceStr, result);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchNegativeQty(BillInfo billInfo, StringBuilder costpricesourceSb, String costpricesourceStr) {
        BigDecimal billQty = billInfo.getQty();
        int amountPrecision = billInfo.getAmtPrecision();
        long eid = billInfo.getBillEntryId();
        long costSubElement = billInfo.getCostSubElementId();
        BigDecimal unitCost = BigDecimal.ZERO;
        BigDecimal actualCost = BigDecimal.ZERO;
        CostPriceResultInfo result = this.billCostPriceMap4NegativeQty.get(eid);
        if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(costSubElement)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = unitCost.multiply(billQty).setScale(amountPrecision, 4);
            this.dealGetPricePriceSrc(billInfo, costpricesourceSb, costpricesourceStr, result);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchRecentPrice(BillInfo billInfo, RecentCostInfo recentCostInfo) {
        boolean isGetRecentPrice;
        BigDecimal billQty = billInfo.getQty();
        int pricePrecision = billInfo.getPricePrecision();
        int amountPrecision = billInfo.getAmtPrecision();
        BigDecimal unitCost = this.fetchCostByRecentCost(pricePrecision, amountPrecision, recentCostInfo);
        BigDecimal actualCost = billQty.multiply(unitCost).setScale(amountPrecision, 4);
        boolean isNotNegQty = recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) > 0;
        isNotNegQty = this.isEnableNegQtyPrice ? isNotNegQty : true;
        boolean isCalByCostElement = this.calByElementMap.get(billInfo.getCostAccountId());
        boolean bl = isCalByCostElement ? true : (isGetRecentPrice = unitCost.compareTo(BigDecimal.ZERO) > 0);
        if (unitCost != null && unitCost.compareTo(BigDecimal.ZERO) != 0 && isNotNegQty && isGetRecentPrice) {
            billInfo.addPriceTypeName(this.realTimePriceName);
            billInfo.addPriceType(RECENT_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchBillPrice(BillInfo billInfo) {
        BigDecimal billCost = billInfo.getCost();
        BigDecimal billPrice = billInfo.getPrice();
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        if (billCost.compareTo(BigDecimal.ZERO) != 0 || billPrice.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = billCost;
            unitCost = billPrice;
            billInfo.addPriceType(BILL_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchSyncPrice(BillInfo billInfo) {
        BigDecimal billQty = billInfo.getQty();
        long eid = billInfo.getBillEntryId();
        long costSubElement = billInfo.getCostSubElementId();
        int amountPrecision = billInfo.getAmtPrecision();
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        String costpricesource = billInfo.getCostpricesource();
        costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource);
        String bizEntityObject = billInfo.getBizEntityObject();
        if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource)) {
            return null;
        }
        CostPriceResultInfo result = this.billCostPriceMap.get(eid);
        if (result != null && (unitCost = (BigDecimal)result.getCostSubElementUnitcostMap().get(costSubElement)) != null && unitCost.compareTo(BigDecimal.ZERO) != 0) {
            actualCost = unitCost.multiply(billQty).setScale(amountPrecision, 4);
            String srcBillno = result.getSrcBillno();
            if (StringUtils.isNotEmpty((String)srcBillno)) {
                billInfo.addPriceTypeName(result.getSrcPriceName() + srcBillno);
            } else {
                billInfo.addPriceTypeName(result.getSrcPriceName());
            }
            billInfo.addPriceType(STRATEGY_SYNC_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private BigDecimal[] fetchGroupPrice(BillInfo billInfo) {
        BigDecimal billQty = billInfo.getQty();
        long calEntryId = billInfo.getCalEntryId();
        long eid = billInfo.getBillEntryId();
        long costaccount = billInfo.getCostAccountId();
        long costSubElement = billInfo.getCostSubElementId();
        int pricePrecision = billInfo.getPricePrecision();
        BigDecimal queueSign = billInfo.getSignnum();
        BigDecimal sign = new BigDecimal(billQty.signum()).multiply(queueSign);
        BigDecimal actualCost = null;
        BigDecimal unitCost = null;
        boolean isCalByCostElement = this.calByElementMap.get(billInfo.getCostAccountId());
        if (isCalByCostElement) {
            actualCost = this.billGroupMap.get(costaccount + "|" + calEntryId + "|" + costSubElement);
        } else {
            BigDecimal gresource;
            BigDecimal gmanufactureCost;
            BigDecimal gprocessCost;
            BigDecimal gfee;
            String costAccountKey = costaccount + "|" + calEntryId;
            BigDecimal materialCost = billInfo.getMaterialCost();
            BigDecimal fee = billInfo.getFee();
            BigDecimal processCost = billInfo.getProcessCost();
            BigDecimal manufactureCost = billInfo.getManufactureCost();
            BigDecimal resource = billInfo.getResource();
            boolean isGroup = false;
            BigDecimal gmaterialCost = this.billGroupMap.get(costAccountKey + "|" + "materialcost");
            if (gmaterialCost != null) {
                materialCost = gmaterialCost;
                isGroup = true;
                BigDecimal unitMaterialCost = gmaterialCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitMaterialCost.signum());
                this.materialCostMap.put(eid, new BigDecimal[]{gmaterialCost.abs().multiply(sign).multiply(priceSignum), unitMaterialCost});
            }
            if ((gfee = this.billGroupMap.get(costAccountKey + "|" + "fee")) != null) {
                fee = gfee;
                isGroup = true;
                BigDecimal unitFee = gfee.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitFee.signum());
                this.feeMap.put(eid, new BigDecimal[]{gfee.abs().multiply(sign).multiply(priceSignum), unitFee});
            }
            if ((gprocessCost = this.billGroupMap.get(costAccountKey + "|" + "processcost")) != null) {
                processCost = gprocessCost;
                isGroup = true;
                BigDecimal unitProcessCost = gprocessCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitProcessCost.signum());
                this.processCostMap.put(eid, new BigDecimal[]{gprocessCost.abs().multiply(sign).multiply(priceSignum), unitProcessCost});
            }
            if ((gmanufactureCost = this.billGroupMap.get(costAccountKey + "|" + "manufacturecost")) != null) {
                manufactureCost = gmanufactureCost;
                isGroup = true;
                BigDecimal unitManufactureCost = gmanufactureCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitManufactureCost.signum());
                this.manufactureCostMap.put(eid, new BigDecimal[]{gmanufactureCost.abs().multiply(sign).multiply(priceSignum), unitManufactureCost});
            }
            if ((gresource = this.billGroupMap.get(costAccountKey + "|" + "resource")) != null) {
                resource = gresource;
                isGroup = true;
                BigDecimal unitResource = gresource.multiply(queueSign).divide(billQty, pricePrecision, 4);
                BigDecimal priceSignum = new BigDecimal(unitResource.signum());
                this.resourceMap.put(eid, new BigDecimal[]{gresource.abs().multiply(sign).multiply(priceSignum), unitResource});
            }
            if (isGroup) {
                actualCost = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource);
            }
        }
        if (actualCost != null) {
            unitCost = actualCost.multiply(queueSign).divide(billQty, pricePrecision, 4);
            billInfo.addPriceType(GROUP_PRICE);
        }
        return new BigDecimal[]{actualCost, unitCost};
    }

    private String checkBillInfo(BillInfo billInfo) {
        if ("0".equals(this.opType)) {
            return null;
        }
        if (this.zeroInOutBizTypeIds.contains(billInfo.getBiztypeId()) && billInfo.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        if (billInfo.getPrice().compareTo(BigDecimal.ZERO) <= 0 && !billInfo.getPriceTypes().contains(GROUP_PRICE)) {
            StringBuilder msg = new StringBuilder();
            if ("1".equals(billInfo.getQueueType()) && !billInfo.isPresent() && !billInfo.isIgnoreZeroCost()) {
                msg.append(ResManager.loadKDString((String)"\u975e\u8d60\u54c1\u884c\u5165\u5e93\u5355\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u786e\u8ba4\u3002\u5efa\u8bae\u901a\u8fc7\u5355\u636e\u5f55\u5165\u5355\u4ef7\u91d1\u989d\u6216\u8005\u901a\u8fc7\u6838\u7b97\u914d\u7f6e-\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u5355\u636e\u540c\u6b65\u53d6\u4ef7\uff0c\u6216\u8005\u91c7\u7528\u975e\u5373\u65f6\u6838\u7b97\u7b97\u6cd5\uff1a%3$s\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"FIFOCalculate_14", (String)"fi-cal-business", (Object[])new Object[0]));
            } else if ("0".equals(billInfo.getQueueType()) && !billInfo.isIgnoreZeroCost()) {
                msg.append(ResManager.loadKDString((String)"\u5355\u4f4d\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u5355\u4ef7\u5f02\u5e38\uff0c\u6838\u7b97\u4e2d\u6b62\uff0c\u8bf7\u6838\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u53ca\u5355\u636e\uff0c\u786e\u4fdd\u6838\u7b97\u5355\u636e\u6570\u91cf\u91d1\u989d\u6b63\u786e\uff1a%3$s\u7269\u6599\u3010%1$s\uff08%2$s\uff09\u3011", (String)"FIFOCalculate_15", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            if ("0".equals(billInfo.getQueueType()) && billInfo.isIgnoreZeroCost()) {
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
                Long billEntryId = billInfo.getBillEntryId();
                if (billInfo.isInvTxZeroCost()) {
                    sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated(), billEntryId});
                    billInfo.setCostpricesource(CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                } else {
                    sqlParams.add(new Object[]{CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue()), CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getDesignated(), billEntryId});
                    billInfo.setCostpricesource(CostPriceSourceTypeEnum.getValueStrBySourceValue((String)CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue()));
                }
                if (sqlParams.size() > 0) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostPriceSourceTypeEnum.getCostpriceSourceSql(), sqlParams);
                }
            }
            if (msg.length() > 0) {
                String costAcctName = this.getCostAcctIdNameMap().get(billInfo.getCostAccountId());
                String costAcctNameMsg = "";
                if (StringUtils.isNotEmpty((String)costAcctName)) {
                    costAcctNameMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011", (String)"CalMoveAddAverageNewProcess_3", (String)"fi-cal-business", (Object[])new Object[0]);
                    costAcctNameMsg = String.format(costAcctNameMsg, costAcctName);
                }
                return String.format(msg.toString(), billInfo.getMaterialNum(), billInfo.getMaterialName(), costAcctNameMsg);
            }
        }
        return null;
    }

    private String getRptKey(String key) {
        String rptkey = key.substring(0, key.lastIndexOf(44));
        rptkey = rptkey.substring(0, rptkey.lastIndexOf(44));
        return rptkey;
    }

    private boolean isDetail(String key) {
        String[] keys = key.split(",");
        String subElementId = keys[keys.length - 1];
        return !"-1".equals(subElementId);
    }

    private String getEntryAndDetailKey(BillInfo billInfo) {
        String key = billInfo.getBillEntryId() + "#" + billInfo.getDetailId();
        return key;
    }

    private BillInfo buildBillInfo(Row row, String key) {
        BillInfo info = new BillInfo();
        info.setAmtPrecision(row.getInteger("amtprecision"));
        info.setBaseUnitId(row.getLong("baseunit"));
        info.setBillId(row.getLong("billid"));
        if ("cal_costrecord_subentity".equals(this.entityName) || "cal_costrecord".equals(this.entityName)) {
            info.setBizbillId(row.getLong("bizbillid"));
        }
        info.setKey(key);
        info.setBillEntryId(row.getLong("eid"));
        info.setDetailId(row.getLong("entryid"));
        String billTypeName = row.getString("billtypename");
        String invbillnum = row.getString("invbillnum");
        if (StringUtils.isNotEmpty((String)invbillnum)) {
            billTypeName = String.format(ResManager.loadKDString((String)"%1$s(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%2$s)", (String)"MoveAddAverageCalculate_13", (String)"fi-cal-business", (Object[])new Object[0]), billTypeName, invbillnum);
        }
        if ("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) {
            String createType = CostAdjustBilCreateTypeEnum.getEnumDesc((String)row.getString("createtype"));
            if (!StringUtils.isEmpty((String)createType)) {
                info.setCostpricesource(createType);
            }
        } else if ("cal_costrecord_subentity".equals(this.entityName) || "cal_costrecord".equals(this.entityName)) {
            info.setCostpricesource(row.getString("costpricesource"));
        }
        if ("cal_costrecord".equals(this.entityName)) {
            info.setBiztypeId(row.getLong("biztype"));
        }
        info.setBillTypeName(billTypeName);
        info.setBillTypeNum(row.getString("billtypenumber"));
        info.setCalEntryId(row.getLong("calentryid"));
        BigDecimal signnum = BigDecimal.valueOf(row.getInteger("signnum").intValue());
        info.setSignnum(signnum);
        info.setCost(row.getBigDecimal("billcost").multiply(signnum));
        info.setCostElementId(Long.parseLong(row.getString("costelement")));
        info.setCostSubElementId(Long.parseLong(row.getString("costsubelement")));
        info.setCurrencyId(row.getLong("currency"));
        info.setDisplayPricePrecision(row.getInteger("displaypricepc"));
        info.setMaterialId(row.getLong("material"));
        info.setPrice(row.getBigDecimal("unitactualcost"));
        info.setPricePrecision(row.getInteger("priceprecision"));
        info.setQty(row.getBigDecimal("billqty").multiply(signnum));
        info.setQtyPrecision(row.getInteger("qtyprecision"));
        info.setPresent(row.getBoolean("ispresent"));
        info.setQueueType(row.getString("type"));
        info.setCostAccountId(row.getLong("costaccount"));
        info.setBillNo(row.getString("billno"));
        info.setCalOrgId(row.getLong("calorgid"));
        info.setMaterialName(row.getString("materialname"));
        info.setMaterialNum(row.getString("materialnum"));
        info.setBizDate(row.getDate("bizdate"));
        info.setAuditDate(row.getDate("auditdate"));
        info.setFee(row.getBigDecimal("fee").multiply(signnum));
        info.setProcessCost(row.getBigDecimal("processcost").multiply(signnum));
        info.setManufactureCost(row.getBigDecimal("manufacturecost").multiply(signnum));
        info.setResource(row.getBigDecimal("resource").multiply(signnum));
        info.setMaterialCost(row.getBigDecimal("materialcost").multiply(signnum));
        info.setBizEntityObject(row.getString("bizentityobject"));
        info.setInvTxZeroCost(row.getBoolean("zerocost"));
        return info;
    }

    private void writeCostRecordEntry() {
        List updateDbParams;
        BigDecimal[] costs;
        String[] keys;
        String key;
        if (!this.recordMap.isEmpty()) {
            String recordUpateSql = "update t_cal_costrecord_detail set factualcost = ?,funitactualcost = ? where fentryid = ? and fcostsubelementid = ?";
            ArrayList<Object[]> recordList = new ArrayList<Object[]>(this.recordMap.size());
            for (Map.Entry<String, BigDecimal[]> entry : this.recordMap.entrySet()) {
                key = entry.getKey();
                keys = key.split("\\|");
                costs = entry.getValue();
                Long entryId = Long.valueOf(keys[0]);
                Long subElementId = Long.valueOf(keys[1]);
                BigDecimal actualCost = costs[0];
                BigDecimal unitCost = costs[1];
                Object[] param = new Object[]{actualCost, unitCost, entryId, subElementId};
                recordList.add(param);
            }
            if (!recordList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)recordUpateSql, recordList);
            }
        }
        if (!this.costRecordEntrySet.isEmpty()) {
            if (!this.byElementCostRecordEntrySet.isEmpty()) {
                CostElementHelper.calCostRecordAllCost((Long[])this.byElementCostRecordEntrySet.toArray(new Long[0]));
            }
            if (!this.noneElementCostRecordEntrySet.isEmpty()) {
                Object[] param;
                Serializable paramList;
                String sql;
                if (!this.recordMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set factualcost = ? ,funitactualcost = ? where fentryid = ?";
                    paramList = new ArrayList(this.recordMap.size());
                    for (Map.Entry<String, BigDecimal[]> entry : this.recordMap.entrySet()) {
                        key = entry.getKey();
                        keys = key.split("\\|");
                        Long entryId = Long.valueOf(keys[0]);
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        BigDecimal[] costs2 = entry.getValue();
                        Object[] param2 = new Object[]{costs2[0], costs2[1], entryId};
                        paramList.add(param2);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.materialCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fmaterialcost = ? ,funitmaterialcost = ? where fentryid = ?";
                    paramList = new ArrayList(this.materialCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.materialCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.feeMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set ffee = ? ,funitfee = ? where fentryid = ?";
                    paramList = new ArrayList(this.feeMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.feeMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.processCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fprocesscost = ? ,funitprocesscost = ? where fentryid = ?";
                    paramList = new ArrayList(this.processCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.processCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.manufactureCostMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fmanufacturecost = ? ,funitmanufacturecost = ? where fentryid = ?";
                    paramList = new ArrayList(this.manufactureCostMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.manufactureCostMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                if (!this.resourceMap.isEmpty()) {
                    sql = "update t_cal_calcostrecordentry set fresource = ? ,funitresource = ? where fentryid = ?";
                    paramList = new ArrayList(this.resourceMap.size());
                    for (Map.Entry<Object, BigDecimal[]> entry : this.resourceMap.entrySet()) {
                        long entryId = (Long)entry.getKey();
                        if (this.byElementCostRecordEntrySet.contains(entryId)) continue;
                        costs = entry.getValue();
                        param = new Object[]{costs[0], costs[1], entryId};
                        paramList.add(param);
                    }
                    if (!paramList.isEmpty()) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                    }
                }
                ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, (Object)this.billIds)});
                paramList = null;
                try {
                    ctx.set();
                    CostElementHelper.calCostRecordMaterialCost((Long[])this.costRecordEntrySet.toArray(new Long[0]));
                }
                catch (Throwable throwable) {
                    paramList = throwable;
                    throw throwable;
                }
                finally {
                    if (ctx != null) {
                        if (paramList != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)paramList).addSuppressed(throwable);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
            }
        }
        if (this.updateCostPricesParams.size() > 0 && (updateDbParams = CostPriceSourceTypeHelper.getUpdateCostPriceSourceParams(this.updateCostPricesParams)) != null && updateDbParams.size() > 0) {
            String updatecostrecordentrysql = " update t_cal_calcostrecordentry set fcostpricesource = ?,fdesignatedcost = ? where fentryid = ?";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updatecostrecordentrysql, (List)updateDbParams);
        }
    }

    private void writeIsCal(Set<Long> entryIdSet) {
        if (entryIdSet.isEmpty() || "0".equals(this.opType)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (long entryId : entryIdSet) {
            sb.append(entryId).append(",");
        }
        String ids = sb.substring(0, sb.length() - 1);
        String sql = "update t_cal_calcostrecordentry set fiscalculated = '1' where fentryid in (" + ids + ")";
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql);
    }

    private void handlePrecision(BillInfo billInfo, int qtyPrecision, int amountPrecision, int pricePrecision) {
        billInfo.setCost(billInfo.getCost().setScale(amountPrecision, 4));
        billInfo.setQty(billInfo.getQty().setScale(qtyPrecision, 4));
        billInfo.setPrice(this.getRecentPrice(billInfo, pricePrecision));
    }

    private BigDecimal getRecentPrice(BillInfo info, int pricePrecision) {
        if (info.getPrice() != null && info.getPrice().compareTo(BigDecimal.ZERO) != 0) {
            return info.getPrice().setScale(pricePrecision, 4);
        }
        if (info.getCost() == null || info.getCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (info.getQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = info.getCost().divide(info.getQty(), pricePrecision, 4);
        return price;
    }

    private void checkRecentCost(RecentCostInfo recentCostInfo, BillInfo billInfo, Map<Long, RecentCostInfo> costAdjustDetailMap) {
        String diffBillType;
        BigDecimal balCost = recentCostInfo.getRecentCost();
        BigDecimal balQty = recentCostInfo.getRecentQty();
        BigDecimal newCost = null;
        if (balQty.signum() == 0 && balCost.signum() != 0) {
            newCost = BigDecimal.ZERO;
        }
        if ("no".equals(diffBillType = this.createDiffbillTypeMap.get(billInfo.getCalOrgId()))) {
            return;
        }
        if (newCost != null) {
            BigDecimal adjustAmt = newCost.subtract(balCost).negate();
            DynamicObject costAdjustInfo = this.costAdjustMap.get(billInfo.getBillEntryId());
            DynamicObject costAdjustEntry = this.costAdjustEntryMap.get(billInfo.getBillEntryId());
            DynamicObject loadBill = this.loadBillMap.get(billInfo.getBillId());
            DynamicObject loadEntry = this.loadEntryMap.get(billInfo.getBillEntryId());
            if (costAdjustInfo != null) {
                if (costAdjustEntry == null) {
                    costAdjustEntry = this.createCostAdjustEntry(loadBill, loadEntry, costAdjustInfo);
                    this.costAdjustEntryMap.put(billInfo.getBillEntryId(), costAdjustEntry);
                }
            } else {
                costAdjustInfo = this.createCostAdjustHead(loadBill);
                costAdjustEntry = this.createCostAdjustEntry(loadBill, loadEntry, costAdjustInfo);
                this.costAdjustMap.put(billInfo.getBillEntryId(), costAdjustInfo);
                this.costAdjustEntryMap.put(billInfo.getBillEntryId(), costAdjustEntry);
            }
            DynamicObject detail = this.createCostAdjustDetail(costAdjustEntry, billInfo, adjustAmt);
            costAdjustDetailMap.put(detail.getLong("id"), recentCostInfo);
        }
    }

    private DynamicObject createCostAdjustHead(DynamicObject loadBill) {
        DynamicObject costAdjustInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustInfo.set("cstype", (Object)"bd_customer");
        if ("cal_costrecord".equals(this.entityName) || "cal_initbill".equals(this.entityName)) {
            costAdjustInfo.set("currency", loadBill.get("localcurrency_id"));
        } else {
            costAdjustInfo.set("currency", loadBill.get("currency_id"));
        }
        costAdjustInfo.set("id", (Object)DB.genLongId((String)"t_cal_costadjustbill"));
        costAdjustInfo.set("biztype", (Object)"B");
        costAdjustInfo.set("billstatus", (Object)"B");
        costAdjustInfo.set("difftype", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        costAdjustInfo.set("createtype", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getValue());
        long costaccountId = loadBill.getLong("costaccount_id");
        costAdjustInfo.set("costaccount", (Object)costaccountId);
        costAdjustInfo.set("calorg", (Object)loadBill.getLong("calorg_id"));
        costAdjustInfo.set("billtype", (Object)this.costAdjustOutBillType);
        Date date = TimeServiceHelper.now();
        costAdjustInfo.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustInfo.set("creator_id", (Object)userId);
        costAdjustInfo.set("auditdate", (Object)date);
        costAdjustInfo.set("auditor_id", (Object)userId);
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustInfo, (String)loadBill.getString("calorg_id"));
        costAdjustInfo.set("billno", (Object)number);
        if ("cal_initbill".equals(this.entityName)) {
            costAdjustInfo.set("period", (Object)this.periodMap.get(costaccountId));
            costAdjustInfo.set("bizdate", (Object)this.begindateMap.get(costaccountId));
            costAdjustInfo.set("bookdate", (Object)this.begindateMap.get(costaccountId));
        } else {
            costAdjustInfo.set("bizdate", (Object)loadBill.getDate("bizdate"));
            costAdjustInfo.set("bookdate", (Object)loadBill.getDate("bookdate"));
            costAdjustInfo.set("adminorg_id", (Object)loadBill.getLong("adminorg_id"));
        }
        return costAdjustInfo;
    }

    private DynamicObject createCostAdjustEntry(DynamicObject loadInfo, DynamicObject loadEntry, DynamicObject costAdjustInfo) {
        DynamicObject costAdjustEntry = costAdjustInfo.getDynamicObjectCollection("entryentity").addNew();
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityName);
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        long id = DB.genLongId((String)"t_cal_costadjustbillentry");
        costAdjustEntry.set("id", (Object)id);
        if ("cal_costrecord".equals(this.entityName)) {
            costAdjustEntry.set("storageorgunit", loadInfo.get("storageorgunit_id"));
        } else {
            costAdjustEntry.set("storageorgunit", loadEntry.get("storageorgunit_id"));
        }
        costAdjustEntry.set("material", loadEntry.get("material_id"));
        costAdjustEntry.set("lot", loadEntry.get("lot"));
        costAdjustEntry.set("warehouse", loadEntry.get("warehouse_id"));
        costAdjustEntry.set("location", loadEntry.get("location_id"));
        costAdjustEntry.set("ownertype", (Object)"bos_org");
        costAdjustEntry.set("owner", loadEntry.get("owner_id"));
        costAdjustEntry.set("ecostcenter", loadEntry.get("ecostcenter_id"));
        costAdjustEntry.set("assist", loadEntry.get("assist_id"));
        costAdjustEntry.set("invbilltype", loadInfo.get("billtype_id"));
        costAdjustEntry.set("invbillnum", (Object)loadInfo.getString("billno"));
        costAdjustEntry.set("inventryseq", loadEntry.get("seq"));
        costAdjustEntry.set("invbillid", loadInfo.get("id"));
        String entityObject = "";
        entityObject = this.entityName.equals("cal_costrecord") ? "cal_costrecord_subentity" : (this.entityName.equals("cal_initbill") ? this.entityName : "cal_costadjust_subentity");
        costAdjustEntry.set("invbizentityobject", (Object)entityObject);
        costAdjustEntry.set("invbillentryid", loadEntry.get("id"));
        costAdjustEntry.set("baseunit", loadEntry.get("baseunit_id"));
        costAdjustEntry.set("project", loadEntry.get("project_id"));
        costAdjustEntry.set("invtype", loadEntry.get("invtype_id"));
        costAdjustEntry.set("invstatus", loadEntry.get("invstatus_id"));
        costAdjustEntry.set("mversion", loadEntry.get("mversion_id"));
        costAdjustEntry.set("tracknumber", loadEntry.get("tracknumber"));
        costAdjustEntry.set("configuredcode", loadEntry.get("configuredcode"));
        costAdjustEntry.set("noupdatecalfields", loadEntry.get("noupdatecalfields"));
        costAdjustEntry.set("stocktype", loadEntry.get("stocktype"));
        CommonSettingHelper.setExFieldValue((MainEntityType)costAdjustEntityType, (MainEntityType)billEntityType, (DynamicObject)costAdjustEntry, (DynamicObject)loadEntry);
        return costAdjustEntry;
    }

    private DynamicObject createCostAdjustDetail(DynamicObject costAdjustEntry, BillInfo billInfo, BigDecimal balCost) {
        DynamicObject detailInfo = costAdjustEntry.getDynamicObjectCollection("subentryentity").addNew();
        long id = DB.genLongId((String)"t_cal_costadjust_detail");
        detailInfo.set("id", (Object)id);
        detailInfo.set("sub_material", (Object)billInfo.getMaterialId());
        detailInfo.set("costelement", (Object)billInfo.getCostElementId());
        detailInfo.set("costsubelement", (Object)billInfo.getCostSubElementId());
        detailInfo.set("sub_currency", (Object)billInfo.getCurrencyId());
        detailInfo.set("sub_adjustamt", (Object)balCost);
        costAdjustEntry.set("adjustamt", (Object)costAdjustEntry.getBigDecimal("adjustamt").add(balCost));
        return detailInfo;
    }

    private void addRptEntry(DynamicObject rptInfo, BillInfo billInfo, RecentCostInfo beginInfo, RecentCostInfo endInfo) {
        String costPriceSourceStr;
        boolean isSubEntry;
        long costSubElement = billInfo.getCostSubElementId();
        boolean bl = isSubEntry = costSubElement != -1L;
        if (isSubEntry && billInfo.getCost().compareTo(BigDecimal.ZERO) == 0 && endInfo.getRecentCost().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int displaypricepc = billInfo.getDisplayPricePrecision();
        DynamicObject rptEntry = rptInfo.getDynamicObjectCollection("entryentity").addNew();
        String inStr = this.getInRecentString(billInfo, displaypricepc, isSubEntry);
        String outStr = this.getOutRecentString(billInfo, displaypricepc, isSubEntry);
        String endStr = this.getRecentString(beginInfo, displaypricepc) + "\n" + this.getRecentString(endInfo, displaypricepc);
        String billno = billInfo.getBillNo();
        String billtypenumber = billInfo.getBillTypeNum();
        String billtypename = billInfo.getBillTypeName();
        long billId = billInfo.getBillId();
        long billEntryId = billInfo.getDetailId();
        int seq = rptInfo.getInt("nextSeq");
        long parentId = 0L;
        if (isSubEntry) {
            billno = this.elementNameMap.get(costSubElement);
            if (billno == null) {
                billno = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id,name,number", (QFilter[])new QFilter("id", "=", (Object)costSubElement).toArray()).getString("name");
                this.elementNameMap.put(costSubElement, billno);
            }
            parentId = billInfo.getBillEntryId();
            billtypename = ResManager.loadKDString((String)"\u5b50\u8981\u7d20", (String)"MoveAddAverageCalculate_0", (String)"fi-cal-business", (Object[])new Object[0]);
        }
        Set<String> priceTypes = billInfo.getPriceTypeNames();
        StringBuilder billTypeSb = new StringBuilder();
        if (!priceTypes.isEmpty()) {
            billTypeSb.append('\uff08');
            for (String priceType : priceTypes) {
                billTypeSb.append(priceType);
                billTypeSb.append(',');
            }
            billTypeSb = new StringBuilder(billTypeSb.substring(0, billTypeSb.length() - 1));
            billTypeSb.append('\uff09');
            billtypename = billtypename + billTypeSb;
        }
        if ("0".equals(this.opType)) {
            String msg;
            billtypename = msg = String.format(ResManager.loadKDString((String)"%1$s\uff08\u53cd\u5ba1\u6838\uff09", (String)"FIFOCalculate_13", (String)"fi-cal-business", (Object[])new Object[0]), billtypename);
        }
        if (seq == 0) {
            seq = 1;
        }
        rptEntry.set("seq", (Object)seq);
        rptInfo.set("nextSeq", (Object)(seq + 1));
        rptEntry.set("bizbillid", (Object)billId);
        rptEntry.set("bizbillentryid", (Object)billEntryId);
        rptEntry.set("billnumber", (Object)billno);
        rptEntry.set("billtypenum", (Object)billtypenumber);
        rptEntry.set("billtype", (Object)billtypename);
        rptEntry.set("bizdate", (Object)billInfo.getBizDate());
        rptEntry.set("auditdate", (Object)billInfo.getAuditDate());
        rptEntry.set("instr", (Object)inStr);
        rptEntry.set("outstr", (Object)outStr);
        rptEntry.set("balancestr", (Object)endStr);
        rptEntry.set("parententryid", (Object)parentId);
        String costpricesource = billInfo.getCostpricesource();
        if ("cal_costadjustbill".equals(this.entityName) || "cal_costadjust_subentity".equals(this.entityName)) {
            if (!isSubEntry) {
                rptEntry.set("describe", (Object)costpricesource);
            }
        } else if (!isSubEntry && ("cal_costrecord_subentity".equals(this.entityName) || "cal_costrecord".equals(this.entityName)) && StringUtils.isNotEmpty((String)(costPriceSourceStr = CostPriceSourceTypeEnum.getAllNameByCostPriceSources((String)costpricesource)))) {
            rptEntry.set("describe", (Object)costPriceSourceStr);
        }
    }

    private int addRptEntry4CostAdjust(DynamicObject rptInfo, BillInfo billInfo, RecentCostInfo parentBalInfo, Map<Long, RecentCostInfo> detailBalMap, DynamicObject costAdjustbill, DynamicObject costAdjustEntry) {
        DynamicObject rptEntry = rptInfo.getDynamicObjectCollection("entryentity").addNew();
        int displaypricepc = billInfo.getDisplayPricePrecision();
        int amtPrecision = billInfo.getAmtPrecision();
        int qtyPrecision = billInfo.getQtyPrecision();
        int pricePrecision = billInfo.getPricePrecision();
        int seq = rptInfo.getInt("nextSeq");
        int entryCount = 0;
        if (seq == 0) {
            seq = 1;
        }
        rptEntry.set("seq", (Object)seq);
        rptInfo.set("nextSeq", (Object)(seq + 1));
        rptEntry.set("bizbillid", costAdjustbill.get("id"));
        rptEntry.set("bizbillentryid", costAdjustEntry.get("id"));
        rptEntry.set("billnumber", (Object)costAdjustbill.getString("billno"));
        rptEntry.set("billtypenum", (Object)"cal_costadjustbill");
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"MoveAddAverageCalculate_1", (String)"fi-cal-business", (Object[])new Object[0]);
        String invbillnum = costAdjustEntry.getString("invbillnum");
        if (StringUtils.isNotEmpty((String)invbillnum)) {
            msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"MoveAddAverageCalculate_14", (String)"fi-cal-business", (Object[])new Object[0]), invbillnum);
        }
        rptEntry.set("describe", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getDesc());
        rptEntry.set("billtype", (Object)msg);
        rptEntry.set("bizdate", (Object)costAdjustbill.getDate("bookdate"));
        rptEntry.set("auditdate", (Object)costAdjustbill.getDate("auditdate"));
        StringBuilder str = new StringBuilder();
        str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(displaypricepc, 4).toPlainString()).append(" = ").append(this.toBigDecimalString(costAdjustEntry.getBigDecimal("adjustamt").setScale(amtPrecision, 4)));
        rptEntry.set("outstr", (Object)str.toString());
        String endStr = this.getRecentString(parentBalInfo, displaypricepc) + "\n";
        parentBalInfo.setRecentCost(parentBalInfo.getRecentCost().add(costAdjustEntry.getBigDecimal("adjustamt").negate()));
        this.handlePrecision(parentBalInfo, qtyPrecision, amtPrecision, pricePrecision);
        endStr = endStr + this.getRecentString(parentBalInfo, displaypricepc);
        rptEntry.set("balancestr", (Object)endStr);
        rptEntry.set("parententryid", (Object)0L);
        for (DynamicObject detail : costAdjustEntry.getDynamicObjectCollection("subentryentity")) {
            RecentCostInfo detailBalInfo = detailBalMap.get(detail.getLong("id"));
            if (detail.getBigDecimal("sub_adjustamt").compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject rpt1 = rptInfo.getDynamicObjectCollection("entryentity").addNew();
            ++entryCount;
            long costSubElement = detail.getLong("costsubelement");
            seq = rptInfo.getInt("nextSeq");
            rpt1.set("seq", (Object)seq);
            rptInfo.set("nextSeq", (Object)(seq + 1));
            rpt1.set("bizbillid", costAdjustbill.get("id"));
            rpt1.set("bizbillentryid", detail.get("id"));
            rpt1.set("billnumber", (Object)QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id,name,number", (QFilter[])new QFilter("id", "=", (Object)costSubElement).toArray()).getString("name"));
            rpt1.set("billtypenum", (Object)"cal_costadjustbill");
            String msg1 = ResManager.loadKDString((String)"\u5b50\u8981\u7d20", (String)"MoveAddAverageCalculate_10", (String)"fi-cal-business", (Object[])new Object[0]);
            rpt1.set("billtype", (Object)msg1);
            rpt1.set("bizdate", (Object)costAdjustbill.getDate("bookdate"));
            rpt1.set("auditdate", (Object)costAdjustbill.getDate("auditdate"));
            str.setLength(0);
            str.append(BigDecimal.ZERO.setScale(qtyPrecision, 4).toPlainString()).append(" * ").append(BigDecimal.ZERO.setScale(displaypricepc, 4).toPlainString()).append(" = ").append(detail.getBigDecimal("sub_adjustamt").setScale(amtPrecision, 4).toPlainString());
            rpt1.set("outstr", (Object)str.toString());
            endStr = this.getRecentString(detailBalInfo, displaypricepc) + "\n";
            detailBalInfo.setRecentCost(detailBalInfo.getRecentCost().add(detail.getBigDecimal("sub_adjustamt").negate()));
            this.handlePrecision(detailBalInfo, qtyPrecision, amtPrecision, pricePrecision);
            endStr = endStr + this.getRecentString(detailBalInfo, displaypricepc);
            rpt1.set("balancestr", (Object)endStr);
            rpt1.set("parententryid", (Object)costAdjustEntry.getLong("id"));
        }
        return entryCount;
    }

    private String getOutRecentString(BillInfo billInfo, int displaypricepc, boolean isSubEntry) {
        String type = billInfo.getQueueType();
        if ("0".equals(type)) {
            if (isSubEntry) {
                return this.toBigDecimalString(billInfo.getCost());
            }
            return this.toBigDecimalString(billInfo.getQty()) + " * " + this.toBigDecimalString(billInfo.getPrice().setScale(displaypricepc, 4)) + " = " + this.toBigDecimalString(billInfo.getCost());
        }
        return "";
    }

    private String getInRecentString(BillInfo billInfo, int displaypricepc, boolean isSubEntry) {
        String type = billInfo.getQueueType();
        if ("1".equals(type)) {
            if (isSubEntry) {
                return this.toBigDecimalString(billInfo.getCost());
            }
            return this.toBigDecimalString(billInfo.getQty()) + " * " + this.toBigDecimalString(billInfo.getPrice().setScale(displaypricepc, 4)) + " = " + this.toBigDecimalString(billInfo.getCost());
        }
        return "";
    }

    private void handlePrecision(RecentCostInfo info, int qtyPrecision, int amountPrecision, int pricePrecision) {
        if (info == null) {
            return;
        }
        info.setRecentCost(info.getRecentCost().setScale(amountPrecision, 4));
        info.setRecentQty(info.getRecentQty().setScale(qtyPrecision, 4));
        info.setRecentPrice(info.getRecentPrice().setScale(pricePrecision, 4));
    }

    private String getRecentString(RecentCostInfo info, int displaypricepc) {
        if (info == null) {
            return "";
        }
        String inStr = this.toBigDecimalString(info.getRecentQty()) + " * " + this.toBigDecimalString(this.getRecentPrice(info, displaypricepc)) + " = " + this.toBigDecimalString(info.getRecentCost());
        return inStr;
    }

    private BigDecimal getRecentPrice(RecentCostInfo info, int pricePrecision) {
        if (info.getRecentCost() == null || info.getRecentCost().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (info.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = info.getRecentCost().divide(info.getRecentQty(), pricePrecision, 4);
        return price;
    }

    private void writeRpt() {
        HashMap<Long, DynamicObject> insertMap = new HashMap<Long, DynamicObject>(this.rptMap.size());
        HashMap updateMap = new HashMap(this.rptMap.size());
        for (Map.Entry<String, DynamicObject> entry : this.rptMap.entrySet()) {
            insertMap.put(entry.getValue().getLong("id"), entry.getValue());
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calculateoutrpt", (String)"id", (QFilter[])new QFilter("id", "in", insertMap.keySet()).toArray(), null);){
            for (Row row : dataSet) {
                updateMap.put(row.getLong("id"), insertMap.get(row.getLong("id")));
                insertMap.remove(row.getLong("id"));
            }
        }
        if (!insertMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])insertMap.values().toArray(new DynamicObject[0]));
        }
        if (!updateMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateMap.values().toArray(new DynamicObject[0]));
        }
    }

    private void writeRptBySql(int entryCounts) {
        ArrayList<Object[]> headParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(this.rptMap.size());
        ArrayList<Object[]> headUpdateParams = new ArrayList<Object[]>(16);
        HashSet<Long> costaccountIds = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        periods.addAll(this.rptIdPeriodDbMap.values());
        IDGenerator entryIdGenerator = new IDGenerator("t_cal_caloutrptentry");
        for (Map.Entry<String, DynamicObject> entry : this.rptMap.entrySet()) {
            DynamicObject caloutRptInfo = entry.getValue();
            DynamicObjectCollection rptEntryInfos = caloutRptInfo.getDynamicObjectCollection("entryentity");
            Long id = caloutRptInfo.getLong("id");
            int nextSeq = 0;
            for (DynamicObject rptEntryInfo : rptEntryInfos) {
                costaccountIds.add(caloutRptInfo.getLong("costaccount"));
                periods.add(caloutRptInfo.getLong("period"));
                Object[] entryParam = new Object[15];
                entryParam[0] = id;
                entryParam[1] = entryIdGenerator.getId();
                nextSeq = rptEntryInfo.getInt("seq");
                entryParam[2] = nextSeq;
                entryParam[3] = rptEntryInfo.getLong("bizbillid");
                entryParam[4] = rptEntryInfo.getLong("bizbillentryid");
                entryParam[5] = rptEntryInfo.getString("billtypenum");
                entryParam[6] = rptEntryInfo.getString("billtype");
                entryParam[7] = rptEntryInfo.getString("billnumber");
                entryParam[8] = rptEntryInfo.getString("instr");
                entryParam[9] = rptEntryInfo.getString("outstr");
                entryParam[10] = rptEntryInfo.getString("balancestr");
                entryParam[11] = rptEntryInfo.getLong("parententryid");
                Date bizDate = rptEntryInfo.getDate("bizdate");
                entryParam[12] = new Timestamp(bizDate.getTime());
                Date auditDate = rptEntryInfo.getDate("auditdate");
                entryParam[13] = new Timestamp(auditDate.getTime());
                entryParam[14] = rptEntryInfo.getString("describe");
                entryParams.add(entryParam);
            }
            if (!entry.getValue().getDataEntityState().getFromDatabase()) {
                Object[] headParam = new Object[]{id, caloutRptInfo.getLong("costaccount"), caloutRptInfo.getLong("dividebasis"), caloutRptInfo.getLong("caldimension"), caloutRptInfo.getString("dividebasisvalue"), caloutRptInfo.getString("caldimensionValue"), caloutRptInfo.getLong("material"), caloutRptInfo.getString("accounttype"), caloutRptInfo.getLong("period"), caloutRptInfo.getDate("caltime"), caloutRptInfo.getString("calstatus"), nextSeq + 1, caloutRptInfo.getLong("calorg"), caloutRptInfo.getLong("calrange"), caloutRptInfo.getLong("operationuser"), caloutRptInfo.getLong("assist"), caloutRptInfo.getLong("configuredcode"), caloutRptInfo.getLong("project"), caloutRptInfo.getLong("tracknumber")};
                headParams.add(headParam);
                continue;
            }
            Object[] headUpdateParam = new Object[]{nextSeq + 1, new Timestamp(TimeServiceHelper.now().getTime()), caloutRptInfo.getLong("assist"), caloutRptInfo.getLong("configuredcode"), caloutRptInfo.getLong("project"), caloutRptInfo.getLong("tracknumber"), id};
            headUpdateParams.add(headUpdateParam);
        }
        DBRoute dbRoute = new DBRoute("cal");
        if (!headParams.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, headParams);
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_caloutrpt", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("FCOSTACCOUNTID", FilterType.in_range, costaccountIds), new ShardingHintContext.ShardingHintCondition("FPERIODID", FilterType.in_range, periods)});){
            ctx.set();
            if (!entryParams.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertEntrySql, entryParams);
            }
        }
        if (!headUpdateParams.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, headUpdateParams);
        }
    }

    private void cacheMap(DataSet dataSet, String[] onFields, Map<String, RecentCostInfo> costMap, Set<String> insertSet, Map<String, Long> costIdMap, Map<Long, RecentCostInfo> detailRecentCostMap, Map<Long, String> detailKeyMap, Map<Long, List<BillInfo>> dataMap, List<Long> entryIdList) {
        for (Row row : dataSet) {
            String key = this.getGroupKey(row, onFields, true);
            String parentKey = this.getGroupKey(row, onFields, false);
            RecentCostInfo recentCostInfo = costMap.get(key);
            if (recentCostInfo == null) {
                recentCostInfo = new RecentCostInfo();
                BigDecimal qty = row.get("recentqty") == null ? BigDecimal.ZERO : row.getBigDecimal("recentqty");
                BigDecimal cost = row.get("recentcost") == null ? BigDecimal.ZERO : row.getBigDecimal("recentcost");
                BigDecimal price = row.get("price") == null ? BigDecimal.ZERO : row.getBigDecimal("price");
                long recentcostid = row.get("recentcostid") == null ? 0L : row.getLong("recentcostid");
                recentCostInfo.setId(recentcostid);
                recentCostInfo.setRecentQty(qty);
                recentCostInfo.setRecentCost(cost);
                recentCostInfo.setRecentPrice(price);
                recentCostInfo.setPriceUpdateTime(row.getDate("priceupdatetime"));
                if (recentcostid == 0L) {
                    insertSet.add(key);
                } else {
                    costIdMap.put(key, recentcostid);
                }
                costMap.put(key, recentCostInfo);
            }
            BillInfo billInfo = this.buildBillInfo(row, parentKey);
            detailKeyMap.put(billInfo.getDetailId(), key);
            detailRecentCostMap.put(billInfo.getDetailId(), recentCostInfo);
            long entryId = billInfo.getBillEntryId();
            if (!entryIdList.contains(entryId)) {
                entryIdList.add(entryId);
            }
            this.entryInvOrgIdMap.put(entryId, row.getLong("storageorgunit"));
            List<BillInfo> list = dataMap.get(entryId);
            if (list != null) {
                list.add(billInfo);
                continue;
            }
            list = new ArrayList<BillInfo>();
            list.add(billInfo);
            dataMap.put(entryId, list);
        }
    }

    private void writeRecentCost(Map<String, RecentCostInfo> costMap, Set<String> insertSet, Map<String, Long> costIdMap, String[] onFields) {
        for (Map.Entry<String, RecentCostInfo> entry : costMap.entrySet()) {
            String key = entry.getKey();
            RecentCostInfo info = entry.getValue();
            String rptkey = key.substring(0, key.lastIndexOf(44));
            rptkey = rptkey.substring(0, rptkey.lastIndexOf(44));
            DynamicObject rptInfo = this.rptMap.get(rptkey);
            if (insertSet.contains(key)) {
                DynamicObject recentCostInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_recentcost");
                String[] value = key.split(",");
                long costAccount = Long.parseLong(value[0]);
                long currency = Long.parseLong(value[1]);
                long baseUnit = Long.parseLong(value[2]);
                long material = Long.parseLong(value[3]);
                recentCostInfo.set("costaccount", (Object)costAccount);
                recentCostInfo.set("currency", (Object)currency);
                recentCostInfo.set("baseunit", (Object)baseUnit);
                recentCostInfo.set("material", (Object)material);
                for (int i = 0; i < onFields.length; ++i) {
                    recentCostInfo.set(onFields[i], (Object)value[i + 4]);
                }
                long costElement = Long.parseLong(recentCostInfo.get("costelement").toString());
                if (costElement == -1L) continue;
                recentCostInfo.set("recentqty", (Object)info.getRecentQty());
                recentCostInfo.set("recentcost", (Object)info.getRecentCost());
                recentCostInfo.set("calrptid", (Object)rptInfo.getLong("id"));
                if (info.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && BigDecimal.ZERO.compareTo(info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP)) < 0) {
                    recentCostInfo.set("price", (Object)info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP));
                    recentCostInfo.set("priceupdatetime", (Object)TimeServiceHelper.now());
                }
                this.insertRecentCost.add(recentCostInfo);
                continue;
            }
            long recentCostId = costIdMap.get(key);
            if (recentCostId == -1L) continue;
            if (info.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && BigDecimal.ZERO.compareTo(info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP)) < 0) {
                Object[] paramPrice = new Object[]{info.getRecentCost(), info.getRecentQty(), rptInfo.getLong("id"), info.getRecentCost().divide(info.getRecentQty(), 10, RoundingMode.HALF_UP), new Timestamp(TimeServiceHelper.now().getTime()), recentCostId};
                this.updateRecentCostList.add(paramPrice);
                continue;
            }
            Timestamp timestamp = info.getPriceUpdateTime() == null ? null : new Timestamp(info.getPriceUpdateTime().getTime());
            Object[] param = new Object[]{info.getRecentCost(), info.getRecentQty(), rptInfo.getLong("id"), info.getRecentPrice(), timestamp, recentCostId};
            this.updateRecentCostList.add(param);
        }
    }

    private BigDecimal fetchCostByRecentCost(int pricePrecision, int amountPrecision, RecentCostInfo recentCostInfo) {
        if (recentCostInfo.getRecentQty() == null && recentCostInfo.getRecentCost() == null) {
            recentCostInfo.setHasRecentCost(false);
        } else {
            recentCostInfo.setHasRecentCost(true);
        }
        BigDecimal unitCost = recentCostInfo.getRecentQty() == null || recentCostInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : recentCostInfo.getRecentCost().divide(recentCostInfo.getRecentQty(), pricePrecision, 4);
        return unitCost;
    }

    private String getGroupKey(Row row, String[] onFields, boolean hasCostElement) {
        StringBuilder key = new StringBuilder();
        long costAccount = row.getLong("costaccount");
        long currecy = row.getLong("currency");
        long baseUnit = row.getLong("baseunit");
        long material = row.getLong("material");
        key.append(costAccount).append(',');
        key.append(currecy).append(',');
        key.append(baseUnit).append(',');
        key.append(material).append(',');
        for (String field : onFields) {
            Object value = row.get(field);
            if ("".equals(value)) {
                value = " ";
            }
            if ("costelement".equals(field) || "costsubelement".equals(field)) {
                if (!hasCostElement) continue;
                key.append(value).append(',');
                continue;
            }
            key.append(value).append(',');
        }
        return key.substring(0, key.length() - 1);
    }

    private DataSet getBillDataSet(Long[] billIds, String entityName) {
        if ("cal_costrecord".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entry.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            q.and("isinitbill", "=", (Object)Boolean.FALSE);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            q.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
            q.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
            if (this.billEntryIds != null) {
                q.and("entry.id", "in", (Object)this.billEntryIds);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getCostRecordSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getCostAdjustSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        if ("cal_balance".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBalanceSelects(), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"id,balid,to_char(costelement) as costelement,to_char(costsubelement) as costsubelement,periodendqty as billqty,periodendactualcost as billcost", (QFilter[])new QFilter("balid", "in", (Object)billIds).toArray(), null);
            DataSet groupDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"id,balid,periodendqty as billqty,periodendactualcost as billcost,costelement,costsubelement", (QFilter[])new QFilter("balid", "in", (Object)billIds).toArray(), null).groupBy(new String[]{"balid"}).max("billqty").sum("billcost").finish().select("balid,billqty,billcost,'-1' as costelement,'-1' as costsubelement");
            dataSet = dataSet.copy().join(detailDataSet, JoinType.LEFT).on("billid", "balid").select(this.getInitBalanceAlias().split(","), new String[]{"id as entryid", "balid as eid", "costelement", "costsubelement", "billqty", "billcost"}).finish().union(dataSet.copy().join(groupDataSet, JoinType.LEFT).on("billid", "balid").select(this.getInitBalanceAlias().split(","), new String[]{"balid as entryid", "balid as eid", "costelement", "costsubelement", "billqty", "billcost"}).finish());
            q.and("accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_calrange", (String)"id as balId,caldimension as caldimension,caldimension.caldimension as caldimensionstr,calrange as calrange,1 as entryseq,1 as signnum,'1' as zerocost,' ' as costpricesource,'' as invbillnum", (QFilter[])q.toArray(), null);
            return dataSet.join(balDataSet, JoinType.INNER).on("billid", "balId").select(this.getAliasSelects().split(",")).finish();
        }
        if ("cal_initbill".equals(entityName)) {
            QFilter q = new QFilter("id", "in", (Object)billIds);
            q.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
            QFilter q1 = new QFilter("entryentity.baseqty", "!=", (Object)0);
            q1.or("entryentity.amount", "!=", (Object)0);
            q.and(q1);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBillSelects(false), (QFilter[])q.toArray(), null);
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getInitBillSelects(true), (QFilter[])q.toArray(), null);
            return dataSet.union(detailDataSet);
        }
        RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", this.getCostRecordSelects(false));
        DataSet emptyDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        return emptyDs;
    }

    private String getCostRecordSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        String entryName = "entry";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        selects.append("id as billid,bizbillid,billno as billno,billtype.number as billtypenumber,billtype.name as billtypename,bookdate as bizdate,costaccount,costaccount.calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entry.caldimension as caldimension,entry.caldimension.caldimension as caldimensionstr,auditdate,entry.seq as entryseq,'0' as createtype,");
        selects.append("entry.baseqty as billqty,entry.material as material,entry.material.name as materialname,entry.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,");
        selects.append("entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,entry.calrange as calrange,entry.calentryid as calentryid,entry.queuetype as queuetype,bizentityobject.number as bizentityobject,period as period,entry.ispresent as ispresent");
        selects.append(",entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource,entry.materialcost as materialcost,entry.signnum as signnum,biztype,entry.costpricesource as costpricesource,'' as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entry.subentrycostelement.costelement) as costelement,to_char(entry.subentrycostelement.costsubelement) as costsubelement,entry.subentrycostelement.sub_actualcost as billcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost,entry.subentrycostelement.id as entryid,entry.id as eid,invscheme.zerocost as zerocost");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entry.actualcost as billcost,entry.unitactualcost as unitactualcost,entry.id as entryid,entry.id as eid,invscheme.zerocost as zerocost");
        }
        return selects.toString();
    }

    private String getCostAdjustSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"MoveAddAverageCalculate_1", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,billno as billno,'cal_costadjustbill' as billtypenumber,'").append(s).append("' as billtypename,entryentity.invbizdate as bizdate,costaccount,costaccount.calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,entryentity.seq as entryseq,createtype,");
        selects.append("0 as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,currency as currency,10 as priceprecision,currency.amtprecision as amtprecision,currency.priceprecision as displaypricepc,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,entryentity.queuetype as queuetype,'cal_costadjustbill' as bizentityobject,0 as unitactualcost,0 as period,'0' as ispresent");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,entryentity.signnum as signnum,' ' as costpricesource,entryentity.invbillnum as invbillnum");
        if (isDetail) {
            selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_adjustamt as billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.adjustamt as billcost,entryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
        }
        return selects.toString();
    }

    private String getInitBalanceSelects() {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        for (String field : fields = this.totalKey.split(",")) {
            selects.append(field).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u4f59\u989d\u521d\u59cb\u5316", (String)"MoveAddAverageCalculate_2", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,' ' as billno,'cal_balance' as billtypenumber,'").append(s).append("' as billtypename,null as bizdate,costaccount,costaccount.calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,'0' as createtype,");
        selects.append("null as auditdate,material as material,material.name as materialname,material.number as materialnum,calpolicy.currency as currency,10 as priceprecision,calpolicy.currency.amtprecision as amtprecision,calpolicy.currency.priceprecision as displaypricepc,");
        selects.append("baseunit as baseunit,baseunit.precision as qtyprecision,0 as calentryid,'cal_balance' as bizentityobject,0 as unitactualcost,0 as period,'0' as ispresent");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost");
        return selects.toString();
    }

    private String getInitBillSelects(boolean isDetail) {
        String[] fields;
        StringBuilder selects = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        String entryName = "entryentity";
        for (String field : fields = this.totalKey.split(",")) {
            IDataEntityProperty p = entityType.findProperty(field);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(field).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(field).append(" as ").append(field).append(',');
        }
        String s = ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355", (String)"MoveAddAverageCalculate_5", (String)"fi-cal-business", (Object[])new Object[0]);
        selects.append("id as billid,billno,'cal_initbill' as billtypenumber,'").append(s).append("' as billtypename,bookdate as bizdate,costaccount,calorg as calorgid,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,");
        selects.append("entryentity.caldimension as caldimension,entryentity.caldimension.caldimension as caldimensionstr,auditdate,entryentity.seq as entryseq,'0' as createtype,");
        selects.append("entryentity.baseqty as billqty,entryentity.material as material,entryentity.material.name as materialname,entryentity.material.number as materialnum,localcurrency as currency,10 as priceprecision,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as displaypricepc,");
        selects.append("entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,entryentity.calrange as calrange,0 as calentryid,'0' as queuetype,'cal_initbill' as bizentityobject,0 as unitactualcost,period,'0' as ispresent");
        selects.append(",0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as materialcost,1 as signnum,' ' as costpricesource,'' as invbillnum");
        if (isDetail) {
            if (this.enableStd) {
                selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_amount+entryentity.subentryentity.sub_costdiff as billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
            } else {
                selects.append(",to_char(entryentity.subentryentity.costelement) as costelement,to_char(entryentity.subentryentity.costsubelement) as costsubelement,entryentity.subentryentity.sub_amount as billcost,entryentity.subentryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
            }
        } else if (this.enableStd) {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.amount+entryentity.costdiff as billcost,entryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
        } else {
            selects.append(",'-1' as costelement,'-1' as costsubelement,entryentity.amount as billcost,entryentity.id as entryid,entryentity.id as eid,'0' as zerocost");
        }
        return selects.toString();
    }

    private String getInitBalanceAlias() {
        StringBuilder selects = new StringBuilder();
        selects.append(this.totalKey);
        selects.append(",billid,billno,billtypenumber,billtypename,bizdate,costaccount,calorgid,dividebasis,dividebasisstr,createtype,");
        selects.append("auditdate,material,materialname,materialnum,currency,priceprecision,amtprecision,displaypricepc,");
        selects.append("baseunit,qtyprecision,calentryid,bizentityobject,unitactualcost,period,ispresent");
        selects.append(",fee,processcost,manufacturecost,resource,materialcost,' ' as costpricesource");
        return selects.toString();
    }

    private String getAliasSelects() {
        StringBuilder selects = new StringBuilder();
        selects.append(this.totalKey);
        selects.append(",billid,bizbillid,billno,billtypenumber,billtypename,bizdate,costaccount,calorgid,entryid,dividebasis,dividebasisstr,createtype,");
        selects.append("caldimension,caldimensionstr,auditdate,period,ispresent,entryseq,materialname,materialnum,");
        selects.append("fee,processcost,manufacturecost,resource,materialcost,signnum,");
        selects.append("billqty,billcost,material,currency,priceprecision,amtprecision,displaypricepc,baseunit,qtyprecision,calrange,calentryid,bizentityobject,unitactualcost,costelement,costsubelement,eid,zerocost,costpricesource,invbillnum");
        if ("cal_costrecord".equals(this.entityName)) {
            selects.append(",biztype");
        }
        return selects.toString();
    }

    private int getCurrSeq(DynamicObject rptInfoDyc) {
        boolean isFromDataBase;
        long calRptId = rptInfoDyc.getLong("id");
        int nextSeq = rptInfoDyc.getInt("nextSeq");
        boolean bl = isFromDataBase = calRptId != 0L && rptInfoDyc.getDataEntityState().getFromDatabase();
        if (isFromDataBase && nextSeq <= 1) {
            Integer nextSeqDb = this.rptIdNextSeqDbMap.get(calRptId);
            if (nextSeqDb != null) {
                nextSeq = nextSeqDb;
            } else {
                rptInfoDyc.set("id", (Object)DB.genLongId((String)"t_cal_caloutrpt"));
                rptInfoDyc.getDataEntityState().setFromDatabase(false);
            }
        }
        if (nextSeq <= 1) {
            nextSeq = 1;
        }
        rptInfoDyc.set("nextSeq", (Object)nextSeq);
        return nextSeq;
    }

    public void setCostAcctIdNameMap(Map<Long, String> costAcctIdNameMap) {
        this.costAcctIdNameMap = costAcctIdNameMap;
    }

    public Map<Long, String> getCostAcctIdNameMap() {
        return this.costAcctIdNameMap;
    }

    public void setBillCostPriceMap4ZeroPrice(Map<Long, CostPriceResultInfo> billCostPriceMap4ZeroPrice) {
        this.billCostPriceMap4ZeroPrice = billCostPriceMap4ZeroPrice;
    }

    public Map<Long, CostPriceResultInfo> getBillCostPriceMap4ZeroPrice() {
        return this.billCostPriceMap4ZeroPrice;
    }

    public Map<Long, CostPriceResultInfo> getBillCostPriceMap4NegativePrice() {
        return this.billCostPriceMap4NegativePrice;
    }

    public void setBillCostPriceMap4NegativePrice(Map<Long, CostPriceResultInfo> billCostPriceMap4NegativePrice) {
        this.billCostPriceMap4NegativePrice = billCostPriceMap4NegativePrice;
    }

    public Map<Long, CostPriceResultInfo> getBillCostPriceMap4NegativeQty() {
        return this.billCostPriceMap4NegativeQty;
    }

    public void setBillCostPriceMap4NegativeQty(Map<Long, CostPriceResultInfo> billCostPriceMap4NegativeQty) {
        this.billCostPriceMap4NegativeQty = billCostPriceMap4NegativeQty;
    }

    public void setPreCal(boolean preCal) {
        this.preCal = preCal;
    }

    public void setBizBillEntity(String bizBillEntity) {
        this.bizBillEntity = bizBillEntity;
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    public void putGroupCost(Map<String, BigDecimal> groupCost) {
        this.billGroupMap.putAll(groupCost);
    }

    public Map<String, BigDecimal> getBillGroupMap() {
        return this.billGroupMap;
    }

    private void cacheCostAcctIdNameMap(Set<Long> costAcctIds) {
        QFilter costAcctIdFilter = new QFilter("id", "in", costAcctIds);
        try (DataSet costAcctDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,name", (QFilter[])costAcctIdFilter.toArray(), null);){
            for (Row row : costAcctDs) {
                this.costAcctIdNameMap.put(row.getLong("id"), row.getString("name"));
            }
        }
    }

    public Set<Long> getHasGetZeroPriceEntryIds() {
        return this.hasGetZeroPriceEntryIds;
    }

    public void setHasGetZeroPriceEntryIds(Set<Long> hasGetZeroPriceEntryIds) {
        this.hasGetZeroPriceEntryIds = hasGetZeroPriceEntryIds;
    }

    public Set<Long> getHasGetNegPriceEntryIds() {
        return this.hasGetNegPriceEntryIds;
    }

    public void setHasGetNegPriceEntryIds(Set<Long> hasGetNegPriceEntryIds) {
        this.hasGetNegPriceEntryIds = hasGetNegPriceEntryIds;
    }

    private static class BillInfo {
        private long billId;
        private long bizbillId;
        private String key;
        private long billEntryId;
        private String billNo;
        private long costAccountId;
        private long calOrgId;
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal cost = BigDecimal.ZERO;
        private BigDecimal price = BigDecimal.ZERO;
        private String queueType;
        private int qtyPrecision;
        private int amtPrecision;
        private int pricePrecision;
        private long currencyId;
        private long baseUnitId;
        private long materialId;
        private String materialName;
        private String materialNum;
        private int displayPricePrecision;
        private String billTypeNum;
        private String billTypeName;
        private BigDecimal signnum = BigDecimal.ONE.stripTrailingZeros();
        private long calEntryId;
        private long detailId;
        private long costElementId;
        private long costSubElementId;
        private boolean present;
        private boolean inventoryTx_ZeroCost;
        private Date bizDate;
        private Date auditDate;
        private BigDecimal materialCost;
        private BigDecimal fee;
        private BigDecimal processCost;
        private BigDecimal manufactureCost;
        private BigDecimal resource;
        private Set<String> priceTypeNames = new HashSet<String>(3);
        private Set<String> priceTypes = new HashSet<String>(16);
        private String bizEntityObject;
        private long biztypeId;
        private boolean ignoreZeroCost;
        private String costpricesource;

        private BillInfo() {
        }

        public long getBiztypeId() {
            return this.biztypeId;
        }

        public void setBiztypeId(long biztypeId) {
            this.biztypeId = biztypeId;
        }

        public String getQueueType() {
            return this.queueType;
        }

        public void setQueueType(String queueType) {
            this.queueType = queueType;
        }

        public int getQtyPrecision() {
            return this.qtyPrecision;
        }

        public void setQtyPrecision(int qtyPrecision) {
            this.qtyPrecision = qtyPrecision;
        }

        public int getAmtPrecision() {
            return this.amtPrecision;
        }

        public void setAmtPrecision(int amtPrecision) {
            this.amtPrecision = amtPrecision;
        }

        public long getBillId() {
            return this.billId;
        }

        public void setBillId(long billId) {
            this.billId = billId;
        }

        public long getBillEntryId() {
            return this.billEntryId;
        }

        public void setBillEntryId(long billEntryId) {
            this.billEntryId = billEntryId;
        }

        public BigDecimal getQty() {
            return this.qty == null ? BigDecimal.ZERO : this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(long currencyId) {
            this.currencyId = currencyId;
        }

        public long getBaseUnitId() {
            return this.baseUnitId;
        }

        public void setBaseUnitId(long baseUnitId) {
            this.baseUnitId = baseUnitId;
        }

        public long getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(long materialId) {
            this.materialId = materialId;
        }

        public int getDisplayPricePrecision() {
            return this.displayPricePrecision;
        }

        public void setDisplayPricePrecision(int displayPricePrecision) {
            this.displayPricePrecision = displayPricePrecision;
        }

        public int getPricePrecision() {
            return this.pricePrecision;
        }

        public void setPricePrecision(int pricePrecision) {
            this.pricePrecision = pricePrecision;
        }

        public String getBillTypeNum() {
            return this.billTypeNum;
        }

        public void setBillTypeNum(String billTypeNum) {
            this.billTypeNum = billTypeNum;
        }

        public String getBillTypeName() {
            return this.billTypeName;
        }

        public void setBillTypeName(String billTypeName) {
            this.billTypeName = billTypeName;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public long getCalEntryId() {
            return this.calEntryId;
        }

        public void setCalEntryId(long calEntryId) {
            this.calEntryId = calEntryId;
        }

        public long getDetailId() {
            return this.detailId;
        }

        public void setDetailId(long detailId) {
            this.detailId = detailId;
        }

        public long getCostElementId() {
            return this.costElementId;
        }

        public void setCostElementId(long costElementId) {
            this.costElementId = costElementId;
        }

        public long getCostSubElementId() {
            return this.costSubElementId;
        }

        public void setCostSubElementId(long costSubElementId) {
            this.costSubElementId = costSubElementId;
        }

        public boolean isPresent() {
            return this.present;
        }

        public void setPresent(boolean present) {
            this.present = present;
        }

        public boolean isInvTxZeroCost() {
            return this.inventoryTx_ZeroCost;
        }

        public void setInvTxZeroCost(boolean zeroCost) {
            this.inventoryTx_ZeroCost = zeroCost;
        }

        public long getCostAccountId() {
            return this.costAccountId;
        }

        public void setCostAccountId(long costAccountId) {
            this.costAccountId = costAccountId;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public long getCalOrgId() {
            return this.calOrgId;
        }

        public void setCalOrgId(long calOrgId) {
            this.calOrgId = calOrgId;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName;
        }

        public String getMaterialNum() {
            return this.materialNum;
        }

        public void setMaterialNum(String materialNum) {
            this.materialNum = materialNum;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public Date getAuditDate() {
            return this.auditDate;
        }

        public void setAuditDate(Date auditDate) {
            this.auditDate = auditDate;
        }

        public BigDecimal getMaterialCost() {
            return this.materialCost;
        }

        public void setMaterialCost(BigDecimal materialCost) {
            this.materialCost = materialCost;
        }

        public BigDecimal getFee() {
            return this.fee == null ? BigDecimal.ZERO : this.fee;
        }

        public void setFee(BigDecimal fee) {
            this.fee = fee;
        }

        public BigDecimal getProcessCost() {
            return this.processCost == null ? BigDecimal.ZERO : this.processCost;
        }

        public void setProcessCost(BigDecimal processCost) {
            this.processCost = processCost;
        }

        public BigDecimal getManufactureCost() {
            return this.manufactureCost == null ? BigDecimal.ZERO : this.manufactureCost;
        }

        public void setManufactureCost(BigDecimal manufactureCost) {
            this.manufactureCost = manufactureCost;
        }

        public BigDecimal getResource() {
            return this.resource == null ? BigDecimal.ZERO : this.resource;
        }

        public void setResource(BigDecimal resource) {
            this.resource = resource;
        }

        public Set<String> getPriceTypeNames() {
            return this.priceTypeNames;
        }

        public void addPriceTypeName(String priceTypeName) {
            this.priceTypeNames.add(priceTypeName);
        }

        public void addAllPriceTypeName(Set<String> priceTypeNames) {
            this.priceTypeNames.addAll(priceTypeNames);
        }

        public BigDecimal getSignnum() {
            return this.signnum == null ? BigDecimal.ZERO : this.signnum;
        }

        public void setSignnum(BigDecimal signnum) {
            this.signnum = signnum;
        }

        public String getBizEntityObject() {
            return this.bizEntityObject;
        }

        public void setBizEntityObject(String bizEntityObject) {
            this.bizEntityObject = bizEntityObject;
        }

        public long getBizbillId() {
            return this.bizbillId;
        }

        public void setBizbillId(long bizbillId) {
            this.bizbillId = bizbillId;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isIgnoreZeroCost() {
            return this.ignoreZeroCost;
        }

        public void setIgnoreZeroCost(boolean ignoreZeroCost) {
            this.ignoreZeroCost = ignoreZeroCost;
        }

        public Set<String> getPriceTypes() {
            return this.priceTypes;
        }

        public void addPriceType(String priceType) {
            this.priceTypes.add(priceType);
        }

        public void addAllPriceType(Set<String> priceTypes) {
            this.priceTypes.addAll(priceTypes);
        }

        public String getCostpricesource() {
            return this.costpricesource;
        }

        public void setCostpricesource(String costpricesource) {
            this.costpricesource = costpricesource;
        }
    }

    private static class RecentCostInfo {
        private long id;
        private BigDecimal recentQty = BigDecimal.ZERO;
        private BigDecimal recentCost = BigDecimal.ZERO;
        private BigDecimal recentPrice = BigDecimal.ZERO;
        private Date priceUpdateTime = null;
        private boolean hasRecentCost;

        private RecentCostInfo() {
        }

        public RecentCostInfo copy() {
            RecentCostInfo info = new RecentCostInfo();
            info.setId(0L);
            info.setRecentCost(this.getRecentCost());
            info.setRecentPrice(this.getRecentPrice());
            info.setRecentQty(this.getRecentQty());
            info.setPriceUpdateTime(this.getPriceUpdateTime());
            return info;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public BigDecimal getRecentQty() {
            return this.recentQty == null ? BigDecimal.ZERO : this.recentQty;
        }

        public void setRecentQty(BigDecimal recentQty) {
            this.recentQty = recentQty;
        }

        public BigDecimal getRecentCost() {
            return this.recentCost == null ? BigDecimal.ZERO : this.recentCost;
        }

        public void setRecentCost(BigDecimal recentCost) {
            this.recentCost = recentCost;
        }

        public BigDecimal getRecentPrice() {
            return this.recentPrice == null ? BigDecimal.ZERO : this.recentPrice;
        }

        public void setRecentPrice(BigDecimal recentPrice) {
            this.recentPrice = recentPrice;
        }

        public boolean isHasRecentCost() {
            return this.hasRecentCost;
        }

        public void setHasRecentCost(boolean hasRecentCost) {
            this.hasRecentCost = hasRecentCost;
        }

        public Date getPriceUpdateTime() {
            return this.priceUpdateTime;
        }

        public void setPriceUpdateTime(Date priceUpdateTime) {
            this.priceUpdateTime = priceUpdateTime;
        }
    }
}

