/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;

public class StandardCostCalculate {
    private static final Log logger = LogFactory.getLog(StandardCostCalculate.class);
    private Set<Long> billIds;
    private Set<Long> costRecordIds;
    private Set<Long> costRecordEntryIds;
    private Map<String, BigDecimal> billGroupMap = new HashMap<String, BigDecimal>();

    public StandardCostCalculate(Set<Long> billIds) {
        this.billIds = billIds;
    }

    public StandardCostCalculate(Set<Long> costRecordIds, Set<Long> costRecordEntryIds) {
        this.costRecordIds = costRecordIds;
        this.costRecordEntryIds = costRecordEntryIds;
    }

    public void calculate() {
        QFilter qs = null;
        qs = this.billIds == null ? new QFilter("id", "in", this.costRecordIds) : new QFilter("bizbillid", "in", this.billIds);
        qs.and("isinitbill", "=", (Object)Boolean.FALSE);
        qs.and("issplitcreate", "=", (Object)Boolean.FALSE);
        qs.and("entry.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        qs.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"costaccount,costaccount.calpolicy,costaccount.calpolicy.calbycostelement,period,invscheme,entry.id,entry.calentryid,entry.baseqty,entry.accounttype,entry.invtype,entry.unitstandardcost,entry.standardcost,entry.materialcost,entry.fee,entry.manufacturecost,entry.resource,entry.processcost,entry.actualcost,entry.iscalculated,entry.unitmaterialcost,entry.unitfee,entry.unitmanufacturecost,entry.unitresource,entry.unitprocesscost,entry.unitactualcost,subentrycostelement.costsubelement,subentrycostelement.costelement,subentrycostelement.costelement.type,subentrycostelement.sub_actualcost,subentrycostelement.sub_unitactualcost,entry.costpricesource,entry.designatedcost", (QFilter[])qs.toArray());
        if (costRecords == null || costRecords.length == 0) {
            return;
        }
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashMap costAccount_calEntryIdMap = new HashMap(16);
        ArrayList<DynamicObject> recordEntryList = new ArrayList<DynamicObject>(10);
        for (DynamicObject costRecord : costRecords) {
            for (DynamicObject recordEntry : costRecord.getDynamicObjectCollection("entry")) {
                if (!AccountTypeEnum.STANDARDCOST.getValue().equals(recordEntry.getString("accounttype")) || !costRecord.getDynamicObject("invscheme").getBoolean("isforwardamount") || !recordEntry.getDynamicObject("invtype").getBoolean("isforwardamount") || this.costRecordEntryIds != null && !this.costRecordEntryIds.contains(recordEntry.getLong("id"))) continue;
                recordEntryList.add(recordEntry);
                long costAccount = costRecord.getLong("costaccount_id");
                long calentryId = recordEntry.getLong("calentryid");
                long period = costRecord.getLong("period_id");
                costAccountIds.add(costAccount);
                if (costAccount_calEntryIdMap.containsKey(costAccount + "|" + period)) {
                    ((Set)costAccount_calEntryIdMap.get(costAccount + "|" + period)).add(calentryId);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(calentryId);
                costAccount_calEntryIdMap.put(costAccount + "|" + period, set);
            }
        }
        Map costAccountMap = BusinessDataServiceHelper.loadFromCache((Object[])costAccountIds.toArray(), (String)"cal_bd_costaccount");
        for (Map.Entry entry : costAccount_calEntryIdMap.entrySet()) {
            String key = (String)entry.getKey();
            Map<String, BigDecimal> map = GroupRelationCostCalculator.calculateCost(key.split("\\|")[0], Long.parseLong(key.split("\\|")[1]), (Set)entry.getValue());
            this.billGroupMap.putAll(map);
        }
        logger.info("\u6210\u7ec4\u5173\u7cfb\u83b7\u53d6\uff1a" + this.billGroupMap);
        if (this.billGroupMap.isEmpty()) {
            return;
        }
        for (DynamicObject recordEntry : recordEntryList) {
            DynamicObject record = (DynamicObject)recordEntry.getParent();
            DynamicObject costAccount = record.getDynamicObject("costaccount");
            BigDecimal qty = recordEntry.getBigDecimal("baseqty");
            long costAccountId = costAccount.getLong("id");
            boolean calbycostelement = ((DynamicObject)costAccountMap.get(costAccountId)).getDynamicObject("calpolicy").getBoolean("calbycostelement");
            long calentryId = recordEntry.getLong("calentryid");
            String keyPfefix = costAccountId + "|" + calentryId + "|";
            if (calbycostelement) {
                this.dealElementEntry(this.billGroupMap, recordEntry, qty, keyPfefix);
                continue;
            }
            this.dealNoneElementEntry(this.billGroupMap, recordEntry, qty, keyPfefix);
        }
        SaveServiceHelper.save((DynamicObject[])costRecords);
    }

    private void dealNoneElementEntry(Map<String, BigDecimal> billGroupMap, DynamicObject recordEntry, BigDecimal qty, String keyPfefix) {
        BigDecimal sign = BigDecimal.valueOf(qty.signum());
        BigDecimal cost = billGroupMap.get(keyPfefix + "materialcost");
        if (cost != null) {
            recordEntry.set("materialcost", (Object)cost.multiply(sign));
            recordEntry.set("unitmaterialcost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal materialcost = recordEntry.getBigDecimal("materialcost");
        cost = billGroupMap.get(keyPfefix + "fee");
        if (cost != null) {
            recordEntry.set("fee", (Object)cost.multiply(sign));
            recordEntry.set("unitfee", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal fee = recordEntry.getBigDecimal("fee");
        cost = billGroupMap.get(keyPfefix + "manufacturecost");
        if (cost != null) {
            recordEntry.set("manufacturecost", (Object)cost.multiply(sign));
            recordEntry.set("unitmanufacturecost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal manufacturecost = recordEntry.getBigDecimal("manufacturecost");
        cost = billGroupMap.get(keyPfefix + "resource");
        if (cost != null) {
            recordEntry.set("resource", (Object)cost.multiply(sign));
            recordEntry.set("unitresource", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal resource = recordEntry.getBigDecimal("resource");
        cost = billGroupMap.get(keyPfefix + "processcost");
        if (cost != null) {
            recordEntry.set("processcost", (Object)cost.multiply(sign));
            recordEntry.set("unitprocesscost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        BigDecimal processcost = recordEntry.getBigDecimal("processcost");
        BigDecimal unitStandardCost = recordEntry.getBigDecimal("unitstandardcost");
        BigDecimal standardCost = recordEntry.getBigDecimal("standardcost");
        BigDecimal actualCost = materialcost.add(fee).add(manufacturecost).add(resource).add(processcost);
        recordEntry.set("actualcost", (Object)actualCost);
        if (actualCost.compareTo(standardCost) == 0) {
            recordEntry.set("unitactualcost", (Object)unitStandardCost);
        } else {
            recordEntry.set("unitactualcost", (Object)actualCost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        recordEntry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue()));
        recordEntry.set("designatedcost", (Object)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated());
        recordEntry.set("iscalculated", (Object)true);
        DynamicObject detail = (DynamicObject)recordEntry.getDynamicObjectCollection("subentrycostelement").get(0);
        detail.set("sub_actualcost", (Object)actualCost);
        detail.set("sub_unitactualcost", (Object)actualCost.divide(qty, 10, RoundingMode.HALF_UP));
    }

    private void dealElementEntry(Map<String, BigDecimal> billGroupMap, DynamicObject recordEntry, BigDecimal qty, String keyPfefix) {
        BigDecimal sign = BigDecimal.valueOf(qty.signum());
        BigDecimal materialCost = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal processCost = BigDecimal.ZERO;
        BigDecimal resource = BigDecimal.ZERO;
        BigDecimal manufactureCost = BigDecimal.ZERO;
        for (DynamicObject detail : recordEntry.getDynamicObjectCollection("subentrycostelement")) {
            long subElementId = detail.getDynamicObject("costsubelement").getLong("id");
            BigDecimal cost = billGroupMap.get(keyPfefix + subElementId);
            String type = detail.getDynamicObject("costelement").getString("type");
            if (cost != null) {
                cost = cost.multiply(sign);
                detail.set("sub_actualcost", (Object)cost);
                detail.set("sub_unitactualcost", (Object)cost.divide(qty, 10, RoundingMode.HALF_UP));
            }
            cost = detail.getBigDecimal("sub_actualcost");
            if ("001".equals(type)) {
                materialCost = materialCost.add(cost);
            }
            if ("002".equals(type)) {
                fee = fee.add(cost);
            }
            if ("003".equals(type)) {
                manufactureCost = manufactureCost.add(cost);
            }
            if ("004".equals(type)) {
                resource = resource.add(cost);
            }
            if (!"005".equals(type)) continue;
            processCost = processCost.add(cost);
        }
        BigDecimal unitStandardCost = recordEntry.getBigDecimal("unitstandardcost");
        BigDecimal standardCost = recordEntry.getBigDecimal("standardcost");
        BigDecimal actualCost = materialCost.add(fee).add(manufactureCost).add(resource).add(processCost);
        recordEntry.set("materialcost", (Object)materialCost);
        recordEntry.set("unitmaterialcost", (Object)materialCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("fee", (Object)fee);
        recordEntry.set("unitfee", (Object)fee.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("manufacturecost", (Object)manufactureCost);
        recordEntry.set("unitmanufacturecost", (Object)manufactureCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("resource", (Object)resource);
        recordEntry.set("unitresource", (Object)resource.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("processcost", (Object)processCost);
        recordEntry.set("unitprocesscost", (Object)processCost.divide(qty, 10, RoundingMode.HALF_UP));
        recordEntry.set("actualcost", (Object)actualCost);
        if (actualCost.compareTo(standardCost) == 0) {
            recordEntry.set("unitactualcost", (Object)unitStandardCost);
        } else {
            recordEntry.set("unitactualcost", (Object)actualCost.divide(qty, 10, RoundingMode.HALF_UP));
        }
        recordEntry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue()));
        recordEntry.set("designatedcost", (Object)CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated());
        recordEntry.set("iscalculated", (Object)true);
    }

    public void putGroupCost(Map<String, BigDecimal> groupCost) {
        this.billGroupMap.putAll(groupCost);
    }
}

