/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.out.FIFOCalculate;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate4Sync;
import kd.fi.cal.business.calculate.out.StandardCostCalculate;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeContext;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalInTimeAcctHandle {
    private final CalInTimeContext calInTimeContext;
    private final Set<Long> errorMatIds = new HashSet<Long>(16);
    private final Map<Long, Set<Long>> errBillIdEidsMap = new HashMap<Long, Set<Long>>(16);

    public CalInTimeAcctHandle(CalInTimeContext calInTimeContext) {
        this.calInTimeContext = calInTimeContext;
    }

    public void handle() {
        this.calInTime();
    }

    private void calInTime() {
        String curEntity = this.calInTimeContext.getCurEntity();
        List<Object[]> posErrorMsgs = this.calPos(curEntity);
        HashMap<Long, Long> errorEidBillIdMap = new HashMap<Long, Long>(16);
        for (Object[] errorMsg : posErrorMsgs) {
            Map eIdErrorMsgMap = this.calInTimeContext.getErrBizBillIdEidMsgMap().computeIfAbsent((Long)errorMsg[0], k -> new HashMap(16));
            Long eId = (Long)errorMsg[6];
            Long billId = (Long)errorMsg[5];
            eIdErrorMsgMap.put(eId, (String)errorMsg[1]);
            Set eIds = this.errBillIdEidsMap.computeIfAbsent(billId, k -> new HashSet(16));
            errorEidBillIdMap.put(eId, billId);
            eIds.add(eId);
            this.errorMatIds.add((Long)errorMsg[7]);
        }
        if (this.errorMatIds.size() > 0) {
            this.calInTimeContext.setErrorEidBillIdMap(errorEidBillIdMap);
            return;
        }
        DataSet errDomainDs = this.getBillDomainDs("cal_costrecord", "entry", this.errBillIdEidsMap);
        this.removeErrorRevBill(errDomainDs);
        this.calRev(curEntity);
    }

    private void calRev(String curEntity) {
        Map<Long, Set<Long>> revIdEidsMap = this.calInTimeContext.getRevIdEidsMap();
        HashSet<Long> ids = new HashSet<Long>(revIdEidsMap.keySet());
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : revIdEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        entryIds.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().keySet());
        if (entryIds.isEmpty()) {
            return;
        }
        MoveAddAverageCalculate movedCalculator = new MoveAddAverageCalculate(ids.toArray(new Long[ids.size()]), entryIds.toArray(new Long[entryIds.size()]), curEntity, "0");
        movedCalculator.calculate();
        this.calFiFo(curEntity, ids, entryIds, "0");
    }

    private List<Object[]> calPos(String curEntity) {
        ArrayList<Object[]> posErrorMsgs = new ArrayList<Object[]>(16);
        HashSet<Long> posIds = new HashSet<Long>(this.calInTimeContext.getPosIdEidsMap().keySet());
        HashSet<Long> posEntryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : this.calInTimeContext.getPosIdEidsMap().values()) {
            posEntryIds.addAll(eIds);
        }
        posEntryIds.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().keySet());
        if (posEntryIds.isEmpty()) {
            return posErrorMsgs;
        }
        if ("cal_costrecord".equals(curEntity)) {
            MoveAddAverageCalculate4Sync movedCalculator = new MoveAddAverageCalculate4Sync(posIds.toArray(new Long[posIds.size()]), posEntryIds.toArray(new Long[posEntryIds.size()]), curEntity, "1");
            DataSet dataSet = movedCalculator.beforeCalculate();
            movedCalculator.putGroupCost(this.calInTimeContext.getTotalAddedGroupCost());
            Map<String, BigDecimal> billGroupMap = movedCalculator.getBillGroupMap();
            this.doCalGroupCostEx(billGroupMap, posIds);
            Collection<Object[]> errorMsgs = movedCalculator.doCalculate(dataSet);
            if (errorMsgs != null) {
                posErrorMsgs.addAll(errorMsgs);
            }
        } else {
            MoveAddAverageCalculate cal = new MoveAddAverageCalculate(posIds.toArray(new Long[0]), posEntryIds.toArray(new Long[0]), curEntity, "1");
            cal.calculate();
        }
        List<Object[]> fifoError = this.calFiFo(curEntity, posIds, posEntryIds, "1");
        if (fifoError != null) {
            posErrorMsgs.addAll(fifoError);
        }
        StandardCostCalculate standardCalculator = new StandardCostCalculate(posIds, posEntryIds);
        standardCalculator.putGroupCost(this.calInTimeContext.getTotalAddedGroupCost());
        standardCalculator.calculate();
        return posErrorMsgs;
    }

    private List<Object[]> calFiFo(String entity, Set<Long> ids, Set<Long> entryIds, String opType) {
        ArrayList<Object[]> errors = new ArrayList<Object[]>(16);
        Map<Long, Map<Long, Set<Long>>> acctIdBillIdEidsMap = this.splitByAccount(entity, ids, entryIds);
        ArrayList<FIFOCalculate> fifoCals = new ArrayList<FIFOCalculate>(16);
        for (Map.Entry<Long, Map<Long, Set<Long>>> acctIdBillIdEidsEnt : acctIdBillIdEidsMap.entrySet()) {
            Long accountId = acctIdBillIdEidsEnt.getKey();
            Map<Long, Set<Long>> billIdEidsMap = acctIdBillIdEidsEnt.getValue();
            Set<Long> curBillIds = billIdEidsMap.keySet();
            HashSet<Long> curEntryIds = new HashSet<Long>(16);
            for (Set<Long> eIds : billIdEidsMap.values()) {
                curEntryIds.addAll(eIds);
            }
            FIFOCalculate fifoCal = new FIFOCalculate(curBillIds.toArray(new Long[0]), entity, opType, accountId, true, null);
            fifoCal.setBillEntryIds(curEntryIds.toArray(new Long[0]));
            fifoCal.putGroupCost(this.calInTimeContext.getTotalAddedGroupCost());
            Collection<Object[]> coll = fifoCal.calculate4Sync();
            if (coll != null && coll.size() > 0) {
                errors.addAll(coll);
                continue;
            }
            fifoCals.add(fifoCal);
        }
        if (errors.isEmpty()) {
            for (FIFOCalculate fifoCal : fifoCals) {
                fifoCal.writeToDB();
            }
        }
        return errors;
    }

    private Map<Long, Map<Long, Set<Long>>> splitByAccount(String entity, Set<Long> ids, Set<Long> entryIds) {
        HashMap<Long, Map<Long, Set<Long>>> acctIdBillIdEidsMap = new HashMap<Long, Map<Long, Set<Long>>>(16);
        String entryIdKey = this.getEntryName(entity) + ".id";
        String sels = "id,costaccount," + entryIdKey + " as entryid";
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter entrIdFilter = new QFilter(entryIdKey, "in", entryIds);
        DataSet costRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)sels, (QFilter[])new QFilter[]{idFilter, entrIdFilter}, null);
        for (Row row : costRecDs) {
            Long accountId = row.getLong("costaccount");
            Map billIdEidsMap = acctIdBillIdEidsMap.computeIfAbsent(accountId, k -> new HashMap(16));
            Set eIds = billIdEidsMap.computeIfAbsent(row.getLong("id"), k -> new HashSet(16));
            eIds.add(row.getLong("entryid"));
        }
        return acctIdBillIdEidsMap;
    }

    private String getEntryName(String entity) {
        String entryName = null;
        if ("cal_initbill".equals(entity)) {
            entryName = "entryentity";
        } else if ("cal_costrecord".equals(entity) || "cal_costrecord_subentity".equals(entity)) {
            entryName = "entry";
        } else if ("cal_costadjustbill".equals(entity) || "cal_costadjust_subentity".equals(entity)) {
            entryName = "entryentity";
        }
        return entryName;
    }

    private DataSet getBillDomainDs(String entity, String entryName, Map<Long, Set<Long>> costRecIdEidsMap) {
        if (costRecIdEidsMap.isEmpty()) {
            return null;
        }
        String divideStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionStr = CommonSettingHelper.getCalDimensionStr();
        String totalKey = CommonUtils.trimComma((String)divideStr) + "," + CommonUtils.trimComma((String)caldimensionStr);
        String[] fields = totalKey.split(",");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        StringBuilder selects = new StringBuilder();
        for (String field : fields) {
            String bizField = field;
            IDataEntityProperty p = entityType.findProperty(bizField);
            if (p.getParent() instanceof EntryType) {
                selects.append(entryName).append('.').append(bizField).append(" as ").append(field).append(',');
                continue;
            }
            selects.append(bizField).append(" as ").append(field).append(',');
        }
        QFilter idFilter = new QFilter("id", "in", costRecIdEidsMap.keySet());
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : costRecIdEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        QFilter entryIdFilter = new QFilter(entryName + ".id", "in", entryIds);
        selects.append(String.format("costaccount.dividebasis.dividebasis as dividebasisstr,%1$s.calrange as calrange,%1$s.caldimension.caldimension as caldimensionstr,%1$s.id as eid,id as billid,%1$s.costdomainkey as domainid,%1$s.material as material,'", entryName));
        selects.append(entity);
        selects.append("' as entity");
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)selects.toString(), (QFilter[])new QFilter[]{idFilter, entryIdFilter}, null);
        return costRecordDs;
    }

    private void removeErrorRevBill(DataSet errDomainDs) {
        if (!"cal_costrecord".equals(this.calInTimeContext.getCurEntity())) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> errBillIdEidEnt : this.errBillIdEidsMap.entrySet()) {
            Set<Long> eIds;
            Long billId = errBillIdEidEnt.getKey();
            Map<Long, Set<Long>> idEidsMap = this.calInTimeContext.getPosIdEidsMap();
            if (idEidsMap == null || (eIds = idEidsMap.get(billId)) == null) continue;
            eIds.removeAll((Collection)errBillIdEidEnt.getValue());
            if (!eIds.isEmpty()) continue;
            idEidsMap.remove(billId);
        }
        Map<Long, Set<Long>> revIdEidsMap = this.calInTimeContext.getRevIdEidsMap();
        if (errDomainDs == null || revIdEidsMap.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> idEidsMap = revIdEidsMap;
        String entryName = this.getEntryName(this.calInTimeContext.getCurEntity());
        DataSet revDs = this.getBillDomainDs(this.calInTimeContext.getCurEntity(), entryName, idEidsMap);
        if (revDs == null) {
            return;
        }
        DataSet errDomainDsJoinRevDs = errDomainDs.join(revDs).on("material", "material").select(new String[]{"domainid"}, new String[]{"entity", "billid", "eid"}).finish();
        for (Row row : errDomainDsJoinRevDs) {
            Long billId;
            Set<Long> eIds;
            Map<Long, Set<Long>> entityIdEidMap = revIdEidsMap;
            if (entityIdEidMap == null || (eIds = entityIdEidMap.get(billId = row.getLong("billid"))) == null) continue;
            eIds.remove(row.getLong("eid"));
            if (!eIds.isEmpty()) continue;
            entityIdEidMap.remove(billId);
        }
    }

    public Set<Long> getErrorMatIds() {
        return this.errorMatIds;
    }

    private void doCalGroupCostEx(Map<String, BigDecimal> billGroupMap, Set<Long> posIds) {
    }

    private Map<String, String> getSrcKeyTgtMap(Map<String, BigDecimal> billGroupMap, Map<String, Long> acctCalEIdRecEIdMap) {
        String splitStr = "|";
        HashMap<String, String> srcKeyTgtMap = new HashMap<String, String>(16);
        for (Map.Entry<String, BigDecimal> entry : billGroupMap.entrySet()) {
            String key = entry.getKey();
            String[] keySplit = key.split("\\|");
            if (keySplit.length != 3) continue;
            String costAcctIdStr = keySplit[0];
            String calEidStr = keySplit[1];
            String costAcctIdCalEidStr = costAcctIdStr + splitStr + calEidStr;
            Long recEid = acctCalEIdRecEIdMap.get(costAcctIdCalEidStr);
            String newKey = key.replace(splitStr + calEidStr, splitStr + recEid.toString());
            srcKeyTgtMap.put(key, newKey);
        }
        return srcKeyTgtMap;
    }

    private Map<String, Set<Long>> getEntityBizBillIdsMap(Set<Long> posIds, Map<String, Long> acctCalEIdRecEIdMap) {
        HashMap<String, Set<Long>> entityBizBillIdsMap = new HashMap<String, Set<Long>>(16);
        QFilter idFilter = new QFilter("id", "in", posIds);
        String sels = "bizentityobject,bizbillid,costaccount,entry.calentryid as calentryid,entry.id as entryid";
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)sels, (QFilter[])new QFilter[]{idFilter}, null);
        String splitStr = "|";
        for (Row row : costRecordDs) {
            Set bizBillIds = entityBizBillIdsMap.computeIfAbsent(row.getString("bizentityobject"), k -> new HashSet(16));
            bizBillIds.add(row.getLong("bizbillid"));
            Long costAcctId = row.getLong("costaccount");
            Long calEid = row.getLong("calentryid");
            Long costRecEid = row.getLong("entryid");
            acctCalEIdRecEIdMap.put(costAcctId + splitStr + calEid, costRecEid);
        }
        return entityBizBillIdsMap;
    }
}

