/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.adjbill.OrderDiffAdjBillCreateHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.balance.InitBillOldBalanceCalculator;
import kd.fi.cal.business.balance.PurPriceDiffCalculator;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeContext;
import kd.fi.cal.business.process.impl.SyncBizBill4AfterAuditNewServiceProcess;
import kd.fi.cal.business.process.impl.SyncBizBill4UnAuditServiceProcess;
import kd.fi.cal.business.process.inner.CostRecordAuditInvoker;
import kd.fi.cal.business.service.CalProcessContext;
import kd.fi.cal.business.service.CalProcessReExcuteHandle;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDLockHelper;

public class CalInTimeAfterHandle {
    private final CalInTimeContext calInTimeContext;

    public CalInTimeAfterHandle(CalInTimeContext calInTimeContext) {
        this.calInTimeContext = calInTimeContext;
    }

    public void afterOmInWfCalInTime(Set<Long> wfSucessRecIds) {
        if (wfSucessRecIds.isEmpty()) {
            return;
        }
        HashSet<Long> omInCostRecordEids = new HashSet<Long>(this.calInTimeContext.getOmInEidBillIdMap().keySet());
        if (!omInCostRecordEids.isEmpty()) {
            DynamicObject[] costRecordDyc = BusinessDataServiceHelper.load((Object[])wfSucessRecIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity"));
            OrderDiffAdjBillCreateHelper adjBillHelper = new OrderDiffAdjBillCreateHelper(false, costRecordDyc);
            adjBillHelper.createCostAdjustBill(null, null);
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            if (isNewBalance) {
                this.updateNewBalance(wfSucessRecIds);
            } else {
                this.updateBalance(omInCostRecordEids, wfSucessRecIds);
            }
            new CostRecordAuditInvoker().invoke(wfSucessRecIds);
        }
    }

    public void afterCalInTime(Set<Long> posIds, Set<Long> revIds) {
        String entity = this.calInTimeContext.getCurEntity();
        if ("cal_costrecord".equals(entity)) {
            this.afterPosCalInTimeCostRecord(posIds);
        }
        if ("cal_costadjustbill".equals(entity)) {
            this.afterPosCalInTimeCostAdj(posIds);
        } else if ("cal_initbill".equals(entity)) {
            this.afterPosCalInTimeInitBill(posIds);
        }
        if ("cal_costrecord".equals(entity)) {
            this.afterRevCalInTimeCostRecord(revIds);
        } else if ("cal_costadjustbill".equals(entity)) {
            this.afterRevCalInTimeCostAdj(revIds);
        } else if ("cal_initbill".equals(entity)) {
            this.afterRevCalInTimeInitBill(revIds);
        }
    }

    private void afterRevCalInTimeInitBill(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (!this.calInTimeContext.isNewBalance()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_initbill");
            DynamicObject[] billDycs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)entityType);
            new InitBillOldBalanceCalculator().updateUnAudit(billDycs);
        } else {
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_initbill");
            balanceOpInvoker.invokeBalReverseOp(ids, null);
        }
    }

    private void afterPosCalInTimeInitBill(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (!this.calInTimeContext.isNewBalance()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_initbill");
            DynamicObject[] billDycs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)entityType);
            new InitBillOldBalanceCalculator().updateAudit(billDycs);
        } else {
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_initbill");
            balanceOpInvoker.invokeBalOp(ids, null);
        }
    }

    private void afterPosCalInTimeCostAdj(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (!this.calInTimeContext.isNewBalance()) {
            BalanceCalculator calculator = new BalanceCalculator();
            HashSet<Long> entryIdSet = new HashSet<Long>(16);
            QFilter billIdFilter = new QFilter("id", "in", ids);
            DataSet adjDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.id as entryid", (QFilter[])billIdFilter.toArray(), null);
            for (Row row : adjDs) {
                entryIdSet.add(row.getLong("entryid"));
            }
            if (!entryIdSet.isEmpty()) {
                calculator.updateBalance4CostAdjust(entryIdSet.toArray());
                new PurPriceDiffCalculator().updatePurPriceDiff4CostAdjust(entryIdSet.toArray());
            }
        } else {
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_costadjust_subentity");
            balanceOpInvoker.invokeBalOp(ids, null);
        }
    }

    private void afterRevCalInTimeCostAdj(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (!this.calInTimeContext.isNewBalance()) {
            BalanceCalculator calculator = new BalanceCalculator();
            HashSet<Long> entryIdSet = new HashSet<Long>(16);
            QFilter billIdFilter = new QFilter("id", "in", ids);
            DataSet adjDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.id as entryid", (QFilter[])billIdFilter.toArray(), null);
            for (Row row : adjDs) {
                entryIdSet.add(row.getLong("entryid"));
            }
            if (!entryIdSet.isEmpty()) {
                calculator.updateBalance4CostAdjustDel(entryIdSet.toArray());
                new PurPriceDiffCalculator().updatePurPriceDiff4CostAdjustDel(entryIdSet.toArray());
            }
        } else {
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_costadjust_subentity");
            balanceOpInvoker.invokeBalReverseOp(ids, null);
        }
        this.calInTimeContext.getNeedDelCostAdjustIds().retainAll(ids);
        if (this.calInTimeContext.getNeedDelCostAdjustIds().isEmpty()) {
            return;
        }
        QFilter idsFilter = new QFilter("id", "in", this.calInTimeContext.getNeedDelCostAdjustIds());
        QFilter createTypeFilter = new QFilter("createtype", "!=", (Object)CostAdjustBilCreateTypeEnum.HAND.getValue());
        DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{idsFilter, createTypeFilter});
        QFilter filter = new QFilter("costadjustbillid", "in", this.calInTimeContext.getNeedDelCostAdjustIds());
        DeleteServiceHelper.delete((String)"cal_balance_costadjust", (QFilter[])new QFilter[]{filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterRevCalInTimeCostRecord(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        Map<String, Set<Long>> entityBizBillIds = this.getEntityBizBillIdsMap(ids);
        Map<Long, Long> noCalEidBillIdMap = this.calInTimeContext.getNoCalEidBillIdMap();
        Map<Long, Long> costRecIdBizBillIdMap = this.calInTimeContext.getCostRecIdBizBillIdMap();
        HashSet<Long> noCalBizBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : noCalEidBillIdMap.entrySet()) {
            Long billId = entry.getValue();
            if (this.calInTimeContext.getOmInEidBillIdMap().containsValue(billId)) continue;
            Long bizBillId = costRecIdBizBillIdMap.get(billId);
            noCalBizBillIds.add(bizBillId);
        }
        for (Map.Entry<Object, Object> entry : entityBizBillIds.entrySet()) {
            DynamicObject[] simpleBillDycs;
            String entity = (String)entry.getKey();
            Set bizBillIds = (Set)entry.getValue();
            for (DynamicObject simpleBillDyc : simpleBillDycs = this.getSimpleBillDycs(entity, bizBillIds)) {
                SyncBizBill4UnAuditServiceProcess process = new SyncBizBill4UnAuditServiceProcess();
                CalProcessContext calProcessContext = new CalProcessContext();
                process.setCalProcessContext(calProcessContext);
                try {
                    if (noCalBizBillIds.contains(simpleBillDyc.getLong("id"))) {
                        calProcessContext.putCustomerParams("nocalbill", "TRUE");
                    }
                    process.doProcessor(null, simpleBillDyc);
                }
                finally {
                    this.removeDLock(calProcessContext);
                }
            }
        }
        final HashMap<String, ArrayList<Long>> entityBizBillIdList = new HashMap<String, ArrayList<Long>>(16);
        for (Map.Entry<String, Set<Long>> entityBizBillIdsEnt : entityBizBillIds.entrySet()) {
            String entity = entityBizBillIdsEnt.getKey();
            Set<Long> bizBillIds = entityBizBillIdsEnt.getValue();
            entityBizBillIdList.put(entity, new ArrayList<Long>(bizBillIds));
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                try (TXHandle tx = TX.requiresNew();){
                    CalProcessReExcuteHandle calProcessReExcuteHandle = new CalProcessReExcuteHandle();
                    calProcessReExcuteHandle.autoExeCurBizBillErrorLog(entityBizBillIdList);
                    calProcessReExcuteHandle.handle(entityBizBillIdList);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterPosCalInTimeCostRecord(Set<Long> sucessCostRecordIds) {
        sucessCostRecordIds.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().values());
        if (sucessCostRecordIds.isEmpty()) {
            return;
        }
        Set<Long> otherFinishedIds = this.getFinishedCostRecordIds(sucessCostRecordIds);
        HashSet<Long> ids = new HashSet<Long>(sucessCostRecordIds);
        HashSet<Long> omInCostRecordIds = new HashSet<Long>(this.calInTimeContext.getOmInEidBillIdMap().values());
        ids.removeAll(omInCostRecordIds);
        ids.removeAll(otherFinishedIds);
        HashSet<Long> wfSucessRecIds = new HashSet<Long>(sucessCostRecordIds);
        wfSucessRecIds.retainAll(omInCostRecordIds);
        wfSucessRecIds.removeAll(otherFinishedIds);
        this.afterOmInWfCalInTime(wfSucessRecIds);
        Map<String, Set<Long>> entityBizBillIds = this.getEntityBizBillIdsMap(ids);
        for (Map.Entry<String, Set<Long>> entry : entityBizBillIds.entrySet()) {
            String string = entry.getKey();
            Set<Long> bizBillIds = entry.getValue();
            if (bizBillIds.isEmpty()) continue;
            DynamicObject[] simpleBillDycs = this.getSimpleBillDycs(string, bizBillIds);
            SyncBizBill4AfterAuditNewServiceProcess process = new SyncBizBill4AfterAuditNewServiceProcess();
            CalProcessContext calProcessContext = new CalProcessContext();
            process.setCalProcessContext(calProcessContext);
            try {
                process.doProcessor(null, simpleBillDycs);
            }
            finally {
                this.removeDLock(calProcessContext);
            }
        }
        final HashMap<String, ArrayList<Long>> entityBizBillIdList = new HashMap<String, ArrayList<Long>>(16);
        for (Map.Entry<String, Set<Long>> entry : entityBizBillIds.entrySet()) {
            String entity = entry.getKey();
            Set<Long> bizBillIds = entry.getValue();
            entityBizBillIdList.put(entity, new ArrayList<Long>(bizBillIds));
        }
        Map<String, Set<Long>> map = this.getEntityBizBillIdsMap(omInCostRecordIds);
        for (Map.Entry<String, Set<Long>> omEntityBizBillIdsEnt : map.entrySet()) {
            String entity = omEntityBizBillIdsEnt.getKey();
            Set<Long> bizBillIds = omEntityBizBillIdsEnt.getValue();
            entityBizBillIdList.put(entity, new ArrayList<Long>(bizBillIds));
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                try (TXHandle tx = TX.requiresNew();){
                    CalProcessReExcuteHandle calProcessReExcuteHandle = new CalProcessReExcuteHandle();
                    calProcessReExcuteHandle.autoExeCurBizBillErrorLog(entityBizBillIdList);
                    calProcessReExcuteHandle.handle(entityBizBillIdList);
                }
            }
        });
    }

    private Set<Long> getFinishedCostRecordIds(Set<Long> sucessCostRecordIds) {
        HashSet<Long> finishedIds = new HashSet<Long>(16);
        String billStatus = "C";
        String entityName = "cal_costrecord";
        QFilter idsF = new QFilter("id", "in", sucessCostRecordIds);
        QFilter statusF = new QFilter("billstatus", "=", (Object)billStatus);
        try (TXHandle txHandle = TX.requiresNew();){
            DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)"id", (QFilter[])new QFilter[]{idsF, statusF}, null);
            for (Row row : billDs) {
                Long billId = row.getLong("id");
                finishedIds.add(billId);
            }
        }
        return finishedIds;
    }

    private void removeDLock(CalProcessContext calProcessContext) {
        Map<String, DLock> lockMap = calProcessContext.getLockMap();
        if (lockMap != null && !lockMap.isEmpty()) {
            for (DLock lock : lockMap.values()) {
                lock.close();
            }
            lockMap.clear();
        }
    }

    private Map<String, Set<Long>> getEntityBizBillIdsMap(Set<Long> ids) {
        HashMap<String, Set<Long>> entityBizBillIds = new HashMap<String, Set<Long>>(16);
        if (ids.isEmpty()) {
            return entityBizBillIds;
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizentityobject,bizbillid", (QFilter[])new QFilter[]{idFilter}, null);
        for (Row row : costRecordDs) {
            Set bizBillIds = entityBizBillIds.computeIfAbsent(row.getString("bizentityobject"), k -> new HashSet(16));
            bizBillIds.add(row.getLong("bizbillid"));
        }
        return entityBizBillIds;
    }

    private DynamicObject[] getSimpleBillDycs(String formId, Collection<Long> bizBillIds) {
        QFilter qFilter = new QFilter("id", "in", bizBillIds);
        StringBuilder selector = new StringBuilder();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        String mainOrgName = dataEntityType.getMainOrg();
        selector.append("id").append(",").append("billno").append(",").append("billstatus").append(",").append(mainOrgName).append(",").append("auditor").append(",").append("modifytime").append(",").append("auditdate");
        DynamicObject[] billDycs = BusinessDataServiceHelper.load((String)formId, (String)selector.toString(), (QFilter[])new QFilter[]{qFilter});
        return billDycs;
    }

    private void updateNewBalance(Set<Long> balIdSet) {
        new BalanceOpInvoker().invokeCostRecordUpdateBalOp(balIdSet, BalanceSourceEnum.WRITE_OFF);
    }

    private void updateBalance(Set<Long> entryIds, Set<Long> ids) {
        String acctId = CacheKeyUtil.getAcctId();
        String lockKey = "fi-cal-billsynclock_updatebal" + acctId;
        DLock dlock = DLock.createReentrant((String)lockKey, (String)"fi-cal-billsynclock_updatebal");
        CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(dlock));
        try (TraceSpan span = Tracer.create((String)"CalInTimeAfterHandle-updateBalance", (String)"CalInTimeAfterHandle-updateBalance");){
            dlock.lock();
            new BalanceCalculator().updateBalance4Others(entryIds.toArray(), BalanceSourceEnum.WRITE_OFF, ids);
        }
    }
}

