/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeContext;
import kd.fi.cal.common.enums.BillStatusEnum;
import kd.fi.cal.common.enums.CalStatusEnum;

public class CalInTimeBillStatusManager {
    private final CalInTimeContext calInTimeContext;

    public CalInTimeBillStatusManager(CalInTimeContext calInTimeContext) {
        this.calInTimeContext = calInTimeContext;
    }

    public void updateEntryStatus() {
        Map<Long, Long> errorEidBillIdMap;
        Map<Long, Set<Long>> posIdEidsMap = this.calInTimeContext.getPosIdEidsMap();
        Set<Long> posIds = posIdEidsMap.keySet();
        HashSet<Long> posEntryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : posIdEidsMap.values()) {
            posEntryIds.addAll(eIds);
        }
        posEntryIds.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().keySet());
        if (posEntryIds.size() > 0) {
            String posEntryTName = this.getEntryTName(this.calInTimeContext.getCurEntity());
            SqlBuilder posSqlSB = this.getUpdateEntryStatusSqlSB(posIds, posEntryIds, posEntryTName, BillStatusEnum.AUDIT.getValue(), CalStatusEnum.SUCESS.getValue());
            if ("cal_costrecord".equals(this.calInTimeContext.getCurEntity())) {
                ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, posIds)});
                Object object = null;
                try {
                    ctx.set();
                    DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)posSqlSB);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ctx != null) {
                        if (object != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
            } else {
                DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)posSqlSB);
            }
        }
        Map<Long, Set<Long>> idEidsMap = this.calInTimeContext.getRevIdEidsMap();
        HashSet<Long> ids = new HashSet<Long>(idEidsMap.keySet());
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : idEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        entryIds.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().keySet());
        if (entryIds.size() > 0) {
            String entryTName = this.getEntryTName(this.calInTimeContext.getCurEntity());
            SqlBuilder sqlSB = this.getUpdateEntryStatusSqlSB(ids, entryIds, entryTName, BillStatusEnum.SAVE.getValue(), CalStatusEnum.SUCESS.getValue());
            if ("cal_costrecord".equals(this.calInTimeContext.getCurEntity())) {
                try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
                    ctx.set();
                    DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlSB);
                }
            } else {
                DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlSB);
            }
        }
        if ((errorEidBillIdMap = this.calInTimeContext.getErrorEidBillIdMap()).size() > 0) {
            String entryTName = this.getEntryTName(this.calInTimeContext.getCurEntity());
            HashSet<Long> errorIds = new HashSet<Long>(errorEidBillIdMap.values());
            Set<Long> errorEids = errorEidBillIdMap.keySet();
            SqlBuilder sqlSB = this.getUpdateEntryStatusSqlSB(errorIds, errorEids, entryTName, "B", "B");
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, errorIds)});){
                ctx.set();
                DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlSB);
            }
        }
    }

    public void updateHeadStatus(Set<Long> posIds, Set<Long> revIds) {
        String auditStatus = BillStatusEnum.AUDIT.getValue();
        this.updateHeadStatus(this.calInTimeContext.getCurEntity(), posIds, auditStatus, CalStatusEnum.SUCESS.getValue());
        String saveStatus = BillStatusEnum.SAVE.getValue();
        this.updateHeadStatus(this.calInTimeContext.getCurEntity(), revIds, saveStatus, CalStatusEnum.SUCESS.getValue());
        this.updateHeadCalStatus();
    }

    private void updateHeadCalStatus() {
        Map<Long, Long> overTimesEidBillIdMap = this.calInTimeContext.getOverTimesEidBillIdMap();
        if (overTimesEidBillIdMap.isEmpty()) {
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(overTimesEidBillIdMap.values());
        String headTName = this.getHeadTName(this.calInTimeContext.getCurEntity());
        String updateHeadStatusSql = "update %s set fcalstatus='%s' where ";
        updateHeadStatusSql = String.format(updateHeadStatusSql, headTName, CalStatusEnum.ERROR.getValue());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(updateHeadStatusSql, new Object[0]);
        Collections.sort(idList);
        sqlBuilder.appendIn("fid", idList.toArray());
        DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlBuilder);
    }

    private String getEntryTName(String entity) {
        String entryTName = null;
        if ("cal_initbill".equals(entity)) {
            entryTName = "t_cal_initbillentry";
        } else if ("cal_costrecord".equals(entity)) {
            entryTName = "t_cal_calcostrecordentry";
        } else if ("cal_costadjustbill".equals(entity)) {
            entryTName = "t_cal_costadjustbillentry";
        }
        return entryTName;
    }

    private SqlBuilder getUpdateEntryStatusSqlSB(Set<Long> ids, Set<Long> entryIds, String entryTName, String billStatus, String calStatus) {
        SqlBuilder sqlSB = new SqlBuilder();
        String updateSql = "update %s set fentrystatus = '%s',fecalstatus='%s' where ";
        sqlSB.append(String.format(updateSql, entryTName, billStatus, calStatus), new Object[0]);
        sqlSB.appendIn("fid", ids.toArray());
        sqlSB.append(" and ", new Object[0]);
        sqlSB.appendIn("fentryid", entryIds.toArray());
        return sqlSB;
    }

    private void updateHeadStatus(String entity, Set<Long> ids, String billStatus, String calStatus) {
        ArrayList<Long> idList = new ArrayList<Long>(ids);
        idList.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().values());
        if (idList.isEmpty()) {
            return;
        }
        String headTName = this.getHeadTName(entity);
        String updateHeadStatusSql = "update %s set fbillstatus = '%s',fcalstatus='%s' where ";
        updateHeadStatusSql = String.format(updateHeadStatusSql, headTName, billStatus, calStatus);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(updateHeadStatusSql, new Object[0]);
        Collections.sort(idList);
        sqlBuilder.appendIn("fid", idList.toArray());
        sqlBuilder.append(" and fcalstatus <> ? ", new Object[]{calStatus});
        DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlBuilder);
    }

    private String getHeadTName(String entity) {
        String headTName = null;
        if ("cal_initbill".equals(entity)) {
            headTName = "t_cal_initbill";
        } else if ("cal_costrecord".equals(entity)) {
            headTName = "t_cal_calcostrecord";
        } else if ("cal_costadjustbill".equals(entity)) {
            headTName = "t_cal_costadjustbill";
        }
        return headTName;
    }
}

