/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeContext;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CalBufferPoolEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.ArrayUtils;

public class CalInTimeBufferPoolManager {
    private static final Log logger = LogFactory.getLog(CalInTimeBufferPoolManager.class);
    public static final String[] ORDER_FIELDS = new String[]{"entity", "grouptype", "accounttype"};
    private CalInTimeContext calInTimeContext;
    private boolean filterTimes = false;

    public CalInTimeBufferPoolManager(CalInTimeContext calInTimeContext) {
        this.calInTimeContext = calInTimeContext;
    }

    public CalInTimeBufferPoolManager() {
    }

    public DataSet getBufferDs(Set<Long> matIds, Set<Long> ids, Set<Long> entryIds) {
        QFilter matIdFilters = null;
        if (matIds != null) {
            matIdFilters = new QFilter("material", "in", matIds);
        }
        QFilter idsFilter = new QFilter("billid", "in", ids);
        QFilter entryIdFilter = new QFilter("entryid", "in", entryIds);
        QFilter timesFilter = this.getTimesFilter();
        String[] orderFields = this.getDateOrderFields();
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bufferpool", (String)"material,billid,entryid,actionname,actiontime,ismaterialtrans,entity,isdeletebill,bookdate,issucess,bizbillid,bizbillentryid", (QFilter[])new QFilter[]{idsFilter, entryIdFilter, matIdFilters, timesFilter}, null).orderBy(orderFields);
        return billDs;
    }

    private QFilter getTimesFilter() {
        QFilter timesFilter = null;
        if (this.filterTimes) {
            Integer calInTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CALINTIME_NOCALTIMES);
            timesFilter = new QFilter("caltimes", "<", (Object)calInTimes);
        }
        return timesFilter;
    }

    private String[] getDateOrderFields() {
        String[] orderFields = new String[]{"bookdate", "actiontime"};
        String orderModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.INTIME_CAL_ORDER, null);
        if ("B".equals(orderModel)) {
            orderFields = new String[]{"actiontime"};
        }
        return orderFields;
    }

    public void updateBufferPoolSucess() {
        HashSet<Long> successIds = new HashSet<Long>(16);
        HashSet<Long> successEids = new HashSet<Long>(16);
        Map<Long, Set<Long>> posIdEidsMap = this.calInTimeContext.getPosIdEidsMap();
        successIds.addAll(posIdEidsMap.keySet());
        for (Set<Long> eIds : posIdEidsMap.values()) {
            successEids.addAll(eIds);
        }
        Map<Long, Set<Long>> revIdEidsMap = this.calInTimeContext.getRevIdEidsMap();
        successIds.addAll(revIdEidsMap.keySet());
        for (Set<Long> eIds : revIdEidsMap.values()) {
            successEids.addAll(eIds);
        }
        successEids.removeAll(this.calInTimeContext.getNoCalEidBillIdMap().keySet());
        this.updateBufferPoolSucess(successIds, successEids);
        this.updateBufferPoolError();
    }

    private void updateBufferPoolError() {
        Map<Long, Long> errorEidBillIdMap = this.calInTimeContext.getErrorEidBillIdMap();
        if (errorEidBillIdMap.size() > 0) {
            SqlBuilder errorSqlSB = new SqlBuilder();
            errorSqlSB.append("update t_cal_bufferpool set fissucess = ?,flastcaltime = ?,fcaltimes=fcaltimes+1 where ", new Object[]{CalBufferPoolEnum.ERROR.getValue(), new Timestamp(TimeServiceHelper.now().getTime())});
            errorSqlSB.appendIn("fbillid", errorEidBillIdMap.values().toArray());
            errorSqlSB.append(" and factionname in ('AUDIT','MATERIALWRITEOFF') and ", new Object[0]);
            errorSqlSB.appendIn("fentryid", errorEidBillIdMap.keySet().toArray());
            DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)errorSqlSB);
            this.setOverTimesEIdBillIdMap(errorEidBillIdMap);
        }
    }

    private void setOverTimesEIdBillIdMap(Map<Long, Long> errorEidBillIdMap) {
        HashMap<Long, Long> overTimesEIdBillIdMap = new HashMap<Long, Long>(16);
        QFilter billIdsFilter = new QFilter("billid", "in", errorEidBillIdMap.values());
        QFilter eIdsFilter = new QFilter("entryid", "in", errorEidBillIdMap.keySet());
        Integer calInTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CALINTIME_NOCALTIMES);
        QFilter timesFilter = new QFilter("caltimes", ">=", (Object)calInTimes);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bufferpool", (String)"entryid,billid", (QFilter[])new QFilter[]{billIdsFilter, eIdsFilter, timesFilter}, null);
        for (Row row : dataSet) {
            overTimesEIdBillIdMap.put(row.getLong("entryid"), row.getLong("billId"));
        }
        this.calInTimeContext.setOverTimesEidBillIdMap(overTimesEIdBillIdMap);
    }

    private void updateBufferPoolSucess(final Set<Long> successIds, final Set<Long> successEids) {
        if (successEids.isEmpty()) {
            return;
        }
        SqlBuilder sqlSB = this.getCalBufferPoolUpdateSqlSB(successIds, successEids, CalBufferPoolEnum.SUCESS.getValue());
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onRollbacked() {
                if (successIds.isEmpty()) {
                    return;
                }
                SqlBuilder backSqlSB = CalInTimeBufferPoolManager.this.getCalBufferPoolUpdateSqlSB(successIds, successEids, CalBufferPoolEnum.CALING.getValue());
                try (TXHandle txHandle = TX.requiresNew();){
                    DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)backSqlSB);
                }
            }
        });
        try (TXHandle txHandle = TX.requiresNew();){
            if (successIds.size() > 0) {
                DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlSB);
            }
        }
    }

    public void clearBufferPool() {
        Map<Long, Set<Long>> posIdEidsMap = this.calInTimeContext.getPosIdEidsMap();
        Set<Long> posIds = posIdEidsMap.keySet();
        HashSet<Long> posEntryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : posIdEidsMap.values()) {
            posEntryIds.addAll(eIds);
        }
        this.deleteBufferDb(this.calInTimeContext.getCurEntity(), posIds, posEntryIds, true);
        Map<Long, Set<Long>> idEidsMap = this.calInTimeContext.getRevIdEidsMap();
        Set<Long> ids = idEidsMap.keySet();
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : idEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        this.deleteBufferDb(this.calInTimeContext.getCurEntity(), ids, entryIds, false);
    }

    public Set<Long> getFinishBill(boolean isPos) {
        HashSet<Long> finishBillIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> entityIdEidsMap = this.calInTimeContext.getPosIdEidsMap();
        List<String> actionNames = this.calInTimeContext.getPosOps();
        if (!isPos) {
            entityIdEidsMap = this.calInTimeContext.getRevIdEidsMap();
            actionNames = this.calInTimeContext.getRevOps();
        }
        if (entityIdEidsMap.isEmpty()) {
            return finishBillIds;
        }
        finishBillIds.addAll(entityIdEidsMap.keySet());
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        billIds.addAll(entityIdEidsMap.keySet());
        for (Set<Long> eIds : entityIdEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        HashMap<Long, Set> bizBillIdIdsMap = new HashMap<Long, Set>(16);
        HashMap<Long, Long> idBizBillIdMap = new HashMap<Long, Long>(16);
        String sels = "id as billid,bizbillid,entry.id as entryid";
        QFilter idsF = new QFilter("id", "in", billIds);
        QFilter eIdsF = new QFilter("entry.id", "in", entryIds);
        DataSet curCostRecords = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)sels, (QFilter[])new QFilter[]{idsF, eIdsF}, null);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Row row : curCostRecords) {
            Long bizBillId = row.getLong("bizbillid");
            bizBillIds.add(bizBillId);
        }
        QFilter bizBillIdsF = new QFilter("bizbillid", "in", bizBillIds);
        DataSet relationCostRecords = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)sels, (QFilter[])new QFilter[]{bizBillIdsF}, null);
        for (Row row : relationCostRecords) {
            billIds.add(row.getLong("billid"));
            Long bizBillId = row.getLong("bizbillid");
            Long billId = row.getLong("billid");
            Set curBillIds = bizBillIdIdsMap.computeIfAbsent(bizBillId, k -> new HashSet(16));
            curBillIds.add(billId);
            idBizBillIdMap.put(billId, bizBillId);
        }
        QFilter billIdF = new QFilter("billid", "in", billIds);
        QFilter notSucessF = new QFilter("issucess", "in", (Object)new String[]{CalBufferPoolEnum.ERROR.getValue(), CalBufferPoolEnum.CALING.getValue(), CalBufferPoolEnum.CANCEL.getValue()});
        QFilter actionNameF = new QFilter("actionname", "in", actionNames);
        DataSet notSucessDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bufferpool", (String)"entity,billid,actionname,entryid,issucess", (QFilter[])new QFilter[]{billIdF, notSucessF, actionNameF}, null);
        for (Row row : notSucessDs) {
            Set curBillIds;
            Long billId = row.getLong("billid");
            Long eId = row.getLong("entryid");
            if (CalBufferPoolEnum.CANCEL.getValue().equals(row.getString("issucess"))) {
                this.calInTimeContext.getNoCalEidBillIdMap().put(eId, billId);
                continue;
            }
            Long bizBillId = (Long)idBizBillIdMap.get(billId);
            if (bizBillId != null && (curBillIds = (Set)bizBillIdIdsMap.get(bizBillId)) != null) {
                for (Long curBillId : curBillIds) {
                    finishBillIds.remove(curBillId);
                }
            }
            finishBillIds.remove(billId);
        }
        return finishBillIds;
    }

    private SqlBuilder getCalBufferPoolUpdateSqlSB(Set<Long> successIds, Set<Long> successEids, String isSucess) {
        SqlBuilder sqlSB = new SqlBuilder();
        sqlSB.append("update t_cal_bufferpool set fissucess = ? where ", new Object[]{isSucess});
        sqlSB.appendIn("fbillid", successIds.toArray());
        sqlSB.append(" and ", new Object[0]);
        sqlSB.appendIn("fentryid", successEids.toArray());
        return sqlSB;
    }

    private void deleteBufferDb(String entity, Set<Long> ids, Set<Long> entryIds, boolean isPos) {
        if (entryIds.isEmpty()) {
            return;
        }
        ArrayList<String> entitys = new ArrayList<String>(16);
        entitys.add(entity);
        if ("cal_costrecord".equals(entity)) {
            entitys.add("cal_costrecord_subentity");
        } else if ("cal_costadjustbill".equals(entity)) {
            entitys.add("cal_costadjust_subentity");
        }
        QFilter clearFilter = new QFilter("billid", "in", ids);
        clearFilter.and(new QFilter("entryid", "in", entryIds));
        clearFilter.and(new QFilter("entity", "in", entitys));
        List<String> actionNames = this.calInTimeContext.getPosOps();
        if (!isPos) {
            actionNames = this.calInTimeContext.getRevOps();
        }
        clearFilter.and(new QFilter("actionname", "in", actionNames));
        DeleteServiceHelper.delete((String)"cal_bufferpool", (QFilter[])clearFilter.toArray());
    }

    public DataSet getOrderBufferDs(Set<Long> matIds) {
        DataSet bufferDs = this.getBufferDs(matIds);
        bufferDs = this.getOrderBufferDs(bufferDs);
        return bufferDs;
    }

    private DataSet getBufferDs(Set<Long> matIds) {
        QFilter matIdFilters = null;
        if (matIds != null) {
            matIdFilters = new QFilter("material", "in", matIds);
        }
        QFilter timesFilter = this.getTimesFilter();
        String selects = "id as bufferid,material,entity,billid,entryid,actionname,actiontime,ismaterialtrans,bookdate,case when entity = 'cal_initbill' then 0 when entity = 'cal_costrecord_subentity' then 1 when entity = 'cal_costrecord' then 1 else 2 end as entityorder,case when actionname = 'UNAUDIT' then 1 else 0 end as actionorder,issucess,bizbillid,caltimes";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_bufferpool", selects);
        rowMeta.getField("entityorder").setDataType((DataType)DataType.IntegerType);
        rowMeta.getField("actionorder").setDataType((DataType)DataType.IntegerType);
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bufferpool", (String)selects, (QFilter[])new QFilter[]{matIdFilters, timesFilter}, null).orderBy(new String[]{"actiontime"});
        return billDs;
    }

    private DataSet getOrderBufferDs(DataSet bufferDs) {
        Map<String, Map<Long, Set<Long>>> entityIdEidsMap = this.getEntityIdEidsMap(bufferDs.copy());
        Map<Long, Set<Long>> idEidsMap = entityIdEidsMap.get("cal_costrecord_subentity");
        if (idEidsMap == null) {
            idEidsMap = entityIdEidsMap.get("cal_costrecord");
        }
        DataSet costRecordDs = this.getCostRecordGroupDs(idEidsMap);
        DataSet billDs = this.getBillDs(entityIdEidsMap);
        billDs = billDs.leftJoin(costRecordDs).on("billid", "billid").on("entryid", "entryid").select(billDs.getRowMeta().getFieldNames(), new String[]{"groupid", "grouptype"}).finish();
        bufferDs = bufferDs.join(billDs).on("entity", "entity").on("billid", "billid").on("entryid", "entryid").select(bufferDs.getRowMeta().getFieldNames(), new String[]{"accounttype", "billno", "groupid", "grouptype"}).finish().orderBy((String[])ArrayUtils.concatAll((Object[])this.getDateOrderFields(), (Object[][])new String[][]{{"entityorder"}, ORDER_FIELDS, {"actionorder"}}));
        return bufferDs;
    }

    private DataSet getCostRecordGroupDs(Map<Long, Set<Long>> idEidsMap) {
        DataSet costRecordDs = null;
        String costRecordSels = "id as billid,entry.id as entryid,calbillid,entry.calentryid as calentryid,bizentityobject,bizbillid";
        if (idEidsMap != null && idEidsMap.size() > 0) {
            Set<Long> ids = idEidsMap.keySet();
            HashSet<Long> entryIds = new HashSet<Long>(16);
            for (Set<Long> eIds : idEidsMap.values()) {
                entryIds.addAll(eIds);
            }
            QFilter idsFilter = new QFilter("id", "in", ids);
            QFilter eIdsFilter = new QFilter("entry.id", "in", entryIds);
            costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)costRecordSels, (QFilter[])new QFilter[]{idsFilter, eIdsFilter}, null);
            HashSet<Long> calBillIds = new HashSet<Long>(16);
            HashSet<Long> calBillEntryIds = new HashSet<Long>(16);
            HashMap<String, Set<Long>> formId2BizbillidMap = new HashMap<String, Set<Long>>(4);
            for (Row row : costRecordDs.copy()) {
                calBillIds.add(row.getLong("calbillid"));
                calBillEntryIds.add(row.getLong("calentryid"));
                String formid = row.getString("bizentityobject");
                Long bizbillid = row.getLong("bizbillid");
                Set bizbillids = formId2BizbillidMap.computeIfAbsent(formid, k -> new HashSet(16));
                bizbillids.add(bizbillid);
            }
            if (AcctGroupModelHelper.isBizGroupModel()) {
                DataSet billGroupDs = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(formId2BizbillidMap);
                costRecordDs = costRecordDs.leftJoin(billGroupDs).on("calbillid", "calbillid").on("calentryid", "calentryid").select(new String[]{"billid", "entryid", "calbillid", "calentryid"}, new String[]{"id as groupid", "type as grouptype"}).finish();
                costRecordDs = costRecordDs.distinct();
            } else {
                costRecordDs = this.getGroupDS(costRecordDs, calBillIds, calBillEntryIds);
            }
        } else {
            costRecordSels = costRecordSels + ",0L as groupid,'' grouptype";
            RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", costRecordSels);
            rowMeta.getField("groupid").setDataType((DataType)DataType.LongType);
            rowMeta.getField("grouptype").setDataType((DataType)DataType.StringType);
            costRecordDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        }
        return costRecordDs;
    }

    private DataSet getGroupDS(DataSet costRecordDs, Set<Long> calBillIds, Set<Long> calBillEntryIds) {
        boolean isNewGModel = AcctGroupModelHelper.isNewGroupModel();
        String groupRecKey = isNewGModel ? "cal_account_grouprecord" : "cal_groupbillrecord";
        String calBillIdKey = isNewGModel ? "calbillid" : "billid";
        calBillIdKey = "entryentity." + calBillIdKey;
        String calEntryIdKey = isNewGModel ? "calentryid" : "billentryid";
        calEntryIdKey = "entryentity." + calEntryIdKey;
        QFilter bizBillIdsF = new QFilter(calBillIdKey, "in", calBillIds);
        QFilter bizBillEntryIdsF = new QFilter(calEntryIdKey, "in", calBillEntryIds);
        StringBuilder groupSelSB = new StringBuilder();
        groupSelSB.append("id as groupid,");
        groupSelSB.append(calBillIdKey);
        groupSelSB.append(" as calbillid,");
        groupSelSB.append(calEntryIdKey);
        groupSelSB.append(" as calentryid,");
        groupSelSB.append("entryentity.type as grouptype");
        DataSet billGroupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)groupSelSB.toString(), (QFilter[])new QFilter[]{bizBillIdsF, bizBillEntryIdsF}, null);
        costRecordDs = costRecordDs.leftJoin(billGroupDs).on("calbillid", "calbillid").on("calentryid", "calentryid").select(new String[]{"billid", "entryid", "calbillid", "calentryid"}, new String[]{"groupid", "grouptype"}).finish();
        return costRecordDs;
    }

    public Map<String, Map<Long, Set<Long>>> getEntityIdEidsMap(DataSet bufferDs) {
        HashMap<String, Map<Long, Set<Long>>> entityIdEidsMap = new HashMap<String, Map<Long, Set<Long>>>(16);
        for (Row row : bufferDs) {
            String entity = row.getString("entity");
            Map idEidsMap = entityIdEidsMap.computeIfAbsent(entity, k -> new HashMap(16));
            Set eIds = idEidsMap.computeIfAbsent(row.getLong("billid"), k -> new HashSet(16));
            eIds.add(row.getLong("entryid"));
        }
        return entityIdEidsMap;
    }

    public DataSet getBillDs(Map<String, Map<Long, Set<Long>>> entityIdEidsMap) {
        String format = "billno,id as billid,%1$s.id as entryid,%1$s.accounttype as accounttype,%1$s.costdomainkey as domainid,'%2$s' as entity,costaccount";
        if (entityIdEidsMap.isEmpty()) {
            String entity = "cal_costrecord";
            String entryName = this.getEntryName(entity);
            RowMeta rowMeta = ORM.create().createRowMeta(entity, String.format(format, entryName, entity));
            rowMeta.getField("entity").setDataType((DataType)DataType.StringType);
            DataSet emptyDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
            return emptyDs;
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        for (Map.Entry<String, Map<Long, Set<Long>>> entityIdEidsEnt : entityIdEidsMap.entrySet()) {
            String entity = entityIdEidsEnt.getKey();
            String entryName = this.getEntryName(entity);
            Map<Long, Set<Long>> idEidsMap = entityIdEidsEnt.getValue();
            HashSet<Long> entryIds = new HashSet<Long>(16);
            for (Set<Long> eIds : idEidsMap.values()) {
                entryIds.addAll(eIds);
            }
            QFilter idFilter = new QFilter("id", "in", idEidsMap.keySet());
            QFilter eIdFilter = new QFilter(entryName + ".id", "in", entryIds);
            String sels = String.format(format, entryName, entity);
            RowMeta rowMeta = ORM.create().createRowMeta(entity, sels);
            rowMeta.getField("entity").setDataType((DataType)DataType.StringType);
            OrmInput input = new OrmInput(this.getClass().getName(), entity, sels, new QFilter[]{idFilter, eIdFilter}, rowMeta);
            inputs.add(input);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet billDs = algo.createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        return billDs;
    }

    private String getEntryName(String entity) {
        String entryName = null;
        if ("cal_initbill".equals(entity)) {
            entryName = "entryentity";
        } else if ("cal_costrecord".equals(entity) || "cal_costrecord_subentity".equals(entity)) {
            entryName = "entry";
        } else if ("cal_costadjustbill".equals(entity) || "cal_costadjust_subentity".equals(entity)) {
            entryName = "entryentity";
        }
        return entryName;
    }

    public void clearNoBillData(Set<Long> matIds) {
        DataSet bufferDs = this.getBufferDs(matIds);
        Map<String, Map<Long, Set<Long>>> entityIdEidsMap = this.getEntityIdEidsMap(bufferDs.copy());
        DataSet billDs = this.getBillDs(entityIdEidsMap);
        if (billDs == null) {
            return;
        }
        bufferDs = bufferDs.leftJoin(billDs).on("entity", "entity").on("billid", "billid").on("entryid", "entryid").select(new String[]{"bufferid", "billid"}, new String[]{"accounttype", "billno"}).finish().filter("billno is null");
        HashSet<Long> needDelBuffIds = new HashSet<Long>(16);
        HashSet<Long> needDelBillId = new HashSet<Long>(16);
        for (Row row : bufferDs) {
            needDelBuffIds.add(row.getLong("bufferid"));
            needDelBillId.add(row.getLong("billid"));
        }
        if (needDelBuffIds.size() > 0) {
            QFilter idsF = new QFilter("id", "in", needDelBuffIds);
            DeleteServiceHelper.delete((String)"cal_bufferpool", (QFilter[])idsF.toArray());
            logger.info("\u81ea\u52a8\u6e05\u7406\u7f13\u51b2\u6c60\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u5355\u636eid\uff1a", needDelBillId);
        }
    }

    public void clearAllNoBillDataAsync(int hours) {
        boolean isTimeout;
        IAppCache cache = AppCache.get((String)"cal");
        String lastClearTimeKey = CacheKeyUtil.getAcctId() + "lastclearallnobilldata";
        Long lastClearTime = (Long)cache.get(lastClearTimeKey, Long.class);
        Long curTime = TimeServiceHelper.now().getTime();
        boolean bl = isTimeout = lastClearTime != null && (curTime - lastClearTime) / 1000L / 60L / 60L >= (long)hours;
        if (lastClearTime == null || isTimeout) {
            ThreadPools.executeOnceIncludeRequestContext((String)(this.getClass().getName() + "clearAllNoBillData"), () -> {
                logger.info("\u5f00\u59cb\u5168\u91cf\u81ea\u52a8\u6e05\u7406\u7f13\u51b2\u6c60\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u5355\u636eid");
                cache.put(lastClearTimeKey, (Object)curTime);
                this.clearNoBillData(null);
                logger.info("\u7ed3\u675f\u5168\u91cf\u81ea\u52a8\u6e05\u7406\u7f13\u51b2\u6c60\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u5355\u636eid");
            });
        }
    }

    public DataSet[] getMatDs() {
        String sql = "select fmaterialid as material,count(1) as ecount,max(fismaterialtrans) as ismaterialtrans from t_cal_bufferpool group by fmaterialid";
        DataSet bufferDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (String)sql);
        QFilter isMatTransF = new QFilter("ismaterialtrans", "=", (Object)"1");
        QFilter notMatTransF = new QFilter("ismaterialtrans", "=", (Object)"0");
        DataSet[] dataSets = bufferDs.splitByFilter(new String[]{isMatTransF.toString(), notMatTransF.toString()}, false);
        return dataSets;
    }

    public Map<String, Set<Long>> getCalIngActionNameBizBillIdsMap(Set<Long> bizBillIds) {
        HashMap<String, Set<Long>> actionNameBizBillIdsMap = new HashMap<String, Set<Long>>(16);
        Boolean isEntryIntimeCal = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL);
        if (bizBillIds.isEmpty() | isEntryIntimeCal == false) {
            return actionNameBizBillIdsMap;
        }
        Set omInBillEntitys = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        String wfRecordSels = "id,entry.id as entryid,entry.billid as bizbillid,entry.billentryid bizbillentryid";
        QFilter bizBillIdsF = new QFilter("id", "in", bizBillIds);
        QFilter billTypeF = new QFilter("entry.billtype", "in", (Object)omInBillEntitys);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_omwrfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, billTypeF}, null);
        HashMap<Long, Long> bizBillEntryIdWfRecordIdMap = new HashMap<Long, Long>(16);
        for (Object row : dataSet) {
            bizBillEntryIdWfRecordIdMap.put(row.getLong("bizbillentryid"), row.getLong("id"));
            bizBillIds.add(row.getLong("bizbillid"));
        }
        DataSet inOsDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_oswfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, billTypeF}, null);
        for (Row row : inOsDataSet) {
            bizBillEntryIdWfRecordIdMap.put(row.getLong("bizbillentryid"), row.getLong("id"));
            bizBillIds.add(row.getLong("bizbillid"));
        }
        HashMap<Long, Long> billIdBizBillIdMap = new HashMap<Long, Long>(16);
        String sels = "id as billid,bizbillid,entry.id as entryid";
        QFilter bizBillIdF = new QFilter("bizbillid", "in", bizBillIds);
        DataSet curCostRecords = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)sels, (QFilter[])new QFilter[]{bizBillIdF}, null);
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Row row : curCostRecords) {
            Long billId = row.getLong("billid");
            billIds.add(billId);
            entryIds.add(row.getLong("entryid"));
            billIdBizBillIdMap.put(billId, row.getLong("bizbillid"));
        }
        DataSet bufferDs = this.getBufferDs(null, billIds, entryIds);
        for (Row row : bufferDs) {
            Long bizBillEntryid;
            Long wfId;
            Set curBizBillIds = actionNameBizBillIdsMap.computeIfAbsent(row.getString("actionname"), k -> new HashSet(16));
            Long bizBillId = (Long)billIdBizBillIdMap.get(row.getLong("billid"));
            if (bizBillId != null) {
                curBizBillIds.add(bizBillId);
            }
            if ((wfId = (Long)bizBillEntryIdWfRecordIdMap.get(bizBillEntryid = row.getLong("bizbillentryid"))) == null) continue;
            curBizBillIds.add(wfId);
        }
        return actionNameBizBillIdsMap;
    }

    public Map<Long, Long> markCancel(List<DynamicObject> bufferDycs) {
        Map<Long, Long> noCalEidBillIdMap = this.getCancelEids(bufferDycs);
        if (noCalEidBillIdMap.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>(noCalEidBillIdMap.values());
            Set<Long> eIds = noCalEidBillIdMap.keySet();
            SqlBuilder sql = this.getCalBufferPoolUpdateSqlSB(ids, eIds, CalBufferPoolEnum.CANCEL.getValue());
            try (TXHandle h = TX.requiresNew();){
                DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sql);
            }
            this.updateCalInTimes(ids, eIds);
        }
        return noCalEidBillIdMap;
    }

    private void updateCalInTimes(Set<Long> ids, Set<Long> eIds) {
        if (eIds.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            SqlBuilder sqlSB = new SqlBuilder();
            sqlSB.append("update t_cal_bufferpool set fcaltimes = 0 where ", new Object[0]);
            sqlSB.appendIn("fbillid", ids.toArray());
            sqlSB.append(" and ", new Object[0]);
            sqlSB.appendIn("fentryid", eIds.toArray());
            DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlSB);
        }
    }

    private Map<Long, Long> getCancelEids(List<DynamicObject> bufferDycs) {
        HashMap<Long, Long> noCalEidBillIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> posEids = new HashSet<Long>(16);
        HashSet<Long> revEids = new HashSet<Long>(16);
        HashMap<Long, Long> eidBillIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject bufferDyc : bufferDycs) {
            String entity = bufferDyc.getString("entity");
            if (!"cal_costrecord".equals(entity) && !"cal_costrecord_subentity".equals(entity)) continue;
            String calSucess = bufferDyc.getString("issucess");
            if (CalBufferPoolEnum.SUCESS.getValue().equals(calSucess) || CalBufferPoolEnum.CANCEL.getValue().equals(calSucess)) continue;
            String actionName = bufferDyc.getString("actionname");
            long billId = bufferDyc.getLong("billid");
            long entryId = bufferDyc.getLong("entryid");
            if (ActionEnum.UN_AUDIT.getValue().equals(actionName)) {
                revEids.add(entryId);
            } else {
                posEids.add(entryId);
            }
            eidBillIdMap.put(entryId, billId);
        }
        revEids.retainAll(posEids);
        for (Long revEid : revEids) {
            noCalEidBillIdMap.put(revEid, (Long)eidBillIdMap.get(revEid));
        }
        return noCalEidBillIdMap;
    }

    public String dispatchTask(Set<Long> matIds) {
        HashMap<String, String> jobParams = new HashMap<String, String>(16);
        jobParams.put("batch", "100");
        jobParams.put("percent", "100");
        String matIdStrs = StringUtils.join((Object[])matIds.toArray(), (String)",");
        jobParams.put("matIdStrs", matIdStrs);
        JobInfo job = new JobInfo();
        job.setId("2PZF9JRK1X/+");
        job.setTaskDefineId("2PZEY192UAF2");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setTaskClassname("kd.fi.cal.formplugin.setting.CalInTimeTask");
        job.setRunByLang(Lang.get());
        String taskid = JobClient.dispatch((JobInfo)job);
        return taskid;
    }

    public void clearCalInTimes(Set<Long> matIds) {
        if (matIds == null || matIds.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            SqlBuilder sqlSB = new SqlBuilder();
            sqlSB.append("update t_cal_bufferpool set fcaltimes = 0 where ", new Object[0]);
            sqlSB.appendIn("fmaterialid", matIds.toArray());
            DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlSB);
        }
    }

    public void setFilterTimes(boolean filterTimes) {
        this.filterTimes = filterTimes;
    }

    public boolean isExistRevData(Set<Long> matIds) {
        QFilter matIdFilter = new QFilter("material", "in", matIds);
        QFilter opFilter = new QFilter("actionname", "=", (Object)ActionEnum.UN_AUDIT.getValue());
        return QueryServiceHelper.exists((String)"cal_bufferpool", (QFilter[])new QFilter[]{matIdFilter, opFilter});
    }
}

