/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CalInTimeErrorDomainManager {
    public void recordError(Set<Long> errorMatIds) {
        if (errorMatIds.isEmpty()) {
            return;
        }
        Date calTime = TimeServiceHelper.now();
        HashSet<Long> copyErrorMatIds = new HashSet<Long>(errorMatIds);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_failcostdomain");
        this.updateErrorInfo(calTime, copyErrorMatIds);
        this.insertErrorInfo(calTime, copyErrorMatIds, entityType);
    }

    public void clearErrorInfo(Set<Long> matIds) {
        if (matIds.isEmpty()) {
            return;
        }
        QFilter matIdFilter = new QFilter("material", "in", matIds);
        DeleteServiceHelper.delete((String)"cal_failcostdomain", (QFilter[])matIdFilter.toArray());
    }

    public Set<Long> getNoCalMatIds() {
        HashSet<Long> noCalMatIds = new HashSet<Long>(16);
        DataSet errorMatIdDs = this.getErrorMatIdDs(null);
        Long curTime = TimeServiceHelper.now().getTime();
        Integer errorTimeOut = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CALINTIME_TIMEOUT_MIN);
        Integer maxTimeOut = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CALINTIME_MAXTIMEOUT_MIN);
        for (Row row : errorMatIdDs) {
            Long matId = row.getLong("material");
            Integer times = row.getInteger("times");
            Long lastCalTime = row.getDate("caltime").getTime();
            long minutes = (curTime - lastCalTime) / 1000L / 60L;
            if (minutes >= (long)maxTimeOut.intValue() || minutes >= (long)(times * errorTimeOut)) continue;
            noCalMatIds.add(matId);
        }
        return noCalMatIds;
    }

    public Set<Long> getErrorMatIds(Set<Long> matIds) {
        HashSet<Long> errorMatIds = new HashSet<Long>(16);
        DataSet errorMatIdDs = this.getErrorMatIdDs(matIds);
        for (Row row : errorMatIdDs) {
            errorMatIds.add(row.getLong("material"));
        }
        return errorMatIds;
    }

    private DataSet getErrorMatIdDs(Set<Long> matIds) {
        QFilter matIdFilter = null;
        if (matIds != null) {
            matIdFilter = new QFilter("material", "in", matIds);
        }
        DataSet errorMatIdDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_failcostdomain", (String)"material,times,caltime", (QFilter[])new QFilter[]{matIdFilter}, null);
        return errorMatIdDs;
    }

    private void updateErrorInfo(Date calTime, Set<Long> copyErrorMatIds) {
        DynamicObject[] updateDycs;
        QFilter matIdF = new QFilter("material", "in", copyErrorMatIds);
        String selectProperties = "times,caltime,material";
        for (DynamicObject errorMatInfoDyc : updateDycs = BusinessDataServiceHelper.load((String)"cal_failcostdomain", (String)selectProperties, (QFilter[])matIdF.toArray())) {
            int times = errorMatInfoDyc.getInt("times");
            errorMatInfoDyc.set("times", (Object)(times + 1));
            errorMatInfoDyc.set("caltime", (Object)calTime);
            DynamicObject materialDyc = errorMatInfoDyc.getDynamicObject("material");
            if (materialDyc == null) continue;
            copyErrorMatIds.remove(materialDyc.getPkValue());
        }
        if (updateDycs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])updateDycs);
        }
    }

    private void insertErrorInfo(Date calTime, Set<Long> copyErrorMatIds, MainEntityType entityType) {
        if (copyErrorMatIds.size() > 0) {
            ArrayList<DynamicObject> newDycs = new ArrayList<DynamicObject>(16);
            for (Long copyErrorMatId : copyErrorMatIds) {
                DynamicObject newDyc = new DynamicObject((DynamicObjectType)entityType);
                newDyc.set("material", (Object)copyErrorMatId);
                newDyc.set("times", (Object)1);
                newDyc.set("caltime", (Object)calTime);
                newDycs.add(newDyc);
            }
            SaveServiceHelper.save((DynamicObject[])newDycs.toArray(new DynamicObject[0]));
        }
    }
}

