/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeContext;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.IDGenerator;

public class CalInTimeLogHandle {
    private final CalInTimeContext calInTimeContext;
    private final Set<Long> allLogIds = new HashSet<Long>(16);
    private final Map<Long, Object[]> eIdInsertEntryLogParamsMap = new HashMap<Long, Object[]>(16);
    private Set<Long> overTimesErrorLogIds = new HashSet<Long>(16);
    private Set<Long> needDelEids = new HashSet<Long>(16);
    private final Set<Long> sucessOmWfLogIds = new HashSet<Long>(16);

    public CalInTimeLogHandle(CalInTimeContext calInTimeContext) {
        this.calInTimeContext = calInTimeContext;
    }

    public void handle() {
        this.recordErrorLog();
    }

    private void recordErrorLog() {
        this.collectDbParams();
        this.writeLog2Db();
    }

    private void collectDbParams() {
        Map<Long, Long> overTimesEidBillIdMap = this.calInTimeContext.getOverTimesEidBillIdMap();
        HashSet<Long> errorEids = new HashSet<Long>(16);
        IDGenerator idGenerator = new IDGenerator("t_cal_businesslogentry");
        for (Map<Long, String> map : this.calInTimeContext.getErrBizBillIdEidMsgMap().values()) {
            errorEids.addAll(map.keySet());
        }
        for (Set set : this.calInTimeContext.getPosIdEidsMap().values()) {
            this.needDelEids.addAll(set);
        }
        this.needDelEids.addAll(this.calInTimeContext.getNoCalEidBillIdMap().keySet());
        this.needDelEids.addAll(errorEids);
        Map<Long, Long> sucessEIdBizBillIdMap = this.getSucessEidWfRecordIdMap();
        HashMap<Long, Set> hashMap = new HashMap<Long, Set>(16);
        for (Map.Entry<Long, Long> entry : sucessEIdBizBillIdMap.entrySet()) {
            Set set = hashMap.computeIfAbsent(entry.getValue(), k -> new HashSet(16));
            set.add(entry.getKey());
        }
        HashMap<Long, String> allErrorEidMsgMap = new HashMap<Long, String>(16);
        for (Map<Long, String> map : this.calInTimeContext.getErrBizBillIdEidMsgMap().values()) {
            allErrorEidMsgMap.putAll(map);
        }
        HashSet<Long> hashSet = new HashSet<Long>(16);
        hashSet.addAll(sucessEIdBizBillIdMap.values());
        hashSet.addAll(this.calInTimeContext.getErrBizBillIdEidMsgMap().keySet());
        QFilter qFilter = new QFilter("bizbillid", "in", hashSet);
        QFilter actionNameF = new QFilter("actionname", "in", this.calInTimeContext.getPosOps());
        DataSet businessLogDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_businesslog", (String)"id,entry.costrecordeid eid,bizbillid,actionname", (QFilter[])new QFilter[]{qFilter, actionNameF}, null);
        for (Row row : businessLogDs) {
            this.allLogIds.add(row.getLong("id"));
            Long bizBillId = row.getLong("bizbillid");
            Map<Long, String> eIdMsgMap = null;
            if (ActionEnum.MATERIALWRITEOFF.getValue().equals(row.getString("actionname"))) {
                Set eIds = (Set)hashMap.get(bizBillId);
                if (eIds == null || eIds.isEmpty()) {
                    this.sucessOmWfLogIds.add(row.getLong("id"));
                } else {
                    eIdMsgMap = new HashMap<Long, String>(16);
                    for (Long eId : eIds) {
                        String errorMsg = (String)allErrorEidMsgMap.get(eId);
                        if (errorMsg == null) continue;
                        eIdMsgMap.put(eId, errorMsg);
                    }
                }
            } else {
                eIdMsgMap = this.calInTimeContext.getErrBizBillIdEidMsgMap().get(bizBillId);
            }
            if (eIdMsgMap == null || eIdMsgMap.isEmpty()) continue;
            for (Map.Entry<Long, String> eIdMsgEntry : eIdMsgMap.entrySet()) {
                String errMsg = eIdMsgEntry.getValue();
                String errMsg_tag = eIdMsgEntry.getValue();
                if (errMsg.length() >= 250) {
                    errMsg = errMsg.substring(0, 250);
                }
                Object[] params = new Object[]{row.getLong("id"), idGenerator.getId(), eIdMsgEntry.getKey(), errMsg, errMsg_tag};
                this.eIdInsertEntryLogParamsMap.put(eIdMsgEntry.getKey(), params);
                if (!overTimesEidBillIdMap.containsKey(eIdMsgEntry.getKey())) continue;
                this.overTimesErrorLogIds.add(row.getLong("id"));
            }
        }
    }

    private void writeLog2Db() {
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_businesslog", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, this.allLogIds)});){
            SqlBuilder updateSqlBuilder;
            ctx.set();
            DBRoute dbRoute = new DBRoute("cal");
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_cal_businesslogentry where ", new Object[0]);
            sqlBuilder.appendIn("fcostrecordeid", this.needDelEids.toArray());
            if (this.needDelEids.size() > 0) {
                DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
            }
            if (this.eIdInsertEntryLogParamsMap.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)"insert into t_cal_businesslogentry(fid,fentryid,fcostrecordeid,ferrorinfo,ferrorinfo_tag) values(?,?,?,?,?)", new ArrayList<Object[]>(this.eIdInsertEntryLogParamsMap.values()));
            }
            if (this.sucessOmWfLogIds.size() > 0) {
                updateSqlBuilder = new SqlBuilder();
                updateSqlBuilder.append("update t_cal_businesslog set fcalstatus='A' where ", new Object[0]);
                updateSqlBuilder.appendIn("fid", this.sucessOmWfLogIds.toArray());
                updateSqlBuilder.append(" and ", new Object[0]);
                updateSqlBuilder.append("factionname=?", new Object[]{ActionEnum.MATERIALWRITEOFF.getValue()});
                DB.execute((DBRoute)dbRoute, (SqlBuilder)updateSqlBuilder);
            }
            if (this.overTimesErrorLogIds.size() > 0) {
                updateSqlBuilder = new SqlBuilder();
                updateSqlBuilder.append("update t_cal_businesslog set fcalstatus='B' where ", new Object[0]);
                updateSqlBuilder.appendIn("fid", this.overTimesErrorLogIds.toArray());
                DB.execute((DBRoute)dbRoute, (SqlBuilder)updateSqlBuilder);
            }
        }
    }

    private Map<Long, Long> getSucessEidWfRecordIdMap() {
        HashMap<Long, Long> sucessEIdBizBillIdMap = new HashMap<Long, Long>(16);
        HashMap idEidsMap = this.calInTimeContext.getPosIdEidsMap();
        idEidsMap = idEidsMap == null ? new HashMap(16) : idEidsMap;
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Set eIds : idEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        HashSet billIds = new HashSet(idEidsMap.keySet());
        entryIds.addAll(this.calInTimeContext.getErrorEidBillIdMap().keySet());
        billIds.addAll(this.calInTimeContext.getErrorEidBillIdMap().values());
        QFilter idF = new QFilter("id", "in", billIds);
        QFilter entryIdF = new QFilter("entry.id", "in", entryIds);
        String selectFields = "bizbillid,entry.bizbillentryid as bizbillentryid,entry.id as entryid,bizentityobject as entity";
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])new QFilter[]{idF, entryIdF}, null);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> bizBillEids = new HashSet<Long>(16);
        HashMap<Long, Long> eIdBizBillEntryIdMap = new HashMap<Long, Long>(16);
        for (Row row : costRecordDs) {
            Long eId = row.getLong("entryid");
            Long bizBillId = row.getLong("bizbillid");
            bizBillIds.add(bizBillId);
            bizBillEids.add(row.getLong("bizbillentryid"));
            eIdBizBillEntryIdMap.put(eId, row.getLong("bizbillentryid"));
            sucessEIdBizBillIdMap.put(eId, bizBillId);
        }
        if (this.calInTimeContext.getOmInEidBillIdMap().isEmpty()) {
            return sucessEIdBizBillIdMap;
        }
        String wfRecordSels = "id,entry.id as entryid,entry.billid as bizbillid,entry.billentryid bizbillentryid";
        QFilter bizBillIdsF = new QFilter("entry.billid", "in", bizBillIds);
        QFilter bizBillEidsF = new QFilter("entry.billentryid", "in", bizBillEids);
        QFilter billTypeF = new QFilter("entry.billtype", "in", this.calInTimeContext.getOmInBills());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_omwrfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEidsF, billTypeF}, null);
        HashMap<Long, Long> bizBillEntryIdWfRecordIdMap = new HashMap<Long, Long>(16);
        for (Object row : dataSet) {
            bizBillEntryIdWfRecordIdMap.put(row.getLong("bizbillentryid"), row.getLong("id"));
        }
        DataSet inOsDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_oswfrecord", (String)wfRecordSels, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEidsF, billTypeF}, null);
        for (Row row : inOsDataSet) {
            bizBillEntryIdWfRecordIdMap.put(row.getLong("bizbillentryid"), row.getLong("id"));
        }
        HashMap<Long, Long> eIdBizBillIdMap = new HashMap<Long, Long>(16);
        for (Map.Entry eIdBizBillEntryIdEnt : eIdBizBillEntryIdMap.entrySet()) {
            Long bizBillEntryId;
            Long wfRecordId;
            Long eId = (Long)eIdBizBillEntryIdEnt.getKey();
            if (!this.calInTimeContext.getOmInEidBillIdMap().containsKey(eId) || (wfRecordId = (Long)bizBillEntryIdWfRecordIdMap.get(bizBillEntryId = (Long)eIdBizBillEntryIdEnt.getValue())) == null) continue;
            eIdBizBillIdMap.put(eId, wfRecordId);
        }
        sucessEIdBizBillIdMap.putAll(eIdBizBillIdMap);
        return sucessEIdBizBillIdMap;
    }

    public void setCalProcessLogSucess(Set<Long> posIds, Set<Long> revIds) {
        HashSet<Long> sucessCostRecordIds = new HashSet<Long>(16);
        sucessCostRecordIds.addAll(posIds);
        sucessCostRecordIds.addAll(revIds);
        if (sucessCostRecordIds.isEmpty()) {
            return;
        }
        QFilter idF = new QFilter("id", "in", sucessCostRecordIds);
        String selectFields = "id,bizbillid,entry.bizbillentryid as bizbillentryid,entry.id as entryid,bizentityobject as entity";
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])new QFilter[]{idF}, null);
        HashSet<Long> posBizBillIds = new HashSet<Long>(16);
        HashSet<Long> revBizBillIds = new HashSet<Long>(16);
        for (Row row : costRecordDs) {
            Long costRecordId = row.getLong("id");
            if (posIds.contains(costRecordId)) {
                posBizBillIds.add(row.getLong("bizbillid"));
            }
            if (!revIds.contains(costRecordId)) continue;
            revBizBillIds.add(row.getLong("bizbillid"));
        }
        this.updateCalProcessCalStatus(posBizBillIds, ActionEnum.AUDIT.getValue());
        this.updateCalProcessCalStatus(revBizBillIds, ActionEnum.UN_AUDIT.getValue());
    }

    private void updateCalProcessCalStatus(Set<Long> bizBillIds, String actionName) {
        if (bizBillIds.isEmpty()) {
            return;
        }
        DBRoute dbRoute = new DBRoute("cal");
        SqlBuilder updateSqlBuilder = new SqlBuilder();
        updateSqlBuilder.append("update t_cal_businesslog set fcalstatus='A' where ", new Object[0]);
        updateSqlBuilder.appendIn("fbizbillid", bizBillIds.toArray());
        updateSqlBuilder.append(" and ", new Object[0]);
        updateSqlBuilder.append("factionname=?", new Object[]{actionName});
        DB.execute((DBRoute)dbRoute, (SqlBuilder)updateSqlBuilder);
    }
}

