/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeAcctHandle;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeAfterHandle;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBillStatusManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeContext;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeErrorDomainManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeLogHandle;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeWfGroupHandle;
import kd.fi.cal.business.calculate.out.calintime.CalLogManager;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CalBufferPoolEnum;

public class CalInTimeManager {
    private final boolean matTrans;
    private Set<Long> matIds;
    private Set<Long> ids;
    private Set<Long> entryIds;
    private Set<Long> allErrorMatIds = new HashSet<Long>(16);
    private Set<Long> allErroEids = new HashSet<Long>(16);
    private CalInTimeContext calInTimeContext = null;
    private Map<Long, Long> noCalEidBillIdMap = new HashMap<Long, Long>(16);
    private CalLogManager logManager;

    public CalInTimeManager(Set<Long> matIds, boolean matTrans) {
        this.matIds = matIds;
        this.matTrans = matTrans;
    }

    public void calculate() {
        try (TXHandle t = TX.requiresNew();){
            try {
                Set<Long> errorMatIds = this.doCalculate();
                if (!this.matTrans && errorMatIds.size() > 0) {
                    this.matIds.removeAll(errorMatIds);
                    this.doCalculate();
                }
            }
            catch (Throwable e) {
                t.markRollback();
                throw e;
            }
        }
    }

    public Set<Long> doCalculate() {
        this.calInTimeContext = new CalInTimeContext();
        this.calInTimeContext.setMatTrans(this.matTrans);
        this.calInTimeContext.setMatIds(this.matIds);
        this.calInTimeContext.setSrcIds(this.ids);
        this.calInTimeContext.setSrcEntryIds(this.entryIds);
        if (this.matIds.isEmpty()) {
            return this.matIds;
        }
        CalInTimeBufferPoolManager bufferPoolManager = new CalInTimeBufferPoolManager(this.calInTimeContext);
        bufferPoolManager.setFilterTimes(true);
        DataSet bufferDs = bufferPoolManager.getBufferDs(this.calInTimeContext.getMatIds(), this.calInTimeContext.getSrcIds(), this.calInTimeContext.getSrcEntryIds());
        this.cacheBillId(bufferDs);
        this.logManager.appenInfo("getBufferDs");
        this.logManager.appenInfo(this.calInTimeContext);
        CalInTimeAcctHandle acctHandle = new CalInTimeAcctHandle(this.calInTimeContext);
        acctHandle.handle();
        this.logManager.appenInfo("acctHandle");
        this.logManager.appenInfo(this.calInTimeContext);
        Set<Long> errorMatIds = acctHandle.getErrorMatIds();
        CalInTimeErrorDomainManager errorDomainManager = new CalInTimeErrorDomainManager();
        if (errorMatIds.size() > 0) {
            this.calInTimeContext.getPosIdEidsMap().clear();
            this.calInTimeContext.getRevIdEidsMap().clear();
            errorDomainManager.recordError(errorMatIds);
            this.allErrorMatIds.addAll(errorMatIds);
            this.allErroEids.addAll(this.calInTimeContext.getErrorEidBillIdMap().keySet());
        }
        this.logManager.appenInfo("recordError");
        CalInTimeBillStatusManager billStatusManager = new CalInTimeBillStatusManager(this.calInTimeContext);
        billStatusManager.updateEntryStatus();
        this.logManager.appenInfo("updateEntryStatus");
        this.logManager.appenInfo(this.calInTimeContext);
        bufferPoolManager.updateBufferPoolSucess();
        this.logManager.appenInfo("updateEntryStatus");
        Set<Long> posIds = bufferPoolManager.getFinishBill(true);
        Set<Long> revIds = bufferPoolManager.getFinishBill(false);
        this.logManager.appenInfo("getFinishBill");
        billStatusManager.updateHeadStatus(posIds, revIds);
        this.logManager.appenInfo("updateHeadStatus");
        CalInTimeLogHandle calInTimeLogHandle = new CalInTimeLogHandle(this.calInTimeContext);
        calInTimeLogHandle.handle();
        calInTimeLogHandle.setCalProcessLogSucess(posIds, revIds);
        this.logManager.appenInfo("calInTimeLogHandle");
        CalInTimeAfterHandle afterHandle = new CalInTimeAfterHandle(this.calInTimeContext);
        afterHandle.afterCalInTime(posIds, revIds);
        this.logManager.appenInfo("afterCalInTime");
        bufferPoolManager.clearBufferPool();
        this.logManager.appenInfo("clearBufferPool");
        bufferPoolManager.clearNoBillData(this.matIds);
        this.logManager.appenInfo("clearNoBillData");
        if (errorMatIds.isEmpty()) {
            errorDomainManager.clearErrorInfo(this.matIds);
        }
        this.logManager.appenInfo("clearNoBillData");
        return errorMatIds;
    }

    private void cacheBillId(DataSet bufferDs) {
        HashMap<Long, Long> costRecIdBizBillIdMap = new HashMap<Long, Long>(16);
        Map<Long, Long> omInEidBillIdMap = this.calInTimeContext.getOmInEidBillIdMap();
        for (Row row : bufferDs) {
            Set entryIds;
            Map<Long, Set<Long>> posIdEidsMap;
            String entity = row.getString("entity");
            if ("cal_costrecord_subentity".equals(entity)) {
                entity = "cal_costrecord";
            } else if ("cal_costadjust_subentity".equals(entity)) {
                entity = "cal_costadjustbill";
            }
            if (!StringUtils.isEmpty((CharSequence)entity)) {
                this.calInTimeContext.setCurEntity(entity);
            }
            String actionName = row.getString("actionname");
            Long billId = row.getLong("billid");
            Long entryId = row.getLong("entryid");
            if ("cal_costrecord".equals(entity) && CalBufferPoolEnum.CANCEL.getValue().equals(row.getString("issucess"))) {
                this.noCalEidBillIdMap.put(entryId, billId);
            }
            costRecIdBizBillIdMap.put(billId, row.getLong("bizbillid"));
            if (ActionEnum.AUDIT.getValue().equals(actionName)) {
                posIdEidsMap = this.calInTimeContext.getPosIdEidsMap();
                entryIds = posIdEidsMap.computeIfAbsent(billId, k -> new HashSet(16));
                entryIds.add(entryId);
            } else if (ActionEnum.MATERIALWRITEOFF.getValue().equals(actionName)) {
                posIdEidsMap = this.calInTimeContext.getPosIdEidsMap();
                entryIds = posIdEidsMap.computeIfAbsent(billId, k -> new HashSet(16));
                entryIds.add(entryId);
                omInEidBillIdMap.put(entryId, billId);
            } else if (ActionEnum.UN_AUDIT.getValue().equals(actionName)) {
                Set entryIds2 = this.calInTimeContext.getRevIdEidsMap().computeIfAbsent(billId, k -> new HashSet(16));
                entryIds2.add(entryId);
            }
            if (!row.getBoolean("isdeletebill").booleanValue()) continue;
            this.calInTimeContext.getNeedDelCostAdjustIds().add(billId);
        }
        CalInTimeWfGroupHandle handle = new CalInTimeWfGroupHandle();
        handle.setOmInEidBillIdMap(omInEidBillIdMap);
        handle.handle();
        this.calInTimeContext.getTotalAddedGroupCost().putAll(handle.getTotalAddedGroupCost());
        this.calInTimeContext.getNoCalEidBillIdMap().putAll(this.noCalEidBillIdMap);
        this.calInTimeContext.setCostRecIdBizBillIdMap(costRecIdBizBillIdMap);
    }

    public void setIds(Set<Long> ids) {
        this.ids = ids;
    }

    public Set<Long> getIds() {
        return this.ids;
    }

    public void setEntryIds(Set<Long> entryIds) {
        this.entryIds = entryIds;
    }

    public Set<Long> getEntryIds() {
        return this.entryIds;
    }

    public Set<Long> getAllErrorMatIds() {
        return this.allErrorMatIds;
    }

    public void setNoCalEidBillIdMap(Map<Long, Long> noCalEidBillIdMap) {
        this.noCalEidBillIdMap = noCalEidBillIdMap;
    }

    public void setLogManager(CalLogManager logManager) {
        this.logManager = logManager;
    }

    public Set<Long> getAllErroEids() {
        return this.allErroEids;
    }
}

