/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.util.ExceptionUtils;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeErrorDomainManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeMsgInfo;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeMutexManager;
import kd.fi.cal.business.calculate.out.calintime.CalLogManager;
import kd.fi.cal.common.enums.CalLogTypeEnum;

public class CalInTimePublisher {
    private static final Log logger = LogFactory.getLog(CalInTimePublisher.class);
    private static final String batch_param = "batch";
    private static final String percent_param = "percent";
    private static final String clear_nobill_hours_param = "clear_nobill_hours";
    private int batch = 100;
    private int percent = 80;
    private int clearNoBillHours = 2;

    public void publish(Map<String, Object> arg) throws KDException {
        CalLogManager logManager = new CalLogManager();
        try {
            this.init(arg);
            HashSet<Long> clearErrorMatIds = new HashSet<Long>(16);
            String matIdStrs = (String)arg.get("matIdStrs");
            if (matIdStrs != null) {
                String[] split;
                for (String item : split = matIdStrs.split(",")) {
                    clearErrorMatIds.add(Long.valueOf(item));
                }
            }
            CalInTimeBufferPoolManager manager = new CalInTimeBufferPoolManager();
            manager.clearAllNoBillDataAsync(this.clearNoBillHours);
            DataSet[] dataSets = manager.getMatDs();
            CalInTimeMutexManager mutexManager = new CalInTimeMutexManager();
            Set<Long> mutexMatIds = mutexManager.getMutexMatIds();
            List<CalInTimeMsgInfo> msgInfos = this.getMsg(dataSets, mutexMatIds, clearErrorMatIds);
            if (msgInfos.size() < 1) {
                logger.info("\u65e0\u5b9a\u65f6\u6838\u7b97\u6d88\u606f");
                logManager.info("msgInfos is empty", arg, CalLogTypeEnum.CAL_INTIME_TASK.getValue());
                return;
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    HashSet<Long> allMatIds = new HashSet<Long>(16);
                    for (CalInTimeMsgInfo msgInfo : msgInfos) {
                        Set<Long> matIds = msgInfo.getMatIds();
                        allMatIds.addAll(matIds);
                    }
                    mutexManager.insertMutex(allMatIds);
                    for (CalInTimeMsgInfo msgInfo : msgInfos) {
                        this.publish(msgInfo);
                    }
                }
                catch (Throwable e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
            logManager.info("", arg, CalLogTypeEnum.CAL_INTIME_TASK.getValue());
        }
        catch (Throwable e) {
            logger.error("\u5b9a\u65f6\u6838\u7b97\u6d88\u606f\u5931\u8d25-CalInTimePublisher", e);
            String info = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e));
            logManager.error(info, arg, CalLogTypeEnum.CAL_INTIME_TASK.getValue());
            throw e;
        }
        logger.info("\u5b9a\u65f6\u6838\u7b97\u6d88\u606f\u53d1\u9001\u6210\u529f-CalInTimePublisher" + RequestContext.get().getTraceId());
    }

    private void init(Map<String, Object> arg) {
        String batchStr = (String)arg.get(batch_param);
        String percentStr = (String)arg.get(percent_param);
        String clearNoBillHoursStr = (String)arg.get(clear_nobill_hours_param);
        this.batch = batchStr == null ? 100 : Integer.parseInt(batchStr);
        this.percent = percentStr == null ? 80 : Integer.parseInt(percentStr);
        this.clearNoBillHours = clearNoBillHoursStr == null ? 2 : Integer.parseInt(clearNoBillHoursStr);
    }

    private List<CalInTimeMsgInfo> getMsg(DataSet[] dataSets, Set<Long> mutexMatId, Set<Long> clearErrorMatIds) {
        HashSet<Long> transMatIds = new HashSet<Long>(16);
        DataSet matTransDs = dataSets[0];
        DataSet notMatTransDs = dataSets[1];
        ArrayList<CalInTimeMsgInfo> msgInfos = new ArrayList<CalInTimeMsgInfo>(16);
        CalInTimeErrorDomainManager handle = new CalInTimeErrorDomainManager();
        Set<Long> noCalMatIds = handle.getNoCalMatIds();
        for (Row row : matTransDs) {
            Long matId = row.getLong("material");
            if (mutexMatId.contains(matId)) continue;
            if (noCalMatIds.contains(matId) && !clearErrorMatIds.contains(matId)) break;
            transMatIds.add(matId);
        }
        if (transMatIds.size() > 0) {
            CalInTimeMsgInfo transMatMsg = new CalInTimeMsgInfo(transMatIds, true, this.percent, clearErrorMatIds);
            msgInfos.add(transMatMsg);
        }
        HashSet<Long> notTransMatIds = new HashSet<Long>(16);
        int count = 0;
        for (Row row : notMatTransDs) {
            Long matId = row.getLong("material");
            if (mutexMatId.contains(matId) || transMatIds.contains(matId) || noCalMatIds.contains(matId) && !clearErrorMatIds.contains(matId)) continue;
            Integer eCount = row.getInteger("ecount");
            if (eCount + count >= this.batch && !notTransMatIds.isEmpty()) {
                CalInTimeMsgInfo msg = new CalInTimeMsgInfo(notTransMatIds, false, this.percent, clearErrorMatIds);
                msgInfos.add(msg);
                count = 0;
                notTransMatIds = new HashSet(16);
            }
            count += eCount.intValue();
            notTransMatIds.add(matId);
        }
        if (notTransMatIds.size() > 0) {
            CalInTimeMsgInfo msg = new CalInTimeMsgInfo(notTransMatIds, false, this.percent, clearErrorMatIds);
            msgInfos.add(msg);
        }
        return msgInfos;
    }

    private void publish(CalInTimeMsgInfo msg) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.cal.calintime");
        try {
            pub.publishInDbTranscation("cal", (Object)msg);
        }
        catch (Throwable e) {
            logger.info("CalInTimeTask-push\u961f\u5217\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getClass().getName());
            logger.error("CalInTimePublisher publish(CalInTimeMsgInfo msg)", e);
            throw e;
        }
        finally {
            logger.info("CalInTimeTask-\u7ed3\u675fpush\u961f\u5217");
            pub.close();
        }
    }
}

