/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.out.calintime;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.billgroup.WFGroupCostCalculator;
import kd.fi.cal.common.helper.AcctGroupModelHelper;

public class CalInTimeWfGroupHandle {
    private Map<Long, Long> omInEidBillIdMap;
    private Map<String, BigDecimal> totalAddedGroupCost;

    public void handle() {
        this.totalAddedGroupCost = this.calWfGroupCostByEidBillIdMap(this.omInEidBillIdMap);
    }

    private Map<String, BigDecimal> calWfGroupCostByEidBillIdMap(Map<Long, Long> omInEidBillIdMap) {
        HashMap<String, BigDecimal> totalAddedGroupCost = new HashMap<String, BigDecimal>(16);
        if (omInEidBillIdMap.size() > 0) {
            QFilter idF = new QFilter("id", "in", omInEidBillIdMap.values());
            QFilter entryIdF = new QFilter("entry.id", "in", omInEidBillIdMap.keySet());
            String selectFields = "bizbillid,entry.bizbillentryid as bizbillentryid,calbillid,entry.calentryid as calentryid,costaccount";
            DataSet omInCostRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])new QFilter[]{idF, entryIdF}, null);
            HashSet<Long> calBillIds = new HashSet<Long>(16);
            HashSet<Long> calBillEntryIds = new HashSet<Long>(16);
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            for (Row row : omInCostRecordDs) {
                costAccountIds.add(row.getLong("costaccount"));
                calBillIds.add(row.getLong("calbillid"));
                calBillEntryIds.add(row.getLong("calentryid"));
            }
            boolean isNewGModel = AcctGroupModelHelper.isNewGroupModel();
            String groupRecKey = isNewGModel ? "cal_account_grouprecord" : "cal_groupbillrecord";
            String calBillIdKey = isNewGModel ? "calbillid" : "billid";
            calBillIdKey = "entryentity." + calBillIdKey;
            String calEntryIdKey = isNewGModel ? "calentryid" : "billentryid";
            calEntryIdKey = "entryentity." + calEntryIdKey;
            QFilter bizBillIdsF = new QFilter(calBillIdKey, "in", calBillIds);
            QFilter bizBillEntryIdsF = new QFilter(calEntryIdKey, "in", calBillEntryIds);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)groupRecKey, (QFilter[])new QFilter[]{bizBillIdsF, bizBillEntryIdsF}, null, (int)-1);
            DynamicObject[] groupRecDycs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)groupRecKey));
            WFGroupCostCalculator calculator = new WFGroupCostCalculator();
            for (DynamicObject groupDyc : groupRecDycs) {
                HashSet<Long> groupNos = new HashSet<Long>(16);
                for (DynamicObject entryDyc : groupDyc.getDynamicObjectCollection("entryentity")) {
                    long groupNo = entryDyc.getLong("groupno");
                    if (groupNo <= 0L) continue;
                    groupNos.add(groupNo);
                }
                for (Long groupNo : groupNos) {
                    for (Long costAccountId : costAccountIds) {
                        Map<String, BigDecimal> addedCost = calculator.calculateCost(groupDyc, groupNo, costAccountId);
                        for (Map.Entry<String, BigDecimal> addedCostEntry : addedCost.entrySet()) {
                            String key = addedCostEntry.getKey();
                            BigDecimal totalAddCost = (BigDecimal)totalAddedGroupCost.get(key);
                            totalAddCost = totalAddCost == null ? addedCostEntry.getValue() : totalAddCost.add(addedCostEntry.getValue());
                            totalAddedGroupCost.put(key, totalAddCost);
                        }
                    }
                }
            }
        }
        return totalAddedGroupCost;
    }

    public void setOmInEidBillIdMap(Map<Long, Long> omInEidBillIdMap) {
        this.omInEidBillIdMap = omInEidBillIdMap;
    }

    public Map<String, BigDecimal> getTotalAddedGroupCost() {
        return this.totalAddedGroupCost;
    }
}

