/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.business.costprice.CostPriceSubelementHelper;
import kd.fi.cal.business.process.inner.QueryInvOrgHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.plugin.IBizPlugin;

public class AbstractCostPriceHelper {
    private static Log log = LogFactory.getLog(AbstractCostPriceHelper.class);
    private static final long costPricePageId = 752057291171328000L;
    private static final long priceLibPageId = 747819409392815104L;
    private StringBuilder cal_dim_ex = new StringBuilder();
    private StringBuilder cal_balance_ex = new StringBuilder();
    private StringBuilder cal_costrecord_ex = new StringBuilder();
    private StringBuilder cal_costadjustbill_ex = new StringBuilder();
    protected Map<String, DynamicObject> priceLibMap = new HashMap<String, DynamicObject>(32);
    protected Map<String, DynamicObject> costPriceTypeMap = new HashMap<String, DynamicObject>(16);
    private Map<Long, Long> costAccountPeriodIdMap = new HashMap<Long, Long>(16);
    private Map<Long, Date> costAccountPeriodEndDateMap = new HashMap<Long, Date>(16);
    private Map<Long, Date> costAccountPeriodBeginDateMap = new HashMap<Long, Date>(16);
    private Map<Long, Long> costAccountPeriodTypeMap = new HashMap<Long, Long>(16);
    private Map<Long, Integer> costAccountPeriodIntMap = new HashMap<Long, Integer>(16);
    private Map<Long, DynamicObjectCollection> beforePeriodCols = new HashMap<Long, DynamicObjectCollection>(16);
    private String notEmptyCalRangeFilterStr = "1 = 1";
    private String emptyCalRangeFilterStr = "1 = 1";
    private String currentEntityTypeNum = null;
    private boolean currentIsDetail = false;
    private Map<Long, Set<Long>> currentSubElementsMap = new HashMap<Long, Set<Long>>();
    protected String currentSrcVarsStr = null;
    private Set<String> currentDestVars = new HashSet<String>(16);
    private String currentSrcExt2DestVarStr = null;
    private DynamicObject currentCostPriceType = null;
    protected String costPricePlugin = null;
    private String currentCostPriceTypeName = null;
    private static final String detailUpdateSql = "update t_cal_costrecord_detail set funitactualcost = ?,factualcost = ? where fentryid = ? and fcostsubelementid = ?";
    private Long costSubElementId = CostElementHelper.getDefalutMaterialId();
    private static final String entryUpdateSelectFields = "entry.id,entry.baseqty,entry.unitmaterialcost,entry.materialcost,entry.unitfee,entry.fee,entry.unitprocesscost,entry.processcost,entry.unitmanufacturecost,entry.manufacturecost,entry.unitresource,entry.resource,entry.unitactualcost,entry.actualcost";
    private static final String splitReg = "[\\+\\-\\*\\/\\(\\)]";
    private String replaceReg = "^aa(?=[\\)*\\+\\-\\*\\/])|(?<=[(\\+\\-\\*\\/])aa(?=[\\)*\\+\\-\\*\\/])|(?<=[\\+\\-\\*\\/])aa$|^aa$";
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public AbstractCostPriceHelper() {
        String dividebasisStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] calRealDims = (dividebasisStr + "," + caldimensionStr).split(",");
        List<String> calRealDimList = Arrays.asList(calRealDims);
        MainEntityType costRecordDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        MainEntityType costAdjustDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costadjustbill");
        List<String> calDimList = Arrays.asList("calorg,costaccount,material,owner,storageorgunit,warehouse,location,lot,project,assist".split(","));
        for (String dim : calRealDims) {
            if (calDimList.contains(dim)) continue;
            this.cal_dim_ex.append(",");
            this.cal_dim_ex.append(dim);
            IDataEntityProperty costRecordEntity = costRecordDataEntity.findProperty(dim);
            if (costRecordEntity != null && costRecordEntity.getParent() instanceof EntryType) {
                this.cal_costrecord_ex.append(",");
                this.cal_costrecord_ex.append(costRecordEntity.getParent().getName());
                this.cal_costrecord_ex.append(".");
                this.cal_costrecord_ex.append(dim);
                this.cal_costrecord_ex.append(" as ");
                this.cal_costrecord_ex.append(dim);
            } else {
                this.cal_costrecord_ex.append(",");
                this.cal_costrecord_ex.append(dim);
            }
            IDataEntityProperty costAdjustEntity = costAdjustDataEntity.findProperty(dim);
            if (costAdjustEntity != null && costAdjustEntity.getParent() instanceof EntryType) {
                this.cal_costadjustbill_ex.append(",");
                this.cal_costadjustbill_ex.append(costAdjustEntity.getParent().getName());
                this.cal_costadjustbill_ex.append(".");
                this.cal_costadjustbill_ex.append(dim);
                this.cal_costadjustbill_ex.append(" as ");
                this.cal_costadjustbill_ex.append(dim);
                continue;
            }
            this.cal_costadjustbill_ex.append(",");
            this.cal_costadjustbill_ex.append(dim);
        }
        Set<String> dimFields = new BalanceDimFieldParser().getDimFields();
        this.cal_balance_ex.append(this.cal_dim_ex.toString());
        for (String dimField : dimFields) {
            if ("costelement".equals(dimField) || "costsubelement".equals(dimField) || calRealDimList.contains(dimField) || calDimList.contains(dimField)) continue;
            this.cal_balance_ex.append(",");
            this.cal_balance_ex.append(dimField);
        }
        QFilter priceLibFilter = new QFilter("id", "=", (Object)747819409392815104L);
        DynamicObjectCollection priceLibs = QueryServiceHelper.query((String)"cal_pricelib", (String)"entry.id,entry.pricenum,entry.pricename,entry.isdetail,entry.costsubelement,entry.priceexp_tag", (QFilter[])priceLibFilter.toArray());
        for (DynamicObject dynamicObject : priceLibs) {
            this.priceLibMap.put(dynamicObject.getString("entry.pricenum"), dynamicObject);
        }
        QFilter costPriceFilter = new QFilter("id", "=", (Object)752057291171328000L);
        DynamicObjectCollection costPrices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.entityobject.number,entry.billfilter_tag,entry.priceplugin.plugin,entry.beforeperiod, entry.type", (QFilter[])costPriceFilter.toArray());
        for (DynamicObject dynamicObject : costPrices) {
            this.costPriceTypeMap.put(dynamicObject.getString("entry.pricenum"), dynamicObject);
        }
        QFilter costAccountPeriodFilter = new QFilter("entry.isenabled", "=", (Object)true);
        costAccountPeriodFilter.and("entry.currentperiod", "!=", (Object)0L);
        costAccountPeriodFilter.and("entry.currentperiod", "is not null", null);
        DynamicObjectCollection costAccountPeriods = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount,entry.currentperiod,entry.currentperiod.enddate,entry.currentperiod.begindate,entry.currentperiod.periodtype,entry.currentperiod.periodyear,entry.currentperiod.periodnumber", (QFilter[])costAccountPeriodFilter.toArray());
        for (DynamicObject dynamicObject : costAccountPeriods) {
            Long costAccountId = dynamicObject.getLong("entry.costaccount");
            Long peridId = dynamicObject.getLong("entry.currentperiod");
            Date periodEndDate = dynamicObject.getDate("entry.currentperiod.enddate");
            Date periodBeginDate = dynamicObject.getDate("entry.currentperiod.begindate");
            Long periodType = dynamicObject.getLong("entry.currentperiod.periodtype");
            int curPeriodInt = dynamicObject.getInt("entry.currentperiod.periodyear") * 100 + dynamicObject.getInt("entry.currentperiod.periodnumber");
            this.costAccountPeriodIdMap.put(costAccountId, peridId);
            this.costAccountPeriodEndDateMap.put(costAccountId, periodEndDate);
            this.costAccountPeriodBeginDateMap.put(costAccountId, periodBeginDate);
            this.costAccountPeriodTypeMap.put(costAccountId, periodType);
            this.costAccountPeriodIntMap.put(costAccountId, curPeriodInt);
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        Map calrangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        HashSet<Long> notEmptyCalRangeIds = new HashSet<Long>(16);
        notEmptyCalRangeIds.add(0L);
        for (DynamicObject info : calrangeMap.values()) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            if (entry == null || entry.size() <= 0) continue;
            notEmptyCalRangeIds.add(info.getLong("id"));
        }
        this.notEmptyCalRangeFilterStr = new QFilter("calrange", "in", notEmptyCalRangeIds).or(QFilter.of((String)"calrange is null", (Object[])new Object[0])).toString();
        this.emptyCalRangeFilterStr = new QFilter("calrange", "not in", notEmptyCalRangeIds).toString();
        this.currentSubElementsMap = CostPriceSubelementHelper.getSubelementMapByScheme();
    }

    protected void prepareSrcDataSet(DynamicObject schemeRow) {
        String costPriceNum = schemeRow.getString("costprice");
        this.currentCostPriceType = this.costPriceTypeMap.get(costPriceNum);
        this.currentEntityTypeNum = this.currentCostPriceType.getString("entry.entityobject.number");
        this.costPricePlugin = this.currentCostPriceType.getString("entry.priceplugin.plugin");
        if (StringUtils.isNotEmpty((String)this.costPricePlugin)) {
            this.currentCostPriceTypeName = schemeRow.getString("pricedisplay");
            return;
        }
        if ("cal_costrecord".equals(this.currentEntityTypeNum)) {
            this.currentEntityTypeNum = "cal_costrecord_subentity";
        }
        String srcPrices = schemeRow.getString("srcprice");
        String destPrices = schemeRow.getString("destprice");
        ArrayList<String> srcNumbers = new ArrayList<String>(Arrays.asList(srcPrices.split(",")));
        srcNumbers.remove("");
        ArrayList<String> destNumbers = new ArrayList<String>(Arrays.asList(destPrices.split(",")));
        destNumbers.remove("");
        DynamicObject prices = this.priceLibMap.get(srcNumbers.get(0));
        this.currentIsDetail = prices.getBoolean("entry.isdetail");
        if (this.currentIsDetail) {
            DynamicObject srcPrice = this.priceLibMap.get(srcNumbers.get(0));
            DynamicObject destPrice = this.priceLibMap.get(destNumbers.get(0));
            String srcPriceExp = srcPrice.getString("entry.priceexp_tag");
            String destPriceExp = destPrice.getString("entry.priceexp_tag");
            this.currentSrcVarsStr = String.join((CharSequence)",", this.getSrcVars(srcPriceExp));
            this.currentSrcExt2DestVarStr = srcPriceExp + " as " + destPriceExp;
        } else {
            int size = srcNumbers.size();
            HashSet<String> srcVarSet = new HashSet<String>(16);
            StringBuilder srcExp2DestStrBuilder = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                DynamicObject srcPrice = this.priceLibMap.get(srcNumbers.get(i));
                DynamicObject destPrice = this.priceLibMap.get(destNumbers.get(i));
                String srcPriceExp = srcPrice.getString("entry.priceexp_tag");
                String destPriceVar = destPrice.getString("entry.priceexp_tag").trim();
                srcVarSet.addAll(this.getSrcVars(srcPriceExp));
                this.currentDestVars.add(destPriceVar);
                srcExp2DestStrBuilder.append(this.getRealExp(srcPriceExp));
                srcExp2DestStrBuilder.append(" as ");
                srcExp2DestStrBuilder.append(destPriceVar);
                srcExp2DestStrBuilder.append(",");
            }
            this.currentSrcVarsStr = String.join((CharSequence)",", srcVarSet);
            this.currentSrcExt2DestVarStr = srcExp2DestStrBuilder.substring(0, srcExp2DestStrBuilder.length() - 1);
        }
        this.currentCostPriceTypeName = schemeRow.getString("pricedisplay");
    }

    protected void handleCostPricePlugin(Set<Long> needCostPriceEntryIds, Long[] costRecordIds, Map<Long, CostPriceResultInfo> currentSchemePriceInfoMap) {
        IBizPlugin plugin = AbstractCostPriceHelper.getProcessByName(this.costPricePlugin);
        HashMap<String, Object> tMap = new HashMap<String, Object>(4);
        tMap.put("entryIds", needCostPriceEntryIds);
        tMap.put("costRecordIds", costRecordIds);
        log.info("\u53d6\u4ef7\u63d2\u4ef6\u5f00\u59cb\u5171" + needCostPriceEntryIds.size() + "\u6761\u5206\u5f55");
        Map entryid2PriceMap = (Map)plugin.doPlugin(tMap, null);
        log.info("\u53d6\u4ef7\u63d2\u4ef6\u53d6\u503c\u4e3a" + entryid2PriceMap);
        for (Map.Entry entryid2Price : entryid2PriceMap.entrySet()) {
            Long entryId = (Long)entryid2Price.getKey();
            BigDecimal price = (BigDecimal)entryid2Price.getValue();
            CostPriceResultInfo costPriceResultInfo = new CostPriceResultInfo();
            currentSchemePriceInfoMap.put(entryId, costPriceResultInfo);
            costPriceResultInfo.setSuccess(true);
            costPriceResultInfo.setDetail(true);
            costPriceResultInfo.setEntryId(entryId);
            costPriceResultInfo.setSrcSchemeNum(this.costPricePlugin);
            costPriceResultInfo.setSrcPriceName(this.currentCostPriceTypeName);
            costPriceResultInfo.putCostSubElementUnitcostMap(Long.valueOf(773175233367685120L), price);
        }
    }

    public static IBizPlugin getProcessByName(String className) {
        try {
            Class<?> process = Class.forName(className);
            return (IBizPlugin)process.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePriceDimension(String priceDimension, DataSet destCostRecordDS, DataSet srcDataSet, Set<String> divideBasisStrSet, Set<String> dimensionStrSet, String costPriceType, Map<Long, CostPriceResultInfo> currentSchemePriceInfoMap, String schemeNum) {
        try (DataSet dataSet = null;){
            if ("A".equals(priceDimension)) {
                dataSet = destCostRecordDS.join(srcDataSet, JoinType.INNER).on("costaccount", "costaccount").on("material", "material").select(new String[]{"entryid", "bookdate destbookdate"}, ("srcentryid,billno,baseunit,bookdate,auditdate,costsubelement," + this.currentSrcVarsStr).split(",")).finish();
                this.handleCostPriceResults(dataSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
            } else {
                DataSet[] srcDSArr = srcDataSet.splitByFilter(new String[]{this.notEmptyCalRangeFilterStr, this.emptyCalRangeFilterStr}, false);
                ArrayList<String> destFilters = new ArrayList<String>(16);
                ArrayList<String> divideBasisStrSetList = new ArrayList<String>(16);
                ArrayList<String> dimensionStrSetList = new ArrayList<String>(16);
                ArrayList<DataSet> resDataSets = new ArrayList<DataSet>(16);
                for (String divideBasis : divideBasisStrSet) {
                    QFilter divideBasisFilter = new QFilter("dividebasis", "=", (Object)divideBasis);
                    if ("B".equals(priceDimension)) {
                        destFilters.add(divideBasisFilter.toString());
                        divideBasisStrSetList.add(divideBasis);
                        dimensionStrSetList.add(null);
                        continue;
                    }
                    for (String dimension : dimensionStrSet) {
                        QFilter dimensionFilter = new QFilter("caldimension", "=", (Object)dimension);
                        destFilters.add(dimensionFilter.and(divideBasisFilter).toString());
                        divideBasisStrSetList.add(divideBasis);
                        dimensionStrSetList.add(dimension);
                    }
                }
                DataSet[] destDataSets = destCostRecordDS.splitByFilter(destFilters.toArray(new String[0]), false);
                for (int i = 0; i < destDataSets.length; ++i) {
                    String dimension;
                    DataSet destDataSet = destDataSets[i];
                    String divideBasis = (String)divideBasisStrSetList.get(i);
                    dimension = (String)dimensionStrSetList.get(i);
                    DataSet tempDataSet = this.getDimJoinDataSet(srcDSArr, destDataSet, divideBasis, dimension);
                    resDataSets.add(tempDataSet);
                }
                for (DataSet resDataSet : resDataSets) {
                    this.handleCostPriceResults(resDataSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
                }
            }
        }
    }

    private DataSet getDimJoinDataSet(DataSet[] srcDSArr, DataSet destDataSet, String divideBasis, String dimension) {
        DataSet[] destDSArr = destDataSet.splitByFilter(new String[]{this.notEmptyCalRangeFilterStr, this.emptyCalRangeFilterStr}, false);
        JoinDataSet joinDataSet0 = destDSArr[0].join(srcDSArr[0], JoinType.INNER).on("costaccount", "costaccount").on("material", "material");
        HashSet<String> dimSet0 = new HashSet<String>(16);
        dimSet0.add("calrange");
        if (StringUtils.isNotEmpty((String)dimension)) {
            String[] fields;
            for (String field : fields = dimension.split(",")) {
                if (!StringUtils.isNotEmpty((String)field)) continue;
                dimSet0.add(field);
            }
        }
        Set<String> srcDimSet0 = this.getSrcDestDimSet(dimSet0, "src");
        Set<String> destDimSet0 = this.getSrcDestDimSet(dimSet0, "dest");
        DataSet dataSet0 = joinDataSet0.select(("entryid,bookdate destbookdate," + String.join((CharSequence)",", destDimSet0)).split(","), ("srcentryid,billno,baseunit,bookdate,auditdate,costsubelement," + String.join((CharSequence)",", srcDimSet0) + "," + this.currentSrcVarsStr).split(",")).finish();
        dataSet0 = this.getFiterNullOrEqualsDataSet(dataSet0, dimSet0);
        JoinDataSet joinDataSet1 = destDSArr[1].join(srcDSArr[1], JoinType.INNER).on("costaccount", "costaccount").on("material", "material");
        HashSet<String> dimSet1 = new HashSet<String>(16);
        for (String field : divideBasis.split(",")) {
            if (!StringUtils.isNotEmpty((String)field)) continue;
            dimSet1.add(field);
        }
        if (StringUtils.isNotEmpty((String)dimension)) {
            String[] fields;
            for (String field : fields = dimension.split(",")) {
                if (!StringUtils.isNotEmpty((String)field)) continue;
                dimSet1.add(field);
            }
        }
        Set<String> srcDimSet1 = this.getSrcDestDimSet(dimSet1, "src");
        Set<String> destDimSet1 = this.getSrcDestDimSet(dimSet1, "dest");
        DataSet dataSet1 = joinDataSet1.select(("entryid,bookdate destbookdate," + String.join((CharSequence)",", destDimSet1)).split(","), ("srcentryid,billno,baseunit,bookdate,auditdate,costsubelement," + String.join((CharSequence)",", srcDimSet1) + "," + this.currentSrcVarsStr).split(",")).finish();
        dataSet1 = this.getFiterNullOrEqualsDataSet(dataSet1, dimSet1);
        dataSet0.getRowMeta().getField("costsubelement").setDataType((DataType)DataType.LongType);
        dataSet1.getRowMeta().getField("costsubelement").setDataType((DataType)DataType.LongType);
        return dataSet0.union(dataSet1);
    }

    private DataSet getFiterNullOrEqualsDataSet(DataSet dataSet0, Set<String> dimSet0) {
        RowMeta rowMeta = dataSet0.getRowMeta();
        HashSet<String> filterSet = new HashSet<String>(16);
        for (String dim : dimSet0) {
            if (rowMeta.getField("src" + dim).getDataType().equals((Object)DataType.LongType)) {
                filterSet.add("(dest" + dim + "= src" + dim + " or dest" + dim + "= null or dest" + dim + " = 0L)");
                continue;
            }
            if (rowMeta.getField("src" + dim).getDataType().equals((Object)DataType.StringType)) {
                filterSet.add("(dest" + dim + "= src" + dim + " or dest" + dim + "= null or dest" + dim + " = '' or dest" + dim + " =' ')");
                continue;
            }
            filterSet.add("(dest" + dim + "= src" + dim + " or dest" + dim + "= null)");
        }
        dataSet0 = dataSet0.where(String.join((CharSequence)"and", filterSet));
        dataSet0 = dataSet0.select("entryid,destbookdate,srcentryid,billno,baseunit,bookdate,auditdate,costsubelement," + this.currentSrcVarsStr);
        return dataSet0;
    }

    private Set<String> getSrcDestDimSet(Set<String> dimSet0, String src) {
        HashSet<String> asDims = new HashSet<String>(16);
        for (String dim : dimSet0) {
            asDims.add(dim + " " + src + dim);
        }
        return asDims;
    }

    public void updateCostRecordCost(Set<Long> bizBillIds, Map<Long, BigDecimal> entryBaseQtyMap, Map<Long, Integer> entryAmtPrecision, List<CostPriceResultInfo> resultInfos) {
        if (resultInfos == null || resultInfos.size() == 0) {
            return;
        }
        ArrayList<Object[]> costRecordDetailUpdateList = new ArrayList<Object[]>(16);
        HashSet<Long> costRecordDetailEntryIdSet = new HashSet<Long>(16);
        HashMap<Long, Map<String, BigDecimal>> costRecordEntryUpdateMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        List allCostEle = CostElementHelper.getAllCostEle4InitBill();
        for (CostPriceResultInfo costPriceResultInfo : resultInfos) {
            boolean isSuccess = costPriceResultInfo.isSuccess();
            boolean isDetail = costPriceResultInfo.isDetail();
            long entryId = costPriceResultInfo.getEntryId();
            BigDecimal baseqty = entryBaseQtyMap.get(entryId);
            int amtprecision = entryAmtPrecision.get(entryId);
            if (!isSuccess) continue;
            if (isDetail) {
                costRecordDetailEntryIdSet.add(entryId);
                Map costSubElementUnitCost = costPriceResultInfo.getCostSubElementUnitcostMap();
                for (Long[] longs : allCostEle) {
                    Long costSubElementId = longs[0];
                    BigDecimal unitCost = (BigDecimal)costSubElementUnitCost.get(costSubElementId);
                    if (unitCost == null) {
                        costRecordDetailUpdateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, entryId, costSubElementId});
                        continue;
                    }
                    BigDecimal actCost = unitCost.multiply(baseqty).setScale(amtprecision, RoundingMode.HALF_UP);
                    costRecordDetailUpdateList.add(new Object[]{unitCost, actCost, entryId, costSubElementId});
                }
                continue;
            }
            Map entryUnitCostMap = costPriceResultInfo.getEntryUnitcostMap();
            if (entryUnitCostMap == null || entryUnitCostMap.isEmpty()) continue;
            costRecordEntryUpdateMap.put(entryId, entryUnitCostMap);
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizBillIds)});){
            ctx.set();
            if (!costRecordDetailUpdateList.isEmpty() && !costRecordDetailEntryIdSet.isEmpty()) {
                this.updateCostDetail(costRecordDetailUpdateList, costRecordDetailEntryIdSet.toArray(new Long[0]));
            }
            if (!costRecordEntryUpdateMap.isEmpty()) {
                this.updateCostEntry(costRecordEntryUpdateMap);
            }
        }
    }

    private void updateCostDetail(List<Object[]> costRecordDetailUpdateList, Long[] costRecordDetailEntryIds) {
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailUpdateSql, costRecordDetailUpdateList);
        CostElementHelper.calCostRecordAllCost((Long[])costRecordDetailEntryIds);
    }

    private void updateCostEntry(Map<Long, Map<String, BigDecimal>> costRecordEntryUpdateMap) {
        ArrayList<Object[]> costRecordMaterialDetailUpdateList = new ArrayList<Object[]>(16);
        QFilter q = new QFilter("entry.id", "in", costRecordEntryUpdateMap.keySet());
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"entry.id,entry.baseqty,entry.unitmaterialcost,entry.materialcost,entry.unitfee,entry.fee,entry.unitprocesscost,entry.processcost,entry.unitmanufacturecost,entry.manufacturecost,entry.unitresource,entry.resource,entry.unitactualcost,entry.actualcost,localcurrency.amtprecision", (QFilter[])q.toArray());
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject costRecord : costRecords) {
            ids.add(costRecord.getLong("id"));
            int amtPrecision = costRecord.getInt("localcurrency.amtprecision");
            DynamicObjectCollection costRecordRows = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject costRecordRow : costRecordRows) {
                BigDecimal baseqty = costRecordRow.getBigDecimal("baseqty");
                Object entryId = costRecordRow.get("id");
                Map<String, BigDecimal> map = costRecordEntryUpdateMap.get(entryId);
                if (map == null) continue;
                for (Map.Entry<String, BigDecimal> entry : map.entrySet()) {
                    costRecordRow.set(entry.getKey().trim(), (Object)entry.getValue());
                    String amount = entry.getKey().trim().replaceAll("^unit", "");
                    if (!costRecordRow.getDataEntityType().getProperties().containsKey((Object)amount)) continue;
                    costRecordRow.set(amount, (Object)baseqty.multiply(entry.getValue()).setScale(amtPrecision, RoundingMode.HALF_UP));
                }
                BigDecimal unitmaterialcost = costRecordRow.getBigDecimal("unitmaterialcost");
                BigDecimal unitfee = costRecordRow.getBigDecimal("unitfee");
                BigDecimal unitprocesscost = costRecordRow.getBigDecimal("unitprocesscost");
                BigDecimal unitmanufacturecost = costRecordRow.getBigDecimal("unitmanufacturecost");
                BigDecimal unitresource = costRecordRow.getBigDecimal("unitresource");
                BigDecimal unitactualcost = costRecordRow.getBigDecimal("unitactualcost");
                BigDecimal actualcost = costRecordRow.getBigDecimal("actualcost");
                if (map.containsKey("unitactualcost")) {
                    unitmaterialcost = unitactualcost.subtract(unitprocesscost).subtract(unitfee).subtract(unitmanufacturecost).subtract(unitresource);
                    costRecordRow.set("unitmaterialcost", (Object)unitmaterialcost);
                    costRecordRow.set("materialcost", (Object)unitmaterialcost.multiply(baseqty).setScale(amtPrecision, RoundingMode.HALF_UP));
                } else {
                    unitactualcost = unitmaterialcost.add(unitfee).add(unitprocesscost).add(unitmanufacturecost).add(unitresource);
                    actualcost = unitactualcost.multiply(baseqty).setScale(amtPrecision, RoundingMode.HALF_UP);
                    costRecordRow.set("unitactualcost", (Object)unitactualcost);
                    costRecordRow.set("actualcost", (Object)actualcost);
                }
                Object[] updateObjects = new Object[]{unitactualcost, actualcost, entryId, this.costSubElementId};
                costRecordMaterialDetailUpdateList.add(updateObjects);
            }
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            SaveServiceHelper.save((DynamicObject[])costRecords);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailUpdateSql, costRecordMaterialDetailUpdateList);
        }
    }

    private Object getRealExp(String srcPriceExp) {
        if ("cal_balance".equals(this.currentEntityTypeNum)) {
            srcPriceExp = srcPriceExp.contains("periodinqty") ? "case when periodbeginqty+periodinqty =0 then 0 else (periodbeginactualcost+periodinactualcost)/(periodbeginqty+periodinqty) end " : "case when periodbeginqty =0 then 0 else periodbeginactualcost/periodbeginqty end ";
        } else if ("cal_recentcost".equals(this.currentEntityTypeNum)) {
            if (srcPriceExp.contains("recentqty")) {
                srcPriceExp = "case when recentqty =0 then 0 else recentcost/recentqty end ";
            }
        } else {
            String[] vars;
            for (String var : vars = srcPriceExp.split(splitReg)) {
                if (StringUtils.isEmpty((String)var)) continue;
                srcPriceExp = srcPriceExp.replaceAll(this.replaceReg.replace("aa", var), "entry." + var.trim());
            }
        }
        return srcPriceExp;
    }

    private Set<String> getSrcVars(String srcPriceExp) {
        HashSet<String> srcVarSet = new HashSet<String>(16);
        if (!this.currentIsDetail && "cal_costrecord_subentity".equals(this.currentEntityTypeNum)) {
            String[] srcVars;
            for (String string : srcVars = srcPriceExp.split(splitReg)) {
                if (!StringUtils.isNotEmpty((String)string)) continue;
                srcVarSet.add("entry." + string.trim());
            }
        } else {
            String[] srcVars;
            for (String string : srcVars = srcPriceExp.split(splitReg)) {
                if (!StringUtils.isNotEmpty((String)string)) continue;
                srcVarSet.add(string.trim());
            }
        }
        return srcVarSet;
    }

    protected DataSet getSrcDataSet(DynamicObject schemeEntryRow, Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> bizBillIds, Set<Long> destEntryIds, Date maxBookdate, Long schemeId) {
        String invOrgKey;
        DataEntityPropertyCollection properties;
        List<Long> costRecordInvOrgIds;
        QFilter filter = this.getSrcFilter(costAccountIds, materialIds, bizBillIds, destEntryIds, maxBookdate);
        String periodInFields = ",0 as periodinqty, 0 as periodinactualcost";
        if (this.currentSrcVarsStr.contains("periodinqty") && !this.isNewBalance) {
            periodInFields = ",periodinqty,periodinactualcost";
        } else if (this.currentSrcVarsStr.contains("periodinqty") && this.isNewBalance) {
            periodInFields = ",baseqty_in as periodinqty,actualcost_in as periodinactualcost";
        }
        Object tempDataSet = null;
        Object beginTempDataSet = null;
        Object endTempDataSet = null;
        DataSet srcDataSet = null;
        DataSet beginDataSet = null;
        DataSet endDataSet = null;
        QueryInvOrgHelper queryInvOrgHelper = new QueryInvOrgHelper();
        Boolean invOrgSplit = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.GET_PRICE_INVORG_SPLIT);
        DynamicObject scheme = (DynamicObject)schemeEntryRow.getParent();
        String priceDimension = scheme.getString("pricedimension");
        if (invOrgSplit.booleanValue() && bizBillIds.size() > 0 && ("B".equals(priceDimension) || "C".equals(priceDimension)) && !(costRecordInvOrgIds = queryInvOrgHelper.getCostRecordBillInvOrgIdListByBizBill(bizBillIds)).isEmpty() && (properties = EntityMetadataCache.getDataEntityType((String)this.currentEntityTypeNum).getProperties()).containsKey((Object)(invOrgKey = "storageorgunit"))) {
            filter.and(new QFilter(invOrgKey, "in", costRecordInvOrgIds));
        }
        try {
            String priceType;
            if (this.currentIsDetail) {
                Set<Long> currentSubElements = this.currentSubElementsMap.get(schemeId);
                if ("cal_costrecord_subentity".equals(this.currentEntityTypeNum)) {
                    if (currentSubElements != null && currentSubElements.size() > 0) {
                        filter.and("entry.subentrycostelement.costsubelement", "in", currentSubElements);
                    }
                    String priceType2 = this.currentCostPriceType.getString("entry.type");
                    int beforePeriodInt = this.currentCostPriceType.getInt("entry.beforeperiod");
                    List<QFilter> filters = this.getBeforePeriodFilters(beforePeriodInt, priceType2, filter, maxBookdate, costAccountIds);
                    if (filters.size() == 1) {
                        srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-costrecord"), (String)"cal_costrecord_subentity", (String)(this.selectFields("cal_costrecord_subentity") + ",entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_baseqty as baseqty,entry.subentrycostelement.sub_actualcost as actualcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost"), (QFilter[])filters.get(0).toArray(), null).where("unitactualcost <> null and unitactualcost <> 0");
                    } else {
                        ArrayList<OrmInput> ormInputs = new ArrayList<OrmInput>(16);
                        for (QFilter qFilter : filters) {
                            OrmInput input = new OrmInput(this.getClass().getName() + "-costrecord", "cal_costrecord_subentity", this.selectFields("cal_costrecord_subentity") + ",entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_baseqty as baseqty,entry.subentrycostelement.sub_actualcost as actualcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost", qFilter.toArray());
                            ormInputs.add(input);
                        }
                        if (!ormInputs.isEmpty()) {
                            srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])ormInputs.toArray(new OrmInput[0])).where("unitactualcost <> null and unitactualcost <> 0");
                        }
                    }
                } else if ("cal_balance".equals(this.currentEntityTypeNum)) {
                    QFilter qend;
                    if (this.isNewBalance) {
                        qend = this.getEndBalanceFilter(costAccountIds).and(filter);
                        DataSet endDetailDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qend));
                        if (currentSubElements != null && currentSubElements.size() > 0) {
                            endDetailDataSet = endDetailDataSet.where(new QFilter("costsubelement", "in", currentSubElements).toString());
                        }
                        endDetailDataSet = endDetailDataSet.select(this.selectFields("cal_balance_base") + ",costsubelement,actualcost_bal as periodbeginactualcost,baseqty_bal as periodbeginqty,0 as periodinqty, 0 as periodinactualcost");
                        QFilter qbegin = this.getBeginBalanceFilter(costAccountIds).and(filter);
                        DataSet beginDetailDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qbegin));
                        if (currentSubElements != null && currentSubElements.size() > 0) {
                            beginDetailDataSet = beginDetailDataSet.where(new QFilter("costsubelement", "in", currentSubElements).toString());
                        }
                        beginDetailDataSet = beginDetailDataSet.select(this.selectFields("cal_balance_base") + ",costsubelement,actualcost as periodbeginactualcost,baseqty as periodbeginqty,baseqty_in as periodinqty, actualcost_in as periodinactualcost");
                        srcDataSet = beginDetailDataSet.union(endDetailDataSet).groupBy((this.selectFields(this.currentEntityTypeNum) + ",costsubelement").split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                    } else {
                        if (currentSubElements != null && currentSubElements.size() > 0) {
                            filter.and("entryentity.costsubelement", "in", currentSubElements);
                        }
                        qend = this.getEndBalanceFilter(costAccountIds).and(filter);
                        endDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balanceend"), (String)"cal_balance_subentity", (String)(this.selectFields("cal_balance_base") + ",entryentity.costsubelement as costsubelement,entryentity.sub_periodendactualcost as periodbeginactualcost,entryentity.sub_periodendqty as periodbeginqty,0 as periodinqty, 0 as periodinactualcost"), (QFilter[])qend.toArray(), null);
                        QFilter qbegin = this.getBeginBalanceFilter(costAccountIds).and(filter);
                        beginDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balancebegin"), (String)"cal_balance_subentity", (String)(this.selectFields("cal_balance_base") + ",entryentity.costsubelement as costsubelement,entryentity.sub_periodbeginactualcost as periodbeginactualcost,entryentity.sub_periodbeginqty as periodbeginqty,entryentity.sub_periodinqty as periodinqty, entryentity.sub_periodinactualcost as periodinactualcost"), (QFilter[])qbegin.toArray(), null);
                        srcDataSet = beginDataSet.union(endDataSet).groupBy((this.selectFields("cal_balance") + ",costsubelement").split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                    }
                } else if ("cal_recentcost".equals(this.currentEntityTypeNum)) {
                    if (currentSubElements != null && currentSubElements.size() > 0) {
                        filter.and("costsubelement", "in", currentSubElements);
                    }
                    srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-recentcost"), (String)"cal_recentcost", (String)(this.selectFields("cal_recentcost") + ",costsubelement," + this.currentSrcVarsStr), (QFilter[])filter.toArray(), null);
                }
            } else if ("cal_balance".equals(this.currentEntityTypeNum)) {
                QFilter qbegin;
                QFilter qend;
                if (this.isNewBalance) {
                    qend = this.getEndBalanceFilter(costAccountIds).and(filter);
                    endDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qend)).select(this.selectFields("cal_balance_base") + ",actualcost_bal as periodbeginactualcost,baseqty_bal as periodbeginqty,0 as periodinqty,0 as periodinactualcost").groupBy(this.selectFields("cal_balance").split(",")).max("periodbeginqty").max("periodinqty").sum("periodbeginactualcost").sum("periodinactualcost").finish();
                    qbegin = this.getBeginBalanceFilter(costAccountIds).and(filter);
                    beginDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qbegin)).select(this.selectFields("cal_balance_base") + ",actualcost as periodbeginactualcost,baseqty as periodbeginqty,baseqty_in as periodinqty, actualcost_in as periodinactualcost").groupBy(this.selectFields("cal_balance").split(",")).max("periodbeginqty").max("periodinqty").sum("periodbeginactualcost").sum("periodinactualcost").finish();
                    srcDataSet = endDataSet.union(beginDataSet).groupBy(this.selectFields(this.currentEntityTypeNum).split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0").select(this.selectFields("cal_balance") + ",0 as costsubelement,periodbeginactualcost,periodbeginqty,periodinqty,periodinactualcost");
                } else {
                    qend = this.getEndBalanceFilter(costAccountIds).and(filter);
                    endDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balanceend"), (String)"cal_balance", (String)(this.selectFields("cal_balance_base") + ",periodendactualcost as periodbeginactualcost,periodendqty as periodbeginqty,0 as periodinqty,0 as periodinactualcost"), (QFilter[])qend.toArray(), null);
                    qbegin = this.getBeginBalanceFilter(costAccountIds).and(filter);
                    beginDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balancebegin"), (String)"cal_balance", (String)(this.selectFields("cal_balance_base") + ",periodbeginactualcost,periodbeginqty" + periodInFields), (QFilter[])qbegin.toArray(), null);
                    srcDataSet = endDataSet.union(beginDataSet).groupBy(this.selectFields("cal_balance").split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0").select(this.selectFields("cal_balance") + ",0 as costsubelement,periodbeginactualcost,periodbeginqty,periodinqty,periodinactualcost");
                }
            } else if ("cal_recentcost".equals(this.currentEntityTypeNum)) {
                srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-recentcost"), (String)"cal_recentcost", (String)(this.selectFields("cal_recentcost") + ",0 as costsubelement," + this.currentSrcVarsStr), (QFilter[])filter.toArray(), null);
            } else if ("cal_costrecord_subentity".equals(this.currentEntityTypeNum)) {
                priceType = this.currentCostPriceType.getString("entry.type");
                int beforePeriodInt = this.currentCostPriceType.getInt("entry.beforeperiod");
                List<QFilter> filters = this.getBeforePeriodFilters(beforePeriodInt, priceType, filter, maxBookdate, costAccountIds);
                if (filters.size() == 1) {
                    srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-costrecord"), (String)"cal_costrecord", (String)(this.selectFields("cal_costrecord_subentity") + ",0 as costsubelement," + this.currentSrcVarsStr), (QFilter[])filters.get(0).toArray(), null);
                } else {
                    ArrayList<OrmInput> ormInputs = new ArrayList<OrmInput>(16);
                    RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.selectFields("cal_costrecord_subentity") + ",0 as costsubelement," + this.currentSrcVarsStr);
                    rowMeta.getField("costsubelement").setDataType((DataType)DataType.LongType);
                    for (QFilter qFilter : filters) {
                        OrmInput input = new OrmInput(this.getClass().getName() + "-costrecord", "cal_costrecord", this.selectFields("cal_costrecord_subentity") + ",0 as costsubelement," + this.currentSrcVarsStr, qFilter.toArray(), rowMeta);
                        ormInputs.add(input);
                    }
                    if (!ormInputs.isEmpty()) {
                        srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])ormInputs.toArray(new OrmInput[0]));
                    }
                }
            }
            if (srcDataSet == null) {
                priceType = null;
                return priceType;
            }
            priceType = this.currentCostPriceType.getString("entry.type");
            boolean isNotManual = !priceType.equals("C");
            Field bizBillField = srcDataSet.getRowMeta().getField("bizbillid", false);
            if (bizBillIds != null && !bizBillIds.isEmpty() && bizBillField != null && isNotManual) {
                QFilter notInFilter = new QFilter("bizbillid", "not in", bizBillIds);
                srcDataSet = srcDataSet.filter(notInFilter.toString());
            }
        }
        catch (Exception e) {
            log.error("AbstractCostPriceHelper getSrcDataSet", (Throwable)e);
            String costPriceHelper_01 = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u3010%1$s\u3011\uff0c\u4ee5\u53ca\u6210\u672c\u4ef7\u7c7b\u522b--\u5355\u4ef7\u7c7b\u522b\u8bbe\u7f6e\u9879\u3002", (String)"CostPriceHelper_02", (String)"fi-cal-business", (Object[])new Object[0]);
            costPriceHelper_01 = String.format(costPriceHelper_01, scheme.getString("number"));
            throw new KDBizException(costPriceHelper_01);
        }
        finally {
            if (tempDataSet != null) {
                tempDataSet.close();
            }
            if (endDataSet != null) {
                endDataSet.close();
            }
            if (beginDataSet != null) {
                beginDataSet.close();
            }
            if (beginTempDataSet != null) {
                beginTempDataSet.close();
            }
            if (endTempDataSet != null) {
                endTempDataSet.close();
            }
        }
        log.info("AbstractCostPriceHelper-\u53d6\u4ef7\u7f13\u5b58\u53d6\u4ef7\u6570\u636e\u6e90\u7ed3\u675f:" + this.currentCostPriceTypeName + System.currentTimeMillis());
        return srcDataSet;
    }

    private List<QFilter> getBeforePeriodFilters(Integer beforePeriod, String priceType, QFilter q, Date maxBookDate, Set<Long> costAccountIds) {
        if ("C".equals(priceType)) {
            return Collections.singletonList(new QFilter("costaccount", "in", costAccountIds).and(q));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        for (Long costAccountId : costAccountIds) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            Date startDate = null;
            Date endDate = null;
            if (beforePeriod == 0) {
                if ("B".equals(priceType)) {
                    startDate = this.costAccountPeriodBeginDateMap.get(costAccountId);
                    endDate = this.costAccountPeriodEndDateMap.get(costAccountId);
                } else {
                    endDate = this.costAccountPeriodEndDateMap.get(costAccountId);
                    if (maxBookDate != null) {
                        endDate = maxBookDate;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(endDate);
                    calendar.add(1, -1);
                    startDate = calendar.getTime();
                }
            } else if (beforePeriod > 0) {
                DynamicObjectCollection beforePeriods = this.getCurrentPeriodBeforePeriod(costAccountId);
                if (beforePeriod != null || beforePeriods.size() > 0) {
                    endDate = ((DynamicObject)beforePeriods.get(0)).getDate("enddate");
                    int size = beforePeriods.size();
                    startDate = size >= beforePeriod ? ((DynamicObject)beforePeriods.get(beforePeriod - 1)).getDate("begindate") : ((DynamicObject)beforePeriods.get(size - 1)).getDate("begindate");
                }
            }
            List costAccountBookdatefilters = DateUtils.getDateSplitFilters(startDate, endDate, (String)"bookdate");
            for (QFilter costAccountBookdatefilter : costAccountBookdatefilters) {
                costAccountBookdatefilter.and(qFilter);
                costAccountBookdatefilter.and(q);
            }
            filters.addAll(costAccountBookdatefilters);
        }
        return filters;
    }

    private DynamicObjectCollection getCurrentPeriodBeforePeriod(Long costAccountId) {
        Long currentPeriodId = this.costAccountPeriodIdMap.get(costAccountId);
        DynamicObjectCollection cols = this.beforePeriodCols.get(currentPeriodId);
        if (cols != null) {
            return cols;
        }
        QFilter periodFilter = new QFilter("periodtype", "=", (Object)this.costAccountPeriodTypeMap.get(costAccountId));
        periodFilter.and("id", "<", (Object)currentPeriodId);
        periodFilter.and("isadjustperiod", "=", (Object)false);
        cols = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{periodFilter}, (String)"id desc");
        this.beforePeriodCols.put(currentPeriodId, cols);
        return cols;
    }

    private QFilter getBeginBalanceFilter(Set<Long> costAccountIds) {
        QFilter q = null;
        for (Long costAccountId : costAccountIds) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            Integer curPeriodInt = this.costAccountPeriodIntMap.get(costAccountId);
            if (curPeriodInt != null) {
                qFilter.and("period", "=", (Object)curPeriodInt);
            } else {
                qFilter.and(QFilter.of((String)"1 <> 1", (Object[])new Object[0]));
            }
            if (q == null) {
                q = qFilter;
                continue;
            }
            q.or(qFilter);
        }
        if (q == null) {
            q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        }
        return q;
    }

    private QFilter getEndBalanceFilter(Set<Long> costAccountIds) {
        QFilter q = null;
        for (Long costAccountId : costAccountIds) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            Integer curPeriodInt = this.costAccountPeriodIntMap.get(costAccountId);
            if (curPeriodInt != null) {
                qFilter.and("period", "<", (Object)curPeriodInt);
                qFilter.and("endperiod", ">", (Object)curPeriodInt);
            } else {
                qFilter.and(QFilter.of((String)"1 <> 1", (Object[])new Object[0]));
            }
            if (q == null) {
                q = qFilter;
                continue;
            }
            q.or(qFilter);
        }
        if (q == null) {
            q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        }
        return q;
    }

    private QFilter getSrcFilter(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> bizBillIds, Set<Long> destEntryIds, Date maxBookdate) {
        QFilter filter = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        if ("cal_costrecord_subentity".equals(this.currentEntityTypeNum)) {
            filter = this.getSrcFilter4CostRecord(costAccountIds, materialIds, bizBillIds, destEntryIds, maxBookdate);
        } else if ("cal_balance".equals(this.currentEntityTypeNum)) {
            filter = this.getSrcFilter4Balance(costAccountIds, materialIds);
        } else if ("cal_recentcost".equals(this.currentEntityTypeNum)) {
            filter = this.getSrcFilter4RecentCost(costAccountIds, materialIds);
        }
        String billFilter = this.currentCostPriceType.getString("entry.billfilter_tag");
        if (StringUtils.isNotEmpty((String)billFilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billFilter, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.currentEntityTypeNum);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            filter.and(filterBuilder.getQFilter());
        }
        return filter;
    }

    private QFilter getSrcFilter4RecentCost(Set<Long> costAccountIds, Set<Long> materialIds) {
        QFilter filter = new QFilter("costaccount", "in", costAccountIds);
        filter.and("material", "in", materialIds);
        return filter;
    }

    private QFilter getSrcFilter4Balance(Set<Long> costAccountIds, Set<Long> materialIds) {
        QFilter filter = new QFilter("costaccount", "in", costAccountIds);
        filter.and("material", "in", materialIds);
        return filter;
    }

    private QFilter getSrcFilter4CostRecord(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> bizBillIds, Set<Long> destEntryIds, Date maxBookdate) {
        QFilter costRecordFilter = null;
        String priceType = this.currentCostPriceType.getString("entry.type");
        int beforePeriodInt = this.currentCostPriceType.getInt("entry.beforeperiod");
        if ("C".equals(priceType)) {
            if (destEntryIds != null && !destEntryIds.isEmpty()) {
                costRecordFilter = new QFilter("entry.id", "in", destEntryIds);
                costRecordFilter.and("bizbillid", "in", bizBillIds);
                costRecordFilter.and("entry.unitactualcost", "!=", (Object)0);
            } else {
                costRecordFilter = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            }
        } else {
            costRecordFilter = new QFilter("entry.material", "in", materialIds);
            costRecordFilter.and("billstatus", "=", (Object)"C");
            if ("A".equals(priceType)) {
                costRecordFilter.and("entry.unitactualcost", "!=", (Object)0);
            }
        }
        return costRecordFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCostPriceResults(DataSet srcDataSet, String costPriceType, Map<Long, CostPriceResultInfo> currentSchemePriceInfoMap, String schemeNum) {
        try {
            String billno;
            List<String> fieldNames;
            if ("B".equals(costPriceType)) {
                GroupbyDataSet groupbyDataSet = srcDataSet.groupBy(new String[]{"entryid", "billno", "baseunit", "auditdate", "bookdate", "costsubelement"});
                for (String string : this.currentSrcVarsStr.split(",")) {
                    groupbyDataSet = groupbyDataSet.sum(string);
                }
                srcDataSet = groupbyDataSet.finish().select("entryid,billno,baseunit,costsubelement,auditdate,bookdate," + this.currentSrcVarsStr);
            }
            if ("A".equals(costPriceType)) {
                srcDataSet = srcDataSet.where("destbookdate == null or destbookdate >= bookdate");
            }
            if ((fieldNames = Arrays.asList(srcDataSet.getRowMeta().getFieldNames())).contains("entry.baseqty")) {
                srcDataSet = srcDataSet.where("entry.baseqty <> 0");
            }
            if (fieldNames.contains("entry.unitactualcost")) {
                srcDataSet = srcDataSet.where("entry.unitactualcost <> 0");
            }
            if (fieldNames.contains("entry.actualcost")) {
                srcDataSet = srcDataSet.where("entry.actualcost <> 0");
            }
            if (fieldNames.contains("unitactualcost")) {
                srcDataSet = srcDataSet.where("unitactualcost <> 0");
            }
            if (fieldNames.contains("periodbeginqty") && !fieldNames.contains("periodinqty")) {
                srcDataSet = srcDataSet.where("periodbeginqty <> 0");
            }
            if (fieldNames.contains("periodbeginqty") && fieldNames.contains("periodinqty")) {
                srcDataSet = srcDataSet.where("periodbeginqty+periodinqty <> 0");
            }
            if (fieldNames.contains("periodbeginactualcost") && !fieldNames.contains("periodinactualcost")) {
                srcDataSet = srcDataSet.where("periodbeginactualcost <> 0");
            }
            if (fieldNames.contains("periodbeginactualcost") && fieldNames.contains("periodinactualcost")) {
                srcDataSet = srcDataSet.where("periodbeginactualcost+periodinactualcost <> 0");
            }
            if (fieldNames.contains("recentqty")) {
                srcDataSet = srcDataSet.where("recentqty <> 0");
            }
            if (fieldNames.contains("recentcost")) {
                srcDataSet = srcDataSet.where("recentcost <> 0");
            }
            if ("A".equals(costPriceType)) {
                srcDataSet = srcDataSet.groupBy(new String[]{"entryid"}).max("bookdate").finish().join(srcDataSet, JoinType.LEFT).on("entryid", "entryid").on("bookdate", "bookdate").select(new String[]{"entryid", "bookdate"}, new String[]{"auditdate", "srcentryid"}).finish().groupBy(new String[]{"entryid", "bookdate"}).max("auditdate").maxP("auditdate", "srcentryid").finish().join(srcDataSet, JoinType.LEFT).on("entryid", "entryid").on("bookdate", "bookdate").on("auditdate", "auditdate").on("srcentryid", "srcentryid").select(new String[]{"entryid"}, ("billno,baseunit,bookdate,auditdate,costsubelement," + this.currentSrcVarsStr).split(",")).finish();
            }
            srcDataSet = srcDataSet.select(("entryid,billno,baseunit,costsubelement," + this.currentSrcExt2DestVarStr).split(","));
            if (this.currentIsDetail) {
                srcDataSet = srcDataSet.where("unitactualcost <> null and unitactualcost <> 0 and unitactualcost <> 0");
                for (Row row : srcDataSet) {
                    Long entryId = row.getLong("entryid");
                    billno = row.getString("billno");
                    Long baseunit = row.getLong("baseunit");
                    Long costSubElement = row.getLong("costsubelement");
                    BigDecimal unitActualCost = row.getBigDecimal("unitactualcost");
                    CostPriceResultInfo costPriceResultInfo = currentSchemePriceInfoMap.get(entryId);
                    if (costPriceResultInfo == null) {
                        costPriceResultInfo = new CostPriceResultInfo();
                        currentSchemePriceInfoMap.put(entryId, costPriceResultInfo);
                        costPriceResultInfo.setSuccess(true);
                        costPriceResultInfo.setDetail(true);
                        costPriceResultInfo.setEntryId(entryId);
                        costPriceResultInfo.setSrcBillno(billno);
                        costPriceResultInfo.setBaseunit(baseunit);
                        costPriceResultInfo.setSrcSchemeNum(schemeNum);
                        costPriceResultInfo.setSrcPriceName(this.currentCostPriceTypeName);
                    }
                    costPriceResultInfo.putCostSubElementUnitcostMap(costSubElement, unitActualCost);
                }
            } else {
                for (Row row : srcDataSet) {
                    Long entryId = row.getLong("entryid");
                    billno = row.getString("billno");
                    Long baseunit = row.getLong("baseunit");
                    for (String field : this.currentDestVars) {
                        BigDecimal unitCost = row.getBigDecimal(field);
                        if (unitCost == null || unitCost.compareTo(BigDecimal.ZERO) == 0) continue;
                        CostPriceResultInfo costPriceResultInfo = currentSchemePriceInfoMap.get(entryId);
                        if (costPriceResultInfo == null) {
                            costPriceResultInfo = new CostPriceResultInfo();
                            currentSchemePriceInfoMap.put(entryId, costPriceResultInfo);
                            costPriceResultInfo.setSuccess(true);
                            costPriceResultInfo.setDetail(false);
                            costPriceResultInfo.setEntryId(entryId);
                            costPriceResultInfo.setSrcBillno(billno);
                            costPriceResultInfo.setBaseunit(baseunit);
                            costPriceResultInfo.setSrcSchemeNum(schemeNum);
                            costPriceResultInfo.setSrcPriceName(this.currentCostPriceTypeName);
                        }
                        costPriceResultInfo.putEntryUnitcostMap(field, unitCost);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("AbstractCostPriceHelper handleCostPriceResults", (Throwable)e);
        }
        finally {
            if (srcDataSet != null) {
                srcDataSet.close();
            }
        }
        log.info(this.getClass().getName() + "-\u5904\u7406\u53d6\u4ef7\u7ed3\u679c\u7ed3\u675f:" + this.currentCostPriceTypeName + System.currentTimeMillis());
    }

    protected String getCostPriceType(DynamicObject schemeRow) {
        String costPriceNum = schemeRow.getString("costprice");
        DynamicObject costPrice = this.costPriceTypeMap.get(costPriceNum);
        return costPrice.getString("entry.type");
    }

    protected String selectFields(String s) {
        String resultStr = "";
        switch (s) {
            case "dest": {
                resultStr = "id,bizentityobject,invscheme.zerocost,ischargeoff,entry.calentryid as calentryid,period, bizbillid,bookdate,entry.id as entryid,calorg,costaccount,entry.material as material,entry.calrange as calrange,entry.owner as owner, storageorgunit as storageorgunit, entry.warehouse as warehouse, entry.location as location, entry.lot as lot, entry.project as project, entry.assist as assist,costaccount.dividebasis.dividebasis as dividebasis,entry.caldimension.caldimension as caldimension" + this.cal_costrecord_ex.toString();
                break;
            }
            case "costadjustbilldest": {
                resultStr = "0 as bizbillid,entryentity.id as entry.id,calorg,costaccount,entryentity.material as material,entryentity.calrange as calrange,entryentity.owner as owner, entryentity.storageorgunit as storageorgunit, entryentity.warehouse as warehouse, entryentity.location as location, entryentity.lot as lot, entryentity.project as project, entryentity.assist as assist,costaccount.dividebasis.dividebasis as dividebasis,entryentity.caldimension.caldimension as caldimension" + this.cal_costadjustbill_ex.toString();
                break;
            }
            case "cal_costrecord_subentity": {
                resultStr = "bizbillid,entry.id as srcentryid,billno,entry.baseunit as baseunit,calorg,costaccount,entry.material as material,entry.calrange as calrange,entry.owner as owner, storageorgunit as storageorgunit, entry.warehouse as warehouse, entry.location as location, entry.lot as lot, entry.project as project, entry.assist as assist,bookdate,auditdate" + this.cal_costrecord_ex.toString();
                break;
            }
            case "cal_balance": {
                resultStr = "srcentryid,billno,baseunit,calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,bookdate,auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_balance_base": {
                resultStr = "0 as srcentryid,'' as billno,baseunit,calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_recentcost": {
                resultStr = "id as srcentryid,'' as billno,baseunit,calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_dim_ex;
                break;
            }
            case "base": {
                resultStr = "srcentryid,billno,baseunit,calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,bookdate,auditdate" + this.cal_dim_ex;
                break;
            }
        }
        return resultStr;
    }
}

