/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.costprice.AbstractCostPriceHelper;
import kd.fi.cal.business.costprice.GroupCostUpdate4CostPrice;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.util.CommonUtils;

public class CostPrice4CostRecordUpdateHelper
extends AbstractCostPriceHelper {
    private static Log log = LogFactory.getLog(CostPrice4CostRecordUpdateHelper.class);
    private Set<Long> costAccountIds = new HashSet<Long>(16);
    private Map<Long, Set<Long>> paramMap = null;
    private Map<Long, DynamicObject> currentPeriods = null;
    private Map<Long, CostPriceResultInfo> costPriceResultInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
    private Map<Long, BigDecimal> entryBaseQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, Integer> entryAmtPrecision = new HashMap<Long, Integer>(16);
    private Map<Long, Long> entryId2IdMap = new HashMap<Long, Long>(16);
    private Map<Long, Set<Long>> failMap = new HashMap<Long, Set<Long>>(16);
    private Set<Long> bizBillIds = new HashSet<Long>(16);
    private Date maxBookdate = null;
    private Date minBookdate = null;
    private Map<String, Set<Long>> costaccountPeriod2CalentryIdMap = new HashMap<String, Set<Long>>(16);
    private Map<String, Set<Long>> entity2BizbillidMap = new HashMap<String, Set<Long>>(16);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getPriceAndUpdate(Map<Long, Set<Long>> paramMap, Map<String, Object> schemeFilterMap) {
        this.paramMap = paramMap;
        try (AlgoContext context = Algo.newContext();){
            Map<String, Object> resultMap;
            this.init();
            log.info("CostPrice4CostRecordUpdateHelper-\u53d6\u4ef7\u5f00\u59cb!");
            DynamicObject priceScheme = this.getPriceScheme(schemeFilterMap);
            if (priceScheme == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u8fd4\u5de5\u53d6\u4ef7\u914d\u7f6e\uff0c\u51fa\u5e93\u6838\u7b97\u7ed3\u679c\u53ef\u80fd\u4e0d\u51c6\u786e\uff0c\u8bf7\u68c0\u67e5\u201c\u5b58\u8d27\u6838\u7b97>\u6838\u7b97\u914d\u7f6e>\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u201d\u3002", (String)"CostPrice4CostRecordUpdateHelper_1", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            String schemeNum = priceScheme.getString("number");
            log.info("CostPrice4CostRecordUpdateHelper-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:\u3010" + schemeNum + "\u3011\u8fdb\u884c\u53d6\u4ef7\u5f00\u59cb!");
            boolean groupCost = priceScheme.getBoolean("groupcost");
            DataSet destCostRecordDS = this.getDestCostRecordDS(groupCost);
            if (destCostRecordDS == null) {
                log.info("CostPrice4CostRecordUpdateHelper-\u5f85\u53d6\u4ef7\u6570\u636e\u4e3a\u7a7a");
                Map<String, Object> map = null;
                return map;
            }
            if (groupCost) {
                DataSet[] splitDS = destCostRecordDS.splitByFilter(new String[]{"type = 0 and invscheme.zerocost = FALSE", "type = 1 and ischargeoff = TRUE", "type = 1 and ischargeoff = FALSE"}, false);
                DataSet notGroupAndSrcDS = splitDS[0];
                DataSet destChargeOffDS = splitDS[1];
                DataSet destNotChargeOffDS = splitDS[2];
                this.getCostPrice(priceScheme, notGroupAndSrcDS);
                String destNotChargeHasPrice = this.getGroupPrice(destNotChargeOffDS);
                log.info("CostPrice4CostRecordUpdateHelper-\u666e\u901a\u76ee\u6807\u5355" + destNotChargeHasPrice);
                String destChargeHasPrice = this.getGroupPrice(destChargeOffDS);
                log.info("CostPrice4CostRecordUpdateHelper-\u51b2\u9500\u76ee\u6807\u5355" + destChargeHasPrice);
            } else {
                destCostRecordDS = destCostRecordDS.where("invscheme.zerocost = FALSE");
                this.getCostPrice(priceScheme, destCostRecordDS);
            }
            Map<String, Object> map = resultMap = this.getResultMap();
            return map;
        }
        catch (Exception e) {
            log.error("CostPrice4CostRecordUpdateHelper-\u8fd4\u5de5\u53d6\u4ef7\u5f02\u5e38", (Throwable)e);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("success", "0");
            resultMap.put("msg", CommonUtils.getLogMessage((Throwable)e));
            return resultMap;
        }
    }

    private String getGroupPrice(DataSet destDS) {
        HashMap<String, Set<Long>> dest_costaccountPeriod2CalentryIdMap = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> dest_entity2BizbillidMap = new HashMap<String, Set<Long>>(16);
        for (Row row : destDS) {
            Long bizbillid = row.getLong("bizbillid");
            String bizentityobject = row.getString("bizentityobject");
            Long costAccountid = row.getLong("costaccount");
            Long period = row.getLong("period");
            Long calentryid = row.getLong("calentryid");
            Set calentryids = dest_costaccountPeriod2CalentryIdMap.computeIfAbsent(costAccountid + "#" + period, k -> new HashSet(4));
            calentryids.add(calentryid);
            Set ids = dest_entity2BizbillidMap.computeIfAbsent(bizentityobject, k -> new HashSet(6));
            ids.add(bizbillid);
        }
        return GroupCostUpdate4CostPrice.update(dest_entity2BizbillidMap, dest_costaccountPeriod2CalentryIdMap, this.costAccountIds);
    }

    private void updateCostRecordCostIsCalculated(Set<Long> bizBillIds, ArrayList<CostPriceResultInfo> costPriceResultInfos) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (CostPriceResultInfo costPriceResultInfo : costPriceResultInfos) {
            boolean isSuccess = costPriceResultInfo.isSuccess();
            long entryId = costPriceResultInfo.getEntryId();
            if (!isSuccess) continue;
            paramsList.add(new Object[]{entryId});
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizBillIds)});){
            ctx.set();
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_calcostrecordentry set fiscalculated = '1',fcostpricesource = 'G',fdesignatedcost = '0' where fentryid = ?", paramsList);
            }
        }
    }

    private void updateBalance() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (Long entryid : this.costPriceResultInfoMap.keySet()) {
            idSet.add(this.entryId2IdMap.get(entryid));
        }
        if (this.isNewBalance) {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.COST_UPDATE_REWORK);
        } else {
            new BalanceCalculator().updateBalance4Others(this.entryId2IdMap.keySet().toArray(), BalanceSourceEnum.COST_UPDATE_REWORK, idSet);
        }
    }

    private Map<String, Object> getResultMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", "1");
        if (this.failMap.isEmpty()) {
            return resultMap;
        }
        resultMap.put("success", "0");
        HashMap<Long, String> costAccountNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> materialNameMap = new HashMap<Long, String>(16);
        HashSet<Long> failCostAccountIds = new HashSet<Long>(16);
        HashSet failMaterialIds = new HashSet(16);
        for (Map.Entry<Long, Set<Long>> entry : this.failMap.entrySet()) {
            failCostAccountIds.add(entry.getKey());
            failMaterialIds.addAll(entry.getValue());
        }
        Throwable throwable = null;
        try (DataSet costAccountDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,number,name", (QFilter[])new QFilter("id", "in", failCostAccountIds).toArray(), null);){
            for (Row row : costAccountDS) {
                costAccountNameMap.put(row.getLong("id"), row.getString("number") + "(" + row.getString("name") + ")");
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        Throwable throwable4 = null;
        try (DataSet materialDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter("id", "in", failMaterialIds).toArray(), null);){
            for (Row row : materialDS) {
                materialNameMap.put(row.getLong("id"), row.getString("number") + "(" + row.getString("name") + ")");
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        String errMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\uff0c\u8fd4\u5de5\u7269\u6599\u201c%2$s\u201d\u672a\u53d6\u5230\u8fd4\u5de5\u4ef7\u683c\u3002", (String)"CostPrice4CostRecordUpdateHelper_2", (String)"fi-cal-business", (Object[])new Object[0]);
        HashSet hashSet = new HashSet(16);
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<Long, Set<Long>> entry3 : this.failMap.entrySet()) {
            hashSet.clear();
            String costAccountName = (String)costAccountNameMap.get(entry3.getKey());
            for (Long materialid : entry3.getValue()) {
                hashSet.add(materialNameMap.get(materialid));
            }
            msg.append(String.format(errMsg, costAccountName, String.join((CharSequence)",", hashSet))).append("\r\n");
        }
        resultMap.put("msg", msg.toString());
        return resultMap;
    }

    private void getCostPrice(DynamicObject priceScheme, DataSet destCostRecordDS) {
        String priceDimension = priceScheme.getString("pricedimension");
        String schemeNum = priceScheme.getString("number");
        Long schemeId = priceScheme.getLong("id");
        try {
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            HashMap<Long, CostPriceResultInfo> currentSchemePriceInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
            for (DynamicObject schemeRow : entryentitys) {
                Set currentHasPriceEntryIds = currentSchemePriceInfoMap.keySet();
                if (!currentHasPriceEntryIds.isEmpty()) {
                    destCostRecordDS = destCostRecordDS.where(new QFilter("entryid", "not in", currentHasPriceEntryIds).toString());
                }
                HashSet<Long> materialIds = new HashSet<Long>(16);
                HashSet<Long> costAccountIds = new HashSet<Long>(16);
                HashSet<String> divideBasisStrSet = new HashSet<String>(16);
                HashSet<String> dimensionStrSet = new HashSet<String>(16);
                HashSet<Long> destEntryIds = new HashSet<Long>(16);
                DataSet destDSCopy = destCostRecordDS.copy();
                HashSet<Long> needCostPriceEntryIds = new HashSet<Long>(4);
                HashSet<Long> costRecordIds = new HashSet<Long>(4);
                for (Row row : destDSCopy) {
                    costRecordIds.add(row.getLong("id"));
                    needCostPriceEntryIds.add(row.getLong("entryid"));
                    materialIds.add(row.getLong("material"));
                    costAccountIds.add(row.getLong("costaccount"));
                    divideBasisStrSet.add(row.getString("dividebasis"));
                    dimensionStrSet.add(row.getString("caldimension"));
                    destEntryIds.add(row.getLong("entryid"));
                }
                if (destEntryIds.isEmpty()) break;
                this.prepareSrcDataSet(schemeRow);
                if (StringUtils.isNotEmpty((String)this.costPricePlugin)) {
                    this.handleCostPricePlugin(needCostPriceEntryIds, costRecordIds.toArray(new Long[0]), currentSchemePriceInfoMap);
                    continue;
                }
                DataSet srcDataSet = this.getSrcDataSet(schemeRow, costAccountIds, materialIds, this.bizBillIds, destEntryIds, this.maxBookdate, schemeId);
                if (srcDataSet == null) continue;
                String costPriceType = this.getCostPriceType(schemeRow);
                if ("C".equals(costPriceType)) {
                    srcDataSet = srcDataSet.select("srcentryid as entryid,costsubelement,billno,baseunit," + this.currentSrcVarsStr);
                    this.handleCostPriceResults(srcDataSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
                    continue;
                }
                DataSet destDsCopy2 = destCostRecordDS.copy();
                this.handlePriceDimension(priceDimension, destDsCopy2, srcDataSet, divideBasisStrSet, dimensionStrSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
            }
            this.costPriceResultInfoMap.putAll(currentSchemePriceInfoMap);
            if (!this.costPriceResultInfoMap.isEmpty()) {
                destCostRecordDS = destCostRecordDS.where(new QFilter("entryid", "not in", this.costPriceResultInfoMap.keySet()).toString());
            }
            for (Row row : destCostRecordDS) {
                Long costAccountId = row.getLong("costaccount");
                Long materialId = row.getLong("material");
                Set materialIds = this.failMap.computeIfAbsent(costAccountId, k -> new HashSet(16));
                materialIds.add(materialId);
            }
            log.info("CostPrice4CostRecordUpdateHelper-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\u8fdb\u884c\u53d6\u4ef7\u7ed3\u675f!");
            log.info("\u8fd4\u5de5\u53d6\u4ef7\u7ed3\u679c\u4e3a" + this.costPriceResultInfoMap);
            this.updateCostRecordCost(this.bizBillIds, this.entryBaseQtyMap, this.entryAmtPrecision, new ArrayList<CostPriceResultInfo>(this.costPriceResultInfoMap.values()));
            this.updateCostRecordCostIsCalculated(this.bizBillIds, new ArrayList<CostPriceResultInfo>(this.costPriceResultInfoMap.values()));
            this.updateBalance();
        }
        catch (Exception e) {
            log.error("CostPrice4CostRecordUpdateHelper-\u8fd4\u5de5\u53d6\u4ef7\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private DataSet getDestCostRecordDS(boolean groupCost) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>(16);
        for (Map.Entry<Long, Set<Long>> param : this.paramMap.entrySet()) {
            Long costAccountId = param.getKey();
            QFilter destFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            Set<Long> materialIds = param.getValue();
            if (materialIds != null && !materialIds.isEmpty()) {
                destFilter.and("entry.material", "in", param.getValue());
            }
            destFilter.and("entry.isrework", "=", (Object)"1");
            destFilter.and("isvoucher", "=", (Object)Boolean.FALSE);
            DynamicObject period = this.currentPeriods.get(costAccountId);
            if (period == null) continue;
            Date begindate = period.getDate("begindate");
            Date enddate = period.getDate("enddate");
            destFilter.and("bookdate", ">=", (Object)begindate);
            destFilter.and("bookdate", "<=", (Object)enddate);
            inputList.add(new OrmInput(this.getClass().getName(), "cal_costrecord", this.selectFields("dest") + ",localcurrency.amtprecision,entry.baseqty", destFilter.toArray()));
        }
        if (!inputList.isEmpty()) {
            Algo algo = Algo.create((String)this.getClass().getName());
            DataSet destCostRecordDS = algo.createDataSet((Input[])inputList.toArray(new OrmInput[inputList.size()]));
            DataSet copy = destCostRecordDS.copy();
            for (Row row : copy) {
                Long bizbillid = row.getLong("bizbillid");
                String bizentityobject = row.getString("bizentityobject");
                Long costAccountid = row.getLong("costaccount");
                Long period = row.getLong("period");
                Long calentryid = row.getLong("calentryid");
                Date bookdate = row.getDate("bookdate");
                if (this.minBookdate == null || this.minBookdate.after(bookdate)) {
                    this.minBookdate = bookdate;
                }
                if (this.maxBookdate == null || this.maxBookdate.before(bookdate)) {
                    this.maxBookdate = bookdate;
                }
                Set calentryids = this.costaccountPeriod2CalentryIdMap.computeIfAbsent(costAccountid + "#" + period, k -> new HashSet(4));
                calentryids.add(calentryid);
                Set ids = this.entity2BizbillidMap.computeIfAbsent(bizentityobject, k -> new HashSet(6));
                ids.add(bizbillid);
                this.bizBillIds.add(bizbillid);
                this.entryAmtPrecision.put(row.getLong("entryid"), row.getInteger("localcurrency.amtprecision"));
                this.entryBaseQtyMap.put(row.getLong("entryid"), row.getBigDecimal("entry.baseqty"));
                this.entryId2IdMap.put(row.getLong("entryid"), row.getLong("id"));
            }
            if (groupCost) {
                DataSet groupDataSet = this.getGroupDataSet();
                groupDataSet = groupDataSet.groupBy(new String[]{"costrecordentryid"}).max("Int(type)", "type").finish();
                CharSequence[] fieldNames = destCostRecordDS.getRowMeta().getFieldNames();
                destCostRecordDS = destCostRecordDS.join(groupDataSet, JoinType.LEFT).on("entryid", "costrecordentryid").select((String[])fieldNames, new String[]{"type"}).finish();
                destCostRecordDS = destCostRecordDS.select(String.join((CharSequence)",", fieldNames) + ",case when type is null then 0 else type end as type");
            }
            return destCostRecordDS;
        }
        return null;
    }

    private DataSet getGroupDataSet() {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            DataSet dataSet = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(this.entity2BizbillidMap);
            dataSet = dataSet.select("type,costrecordentryid");
            return dataSet;
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        for (Map.Entry<String, Set<Long>> entry : this.costaccountPeriod2CalentryIdMap.entrySet()) {
            String[] costaccountPeriod = entry.getKey().split("#");
            Set<Long> calentryids = entry.getValue();
            QFilter filter = new QFilter("entryentity.costaccount", "=", (Object)Long.valueOf(costaccountPeriod[0]));
            filter.and("entryentity.period", "=", (Object)Long.valueOf(costaccountPeriod[1]));
            filter.and("entryentity.calentryid", "in", calentryids);
            OrmInput input = new OrmInput(GroupCostUpdate4CostPrice.class.getName(), "cal_account_grouprecord", "entryentity.type as type, entryentity.costrecordentryid as costrecordentryid", filter.toArray());
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta("cal_account_grouprecord", "entryentity.type as type, entryentity.costrecordentryid as costrecordentryid");
            return Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        }
        DataSet dataSet = Algo.create((String)GroupCostUpdate4CostPrice.class.getName()).createDataSet(inputs.toArray(new Input[0]));
        return dataSet;
    }

    private void init() {
        for (Map.Entry<Long, Set<Long>> param : this.paramMap.entrySet()) {
            this.costAccountIds.add(param.getKey());
        }
        this.currentPeriods = PeriodHelper.getCurrentPeriods(this.costAccountIds);
    }

    private DynamicObject getPriceScheme(Map<String, Object> schemeFilterMap) {
        String entityobject = (String)schemeFilterMap.get("entityobject");
        String priceobject = (String)schemeFilterMap.get("priceobject");
        QFilter priceSchemeFilter = new QFilter("entityobject", "=", (Object)entityobject).and("priceobject", "=", (Object)priceobject);
        priceSchemeFilter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingle((String)"cal_pricescheme", (String)"id,name,number,groupcost,entityobject,billfilter_tag,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])priceSchemeFilter.toArray());
    }
}

