/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.costprice.AbstractCostPriceHelper;
import kd.fi.cal.business.costprice.PriceDimensionHelperNew;
import kd.fi.cal.common.model.CostPriceResultInfo;

public class CostPrice4Others
extends AbstractCostPriceHelper {
    private static Log log = LogFactory.getLog(CostPrice4Others.class);
    private Date maxBoodate = null;
    private Set<Long> bizBillIds = new HashSet<Long>(16);
    private String singleCostPriceNum = null;
    private PriceDimensionHelperNew priceDimensionHelperNew;
    private Map<Object, Object> entryIdCurrencyIdMap;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CostPriceResultInfo[] getPrice4MoveAddAverage(List<Long> costRecordEntryIds, QFilter q, Long[] costRecordIds) {
        if (costRecordEntryIds == null) return null;
        if (costRecordEntryIds.isEmpty()) {
            return null;
        }
        DynamicObject priceScheme = this.getPriceScheme(q);
        if (priceScheme == null) {
            return null;
        }
        log.info("CostPrice4Others-\u53d6\u4ef7\u5f00\u59cb\uff1a\u5339\u914d\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\\n\u5f85\u53d6\u4ef7\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55entryids:" + costRecordEntryIds + "\\n");
        String schemeNum = priceScheme.getString("number");
        Long priceSchemeId = priceScheme.getLong("id");
        log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:\u3010" + schemeNum + "\u3011\u8fdb\u884c\u53d6\u4ef7\u5f00\u59cb!" + System.currentTimeMillis());
        String priceDimension = priceScheme.getString("pricedimension");
        String errmsg = "";
        HashSet<Long> needCostPriceEntryIds = new HashSet<Long>(costRecordEntryIds);
        try (AlgoContext context = Algo.newContext();){
            DataSet destCostRecordDS = this.getDestCostRecordDS(costRecordEntryIds, costRecordIds);
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            HashMap<Long, CostPriceResultInfo> currentSchemePriceInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
            this.getPriceBySchemeRow(costRecordIds, schemeNum, priceDimension, needCostPriceEntryIds, destCostRecordDS, entryentitys, currentSchemePriceInfoMap, priceSchemeId);
            log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\u8fdb\u884c\u53d6\u4ef7\u7ed3\u675f!" + System.currentTimeMillis());
            log.info("CostPrice4Others-\u540c\u6b65\u5355\u636e\u53d6\u4ef7\u7ed3\u675f\uff0c\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + ((Object)currentSchemePriceInfoMap).toString() + System.currentTimeMillis());
            CostPriceResultInfo[] costPriceResultInfoArray = currentSchemePriceInfoMap.values().toArray(new CostPriceResultInfo[0]);
            return costPriceResultInfoArray;
        }
        catch (Exception e) {
            errmsg = e.getMessage();
            log.error("CostPrice4Others getPrice4MoveAddAverage", (Throwable)e);
            CostPriceResultInfo info = this.getErrorCostPriceResultInfo(errmsg);
            return new CostPriceResultInfo[]{info};
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Long, CostPriceResultInfo> getPrice4MoveAddAverage(List<Long> costRecordEntryIds, QFilter q, Long[] costRecordIds, String costPriceNumber) {
        if (costRecordEntryIds == null) return null;
        if (costRecordEntryIds.isEmpty()) {
            return null;
        }
        DynamicObject priceScheme = this.getPriceScheme(q);
        if (priceScheme == null) {
            return null;
        }
        this.singleCostPriceNum = costPriceNumber;
        log.info("CostPrice4Others-\u53d6\u4ef7\u5f00\u59cb\uff1a\u5339\u914d\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\\n\u5f85\u53d6\u4ef7\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55entryids:" + costRecordEntryIds + "\\n");
        String schemeNum = priceScheme.getString("number");
        Long priceSchemeId = priceScheme.getLong("id");
        log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:\u3010" + schemeNum + "\u3011\u8fdb\u884c\u53d6\u4ef7\u5f00\u59cb!" + System.currentTimeMillis());
        String priceDimension = priceScheme.getString("pricedimension");
        String errmsg = "";
        HashSet<Long> needCostPriceEntryIds = new HashSet<Long>(costRecordEntryIds);
        try (AlgoContext context = Algo.newContext();){
            DataSet destCostRecordDS = this.getDestCostRecordDS(costRecordEntryIds, costRecordIds);
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            HashMap<Long, CostPriceResultInfo> currentSchemePriceInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
            this.getPriceBySchemeRow(costRecordIds, schemeNum, priceDimension, needCostPriceEntryIds, destCostRecordDS, entryentitys, currentSchemePriceInfoMap, priceSchemeId);
            log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\u8fdb\u884c\u53d6\u4ef7\u7ed3\u675f!" + System.currentTimeMillis());
            log.info("CostPrice4Others-\u540c\u6b65\u5355\u636e\u53d6\u4ef7\u7ed3\u675f\uff0c\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + ((Object)currentSchemePriceInfoMap).toString() + System.currentTimeMillis());
            HashMap<Long, CostPriceResultInfo> hashMap = currentSchemePriceInfoMap;
            return hashMap;
        }
        catch (Exception e) {
            errmsg = e.getMessage();
            log.error("CostPrice4Others getPrice4MoveAddAverage", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, Map<Long, BigDecimal>> getPriceFromEntryParmsMap(List<Map<String, Object>> parms, QFilter q, String costPriceNumber) {
        if (parms == null) return null;
        if (parms.isEmpty()) {
            return null;
        }
        DynamicObject priceScheme = this.getPriceScheme(q);
        if (priceScheme == null) {
            return null;
        }
        this.singleCostPriceNum = costPriceNumber;
        log.info("CostPrice4Others-\u53d6\u4ef7\u5f00\u59cb\uff1a\u5339\u914d\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number"));
        String schemeNum = priceScheme.getString("number");
        Long priceSchemeId = priceScheme.getLong("id");
        log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:\u3010" + schemeNum + "\u3011\u8fdb\u884c\u53d6\u4ef7\u5f00\u59cb!" + System.currentTimeMillis());
        String priceDimension = priceScheme.getString("pricedimension");
        try (AlgoContext context = Algo.newContext();){
            Map<Integer, Map<Long, BigDecimal>> resultMap;
            HashSet<Long> needCostPriceEntryIds = new HashSet<Long>();
            DataSet destCostRecordDS = this.createDestDataSetByParmsMap(parms, needCostPriceEntryIds);
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            HashMap<Long, CostPriceResultInfo> currentSchemePriceInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
            this.getPriceBySchemeRow(null, schemeNum, priceDimension, needCostPriceEntryIds, destCostRecordDS, entryentitys, currentSchemePriceInfoMap, priceSchemeId);
            log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\u8fdb\u884c\u53d6\u4ef7\u7ed3\u675f!\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + ((Object)currentSchemePriceInfoMap).toString() + System.currentTimeMillis());
            Map<Integer, Map<Long, BigDecimal>> map = resultMap = this.getResultMapByCostPriceResultInfo(currentSchemePriceInfoMap.values().toArray(new CostPriceResultInfo[0]));
            return map;
        }
        catch (Exception e) {
            log.error("CostPrice4Others getPrice4MoveAddAverage", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Object, Map<String, Object>> getPriceFromEntryParmsMap(Map<Object, Map<String, Object>> params, QFilter q) {
        if (params == null) return null;
        if (params.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> parmList = new ArrayList<Map<String, Object>>(4);
        boolean isInt = true;
        String entityObject = null;
        for (Map.Entry<Object, Map<String, Object>> objectMapEntry : params.entrySet()) {
            Object rowIndex = objectMapEntry.getKey();
            Map<String, Object> map = objectMapEntry.getValue();
            String entity = (String)map.get("entityobject");
            if (rowIndex instanceof Integer) {
                isInt = true;
            } else if (rowIndex instanceof Long) {
                isInt = false;
            }
            map.put("rowIndex", rowIndex);
            parmList.add(map);
            entityObject = entity;
        }
        q.and("entityobject", "=", entityObject);
        DynamicObject priceScheme = this.getPriceScheme(q);
        if (priceScheme == null) {
            return null;
        }
        log.info("CostPrice4Others-\u53d6\u4ef7\u5f00\u59cb\uff1a\u5339\u914d\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number"));
        String schemeNum = priceScheme.getString("number");
        Long priceSchemeId = priceScheme.getLong("id");
        log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:\u3010" + schemeNum + "\u3011\u8fdb\u884c\u53d6\u4ef7\u5f00\u59cb!" + System.currentTimeMillis());
        String priceDimension = priceScheme.getString("pricedimension");
        try (AlgoContext context = Algo.newContext();){
            Map<Object, Map<String, Object>> resultMap;
            HashSet<Long> needCostPriceEntryIds = new HashSet<Long>();
            DataSet destCostRecordDS = this.createDestDataSetByParmsMap(parmList, needCostPriceEntryIds);
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            HashMap<Long, CostPriceResultInfo> currentSchemePriceInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
            this.getPriceBySchemeRow(null, schemeNum, priceDimension, needCostPriceEntryIds, destCostRecordDS, entryentitys, currentSchemePriceInfoMap, priceSchemeId);
            log.info("CostPrice4Others-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\u8fdb\u884c\u53d6\u4ef7\u7ed3\u675f!\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + ((Object)currentSchemePriceInfoMap).toString() + System.currentTimeMillis());
            Map<Object, Map<String, Object>> map = resultMap = this.getResultMapByCostPriceResultInfo(currentSchemePriceInfoMap.values().toArray(new CostPriceResultInfo[0]), isInt);
            return map;
        }
        catch (Exception e) {
            log.error("CostPrice4Others getPrice4SCM", (Throwable)e);
            throw e;
        }
    }

    private Map<Integer, Map<Long, BigDecimal>> getResultMapByCostPriceResultInfo(CostPriceResultInfo[] resultInfos) {
        HashMap<Integer, Map<Long, BigDecimal>> map = new HashMap<Integer, Map<Long, BigDecimal>>(16);
        for (CostPriceResultInfo resultInfo : resultInfos) {
            Long entryId = resultInfo.getEntryId();
            if (resultInfo.isDetail()) {
                map.put(entryId.intValue(), resultInfo.getCostSubElementUnitcostMap());
                continue;
            }
            Map entryUnitcostMap = resultInfo.getEntryUnitcostMap();
            BigDecimal actualcost = BigDecimal.ZERO;
            if (!entryUnitcostMap.isEmpty()) {
                actualcost = (BigDecimal)entryUnitcostMap.values().iterator().next();
            }
            HashMap<Long, BigDecimal> detailMap = new HashMap<Long, BigDecimal>(4);
            detailMap.put(773175233367685120L, actualcost);
            map.put(entryId.intValue(), detailMap);
        }
        return map;
    }

    private Map<Object, Map<String, Object>> getResultMapByCostPriceResultInfo(CostPriceResultInfo[] resultInfos, boolean isInt) {
        HashMap<Object, Map<String, Object>> map = new HashMap<Object, Map<String, Object>>(16);
        for (CostPriceResultInfo resultInfo : resultInfos) {
            Long entryId = resultInfo.getEntryId();
            Map entryUnitcostMap = resultInfo.getEntryUnitcostMap();
            HashMap<String, Object> resmap = new HashMap<String, Object>(4);
            Number id = entryId;
            if (isInt) {
                id = entryId.intValue();
            }
            resmap.putAll(entryUnitcostMap);
            resmap.put("unit", resultInfo.getBaseunit());
            resmap.put("currency", this.entryIdCurrencyIdMap.get(id));
            map.put(id, resmap);
        }
        return map;
    }

    private DataSet createDestDataSetByParmsMap(List<Map<String, Object>> parms, Set<Long> needCostPriceEntryIds) {
        HashMap<Object, Map<String, Object>> paramsMap = new HashMap<Object, Map<String, Object>>(16);
        for (Map<String, Object> parm : parms) {
            Object rowIndex = parm.get("rowIndex");
            paramsMap.put(rowIndex, parm);
        }
        this.priceDimensionHelperNew = new PriceDimensionHelperNew(paramsMap);
        needCostPriceEntryIds.addAll(this.priceDimensionHelperNew.getEntryids());
        this.entryIdCurrencyIdMap = this.priceDimensionHelperNew.getEntryIdCurrencyIdMap();
        return this.priceDimensionHelperNew.createDestDataSet();
    }

    public boolean isHasEnablePriceScheme(QFilter q) {
        QFilter filter = q.copy().and("enable", "=", (Object)"1");
        boolean isHasEnablePrice = QueryServiceHelper.exists((String)"cal_pricescheme", (QFilter[])filter.toArray());
        return isHasEnablePrice;
    }

    private DynamicObject getPriceScheme(QFilter q) {
        q.and("enable", "=", (Object)"1");
        DynamicObject priceScheme = BusinessDataServiceHelper.loadSingle((String)"cal_pricescheme", (String)"id,number,entityobject,billfilter_tag,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])q.toArray());
        if (priceScheme == null) {
            return null;
        }
        return priceScheme;
    }

    private CostPriceResultInfo getErrorCostPriceResultInfo(String errmsg) {
        CostPriceResultInfo info = new CostPriceResultInfo();
        info.setSuccess(false);
        String errorMsg = String.format(ResManager.loadKDString((String)"\u672a\u53d6\u5230\u4ef7\u683c\u3002\u539f\u56e0\u4e3a\uff1a%1$s", (String)"CostPriceHelper_1", (String)"fi-cal-business", (Object[])new Object[0]), errmsg);
        info.setErrMsg(errorMsg);
        return info;
    }

    private void getPriceBySchemeRow(Long[] costRecordIds, String schemeNum, String priceDimension, Set<Long> needCostPriceEntryIds, DataSet destCostRecordDS, DynamicObjectCollection entryentitys, Map<Long, CostPriceResultInfo> currentSchemePriceInfoMap, Long schemeId) {
        for (DynamicObject schemeRow : entryentitys) {
            String costPriceNum = schemeRow.getString("costprice");
            if (this.singleCostPriceNum != null && !this.singleCostPriceNum.equals(costPriceNum)) continue;
            Set<Long> currentHasPriceEntryIds = currentSchemePriceInfoMap.keySet();
            if (!currentHasPriceEntryIds.isEmpty()) {
                needCostPriceEntryIds.removeAll(currentHasPriceEntryIds);
                destCostRecordDS = destCostRecordDS.where(new QFilter("entryid", "not in", currentHasPriceEntryIds).toString());
            }
            HashSet<Long> materialIds = new HashSet<Long>(16);
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            HashSet<String> divideBasisStrSet = new HashSet<String>(16);
            HashSet<String> dimensionStrSet = new HashSet<String>(16);
            HashSet<Long> destEntryIds = new HashSet<Long>(16);
            DataSet destDSCopy = destCostRecordDS.copy();
            for (Row row : destDSCopy) {
                materialIds.add(row.getLong("material"));
                costAccountIds.add(row.getLong("costaccount"));
                divideBasisStrSet.add(row.getString("dividebasis"));
                dimensionStrSet.add(row.getString("caldimension"));
                destEntryIds.add(row.getLong("entryid"));
                Date bookdate = row.getDate("bookdate");
                Long bizbillid = row.getLong("bizbillid");
                if (bizbillid != null && bizbillid.compareTo(0L) != 0) {
                    this.bizBillIds.add(bizbillid);
                }
                if (bookdate == null || this.maxBoodate != null && !this.maxBoodate.before(bookdate)) continue;
                this.maxBoodate = bookdate;
            }
            if (destEntryIds.isEmpty()) break;
            this.prepareSrcDataSet(schemeRow);
            if (StringUtils.isNotEmpty((String)this.costPricePlugin)) {
                this.handleCostPricePlugin(needCostPriceEntryIds, costRecordIds, currentSchemePriceInfoMap);
                continue;
            }
            DataSet srcDataSet = this.getSrcDataSet(schemeRow, costAccountIds, materialIds, this.bizBillIds, destEntryIds, this.maxBoodate, schemeId);
            if (srcDataSet == null) continue;
            String costPriceType = this.getCostPriceType(schemeRow);
            if ("C".equals(costPriceType)) {
                srcDataSet = srcDataSet.select("srcentryid as entryid,costsubelement,billno,baseunit," + this.currentSrcVarsStr);
                this.handleCostPriceResults(srcDataSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
                continue;
            }
            DataSet destDsCopy2 = destCostRecordDS.copy();
            this.handlePriceDimension(priceDimension, destDsCopy2, srcDataSet, divideBasisStrSet, dimensionStrSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
        }
    }

    private DataSet getDestCostRecordDS(List<Long> costRecordEntryIds, Long[] costRecordIds) {
        QFilter qbill = new QFilter("entry.id", "in", costRecordEntryIds);
        if (costRecordIds != null && costRecordIds.length != 0) {
            qbill.and("id", "in", (Object)costRecordIds);
        }
        qbill.and(new QFilter("calbilltype", "=", (Object)"OUT").or("entry.ispresent", "=", (Object)"0"));
        DataSet destDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)this.selectFields("dest"), (QFilter[])qbill.toArray(), null);
        return destDataSet;
    }
}

