/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.business.costprice.PriceDimensionHelperNew;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class CostPrice4SCMHelper {
    private static Log log = LogFactory.getLog(CostPrice4SCMHelper.class);
    private static final long CAL_PRICELIB_PAGEID = 747819409392815104L;
    private Set<Object> materialIds = new HashSet<Object>(16);
    private Set<Object> storageorgunitIds = new HashSet<Object>(16);
    private Set<Long> costAccountIds = new HashSet<Long>(16);
    private Map<String, DataSet> srcDataSetMap = new HashMap<String, DataSet>(16);
    private Map<String, String> srcPriceVars = new HashMap<String, String>(16);
    private Map<String, String> srcExp2DestVars = new HashMap<String, String>(16);
    private Map<Object, Map<String, Object>> resultMap = new HashMap<Object, Map<String, Object>>(16);
    private Map<String, DynamicObject> costPriceMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> priceLibMap = new HashMap<String, DynamicObject>(16);
    private Map<Object, Map<String, Object>> params = null;
    private Map<String, DynamicObject> priceSchemes = new HashMap<String, DynamicObject>(16);
    private PriceDimensionHelperNew priceDimensionHelper = null;
    private Map<Long, DynamicObject> currentPeriodMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Long> currentPeriodTypeMap = new HashMap<Long, Long>(16);
    private Map<Long, DynamicObjectCollection> beforePeriodCols = new HashMap<Long, DynamicObjectCollection>(16);
    private StringBuilder cal_balance_ex = new StringBuilder();
    private StringBuilder cal_costrecord_ex = new StringBuilder();
    private Map<Object, Object> entryIdCurrencyIdMap = new HashMap<Object, Object>(16);
    private Date maxBookDate = null;
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Boolean get_scm_price_null2zero = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.GET_SCM_PRICE_NULL2ZERO);

    public Map<Object, Map<String, Object>> getCostPriceFromMap4SCM(Map<Object, Map<String, Object>> params) {
        log.info("\u53d6\u4ef7\u53c2\u6570\u4e3a:" + params);
        this.params = params;
        this.priceDimensionHelper = new PriceDimensionHelperNew(params);
        this.materialIds = this.priceDimensionHelper.getMaterialIds();
        this.storageorgunitIds = this.priceDimensionHelper.getStorageorgunitIds();
        this.costAccountIds = this.priceDimensionHelper.getCostAccountIds();
        if (this.costAccountIds == null || this.costAccountIds.isEmpty()) {
            log.error("\u53d6\u4ef7\u672a\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7\uff0c\u6216\u8005\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u7684\u8d26\u7c3f");
            return this.resultMap;
        }
        this.maxBookDate = this.priceDimensionHelper.getMaxBookdate();
        Set<String> entityObjects = this.priceDimensionHelper.getEntityObjects();
        this.entryIdCurrencyIdMap = this.priceDimensionHelper.getEntryIdCurrencyIdMap();
        this.buildPriceSchemesCache(entityObjects);
        this.buildSrcCostPriceDataCache();
        this.getCostPriceResult();
        log.info("\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + this.resultMap);
        return this.resultMap;
    }

    public Map<Object, Map<String, Object>> getCostPriceFromMap4ExtSys(String priceObject, Map<Object, Map<String, Object>> params) {
        if (StringUtils.isEmpty((String)priceObject)) {
            return this.resultMap;
        }
        log.info("\u53d6\u4ef7\u53c2\u6570\u4e3a:" + params);
        this.params = params;
        this.priceDimensionHelper = new PriceDimensionHelperNew(params);
        this.materialIds = this.priceDimensionHelper.getMaterialIds();
        this.storageorgunitIds = this.priceDimensionHelper.getStorageorgunitIds();
        this.costAccountIds = this.priceDimensionHelper.getCostAccountIds();
        if (this.costAccountIds == null || this.costAccountIds.isEmpty()) {
            log.error("\u53d6\u4ef7\u672a\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7\uff0c\u6216\u8005\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u7684\u8d26\u7c3f");
            return this.resultMap;
        }
        this.maxBookDate = this.priceDimensionHelper.getMaxBookdate();
        Set<String> entityObjects = this.priceDimensionHelper.getEntityObjects();
        this.entryIdCurrencyIdMap = this.priceDimensionHelper.getEntryIdCurrencyIdMap();
        this.buildPriceSchemesCache(entityObjects, priceObject);
        this.buildSrcCostPriceDataCache();
        this.getCostPriceResult();
        log.info("\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + this.resultMap);
        return this.resultMap;
    }

    private void buildPriceSchemesCache(Set<String> entityObjects, String priceObject) {
        DynamicObject[] costPriceSchemes;
        QFilter schemeFilter = new QFilter("priceobject", "=", (Object)priceObject);
        schemeFilter.and("enable", "=", (Object)"1");
        schemeFilter.and("entityobject", "in", entityObjects);
        for (DynamicObject dynamicObject : costPriceSchemes = BusinessDataServiceHelper.load((String)"cal_pricescheme", (String)"entityobject,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])schemeFilter.toArray())) {
            DynamicObject entityobject = dynamicObject.getDynamicObject("entityobject");
            if (entityobject == null) continue;
            this.priceSchemes.put(entityobject.getString("number"), dynamicObject);
        }
    }

    private void getCostPriceResult() {
        block0: for (Map.Entry<Object, Map<String, Object>> entryMap : this.params.entrySet()) {
            DynamicObject priceScheme;
            Object entryId = entryMap.getKey();
            Map<String, Object> paramMap = entryMap.getValue();
            String entityObject = (String)paramMap.get("entityobject");
            Object calOrg = paramMap.get("calorg");
            if (calOrg == null || (priceScheme = this.priceSchemes.get(entityObject)) == null) continue;
            String dimension = priceScheme.getString("pricedimension");
            Set<String> dimensionSet = this.priceDimensionHelper.getPriceDimension(paramMap, dimension);
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            for (DynamicObject cp : entryentitys) {
                boolean hasPrice;
                String costPriceNum = cp.getString("costprice");
                String srcVars = this.srcPriceVars.get(entityObject + "_" + costPriceNum);
                String srcExp2Dest = this.srcExp2DestVars.get(entityObject + "_" + costPriceNum);
                DataSet srcRowDataSet = this.srcDataSetMap.get(entityObject + "_" + costPriceNum);
                DynamicObject costPrice = this.costPriceMap.get(costPriceNum);
                String srcBillType = costPrice.getString("entry.entityobject.number");
                String priceType = costPrice.getString("entry.type");
                if (srcRowDataSet == null) continue;
                srcRowDataSet = srcRowDataSet.copy();
                RowMeta rowMeta = srcRowDataSet.getRowMeta();
                if ("cal_recentcost".equals(srcBillType)) {
                    QFilter recentCostFilter = this.priceDimensionHelper.getRecentCostFilter(paramMap, dimension, rowMeta);
                    log.info("\u5916\u90e8\u5355\u636e\u5206\u5f55\u53d6\u5373\u65f6\u6210\u672c\u8fc7\u6ee4\u6761\u4ef6\uff1a" + recentCostFilter);
                    srcRowDataSet = srcRowDataSet.where(recentCostFilter.toString());
                } else {
                    QFilter dimFilter = null;
                    for (String dim : dimensionSet) {
                        QFilter q;
                        Object dimValue = paramMap.get(dim);
                        if (dimValue != null && !"".equals(dimValue)) {
                            q = new QFilter(dim, "=", dimValue);
                            if (dimFilter == null) {
                                dimFilter = q;
                                continue;
                            }
                            dimFilter.and(q);
                            continue;
                        }
                        if (!this.get_scm_price_null2zero.booleanValue() || !paramMap.containsKey(dim) || !(rowMeta.getField(dim).getDataType() instanceof LongType)) continue;
                        q = new QFilter(dim, "=", (Object)0).or(dim, "=", null);
                        if (dimFilter == null) {
                            dimFilter = q;
                            continue;
                        }
                        dimFilter.and(q);
                    }
                    if (dimFilter != null) {
                        srcRowDataSet = srcRowDataSet.where(dimFilter.toString());
                    }
                }
                if (srcRowDataSet.copy().isEmpty()) continue;
                if ("A".equals(priceType)) {
                    srcRowDataSet = srcRowDataSet.orderBy("bookdate desc,auditdate desc".split(",")).top(1);
                } else if ("B".equals(priceType)) {
                    if ("cal_recentcost".equals(srcBillType)) {
                        srcRowDataSet = srcRowDataSet.groupBy(new String[]{"costsubelement"}).max("baseunit").sum("recentqty").sum("recentcost").finish();
                        srcRowDataSet = srcRowDataSet.groupBy().max("baseunit").max("recentqty").sum("recentcost").finish();
                    } else {
                        GroupbyDataSet groupbyDataSet = srcRowDataSet.groupBy(new String[]{"baseunit"});
                        for (String var : srcVars.split(",")) {
                            groupbyDataSet = groupbyDataSet.sum(var);
                        }
                        srcRowDataSet = groupbyDataSet.finish();
                    }
                }
                if (!(hasPrice = this.hasPrice(srcRowDataSet.copy()))) continue;
                srcRowDataSet = srcRowDataSet.select(("baseunit," + srcExp2Dest).split(","));
                Row srcRow = srcRowDataSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                String[] fields = srcRowDataSet.getRowMeta().getFieldNames();
                Long unit = 0L;
                for (int i = 0; i < fields.length; ++i) {
                    if ("baseunit".equals(fields[i])) {
                        unit = srcRow.getLong("baseunit");
                        continue;
                    }
                    if (((BigDecimal)srcRow.get(i)).signum() < 0) continue;
                    map.put(fields[i].trim(), srcRow.get(i));
                }
                Object currencyId = this.entryIdCurrencyIdMap.get(entryId);
                if (map.isEmpty() || currencyId == null) continue;
                map.put("currency", currencyId);
                map.put("unit", unit);
                this.resultMap.put(entryId, map);
                continue block0;
            }
        }
    }

    private void buildSrcCostPriceDataCache() {
        this.createPriceLibMap();
        this.createCostPriceMap();
        this.createCostAccountCurrentPeriods();
        this.createSrcDataMap();
    }

    private void buildPriceSchemesCache(Set<String> entityObjects) {
        DynamicObject[] costPriceSchemes;
        QFilter schemeFilter = new QFilter("priceobject", "=", (Object)"G");
        schemeFilter.and("enable", "=", (Object)"1");
        schemeFilter.and("entityobject", "in", entityObjects);
        for (DynamicObject dynamicObject : costPriceSchemes = BusinessDataServiceHelper.load((String)"cal_pricescheme", (String)"entityobject,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])schemeFilter.toArray())) {
            DynamicObject entityobject = dynamicObject.getDynamicObject("entityobject");
            if (entityobject == null) continue;
            this.priceSchemes.put(entityobject.getString("number"), dynamicObject);
        }
    }

    public CostPrice4SCMHelper() {
        String dividebasisStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] calRealDims = (dividebasisStr + "," + caldimensionStr).split(",");
        MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        List<String> calDimList = Arrays.asList("calorg,costaccount,material,owner,storageorgunit,warehouse,location,lot,project,assist".split(","));
        for (String dim : calRealDims) {
            if (calDimList.contains(dim)) continue;
            this.cal_balance_ex.append(",");
            this.cal_balance_ex.append(dim);
            IDataEntityProperty dataEntity = billDataEntity.findProperty(dim);
            if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
                this.cal_costrecord_ex.append(",");
                this.cal_costrecord_ex.append(dataEntity.getParent().getName());
                this.cal_costrecord_ex.append(".");
                this.cal_costrecord_ex.append(dim);
                this.cal_costrecord_ex.append(" as ");
                this.cal_costrecord_ex.append(dim);
                continue;
            }
            this.cal_costrecord_ex.append(",");
            this.cal_costrecord_ex.append(dim);
        }
    }

    private void createCostAccountCurrentPeriods() {
        this.currentPeriodMap = PeriodHelper.getCurrentPeriods(this.costAccountIds);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> removeKeySet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> mapEntry : this.currentPeriodMap.entrySet()) {
            DynamicObject period = mapEntry.getValue();
            Long currentCostaccountId = mapEntry.getKey();
            if (period == null) {
                removeKeySet.add(currentCostaccountId);
                continue;
            }
            periodIds.add(period.getLong("id"));
        }
        for (Long long1 : removeKeySet) {
            this.currentPeriodMap.remove(long1);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id,periodtype", (QFilter[])new QFilter("id", "in", periodIds).toArray(), null);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                Long periodType = row.getLong("periodtype");
                this.currentPeriodTypeMap.put(id, periodType);
            }
        }
    }

    private void createSrcDataMap() {
        for (DynamicObject priceScheme : this.priceSchemes.values()) {
            String entityObject = priceScheme.getDynamicObject("entityobject").getString("number");
            String priceDimension = priceScheme.getString("pricedimension");
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            if (entryentitys == null || entryentitys.size() <= 0) continue;
            for (DynamicObject dynamicObject : entryentitys) {
                Boolean invOrgSplit;
                String costPriceNum = dynamicObject.getString("costprice");
                DynamicObject costPrice = this.costPriceMap.get(costPriceNum);
                String priceType = costPrice.getString("entry.type");
                String billfilter = costPrice.getString("entry.billfilter_tag");
                String srcBillType = costPrice.getString("entry.entityobject.number");
                String srcPrices = dynamicObject.getString("srcprice");
                String destPrices = dynamicObject.getString("destprice");
                String srcVars = this.getSrcVars(srcPrices);
                String srcExp2Dest = this.getSrcExp2Dest(srcPrices, destPrices);
                this.srcPriceVars.put(entityObject + "_" + costPriceNum, srcVars);
                this.srcExp2DestVars.put(entityObject + "_" + costPriceNum, srcExp2Dest);
                QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
                q.and(this.getBillFilter(srcBillType, billfilter));
                if ("cal_costrecord".equals(srcBillType) || "cal_costrecord_subentity".equals(srcBillType)) {
                    if ("A".equals(priceType)) {
                        q.and("entry.unitactualcost", "!=", (Object)0);
                    }
                    if (this.materialIds.isEmpty()) continue;
                    q.and("entry.material", "in", this.materialIds);
                }
                if (("cal_recentcost".equals(srcBillType) || "cal_balance".equals(srcBillType)) && !this.materialIds.isEmpty()) {
                    q.and("material", "in", this.materialIds);
                }
                if ("cal_recentcost".equals(srcBillType) && !this.costAccountIds.isEmpty()) {
                    q.and("costaccount", "in", this.costAccountIds);
                }
                if ((invOrgSplit = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.GET_PRICE_INVORG_SPLIT)).booleanValue() && this.storageorgunitIds != null && this.storageorgunitIds.size() > 0 && ("B".equals(priceDimension) || "C".equals(priceDimension))) {
                    log.info("\u53d6\u4ef7\u5e93\u5b58\u7ec4\u7ec7\u8fc7\u6ee4" + srcBillType + this.storageorgunitIds);
                    DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)srcBillType).getProperties();
                    String invOrgKey = "storageorgunit";
                    if (properties.containsKey((Object)invOrgKey)) {
                        q.and(new QFilter("storageorgunit", "in", this.storageorgunitIds));
                    }
                }
                DataSet srcDataSet = null;
                try {
                    if ("cal_balance".equals(srcBillType)) {
                        if (this.isNewBalance) {
                            String balSelectField = CalBalanceModelHelper.getDimFields((boolean)false) + ",calorg,baseunit,calrange";
                            String[] groupFields = (balSelectField + ",bookdate,auditdate").split(",");
                            QFilter qend = q.copy().and(this.getEndBalanceFilter());
                            DataSet endDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qend)).select(balSelectField + ",0 as bookdate,0 as auditdate,actualcost_bal as periodbeginactualcost,baseqty_bal as periodbeginqty,0 as periodinqty,0 as periodinactualcost").groupBy(groupFields).max("periodbeginqty").max("periodinqty").sum("periodbeginactualcost").sum("periodinactualcost").finish();
                            QFilter qbegin = q.copy().and(this.getBeginBalanceFilter());
                            DataSet beginDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qbegin)).select(balSelectField + ",0 as bookdate,0 as auditdate,actualcost as periodbeginactualcost,baseqty as periodbeginqty,baseqty_in as periodinqty, actualcost_in as periodinactualcost").groupBy(groupFields).max("periodbeginqty").max("periodinqty").sum("periodbeginactualcost").sum("periodinactualcost").finish();
                            srcDataSet = endDataSet.union(beginDataSet).groupBy(groupFields).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                        } else {
                            QFilter qend = q.copy().and(this.getEndBalanceFilter());
                            log.info("\u53d6\u4ef7\u67e5\u8be2\u7ed3\u5b58\u4f59\u989d\u8868\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + qend);
                            DataSet endDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)srcBillType, (String)(this.selectFields(srcBillType + "_base") + ",periodendactualcost as periodbeginactualcost,periodendqty as periodbeginqty,0 as periodinqty,0 as periodinactualcost"), (QFilter[])qend.toArray(), null);
                            QFilter qbegin = q.copy().and(this.getBeginBalanceFilter());
                            log.info("\u53d6\u4ef7\u67e5\u8be2\u671f\u521d\u4f59\u989d\u8868\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + qbegin);
                            DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)srcBillType, (String)(this.selectFields(srcBillType + "_base") + ",periodbeginactualcost,periodbeginqty,periodinqty,periodinactualcost"), (QFilter[])qbegin.toArray(), null);
                            srcDataSet = endDataSet.union(beginDataSet).groupBy(this.selectFields(srcBillType).split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0  or periodinqty <> 0 or periodinactualcost <> 0");
                        }
                    } else if ("cal_recentcost".equals(srcBillType)) {
                        log.info("\u53d6\u4ef7\u67e5\u8be2\u5373\u65f6\u6210\u672c\u8868\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + q);
                        srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-recentcost"), (String)srcBillType, (String)(this.selectFields(srcBillType) + "," + srcVars), (QFilter[])q.toArray(), null);
                    } else if ("cal_costrecord".equals(srcBillType) || "cal_costrecord_subentity".equals(srcBillType)) {
                        log.info("\u53d6\u4ef7\u67e5\u8be2\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + q);
                        Integer beforePeriod = costPrice.getInt("entry.beforeperiod");
                        List<QFilter> filters = this.getBeforePeriodFilters(beforePeriod, priceType, q);
                        ArrayList<OrmInput> ormInputs = new ArrayList<OrmInput>(16);
                        for (QFilter filter : filters) {
                            OrmInput input = new OrmInput(this.getClass().getName() + "-costrecord", srcBillType, this.selectFields(srcBillType) + "," + srcVars, filter.toArray());
                            ormInputs.add(input);
                        }
                        if (!ormInputs.isEmpty()) {
                            srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])ormInputs.toArray(new OrmInput[0]));
                        }
                    }
                }
                catch (Exception e) {
                    log.error("CostPrice4SCMHelper createSrcDataMap", (Throwable)e);
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bf9\u5e94\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff0c\u4ee5\u53ca\u6210\u672c\u4ef7\u7c7b\u522b--\u5355\u4ef7\u7c7b\u522b\u8bbe\u7f6e\u9879\r\n %1$s", (String)"CostPriceHelper_0", (String)"fi-cal-business", (Object[])new Object[0]), this.getErrorMsg(e));
                    throw new KDBizException(msg);
                }
                if (srcDataSet == null || srcDataSet.copy().isEmpty()) continue;
                DataSet copy = srcDataSet.copy();
                this.srcDataSetMap.put(entityObject + "_" + costPriceNum, copy);
            }
        }
    }

    private List<QFilter> getBeforePeriodFilters(Integer beforePeriod, String priceType, QFilter q) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        for (Map.Entry<Long, DynamicObject> entryMap : this.currentPeriodMap.entrySet()) {
            Long costAccountId = entryMap.getKey();
            DynamicObject currentPeriod = entryMap.getValue();
            QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            Date startDate = null;
            Date endDate = null;
            if (beforePeriod == 0) {
                if ("B".equals(priceType)) {
                    startDate = currentPeriod.getDate("begindate");
                    endDate = currentPeriod.getDate("enddate");
                } else {
                    endDate = currentPeriod.getDate("enddate");
                    if (this.maxBookDate != null) {
                        endDate = this.maxBookDate;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(endDate);
                    calendar.add(1, -1);
                    startDate = calendar.getTime();
                }
            } else if (beforePeriod > 0) {
                DynamicObjectCollection beforePeriods = this.getCurrentPeriodBeforePeriod(currentPeriod);
                if (beforePeriod != null || beforePeriods.size() > 0) {
                    endDate = ((DynamicObject)beforePeriods.get(0)).getDate("enddate");
                    int size = beforePeriods.size();
                    startDate = size >= beforePeriod ? ((DynamicObject)beforePeriods.get(beforePeriod - 1)).getDate("begindate") : ((DynamicObject)beforePeriods.get(size - 1)).getDate("begindate");
                }
            }
            List costAccountBookdatefilters = DateUtils.getDateSplitFilters(startDate, endDate, (String)"bookdate");
            for (QFilter costAccountBookdatefilter : costAccountBookdatefilters) {
                costAccountBookdatefilter.and(qFilter);
                costAccountBookdatefilter.and(q);
            }
            filters.addAll(costAccountBookdatefilters);
        }
        return filters;
    }

    private QFilter getBeginBalanceFilter() {
        QFilter q = null;
        for (Map.Entry<Long, DynamicObject> entryMap : this.currentPeriodMap.entrySet()) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)entryMap.getKey());
            DynamicObject period = entryMap.getValue();
            int periodnumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
            qFilter.and("period", "=", (Object)periodnumber);
            if (q == null) {
                q = qFilter;
                continue;
            }
            q.or(qFilter);
        }
        return q;
    }

    private QFilter getEndBalanceFilter() {
        QFilter q = null;
        for (Map.Entry<Long, DynamicObject> entryMap : this.currentPeriodMap.entrySet()) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)entryMap.getKey());
            DynamicObject period = entryMap.getValue();
            int periodnumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
            qFilter.and("period", "<", (Object)periodnumber);
            qFilter.and("endperiod", ">", (Object)periodnumber);
            if (q == null) {
                q = qFilter;
                continue;
            }
            q.or(qFilter);
        }
        return q;
    }

    public String getErrorMsg(Exception e) {
        return CommonUtils.getLogMessage((Throwable)e);
    }

    private void createCostPriceMap() {
        HashSet<String> costPriceNumList = new HashSet<String>(16);
        for (DynamicObject priceScheme : this.priceSchemes.values()) {
            DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
            if (entryentitys == null || entryentitys.size() <= 0) continue;
            for (DynamicObject dynamicObject : entryentitys) {
                String costPriceNum = dynamicObject.getString("costprice");
                costPriceNumList.add(costPriceNum);
            }
        }
        QFilter costPriceFilter = new QFilter("entry.pricenum", "in", costPriceNumList);
        DynamicObjectCollection costPrices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.entityobject.number,entry.billfilter_tag,entry.priceplugin,entry.beforeperiod, entry.type", (QFilter[])costPriceFilter.toArray());
        for (DynamicObject costPrice : costPrices) {
            String costPriceNum = costPrice.getString("entry.pricenum");
            this.costPriceMap.put(costPriceNum, costPrice);
        }
    }

    private void createPriceLibMap() {
        DynamicObject priceLib = BusinessDataServiceHelper.loadSingleFromCache((Object)747819409392815104L, (String)"cal_pricelib");
        DynamicObjectCollection entrys = priceLib.getDynamicObjectCollection("entry");
        for (DynamicObject dynamicObject : entrys) {
            this.priceLibMap.put(dynamicObject.getString("pricenum"), dynamicObject);
        }
    }

    private DynamicObjectCollection getCurrentPeriodBeforePeriod(DynamicObject currentPeriod) {
        Long currentPeriodId = currentPeriod.getLong("id");
        DynamicObjectCollection cols = this.beforePeriodCols.get(currentPeriodId);
        if (cols != null) {
            return cols;
        }
        QFilter filterType = new QFilter("periodtype", "=", (Object)this.currentPeriodTypeMap.get(currentPeriodId));
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currentPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currentPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currentPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        cols = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        this.beforePeriodCols.put(currentPeriodId, cols);
        return cols;
    }

    private boolean hasPrice(DataSet copy) {
        if (copy.hasNext()) {
            List<String> fieldNames = Arrays.asList(copy.getRowMeta().getFieldNames());
            Row srcRow = copy.next();
            return !(fieldNames.contains("entry.baseqty") && srcRow.getBigDecimal("entry.baseqty").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginqty") && !fieldNames.contains("periodinqty") && srcRow.getBigDecimal("periodbeginqty").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginqty") && fieldNames.contains("periodinqty") && srcRow.getBigDecimal("periodbeginqty").add(srcRow.getBigDecimal("periodinqty")).compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginactualcost") && !fieldNames.contains("periodinactualcost") && srcRow.getBigDecimal("periodbeginactualcost").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginactualcost") && fieldNames.contains("periodinactualcost") && srcRow.getBigDecimal("periodbeginactualcost").add(srcRow.getBigDecimal("periodinactualcost")).compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("entry.unitactualcost") && srcRow.getBigDecimal("entry.unitactualcost").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("entry.actualcost") && srcRow.getBigDecimal("entry.actualcost").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("recentqty") && srcRow.getBigDecimal("recentqty").compareTo(BigDecimal.ZERO) == 0);
        }
        return false;
    }

    private QFilter getBillFilter(String billType, String billfilter) {
        QFilter q = null;
        if (StringUtils.isNotEmpty((String)billfilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilter, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            q = filterBuilder.getQFilter();
        }
        return q;
    }

    private String getSrcExp2Dest(String srcPrice, String destPrice) {
        ArrayList<String> srcNumbers = new ArrayList<String>(Arrays.asList(srcPrice.split(",")));
        srcNumbers.remove("");
        ArrayList<String> destNumbers = new ArrayList<String>(Arrays.asList(destPrice.split(",")));
        destNumbers.remove("");
        int n = srcNumbers.size();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            DynamicObject srcPrices = this.priceLibMap.get(srcNumbers.get(i));
            DynamicObject destPrices = this.priceLibMap.get(destNumbers.get(i));
            String srcEntityObject = String.valueOf(srcPrices.getDynamicObject("entityobject").getPkValue());
            boolean isDetail = srcPrices.getBoolean("isdetail");
            if (isDetail && ("cal_costrecord".equals(srcEntityObject) || "cal_costrecord_subentity".equals(srcEntityObject))) {
                srcEntityObject = "cal_costrecord_detail";
            }
            String srcPriceExp = srcPrices.getString("priceexp_tag");
            String destPriceExp = destPrices.getString("priceexp_tag");
            result.append(this.getRealExp(srcEntityObject, srcPriceExp));
            result.append(" as ");
            result.append(destPriceExp);
            result.append(",");
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    private String getSrcVars(String srcPrice) {
        HashSet<String> result = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)srcPrice)) {
            ArrayList<String> srcNumbers = new ArrayList<String>(Arrays.asList(srcPrice.split(",")));
            srcNumbers.remove("");
            DynamicObject price = this.priceLibMap.get(srcNumbers.get(0));
            String srcEntityObject = String.valueOf(price.getDynamicObject("entityobject").getPkValue());
            boolean isDetail = price.getBoolean("isdetail");
            if (isDetail && ("cal_costrecord".equals(srcEntityObject) || "cal_costrecord_subentity".equals(srcEntityObject))) {
                srcEntityObject = "cal_costrecord_detail";
            }
            for (String priceNum : srcNumbers) {
                price = this.priceLibMap.get(priceNum);
                String srcPriceExp = price.getString("priceexp_tag");
                if ("".equals(srcPriceExp)) continue;
                result.addAll(Arrays.asList(this.getRealVars(srcEntityObject, srcPriceExp).split(",")));
            }
        } else {
            result.add("entry.unitactualcost");
        }
        return String.join((CharSequence)",", result);
    }

    private String getRealVars(String entityObject, String priceExp) {
        StringBuilder varStr = new StringBuilder();
        String op = "[\\+\\-\\*\\/\\(\\)]";
        String[] vars = priceExp.split(op);
        MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)entityObject);
        for (String var : vars) {
            if ((var = var.trim()).equals("")) continue;
            IDataEntityProperty dataEntity = billDataEntity.findProperty(var);
            if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
                varStr.append(dataEntity.getParent().getName());
                varStr.append(".");
                varStr.append(var);
                varStr.append(",");
                continue;
            }
            varStr.append(var);
            varStr.append(",");
        }
        return varStr.substring(0, varStr.length() - 1);
    }

    private String getRealExp(String entityObject, String priceExp) {
        if ("cal_balance".equals(entityObject)) {
            priceExp = priceExp.contains("periodinqty") ? "case when periodbeginqty+periodinqty =0 then 0 else (periodbeginactualcost+periodinactualcost)/(periodbeginqty+periodinqty) end " : "case when periodbeginqty =0 then 0 else periodbeginactualcost/periodbeginqty end ";
        } else {
            String op = "[\\+\\-\\*\\/\\(\\)]";
            String reg = "^aa(?=[\\)*\\+\\-\\*\\/])|(?<=[(\\+\\-\\*\\/])aa(?=[\\)*\\+\\-\\*\\/])|(?<=[\\+\\-\\*\\/])aa$|^aa$";
            String[] vars = priceExp.split(op);
            MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)entityObject);
            for (String var : vars) {
                IDataEntityProperty dataEntity;
                if (var.equals("") || (dataEntity = billDataEntity.findProperty(var.trim())) == null || !(dataEntity.getParent() instanceof EntryType)) continue;
                priceExp = priceExp.replaceAll(reg.replace("aa", var), dataEntity.getParent().getName() + "." + var.trim());
            }
        }
        return priceExp;
    }

    private String selectFields(String s) {
        String resultStr = "";
        switch (s) {
            case "cal_costrecord": 
            case "cal_costrecord_subentity": {
                resultStr = "entry.id as detailid,calorg,costaccount,entry.material as material,entry.calrange as calrange,entry.baseunit as baseunit,entry.owner as owner, storageorgunit as storageorgunit, entry.warehouse as warehouse, entry.location as location, entry.lot as lot, entry.project as project, entry.assist as assist,bookdate,auditdate" + this.cal_costrecord_ex.toString();
                break;
            }
            case "cal_balance": {
                resultStr = "calorg,costaccount,material,calrange,baseunit,owner,storageorgunit,warehouse,location,lot,project,assist,bookdate,auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_balance_base": {
                resultStr = "calorg,costaccount,material,calrange,baseunit,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_balance_end": {
                resultStr = "calorg,costaccount,material,calrange,baseunit,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_balance_ex + ",periodendactualcost as periodbeginactualcost,periodendqty as periodbeginqty";
                break;
            }
            case "cal_balance_begin": {
                resultStr = "calorg,costaccount,material,calrange,baseunit,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_balance_ex + ",periodbeginactualcost,periodbeginqty";
                break;
            }
            case "cal_recentcost": {
                resultStr = "calorg,costaccount,material,calrange,baseunit,owner,storageorgunit,warehouse,location,lot,project,assist,costelement,costsubelement,0 as bookdate,0 as auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_costrecord_price": {
                resultStr = "entry.id,entry.baseqty,entry.unitmaterialcost,entry.materialcost,entry.unitfee,entry.fee,entry.unitprocesscost,entry.processcost,entry.unitmanufacturecost,entry.manufacturecost,entry.unitresource,entry.resource,entry.unitactualcost,entry.actualcost";
                break;
            }
            case "base": {
                resultStr = "detailid,calorg,costaccount,material,calrange,baseunit,owner,storageorgunit,warehouse,location,lot,project,assist,bookdate,auditdate" + this.cal_balance_ex.toString();
                break;
            }
        }
        return resultStr;
    }
}

