/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.costprice.AbstractCostPriceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;

public class CostPrice4SyncBillHelper
extends AbstractCostPriceHelper {
    private static Log log = LogFactory.getLog(CostPrice4SyncBillHelper.class);
    private Set<DynamicObject> priceSchemeSet = new HashSet<DynamicObject>(16);
    private Map<Long, CostPriceResultInfo> costPriceResultInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
    private String bizBillType = "";
    private String bizBillEntryIdKey = "";
    private Set<Long> bizBillIds = null;
    private Set<Long> calOrgIds = null;
    private Date maxBoodate = null;

    public CostPrice4SyncBillHelper(String bizBillType, String bizbillentrykey, Set<Long> bizBillIds, Set<Long> calOrgIds, Date maxBoodate) {
        log.info("CostPrice4SyncBillHelper-\u53d6\u4ef7\u53d6\u4ef7\u521d\u59cb\u5316\u7236\u7c7b\u7ed3\u675f" + System.currentTimeMillis());
        this.bizBillEntryIdKey = bizbillentrykey + ".id";
        this.bizBillType = bizBillType;
        this.bizBillIds = bizBillIds;
        this.calOrgIds = calOrgIds;
        this.maxBoodate = maxBoodate;
        QFilter schemeFilter = new QFilter("entityobject", "=", (Object)bizBillType);
        schemeFilter.and("priceobject", "=", (Object)"C");
        schemeFilter.and("enable", "=", (Object)"1");
        DynamicObject[] costPriceSchemes = BusinessDataServiceHelper.load((String)"cal_pricescheme", (String)"id,name,number,entityobject,billfilter_tag,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])schemeFilter.toArray());
        if (costPriceSchemes == null || costPriceSchemes.length < 1) {
            return;
        }
        for (DynamicObject dynamicObject : costPriceSchemes) {
            this.priceSchemeSet.add(dynamicObject);
        }
        log.info("CostPrice4SyncBillHelper-\u53d6\u4ef7\u53d6\u4ef7\u521d\u59cb\u5316\u5b50\u7c7b\u7ed3\u675f" + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CostPriceResultInfo> getCostPrice() {
        if (this.calOrgIds == null || this.calOrgIds.isEmpty() || this.bizBillIds == null || this.bizBillIds.isEmpty()) {
            return null;
        }
        log.info("CostPrice4SyncBillHelper-\u53d6\u4ef7\u5f00\u59cb\uff1a\u5f85\u53d6\u4ef7\u7684\u6838\u7b97\u7ec4\u7ec7:" + this.calOrgIds + "\\n\u5f85\u53d6\u4ef7\u7684\u4e1a\u52a1\u5355\u636eids:" + this.bizBillIds + "\\n" + System.currentTimeMillis());
        for (DynamicObject priceScheme : this.priceSchemeSet) {
            String schemeNum = priceScheme.getString("number");
            Long priceSchemeId = priceScheme.getLong("id");
            log.info("CostPrice4SyncBillHelper-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:\u3010" + schemeNum + "\u3011\u8fdb\u884c\u53d6\u4ef7\u5f00\u59cb!" + System.currentTimeMillis());
            String billFilter = priceScheme.getString("billfilter_tag");
            String priceDimension = priceScheme.getString("pricedimension");
            DataSet destCostRecordDS = null;
            DataSet destDSCopy = null;
            DataSet destDsCopy2 = null;
            DataSet srcDataSet = null;
            try {
                AlgoContext context = Algo.newContext();
                Throwable throwable = null;
                try {
                    destCostRecordDS = this.getDestCostRecordDS(billFilter);
                    if (destCostRecordDS == null) continue;
                    DynamicObjectCollection entryentitys = priceScheme.getDynamicObjectCollection("entry");
                    HashMap<Long, CostPriceResultInfo> currentSchemePriceInfoMap = new HashMap<Long, CostPriceResultInfo>(16);
                    for (DynamicObject schemeRow : entryentitys) {
                        Set currentHasPriceEntryIds = currentSchemePriceInfoMap.keySet();
                        if (!currentHasPriceEntryIds.isEmpty()) {
                            destCostRecordDS = destCostRecordDS.where(new QFilter("entryid", "not in", currentHasPriceEntryIds).toString());
                        }
                        HashSet<Long> materialIds = new HashSet<Long>(16);
                        HashSet<Long> costAccountIds = new HashSet<Long>(16);
                        HashSet<String> divideBasisStrSet = new HashSet<String>(16);
                        HashSet<String> dimensionStrSet = new HashSet<String>(16);
                        HashSet<Long> destEntryIds = new HashSet<Long>(16);
                        HashSet<Long> costRecordIds = new HashSet<Long>(16);
                        destDSCopy = destCostRecordDS.copy();
                        for (Row row : destDSCopy) {
                            costRecordIds.add(row.getLong("id"));
                            materialIds.add(row.getLong("material"));
                            costAccountIds.add(row.getLong("costaccount"));
                            divideBasisStrSet.add(row.getString("dividebasis"));
                            dimensionStrSet.add(row.getString("caldimension"));
                            destEntryIds.add(row.getLong("entryid"));
                        }
                        if (destEntryIds.isEmpty()) break;
                        this.prepareSrcDataSet(schemeRow);
                        if (StringUtils.isNotEmpty((String)this.costPricePlugin)) {
                            this.handleCostPricePlugin(destEntryIds, costRecordIds.toArray(new Long[0]), currentSchemePriceInfoMap);
                            continue;
                        }
                        srcDataSet = this.getSrcDataSet(schemeRow, costAccountIds, materialIds, this.bizBillIds, destEntryIds, this.maxBoodate, priceSchemeId);
                        if (srcDataSet == null) continue;
                        String costPriceType = this.getCostPriceType(schemeRow);
                        if ("C".equals(costPriceType)) {
                            srcDataSet = srcDataSet.select("srcentryid as entryid,costsubelement,billno,baseunit," + this.currentSrcVarsStr);
                            this.handleCostPriceResults(srcDataSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
                            continue;
                        }
                        destDsCopy2 = destCostRecordDS.copy();
                        this.handlePriceDimension(priceDimension, destDsCopy2, srcDataSet, divideBasisStrSet, dimensionStrSet, costPriceType, currentSchemePriceInfoMap, schemeNum);
                    }
                    this.costPriceResultInfoMap.putAll(currentSchemePriceInfoMap);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
            }
            finally {
                if (destCostRecordDS != null) {
                    destCostRecordDS.close();
                }
                if (destDSCopy != null) {
                    destDSCopy.close();
                }
                if (destDsCopy2 != null) {
                    destDsCopy2.close();
                }
                if (srcDataSet == null) continue;
                srcDataSet.close();
                continue;
            }
            log.info("CostPrice4SyncBillHelper-\u901a\u8fc7\u53d6\u4ef7\u914d\u7f6e:" + priceScheme.getString("number") + "\u8fdb\u884c\u53d6\u4ef7\u7ed3\u675f!" + System.currentTimeMillis());
        }
        log.info("CostPrice4SyncBillHelper-\u540c\u6b65\u5355\u636e\u53d6\u4ef7\u7ed3\u675f\uff0c\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + this.costPriceResultInfoMap.toString() + System.currentTimeMillis());
        return new ArrayList<CostPriceResultInfo>(this.costPriceResultInfoMap.values());
    }

    @Override
    public void updateCostRecordCost(Set<Long> bizBillIds, Map<Long, BigDecimal> entryBaseQtyMap, Map<Long, Integer> entryAmtPrecision, List<CostPriceResultInfo> resultInfos) {
        super.updateCostRecordCost(bizBillIds, entryBaseQtyMap, entryAmtPrecision, resultInfos);
    }

    private DataSet getDestCostRecordDS(String billFilter) {
        Object entryKey2;
        QFilter bizBillFilter = new QFilter("id", "in", this.bizBillIds);
        if (StringUtils.isNotEmpty((String)billFilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billFilter, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.bizBillType);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            bizBillFilter.and(filterBuilder.getQFilter());
        }
        HashSet<Long> matchBizBillEntryIds = new HashSet<Long>(16);
        Set entryKeyS = SynBizBillHelper.getAllEntryKeys((String)this.bizBillType, (boolean)true);
        HashSet<String> entryIdKeys = new HashSet<String>(16);
        StringBuilder selSb = new StringBuilder(16);
        for (Object entryKey2 : entryKeyS) {
            String entryIdKey = (String)entryKey2 + ".id";
            entryIdKeys.add(entryIdKey);
            selSb.append(entryIdKey).append(",");
        }
        if (selSb.length() > 0) {
            selSb.deleteCharAt(selSb.length() - 1);
        }
        DataSet bizBillDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.bizBillType, (String)selSb.toString(), (QFilter[])bizBillFilter.toArray(), null);
        entryKey2 = null;
        try {
            for (Row row : bizBillDS) {
                for (String entryIdKey : entryIdKeys) {
                    matchBizBillEntryIds.add(row.getLong(entryIdKey));
                }
            }
        }
        catch (Throwable throwable) {
            entryKey2 = throwable;
            throw throwable;
        }
        finally {
            if (bizBillDS != null) {
                if (entryKey2 != null) {
                    try {
                        bizBillDS.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)entryKey2).addSuppressed(throwable);
                    }
                } else {
                    bizBillDS.close();
                }
            }
        }
        if (matchBizBillEntryIds.isEmpty()) {
            return null;
        }
        QFilter destDsFilter = new QFilter("entry.bizbillentryid", "in", matchBizBillEntryIds);
        destDsFilter.and("bizbillid", "in", this.bizBillIds);
        Set<Long> hasPriceCostRecordEntryIds = this.costPriceResultInfoMap.keySet();
        if (!hasPriceCostRecordEntryIds.isEmpty()) {
            destDsFilter.and("entry.id", "not in", hasPriceCostRecordEntryIds);
        }
        destDsFilter.and("calorg.id", "in", this.calOrgIds);
        destDsFilter.and("entry.accounttype", "not in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue()});
        destDsFilter.and(new QFilter("calbilltype", "=", (Object)"OUT").or("entry.ispresent", "=", (Object)"0"));
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)this.selectFields("dest"), (QFilter[])destDsFilter.toArray(), null);
    }
}

