/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.business.costprice.PriceDimensionHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.util.DateUtils;

public class CostPriceHelper {
    private static Log log = LogFactory.getLog(CostPriceHelper.class);
    private static final long CAL_PRICELIB_PAGEID = 747819409392815104L;
    private QFilter srcDataSetFilter = null;
    private Set<Long> srcBillIds = new HashSet<Long>(16);
    private String singleCostPriceNum = null;
    private Set<Long> costAccountIds = new HashSet<Long>(16);
    private Set<Long> materialIds = new HashSet<Long>(16);
    private Map<String, DataSet> srcDataSetMap = new HashMap<String, DataSet>();
    private Map<String, String> srcPriceTypeMap = new HashMap<String, String>();
    private Map<String, String> srcPriceVars = new HashMap<String, String>();
    private Map<String, String> srcExp2DestVars = new HashMap<String, String>();
    private Map<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
    private Map<Object, String> srcPriceDisplayMap = new HashMap<Object, String>();
    private List<String> costPriceNumList = new ArrayList<String>();
    private Map<String, DynamicObject> costPriceMap = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> priceLibMap = new HashMap<String, DynamicObject>();
    private Map<String, Boolean> srcIsDetailMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> destIsDetailMap = new HashMap<String, Boolean>();
    private Map<String, List<Object>> srcCostSubElementIdMap = new HashMap<String, List<Object>>();
    private Map<String, List<Object>> destCostSubElementIdMap = new HashMap<String, List<Object>>();
    private List<Object[]> costRecordDetailUpdateList = new ArrayList<Object[]>();
    private boolean onlyCostAccount = true;
    private String costAccountId = null;
    private Set<String> dimSet = new HashSet<String>();
    private Map<String, Set<String>> dimMap = new HashMap<String, Set<String>>();
    private String[] dividebasis = null;
    private Map<Long, DynamicObject> currentPeriodMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Long> currentPeriodTypeMap = new HashMap<Long, Long>(16);
    private Map<Long, DynamicObjectCollection> beforePeriodCols = new HashMap<Long, DynamicObjectCollection>(16);
    private Date maxBookDate = null;
    private StringBuilder cal_balance_ex = new StringBuilder();
    private StringBuilder cal_costrecord_ex = new StringBuilder();
    private StringBuilder cal_costadjustbill_ex = new StringBuilder();
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Set<Long> notEmptyCalRangeIds = new HashSet<Long>(16);

    public CostPriceHelper() {
        String dividebasisStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] calRealDims = (dividebasisStr + "," + caldimensionStr).split(",");
        MainEntityType costRecordDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        MainEntityType costAdjustDataEntity = EntityMetadataCache.getDataEntityType((String)"cal_costadjustbill");
        List<String> calDimList = Arrays.asList("calorg,costaccount,material,owner,storageorgunit,warehouse,location,lot,project,assist".split(","));
        for (String dim : calRealDims) {
            if (calDimList.contains(dim)) continue;
            this.cal_balance_ex.append(",");
            this.cal_balance_ex.append(dim);
            IDataEntityProperty costRecordEntity = costRecordDataEntity.findProperty(dim);
            if (costRecordEntity != null && costRecordEntity.getParent() instanceof EntryType) {
                this.cal_costrecord_ex.append(",");
                this.cal_costrecord_ex.append(costRecordEntity.getParent().getName());
                this.cal_costrecord_ex.append(".");
                this.cal_costrecord_ex.append(dim);
                this.cal_costrecord_ex.append(" as ");
                this.cal_costrecord_ex.append(dim);
            } else {
                this.cal_costrecord_ex.append(",");
                this.cal_costrecord_ex.append(dim);
            }
            IDataEntityProperty costAdjustEntity = costAdjustDataEntity.findProperty(dim);
            if (costAdjustEntity != null && costAdjustEntity.getParent() instanceof EntryType) {
                this.cal_costadjustbill_ex.append(",");
                this.cal_costadjustbill_ex.append(costAdjustEntity.getParent().getName());
                this.cal_costadjustbill_ex.append(".");
                this.cal_costadjustbill_ex.append(dim);
                this.cal_costadjustbill_ex.append(" as ");
                this.cal_costadjustbill_ex.append(dim);
                continue;
            }
            this.cal_costadjustbill_ex.append(",");
            this.cal_costadjustbill_ex.append(dim);
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        Map calrangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject info : calrangeMap.values()) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            if (entry == null || entry.size() <= 0) continue;
            this.notEmptyCalRangeIds.add(info.getLong("id"));
        }
    }

    public CostPriceResultInfo[] getPrice4MoveAddAverage(List<Long> costRecordEntryIds, QFilter q) {
        String errmsg = "";
        try {
            q.and("enable", "=", (Object)"1");
            DynamicObject matchSchemeInfo = BusinessDataServiceHelper.loadSingle((String)"cal_pricescheme", (String)"number,entityobject,billfilter_tag,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])q.toArray());
            if (matchSchemeInfo == null) {
                return null;
            }
            QFilter qbill = new QFilter("entry.id", "in", costRecordEntryIds);
            qbill.and(new QFilter("calbilltype", "=", (Object)"OUT").or("entry.ispresent", "=", (Object)"0"));
            DataSet destDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)this.selectFields("dest"), (QFilter[])qbill.toArray(), null);
            this.createCostAccountAndMaterialFilter(destDataSet.copy());
            this.createSrcDataSetMap(matchSchemeInfo);
            for (Row row : destDataSet) {
                this.createCostPriceBySchemeFromCostRecord(matchSchemeInfo, row);
            }
        }
        catch (Exception e) {
            errmsg = e.getMessage();
            log.error("CostPriceHelper getPrice4MoveAddAverage", (Throwable)e);
        }
        CostPriceResultInfo[] resultInfos = this.buildCostPriceResultInfos(errmsg);
        log.info("\u5b9e\u65f6\u79fb\u52a8/\u5148\u8fdb\u5148\u51fa\u53d6\u4ef7\u7ed3\u679c\uff1a" + Arrays.asList(resultInfos));
        return resultInfos;
    }

    private CostPriceResultInfo[] buildCostPriceResultInfos(String errmsg) {
        HashMap<Object, CostPriceResultInfo> infoMap = new HashMap<Object, CostPriceResultInfo>(16);
        if (!this.costRecordDetailUpdateList.isEmpty()) {
            for (Object[] detail : this.costRecordDetailUpdateList) {
                Long costSubElementId = Long.valueOf(detail[3].toString());
                BigDecimal costPrice = new BigDecimal(detail[0].toString());
                Object entryId = detail[2];
                CostPriceResultInfo info = (CostPriceResultInfo)infoMap.get(entryId);
                if (info == null) {
                    info = new CostPriceResultInfo();
                    info.setSuccess(true);
                    info.setDetail(true);
                    info.setEntryId((Long)entryId);
                    infoMap.put(entryId, info);
                }
                info.putCostSubElementUnitcostMap(costSubElementId, costPrice);
                info.setSrcPriceName(this.srcPriceDisplayMap.get(entryId));
            }
        } else {
            CostPriceResultInfo info = new CostPriceResultInfo();
            info.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672a\u53d6\u5230\u4ef7\u683c\u3002\u539f\u56e0\u4e3a\uff1a%1$s", (String)"CostPriceHelper_1", (String)"fi-cal-business", (Object[])new Object[0]), errmsg);
            info.setErrMsg(errorMsg);
            infoMap.put("0", info);
        }
        return infoMap.values().toArray(new CostPriceResultInfo[infoMap.size()]);
    }

    private void createCostAccountAndMaterialFilter(DataSet destDataSet) {
        for (Row row : destDataSet) {
            this.costAccountIds.add(row.getLong("costaccount"));
            this.materialIds.add(row.getLong("material"));
            this.srcBillIds.add(row.getLong("bizbillid"));
            Date bookdate = row.getDate("bookdate");
            if (this.maxBookDate != null && !bookdate.after(this.maxBookDate)) continue;
            this.maxBookDate = bookdate;
        }
    }

    public Map<Long, Map<String, Object>> getPriceFromCostRecordEntryIds(List<Long> costRecordEntryIds, QFilter q, String costPriceNumber, QFilter srcFilter) {
        this.srcDataSetFilter = srcFilter;
        q.and("enable", "=", (Object)"1");
        DynamicObject matchSchemeInfo = BusinessDataServiceHelper.loadSingle((String)"cal_pricescheme", (String)"number,entityobject,billfilter_tag,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])q.toArray());
        if (matchSchemeInfo == null) {
            return null;
        }
        this.singleCostPriceNum = costPriceNumber;
        QFilter qbill = new QFilter("entry.id", "in", costRecordEntryIds);
        DataSet destDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)this.selectFields("dest"), (QFilter[])qbill.toArray(), null);
        this.createCostAccountAndMaterialFilter(destDataSet.copy());
        this.createSrcDataSetMap(matchSchemeInfo);
        for (Row row : destDataSet) {
            this.createCostPriceBySchemeFromCostRecord(matchSchemeInfo, row);
        }
        return this.resultMap;
    }

    public Map<Integer, Map<String, Object>> getPriceFromEntry(List<Map<String, Object>> parms, QFilter q, String costPriceNumber, DynamicObject costAccount) {
        if (!parms.isEmpty()) {
            Object dividebasisId = costAccount.getDynamicObject("dividebasis").getPkValue();
            this.dividebasis = QueryServiceHelper.queryOne((String)"cal_bd_dividebasis", (String)"id,dividebasis", (QFilter[])new QFilter("id", "=", dividebasisId).toArray()).getString("dividebasis").split(",");
            this.costAccountId = String.valueOf(costAccount.getPkValue());
            this.costAccountIds.add(costAccount.getLong("id"));
            this.initMaterialids(parms);
            this.srcDataSetFilter = new QFilter("costaccount", "=", costAccount.getPkValue());
            HashMap<Integer, Map<String, Object>> maps = new HashMap<Integer, Map<String, Object>>();
            q.and("enable", "=", (Object)"1");
            DynamicObject matchSchemeInfo = BusinessDataServiceHelper.loadSingle((String)"cal_pricescheme", (String)"number,entityobject,billfilter_tag,pricedimension,entry.costprice,entry.pricedisplay,entry.srcprice,entry.destprice", (QFilter[])q.toArray());
            if (matchSchemeInfo == null) {
                return null;
            }
            this.createDimMap(matchSchemeInfo, costAccount);
            this.singleCostPriceNum = costPriceNumber;
            this.createSrcDataSetMap(matchSchemeInfo);
            for (Map<String, Object> map : parms) {
                int rowIndex = (Integer)map.get("rowIndex");
                Map<String, Object> priceMap = this.getCostPriceBySchemeFromMap(matchSchemeInfo, map);
                if (priceMap == null || priceMap.isEmpty()) continue;
                maps.put(rowIndex, priceMap);
            }
            return maps;
        }
        return null;
    }

    private void initMaterialids(List<Map<String, Object>> parms) {
        for (Map<String, Object> parm : parms) {
            this.materialIds.add(Long.valueOf(parm.get("material").toString()));
        }
    }

    private void createDimMap(DynamicObject matchSchemeInfo, DynamicObject costAccount) {
        String priceDimension = matchSchemeInfo.getString("pricedimension");
        if ("C".equals(priceDimension)) {
            this.dimSet.addAll(Arrays.asList(this.dividebasis));
            this.dimMap = new PriceDimensionHelper(costAccount.getPkValue()).getCalDimMap();
            this.onlyCostAccount = false;
        } else if ("B".equals(priceDimension)) {
            this.dimSet.add("costaccount");
            HashSet<String> set = new HashSet<String>();
            set.add("calorg");
            set.add("costaccount");
            set.add("material");
            for (String string : this.dividebasis) {
                if ("".equals(string)) continue;
                set.add(string);
            }
            this.dimMap.put(String.valueOf(costAccount.getPkValue()), set);
        } else {
            this.dimSet.add("costaccount");
            HashSet<String> set = new HashSet<String>();
            set.add("calorg");
            set.add("costaccount");
            set.add("material");
            this.dimMap.put(String.valueOf(costAccount.getPkValue()), set);
        }
    }

    private Map<String, Object> getCostPriceBySchemeFromMap(DynamicObject matchSchemeInfo, Map<String, Object> map) {
        DynamicObjectCollection entryentitys = matchSchemeInfo.getDynamicObjectCollection("entry");
        HashMap<String, Object> priceMap = new HashMap<String, Object>();
        map.remove("rowIndex");
        for (DynamicObject cp : entryentitys) {
            boolean hasPrice;
            String srcVars = this.srcPriceVars.get(cp.getString("costprice"));
            String srcExp2Dest = this.srcExp2DestVars.get(cp.getString("costprice"));
            DataSet srcRowDataSet = this.srcDataSetMap.get(cp.getString("costprice"));
            String priceType = this.srcPriceTypeMap.get(cp.getString("costprice"));
            if (srcRowDataSet == null) continue;
            srcRowDataSet = srcRowDataSet.copy();
            QFilter dimFilter = null;
            Set<String> priceDimSet = this.getPriceDimSet(map);
            for (String string : priceDimSet) {
                Object dimValue = map.get(string);
                if (dimValue == null || (!(dimValue instanceof String) || "".equals(dimValue)) && (!(dimValue instanceof Long) || (Long)dimValue == 0L)) continue;
                QFilter q = new QFilter(string, "=", dimValue);
                if (dimFilter == null) {
                    dimFilter = q;
                    continue;
                }
                dimFilter.and(q);
            }
            if (dimFilter != null) {
                srcRowDataSet = srcRowDataSet.where(dimFilter.toString());
            }
            if (srcRowDataSet.copy().isEmpty()) continue;
            srcRowDataSet = srcRowDataSet.select(("bookdate,auditdate," + srcVars).split(","));
            if ("A".equals(priceType)) {
                srcRowDataSet = srcRowDataSet.orderBy("bookdate desc,auditdate desc".split(",")).top(1);
            } else if ("B".equals(priceType)) {
                GroupbyDataSet groupbyDataSet = srcRowDataSet.groupBy(null);
                for (String var : srcVars.split(",")) {
                    groupbyDataSet = groupbyDataSet.sum(var);
                }
                srcRowDataSet = groupbyDataSet.finish();
            }
            if (!(hasPrice = this.hasPrice(srcRowDataSet.copy()))) continue;
            try {
                srcRowDataSet = srcRowDataSet.select(srcExp2Dest.split(","));
            }
            catch (Exception exception) {
                log.error("CostPriceHelper getCostPriceBySchemeFromMap", (Throwable)exception);
                throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostPriceHelper_5", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            Row row = srcRowDataSet.next();
            String[] fields = srcRowDataSet.getRowMeta().getFieldNames();
            for (int i = 0; i < fields.length; ++i) {
                if (((BigDecimal)row.get(i)).signum() == 0) continue;
                priceMap.put(fields[i].trim(), row.get(i));
            }
            if (priceMap == null) continue;
            return priceMap;
        }
        return priceMap;
    }

    private Set<String> getPriceDimSet(Map<String, Object> map) {
        if (!this.onlyCostAccount) {
            StringBuilder div = new StringBuilder();
            for (String string : this.dimSet) {
                Object value = map.get(string);
                div.append(value == null ? "0" : String.valueOf(value) + "_");
            }
            String divStr = div.toString();
            String materialNum = String.valueOf(map.get("materialnum"));
            String materialGroup = String.valueOf(map.get("materialgroupnum"));
            Set<String> resulDimSet = this.dimMap.get(divStr + materialNum);
            if (resulDimSet != null) {
                return resulDimSet;
            }
            resulDimSet = this.dimMap.get(divStr + materialGroup);
            if (resulDimSet != null) {
                this.dimMap.put(divStr + materialNum, resulDimSet);
                return resulDimSet;
            }
            resulDimSet = this.dimMap.get(divStr + "0");
            if (resulDimSet != null) {
                this.dimMap.put(divStr + materialNum, resulDimSet);
                return resulDimSet;
            }
            resulDimSet = this.dimMap.get("0_" + materialNum);
            if (resulDimSet != null) {
                this.dimMap.put(divStr + materialNum, resulDimSet);
                return resulDimSet;
            }
            resulDimSet = this.dimMap.get("0_" + materialGroup);
            if (resulDimSet != null) {
                this.dimMap.put(divStr + materialNum, resulDimSet);
                return resulDimSet;
            }
            resulDimSet = this.dimMap.get("0_0");
            if (resulDimSet != null) {
                this.dimMap.put(divStr + materialNum, resulDimSet);
                return resulDimSet;
            }
        }
        return this.dimMap.get(this.costAccountId);
    }

    private void createSrcDataSetMap(DynamicObject matchSchemeInfo) {
        DynamicObjectCollection entryentitys = matchSchemeInfo.getDynamicObjectCollection("entry");
        this.createPriceLibMap();
        for (DynamicObject cp : entryentitys) {
            String costPriceNum = cp.getString("costprice");
            String srcPrices = cp.getString("srcprice");
            String destPrices = cp.getString("destprice");
            this.createIsDetailMap(srcPrices, this.srcIsDetailMap, this.srcCostSubElementIdMap, cp);
            this.createIsDetailMap(destPrices, this.destIsDetailMap, this.destCostSubElementIdMap, cp);
            String srcVars = this.getSrcVars(srcPrices);
            String srcExp2Dest = this.getSrcExp2Dest(srcPrices, destPrices);
            this.srcPriceVars.put(costPriceNum, srcVars);
            this.srcExp2DestVars.put(costPriceNum, srcExp2Dest);
            if (costPriceNum.equals(this.singleCostPriceNum)) {
                this.costPriceNumList.clear();
                this.costPriceNumList.add(costPriceNum);
                break;
            }
            this.costPriceNumList.add(costPriceNum);
        }
        this.createCostPriceMap();
        this.createCostAccountCurrentPeriods();
        this.createSrcMap();
    }

    private void createIsDetailMap(String prices, Map<String, Boolean> isDetailMap, Map<String, List<Object>> costSubElementIdMap, DynamicObject cp) {
        if (prices != null && !"".equals(prices) && !",,".equals(prices)) {
            ArrayList<String> priceNums = new ArrayList<String>(Arrays.asList(prices.split(",")));
            priceNums.remove("");
            DynamicObject price0 = this.priceLibMap.get(priceNums.get(0));
            boolean isdetail = price0.getBoolean("isdetail");
            isDetailMap.put(cp.getString("costprice"), isdetail);
            if (isdetail) {
                ArrayList<Object> costSubElementIdList = new ArrayList<Object>(16);
                for (String string : priceNums) {
                    DynamicObject price = this.priceLibMap.get(string);
                    DynamicObject costSubElement = price.getDynamicObject("costsubelement");
                    if (costSubElement == null) continue;
                    costSubElementIdList.add(costSubElement.getPkValue());
                }
                costSubElementIdMap.put(cp.getString("costprice"), costSubElementIdList);
            }
        }
    }

    private void createCostAccountCurrentPeriods() {
        this.currentPeriodMap = PeriodHelper.getCurrentPeriods(this.costAccountIds);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> removeKeySet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> mapEntry : this.currentPeriodMap.entrySet()) {
            DynamicObject period = mapEntry.getValue();
            Long currentCostaccountId = mapEntry.getKey();
            if (period == null) {
                removeKeySet.add(currentCostaccountId);
                continue;
            }
            periodIds.add(period.getLong("id"));
        }
        for (Long long1 : removeKeySet) {
            this.currentPeriodMap.remove(long1);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id,periodtype", (QFilter[])new QFilter("id", "in", periodIds).toArray(), null);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                Long periodType = row.getLong("periodtype");
                this.currentPeriodTypeMap.put(id, periodType);
            }
        }
    }

    private void createSrcMap() {
        for (String costPriceNum : this.costPriceNumList) {
            DynamicObject costPrice = this.costPriceMap.get(costPriceNum);
            String priceType = this.srcPriceTypeMap.get(costPriceNum);
            String srcVars = this.srcPriceVars.get(costPriceNum);
            QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (this.srcDataSetFilter != null) {
                q = q.and(this.srcDataSetFilter);
            }
            String srcBillType = null;
            if ("C".equals(priceType)) {
                srcBillType = "cal_costrecord";
                if (!this.srcBillIds.isEmpty()) {
                    q.and("bizbillid", "in", this.srcBillIds);
                }
                q.and("entry.unitactualcost", "!=", (Object)0);
            } else {
                String billfilter = costPrice.getString("entry.billfilter_tag");
                srcBillType = costPrice.getString("entry.entityobject.number");
                q.and(this.getBillFilter(srcBillType, billfilter));
                if ("cal_costrecord".equals(srcBillType) || "cal_costrecord_subentity".equals(srcBillType)) {
                    if (!this.srcBillIds.isEmpty()) {
                        q.and("bizbillid", "not in", this.srcBillIds);
                    }
                    if ("A".equals(priceType)) {
                        q.and("entry.unitactualcost", "!=", (Object)0);
                    }
                    if (!this.materialIds.isEmpty()) {
                        q.and("entry.material", "in", this.materialIds);
                    }
                    q.and("billstatus", "=", (Object)"C");
                }
                if ("cal_recentcost".equals(srcBillType) || "cal_balance".equals(srcBillType)) {
                    if (!this.costAccountIds.isEmpty()) {
                        q.and("costaccount", "in", this.costAccountIds);
                    }
                    if (!this.materialIds.isEmpty()) {
                        q.and("material", "in", this.materialIds);
                    }
                }
            }
            Boolean srcIsDetail = this.srcIsDetailMap.get(costPriceNum);
            DataSet srcDataSet = null;
            try {
                DataSet beginDataSet;
                DataSet endDataSet;
                QFilter qbegin;
                QFilter qend;
                OrmInput input;
                ArrayList<OrmInput> ormInputs;
                List<QFilter> filters;
                Integer beforePeriod;
                if (srcIsDetail != null && srcIsDetail.booleanValue()) {
                    if ("cal_costrecord".equals(srcBillType) || "cal_costrecord_subentity".equals(srcBillType)) {
                        q.and("entry.subentrycostelement.costsubelement", "in", this.srcCostSubElementIdMap.get(costPriceNum));
                        beforePeriod = costPrice.getInt("entry.beforeperiod");
                        filters = this.getBeforePeriodFilters(beforePeriod, priceType, q);
                        ormInputs = new ArrayList(16);
                        for (QFilter filter : filters) {
                            input = new OrmInput(this.getClass().getName() + "-costrecord", "cal_costrecord_subentity", this.selectFields("cal_costrecord_subentity") + ",entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_baseqty as baseqty,entry.subentrycostelement.sub_actualcost as actualcost,entry.subentrycostelement.sub_unitactualcost as unitactualcost", filter.toArray());
                            ormInputs.add(input);
                        }
                        if (!ormInputs.isEmpty()) {
                            srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])ormInputs.toArray(new OrmInput[0])).where("actualcost <> null and actualcost <> 0");
                        }
                    } else if ("cal_balance".equals(srcBillType)) {
                        if (this.isNewBalance) {
                            qend = q.copy().and(this.getEndBalanceFilter());
                            DataSet endDetailDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qend));
                            if (this.srcCostSubElementIdMap.get(costPriceNum) != null && this.srcCostSubElementIdMap.get(costPriceNum).size() > 0) {
                                endDetailDataSet = endDetailDataSet.where(new QFilter("costsubelement", "in", this.srcCostSubElementIdMap.get(costPriceNum)).toString());
                            }
                            endDetailDataSet = endDetailDataSet.select(this.selectFields(srcBillType + "_base") + ",costsubelement,actualcost_bal as periodbeginactualcost,baseqty_bal as periodbeginqty,0 as periodinqty, 0 as periodinactualcost");
                            qbegin = q.copy().and(this.getBeginBalanceFilter());
                            DataSet beginDetailDataSet = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qbegin));
                            if (this.srcCostSubElementIdMap.get(costPriceNum) != null && this.srcCostSubElementIdMap.get(costPriceNum).size() > 0) {
                                beginDetailDataSet = beginDetailDataSet.where(new QFilter("costsubelement", "in", this.srcCostSubElementIdMap.get(costPriceNum)).toString());
                            }
                            beginDetailDataSet = beginDetailDataSet.select(this.selectFields(srcBillType + "_base") + ",costsubelement,actualcost as periodbeginactualcost,baseqty as periodbeginqty,baseqty_in as periodinqty, actualcost_in as periodinactualcost");
                            srcDataSet = beginDetailDataSet.union(endDetailDataSet).groupBy((this.selectFields(srcBillType) + ",costsubelement").split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                        } else {
                            if (this.srcCostSubElementIdMap.get(costPriceNum) != null && this.srcCostSubElementIdMap.get(costPriceNum).size() > 0) {
                                q.and("entryentity.costsubelement", "in", this.srcCostSubElementIdMap.get(costPriceNum));
                            }
                            qend = q.copy().and(this.getEndBalanceFilter());
                            endDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balanceend"), (String)"cal_balance_subentity", (String)(this.selectFields("cal_balance_base") + ",entryentity.costsubelement as costsubelement,entryentity.sub_periodendactualcost as periodbeginactualcost,entryentity.sub_periodendqty as periodbeginqty,0 as periodinqty, 0 as periodinactualcost"), (QFilter[])qend.toArray(), null);
                            qbegin = q.copy().and(this.getBeginBalanceFilter());
                            beginDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balancebegin"), (String)"cal_balance_subentity", (String)(this.selectFields("cal_balance_base") + ",entryentity.costsubelement as costsubelement,entryentity.sub_periodbeginactualcost as periodbeginactualcost,entryentity.sub_periodbeginqty as periodbeginqty,entryentity.sub_periodinqty as periodinqty, entryentity.sub_periodinactualcost as periodinactualcost"), (QFilter[])qbegin.toArray(), null);
                            srcDataSet = beginDataSet.union(endDataSet).groupBy((this.selectFields("cal_balance") + ",costsubelement").split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                        }
                    }
                } else if ("cal_balance".equals(srcBillType)) {
                    if (this.isNewBalance) {
                        String balSelectField = CalBalanceModelHelper.getDimFields((boolean)false) + ",calorg,calrange";
                        String[] groupFields = (balSelectField + ",bookdate,auditdate").split(",");
                        QFilter qend2 = q.copy().and(this.getEndBalanceFilter());
                        DataSet endDataSet2 = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qend2)).select(balSelectField + ",0 as bookdate,0 as auditdate,actualcost_bal as periodbeginactualcost,baseqty_bal as periodbeginqty,0 as periodinqty,0 as periodinactualcost").groupBy(groupFields).max("periodbeginqty").max("periodinqty").sum("periodbeginactualcost").sum("periodinactualcost").finish();
                        QFilter qbegin2 = q.copy().and(this.getBeginBalanceFilter());
                        DataSet beginDataSet2 = BalanceUncompressHelper.getBalancDataSetDetail(false, false, null, Collections.singletonList(qbegin2)).select(balSelectField + ",0 as bookdate,0 as auditdate,actualcost as periodbeginactualcost,baseqty as periodbeginqty,baseqty_in as periodinqty, actualcost_in as periodinactualcost").groupBy(groupFields).max("periodbeginqty").max("periodinqty").sum("periodbeginactualcost").sum("periodinactualcost").finish();
                        srcDataSet = endDataSet2.union(beginDataSet2).groupBy(groupFields).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                    } else {
                        qend = q.copy().and(this.getEndBalanceFilter());
                        endDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balanceend"), (String)srcBillType, (String)(this.selectFields(srcBillType + "_base") + ",periodendactualcost as periodbeginactualcost,periodendqty as periodbeginqty,0 as periodinqty,0 as periodinactualcost"), (QFilter[])qend.toArray(), null);
                        qbegin = q.copy().and(this.getBeginBalanceFilter());
                        beginDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-balancebegin"), (String)srcBillType, (String)(this.selectFields(srcBillType + "_base") + ",periodbeginactualcost,periodbeginqty,periodinqty,periodinactualcost"), (QFilter[])qbegin.toArray(), null);
                        srcDataSet = endDataSet.union(beginDataSet).groupBy(this.selectFields(srcBillType).split(",")).sum("periodbeginactualcost").sum("periodbeginqty").sum("periodinqty").sum("periodinactualcost").finish().where("periodbeginactualcost <> 0 or periodbeginqty <> 0 or periodinqty <> 0 or periodinactualcost <> 0");
                    }
                } else if ("cal_recentcost".equals(srcBillType)) {
                    srcDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-recentcost"), (String)srcBillType, (String)(this.selectFields(srcBillType) + "," + srcVars), (QFilter[])q.toArray(), null);
                } else if ("cal_costrecord".equals(srcBillType) || "cal_costrecord_subentity".equals(srcBillType)) {
                    beforePeriod = costPrice.getInt("entry.beforeperiod");
                    filters = this.getBeforePeriodFilters(beforePeriod, priceType, q);
                    ormInputs = new ArrayList<OrmInput>(16);
                    for (QFilter filter : filters) {
                        input = new OrmInput(this.getClass().getName() + "-costrecord", srcBillType, this.selectFields(srcBillType) + "," + srcVars, filter.toArray());
                        ormInputs.add(input);
                    }
                    if (!ormInputs.isEmpty()) {
                        srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])ormInputs.toArray(new OrmInput[0]));
                    }
                }
            }
            catch (Exception e) {
                log.error("CostPriceHelper createSrcMap", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bf9\u5e94\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\uff0c\u4ee5\u53ca\u6210\u672c\u4ef7\u7c7b\u522b--\u5355\u4ef7\u7c7b\u522b\u8bbe\u7f6e\u9879\u3002", (String)"CostPriceHelper_01", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            if (srcDataSet == null) continue;
            DataSet copy = srcDataSet.copy();
            if (srcDataSet.isEmpty()) continue;
            this.srcDataSetMap.put(costPriceNum, copy);
        }
    }

    private List<QFilter> getBeforePeriodFilters(Integer beforePeriod, String priceType, QFilter q) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        for (Map.Entry<Long, DynamicObject> entryMap : this.currentPeriodMap.entrySet()) {
            Long costAccountId = entryMap.getKey();
            DynamicObject currentPeriod = entryMap.getValue();
            QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            Date startDate = null;
            Date endDate = null;
            if (beforePeriod == 0) {
                if ("B".equals(priceType)) {
                    startDate = currentPeriod.getDate("begindate");
                    endDate = currentPeriod.getDate("enddate");
                } else {
                    endDate = currentPeriod.getDate("enddate");
                    if (this.maxBookDate != null) {
                        endDate = this.maxBookDate;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(endDate);
                    calendar.add(1, -1);
                    startDate = calendar.getTime();
                }
            } else if (beforePeriod > 0) {
                DynamicObjectCollection beforePeriods = this.getCurrentPeriodBeforePeriod(currentPeriod);
                if (beforePeriod != null || beforePeriods.size() > 0) {
                    endDate = ((DynamicObject)beforePeriods.get(0)).getDate("enddate");
                    int size = beforePeriods.size();
                    startDate = size >= beforePeriod ? ((DynamicObject)beforePeriods.get(beforePeriod - 1)).getDate("begindate") : ((DynamicObject)beforePeriods.get(size - 1)).getDate("begindate");
                }
            }
            List costAccountBookdatefilters = DateUtils.getDateSplitFilters(startDate, endDate, (String)"bookdate");
            for (QFilter costAccountBookdatefilter : costAccountBookdatefilters) {
                costAccountBookdatefilter.and(qFilter);
                costAccountBookdatefilter.and(q);
            }
            filters.addAll(costAccountBookdatefilters);
        }
        return filters;
    }

    private QFilter getBeginBalanceFilter() {
        QFilter q = null;
        for (Map.Entry<Long, DynamicObject> entryMap : this.currentPeriodMap.entrySet()) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)entryMap.getKey());
            DynamicObject period = entryMap.getValue();
            int periodnumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
            qFilter.and("period", "=", (Object)periodnumber);
            if (q == null) {
                q = qFilter;
                continue;
            }
            q.or(qFilter);
        }
        return q;
    }

    private QFilter getEndBalanceFilter() {
        QFilter q = null;
        for (Map.Entry<Long, DynamicObject> entryMap : this.currentPeriodMap.entrySet()) {
            QFilter qFilter = new QFilter("costaccount", "=", (Object)entryMap.getKey());
            DynamicObject period = entryMap.getValue();
            int periodnumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
            qFilter.and("period", "<", (Object)periodnumber);
            qFilter.and("endperiod", ">", (Object)periodnumber);
            if (q == null) {
                q = qFilter;
                continue;
            }
            q.or(qFilter);
        }
        return q;
    }

    public String getErrorMsg(Exception e) {
        StringBuilder message = new StringBuilder();
        if (e instanceof KDBizException) {
            if (e.getMessage() != null) {
                message.append(e.getMessage());
            }
        } else {
            StackTraceElement[] errs;
            if (e.getMessage() != null) {
                message.append(e.getMessage());
                message.append("\n");
            }
            log.error("CostPriceHelper getErrorMsg", (Throwable)e);
            for (StackTraceElement err : errs = e.getStackTrace()) {
                message.append(err);
                message.append("\n");
            }
        }
        return message.toString();
    }

    private void createCostPriceMap() {
        QFilter costPriceFilter = new QFilter("entry.pricenum", "in", this.costPriceNumList);
        DynamicObjectCollection costPrices = QueryServiceHelper.query((String)"cal_costprice", (String)"entry.pricenum,entry.entityobject.number,entry.billfilter_tag,entry.priceplugin,entry.beforeperiod, entry.type", (QFilter[])costPriceFilter.toArray());
        for (DynamicObject costPrice : costPrices) {
            String costPriceNum = costPrice.getString("entry.pricenum");
            String priceType = costPrice.getString("entry.type");
            this.costPriceMap.put(costPriceNum, costPrice);
            this.srcPriceTypeMap.put(costPriceNum, priceType);
        }
    }

    private void createPriceLibMap() {
        DynamicObject priceLib = BusinessDataServiceHelper.loadSingleFromCache((Object)747819409392815104L, (String)"cal_pricelib");
        DynamicObjectCollection entrys = priceLib.getDynamicObjectCollection("entry");
        for (DynamicObject dynamicObject : entrys) {
            this.priceLibMap.put(dynamicObject.getString("pricenum"), dynamicObject);
        }
    }

    private DynamicObjectCollection getCurrentPeriodBeforePeriod(DynamicObject currentPeriod) {
        Long currentPeriodId = currentPeriod.getLong("id");
        DynamicObjectCollection cols = this.beforePeriodCols.get(currentPeriodId);
        if (cols != null) {
            return cols;
        }
        QFilter filterType = new QFilter("periodtype", "=", (Object)this.currentPeriodTypeMap.get(currentPeriodId));
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currentPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currentPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currentPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        cols = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        this.beforePeriodCols.put(currentPeriodId, cols);
        return cols;
    }

    private void createCostPriceBySchemeFromCostRecord(DynamicObject matchSchemeInfo, Row row) {
        String pricedimension = matchSchemeInfo.getString("pricedimension");
        Long calRangeid = row.getLong("calrange");
        String dividebasis = row.getString("dividebasis");
        String caldimension = row.getString("caldimension");
        Set<String> dimensionSet = this.getPriceDimensionSet(dividebasis, caldimension, pricedimension, calRangeid);
        DynamicObjectCollection entryentitys = matchSchemeInfo.getDynamicObjectCollection("entry");
        for (DynamicObject cp : entryentitys) {
            boolean hasPrice;
            String costPriceNum = cp.getString("costprice");
            if (this.singleCostPriceNum != null && !this.singleCostPriceNum.equals(costPriceNum)) continue;
            String costPriceDisplay = cp.getString("pricedisplay");
            String srcVars = this.srcPriceVars.get(costPriceNum);
            String srcExp2Dest = this.srcExp2DestVars.get(costPriceNum);
            DataSet srcRowDataSet = this.srcDataSetMap.get(costPriceNum);
            String priceType = this.srcPriceTypeMap.get(costPriceNum);
            boolean detail = this.srcIsDetailMap.get(costPriceNum);
            String costSubElement = "";
            if (detail) {
                costSubElement = ",costsubelement";
            }
            if (srcRowDataSet == null) continue;
            srcRowDataSet = srcRowDataSet.copy();
            if ("C".equals(priceType)) {
                srcRowDataSet = srcRowDataSet.where("detailid = " + String.valueOf(row.get("entry.id")));
            } else {
                QFilter dimFilter = null;
                for (String dim : dimensionSet) {
                    String[] dimValue = row.get(dim);
                    if (dimValue == null || "".equals(dimValue)) continue;
                    QFilter q = new QFilter(dim, "=", (Object)dimValue);
                    if (dimFilter == null) {
                        dimFilter = q;
                        continue;
                    }
                    dimFilter.and(q);
                }
                if (dimFilter != null) {
                    srcRowDataSet = srcRowDataSet.where(dimFilter.toString());
                }
                srcRowDataSet = srcRowDataSet.select((String.valueOf(row.get("entry.id")) + " as detailid," + String.join((CharSequence)",", dimensionSet) + ",bookdate,auditdate," + srcVars + costSubElement).split(","));
                if ("A".equals(priceType)) {
                    DataSet newestDataSet = srcRowDataSet.copy().orderBy("bookdate desc,auditdate desc".split(",")).top(1);
                    srcRowDataSet = detail ? newestDataSet.join(srcRowDataSet, JoinType.LEFT).on("detailid", "detailid").on("bookdate", "bookdate").on("auditdate", "auditdate").select(new String[]{"detailid"}, (String.join((CharSequence)",", dimensionSet) + ",bookdate,auditdate,costsubelement," + srcVars).split(",")).finish() : newestDataSet;
                } else if ("B".equals(priceType)) {
                    HashSet<String> groupbySet = new HashSet<String>(16);
                    groupbySet.addAll(dimensionSet);
                    groupbySet.add("detailid");
                    if (detail) {
                        groupbySet.add("costsubelement");
                    }
                    Iterator groupbyDataSet = srcRowDataSet.groupBy(groupbySet.toArray(new String[groupbySet.size()]));
                    for (String var : srcVars.split(",")) {
                        groupbyDataSet = groupbyDataSet.sum(var);
                    }
                    srcRowDataSet = groupbyDataSet.finish();
                }
            }
            if (!(hasPrice = this.hasPrice(srcRowDataSet.copy()))) continue;
            if ("C".equals(priceType)) {
                srcRowDataSet = srcRowDataSet.select(("detailid," + srcExp2Dest + costSubElement).split(","));
                boolean hasprice = false;
                if (detail) {
                    for (Row srcRow : srcRowDataSet) {
                        Long entryId = srcRow.getLong("detailid");
                        String costSubElementId = srcRow.getString("costsubelement");
                        BigDecimal unitactualcost = srcRow.getBigDecimal("unitactualcost") == null ? BigDecimal.ZERO : srcRow.getBigDecimal("unitactualcost");
                        if (unitactualcost.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.srcPriceDisplayMap.put(entryId, costPriceDisplay);
                        hasprice = true;
                    }
                    if (hasprice) {
                        return;
                    }
                } else {
                    Row srcRow = srcRowDataSet.next();
                    Long entryId = srcRow.getLong("detailid");
                    List<Object> costSubElementId = this.destCostSubElementIdMap.get(costPriceNum);
                    BigDecimal unitactualcost = srcRow.getBigDecimal("unitactualcost");
                    if (unitactualcost.compareTo(BigDecimal.ZERO) != 0) {
                        this.srcPriceDisplayMap.put(entryId, costPriceDisplay);
                        return;
                    }
                }
            }
            try {
                srcRowDataSet = srcRowDataSet.select(("detailid," + srcExp2Dest + costSubElement).split(","));
            }
            catch (Exception e) {
                log.info("CostPriceHelper createCostPriceBySchemeFromCostRecord", (Object)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u53d6\u4ef7\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostPriceHelper_5", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            String[] fields = srcRowDataSet.getRowMeta().getFieldNames();
            HashMap<String, Object> map = new HashMap<String, Object>();
            boolean isDetail = this.destIsDetailMap.get(costPriceNum);
            if (isDetail) {
                boolean hasprice = false;
                for (Row srcRow : srcRowDataSet) {
                    Long entryId = srcRow.getLong("detailid");
                    Object costSubElementId = srcRow.get("costsubelement");
                    BigDecimal unitactualcost = srcRow.getBigDecimal("unitactualcost");
                    if (unitactualcost.compareTo(BigDecimal.ZERO) == 0) continue;
                    Object[] updateObjects = new Object[]{unitactualcost, unitactualcost, entryId, costSubElementId};
                    this.costRecordDetailUpdateList.add(updateObjects);
                    this.srcPriceDisplayMap.put(entryId, costPriceDisplay);
                    hasprice = true;
                }
                if (!hasprice) continue;
                return;
            }
            Row srcRow = srcRowDataSet.next();
            Long entryId = null;
            for (int i = 0; i < fields.length; ++i) {
                if ("detailid".equals(fields[i])) {
                    entryId = (Long)srcRow.get(i);
                    continue;
                }
                if (((BigDecimal)srcRow.get(i)).signum() == 0) continue;
                map.put(fields[i].trim(), srcRow.get(i));
            }
            if (map == null) continue;
            this.resultMap.put(entryId, map);
            return;
        }
    }

    private boolean hasPrice(DataSet copy) {
        if (copy.hasNext()) {
            List<String> fieldNames = Arrays.asList(copy.getRowMeta().getFieldNames());
            Row srcRow = copy.next();
            return !(fieldNames.contains("entry.baseqty") && srcRow.getBigDecimal("entry.baseqty").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginqty") && !fieldNames.contains("periodinqty") && srcRow.getBigDecimal("periodbeginqty").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginqty") && fieldNames.contains("periodinqty") && srcRow.getBigDecimal("periodbeginqty").add(srcRow.getBigDecimal("periodinqty")).compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginactualcost") && !fieldNames.contains("periodinactualcost") && srcRow.getBigDecimal("periodbeginactualcost").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("periodbeginactualcost") && fieldNames.contains("periodinactualcost") && srcRow.getBigDecimal("periodbeginactualcost").add(srcRow.getBigDecimal("periodinactualcost")).compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("entry.unitactualcost") && srcRow.getBigDecimal("entry.unitactualcost").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("entry.actualcost") && srcRow.getBigDecimal("entry.actualcost").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("recentqty") && srcRow.getBigDecimal("recentqty").compareTo(BigDecimal.ZERO) == 0 || fieldNames.contains("recentcost") && srcRow.getBigDecimal("recentcost").compareTo(BigDecimal.ZERO) == 0);
        }
        return false;
    }

    private Set<String> getPriceDimensionSet(String dividebasis, String caldimension, String pricedimension, Long calRangeid) {
        HashSet<String> dimensionSet = new HashSet<String>(16);
        dimensionSet.add("calorg");
        dimensionSet.add("costaccount");
        dimensionSet.add("material");
        if (("B".equals(pricedimension) || "C".equals(pricedimension)) && StringUtils.isNotEmpty((String)dividebasis)) {
            if (this.notEmptyCalRangeIds.contains(calRangeid)) {
                dimensionSet.add("calrange");
            } else {
                for (String div : dividebasis.split(",")) {
                    dimensionSet.add(div);
                }
            }
        }
        if ("C".equals(pricedimension) && StringUtils.isNotEmpty((String)caldimension)) {
            for (String cal : caldimension.split(",")) {
                dimensionSet.add(cal);
            }
        }
        return dimensionSet;
    }

    private QFilter getBillFilter(String billType, String billfilter) {
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (billfilter != null && !"".equals(billfilter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilter, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            List qFilters = filterBuilder.getQFilters();
            for (QFilter qFilter : qFilters) {
                q.and(qFilter);
            }
        }
        return q;
    }

    private String getSrcExp2Dest(String srcPrice, String destPrice) {
        ArrayList<String> srcNumbers = new ArrayList<String>(Arrays.asList(srcPrice.split(",")));
        srcNumbers.remove("");
        ArrayList<String> destNumbers = new ArrayList<String>(Arrays.asList(destPrice.split(",")));
        destNumbers.remove("");
        int n = srcNumbers.size();
        StringBuilder result = new StringBuilder();
        DynamicObject prices = this.priceLibMap.get(srcNumbers.get(0));
        boolean isDetail = prices.getBoolean("isdetail");
        if (isDetail) {
            DynamicObject srcPrices = this.priceLibMap.get(srcNumbers.get(0));
            DynamicObject destPrices = this.priceLibMap.get(destNumbers.get(0));
            String srcEntityObject = String.valueOf(srcPrices.getDynamicObject("entityobject").getPkValue());
            if ("cal_costrecord".equals(srcEntityObject) || "cal_costrecord_subentity".equals(srcEntityObject)) {
                srcEntityObject = "cal_costrecord_detail";
            }
            String srcPriceExp = srcPrices.getString("priceexp_tag");
            String destPriceExp = destPrices.getString("priceexp_tag");
            result.append(this.getRealExp(srcEntityObject, srcPriceExp));
            result.append(" as ");
            result.append(destPriceExp);
            result.append(",");
        } else {
            for (int i = 0; i < n; ++i) {
                DynamicObject srcPrices = this.priceLibMap.get(srcNumbers.get(i));
                DynamicObject destPrices = this.priceLibMap.get(destNumbers.get(i));
                String srcEntityObject = String.valueOf(srcPrices.getDynamicObject("entityobject").getPkValue());
                String srcPriceExp = srcPrices.getString("priceexp_tag");
                String destPriceExp = destPrices.getString("priceexp_tag");
                result.append(this.getRealExp(srcEntityObject, srcPriceExp));
                result.append(" as ");
                result.append(destPriceExp);
                result.append(",");
            }
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    private String getSrcVars(String srcPrice) {
        HashSet<String> result = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)srcPrice)) {
            ArrayList<String> srcNumbers = new ArrayList<String>(Arrays.asList(srcPrice.split(",")));
            srcNumbers.remove("");
            DynamicObject price = this.priceLibMap.get(srcNumbers.get(0));
            String srcEntityObject = String.valueOf(price.getDynamicObject("entityobject").getPkValue());
            boolean isDetail = price.getBoolean("isdetail");
            if (isDetail && ("cal_costrecord".equals(srcEntityObject) || "cal_costrecord_subentity".equals(srcEntityObject))) {
                srcEntityObject = "cal_costrecord_detail";
            }
            for (String priceNum : srcNumbers) {
                price = this.priceLibMap.get(priceNum);
                String srcPriceExp = price.getString("priceexp_tag");
                if (!StringUtils.isNotEmpty((String)srcPriceExp)) continue;
                result.addAll(Arrays.asList(this.getRealVars(srcEntityObject, srcPriceExp).split(",")));
            }
        } else {
            result.add("entry.unitactualcost");
        }
        return String.join((CharSequence)",", result);
    }

    private String getRealVars(String entityObject, String priceExp) {
        StringBuilder varStr = new StringBuilder();
        String op = "[\\+\\-\\*\\/\\(\\)]";
        String[] vars = priceExp.split(op);
        MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)entityObject);
        for (String var : vars) {
            if ((var = var.trim()).equals("")) continue;
            IDataEntityProperty dataEntity = billDataEntity.findProperty(var);
            if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
                varStr.append(dataEntity.getParent().getName());
                varStr.append(".");
                varStr.append(var);
                varStr.append(",");
                continue;
            }
            varStr.append(var);
            varStr.append(",");
        }
        return varStr.substring(0, varStr.length() - 1);
    }

    private String getRealExp(String entityObject, String priceExp) {
        if ("cal_balance".equals(entityObject)) {
            priceExp = priceExp.contains("periodinqty") ? "case when periodbeginqty+periodinqty =0 then 0 else (periodbeginactualcost+periodinactualcost)/(periodbeginqty+periodinqty) end " : "case when periodbeginqty =0 then 0 else periodbeginactualcost/periodbeginqty end ";
        } else {
            String op = "[\\+\\-\\*\\/\\(\\)\\s]";
            String reg = "^aa(?=[\\)*\\+\\-\\*\\/])|(?<=[(\\+\\-\\*\\/])aa(?=[\\)*\\+\\-\\*\\/])|(?<=[\\+\\-\\*\\/])aa$|^aa$";
            String[] vars = priceExp.split(op);
            MainEntityType billDataEntity = EntityMetadataCache.getDataEntityType((String)entityObject);
            for (String var : vars) {
                IDataEntityProperty dataEntity;
                if (var.equals("") || (dataEntity = billDataEntity.findProperty(var.trim())) == null || !(dataEntity.getParent() instanceof EntryType)) continue;
                priceExp = priceExp.replaceAll(reg.replace("aa", var), dataEntity.getParent().getName() + "." + var.trim());
            }
        }
        return priceExp;
    }

    private String selectFields(String s) {
        String resultStr = "";
        switch (s) {
            case "dest": {
                resultStr = "id,bizbillid,bookdate,entry.id,calorg,costaccount,entry.material as material,entry.calrange as calrange,entry.owner as owner, storageorgunit as storageorgunit, entry.warehouse as warehouse, entry.location as location, entry.lot as lot, entry.project as project, entry.assist as assist,costaccount.dividebasis.dividebasis as dividebasis,entry.calrange.caldimension.caldimension as caldimension" + this.cal_costrecord_ex.toString();
                break;
            }
            case "costadjustbilldest": {
                resultStr = "0 as bizbillid,entryentity.id as entry.id,calorg,costaccount,entryentity.material as material,entryentity.calrange as calrange,entryentity.owner as owner, entryentity.storageorgunit as storageorgunit, entryentity.warehouse as warehouse, entryentity.location as location, entryentity.lot as lot, entryentity.project as project, entryentity.assist as assist,costaccount.dividebasis.dividebasis as dividebasis,entryentity.caldimension.caldimension as caldimension" + this.cal_costadjustbill_ex.toString();
                break;
            }
            case "cal_costrecord": 
            case "cal_costrecord_subentity": {
                resultStr = "id,entry.id as detailid,calorg,costaccount,entry.material as material,entry.calrange as calrange,entry.owner as owner, storageorgunit as storageorgunit, entry.warehouse as warehouse, entry.location as location, entry.lot as lot, entry.project as project, entry.assist as assist,bookdate,auditdate" + this.cal_costrecord_ex.toString();
                break;
            }
            case "cal_balance": {
                resultStr = "calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,bookdate,auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_balance_base": {
                resultStr = "id,calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_recentcost": {
                resultStr = "calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,0 as bookdate,0 as auditdate" + this.cal_balance_ex;
                break;
            }
            case "cal_costrecord_price": {
                resultStr = "entry.id,entry.baseqty,entry.unitmaterialcost,entry.materialcost,entry.unitfee,entry.fee,entry.unitprocesscost,entry.processcost,entry.unitmanufacturecost,entry.manufacturecost,entry.unitresource,entry.resource,entry.unitactualcost,entry.actualcost";
                break;
            }
            case "base": {
                resultStr = "detailid,calorg,costaccount,material,calrange,owner,storageorgunit,warehouse,location,lot,project,assist,bookdate,auditdate" + this.cal_balance_ex.toString();
                break;
            }
        }
        return resultStr;
    }
}

