/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class DayAvgPriceHelper {
    private static Log log = LogFactory.getLog(DayAvgPriceHelper.class);
    private final QFilter dimFilter;
    private QFilter costRecDimFilter = null;
    private QFilter adjDimFilter = null;
    private Set<Long> calOrgIds;
    private Date calDate;
    private Set<Long> matIds;
    private final boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private final Set<Long> notUpdateBalBizTypeIds = CommonSettingHelper.getNotUpdBalBizType();
    private final String[] groupDim = new String[]{"costaccount", "calorg", "material"};
    private static final String[] DIFF_BILLTYPE = new String[]{"G", "H", "K"};

    public DayAvgPriceHelper(Set<Long> calOrgIds, Date calDate, Set<Long> matIds, QFilter dimFilter) {
        this.calOrgIds = calOrgIds;
        this.calDate = calDate;
        this.matIds = matIds;
        this.dimFilter = dimFilter;
        this.costRecDimFilter = this.getCostRecDimFilter(dimFilter);
        this.adjDimFilter = this.getAdjDimFilter(dimFilter);
    }

    public Map<String, BigDecimal> getDayAvgPrice() {
        this.calDate = DateUtils.addDateTime((Date)this.calDate, (int)5, (int)1);
        Map<Long, Long> calOrgIdAcctIdMap = this.getAcctIdByCalOrgId(this.calOrgIds);
        Map acctIdPeriodDycMap = PeriodHelper.getCurrentPeriods(new HashSet<Long>(calOrgIdAcctIdMap.values()));
        Map<Long, Set<Long>> periodIdAcctIdsMap = this.getPeriodIdAcctIdsMap(acctIdPeriodDycMap);
        DataSet allDs = this.getAllDs(acctIdPeriodDycMap, periodIdAcctIdsMap);
        allDs = allDs.groupBy(this.groupDim).sum("periodendactualcost").sum("reccost").sum("periodendqty").sum("recqty").finish();
        Map<String, BigDecimal> calOrgMatAvgPriceMap = this.getCalOrgMatAvgPriceMap(allDs);
        return calOrgMatAvgPriceMap;
    }

    private QFilter getAdjDimFilter(QFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        QFilter adjDimF = dimFilter.copy();
        String property = adjDimF.getProperty();
        String fieldPath = CommonUtils.getFieldPath((String)"cal_costadjust_subentity", (String)property);
        adjDimF.__setProperty(fieldPath);
        List nests = adjDimF.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter curFilter = nest.getFilter();
            String curProperty = curFilter.getProperty();
            String curFieldPath = CommonUtils.getFieldPath((String)"cal_costadjust_subentity", (String)curProperty);
            curFilter.__setProperty(curFieldPath);
        }
        return adjDimF;
    }

    private QFilter getCostRecDimFilter(QFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        QFilter costRecDimF = dimFilter.copy();
        String property = costRecDimF.getProperty();
        String fieldPath = CommonUtils.getFieldPath((String)"cal_costrecord_subentity", (String)property);
        costRecDimF.__setProperty(fieldPath);
        List nests = costRecDimF.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter curFilter = nest.getFilter();
            String curProperty = curFilter.getProperty();
            String curFieldPath = CommonUtils.getFieldPath((String)"cal_costrecord_subentity", (String)curProperty);
            curFilter.__setProperty(curFieldPath);
        }
        return costRecDimF;
    }

    private DataSet getAllDs(Map<Long, DynamicObject> acctIdPeriodDycMap, Map<Long, Set<Long>> periodIdAcctIdsMap) {
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        for (Set<Long> acctIds : periodIdAcctIdsMap.values()) {
            DynamicObject periodDyc = acctIdPeriodDycMap.get(acctIds.iterator().next());
            Date periodFirstDate = periodDyc.getDate("begindate");
            this.addOldBalInput(inputs, acctIds, periodDyc);
            this.addCostRecInput(inputs, acctIds, periodFirstDate);
            this.addAdjInput(inputs, acctIds, periodFirstDate);
        }
        DataSet allDs = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        DataSet newBalDs = this.getNewBalDs(acctIdPeriodDycMap, periodIdAcctIdsMap);
        if (newBalDs != null) {
            newBalDs = newBalDs.select(allDs.getRowMeta().getFieldNames());
            allDs = allDs.union(newBalDs);
        }
        return allDs;
    }

    private DataSet getNewBalDs(Map<Long, DynamicObject> acctIdPeriodDycMap, Map<Long, Set<Long>> periodIdAcctIdsMap) {
        if (!this.isNewBalance) {
            return null;
        }
        DataSet newBalDs = null;
        ArrayList<OrmInput> newBalInputs = new ArrayList<OrmInput>(16);
        String dimFields = CalBalanceModelHelper.getDimFields((boolean)false);
        StringBuilder selSB = new StringBuilder();
        selSB.append(dimFields);
        selSB.append(",calorg,baseqty_bal periodendqty,actualcost_bal periodendactualcost,0.0 recqty, 0.0 reccost");
        RowMeta newBalRowMeta = ORM.create().createRowMeta("cal_bal", selSB.toString());
        newBalRowMeta.getField("recqty").setDataType((DataType)DataType.BigDecimalType);
        newBalRowMeta.getField("reccost").setDataType((DataType)DataType.BigDecimalType);
        newBalRowMeta.getField("periodendqty").setDataType((DataType)DataType.BigDecimalType);
        newBalRowMeta.getField("periodendactualcost").setDataType((DataType)DataType.BigDecimalType);
        for (Set<Long> acctIds : periodIdAcctIdsMap.values()) {
            DynamicObject periodDyc = acctIdPeriodDycMap.get(acctIds.iterator().next());
            int periodYear = periodDyc.getInt("periodyear");
            int periodNum = periodDyc.getInt("periodnumber");
            int period = periodYear * 100 + periodNum;
            QFilter balF = this.buildBalFilter(period, acctIds);
            OrmInput newBalInput = new OrmInput(this.getClass().getName(), "cal_bal", selSB.toString(), balF.toArray(), newBalRowMeta);
            newBalInputs.add(newBalInput);
        }
        newBalDs = Algo.create((String)this.getClass().getName()).createDataSet((Input[])newBalInputs.toArray(new OrmInput[0]));
        String[] split = (dimFields + ",calorg").split(",");
        newBalDs = newBalDs.groupBy(split).max("periodendqty").sum("periodendactualcost").sum("recqty").sum("reccost").finish();
        return newBalDs;
    }

    private Map<Long, Set<Long>> getPeriodIdAcctIdsMap(Map<Long, DynamicObject> acctIdPeriodDycMap) {
        HashMap<Long, Set<Long>> periodIdAcctIdsMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, DynamicObject> acctIdPeriodDycEnt : acctIdPeriodDycMap.entrySet()) {
            DynamicObject periodDyc = acctIdPeriodDycEnt.getValue();
            Set acctIds = periodIdAcctIdsMap.computeIfAbsent((Long)periodDyc.getPkValue(), k -> new HashSet(16));
            acctIds.add(acctIdPeriodDycEnt.getKey());
        }
        return periodIdAcctIdsMap;
    }

    private Map<Long, Long> getAcctIdByCalOrgId(Set<Long> calOrgIds) {
        HashMap<Long, Long> calOrgIdAcctIdMap = new HashMap<Long, Long>(16);
        QFilter calOrgF = new QFilter("calorg", "in", calOrgIds);
        calOrgF.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DataSet costAcctDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,calorg,ismainaccount", (QFilter[])calOrgF.toArray(), (String)"ismainaccount desc");
        for (Row row : costAcctDs) {
            boolean isNotAdded;
            Long calOrgId = row.getLong("calorg");
            Long acctId = row.getLong("id");
            Boolean isMainAcct = row.getBoolean("ismainaccount");
            boolean bl = isNotAdded = !calOrgIdAcctIdMap.containsKey(calOrgId);
            if (!isMainAcct.booleanValue() && !isNotAdded) continue;
            calOrgIdAcctIdMap.put(calOrgId, acctId);
        }
        log.info("DayAvgPriceHelper-acctIdCalOrdIdMap==>{}", calOrgIdAcctIdMap);
        return calOrgIdAcctIdMap;
    }

    private QFilter buildBalFilter(Integer periodNum, Set<Long> acctIds) {
        QFilter balF = new QFilter("costaccount", "in", acctIds);
        QFilter periodF = new QFilter("period", "<", (Object)periodNum);
        periodF.and("endperiod", ">=", (Object)periodNum);
        balF.and(periodF);
        QFilter matIdF = new QFilter("material", "in", this.matIds);
        balF.and(matIdF);
        balF.and(this.dimFilter);
        return balF;
    }

    private void addOldBalInput(List<OrmInput> inputs, Set<Long> acctIds, DynamicObject periodDyc) {
        if (this.isNewBalance) {
            return;
        }
        int periodYear = periodDyc.getInt("periodyear");
        int periodNum = periodDyc.getInt("periodnumber");
        int period = periodYear * 100 + periodNum;
        QFilter balF = this.buildBalFilter(period, acctIds);
        String sels = "costaccount,calorg,material,periodendqty,periodendactualcost,0.0 recqty, 0.0 reccost";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_balance", sels);
        rowMeta.getField("recqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("reccost").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("periodendqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("periodendactualcost").setDataType((DataType)DataType.BigDecimalType);
        OrmInput balInput = new OrmInput(this.getClass().getName(), "cal_balance", sels, balF.toArray(), rowMeta);
        inputs.add(balInput);
    }

    private void addCostRecInput(List<OrmInput> inputs, Set<Long> acctIds, Date periodFirstDate) {
        QFilter costRecF = new QFilter("bookdate", ">=", (Object)periodFirstDate);
        costRecF.and(new QFilter("bookdate", "<", (Object)this.calDate));
        costRecF.and("costaccount", "in", acctIds);
        costRecF.and("isinitbill", "=", (Object)Boolean.FALSE);
        costRecF.and("issplitcreate", "=", (Object)Boolean.FALSE);
        if (this.notUpdateBalBizTypeIds != null && !this.notUpdateBalBizTypeIds.isEmpty()) {
            costRecF.and("biztype", "not in", this.notUpdateBalBizTypeIds);
        }
        costRecF.and(new QFilter("billstatus", "=", (Object)"C"));
        costRecF.and(new QFilter("entry.material", "in", this.matIds));
        costRecF.and(this.costRecDimFilter);
        costRecF.and(new QFilter("entry.queuetype", "=", (Object)"0"));
        String costRecSel = "costaccount,calorg,entry.material material,0.0 periodendqty,0.0 periodendactualcost,entry.baseqty*entry.signnum recqty, entry.actualcost*entry.signnum reccost";
        RowMeta costRecRowMeta = ORM.create().createRowMeta("cal_costrecord", costRecSel);
        costRecRowMeta.getField("recqty").setDataType((DataType)DataType.BigDecimalType);
        costRecRowMeta.getField("reccost").setDataType((DataType)DataType.BigDecimalType);
        costRecRowMeta.getField("periodendqty").setDataType((DataType)DataType.BigDecimalType);
        costRecRowMeta.getField("periodendactualcost").setDataType((DataType)DataType.BigDecimalType);
        OrmInput recInput = new OrmInput(this.getClass().getName(), "cal_costrecord", costRecSel, costRecF.toArray(), costRecRowMeta);
        inputs.add(recInput);
        log.info("DayAvgPriceHelper-filter-addCostRecInput==>{}", (Object)costRecF);
    }

    private void addAdjInput(List<OrmInput> inputs, Set<Long> acctIds, Date periodFirstDate) {
        QFilter adjF = new QFilter("bookdate", ">=", (Object)periodFirstDate);
        adjF.and(new QFilter("bookdate", "<", (Object)this.calDate));
        adjF.and("costaccount", "in", acctIds);
        adjF.and("createtype", "not in", (Object)DIFF_BILLTYPE);
        adjF.and("difftype", "=", (Object)"B");
        adjF.and("isupdatecost", "=", (Object)Boolean.TRUE);
        adjF.and(new QFilter("entryentity.material", "in", this.matIds));
        adjF.and(this.adjDimFilter);
        adjF.and(new QFilter("entryentity.queuetype", "=", (Object)"0"));
        String adjSel = "costaccount,calorg,entryentity.material material,0.0 periodendqty,0.0 periodendactualcost,0.0 recqty, entryentity.adjustamt*entryentity.signnum reccost";
        RowMeta adjRowMeta = ORM.create().createRowMeta("cal_costadjustbill", adjSel);
        adjRowMeta.getField("recqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("reccost").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("periodendqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("periodendactualcost").setDataType((DataType)DataType.BigDecimalType);
        OrmInput adjInput = new OrmInput(this.getClass().getName(), "cal_costadjustbill", adjSel, adjF.toArray(), adjRowMeta);
        inputs.add(adjInput);
        log.info("DayAvgPriceHelper-filter-addAdjInput==>{}", (Object)adjF);
    }

    private Map<String, BigDecimal> getCalOrgMatAvgPriceMap(DataSet allDs) {
        HashMap<String, BigDecimal> calOrgMatAvgPriceMap = new HashMap<String, BigDecimal>(16);
        for (Row row : allDs) {
            Long calOrgId = row.getLong("calorg");
            Long matId = row.getLong("material");
            String key = calOrgId + "," + matId;
            BigDecimal beginCost = row.getBigDecimal("periodendactualcost");
            BigDecimal recCost = row.getBigDecimal("reccost");
            BigDecimal beginQty = row.getBigDecimal("periodendqty");
            BigDecimal recQty = row.getBigDecimal("recqty");
            BigDecimal beginAndRecCost = beginCost.add(recCost);
            BigDecimal beginAndRecQty = beginQty.add(recQty);
            BigDecimal avgPrice = beginAndRecQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beginAndRecCost.divide(beginAndRecQty, 10, RoundingMode.HALF_UP);
            calOrgMatAvgPriceMap.put(key, avgPrice);
        }
        return calOrgMatAvgPriceMap;
    }
}

