/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.costprice.GroupCostUpdate4CostPriceFunction;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.util.CommonUtils;

public class GroupCostUpdate4CostPrice {
    private static Log log = LogFactory.getLog(GroupCostUpdate4CostPrice.class);
    private static final String COSTRECORD_ENTRY_UPDATESQL = "update t_cal_calcostrecordentry set funitactualcost = ?,factualcost = ?,funitmaterialcost = ?,fmaterialcost = ?,funitfee = ?,ffee = ?,funitprocesscost = ?,fprocesscost = ?, funitmanufacturecost = ?,fmanufacturecost = ?,funitresource = ?,fresource = ?,fcostpricesource = ?,fdesignatedcost = ?,fiscalculated = '1' where fentryid = ?";
    private static final String COSTRECORD_DETAIL_UPDATESQL = "update t_cal_costrecord_detail set factualcost = ?, funitactualcost = ? where fentryid = ? and fcostsubelementid = ?";

    public static String update(Map<String, Set<Long>> entity2BizbillidMap, Map<String, Set<Long>> costaccountPeriod2CalentryIdMap, Set<Long> costAccountIds) {
        log.info("\u8fd4\u5de5\u83b7\u53d6\u6210\u7ec4\u6210\u672c\u5f00\u59cbentity2BizbillidMap" + entity2BizbillidMap + "\r\ncostaccountPeriod2CalentryIdMap" + costaccountPeriod2CalentryIdMap);
        String filterStr = "1=1";
        if (entity2BizbillidMap.isEmpty() || costaccountPeriod2CalentryIdMap.isEmpty()) {
            log.info("\u8fd4\u5de5\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
            return filterStr;
        }
        DataSet groupDs = GroupCostUpdate4CostPrice.getGroupDataSet(entity2BizbillidMap, costaccountPeriod2CalentryIdMap);
        if (groupDs == null) {
            log.info("\u8fd4\u5de5\u67e5\u8be2\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55\u4e3a\u7a7a");
            return filterStr;
        }
        DataSet costRecordDs = GroupCostUpdate4CostPrice.getCostRecordDS(groupDs.copy());
        if (costRecordDs == null) {
            log.info("\u8fd4\u5de5\u67e5\u8be2\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e3a\u7a7a");
            return filterStr;
        }
        DataSet dataSet = groupDs.join(costRecordDs, JoinType.INNER).on("costrecordentryid", "entryid").select(groupDs.getRowMeta().getFieldNames(), costRecordDs.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.groupBy(new String[]{"groupid"}).reduceGroup((ReduceGroupFunctionWithCollector)new GroupCostUpdate4CostPriceFunction(costAccountIds));
        HashMap<String, Set> needCAP2CalEIdMap = new HashMap<String, Set>(4);
        HashMap<String, Long> caCalEid2CREIdMap = new HashMap<String, Long>(16);
        HashMap<Long, BigDecimal> crEntryid2BaseqtyMap = new HashMap<Long, BigDecimal>(16);
        HashSet<Long> costRecordIds = new HashSet<Long>(4);
        HashSet<Long> allCostAccountIds = new HashSet<Long>(4);
        for (Object row : dataSet) {
            Long l = row.getLong("costrecordid");
            Long costaccountid = row.getLong("costaccount");
            Long period = row.getLong("period");
            Long calentryid = row.getLong("calentryid");
            Long costrecordentryid = row.getLong("costrecordentryid");
            BigDecimal baseqty = row.getBigDecimal("baseqty");
            String key = costaccountid + "#" + period;
            Set<Long> needCalentryids = costaccountPeriod2CalentryIdMap.get(key);
            if (needCalentryids == null || !needCalentryids.contains(calentryid)) continue;
            Set calentryids = needCAP2CalEIdMap.computeIfAbsent(key, k -> new HashSet(4));
            calentryids.add(calentryid);
            costRecordIds.add(l);
            allCostAccountIds.add(costaccountid);
            crEntryid2BaseqtyMap.put(costrecordentryid, baseqty);
            caCalEid2CREIdMap.put(costaccountid + "#" + calentryid, costrecordentryid);
        }
        log.info("\u8fd4\u5de5\u9700\u8981\u83b7\u53d6\u6210\u7ec4\u6210\u672cneedCAP2CalEIdMap\uff1a" + needCAP2CalEIdMap);
        if (needCAP2CalEIdMap.isEmpty()) {
            return filterStr;
        }
        HashMap<String, BigDecimal> allGroupCost = new HashMap<String, BigDecimal>(4);
        for (Map.Entry entry : needCAP2CalEIdMap.entrySet()) {
            String[] costaccountPeriod = ((String)entry.getKey()).split("#");
            Set calentryids = (Set)entry.getValue();
            Map<String, BigDecimal> groupCost = GroupRelationCostCalculator.calculateCost(Long.valueOf(costaccountPeriod[0]), Long.parseLong(costaccountPeriod[1]), calentryids);
            allGroupCost.putAll(groupCost);
        }
        QFilter filter = new QFilter("id", "in", allCostAccountIds);
        filter.and("calpolicy.calbycostelement", "=", (Object)true);
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)GroupCostUpdate4CostPrice.class.getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray(), null);
        HashSet<Long> calByCostElementCostAccountIds = new HashSet<Long>(4);
        for (Row row : dataSet2) {
            calByCostElementCostAccountIds.add(row.getLong("id"));
        }
        ArrayList<Object[]> costRecordDetailUpdateParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> costRecordEntryUpdateParams = new ArrayList<Object[]>(16);
        HashSet<Long> needCalCostRecordAmtEntryIds = new HashSet<Long>(16);
        HashSet<Long> allCostRecordEntryIds = new HashSet<Long>(16);
        HashMap<Long, BigDecimal[]> costRecordEntryCostMap = new HashMap<Long, BigDecimal[]>(16);
        for (Map.Entry entry : allGroupCost.entrySet()) {
            String[] keys = ((String)entry.getKey()).split("\\|");
            BigDecimal cost = (BigDecimal)entry.getValue();
            Long costAccountid = Long.valueOf(keys[0]);
            Long calentryid = Long.valueOf(keys[1]);
            Long costRecordEntryid = (Long)caCalEid2CREIdMap.get(costAccountid + "#" + calentryid);
            if (costRecordEntryid == null) continue;
            allCostRecordEntryIds.add(costRecordEntryid);
            BigDecimal baseqty = (BigDecimal)crEntryid2BaseqtyMap.get(costRecordEntryid);
            if (calByCostElementCostAccountIds.contains(costAccountid)) {
                Long costSubElementId = Long.valueOf(keys[2]);
                BigDecimal unitcost = cost.divide(baseqty, RoundingMode.HALF_UP);
                costRecordDetailUpdateParams.add(new Object[]{cost, unitcost, costRecordEntryid, costSubElementId});
                needCalCostRecordAmtEntryIds.add(costRecordEntryid);
                continue;
            }
            BigDecimal[] params = (BigDecimal[])costRecordEntryCostMap.get(costRecordEntryid);
            if (params == null) {
                params = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
                costRecordEntryCostMap.put(costRecordEntryid, params);
            }
            int i = GroupCostUpdate4CostPrice.getCostFieldIndex(keys[2]);
            params[i] = cost;
        }
        for (Map.Entry entry : costRecordEntryCostMap.entrySet()) {
            Long costrecordentryid = (Long)entry.getKey();
            BigDecimal baseqty = (BigDecimal)crEntryid2BaseqtyMap.get(costrecordentryid);
            BigDecimal[] costs = (BigDecimal[])entry.getValue();
            BigDecimal materialCost = costs[0];
            BigDecimal unitMaterialCost = materialCost.divide(baseqty, 10, RoundingMode.HALF_UP);
            BigDecimal fee = costs[1];
            BigDecimal unitFee = fee.divide(baseqty, 10, RoundingMode.HALF_UP);
            BigDecimal processCost = costs[2];
            BigDecimal unitProcessCost = processCost.divide(baseqty, 10, RoundingMode.HALF_UP);
            BigDecimal manufactureCost = costs[3];
            BigDecimal unitManufactureCost = manufactureCost.divide(baseqty, 10, RoundingMode.HALF_UP);
            BigDecimal resource = costs[4];
            BigDecimal unitResource = resource.divide(baseqty, 10, RoundingMode.HALF_UP);
            BigDecimal actualCost = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource);
            BigDecimal unitActualCost = actualCost.divide(baseqty, 10, RoundingMode.HALF_UP);
            costRecordDetailUpdateParams.add(new Object[]{actualCost, unitActualCost, costrecordentryid, 773175233367685120L});
            costRecordEntryUpdateParams.add(new Object[]{unitActualCost, actualCost, unitMaterialCost, materialCost, unitFee, fee, unitProcessCost, processCost, unitManufactureCost, manufactureCost, unitResource, resource, CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue(), CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated(), costrecordentryid});
        }
        log.info("\u8fd4\u5de5\u83b7\u53d6\u6210\u7ec4\u6210\u672ccostRecordIds\uff1a" + costRecordIds);
        try (TXHandle tx = TX.required();){
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cal_calcostrecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, costRecordIds)});){
                if (!costRecordDetailUpdateParams.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)COSTRECORD_DETAIL_UPDATESQL, costRecordDetailUpdateParams);
                }
                if (!costRecordEntryUpdateParams.isEmpty()) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)COSTRECORD_ENTRY_UPDATESQL, costRecordEntryUpdateParams);
                }
                if (!needCalCostRecordAmtEntryIds.isEmpty()) {
                    CostElementHelper.calCostRecordAllCost((Long[])needCalCostRecordAmtEntryIds.toArray(new Long[0]));
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("update t_cal_calcostrecordentry set fiscalculated = '1', fcostpricesource =", new Object[0]);
                    sqlBuilder.append("'" + CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue() + "'", new Object[0]);
                    sqlBuilder.append(",fdesignatedcost =", new Object[0]);
                    sqlBuilder.append(CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getDesignated(), new Object[0]);
                    sqlBuilder.append(" where ", new Object[0]);
                    Object[] inValues = needCalCostRecordAmtEntryIds.toArray(new Long[0]);
                    sqlBuilder.appendIn("fentryid", inValues);
                    DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)sqlBuilder);
                }
            }
            catch (Throwable throwable) {
                tx.markRollback();
                throw throwable;
            }
        }
        log.info("\u8fd4\u5de5\u83b7\u53d6\u6210\u7ec4\u6210\u672c\u8c03\u7528\u4f59\u989d\u66f4\u65b0allCostRecordEntryIds\uff1a" + allCostRecordEntryIds);
        if (CalBalanceModelHelper.isNewBalance()) {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(costRecordIds, BalanceSourceEnum.COST_UPDATE_REWORK);
        } else {
            new BalanceCalculator().updateBalance4Others(allCostRecordEntryIds.toArray(), BalanceSourceEnum.COST_UPDATE_REWORK, costRecordIds);
        }
        if (allCostRecordEntryIds.isEmpty()) {
            log.info("\u8fd4\u5de5\u672a\u83b7\u53d6\u6210\u7ec4\u6210\u672c");
            return filterStr;
        }
        log.info("\u8fd4\u5de5\u83b7\u53d6\u6210\u7ec4\u6210\u672c\uff1a" + allCostRecordEntryIds);
        return new QFilter("entryid", "not in", allCostRecordEntryIds).toString();
    }

    private static int getCostFieldIndex(String key) {
        switch (key) {
            case "materialcost": {
                return 0;
            }
            case "fee": {
                return 1;
            }
            case "processcost": {
                return 2;
            }
            case "manufacturecost": {
                return 3;
            }
            case "resource": {
                return 4;
            }
        }
        return 0;
    }

    private static DataSet getCostRecordDS(DataSet copy) {
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        boolean isNewGroup = true;
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashSet<Long> calentryIds = new HashSet<Long>(16);
        for (Row row : copy) {
            Long bizBillId = row.getLong("bizbillid");
            Long costAccountid = row.getLong("costaccount");
            Long calentryid = row.getLong("calentryid");
            if (bizBillId.compareTo(0L) == 0) {
                isNewGroup = false;
            } else {
                bizBillIds.add(bizBillId);
            }
            costAccountIds.add(costAccountid);
            calentryIds.add(calentryid);
            if (calentryIds.size() <= 2000) continue;
            QFilter filter = new QFilter("costaccount", "in", costAccountIds);
            filter.and("entry.calentryid", "in", calentryIds);
            if (isNewGroup) {
                filter.and("bizbillid", "in", bizBillIds);
            }
            OrmInput input = new OrmInput(GroupCostUpdate4CostPrice.class.getName(), "cal_costrecord", "id as costrecordid,isvoucher,entry.id as entryid,entry.isrework as isrework,entry.iscalculated as iscalculated,entry.baseqty as baseqty", filter.toArray());
            inputs.add(input);
            isNewGroup = true;
            bizBillIds = new HashSet(16);
            costAccountIds = new HashSet(16);
            calentryIds = new HashSet(16);
        }
        if (calentryIds.size() > 0) {
            QFilter filter = new QFilter("costaccount", "in", costAccountIds);
            filter.and("entry.calentryid", "in", calentryIds);
            if (isNewGroup) {
                filter.and("bizbillid", "in", bizBillIds);
            }
            OrmInput input = new OrmInput(GroupCostUpdate4CostPrice.class.getName(), "cal_costrecord", "id as costrecordid,isvoucher,entry.id as entryid,entry.isrework as isrework,entry.iscalculated as iscalculated,entry.baseqty as baseqty", filter.toArray());
            inputs.add(input);
        }
        if (inputs.size() > 0) {
            DataSet costrecordDS = Algo.create((String)GroupCostUpdate4CostPrice.class.getName()).createDataSet(inputs.toArray(new Input[0]));
            return costrecordDS;
        }
        return null;
    }

    private static DataSet getGroupDataSet(Map<String, Set<Long>> entity2BizbillidMap, Map<String, Set<Long>> costaccountPeriod2CalentryIdMap) {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            DataSet dataSet = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(entity2BizbillidMap);
            dataSet = dataSet.select("groupid,bizbillid,type,costrecordentryid,costaccount,period,calentryid");
            return dataSet;
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        for (Map.Entry<String, Set<Long>> entry : costaccountPeriod2CalentryIdMap.entrySet()) {
            String[] costaccountPeriod = entry.getKey().split("#");
            Set<Long> calentryids = entry.getValue();
            QFilter filter = new QFilter("entryentity.costaccount", "=", (Object)Long.valueOf(costaccountPeriod[0]));
            filter.and("entryentity.period", "=", (Object)Long.valueOf((String)costaccountPeriod[1]));
            filter.and("entryentity.calentryid", "in", calentryids);
            OrmInput input = new OrmInput(GroupCostUpdate4CostPrice.class.getName(), "cal_account_grouprecord", "id", filter.toArray());
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            return null;
        }
        DataSet dataSet = Algo.create((String)GroupCostUpdate4CostPrice.class.getName()).createDataSet(inputs.toArray(new Input[0]));
        HashSet<Long> groupIds = new HashSet<Long>(16);
        for (Row row : dataSet) {
            groupIds.add(row.getLong("id"));
        }
        ArrayList inputList = new ArrayList(4);
        RowMeta rowMeta = ORM.create().createRowMeta("cal_account_grouprecord", "TO_CHAR(id) as groupid,entryentity.bizbillid as bizbillid,entryentity.type as type,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period,entryentity.calentryid as calentryid");
        rowMeta.getField("groupid").setDataType((DataType)DataType.StringType);
        Lists.partition(Arrays.asList(groupIds.toArray(new Long[0])), (int)1000).forEach(list -> {
            QFilter filter = new QFilter("id", "in", list);
            OrmInput input = new OrmInput(GroupCostUpdate4CostPrice.class.getName(), "cal_account_grouprecord", "TO_CHAR(id) as groupid,entryentity.bizbillid as bizbillid,entryentity.type as type,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period,entryentity.calentryid as calentryid", filter.toArray(), rowMeta);
            inputList.add(input);
        });
        if (inputList.isEmpty()) {
            return null;
        }
        DataSet accGroupIdDS = Algo.create((String)GroupCostUpdate4CostPrice.class.getName()).createDataSet(inputList.toArray(new Input[0]));
        return accGroupIdDS;
    }
}

