/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class GroupCostUpdate4CostPriceFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = -5578387378793620970L;
    public static final String SRC_TYPE = "0";
    private Set<Long> costAccountIds;

    public GroupCostUpdate4CostPriceFunction(Set<Long> costAccountIds) {
        this.costAccountIds = costAccountIds;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        boolean allSrcIsCalculated = true;
        boolean containsCostAccount = false;
        ArrayList<Object[]> res = new ArrayList<Object[]>(4);
        while (iterator.hasNext()) {
            Row row = iterator.next();
            String type = row.getString("type");
            boolean bl = containsCostAccount = containsCostAccount || this.costAccountIds.contains(row.getLong("costaccount"));
            if (SRC_TYPE.equals(type)) {
                boolean iscalculated = row.getBoolean("iscalculated");
                allSrcIsCalculated = allSrcIsCalculated && iscalculated;
                continue;
            }
            boolean isrework = row.getBoolean("isrework");
            boolean isvoucher = row.getBoolean("isvoucher");
            if (!isrework || isvoucher) continue;
            res.add(new Object[]{row.getLong("costrecordid"), row.getLong("costaccount"), row.getLong("period"), row.getLong("calentryid"), row.getLong("costrecordentryid"), row.getBigDecimal("baseqty")});
        }
        if (allSrcIsCalculated && containsCostAccount) {
            for (Object[] re : res) {
                collector.collect(re);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("costrecordid", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType), new Field("calentryid", (DataType)DataType.LongType), new Field("costrecordentryid", (DataType)DataType.LongType), new Field("baseqty", (DataType)DataType.BigDecimalType)});
    }
}

