/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PriceDimensionHelper {
    private Object costAccountId = null;
    private Map<String, Set<String>> dimMap = new HashMap<String, Set<String>>();
    private static final String DEFAULT_KEY = "0";
    private Set<Object> calRangeIDs = new HashSet<Object>();
    private String[] dividebasis = null;
    private Map<Object, Map<String, Object>> calRangeValueMap = new HashMap<Object, Map<String, Object>>();
    private Map<Object, Map<String, String>> calDimensionValueMap = new HashMap<Object, Map<String, String>>();

    public PriceDimensionHelper(Object costaccountid) {
        this.costAccountId = costaccountid;
        QFilter q = new QFilter("id", "=", this.costAccountId);
        this.dividebasis = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,dividebasis.dividebasis", (QFilter[])q.toArray()).getString("dividebasis.dividebasis").split(",");
        this.createCalRangeValueMap();
        this.createCalDimensionMap();
        this.createDimMap();
    }

    public Map<String, Set<String>> getCalDimMap() {
        return this.dimMap;
    }

    private void createDimMap() {
        Map<String, Object> calRangeMap;
        HashSet<String> baseset = new HashSet<String>();
        baseset.add("material");
        for (String string : this.dividebasis) {
            if ("".equals(string)) continue;
            baseset.add(string);
        }
        if (!this.calRangeValueMap.isEmpty() && (calRangeMap = this.calRangeValueMap.get(this.costAccountId)) != null) {
            for (Map.Entry<String, Object> calRangeEntry : calRangeMap.entrySet()) {
                Map<String, String> calDimensionMap = this.calDimensionValueMap.get(calRangeEntry.getValue());
                if (calDimensionMap == null || calDimensionMap.isEmpty()) continue;
                for (Map.Entry<String, String> calDimEntry : calDimensionMap.entrySet()) {
                    String key = calRangeEntry.getKey() + "_" + calDimEntry.getKey();
                    String[] calDim = calDimEntry.getValue().split(",");
                    HashSet<String> set = new HashSet<String>();
                    set.addAll(baseset);
                    for (String string : calDim) {
                        if ("".equals(string)) continue;
                        set.add(string);
                    }
                    this.dimMap.put(key, set);
                }
            }
        }
        this.dimMap.put(String.valueOf(this.costAccountId), baseset);
    }

    private void createCalRangeValueMap() {
        DynamicObject[] calRanges;
        QFilter calRangeQFilter = new QFilter("costaccount.id", "=", this.costAccountId);
        calRangeQFilter.and("status", "=", (Object)"C");
        calRangeQFilter.and("enable", "=", (Object)"1");
        for (DynamicObject calrange : calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,costaccount,costaccount.id,accounttype,dividebasis.dividebasis,accounttype,caldimension.caldimension,calorg,owner,storageorgunit,warehouse,location", (QFilter[])calRangeQFilter.toArray())) {
            Object calRangeId = calrange.get("id");
            this.calRangeIDs.add(calRangeId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObjectCollection entry = calrange.getDynamicObjectCollection("entry");
            if (entry.isEmpty()) {
                map.put(DEFAULT_KEY, calRangeId);
            } else {
                for (DynamicObject dynamicObject : entry) {
                    StringBuilder MapKey = new StringBuilder();
                    for (String div : this.dividebasis) {
                        MapKey.append(dynamicObject.getString(div));
                        MapKey.append("_");
                    }
                    String mapKey = MapKey.substring(0, MapKey.length() - 1);
                    map.put(mapKey, calRangeId);
                }
            }
            this.calRangeValueMap.put(this.costAccountId, map);
            DynamicObject calDimension = calrange.getDynamicObject("caldimension");
            if (calDimension != null) {
                String dimension = calDimension.getString("caldimension");
                HashMap<String, String> dimensionMap = new HashMap<String, String>();
                dimensionMap.put(DEFAULT_KEY, dimension);
                this.calDimensionValueMap.put(calRangeId, dimensionMap);
            }
            String string = calrange.getString("accounttype");
        }
    }

    private void createCalDimensionMap() {
        DynamicObject[] calDimensions;
        QFilter calDimQFilter = new QFilter("calrange.id", "in", this.calRangeIDs);
        calDimQFilter.and("status", "=", (Object)"C");
        calDimQFilter.and("enable", "=", (Object)"1");
        for (DynamicObject calDimension : calDimensions = BusinessDataServiceHelper.load((String)"cal_bd_materialdimension", (String)"id,calrange.id,material.number,materialgroup.number,caldimension.caldimension", (QFilter[])calDimQFilter.toArray())) {
            String defaultDimension;
            Object calRangeID = calDimension.getDynamicObject("calrange").get("id");
            DynamicObjectCollection entry = calDimension.getDynamicObjectCollection("entry");
            HashMap<String, String> map = new HashMap<String, String>();
            for (DynamicObject dynamicObject : entry) {
                DynamicObject material = dynamicObject.getDynamicObject("material");
                DynamicObject materialGroup = dynamicObject.getDynamicObject("materialgroup");
                String calDim = dynamicObject.getDynamicObject("caldimension").getString("caldimension");
                if (material != null) {
                    String materialNum = material.getString("number");
                    map.put(materialNum, calDim);
                    continue;
                }
                if (materialGroup == null) continue;
                String materialGroupNum = materialGroup.getString("number");
                map.put(materialGroupNum, calDim);
            }
            Map<String, String> oldMap = this.calDimensionValueMap.remove(calRangeID);
            if (oldMap != null && (defaultDimension = oldMap.get(DEFAULT_KEY)) != null) {
                map.put(DEFAULT_KEY, defaultDimension);
            }
            this.calDimensionValueMap.put(calRangeID, map);
        }
    }
}

